-- Magento DB backup
--
-- Host: localhost    Database: admagchs
-- ------------------------------------------------------
-- Server version: 5.6.39-cll-lve

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `admin_passwords`
--

DROP TABLE IF EXISTS `admin_passwords`;
CREATE TABLE `admin_passwords` (
  `password_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Password Id',
  `user_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'User Id',
  `password_hash` varchar(100) DEFAULT NULL COMMENT 'Password Hash',
  `expires` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Deprecated',
  `last_updated` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Last Updated',
  PRIMARY KEY (`password_id`),
  KEY `ADMIN_PASSWORDS_USER_ID` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COMMENT='Admin Passwords';

--
-- Dumping data for table `admin_passwords`
--

LOCK TABLES `admin_passwords` WRITE;
/*!40000 ALTER TABLE `admin_passwords` DISABLE KEYS */;
INSERT INTO `admin_passwords` VALUES ('1','1','87f331530dd36cac6383a991bd5ca5547102a1677fbf8ef41a0caa869c513085:uB3GjjYuJMBZG1Hmx8J0hsRUsdCr5j10:1','0','1512974127'),('2','1','f6de5644e6b32bed807ac7ece25a71d18004822f13af2381c3578b2a85d5472a:SL04LSMxa7NcHIduLS8xtrZh3IncRsGr:1','0','1532096266'),('3','2','ebda5ade8661a712994c49fa315ce51eca882d5574e8a5aa18c996fa093ed51d:nceODU8VRDIB3oGORCUviD1FmCdd3D0q:1','0','1535657406'),('4','3','b5a374e102bdd8c85abb48edf8fa4d053cd0415c7991a285bd93e4684e4dcfa2:6wYZb113IVBPQwOVvrKQE0dQfW2jYOJ0:1','0','1536588649'),('5','4','f063239b199d25dbceba5ca239eb96af69e27a55c9956bb280aee1dc4cc65b3e:NroyBtQDP0cBtydLiihj84Hj4gBGBXLk:1','0','1539359223');
/*!40000 ALTER TABLE `admin_passwords` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `admin_system_messages`
--

DROP TABLE IF EXISTS `admin_system_messages`;
CREATE TABLE `admin_system_messages` (
  `identity` varchar(100) NOT NULL COMMENT 'Message id',
  `severity` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Problem type',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Create date',
  PRIMARY KEY (`identity`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Admin System Messages';

--
-- Table structure for table `admin_user`
--

DROP TABLE IF EXISTS `admin_user`;
CREATE TABLE `admin_user` (
  `user_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'User ID',
  `firstname` varchar(32) DEFAULT NULL COMMENT 'User First Name',
  `lastname` varchar(32) DEFAULT NULL COMMENT 'User Last Name',
  `email` varchar(128) DEFAULT NULL COMMENT 'User Email',
  `username` varchar(40) DEFAULT NULL COMMENT 'User Login',
  `password` varchar(255) NOT NULL COMMENT 'User Password',
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'User Created Time',
  `modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'User Modified Time',
  `logdate` timestamp NULL DEFAULT NULL COMMENT 'User Last Login Time',
  `lognum` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'User Login Number',
  `reload_acl_flag` smallint(6) NOT NULL DEFAULT '0' COMMENT 'Reload ACL',
  `is_active` smallint(6) NOT NULL DEFAULT '1' COMMENT 'User Is Active',
  `extra` text COMMENT 'User Extra Data',
  `rp_token` text COMMENT 'Reset Password Link Token',
  `rp_token_created_at` timestamp NULL DEFAULT NULL COMMENT 'Reset Password Link Token Creation Date',
  `interface_locale` varchar(16) NOT NULL DEFAULT 'en_US' COMMENT 'Backend interface locale',
  `failures_num` smallint(6) DEFAULT '0' COMMENT 'Failure Number',
  `first_failure` timestamp NULL DEFAULT NULL COMMENT 'First Failure',
  `lock_expires` timestamp NULL DEFAULT NULL COMMENT 'Expiration Lock Dates',
  PRIMARY KEY (`user_id`),
  UNIQUE KEY `ADMIN_USER_USERNAME` (`username`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COMMENT='Admin User Table';

--
-- Dumping data for table `admin_user`
--

LOCK TABLES `admin_user` WRITE;
/*!40000 ALTER TABLE `admin_user` DISABLE KEYS */;
INSERT INTO `admin_user` VALUES ('1','admin','admin','admin@gmail.com','admin','f6de5644e6b32bed807ac7ece25a71d18004822f13af2381c3578b2a85d5472a:SL04LSMxa7NcHIduLS8xtrZh3IncRsGr:1','2017-12-11 09:35:27','2018-10-17 13:23:50','2018-10-17 13:23:50',146,0,1,'{\"configState\":{\"web_url\":\"1\",\"web_seo\":\"0\",\"web_unsecure\":\"0\",\"web_secure\":\"0\",\"web_default\":\"0\",\"web_cookie\":\"0\",\"web_session\":\"0\",\"web_browser_capabilities\":\"0\",\"currency_options\":\"1\",\"currency_yahoofinance\":\"0\",\"currency_fixerio\":\"0\",\"currency_webservicex\":\"0\",\"currency_import\":\"0\",\"tax_display\":\"1\",\"tax_cart_display\":\"0\",\"tax_defaults\":\"1\",\"tax_calculation\":\"0\",\"tax_classes\":\"1\",\"tax_sales_display\":\"0\",\"tax_weee\":\"0\",\"categorytop_new_status\":\"1\",\"pricecountdown_countdown_slider\":\"1\",\"pricecountdown_general\":\"0\",\"pricecountdown_in_product_list\":\"0\",\"pricecountdown_in_product_view\":\"0\",\"producttab_new_status\":\"1\",\"randomproductslider_general\":\"1\",\"brandslider_general\":\"1\",\"instagramgallery_general\":\"1\",\"catalog_frontend\":\"1\",\"catalog_fields_masks\":\"0\",\"catalog_review\":\"0\",\"catalog_productalert\":\"0\",\"catalog_productalert_cron\":\"0\",\"catalog_placeholder\":\"0\",\"catalog_recently_products\":\"0\",\"catalog_product_video\":\"0\",\"catalog_price\":\"0\",\"catalog_layered_navigation\":\"0\",\"catalog_seo\":\"0\",\"catalog_navigation\":\"0\",\"catalog_search\":\"0\",\"catalog_downloadable\":\"0\",\"catalog_custom_options\":\"0\",\"recentproductslider_general\":\"1\",\"newproductslider_new_status\":\"1\",\"bestsellerproduct_new_status\":\"1\",\"mfblog_general\":\"0\",\"mfblog_index_page\":\"0\",\"mfblog_post_view\":\"0\",\"mfblog_post_list\":\"0\",\"mfblog_sidebar\":\"0\",\"mfblog_rss_feed\":\"0\",\"mostviewed_general\":\"1\",\"quickview_general\":\"1\",\"newsletterpopup_popup_group\":\"1\",\"plazathemes_design_header\":\"1\",\"plazathemes_design_footer_top\":\"1\",\"plazathemes_design_footer_bottom\":\"1\",\"general_country\":\"0\",\"general_locale\":\"1\",\"general_store_information\":\"1\",\"plazathemes_design_general\":\"1\",\"admin_security\":\"1\",\"admin_emails\":\"0\",\"admin_startup\":\"0\",\"admin_url\":\"0\",\"admin_dashboard\":\"1\",\"admin_captcha\":\"0\",\"plazathemes_design_footer\":\"1\",\"trans_email_ident_support\":\"1\",\"trans_email_ident_sales\":\"1\",\"trans_email_ident_general\":\"1\",\"general_single_store_mode\":\"0\",\"general_region\":\"0\",\"trans_email_ident_custom1\":\"1\",\"trans_email_ident_custom2\":\"1\",\"smtp_general\":\"1\",\"smtp_configuration_option\":\"1\",\"smtp_developer\":\"0\",\"smtp_module\":\"1\",\"contact_email\":\"1\",\"contact_contact\":\"0\",\"dev_js\":\"1\",\"dev_css\":\"1\",\"dev_front_end_development_workflow\":\"0\",\"dev_restrict\":\"1\",\"dev_template\":\"0\",\"dev_debug\":\"1\",\"dev_translate_inline\":\"0\",\"dev_image\":\"0\",\"dev_static\":\"0\",\"dev_grid\":\"0\",\"system_full_page_cache\":\"1\",\"system_smtp\":\"0\",\"system_cron\":\"0\",\"system_adminnotification\":\"0\",\"system_currency\":\"0\",\"system_backup\":\"0\",\"cataloginventory_item_options\":\"1\",\"cataloginventory_options\":\"1\",\"categorytab_new_status\":\"1\"}}',NULL,NULL,'nl_NL',0,NULL,NULL),('2','CHS','Suriname','info@chs.sr','chssr','ebda5ade8661a712994c49fa315ce51eca882d5574e8a5aa18c996fa093ed51d:nceODU8VRDIB3oGORCUviD1FmCdd3D0q:1','2018-08-30 19:30:06','2018-08-30 19:30:43','2018-08-30 19:30:43',1,0,1,'null',NULL,NULL,'en_US',0,NULL,NULL),('3','Shayne','Man A Hing','smah@computronics.sr','shayne','b5a374e102bdd8c85abb48edf8fa4d053cd0415c7991a285bd93e4684e4dcfa2:6wYZb113IVBPQwOVvrKQE0dQfW2jYOJ0:1','2018-09-10 14:10:49','2018-10-15 16:44:11','2018-10-15 16:44:11',28,0,1,'{\"configState\":{\"plazathemes_design_general\":\"0\",\"cataloginventory_options\":\"0\"}}',NULL,NULL,'en_US',0,NULL,NULL),('4','CHS','CHS','vanessa.ronokarijo@chs.sr','chs-administrator','f063239b199d25dbceba5ca239eb96af69e27a55c9956bb280aee1dc4cc65b3e:NroyBtQDP0cBtydLiihj84Hj4gBGBXLk:1','2018-10-12 15:47:03','2018-10-12 15:57:29','2018-10-12 15:57:29',3,0,1,'null',NULL,NULL,'en_US',0,NULL,NULL);
/*!40000 ALTER TABLE `admin_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `admin_user_session`
--

DROP TABLE IF EXISTS `admin_user_session`;
CREATE TABLE `admin_user_session` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `session_id` varchar(128) NOT NULL COMMENT 'Session id value',
  `user_id` int(10) unsigned DEFAULT NULL COMMENT 'Admin User ID',
  `status` smallint(5) unsigned NOT NULL DEFAULT '1' COMMENT 'Current Session status',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Created Time',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Update Time',
  `ip` varchar(15) NOT NULL COMMENT 'Remote user IP',
  PRIMARY KEY (`id`),
  KEY `ADMIN_USER_SESSION_SESSION_ID` (`session_id`),
  KEY `ADMIN_USER_SESSION_USER_ID` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=183 DEFAULT CHARSET=utf8 COMMENT='Admin User sessions table';

--
-- Dumping data for table `admin_user_session`
--

LOCK TABLES `admin_user_session` WRITE;
/*!40000 ALTER TABLE `admin_user_session` DISABLE KEYS */;
INSERT INTO `admin_user_session` VALUES ('1','5d0bj8ra4a8fmj70nh51v7l6a1','1',2,'2017-12-11 10:13:43','2018-08-03 12:16:41','::1'),('2','738ljp3i3tstpnigseannbb2h3','1',2,'2017-12-12 06:14:21','2018-08-03 12:16:41','::1'),('3','b09sre8ec21fr0fgqlh5avvkn6','1',2,'2017-12-12 06:49:15','2018-08-03 12:16:41','::1'),('4','v4oh6bovana2hs02r2va6ebcf4','1',2,'2017-12-12 09:22:45','2018-08-03 12:16:41','::1'),('5','c7iavvch31gmkhu71192jv8b62','1',2,'2017-12-13 11:37:11','2018-08-03 12:16:41','::1'),('6','evdm354v6bp0b094cekgpbt7e0','1',2,'2017-12-14 05:23:06','2017-12-14 05:27:02','::1'),('7','sks9uipm9t64sjru13djqoru43','1',2,'2017-12-14 05:27:02','2018-08-03 12:16:41','::1'),('8','9vo467256ij0qbe41igefsevo1','1',2,'2017-12-14 07:07:21','2018-08-03 12:16:41','::1'),('9','upcdd46ushj7olv10ahcpg2jl4','1',2,'2017-12-14 09:23:16','2018-08-03 12:16:41','::1'),('10','atoaq1in9a8upgucd24nk1h2e5','1',2,'2017-12-14 10:24:32','2018-08-03 12:16:41','::1'),('11','ggh20b3n9n1uncpddgurj73se3','1',2,'2017-12-14 12:06:13','2018-08-03 12:16:41','::1'),('12','1s13vuv4do495piqfv816ca8j2','1',2,'2017-12-15 04:43:25','2018-08-03 12:16:41','::1'),('13','qd1didms8hfak4duhf96999ch3','1',2,'2017-12-15 05:21:07','2018-08-03 12:16:41','::1'),('14','vnb8mmc6ppk9c6a0dnaf4h0m42','1',2,'2017-12-15 07:00:08','2018-08-03 12:16:41','::1'),('15','24u54cjoq9r30ev9bkviqa5tr6','1',2,'2017-12-15 09:19:38','2018-08-03 12:16:41','::1'),('16','1l07g2oi3mu5mob1443vdcpsu0','1',2,'2017-12-16 04:46:56','2018-08-03 12:16:41','::1'),('17','b95pq3dpf791rnergqj8jo8t67','1',2,'2017-12-16 06:16:19','2018-08-03 12:16:41','::1'),('18','d1pj7rhsc6rbid2dpbo3kge385','1',2,'2017-12-16 07:43:15','2018-08-03 12:16:41','::1'),('19','r024j4po2ujssu06vfrij8acd5','1',2,'2017-12-18 05:20:43','2018-08-03 12:16:41','::1'),('20','a4oirpva7r7k62e756pd16gvd2','1',2,'2017-12-18 09:35:18','2018-08-03 12:16:41','::1'),('21','v0e4mvmhr5n4v0f6u26dvarn22','1',2,'2017-12-18 11:55:13','2018-08-03 12:16:41','::1'),('22','qlouuq8fg50jco8j0duh681vb5','1',2,'2017-12-19 06:26:23','2018-08-03 12:16:41','::1'),('23','2s9mk8sfgfk0lpst4q23udm8j2','1',2,'2017-12-19 10:31:55','2018-08-03 12:16:41','::1'),('24','lrsj2qihr5ahoftqhdgsafe3k6','1',2,'2017-12-20 04:53:46','2018-08-03 12:16:41','::1'),('25','ua7ceq8j8orf6msrk7enomcji1','1',2,'2017-12-20 09:24:43','2018-08-03 12:16:41','::1'),('26','gkqq8q0fmmdcgg1n92l86ohhj3','1',2,'2017-12-21 04:52:10','2018-08-03 12:16:41','::1'),('27','rv2s4j0jgbpc621bn3ishg86n5','1',2,'2017-12-21 05:55:39','2018-08-03 12:16:41','::1'),('28','g2cppm10j0tmi3gp0qthqnjk12','1',2,'2017-12-21 06:56:44','2018-08-03 12:16:41','::1'),('29','4nhbpd7k5r1ihj9kclrh7cedp2','1',2,'2017-12-21 07:22:18','2018-08-03 12:16:41','::1'),('30','vnkb1r1f5chj8uklsoac9c5l21','1',2,'2017-12-21 09:25:41','2018-08-03 12:16:41','::1'),('31','2dm36ib12964tkltcg876g2so6','1',2,'2017-12-21 10:00:09','2018-08-03 12:16:41','::1'),('32','pl5m3gvgc2jnd3t621vdqrk112','1',2,'2017-12-21 12:44:01','2018-08-03 12:16:41','::1'),('33','7q35mctu20p5buittf9m9h3vo4','1',2,'2017-12-22 04:37:07','2018-08-03 12:16:41','::1'),('34','7p86fibau2aafuom2r857fl686','1',2,'2017-12-22 06:21:25','2018-08-03 12:16:41','::1'),('35','fijips6pg7tj8f8m231dh26fu7','1',2,'2017-12-22 09:28:27','2018-08-03 12:16:41','::1'),('36','of6qga63hnqjc805t93mlcvk00','1',2,'2017-12-23 04:45:51','2018-08-03 12:16:41','::1'),('37','ahmlkd959pqomq73fdmhul0a02','1',2,'2017-12-23 06:50:43','2018-08-03 12:16:41','::1'),('38','5ql36kvp9ke86t4kb07dtct957','1',2,'2017-12-25 04:52:15','2018-08-03 12:16:41','::1'),('39','8tauvhosj441g0dslklhcaujl6','1',2,'2017-12-25 09:34:09','2018-08-03 12:16:41','::1'),('40','clii7ek0c3l8s2q4sbk44f0495','1',2,'2017-12-25 13:03:12','2018-08-03 12:16:41','::1'),('41','8cunu7ascavh7uua3sk7265ng2','1',2,'2017-12-26 04:44:44','2018-08-03 12:16:41','::1'),('42','g4hmtmbj735olrhlg0a4ott701','1',2,'2017-12-26 05:10:55','2018-08-03 12:16:41','::1'),('43','jl5nb15172p10pmsrhgjjqt953','1',2,'2017-12-26 05:34:53','2018-08-03 12:16:41','::1'),('44','i6pm1ie34kcskai3r7m362sk34','1',2,'2017-12-26 09:18:21','2018-08-03 12:16:41','::1'),('45','stdq178r5cg5226bcm5qooch36','1',2,'2017-12-26 09:53:18','2017-12-26 09:53:51','::1'),('46','5hagh5grk9shsl3o93a6t2bg95','1',0,'2017-12-26 09:53:51','2017-12-26 11:40:23','192.168.1.99'),('47','6em3v457sa4201s1itlnc043t4','1',2,'2017-12-26 11:41:14','2018-08-03 12:16:41','192.168.1.99'),('48','b8ogaae1mu6k5948q6ai9gjqo5','1',2,'2017-12-28 04:53:24','2018-08-03 12:16:41','192.168.1.99'),('49','ooqfjmoe6erviideqot5kh1g77','1',2,'2017-12-28 07:05:06','2018-08-03 12:16:41','192.168.1.99'),('50','pfkk9s26fr5jpi62mmltb5sm10','1',0,'2017-12-28 09:18:30','2017-12-28 09:35:00','192.168.1.99'),('51','v7djg49s2ca714gr7gv91m1e90','1',2,'2017-12-28 09:35:07','2018-08-03 12:16:41','192.168.1.99'),('52','5og75cbnc5q4bvkm3fq9nomet3','1',2,'2017-12-28 10:05:56','2018-08-03 12:16:41','192.168.1.99'),('53','3sc2ja1i4amvcp5i1cvea5ubt2','1',2,'2017-12-28 12:27:49','2018-08-03 12:16:41','192.168.1.99'),('54','4jghh1iedfcm6pdd147m352i60','1',2,'2017-12-29 04:42:20','2018-08-03 12:16:41','192.168.1.99'),('55','59g8kstn2hv1dj8ka1mjat6814','1',2,'2017-12-29 09:19:33','2018-08-03 12:16:41','192.168.1.99'),('56','',NULL,0,'2017-12-29 12:54:49','2017-12-29 12:54:49',''),('57','rdbuio3hgleeskbg2q0uev0ld2','1',2,'2017-12-29 12:55:17','2018-08-03 12:16:41','192.168.1.99'),('58','93cq23s9navp64da9nh1o40q75','1',2,'2018-01-03 04:37:37','2018-08-03 12:16:41','192.168.1.99'),('59','2u879vbl6t8bfvr18suuvo4e25','1',2,'2018-01-03 06:57:37','2018-08-03 12:16:41','192.168.1.99'),('60','hgpueotom7t4071h6moeqh1ne3','1',2,'2018-01-03 08:48:33','2018-08-03 12:16:41','192.168.1.99'),('61','hgdb7rgnj39mbsu8oheastgi71','1',2,'2018-01-03 09:26:44','2018-08-03 12:16:41','192.168.1.99'),('62','mttahs73unic0ljus5k373c4k6','1',2,'2018-01-03 11:38:54','2018-08-03 12:16:41','192.168.1.99'),('63','pvcbl972dco8d91b46ua99t7e4','1',2,'2018-01-03 12:03:24','2018-08-03 12:16:41','192.168.1.99'),('64','ckodd8nbhb8vfofdcrv2ssqko6','1',2,'2018-01-04 04:50:05','2018-08-03 12:16:41','192.168.1.99'),('65','42jghr5h32ukj8kij4vjjt85e0','1',0,'2018-01-04 06:14:40','2018-01-04 06:17:41','192.168.1.99'),('66','a9sstd671c6avlpef40tbmu311','1',2,'2018-01-04 06:17:55','2018-08-03 12:16:41','192.168.1.99'),('67','8fidih8id534fjnela5b1o4ro0','1',2,'2018-01-04 08:57:11','2018-08-03 12:16:41','192.168.1.99'),('68','vpiclh0it3ubitk80trgppp1e1','1',2,'2018-01-04 12:26:12','2018-08-03 12:16:41','192.168.1.99'),('69','q54pum3voqs63vpc8dvenu0vo3','1',2,'2018-01-05 04:43:58','2018-08-03 12:16:41','192.168.1.99'),('70','ukbjm9eoedpg51vchapciea791','1',2,'2018-01-05 05:17:55','2018-08-03 12:16:41','192.168.1.99'),('71','rpdfbjvp84e6384mi5u9g8j3a2','1',2,'2018-01-05 08:54:07','2018-08-03 12:16:41','192.168.1.99'),('72','sou2ki2d4pnrkp8vl0qb2f3gc1','1',2,'2018-01-05 11:33:50','2018-08-03 12:16:41','192.168.1.99'),('73','m67d7nmi0sqptq1jfjdijam5g5','1',2,'2018-01-08 04:37:02','2018-08-03 12:16:41','192.168.1.99'),('74','30hko4207b38j2hjbhdnbcmqo2','1',2,'2018-01-08 05:35:54','2018-08-03 12:16:41','192.168.1.99'),('75','gqm1r2bob5dasu3q8kr74a1ju2','1',2,'2018-01-08 06:11:52','2018-08-03 12:16:41','192.168.1.99'),('76','e67r6amjuqnapqq2m0mh5vtpe3','1',2,'2018-01-08 08:03:38','2018-08-03 12:16:41','192.168.1.99'),('77','qlgh7j35l0lp0hs14up4q64s86','1',0,'2018-01-08 08:50:12','2018-01-08 11:43:59','192.168.1.99'),('78','7td3d85g1br24bn45mrnjooma3','1',2,'2018-01-08 11:44:23','2018-08-03 12:16:41','192.168.1.99'),('79','l6ee3aa31grcoiq7vhialih2l0','1',2,'2018-01-08 12:33:56','2018-08-03 12:16:41','192.168.1.99'),('80','8o5na43oo9a7p9mipmo6s8s4o2','1',2,'2018-01-09 05:40:13','2018-08-03 12:16:41','192.168.1.99'),('81','nv4l08sahj1k8g01btcgsouc71','1',2,'2018-01-09 08:56:00','2018-08-03 12:16:41','192.168.1.99'),('82','',NULL,0,'2018-01-09 10:04:30','2018-01-09 10:04:30',''),('83','49p1sb2ph5i2633bt2rjvr9ua0','1',2,'2018-01-09 10:05:52','2018-08-03 12:16:41','192.168.1.99'),('84','peaovtk63e6pge949ker03amj7','1',2,'2018-01-10 04:32:45','2018-08-03 12:16:41','192.168.1.99'),('85','4bboqi50tuf3irfeln9md97ev3','1',2,'2018-01-10 09:55:00','2018-08-03 12:16:41','192.168.1.99'),('86','721ei91cjqseu2prl19mbbh8b6','1',2,'2018-01-10 10:21:45','2018-08-03 12:16:41','192.168.1.99'),('87','qeoqagta5ql6o0rmnbmj99pl95','1',2,'2018-01-10 11:42:35','2018-08-03 12:16:41','192.168.1.99'),('88','r7gb9ukn5ehqeukl6d73r1idj7','1',2,'2018-01-10 12:07:23','2018-08-03 12:16:41','192.168.1.99'),('89','b4ucafg12jl7ajp9fkmivrrp25','1',2,'2018-01-11 09:12:07','2018-08-03 12:16:41','192.168.1.99'),('90','',NULL,0,'2018-01-11 09:45:32','2018-01-11 09:45:32',''),('91','dt09nrtjb74979bn1tgdjcb762','1',2,'2018-01-11 09:46:05','2018-08-03 12:16:41','192.168.1.99'),('92','03impec4kvnbgjat8l5fo2cuf2','1',2,'2018-01-11 10:06:19','2018-08-03 12:16:41','192.168.1.99'),('93','clnfe2bjk2fohq2er6h1fv64i2','1',2,'2018-01-12 09:56:56','2018-08-03 12:16:41','192.168.1.99'),('94','lq1iovjlsod7ea7ishb4j40vt2','1',2,'2018-01-12 11:46:02','2018-08-03 12:16:41','192.168.1.99'),('95','r4gpa98a0g7778dhng49s6vnk4','1',2,'2018-02-01 05:40:49','2018-08-03 12:16:41','192.168.1.99'),('96','odakmuar5cn6vvnjrte3q5smg4','1',2,'2018-02-08 05:54:29','2018-08-03 12:16:41','192.168.1.99'),('97','7jng13cmuc02bj37j8ra3sg7q6','1',2,'2018-02-08 09:01:19','2018-08-03 12:16:41','192.168.1.99'),('98','loac437abfars1rcf9pp02g4e5','1',2,'2018-02-08 09:26:52','2018-08-03 12:16:41','192.168.1.99'),('99','5s55dt2ev072lflcfavda0glf1','1',2,'2018-02-08 10:43:56','2018-08-03 12:16:41','192.168.1.99'),('100','',NULL,0,'2018-02-08 11:47:55','2018-02-08 11:47:55',''),('101','ml4k291q7in2hfds2jdb4tk056','1',2,'2018-02-08 11:48:14','2018-08-03 12:16:41','192.168.1.99'),('102','5ouegsb6kklm47shng9j7rqip1','1',2,'2018-02-21 11:26:41','2018-08-03 12:16:41','::1'),('103','urdhip33qg14s94lkrukb3hjf6','1',2,'2018-02-21 12:52:11','2018-08-03 12:16:41','::1'),('104','',NULL,0,'2018-02-21 14:11:00','2018-02-21 14:11:00',''),('105','ft6lijhs02crgp5rmn3k35q193','1',2,'2018-02-21 14:11:23','2018-08-03 12:16:41','::1'),('106','1vnmtnrour1g4v8g9u6ofqnu54','1',2,'2018-02-22 10:23:52','2018-08-03 12:16:41','::1'),('107','b1fa132272ff1672e44714cbacbdf84c','1',2,'2018-07-20 14:16:18','2018-08-03 12:16:41','::1'),('108','dade4a2c189b9a8cbecde79a94484f3e','1',2,'2018-07-20 15:29:08','2018-08-03 12:16:41','::1'),('109','86c4d7d8eaf140fe26c3655da7f88e6b','1',2,'2018-07-23 11:46:43','2018-08-03 12:16:41','::1'),('110','8699824bf8a11470f4b3c0e1a8290d6e','1',2,'2018-07-23 12:52:10','2018-08-03 12:16:41','::1'),('111','cec5b348a3cb156379eb2a90fa39eb70','1',2,'2018-08-03 12:16:41','2018-08-10 17:09:37','::1'),('112','b68f457288b27f75bb45cc4dcbdb084d','1',2,'2018-08-10 17:09:37','2018-08-30 18:42:55','::1'),('113','c6dcee7aeeb56fd068d068b0425b77d4','1',2,'2018-08-30 18:42:55','2018-08-30 18:42:56','51.38.246.115'),('114','d3d183cbc7df7ebfd725a40cb59b28e0','1',2,'2018-08-30 18:42:56','2018-08-30 18:43:24','190.98.41.4'),('115','8350ec8187e76529d258044f9e064edf','1',2,'2018-08-30 18:43:24','2018-08-30 19:05:50','51.38.246.115'),('116','932cf2bbe4108e15a87286b4daad02fd','1',0,'2018-08-30 19:05:50','2018-08-30 19:06:41','190.98.41.4'),('117','7ef1b7058dde08d29e975edaa3e144ad','1',2,'2018-08-30 19:07:23','2018-08-30 19:12:25','117.247.196.89'),('118','5f7b0f68964af2f213582342471bea22','1',2,'2018-08-30 19:12:25','2018-08-30 19:28:36','51.38.246.115'),('119','06848f304410953ba48f020dfec010e2','1',0,'2018-08-30 19:28:36','2018-08-30 19:30:21','190.98.41.4'),('120','5bd4b2bb08f8717b5289077acc038e7c','2',1,'2018-08-30 19:30:43','2018-08-30 19:31:01','190.98.41.4'),('121','67adb8a7c1945dcb21e38ac1ef2135e2','1',2,'2018-09-06 14:21:19','2018-09-08 12:44:02','14.192.211.107'),('122','eb059e980d21e20cc085654147b0dedd','1',2,'2018-09-08 12:44:02','2018-09-08 13:48:36','14.192.211.19'),('123','73aa20ec4635e0a45ecf5d09f1f5c5bc','1',2,'2018-09-08 13:48:36','2018-09-08 15:20:28','14.192.211.19'),('124','451668265d38d654c846dfff0c10caa8','1',2,'2018-09-08 15:20:28','2018-09-08 16:35:27','14.192.211.19'),('125','d694d68a2eaf1a75e9f217f52a48c9fd','1',2,'2018-09-08 16:35:27','2018-09-08 19:05:19','14.192.211.19'),('126','f04c4c4312a9b8038ed0a9989ad6a589','1',2,'2018-09-08 19:05:19','2018-09-10 11:36:39','14.192.211.19'),('127','4454be987e31ff5841ae40d3fb8149e8','1',2,'2018-09-10 11:36:39','2018-09-10 14:09:25','190.98.41.4'),('128','1ad9379bc53192db8aabdfc970702485','1',2,'2018-09-10 14:09:25','2018-09-17 13:13:11','190.98.41.4'),('129','0227d351cbacb875dc1f2d063cc29f82','3',2,'2018-09-10 14:16:15','2018-09-10 19:18:44','76.110.65.236'),('130','3bb8a2a12d03882aa57da292abed2e6c','3',2,'2018-09-10 19:18:44','2018-09-10 20:18:53','76.110.65.236'),('131','edc12d72f62e9558cbf5295a533fd694','3',2,'2018-09-10 20:18:53','2018-09-14 16:46:06','76.110.65.236'),('132','119c89ce38fc62009dfb5eeaa61c2f1d','3',2,'2018-09-14 16:46:05','2018-09-17 14:32:44','76.110.65.236'),('133','9554b9620936ec2bbae6e24ca42243e7','1',2,'2018-09-17 13:13:11','2018-09-21 13:17:43','190.98.41.4'),('134','6c2b27446ed3f43b6535072584dc795e','3',2,'2018-09-17 14:32:44','2018-09-18 14:22:09','73.139.243.117'),('135','4dafa4e146e379e65477ebec87e88dfc','3',2,'2018-09-18 14:22:09','2018-09-19 13:51:36','73.139.243.117'),('136','860b7a78885df2f23ad70e2d6ba09422','3',2,'2018-09-19 13:51:36','2018-09-19 14:29:36','76.110.65.236'),('137','7a090a85f017adf3dffe7f239c96a253','3',2,'2018-09-19 14:29:36','2018-09-19 18:20:30','76.110.65.236'),('138','6489b2988e62dbe4b87fb778d6ac4d2d','3',2,'2018-09-19 18:20:30','2018-09-19 22:08:08','76.110.65.236'),('139','30377584e64e5a0d5f52f1b4ac6ff849','3',2,'2018-09-19 22:08:08','2018-09-20 12:29:53','76.110.65.236'),('140','d9a49bb55be98a0dca3b439927c8a129','3',2,'2018-09-20 12:29:53','2018-09-20 19:43:03','76.110.65.236'),('141','90165a3e476b53ba60a532a2181f4cfa','3',2,'2018-09-20 19:43:03','2018-09-20 21:29:46','76.110.65.236'),('142','deba3094d2f5e7f37fe7d1907bb3a6a0','3',2,'2018-09-20 21:29:46','2018-09-21 00:14:53','76.110.65.236'),('143','c281b316e2755f4a1d75cb17b617f9ea','3',2,'2018-09-21 00:14:53','2018-09-21 11:43:08','76.110.65.236'),('144','fd5d597f4f5c39d86a7397c17cdf14f8','3',2,'2018-09-21 11:43:08','2018-09-24 14:42:48','76.110.65.236'),('145','0275ec6dfc44581bd306e3ded70210e3','1',2,'2018-09-21 13:17:43','2018-09-21 15:46:51','190.98.41.4'),('146','5fcbee09743accdebe5b40ef0ce62b90','1',2,'2018-09-21 15:46:50','2018-09-25 12:09:13','190.98.41.4'),('147','37763767c442c007811796eaa14feeed','3',2,'2018-09-24 14:42:48','2018-09-24 19:01:48','76.110.65.236'),('148','c31921ba4a08eda955d6c8361ea16e37','3',2,'2018-09-24 19:01:48','2018-09-24 20:33:22','73.139.243.117'),('149','7ff98e7343556c6a41eef6d9276526d3','3',2,'2018-09-24 20:33:22','2018-09-25 14:36:07','76.110.65.236'),('150','363441e619e9626799494d1ed9967f43','1',2,'2018-09-25 12:09:13','2018-09-26 11:48:33','190.98.41.4'),('151','0670cf79e35c9b2f5c6d8d2edc12c435','3',2,'2018-09-25 14:36:07','2018-09-25 16:05:31','76.110.65.236'),('152','99d2f34ed9e9decf3ad7610b63f96ca1','3',2,'2018-09-25 16:05:31','2018-09-26 14:48:20','76.110.65.236'),('153','73b939da4182523758e1699341d495ee','1',2,'2018-09-26 11:48:33','2018-09-26 14:05:30','190.98.41.4'),('154','658522ca27ef36b40a822c1fc7b5e890','1',2,'2018-09-26 14:05:30','2018-09-26 17:40:08','190.98.41.4'),('155','aa09d25bba40651aa7e613d2234105e8','3',2,'2018-09-26 14:48:20','2018-09-26 17:49:16','76.110.65.236'),('156','b954917a213bfd5ab2f585f8bde8f416','1',2,'2018-09-26 17:40:08','2018-09-28 15:42:36','190.98.41.4'),('157','2d1ba1bfc9204aeea60d7b2529153525','3',2,'2018-09-26 17:49:16','2018-10-08 13:06:45','76.110.65.236'),('158','b829060e1ce1348cb727d3a343861651','1',2,'2018-09-28 15:42:36','2018-10-05 14:21:11','190.98.41.4'),('159','d44bdad7a0e667dcd0565f3520b80593','1',2,'2018-10-05 14:21:11','2018-10-05 16:46:21','190.98.41.4'),('160','ffc2a5795849bf946f9d0652d6f9d7ad','1',2,'2018-10-05 16:46:21','2018-10-05 18:42:58','190.98.41.4'),('161','089c06ac6c87ac8b5cea45c513e12a1c','1',2,'2018-10-05 18:42:58','2018-10-08 12:45:15','190.98.41.4'),('162','3cb55302238b27b2cf79991887115570','1',2,'2018-10-08 12:45:15','2018-10-08 14:25:24','190.98.41.4'),('163','befe123c5d0cd0ced68de01988d8ae08','3',2,'2018-10-08 13:06:45','2018-10-08 17:16:48','76.110.65.236'),('164','d157dd8387bcd9dd1c0748fffadbba32','1',2,'2018-10-08 14:25:24','2018-10-08 15:21:43','190.98.41.4'),('165','00f4bae0d2fc3fe77907c619b58899d0','1',2,'2018-10-08 15:21:43','2018-10-08 16:09:19','190.98.41.4'),('166','c672e57c7843e2ae759acdb153a5b3b5','1',2,'2018-10-08 16:09:19','2018-10-08 19:19:03','190.98.41.4'),('167','3996eff82b8067c033a1dd334d5417ff','3',2,'2018-10-08 17:16:48','2018-10-11 19:57:36','76.110.65.236'),('168','7537659696738efb39e7b1cfd1268a76','1',2,'2018-10-08 19:19:03','2018-10-09 14:41:28','190.98.41.4'),('169','257cb9483fab094cab5aef51cc483b5a','1',2,'2018-10-09 14:41:28','2018-10-09 18:37:00','190.98.41.4'),('170','0dc44ddd0f988ce2b2998fd0e32bbdde','1',2,'2018-10-09 18:37:00','2018-10-11 12:54:26','190.98.41.4'),('171','72c59bb5c7d43f2e08829d79e02fbff5','1',2,'2018-10-11 12:54:26','2018-10-12 15:39:25','190.98.41.4'),('172','5f594bc3b327790600c68c91d08125ac','3',2,'2018-10-11 19:57:36','2018-10-12 15:52:57','73.139.243.117'),('173','5b19375adfc207c7387e447d8805b94c','1',0,'2018-10-12 15:39:25','2018-10-12 15:48:40','190.98.41.4'),('174','5bd31af59f9eca5c114c860b1ff28e35','4',0,'2018-10-12 15:48:54','2018-10-12 15:49:13','190.98.41.4'),('175','770c02ad769f9e0f68b8e08e6678c5ab','4',0,'2018-10-12 15:52:36','2018-10-12 15:52:45','76.110.65.236'),('176','1f9b889a82aadf27bbca4e65cb43b05b','3',0,'2018-10-12 15:52:57','2018-10-12 16:05:15','76.110.65.236'),('177','8a3f1f0cc8f5c3ae201c139e8709e102','4',0,'2018-10-12 15:57:29','2018-10-12 16:09:38','200.2.190.85'),('178','8250e8d6afd89871cbcdd40619a10ff9','3',2,'2018-10-12 16:05:21','2018-10-15 16:44:11','76.110.65.236'),('179','7ee9764ff9eb1ee061153ff6550a0ef9','1',2,'2018-10-12 16:35:20','2018-10-15 12:49:23','190.98.41.4'),('180','090dbc85f6dc067829f3b7a9468ab6d3','1',2,'2018-10-15 12:49:23','2018-10-17 13:23:50','190.98.41.4'),('181','a61860cabb840ac8f59bbbe15d9e9cfb','3',1,'2018-10-15 16:44:11','2018-10-15 16:46:08','76.110.65.236'),('182','7f060ec078adcb36f3646c4975eaa15d','1',1,'2018-10-17 13:23:50','2018-10-17 13:29:24','190.98.41.4');
/*!40000 ALTER TABLE `admin_user_session` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `adminnotification_inbox`
--

DROP TABLE IF EXISTS `adminnotification_inbox`;
CREATE TABLE `adminnotification_inbox` (
  `notification_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Notification id',
  `severity` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Problem type',
  `date_added` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Create date',
  `title` varchar(255) NOT NULL COMMENT 'Title',
  `description` text COMMENT 'Description',
  `url` varchar(255) DEFAULT NULL COMMENT 'Url',
  `is_read` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Flag if notification read',
  `is_remove` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Flag if notification might be removed',
  PRIMARY KEY (`notification_id`),
  KEY `ADMINNOTIFICATION_INBOX_SEVERITY` (`severity`),
  KEY `ADMINNOTIFICATION_INBOX_IS_READ` (`is_read`),
  KEY `ADMINNOTIFICATION_INBOX_IS_REMOVE` (`is_remove`)
) ENGINE=InnoDB AUTO_INCREMENT=29 DEFAULT CHARSET=utf8 COMMENT='Adminnotification Inbox';

--
-- Dumping data for table `adminnotification_inbox`
--

LOCK TABLES `adminnotification_inbox` WRITE;
/*!40000 ALTER TABLE `adminnotification_inbox` DISABLE KEYS */;
INSERT INTO `adminnotification_inbox` VALUES ('1',4,'2017-12-11 10:13:49','FAQ: How to configure &quot;read more&quot; in your Magento 2 blog post',' If you still don\'t know how to configure read more functionality in your magento 2 blog post, please read this article.\nOnline documentation for Magento 2 blog extension is also available on our website. http://goo.gl/XOEdpy ','http://magefan.com/blog/add-read-more-tag-to-blog-post-content/?from=notification1',0,0),('2',4,'2017-12-12 23:00:41','Magento Open Source 2.2.2 Accelerates Growth with Instant Purchase Checkout, Integrated Email Marketing Automation, Advanced Reporting, and More – 12/12/2017','Our newest release of Magento Open Source equips merchants with powerful tools to accelerate growth and improve operational efficiency. It boosts conversion rates with a streamlined Instant Purchase checkout, jump-starts sales with integrated dotmailer email marketing automation, delivers actionable insights through Advanced Reporting, and provides integrated multi-carrier shipping and fulfillment capabilities with Magento Shipping. https://magento.com/blog/magento-news/new-instant-purchase-checkout-boosts-sales ','https://magento.com/blog/magento-news/new-instant-purchase-checkout-boosts-sales ',0,0),('3',4,'2017-12-16 02:19:51','Survey: Do you use site personalization and optimization tools? If yes, we\'d to hear from you!','We\'d like to invite you to take our online survey on site personalization and optimization tools. Your input is valuable and will help to inform the products we bring to market.\n\nThe survey should take no more than 5-7 minutes. \n\nTo get started, go to: \nhttps://www.surveymonkey.com/r/NF9ZH8D\n\nThank you in advance for your participation.','https://www.surveymonkey.com/r/NF9ZH8D',0,0),('4',4,'2017-12-27 18:45:11','Magento Survey: Take our quick survey on payments risk &amp; fraud.','We\'d like to invite you to take our online survey on payments risk and fraud. The survey should take no more than 2 minutes to complete.\n\nTo get started, go to: \nhttps://www.surveymonkey.co.uk/r/J8SQ9VG\n\nThank you in advance for your participation.\n\n~The Magento Team','https://www.surveymonkey.co.uk/r/J8SQ9VG',1,0),('5',4,'2018-01-03 03:10:14','Survey: Tell us about your expectations for mobile commerce in less than 1 minute','Happy new year!\n\nHas mobile commerce lived up to your expectations? We\'d like to hear from you. Take our short survey and tell us what you think.\n\nGo to: https://www.surveymonkey.com/r/589GJVT\n\nCheers!\n\n~The Magento Team','https://www.surveymonkey.com/r/589GJVT',1,0),('6',4,'2018-01-03 20:33:54','Survey: Tell us about your expectations for mobile commerce with our 1 minute survey','Happy new year!\n\nHas mobile commerce lived up to your expectations? We\'d like to hear from you. Take our short survey and tell us what you think.\n\nGo to: https://www.surveymonkey.com/r/589GJVT\n\nCheers!\n\n~The Magento Team','https://www.surveymonkey.com/r/589GJVT',1,0),('7',4,'2018-01-31 03:16:41','Are you a Magento Developer? Please participate in our developer survey. ','As a Magento developer, your feedback is critical to the success of the Magento platform. We invite you to complete a survey about your experience developing on the Magento 2 platform. The results will help us improve our product and services to enable your continued success. The survey should take no more than 10 minutes to complete and the information you provide will remain strictly confidential. \n\nThanks in advance for your participation. \n\nhttps://www.surveymonkey.com/r/X3KHNV3\n','https://www.surveymonkey.com/r/X3KHNV3',1,0),('8',3,'2018-02-01 05:41:12','New version 2.7.0 of Magefan Magento 2 Blog Extension is now available.',' You can download the new version from Magefan Store or update it via composer. Get us in touch if you need our help with an update or you have any questions.\n                https://magefan.com/magento2-blog-extension?version=2.7.0\n             ','https://magefan.com/magento2-blog-extension?version=2.7.0',1,0),('9',4,'2018-02-07 16:56:41','New Magento Security Scan Tool is available!','Magento has rolled out a new security scan tool that enables you to regularly monitor your sites and receive updates regarding known security risks, malware, and unauthorized access. Our  goal is to assist in ensuring the on-going security of your Magento sites. \n\nSecurity Scan is a free service of Magento, and provides over 30 security tests to identify potential vulnerabilities, such as missing Magento patches, configuration issues, and failure to follow security best practices. In addition, you\'ll receive real-time security status of your Magento sites and how to fix potential vulnerabilities.\n\nYou and your team, including authorized developers, can access the new tool directly within your Magento Account. And it is very easy to set up. \n\nTo learn more about the Security Scan Tool, \nlog into your Magento Account at https://account.magento.com/customer/account/.\n\nMy Account &gt; Security Scan','https://account.magento.com/customer/account/',1,0),('10',1,'2018-04-09 05:04:15','Take Steps to Protect Your Site ','Our goal is to help you deliver the highest level of security to your Magento site. \n\nYou now have access to a security scan tool that enables you to regularly monitor your sites and receive updates regarding known security risks, malware, and unauthorized access. It provides over 30 security tests to identify potential vulnerabilities, such as missing Magento patches, configuration issues, and failure to follow security best practices. Please be sure to set your site up for security scanning – activation is quick and easy. Access today in your Magento account.\n\nYou should also visit our Security Center which provides alerts around potential issues as well as best practices to help you protect your site against issues, such as brute force attacks. Brute-force password guessing attacks continue to target Magento Open Source (formerly Community Edition) sites worldwide and we have published an  article that explains multiple actions you can take to protect your site from such attacks. In some cases, these attacks have resulted in unauthorized administrative access, so it is important to implement these recommendations.\n\nTo visit the Magento Security Center:\nwww.magento.com/security\n\nTo view steps you can take to protect against issues like brute force, go to:\nwww.magento.com/security/best-practices/5-immediate-actions-protect-against-brute-force-attacks','https://magento.com/security/best-practices/5-immediate-actions-protect-against-brute-force-attacks',1,0),('11',4,'2018-05-02 21:07:10','Magento Open Source 2.2.4 Enables Better Shopping Experiences with Integrated Payment, Tax, and Shipping Solutions – 5/2/2018','The latest release of Magento Open Source empowers merchants to create better shopping experiences with performance enhancements and integrations with Amazon Pay, Klarna, and Vertex. Learn how these features can help you reduce cart abandonment and increase average order value, while simplifying your operations at https://magento.com/blog/magento-news/create-better-shopping-experiences-magento-commerce','https://magento.com/blog/magento-news/create-better-shopping-experiences-magento-commerce',1,0),('12',1,'2018-06-27 18:45:34','Magento Open Source 2.2.5 delivers important security updates along with performance and functionality enhancements – 6/27/2018','The latest release of Magento Open Source includes important security enhancements along with performance and functionality improvements. With these important updates we strongly recommend that you upgrade to ensure your sites maintain the highest level of security. You can review the release notes for more information about all of the enhancements. For more information about security updates included in these versions of Magento please see our Security Center: https://magento.com/security/patches/magento-2.2.5-and-2.1.14-security-update','https://devdocs.magento.com/guides/v2.2/release-notes/bk-release-notes.html',1,0),('13',4,'2018-07-17 00:00:20','Survey: Help us improve the Admin Panel usability by taking this 5 minute survey.','We\'d like to invite you to take our online survey on Admin Panel Usability. Your input is valuable to us and will help to inform the user experience direction. The survey should take no more than 5 minutes to complete.\n \nTo get started, go to:\nhttps://www.surveymonkey.com/r/SUS-AdHoc-M2','https://www.surveymonkey.com/r/SUS-AdHoc-M2',1,0),('14',3,'2018-07-20 14:17:02','New version 2.8.1 of Magefan Magento 2 Blog Extension is now available.',' You can download the new version from Magefan Store or update it via composer. Get us in touch if you need our help with an update or you have any questions.\n                                https://magefan.com/magento2-blog-extension?version=2.8.1\n                             ','https://magefan.com/magento2-blog-extension?version=2.8.1',1,0),('15',1,'2018-07-20 14:17:02','Attention! You use an ancient version of Blog Extension. It is strongly recommended to update Blog Extension to the newest version 2.8.1',' \n                                https://magefan.com/magento2-blog-extension?ancient=2.6.0                             ','https://magefan.com/magento2-blog-extension?ancient=2.6.0',1,0),('16',3,'2018-07-20 08:00:00','Blog v2.7.0 released','Feature: Import data from Wordpress, Aheadworks Blog M1, Magefan Blog M2. Bugfixing and performance improvements. See more.','https://www.mageplaza.com/magento-2-blog-extension/?utm_source=notification&amp;utm_medium=rss&amp;utm_campaign=released',1,0),('17',4,'2018-07-10 08:00:00','Mageplaza Is Now A Select Magento Extension Builder ','It’s our honor to announce that Mageplaza has successfully formed a partnership with Magento as a Select Magento extension builder.','https://www.mageplaza.com/blog/mageplaza-select-magento-extension-builder.html?utm_source=notification&amp;utm_medium=rss&amp;utm_campaign=select-partner',1,0),('18',4,'2018-05-24 08:00:00','Preparing for the GDPR: Easy step to implement','Every organisation that processes personal data must be compliant with new GDPR rules on 25 May 2018 and this includes charities and voluntary ...','https://www.mageplaza.com/magento-2-gdpr-extension/?utm_source=notification&amp;utm_medium=rss&amp;utm_campaign=gdpr-m2',1,0),('19',4,'2018-03-23 08:00:00','Protect &amp; Secure your online stores.','Mageplaza released Security module designed to keep the bad guys out. It resolves common security issues. Download it for FREE!','https://www.mageplaza.com/magento-2-security/?utm_source=notification&amp;utm_medium=rss&amp;utm_campaign=security-m2',1,0),('20',4,'2018-03-02 08:00:00','Reward Points is now available for pre-order','Reward Points is now available for pre-order from March 02 to March 08. Let\'s double the effectiveness of your customer engagement with Mageplaza\'s special preorder package. Go explore now and make a big saving of $229!','https://www.mageplaza.com/magento-2-reward-points-extension/?utm_source=notification&amp;utm_medium=rss&amp;utm_campaign=preorder-reward-points',1,0),('21',3,'2018-01-08 08:00:00','PDF Invoice is now available for pre-order','The pre-order for PDF Invoice is available now until Jan 10th with LIMITED SPECIAL OFFERS. Go explore now!','https://www.mageplaza.com/magento-2-pdf-invoice-extension/?utm_source=notification&amp;utm_medium=rss&amp;utm_campaign=pre-order-pdf',1,0),('22',3,'2017-12-20 00:00:00','SMTP v1.1.0 released','Support multistores, AWS SES, Improve Email Log features and performance.','https://www.mageplaza.com/magento-2-smtp/?utm_source=notification&amp;utm_medium=rss&amp;utm_campaign=halloween',0,0),('23',3,'2018-07-26 08:00:00','Size Chart v1.0.1 released','Unlimited size charts built based on flexible catalog rules, 6 premade standard size chart. See more.','https://www.mageplaza.com/magento-2-size-chart/?utm_source=notification&amp;utm_medium=rss&amp;utm_campaign=released',1,0),('24',4,'2018-08-06 15:42:38','Join our early access program for Magento Payments. Learn more!','Want to get exclusive access to an upcoming new product before it is released to the public?\n\nWant to help influence new payment features Magento is building?\n\nJoin our Early Adopter Program and play a pivotal role in the validation of one of Magento’s newest products.  You will get access to Magento Payments – the payment solution built for Magento by Magento. Magento Payments enables you to instantly accept payments from your customers, offers the right payment options and allows you to manage financial operations with minimal effort. \n \nWe will be granting access to this program to a select number of merchants - we are looking for active participation and regular feedback.\n\nIf you would like to participate and your business is based in the United States, please send an email to: payments@magento.com','www.magento.com',1,0),('25',4,'2018-08-29 15:24:11','Sign-up for Magento Shipping today!','Looking to reduce your shipping costs? Want to expand delivery options you offer your customers? Ship internationally?\n\nYou can with Magento Shipping. Magento Shipping lets you:\n\n•	Easily connect with global shipping carriers from within the Magento Admin \n•	Reduce shipping-related costs\n•	Automate order fulfillment and logistics \n•	Drive cart conversion, customer loyalty, and revenue \n\nIt’s time to take advantage of the new Magento Shipping sign-up process. Just enter your details and you’re ready to go.\n\nThe sooner you select your plan and register, the faster you’ll turn shipping into a profit machine for your business. \n\nSign up today!\n','http://account.magento.com/shipping/onboarding/start?utm_medium=microsite&amp;utm_campaign=1808-PR-EM-EMEA-APAC-MSH-Self-Service-Sign-Up&amp;utm_source=rss',1,0),('26',3,'2018-08-30 18:42:56','New version 2.8.2 of Magefan Magento 2 Blog Extension is now available.',' You can download the new version from Magefan Store or update it via composer. Get us in touch if you need our help with an update or you have any questions.\n                                https://magefan.com/magento2-blog-extension?version=2.8.2\n                             ','https://magefan.com/magento2-blog-extension?version=2.8.2',1,0),('27',1,'2018-08-30 18:42:56','Attention! You use an ancient version of Blog Extension. It is strongly recommended to update Blog Extension to the newest version 2.8.2',' \n                                https://magefan.com/magento2-blog-extension?ancient=2.6.0                             ','https://magefan.com/magento2-blog-extension?ancient=2.6.0',1,0),('28',1,'2018-09-18 23:21:46','Magento Open Source 2.2.6 delivers important security updates along with performance and functionality enhancements – 9/18/2018','The latest release of Magento Open Source includes important security enhancements along with performance and functionality improvements. With these important updates we strongly recommend that you upgrade to ensure your sites maintain the highest level of security. You can review the release notes for more information about all of the enhancements. For more information about security updates included in these versions of Magento please see our Security Center: https://magento.com/security/patches/magento-2.2.6-and-2.1.15-security-update','https://devdocs.magento.com/guides/v2.2/release-notes/bk-release-notes.html',1,0);
/*!40000 ALTER TABLE `adminnotification_inbox` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `authorization_role`
--

DROP TABLE IF EXISTS `authorization_role`;
CREATE TABLE `authorization_role` (
  `role_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Role ID',
  `parent_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Parent Role ID',
  `tree_level` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Role Tree Level',
  `sort_order` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Role Sort Order',
  `role_type` varchar(1) NOT NULL DEFAULT '0' COMMENT 'Role Type',
  `user_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'User ID',
  `user_type` varchar(16) DEFAULT NULL COMMENT 'User Type',
  `role_name` varchar(50) DEFAULT NULL COMMENT 'Role Name',
  PRIMARY KEY (`role_id`),
  KEY `AUTHORIZATION_ROLE_PARENT_ID_SORT_ORDER` (`parent_id`,`sort_order`),
  KEY `AUTHORIZATION_ROLE_TREE_LEVEL` (`tree_level`)
) ENGINE=InnoDB AUTO_INCREMENT=30 DEFAULT CHARSET=utf8 COMMENT='Admin Role Table';

--
-- Dumping data for table `authorization_role`
--

LOCK TABLES `authorization_role` WRITE;
/*!40000 ALTER TABLE `authorization_role` DISABLE KEYS */;
INSERT INTO `authorization_role` VALUES ('3','0',1,1,'G','0','2','Administrators'),('4','3',2,0,'U','1','2','admin'),('26','0',1,0,'U','24','1','124'),('27','3',2,0,'U','2','2','CHS'),('28','3',2,0,'U','3','2','Shayne'),('29','3',2,0,'U','4','2','CHS');
/*!40000 ALTER TABLE `authorization_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `authorization_rule`
--

DROP TABLE IF EXISTS `authorization_rule`;
CREATE TABLE `authorization_rule` (
  `rule_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Rule ID',
  `role_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Role ID',
  `resource_id` varchar(255) DEFAULT NULL COMMENT 'Resource ID',
  `privileges` varchar(20) DEFAULT NULL COMMENT 'Privileges',
  `permission` varchar(10) DEFAULT NULL COMMENT 'Permission',
  PRIMARY KEY (`rule_id`),
  KEY `AUTHORIZATION_RULE_RESOURCE_ID_ROLE_ID` (`resource_id`,`role_id`),
  KEY `AUTHORIZATION_RULE_ROLE_ID_RESOURCE_ID` (`role_id`,`resource_id`)
) ENGINE=InnoDB AUTO_INCREMENT=16087 DEFAULT CHARSET=utf8 COMMENT='Admin Rule Table';

--
-- Dumping data for table `authorization_rule`
--

LOCK TABLES `authorization_rule` WRITE;
/*!40000 ALTER TABLE `authorization_rule` DISABLE KEYS */;
INSERT INTO `authorization_rule` VALUES ('951','3','Magento_Backend::all',NULL,'allow'),('15849','26','Magento_Backend::all',NULL,'deny'),('15850','26','Magento_Backend::admin',NULL,'allow'),('15851','26','Magento_Backend::dashboard',NULL,'deny'),('15852','26','Plazathemes_Randomproductslider::Plazathemes',NULL,'deny'),('15853','26','Plazathemes_Randomproductslider::randomproductslider',NULL,'deny'),('15854','26','Plazathemes_Randomproductslider::general',NULL,'deny'),('15855','26','Plazathemes_Mostviewed::Plazathemes',NULL,'deny'),('15856','26','Plazathemes_Mostviewed::mostviewed',NULL,'deny'),('15857','26','Plazathemes_Mostviewed::general',NULL,'deny'),('15858','26','Magento_Sales::sales',NULL,'deny'),('15859','26','Magento_Sales::sales_operation',NULL,'deny'),('15860','26','Magento_Sales::sales_order',NULL,'deny'),('15861','26','Magento_Sales::actions',NULL,'deny'),('15862','26','Magento_Sales::create',NULL,'deny'),('15863','26','Magento_Sales::actions_view',NULL,'deny'),('15864','26','Magento_Sales::email',NULL,'deny'),('15865','26','Magento_Sales::reorder',NULL,'deny'),('15866','26','Magento_Sales::actions_edit',NULL,'deny'),('15867','26','Magento_Sales::cancel',NULL,'deny'),('15868','26','Magento_Sales::review_payment',NULL,'deny'),('15869','26','Magento_Sales::capture',NULL,'deny'),('15870','26','Magento_Sales::invoice',NULL,'deny'),('15871','26','Magento_Sales::creditmemo',NULL,'deny'),('15872','26','Magento_Sales::hold',NULL,'deny'),('15873','26','Magento_Sales::unhold',NULL,'deny'),('15874','26','Magento_Sales::ship',NULL,'deny'),('15875','26','Magento_Sales::comment',NULL,'deny'),('15876','26','Magento_Sales::emails',NULL,'deny'),('15877','26','Magento_Sales::sales_invoice',NULL,'deny'),('15878','26','Magento_Sales::shipment',NULL,'deny'),('15879','26','Magento_Sales::sales_creditmemo',NULL,'deny'),('15880','26','Magento_Paypal::billing_agreement',NULL,'deny'),('15881','26','Magento_Paypal::billing_agreement_actions',NULL,'deny'),('15882','26','Magento_Paypal::billing_agreement_actions_view',NULL,'deny'),('15883','26','Magento_Paypal::actions_manage',NULL,'deny'),('15884','26','Magento_Paypal::use',NULL,'deny'),('15885','26','Magento_Sales::transactions',NULL,'deny'),('15886','26','Magento_Sales::transactions_fetch',NULL,'deny'),('15887','26','Magento_Catalog::catalog',NULL,'allow'),('15888','26','Magento_Catalog::catalog_inventory',NULL,'allow'),('15889','26','Magento_Catalog::products',NULL,'allow'),('15890','26','Magento_Catalog::categories',NULL,'deny'),('15891','26','Plazathemes_Hozmegamenu::hozmegamenu',NULL,'deny'),('15892','26','Plazathemes_Bannerslider::bannerslider_bannerslider',NULL,'deny'),('15893','26','Plazathemes_Bannerslider::bannerslider_banners',NULL,'deny'),('15894','26','Plazathemes_Bannerslider::settings',NULL,'deny'),('15895','26','Plazathemes_Blog::elements',NULL,'deny'),('15896','26','Plazathemes_Blog::post',NULL,'deny'),('15897','26','Plazathemes_Blog::category',NULL,'deny'),('15898','26','Plazathemes_Brandslider::brandslider_brandslider',NULL,'deny'),('15899','26','Plazathemes_Brandslider::brandslider_brands',NULL,'deny'),('15900','26','Plazathemes_Brandslider::settings',NULL,'deny'),('15901','26','Plazathemes_Themeoptions::themeoptions',NULL,'deny'),('15902','26','Plazathemes_Themeoptions::settings',NULL,'deny'),('15903','26','Plazathemes_Hozmegamenu::hozmegamenu_hozmegamenu',NULL,'deny'),('15904','26','Plazathemes_Hozmegamenu::items',NULL,'deny'),('15905','26','Magento_Cart::cart',NULL,'deny'),('15906','26','Magento_Cart::manage',NULL,'deny'),('15907','26','Plazathemes_Template::template',NULL,'deny'),('15908','26','Plazathemes_Template::items',NULL,'deny'),('15909','26','Magento_Customer::customer',NULL,'deny'),('15910','26','Magento_Customer::manage',NULL,'deny'),('15911','26','Magento_Customer::online',NULL,'deny'),('15912','26','Mageplaza_Core::menu',NULL,'deny'),('15913','26','Mageplaza_Smtp::smtp',NULL,'deny'),('15914','26','Mageplaza_Smtp::log',NULL,'deny'),('15915','26','Mageplaza_Core::documentation',NULL,'deny'),('15916','26','Mageplaza_Core::userguide',NULL,'deny'),('15917','26','Mageplaza_Core::activate',NULL,'deny'),('15918','26','Magento_Backend::marketing',NULL,'deny'),('15919','26','Magento_CatalogRule::promo',NULL,'deny'),('15920','26','Magento_CatalogRule::promo_catalog',NULL,'deny'),('15921','26','Magento_SalesRule::quote',NULL,'deny'),('15922','26','Magento_Backend::marketing_communications',NULL,'deny'),('15923','26','Magento_Email::template',NULL,'deny'),('15924','26','Magento_Newsletter::template',NULL,'deny'),('15925','26','Magento_Newsletter::queue',NULL,'deny'),('15926','26','Magento_Newsletter::subscriber',NULL,'deny'),('15927','26','Magento_Backend::marketing_seo',NULL,'deny'),('15928','26','Magento_Search::search',NULL,'deny'),('15929','26','Magento_Search::synonyms',NULL,'deny'),('15930','26','Magento_UrlRewrite::urlrewrite',NULL,'deny'),('15931','26','Magento_Sitemap::sitemap',NULL,'deny'),('15932','26','Magento_Backend::marketing_user_content',NULL,'deny'),('15933','26','Magento_Review::reviews_all',NULL,'deny'),('15934','26','Magento_Review::pending',NULL,'deny'),('15935','26','Magento_Backend::myaccount',NULL,'deny'),('15936','26','Magento_Backend::content',NULL,'deny'),('15937','26','Magento_Backend::content_elements',NULL,'deny'),('15938','26','Magento_Cms::page',NULL,'deny'),('15939','26','Magento_Cms::save',NULL,'deny'),('15940','26','Magento_Cms::page_delete',NULL,'deny'),('15941','26','Magento_Cms::block',NULL,'deny'),('15942','26','Magento_Widget::widget_instance',NULL,'deny'),('15943','26','Magento_Cms::media_gallery',NULL,'deny'),('15944','26','Magento_Backend::design',NULL,'deny'),('15945','26','Magento_Theme::theme',NULL,'deny'),('15946','26','Magento_Backend::schedule',NULL,'deny'),('15947','26','Magento_Backend::content_translation',NULL,'deny'),('15948','26','Magento_Reports::report',NULL,'deny'),('15949','26','Magento_Reports::report_marketing',NULL,'deny'),('15950','26','Magento_Reports::shopcart',NULL,'deny'),('15951','26','Magento_Reports::product',NULL,'deny'),('15952','26','Magento_Reports::abandoned',NULL,'deny'),('15953','26','Magento_Reports::report_search',NULL,'deny'),('15954','26','Magento_Newsletter::problem',NULL,'deny'),('15955','26','Magento_Reports::review',NULL,'deny'),('15956','26','Magento_Reports::review_customer',NULL,'deny'),('15957','26','Magento_Reports::review_product',NULL,'deny'),('15958','26','Magento_Reports::salesroot',NULL,'deny'),('15959','26','Magento_Reports::salesroot_sales',NULL,'deny'),('15960','26','Magento_Reports::tax',NULL,'deny'),('15961','26','Magento_Reports::invoiced',NULL,'deny'),('15962','26','Magento_Reports::shipping',NULL,'deny'),('15963','26','Magento_Reports::refunded',NULL,'deny'),('15964','26','Magento_Reports::coupons',NULL,'deny'),('15965','26','Magento_Paypal::paypal_settlement_reports',NULL,'deny'),('15966','26','Magento_Paypal::paypal_settlement_reports_view',NULL,'deny'),('15967','26','Magento_Paypal::fetch',NULL,'deny'),('15968','26','Magento_Braintree::settlement_report',NULL,'deny'),('15969','26','Magento_Reports::customers',NULL,'deny'),('15970','26','Magento_Reports::totals',NULL,'deny'),('15971','26','Magento_Reports::customers_orders',NULL,'deny'),('15972','26','Magento_Reports::accounts',NULL,'deny'),('15973','26','Magento_Reports::report_products',NULL,'deny'),('15974','26','Magento_Reports::viewed',NULL,'deny'),('15975','26','Magento_Reports::bestsellers',NULL,'deny'),('15976','26','Magento_Reports::lowstock',NULL,'deny'),('15977','26','Magento_Reports::sold',NULL,'deny'),('15978','26','Magento_Reports::downloads',NULL,'deny'),('15979','26','Magento_Reports::statistics',NULL,'deny'),('15980','26','Magento_Reports::statistics_refresh',NULL,'deny'),('15981','26','Magento_Backend::stores',NULL,'allow'),('15982','26','Magento_Backend::stores_settings',NULL,'allow'),('15983','26','Magento_Backend::store',NULL,'allow'),('15984','26','Magento_Config::config',NULL,'deny'),('15985','26','Plazathemes_Themeoptions::config',NULL,'deny'),('15986','26','Magento_CatalogInventory::cataloginventory',NULL,'deny'),('15987','26','Magento_Cms::config_cms',NULL,'deny'),('15988','26','Mageplaza_Smtp::configuration',NULL,'deny'),('15989','26','Plazathemes_Bannerslider::config_bannerslider',NULL,'deny'),('15990','26','Magento_Newsletter::newsletter',NULL,'deny'),('15991','26','Plazathemes_Bestsellerproduct::test_config',NULL,'deny'),('15992','26','Magento_GoogleAnalytics::google',NULL,'deny'),('15993','26','Plazathemes_Blog::config_blog',NULL,'deny'),('15994','26','Plazathemes_Brandslider::config_brandslider',NULL,'deny'),('15995','26','Plazathemes_Categorytab::test_config',NULL,'deny'),('15996','26','Plazathemes_Categorytop::test_config',NULL,'deny'),('15997','26','Magento_Contact::contact',NULL,'deny'),('15998','26','Magento_Downloadable::downloadable',NULL,'deny'),('15999','26','Plazathemes_Featureproductslider::test_config',NULL,'deny'),('16000','26','Plazathemes_Mostviewed::config_mostviewed',NULL,'deny'),('16001','26','Magento_Catalog::config_catalog',NULL,'deny'),('16002','26','Magento_CatalogSearch::config_catalog_search',NULL,'deny'),('16003','26','Magento_Payment::payment',NULL,'deny'),('16004','26','Magento_Payment::payment_services',NULL,'deny'),('16005','26','Plazathemes_Recentproductslider::config_recentproductslider',NULL,'deny'),('16006','26','Plazathemes_Randomproductslider::config_randomproductslider',NULL,'deny'),('16007','26','Plazathemes_Producttab::test_config',NULL,'deny'),('16008','26','Plazathemes_Newsletterpopup::test_config',NULL,'deny'),('16009','26','Plazathemes_Newproductslider::test_config',NULL,'deny'),('16010','26','Magento_Sales::fraud_protection',NULL,'deny'),('16011','26','Magento_Shipping::config_shipping',NULL,'deny'),('16012','26','Magento_Shipping::shipping_policy',NULL,'deny'),('16013','26','Magento_Shipping::carriers',NULL,'deny'),('16014','26','Magento_Multishipping::config_multishipping',NULL,'deny'),('16015','26','Mageplaza_Core::configuration',NULL,'deny'),('16016','26','Mageplaza_Core::marketplace',NULL,'deny'),('16017','26','Magento_Config::config_general',NULL,'deny'),('16018','26','Magento_Config::web',NULL,'deny'),('16019','26','Magento_Config::config_design',NULL,'deny'),('16020','26','Magento_Customer::config_customer',NULL,'deny'),('16021','26','Magento_Paypal::paypal',NULL,'deny'),('16022','26','Magento_Tax::config_tax',NULL,'deny'),('16023','26','Magento_Checkout::checkout',NULL,'deny'),('16024','26','Magento_Persistent::persistent',NULL,'deny'),('16025','26','Magento_Sales::config_sales',NULL,'deny'),('16026','26','Magento_Sales::sales_email',NULL,'deny'),('16027','26','Magento_Sales::sales_pdf',NULL,'deny'),('16028','26','Magento_Reports::reports',NULL,'deny'),('16029','26','Magento_Sitemap::config_sitemap',NULL,'deny'),('16030','26','Magento_Config::config_system',NULL,'deny'),('16031','26','Magento_Wishlist::config_wishlist',NULL,'deny'),('16032','26','Plazathemes_InstagramGallery::config_instagramgallery',NULL,'deny'),('16033','26','Magento_Config::advanced',NULL,'deny'),('16034','26','Magento_SalesRule::config_promo',NULL,'deny'),('16035','26','Magento_Config::config_admin',NULL,'deny'),('16036','26','Magento_Config::trans_email',NULL,'deny'),('16037','26','Plazathemes_Pricecountdown::config_pricecountdown',NULL,'deny'),('16038','26','Magento_Config::dev',NULL,'deny'),('16039','26','Plazathemes_Quickview::config_quickview',NULL,'deny'),('16040','26','Magento_Config::currency',NULL,'deny'),('16041','26','Magento_Rss::rss',NULL,'deny'),('16042','26','Magento_Config::sendfriend',NULL,'deny'),('16043','26','Magento_NewRelicReporting::config_newrelicreporting',NULL,'deny'),('16044','26','Magento_CheckoutAgreements::checkoutagreement',NULL,'deny'),('16045','26','Magento_Sales::order_statuses',NULL,'deny'),('16046','26','Magento_Tax::manage_tax',NULL,'deny'),('16047','26','Magento_CurrencySymbol::system_currency',NULL,'deny'),('16048','26','Magento_CurrencySymbol::currency_rates',NULL,'deny'),('16049','26','Magento_CurrencySymbol::symbols',NULL,'deny'),('16050','26','Magento_Backend::stores_attributes',NULL,'deny'),('16051','26','Magento_Catalog::attributes_attributes',NULL,'deny'),('16052','26','Magento_Catalog::update_attributes',NULL,'deny'),('16053','26','Magento_Catalog::sets',NULL,'deny'),('16054','26','Magento_Review::ratings',NULL,'deny'),('16055','26','Magento_Swatches::iframe',NULL,'deny'),('16056','26','Magento_Backend::stores_other_settings',NULL,'deny'),('16057','26','Magento_Customer::group',NULL,'deny'),('16058','26','Magento_Backend::system',NULL,'deny'),('16059','26','Magento_Backend::convert',NULL,'deny'),('16060','26','Magento_ImportExport::import',NULL,'deny'),('16061','26','Magento_ImportExport::export',NULL,'deny'),('16062','26','Magento_TaxImportExport::import_export',NULL,'deny'),('16063','26','Magento_ImportExport::history',NULL,'deny'),('16064','26','Magento_Backend::extensions',NULL,'deny'),('16065','26','Magento_Backend::local',NULL,'deny'),('16066','26','Magento_Backend::custom',NULL,'deny'),('16067','26','Magento_Backend::tools',NULL,'deny'),('16068','26','Magento_Backend::cache',NULL,'deny'),('16069','26','Magento_Backend::setup_wizard',NULL,'deny'),('16070','26','Magento_Backup::backup',NULL,'deny'),('16071','26','Magento_Backup::rollback',NULL,'deny'),('16072','26','Magento_Indexer::index',NULL,'deny'),('16073','26','Magento_Indexer::changeMode',NULL,'deny'),('16074','26','Magento_User::acl',NULL,'deny'),('16075','26','Magento_User::acl_users',NULL,'deny'),('16076','26','Magento_User::locks',NULL,'deny'),('16077','26','Magento_User::acl_roles',NULL,'deny'),('16078','26','Magento_Backend::system_other_settings',NULL,'deny'),('16079','26','Magento_AdminNotification::adminnotification',NULL,'deny'),('16080','26','Magento_AdminNotification::show_toolbar',NULL,'deny'),('16081','26','Magento_AdminNotification::show_list',NULL,'deny'),('16082','26','Magento_AdminNotification::mark_as_read',NULL,'deny'),('16083','26','Magento_AdminNotification::adminnotification_remove',NULL,'deny'),('16084','26','Magento_Variable::variable',NULL,'deny'),('16085','26','Magento_EncryptionKey::crypt_key',NULL,'deny'),('16086','26','Magento_Backend::global_search',NULL,'deny');
/*!40000 ALTER TABLE `authorization_rule` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cache`
--

DROP TABLE IF EXISTS `cache`;
CREATE TABLE `cache` (
  `id` varchar(200) NOT NULL COMMENT 'Cache Id',
  `data` mediumblob COMMENT 'Cache Data',
  `create_time` int(11) DEFAULT NULL COMMENT 'Cache Creation Time',
  `update_time` int(11) DEFAULT NULL COMMENT 'Time of Cache Updating',
  `expire_time` int(11) DEFAULT NULL COMMENT 'Cache Expiration Time',
  PRIMARY KEY (`id`),
  KEY `CACHE_EXPIRE_TIME` (`expire_time`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Caches';

--
-- Table structure for table `cache_tag`
--

DROP TABLE IF EXISTS `cache_tag`;
CREATE TABLE `cache_tag` (
  `tag` varchar(100) NOT NULL COMMENT 'Tag',
  `cache_id` varchar(200) NOT NULL COMMENT 'Cache Id',
  PRIMARY KEY (`tag`,`cache_id`),
  KEY `CACHE_TAG_CACHE_ID` (`cache_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Tag Caches';

--
-- Table structure for table `captcha_log`
--

DROP TABLE IF EXISTS `captcha_log`;
CREATE TABLE `captcha_log` (
  `type` varchar(32) NOT NULL COMMENT 'Type',
  `value` varchar(32) NOT NULL COMMENT 'Value',
  `count` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Count',
  `updated_at` timestamp NULL DEFAULT NULL COMMENT 'Update Time',
  PRIMARY KEY (`type`,`value`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Count Login Attempts';

--
-- Dumping data for table `captcha_log`
--

LOCK TABLES `captcha_log` WRITE;
/*!40000 ALTER TABLE `captcha_log` DISABLE KEYS */;
INSERT INTO `captcha_log` VALUES ('1','46.229.168.129','1','2018-10-09 22:47:44'),('2','adept','1','2018-08-03 12:15:42'),('2','jamatsahip','1','2018-08-03 12:14:15');
/*!40000 ALTER TABLE `captcha_log` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_entity`
--

DROP TABLE IF EXISTS `catalog_category_entity`;
CREATE TABLE `catalog_category_entity` (
  `entity_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `attribute_set_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Attriute Set ID',
  `parent_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Parent Category ID',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Creation Time',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Update Time',
  `path` varchar(255) NOT NULL COMMENT 'Tree Path',
  `position` int(11) NOT NULL COMMENT 'Position',
  `level` int(11) NOT NULL DEFAULT '0' COMMENT 'Tree Level',
  `children_count` int(11) NOT NULL COMMENT 'Child Count',
  PRIMARY KEY (`entity_id`),
  KEY `CATALOG_CATEGORY_ENTITY_LEVEL` (`level`),
  KEY `CATALOG_CATEGORY_ENTITY_PATH` (`path`)
) ENGINE=InnoDB AUTO_INCREMENT=112 DEFAULT CHARSET=utf8 COMMENT='Catalog Category Table';

--
-- Dumping data for table `catalog_category_entity`
--

LOCK TABLES `catalog_category_entity` WRITE;
/*!40000 ALTER TABLE `catalog_category_entity` DISABLE KEYS */;
INSERT INTO `catalog_category_entity` VALUES ('1',3,'0','2017-12-11 09:32:01','2018-09-24 20:49:12','1','0','0','66'),('2',3,'1','2017-12-11 09:32:12','2018-09-24 20:49:12','1/2','1','1','-6'),('4',3,'2','2017-12-11 10:59:49','2018-10-08 15:24:26','1/2/4','2','2','-15'),('5',3,'2','2017-12-11 11:00:18','2018-10-08 15:24:58','1/2/5','3','2','0'),('6',3,'2','2017-12-11 11:00:42','2018-10-08 15:25:29','1/2/6','4','2','0'),('7',3,'2','2017-12-11 11:01:18','2018-10-08 15:25:58','1/2/7','5','2','0'),('8',3,'2','2017-12-11 11:01:40','2018-10-08 14:29:00','1/2/8','7','2','0'),('9',3,'2','2017-12-11 11:02:08','2018-10-08 15:26:58','1/2/9','8','2','0'),('10',3,'2','2017-12-11 11:02:31','2018-10-08 15:27:43','1/2/10','9','2','0'),('11',3,'2','2017-12-11 11:03:09','2018-10-08 15:28:30','1/2/11','10','2','0'),('12',3,'2','2017-12-11 11:12:27','2018-10-08 15:26:25','1/2/12','6','2','0'),('34',3,'1','2017-12-11 11:41:08','2017-12-28 07:08:24','1/34','2','1','27'),('35',3,'34','2017-12-11 11:48:06','2017-12-28 07:25:14','1/34/35','1','2','18'),('36',3,'34','2017-12-11 11:48:34','2017-12-28 07:25:30','1/34/36','2','2','0'),('37',3,'34','2017-12-11 11:49:03','2017-12-28 07:25:44','1/34/37','3','2','0'),('38',3,'34','2017-12-11 11:49:31','2017-12-28 07:32:28','1/34/38','4','2','0'),('39',3,'34','2017-12-11 11:50:04','2017-12-28 10:17:19','1/34/39','5','2','3'),('40',3,'35','2017-12-11 11:53:38','2017-12-28 07:09:52','1/34/35/40','1','3','5'),('41',3,'34','2017-12-11 11:54:23','2017-12-29 10:54:46','1/34/41','6','2','0'),('42',3,'35','2017-12-11 11:55:03','2017-12-28 07:11:31','1/34/35/42','2','3','5'),('43',3,'35','2017-12-11 11:55:46','2017-12-28 07:16:04','1/34/35/43','3','3','5'),('44',3,'40','2017-12-11 11:58:24','2017-12-28 07:10:07','1/34/35/40/44','1','4','0'),('45',3,'40','2017-12-11 11:59:00','2017-12-28 07:10:27','1/34/35/40/45','2','4','0'),('46',3,'40','2017-12-11 11:59:24','2017-12-28 07:10:44','1/34/35/40/46','3','4','0'),('47',3,'40','2017-12-11 11:59:49','2017-12-28 07:11:00','1/34/35/40/47','4','4','0'),('48',3,'40','2017-12-11 12:00:15','2017-12-28 07:11:15','1/34/35/40/48','5','4','0'),('49',3,'42','2017-12-11 12:00:55','2017-12-28 07:11:49','1/34/35/42/49','1','4','0'),('50',3,'42','2017-12-11 12:01:20','2017-12-28 07:12:05','1/34/35/42/50','2','4','0'),('51',3,'42','2017-12-11 12:01:43','2017-12-28 07:12:20','1/34/35/42/51','3','4','0'),('52',3,'42','2017-12-11 12:02:20','2017-12-28 07:12:35','1/34/35/42/52','4','4','0'),('53',3,'42','2017-12-11 12:02:43','2017-12-28 07:12:50','1/34/35/42/53','5','4','0'),('54',3,'43','2017-12-11 12:04:47','2017-12-28 07:16:52','1/34/35/43/54','1','4','0'),('55',3,'43','2017-12-11 12:05:38','2017-12-28 07:17:27','1/34/35/43/55','2','4','0'),('56',3,'43','2017-12-11 12:06:03','2017-12-28 07:19:11','1/34/35/43/56','3','4','0'),('57',3,'43','2017-12-11 12:06:24','2017-12-28 07:19:55','1/34/35/43/57','4','4','0'),('58',3,'43','2017-12-11 12:06:54','2017-12-28 07:20:47','1/34/35/43/58','5','4','0'),('59',3,'39','2017-12-11 12:09:48','2017-12-28 10:25:02','1/34/39/59','1','3','0'),('60',3,'39','2017-12-11 12:10:26','2017-12-28 10:25:16','1/34/39/60','2','3','0'),('61',3,'39','2017-12-11 12:10:56','2017-12-28 10:25:31','1/34/39/61','3','3','0'),('62',3,'1','2017-12-12 06:18:39','2018-01-03 05:18:54','1/62','3','1','26'),('63',3,'62','2017-12-12 06:19:17','2018-01-03 05:28:31','1/62/63','1','2','4'),('64',3,'62','2017-12-12 06:19:59','2018-01-03 05:28:58','1/62/64','2','2','4'),('65',3,'62','2017-12-12 06:20:32','2018-01-03 05:29:19','1/62/65','3','2','4'),('66',3,'62','2017-12-12 06:21:03','2018-01-03 05:22:59','1/62/66','4','2','0'),('67',3,'62','2017-12-12 06:21:31','2018-01-03 05:30:01','1/62/67','5','2','4'),('68',3,'62','2017-12-12 06:21:53','2018-01-03 05:33:17','1/62/68','6','2','0'),('69',3,'62','2017-12-12 06:26:16','2018-01-03 05:33:46','1/62/69','7','2','0'),('70',3,'62','2017-12-12 06:26:41','2018-01-03 05:25:20','1/62/70','8','2','0'),('71',3,'62','2017-12-12 06:27:07','2018-01-03 05:25:34','1/62/71','9','2','0'),('72',3,'62','2017-12-12 06:51:59','2018-01-03 05:25:52','1/62/72','10','2','0'),('73',3,'63','2017-12-12 06:53:32','2018-01-03 05:44:44','1/62/63/73','1','3','0'),('74',3,'63','2017-12-12 06:53:59','2018-01-03 05:45:01','1/62/63/74','2','3','0'),('75',3,'63','2017-12-12 06:54:20','2018-01-03 05:45:18','1/62/63/75','3','3','0'),('76',3,'63','2017-12-12 06:54:54','2018-01-03 05:45:52','1/62/63/76','4','3','0'),('77',3,'64','2017-12-12 06:55:27','2018-01-03 05:46:10','1/62/64/77','1','3','0'),('78',3,'64','2017-12-12 06:55:52','2018-01-03 05:46:34','1/62/64/78','2','3','0'),('79',3,'64','2017-12-12 06:56:14','2018-01-03 05:46:53','1/62/64/79','3','3','0'),('80',3,'64','2017-12-12 06:56:35','2018-01-03 05:47:08','1/62/64/80','4','3','0'),('81',3,'65','2017-12-12 06:57:00','2018-01-03 05:47:29','1/62/65/81','1','3','0'),('82',3,'65','2017-12-12 06:57:27','2018-01-03 05:47:46','1/62/65/82','2','3','0'),('83',3,'65','2017-12-12 06:57:47','2018-01-03 05:48:04','1/62/65/83','3','3','0'),('84',3,'65','2017-12-12 06:58:07','2018-01-03 05:48:19','1/62/65/84','4','3','0'),('85',3,'67','2017-12-12 06:59:49','2018-01-03 05:48:48','1/62/67/85','1','3','0'),('86',3,'67','2017-12-12 07:00:11','2018-01-03 05:49:05','1/62/67/86','2','3','0'),('87',3,'67','2017-12-12 07:00:29','2018-01-03 05:49:21','1/62/67/87','3','3','0'),('88',3,'67','2017-12-12 07:00:50','2018-01-03 05:49:38','1/62/67/88','4','3','0'),('89',3,'1','2017-12-12 07:02:10','2018-01-05 06:53:56','1/89','4','1','15'),('90',3,'89','2017-12-12 07:13:57','2018-01-05 06:57:31','1/89/90','1','2','3'),('91',3,'89','2017-12-12 07:14:30','2018-01-05 06:34:57','1/89/91','2','2','3'),('93',3,'89','2017-12-12 07:15:38','2018-01-05 06:52:05','1/89/93','4','2','0'),('94',3,'89','2017-12-12 07:16:00','2018-01-05 06:58:06','1/89/94','5','2','0'),('95',3,'89','2017-12-12 07:16:28','2018-01-05 06:58:31','1/89/95','6','2','0'),('96',3,'89','2017-12-12 07:16:55','2018-01-05 06:59:28','1/89/96','7','2','0'),('97',3,'89','2017-12-12 07:17:27','2018-01-05 06:59:50','1/89/97','8','2','0'),('98',3,'89','2017-12-12 07:17:50','2018-01-05 07:00:28','1/89/98','9','2','0'),('99',3,'89','2017-12-12 07:18:11','2018-01-05 07:00:51','1/89/99','10','2','0'),('100',3,'90','2017-12-12 07:20:29','2018-09-08 15:27:14','1/89/90/100','1','3','0'),('101',3,'90','2017-12-12 07:23:50','2018-01-05 06:55:10','1/89/90/101','2','3','0'),('102',3,'90','2017-12-12 09:27:52','2018-01-05 06:55:54','1/89/90/102','3','3','0'),('109',3,'91','2018-01-05 06:32:29','2018-01-05 06:32:29','1/89/91/109','1','3','0'),('110',3,'91','2018-01-05 06:34:04','2018-01-05 06:34:04','1/89/91/110','2','3','0'),('111',3,'91','2018-01-05 06:34:57','2018-01-05 06:34:57','1/89/91/111','3','3','0');
/*!40000 ALTER TABLE `catalog_category_entity` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_entity_datetime`
--

DROP TABLE IF EXISTS `catalog_category_entity_datetime`;
CREATE TABLE `catalog_category_entity_datetime` (
  `value_id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `attribute_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `value` datetime DEFAULT NULL COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `CATALOG_CATEGORY_ENTITY_DATETIME_ENTITY_ID_ATTRIBUTE_ID_STORE_ID` (`entity_id`,`attribute_id`,`store_id`),
  KEY `CATALOG_CATEGORY_ENTITY_DATETIME_ENTITY_ID` (`entity_id`),
  KEY `CATALOG_CATEGORY_ENTITY_DATETIME_ATTRIBUTE_ID` (`attribute_id`),
  KEY `CATALOG_CATEGORY_ENTITY_DATETIME_STORE_ID` (`store_id`)
) ENGINE=InnoDB AUTO_INCREMENT=377 DEFAULT CHARSET=utf8 COMMENT='Catalog Category Datetime Attribute Backend Table';

--
-- Dumping data for table `catalog_category_entity_datetime`
--

LOCK TABLES `catalog_category_entity_datetime` WRITE;
/*!40000 ALTER TABLE `catalog_category_entity_datetime` DISABLE KEYS */;
INSERT INTO `catalog_category_entity_datetime` VALUES ('1',61,0,'34',NULL),('2',62,0,'34',NULL),('3',61,0,'43',NULL),('4',62,0,'43',NULL),('5',61,0,'89',NULL),('6',62,0,'89',NULL),('7',61,0,'2',NULL),('8',62,0,'2',NULL),('11',61,0,'4',NULL),('12',62,0,'4',NULL),('13',61,0,'6',NULL),('14',62,0,'6',NULL),('15',61,0,'7',NULL),('16',62,0,'7',NULL),('17',61,0,'5',NULL),('18',62,0,'5',NULL),('19',61,0,'8',NULL),('20',62,0,'8',NULL),('21',61,0,'9',NULL),('22',62,0,'9',NULL),('23',61,0,'10',NULL),('24',62,0,'10',NULL),('25',61,0,'11',NULL),('26',62,0,'11',NULL),('27',61,0,'12',NULL),('28',62,0,'12',NULL),('39',61,0,'35',NULL),('40',62,0,'35',NULL),('41',61,0,'36',NULL),('42',62,0,'36',NULL),('43',61,0,'37',NULL),('44',62,0,'37',NULL),('45',61,0,'39',NULL),('46',62,0,'39',NULL),('125',61,1,'5',NULL),('126',62,1,'5',NULL),('127',61,1,'6',NULL),('128',62,1,'6',NULL),('137',61,1,'7',NULL),('138',62,1,'7',NULL),('147',61,0,'63',NULL),('148',62,0,'63',NULL),('149',61,0,'40',NULL),('150',62,0,'40',NULL),('151',61,0,'44',NULL),('152',62,0,'44',NULL),('153',61,0,'45',NULL),('154',62,0,'45',NULL),('155',61,0,'46',NULL),('156',62,0,'46',NULL),('157',61,0,'47',NULL),('158',62,0,'47',NULL),('159',61,0,'48',NULL),('160',62,0,'48',NULL),('161',61,0,'42',NULL),('162',62,0,'42',NULL),('163',61,0,'49',NULL),('164',62,0,'49',NULL),('165',61,0,'50',NULL),('166',62,0,'50',NULL),('167',61,0,'51',NULL),('168',62,0,'51',NULL),('169',61,0,'52',NULL),('170',62,0,'52',NULL),('171',61,0,'53',NULL),('172',62,0,'53',NULL),('173',61,0,'54',NULL),('174',62,0,'54',NULL),('175',61,0,'55',NULL),('176',62,0,'55',NULL),('177',61,0,'56',NULL),('178',62,0,'56',NULL),('179',61,0,'57',NULL),('180',62,0,'57',NULL),('181',61,0,'58',NULL),('182',62,0,'58',NULL),('183',61,0,'38',NULL),('184',62,0,'38',NULL),('185',61,0,'59',NULL),('186',62,0,'59',NULL),('187',61,0,'60',NULL),('188',62,0,'60',NULL),('189',61,0,'61',NULL),('190',62,0,'61',NULL),('191',61,0,'41',NULL),('192',62,0,'41',NULL),('213',61,0,'62',NULL),('214',62,0,'62',NULL),('215',61,0,'73',NULL),('216',62,0,'73',NULL),('217',61,0,'74',NULL),('218',62,0,'74',NULL),('219',61,0,'75',NULL),('220',62,0,'75',NULL),('221',61,0,'76',NULL),('222',62,0,'76',NULL),('223',61,0,'64',NULL),('224',62,0,'64',NULL),('225',61,0,'77',NULL),('226',62,0,'77',NULL),('227',61,0,'78',NULL),('228',62,0,'78',NULL),('229',61,0,'79',NULL),('230',62,0,'79',NULL),('231',61,0,'80',NULL),('232',62,0,'80',NULL),('233',61,0,'65',NULL),('234',62,0,'65',NULL),('235',61,0,'81',NULL),('236',62,0,'81',NULL),('237',61,0,'82',NULL),('238',62,0,'82',NULL),('239',61,0,'83',NULL),('240',62,0,'83',NULL),('241',61,0,'84',NULL),('242',62,0,'84',NULL),('243',61,0,'66',NULL),('244',62,0,'66',NULL),('245',61,0,'67',NULL),('246',62,0,'67',NULL),('247',61,0,'85',NULL),('248',62,0,'85',NULL),('249',61,0,'86',NULL),('250',62,0,'86',NULL),('251',61,0,'87',NULL),('252',62,0,'87',NULL),('253',61,0,'88',NULL),('254',62,0,'88',NULL),('255',61,0,'68',NULL),('256',62,0,'68',NULL),('257',61,0,'69',NULL),('258',62,0,'69',NULL),('259',61,0,'70',NULL),('260',62,0,'70',NULL),('261',61,0,'71',NULL),('262',62,0,'71',NULL),('263',61,0,'72',NULL),('264',62,0,'72',NULL),('311',61,0,'90',NULL),('312',62,0,'90',NULL),('313',61,0,'100',NULL),('314',62,0,'100',NULL),('315',61,0,'101',NULL),('316',62,0,'101',NULL),('317',61,0,'102',NULL),('318',62,0,'102',NULL),('319',61,0,'91',NULL),('320',62,0,'91',NULL),('321',61,0,'93',NULL),('322',62,0,'93',NULL),('325',61,0,'94',NULL),('326',62,0,'94',NULL),('327',61,0,'95',NULL),('328',62,0,'95',NULL),('329',61,0,'96',NULL),('330',62,0,'96',NULL),('331',61,0,'97',NULL),('332',62,0,'97',NULL),('333',61,0,'98',NULL),('334',62,0,'98',NULL),('335',61,0,'99',NULL),('336',62,0,'99',NULL),('353',61,13,'2',NULL),('354',62,13,'2',NULL),('359',61,13,'4',NULL),('360',62,13,'4',NULL),('361',61,13,'9',NULL),('362',62,13,'9',NULL),('363',61,13,'5',NULL),('364',62,13,'5',NULL),('365',61,13,'6',NULL),('366',62,13,'6',NULL),('367',61,13,'7',NULL),('368',62,13,'7',NULL),('369',61,13,'8',NULL),('370',62,13,'8',NULL),('371',61,13,'10',NULL),('372',62,13,'10',NULL),('373',61,13,'11',NULL),('374',62,13,'11',NULL),('375',61,13,'12',NULL),('376',62,13,'12',NULL);
/*!40000 ALTER TABLE `catalog_category_entity_datetime` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_entity_decimal`
--

DROP TABLE IF EXISTS `catalog_category_entity_decimal`;
CREATE TABLE `catalog_category_entity_decimal` (
  `value_id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `attribute_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `value` decimal(12,4) DEFAULT NULL COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `CATALOG_CATEGORY_ENTITY_DECIMAL_ENTITY_ID_ATTRIBUTE_ID_STORE_ID` (`entity_id`,`attribute_id`,`store_id`),
  KEY `CATALOG_CATEGORY_ENTITY_DECIMAL_ENTITY_ID` (`entity_id`),
  KEY `CATALOG_CATEGORY_ENTITY_DECIMAL_ATTRIBUTE_ID` (`attribute_id`),
  KEY `CATALOG_CATEGORY_ENTITY_DECIMAL_STORE_ID` (`store_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Category Decimal Attribute Backend Table';

--
-- Table structure for table `catalog_category_entity_int`
--

DROP TABLE IF EXISTS `catalog_category_entity_int`;
CREATE TABLE `catalog_category_entity_int` (
  `value_id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `attribute_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `value` int(11) DEFAULT NULL COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `CATALOG_CATEGORY_ENTITY_INT_ENTITY_ID_ATTRIBUTE_ID_STORE_ID` (`entity_id`,`attribute_id`,`store_id`),
  KEY `CATALOG_CATEGORY_ENTITY_INT_ENTITY_ID` (`entity_id`),
  KEY `CATALOG_CATEGORY_ENTITY_INT_ATTRIBUTE_ID` (`attribute_id`),
  KEY `CATALOG_CATEGORY_ENTITY_INT_STORE_ID` (`store_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1517 DEFAULT CHARSET=utf8 COMMENT='Catalog Category Integer Attribute Backend Table';

--
-- Dumping data for table `catalog_category_entity_int`
--

LOCK TABLES `catalog_category_entity_int` WRITE;
/*!40000 ALTER TABLE `catalog_category_entity_int` DISABLE KEYS */;
INSERT INTO `catalog_category_entity_int` VALUES ('1',69,0,'1','1'),('2',46,0,'2','1'),('3',69,0,'2','1'),('12',46,0,'4','1'),('13',54,0,'4','1'),('14',69,0,'4','1'),('15',70,0,'4','0'),('16',71,0,'4','0'),('17',136,0,'4','0'),('18',139,0,'4','1'),('19',140,0,'4','1'),('20',46,0,'5','1'),('21',54,0,'5','1'),('22',69,0,'5','1'),('23',70,0,'5','0'),('24',71,0,'5','0'),('25',136,0,'5','0'),('26',139,0,'5','1'),('27',140,0,'5','1'),('28',46,0,'6','1'),('29',54,0,'6','1'),('30',69,0,'6','1'),('31',70,0,'6','0'),('32',71,0,'6','0'),('33',136,0,'6','0'),('34',139,0,'6','1'),('35',140,0,'6','1'),('36',46,0,'7','1'),('37',54,0,'7','1'),('38',69,0,'7','1'),('39',70,0,'7','0'),('40',71,0,'7','0'),('41',136,0,'7','0'),('42',139,0,'7','1'),('43',140,0,'7','1'),('44',46,0,'8','1'),('45',54,0,'8','1'),('46',69,0,'8','1'),('47',70,0,'8','0'),('48',71,0,'8','0'),('49',136,0,'8','0'),('50',139,0,'8','1'),('51',140,0,'8','1'),('52',46,0,'9','1'),('53',54,0,'9','1'),('54',69,0,'9','1'),('55',70,0,'9','0'),('56',71,0,'9','0'),('57',136,0,'9','0'),('58',139,0,'9','1'),('59',140,0,'9','1'),('60',46,0,'10','1'),('61',54,0,'10','1'),('62',69,0,'10','1'),('63',70,0,'10','0'),('64',71,0,'10','0'),('65',136,0,'10','0'),('66',139,0,'10','1'),('67',140,0,'10','1'),('68',46,0,'11','1'),('69',54,0,'11','1'),('70',69,0,'11','1'),('71',70,0,'11','0'),('72',71,0,'11','0'),('73',136,0,'11','0'),('74',139,0,'11','1'),('75',140,0,'11','1'),('76',46,0,'12','1'),('77',54,0,'12','1'),('78',69,0,'12','1'),('79',70,0,'12','0'),('80',71,0,'12','0'),('81',136,0,'12','0'),('82',139,0,'12','1'),('83',140,0,'12','1'),('252',46,0,'34','1'),('253',54,0,'34','1'),('254',69,0,'34','1'),('255',70,0,'34','0'),('256',71,0,'34','0'),('257',136,0,'34','0'),('258',139,0,'34','1'),('259',140,0,'34','1'),('260',46,0,'35','1'),('261',54,0,'35','1'),('262',69,0,'35','1'),('263',70,0,'35','0'),('264',71,0,'35','0'),('265',136,0,'35','0'),('266',139,0,'35','1'),('267',140,0,'35','1'),('268',46,0,'36','1'),('269',54,0,'36','1'),('270',69,0,'36','1'),('271',70,0,'36','0'),('272',71,0,'36','0'),('273',136,0,'36','0'),('274',139,0,'36','1'),('275',140,0,'36','1'),('276',46,0,'37','1'),('277',54,0,'37','1'),('278',69,0,'37','1'),('279',70,0,'37','0'),('280',71,0,'37','0'),('281',136,0,'37','0'),('282',139,0,'37','1'),('283',140,0,'37','1'),('284',46,0,'38','1'),('285',54,0,'38','1'),('286',69,0,'38','1'),('287',70,0,'38','0'),('288',71,0,'38','0'),('289',136,0,'38','0'),('290',139,0,'38','1'),('291',140,0,'38','1'),('292',53,0,'34',NULL),('293',46,0,'39','1'),('294',54,0,'39','1'),('295',69,0,'39','1'),('296',70,0,'39','0'),('297',71,0,'39','0'),('298',136,0,'39','0'),('299',139,0,'39','1'),('300',140,0,'39','1'),('301',46,0,'40','1'),('302',54,0,'40','1'),('303',69,0,'40','1'),('304',70,0,'40','0'),('305',71,0,'40','0'),('306',136,0,'40','0'),('307',139,0,'40','1'),('308',140,0,'40','1'),('309',46,0,'41','1'),('310',54,0,'41','1'),('311',69,0,'41','1'),('312',70,0,'41','0'),('313',71,0,'41','0'),('314',136,0,'41','0'),('315',139,0,'41','1'),('316',140,0,'41','1'),('317',46,0,'42','1'),('318',54,0,'42','1'),('319',69,0,'42','1'),('320',70,0,'42','0'),('321',71,0,'42','0'),('322',136,0,'42','0'),('323',139,0,'42','1'),('324',140,0,'42','1'),('325',46,0,'43','1'),('326',54,0,'43','1'),('327',69,0,'43','1'),('328',70,0,'43','0'),('329',71,0,'43','0'),('330',136,0,'43','0'),('331',139,0,'43','1'),('332',140,0,'43','1'),('333',46,0,'44','1'),('334',54,0,'44','1'),('335',69,0,'44','1'),('336',70,0,'44','0'),('337',71,0,'44','0'),('338',136,0,'44','0'),('339',139,0,'44','1'),('340',140,0,'44','1'),('341',46,0,'45','1'),('342',54,0,'45','1'),('343',69,0,'45','1'),('344',70,0,'45','0'),('345',71,0,'45','0'),('346',136,0,'45','0'),('347',139,0,'45','1'),('348',140,0,'45','1'),('349',46,0,'46','1'),('350',54,0,'46','1'),('351',69,0,'46','1'),('352',70,0,'46','0'),('353',71,0,'46','0'),('354',136,0,'46','0'),('355',139,0,'46','1'),('356',140,0,'46','1'),('357',46,0,'47','1'),('358',54,0,'47','1'),('359',69,0,'47','1'),('360',70,0,'47','0'),('361',71,0,'47','0'),('362',136,0,'47','0'),('363',139,0,'47','1'),('364',140,0,'47','1'),('365',46,0,'48','1'),('366',54,0,'48','1'),('367',69,0,'48','1'),('368',70,0,'48','0'),('369',71,0,'48','0'),('370',136,0,'48','0'),('371',139,0,'48','1'),('372',140,0,'48','1'),('373',46,0,'49','1'),('374',54,0,'49','1'),('375',69,0,'49','1'),('376',70,0,'49','0'),('377',71,0,'49','0'),('378',136,0,'49','0'),('379',139,0,'49','1'),('380',140,0,'49','1'),('381',46,0,'50','1'),('382',54,0,'50','1'),('383',69,0,'50','1'),('384',70,0,'50','0'),('385',71,0,'50','0'),('386',136,0,'50','0'),('387',139,0,'50','1'),('388',140,0,'50','1'),('389',46,0,'51','1'),('390',54,0,'51','1'),('391',69,0,'51','1'),('392',70,0,'51','0'),('393',71,0,'51','0'),('394',136,0,'51','0'),('395',139,0,'51','1'),('396',140,0,'51','1'),('397',46,0,'52','1'),('398',54,0,'52','1'),('399',69,0,'52','1'),('400',70,0,'52','0'),('401',71,0,'52','0'),('402',136,0,'52','0'),('403',139,0,'52','1'),('404',140,0,'52','1'),('405',46,0,'53','1'),('406',54,0,'53','1'),('407',69,0,'53','1'),('408',70,0,'53','0'),('409',71,0,'53','0'),('410',136,0,'53','0'),('411',139,0,'53','1'),('412',140,0,'53','1'),('413',46,0,'54','1'),('414',54,0,'54','1'),('415',69,0,'54','1'),('416',70,0,'54','0'),('417',71,0,'54','0'),('418',136,0,'54','0'),('419',139,0,'54','1'),('420',140,0,'54','1'),('421',53,0,'43',NULL),('422',46,0,'55','1'),('423',54,0,'55','1'),('424',69,0,'55','1'),('425',70,0,'55','0'),('426',71,0,'55','0'),('427',136,0,'55','0'),('428',139,0,'55','1'),('429',140,0,'55','1'),('430',46,0,'56','1'),('431',54,0,'56','1'),('432',69,0,'56','1'),('433',70,0,'56','0'),('434',71,0,'56','0'),('435',136,0,'56','0'),('436',139,0,'56','1'),('437',140,0,'56','1'),('438',46,0,'57','1'),('439',54,0,'57','1'),('440',69,0,'57','1'),('441',70,0,'57','0'),('442',71,0,'57','0'),('443',136,0,'57','0'),('444',139,0,'57','1'),('445',140,0,'57','1'),('446',46,0,'58','1'),('447',54,0,'58','1'),('448',69,0,'58','1'),('449',70,0,'58','0'),('450',71,0,'58','0'),('451',136,0,'58','0'),('452',139,0,'58','1'),('453',140,0,'58','1'),('454',46,0,'59','1'),('455',54,0,'59','1'),('456',69,0,'59','1'),('457',70,0,'59','0'),('458',71,0,'59','0'),('459',136,0,'59','0'),('460',139,0,'59','1'),('461',140,0,'59','1'),('462',46,0,'60','1'),('463',54,0,'60','1'),('464',69,0,'60','1'),('465',70,0,'60','0'),('466',71,0,'60','0'),('467',136,0,'60','0'),('468',139,0,'60','1'),('469',140,0,'60','1'),('470',46,0,'61','1'),('471',54,0,'61','1'),('472',69,0,'61','1'),('473',70,0,'61','0'),('474',71,0,'61','0'),('475',136,0,'61','0'),('476',139,0,'61','1'),('477',140,0,'61','1'),('478',46,0,'62','1'),('479',54,0,'62','1'),('480',69,0,'62','1'),('481',70,0,'62','0'),('482',71,0,'62','0'),('483',136,0,'62','0'),('484',139,0,'62','1'),('485',140,0,'62','1'),('486',46,0,'63','1'),('487',54,0,'63','1'),('488',69,0,'63','1'),('489',70,0,'63','0'),('490',71,0,'63','0'),('491',136,0,'63','0'),('492',139,0,'63','1'),('493',140,0,'63','1'),('494',46,0,'64','1'),('495',54,0,'64','1'),('496',69,0,'64','1'),('497',70,0,'64','0'),('498',71,0,'64','0'),('499',136,0,'64','0'),('500',139,0,'64','1'),('501',140,0,'64','1'),('502',46,0,'65','1'),('503',54,0,'65','1'),('504',69,0,'65','1'),('505',70,0,'65','0'),('506',71,0,'65','0'),('507',136,0,'65','0'),('508',139,0,'65','1'),('509',140,0,'65','1'),('510',46,0,'66','1'),('511',54,0,'66','1'),('512',69,0,'66','1'),('513',70,0,'66','0'),('514',71,0,'66','0'),('515',136,0,'66','0'),('516',139,0,'66','1'),('517',140,0,'66','1'),('518',46,0,'67','1'),('519',54,0,'67','1'),('520',69,0,'67','1'),('521',70,0,'67','0'),('522',71,0,'67','0'),('523',136,0,'67','0'),('524',139,0,'67','1'),('525',140,0,'67','1'),('526',46,0,'68','1'),('527',54,0,'68','1'),('528',69,0,'68','1'),('529',70,0,'68','0'),('530',71,0,'68','0'),('531',136,0,'68','0'),('532',139,0,'68','1'),('533',140,0,'68','1'),('534',46,0,'69','1'),('535',54,0,'69','1'),('536',69,0,'69','1'),('537',70,0,'69','0'),('538',71,0,'69','0'),('539',136,0,'69','0'),('540',139,0,'69','1'),('541',140,0,'69','1'),('542',46,0,'70','1'),('543',54,0,'70','1'),('544',69,0,'70','1'),('545',70,0,'70','0'),('546',71,0,'70','0'),('547',136,0,'70','0'),('548',139,0,'70','1'),('549',140,0,'70','1'),('550',46,0,'71','1'),('551',54,0,'71','1'),('552',69,0,'71','1'),('553',70,0,'71','0'),('554',71,0,'71','0'),('555',136,0,'71','0'),('556',139,0,'71','1'),('557',140,0,'71','1'),('558',46,0,'72','1'),('559',54,0,'72','1'),('560',69,0,'72','1'),('561',70,0,'72','0'),('562',71,0,'72','0'),('563',136,0,'72','0'),('564',139,0,'72','1'),('565',140,0,'72','1'),('566',46,0,'73','1'),('567',54,0,'73','1'),('568',69,0,'73','1'),('569',70,0,'73','0'),('570',71,0,'73','0'),('571',136,0,'73','0'),('572',139,0,'73','1'),('573',140,0,'73','1'),('574',46,0,'74','1'),('575',54,0,'74','1'),('576',69,0,'74','1'),('577',70,0,'74','0'),('578',71,0,'74','0'),('579',136,0,'74','0'),('580',139,0,'74','1'),('581',140,0,'74','1'),('582',46,0,'75','1'),('583',54,0,'75','1'),('584',69,0,'75','1'),('585',70,0,'75','0'),('586',71,0,'75','0'),('587',136,0,'75','0'),('588',139,0,'75','1'),('589',140,0,'75','1'),('590',46,0,'76','1'),('591',54,0,'76','1'),('592',69,0,'76','1'),('593',70,0,'76','0'),('594',71,0,'76','0'),('595',136,0,'76','0'),('596',139,0,'76','1'),('597',140,0,'76','1'),('598',46,0,'77','1'),('599',54,0,'77','1'),('600',69,0,'77','1'),('601',70,0,'77','0'),('602',71,0,'77','0'),('603',136,0,'77','0'),('604',139,0,'77','1'),('605',140,0,'77','1'),('606',46,0,'78','1'),('607',54,0,'78','1'),('608',69,0,'78','1'),('609',70,0,'78','0'),('610',71,0,'78','0'),('611',136,0,'78','0'),('612',139,0,'78','1'),('613',140,0,'78','1'),('614',46,0,'79','1'),('615',54,0,'79','1'),('616',69,0,'79','1'),('617',70,0,'79','0'),('618',71,0,'79','0'),('619',136,0,'79','0'),('620',139,0,'79','1'),('621',140,0,'79','1'),('622',46,0,'80','1'),('623',54,0,'80','1'),('624',69,0,'80','1'),('625',70,0,'80','0'),('626',71,0,'80','0'),('627',136,0,'80','0'),('628',139,0,'80','1'),('629',140,0,'80','1'),('630',46,0,'81','1'),('631',54,0,'81','1'),('632',69,0,'81','1'),('633',70,0,'81','0'),('634',71,0,'81','0'),('635',136,0,'81','0'),('636',139,0,'81','1'),('637',140,0,'81','1'),('638',46,0,'82','1'),('639',54,0,'82','1'),('640',69,0,'82','1'),('641',70,0,'82','0'),('642',71,0,'82','0'),('643',136,0,'82','0'),('644',139,0,'82','1'),('645',140,0,'82','1'),('646',46,0,'83','1'),('647',54,0,'83','1'),('648',69,0,'83','1'),('649',70,0,'83','0'),('650',71,0,'83','0'),('651',136,0,'83','0'),('652',139,0,'83','1'),('653',140,0,'83','1'),('654',46,0,'84','1'),('655',54,0,'84','1'),('656',69,0,'84','1'),('657',70,0,'84','0'),('658',71,0,'84','0'),('659',136,0,'84','0'),('660',139,0,'84','1'),('661',140,0,'84','1'),('662',46,0,'85','1'),('663',54,0,'85','1'),('664',69,0,'85','1'),('665',70,0,'85','0'),('666',71,0,'85','0'),('667',136,0,'85','0'),('668',139,0,'85','1'),('669',140,0,'85','1'),('670',46,0,'86','1'),('671',54,0,'86','1'),('672',69,0,'86','1'),('673',70,0,'86','0'),('674',71,0,'86','0'),('675',136,0,'86','0'),('676',139,0,'86','1'),('677',140,0,'86','1'),('678',46,0,'87','1'),('679',54,0,'87','1'),('680',69,0,'87','1'),('681',70,0,'87','0'),('682',71,0,'87','0'),('683',136,0,'87','0'),('684',139,0,'87','1'),('685',140,0,'87','1'),('686',46,0,'88','1'),('687',54,0,'88','1'),('688',69,0,'88','1'),('689',70,0,'88','0'),('690',71,0,'88','0'),('691',136,0,'88','0'),('692',139,0,'88','1'),('693',140,0,'88','1'),('694',46,0,'89','1'),('695',54,0,'89','1'),('696',69,0,'89','1'),('697',70,0,'89','0'),('698',71,0,'89','0'),('699',136,0,'89','0'),('700',139,0,'89','1'),('701',140,0,'89','1'),('702',53,0,'89',NULL),('703',46,0,'90','1'),('704',54,0,'90','1'),('705',69,0,'90','1'),('706',70,0,'90','0'),('707',71,0,'90','0'),('708',136,0,'90','0'),('709',139,0,'90','1'),('710',140,0,'90','1'),('711',46,0,'91','1'),('712',54,0,'91','1'),('713',69,0,'91','1'),('714',70,0,'91','0'),('715',71,0,'91','0'),('716',136,0,'91','0'),('717',139,0,'91','1'),('718',140,0,'91','1'),('727',46,0,'93','1'),('728',54,0,'93','1'),('729',69,0,'93','1'),('730',70,0,'93','0'),('731',71,0,'93','0'),('732',136,0,'93','0'),('733',139,0,'93','1'),('734',140,0,'93','1'),('735',46,0,'94','1'),('736',54,0,'94','1'),('737',69,0,'94','1'),('738',70,0,'94','0'),('739',71,0,'94','0'),('740',136,0,'94','0'),('741',139,0,'94','1'),('742',140,0,'94','1'),('743',46,0,'95','1'),('744',54,0,'95','1'),('745',69,0,'95','1'),('746',70,0,'95','0'),('747',71,0,'95','0'),('748',136,0,'95','0'),('749',139,0,'95','1'),('750',140,0,'95','1'),('751',46,0,'96','1'),('752',54,0,'96','1'),('753',69,0,'96','1'),('754',70,0,'96','0'),('755',71,0,'96','0'),('756',136,0,'96','0'),('757',139,0,'96','1'),('758',140,0,'96','1'),('759',46,0,'97','1'),('760',54,0,'97','1'),('761',69,0,'97','1'),('762',70,0,'97','0'),('763',71,0,'97','0'),('764',136,0,'97','0'),('765',139,0,'97','1'),('766',140,0,'97','1'),('767',46,0,'98','1'),('768',54,0,'98','1'),('769',69,0,'98','1'),('770',70,0,'98','0'),('771',71,0,'98','0'),('772',136,0,'98','0'),('773',139,0,'98','1'),('774',140,0,'98','1'),('775',46,0,'99','1'),('776',54,0,'99','1'),('777',69,0,'99','1'),('778',70,0,'99','0'),('779',71,0,'99','0'),('780',136,0,'99','0'),('781',139,0,'99','1'),('782',140,0,'99','1'),('783',46,0,'100','1'),('784',54,0,'100','1'),('785',69,0,'100','1'),('786',70,0,'100','0'),('787',71,0,'100','0'),('788',136,0,'100','1'),('789',139,0,'100','1'),('790',140,0,'100','1'),('791',46,0,'101','1'),('792',54,0,'101','1'),('793',69,0,'101','1'),('794',70,0,'101','0'),('795',71,0,'101','0'),('796',136,0,'101','0'),('797',139,0,'101','1'),('798',140,0,'101','1'),('799',46,0,'102','1'),('800',54,0,'102','1'),('801',69,0,'102','1'),('802',70,0,'102','0'),('803',71,0,'102','0'),('804',136,0,'102','0'),('805',139,0,'102','1'),('806',140,0,'102','1'),('807',53,0,'2',NULL),('808',54,0,'2','1'),('809',70,0,'2','0'),('810',71,0,'2','0'),('811',136,0,'2','0'),('812',139,0,'2','1'),('813',140,0,'2','0'),('839',53,0,'4',NULL),('840',53,0,'6',NULL),('841',53,0,'7',NULL),('842',53,0,'5',NULL),('843',53,0,'8',NULL),('844',53,0,'9',NULL),('845',53,0,'10',NULL),('846',53,0,'11',NULL),('847',53,0,'12',NULL),('877',53,0,'35',NULL),('878',53,0,'36',NULL),('879',53,0,'37',NULL),('880',53,0,'39',NULL),('1011',70,1,'5','0'),('1012',71,1,'5','0'),('1013',136,1,'5','0'),('1014',139,1,'5','1'),('1015',140,1,'5','1'),('1017',70,1,'6','0'),('1018',71,1,'6','0'),('1019',136,1,'6','0'),('1020',139,1,'6','1'),('1021',140,1,'6','1'),('1047',70,1,'7','0'),('1048',71,1,'7','0'),('1049',136,1,'7','1'),('1050',139,1,'7','1'),('1051',140,1,'7','1'),('1079',53,0,'63',NULL),('1080',53,0,'40',NULL),('1081',53,0,'44',NULL),('1082',53,0,'45',NULL),('1083',53,0,'46',NULL),('1084',53,0,'47',NULL),('1085',53,0,'48',NULL),('1086',53,0,'42',NULL),('1087',53,0,'49',NULL),('1088',53,0,'50',NULL),('1089',53,0,'51',NULL),('1090',53,0,'52',NULL),('1091',53,0,'53',NULL),('1092',53,0,'54',NULL),('1093',53,0,'55',NULL),('1094',53,0,'56',NULL),('1095',53,0,'57',NULL),('1096',53,0,'58',NULL),('1097',53,0,'38',NULL),('1098',53,0,'59',NULL),('1099',53,0,'60',NULL),('1100',53,0,'61',NULL),('1101',53,0,'41',NULL),('1159',53,0,'62',NULL),('1160',53,0,'73',NULL),('1161',53,0,'74',NULL),('1162',53,0,'75',NULL),('1163',53,0,'76',NULL),('1164',53,0,'64',NULL),('1165',53,0,'77',NULL),('1166',53,0,'78',NULL),('1167',53,0,'79',NULL),('1168',53,0,'80',NULL),('1169',53,0,'65',NULL),('1170',53,0,'81',NULL),('1171',53,0,'82',NULL),('1172',53,0,'83',NULL),('1173',53,0,'84',NULL),('1174',53,0,'66',NULL),('1175',53,0,'67',NULL),('1176',53,0,'85',NULL),('1177',53,0,'86',NULL),('1178',53,0,'87',NULL),('1179',53,0,'88',NULL),('1180',53,0,'68',NULL),('1181',53,0,'69',NULL),('1182',53,0,'70',NULL),('1183',53,0,'71',NULL),('1184',53,0,'72',NULL),('1323',53,0,'90',NULL),('1324',53,0,'100',NULL),('1325',53,0,'101',NULL),('1326',53,0,'102',NULL),('1327',53,0,'91',NULL),('1328',46,0,'109','1'),('1329',54,0,'109','1'),('1330',69,0,'109','1'),('1331',70,0,'109','0'),('1332',71,0,'109','0'),('1333',136,0,'109','0'),('1334',139,0,'109','1'),('1335',140,0,'109','1'),('1336',46,0,'110','1'),('1337',54,0,'110','1'),('1338',69,0,'110','1'),('1339',70,0,'110','0'),('1340',71,0,'110','0'),('1341',136,0,'110','0'),('1342',139,0,'110','1'),('1343',140,0,'110','1'),('1344',46,0,'111','1'),('1345',54,0,'111','1'),('1346',69,0,'111','1'),('1347',70,0,'111','0'),('1348',71,0,'111','0'),('1349',136,0,'111','0'),('1350',139,0,'111','1'),('1351',140,0,'111','1'),('1352',53,0,'93',NULL),('1354',53,0,'94',NULL),('1355',53,0,'95',NULL),('1356',53,0,'96',NULL),('1357',53,0,'97',NULL),('1358',53,0,'98',NULL),('1359',53,0,'99',NULL),('1409',53,13,'2',NULL),('1411',70,13,'2','0'),('1412',71,13,'2','0'),('1413',136,13,'2','0'),('1414',139,13,'2','1'),('1415',140,13,'2','1'),('1429',53,13,'4',NULL),('1431',70,13,'4','0'),('1432',71,13,'4','0'),('1433',136,13,'4','0'),('1434',139,13,'4','1'),('1435',140,13,'4','1'),('1437',53,13,'9',NULL),('1439',70,13,'9','0'),('1440',71,13,'9','0'),('1441',136,13,'9','0'),('1442',139,13,'9','1'),('1443',140,13,'9','1'),('1446',53,13,'5',NULL),('1448',70,13,'5','0'),('1449',71,13,'5','0'),('1450',136,13,'5','0'),('1451',139,13,'5','1'),('1452',140,13,'5','1'),('1453',53,13,'6',NULL),('1455',70,13,'6','0'),('1456',71,13,'6','0'),('1457',136,13,'6','0'),('1458',139,13,'6','1'),('1459',140,13,'6','1'),('1460',53,13,'7',NULL),('1462',70,13,'7','0'),('1463',71,13,'7','0'),('1464',136,13,'7','0'),('1465',139,13,'7','1'),('1466',140,13,'7','1'),('1467',53,13,'8',NULL),('1469',70,13,'8','0'),('1470',71,13,'8','0'),('1471',136,13,'8','0'),('1472',139,13,'8','1'),('1473',140,13,'8','1'),('1475',53,13,'10',NULL),('1477',70,13,'10','0'),('1478',71,13,'10','0'),('1479',136,13,'10','0'),('1480',139,13,'10','1'),('1481',140,13,'10','1'),('1482',53,13,'11',NULL),('1484',70,13,'11','0'),('1485',71,13,'11','0'),('1486',136,13,'11','0'),('1487',139,13,'11','1'),('1488',140,13,'11','1'),('1489',53,13,'12',NULL),('1491',70,13,'12','0'),('1492',71,13,'12','0'),('1493',136,13,'12','0'),('1494',139,13,'12','1'),('1495',140,13,'12','1');
/*!40000 ALTER TABLE `catalog_category_entity_int` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_entity_text`
--

DROP TABLE IF EXISTS `catalog_category_entity_text`;
CREATE TABLE `catalog_category_entity_text` (
  `value_id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `attribute_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `value` text COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `CATALOG_CATEGORY_ENTITY_TEXT_ENTITY_ID_ATTRIBUTE_ID_STORE_ID` (`entity_id`,`attribute_id`,`store_id`),
  KEY `CATALOG_CATEGORY_ENTITY_TEXT_ENTITY_ID` (`entity_id`),
  KEY `CATALOG_CATEGORY_ENTITY_TEXT_ATTRIBUTE_ID` (`attribute_id`),
  KEY `CATALOG_CATEGORY_ENTITY_TEXT_STORE_ID` (`store_id`)
) ENGINE=InnoDB AUTO_INCREMENT=683 DEFAULT CHARSET=utf8 COMMENT='Catalog Category Text Attribute Backend Table';

--
-- Dumping data for table `catalog_category_entity_text`
--

LOCK TABLES `catalog_category_entity_text` WRITE;
/*!40000 ALTER TABLE `catalog_category_entity_text` DISABLE KEYS */;
INSERT INTO `catalog_category_entity_text` VALUES ('1',47,0,'34',NULL),('2',50,0,'34',NULL),('3',51,0,'34',NULL),('4',64,0,'34',NULL),('5',47,0,'43',NULL),('6',50,0,'43',NULL),('7',51,0,'43',NULL),('8',64,0,'43',NULL),('9',47,0,'89',NULL),('10',50,0,'89',NULL),('11',51,0,'89',NULL),('12',64,0,'89',NULL),('13',47,0,'2',NULL),('14',50,0,'2',NULL),('15',51,0,'2',NULL),('16',64,0,'2',NULL),('21',47,0,'4',NULL),('22',50,0,'4',NULL),('23',51,0,'4',NULL),('24',64,0,'4',NULL),('25',47,0,'6',NULL),('26',50,0,'6',NULL),('27',51,0,'6',NULL),('28',64,0,'6',NULL),('29',47,0,'7',NULL),('30',50,0,'7',NULL),('31',51,0,'7',NULL),('32',64,0,'7',NULL),('33',47,0,'5',NULL),('34',50,0,'5',NULL),('35',51,0,'5',NULL),('36',64,0,'5',NULL),('37',47,0,'8',NULL),('38',50,0,'8',NULL),('39',51,0,'8',NULL),('40',64,0,'8',NULL),('41',47,0,'9',NULL),('42',50,0,'9',NULL),('43',51,0,'9',NULL),('44',64,0,'9',NULL),('45',47,0,'10',NULL),('46',50,0,'10',NULL),('47',51,0,'10',NULL),('48',64,0,'10',NULL),('49',47,0,'11',NULL),('50',50,0,'11',NULL),('51',51,0,'11',NULL),('52',64,0,'11',NULL),('53',47,0,'12',NULL),('54',50,0,'12',NULL),('55',51,0,'12',NULL),('56',64,0,'12',NULL),('77',47,0,'35',NULL),('78',50,0,'35',NULL),('79',51,0,'35',NULL),('80',64,0,'35',NULL),('81',47,0,'36',NULL),('82',50,0,'36',NULL),('83',51,0,'36',NULL),('84',64,0,'36',NULL),('85',47,0,'37',NULL),('86',50,0,'37',NULL),('87',51,0,'37',NULL),('88',64,0,'37',NULL),('89',47,0,'39',NULL),('90',50,0,'39',NULL),('91',51,0,'39',NULL),('92',64,0,'39',NULL),('231',50,1,'5',NULL),('232',51,1,'5',NULL),('233',64,1,'5',NULL),('234',50,1,'6',NULL),('235',51,1,'6',NULL),('236',64,1,'6',NULL),('249',50,1,'7',NULL),('250',51,1,'7',NULL),('251',64,1,'7',NULL),('264',47,0,'63',NULL),('265',50,0,'63',NULL),('266',51,0,'63',NULL),('267',64,0,'63',NULL),('268',47,0,'40',NULL),('269',50,0,'40',NULL),('270',51,0,'40',NULL),('271',64,0,'40',NULL),('272',47,0,'44',NULL),('273',50,0,'44',NULL),('274',51,0,'44',NULL),('275',64,0,'44',NULL),('276',47,0,'45',NULL),('277',50,0,'45',NULL),('278',51,0,'45',NULL),('279',64,0,'45',NULL),('280',47,0,'46',NULL),('281',50,0,'46',NULL),('282',51,0,'46',NULL),('283',64,0,'46',NULL),('284',47,0,'47',NULL),('285',50,0,'47',NULL),('286',51,0,'47',NULL),('287',64,0,'47',NULL),('288',47,0,'48',NULL),('289',50,0,'48',NULL),('290',51,0,'48',NULL),('291',64,0,'48',NULL),('292',47,0,'42',NULL),('293',50,0,'42',NULL),('294',51,0,'42',NULL),('295',64,0,'42',NULL),('296',47,0,'49',NULL),('297',50,0,'49',NULL),('298',51,0,'49',NULL),('299',64,0,'49',NULL),('300',47,0,'50',NULL),('301',50,0,'50',NULL),('302',51,0,'50',NULL),('303',64,0,'50',NULL),('304',47,0,'51',NULL),('305',50,0,'51',NULL),('306',51,0,'51',NULL),('307',64,0,'51',NULL),('308',47,0,'52',NULL),('309',50,0,'52',NULL),('310',51,0,'52',NULL),('311',64,0,'52',NULL),('312',47,0,'53',NULL),('313',50,0,'53',NULL),('314',51,0,'53',NULL),('315',64,0,'53',NULL),('316',47,0,'54',NULL),('317',50,0,'54',NULL),('318',51,0,'54',NULL),('319',64,0,'54',NULL),('320',47,0,'55',NULL),('321',50,0,'55',NULL),('322',51,0,'55',NULL),('323',64,0,'55',NULL),('324',47,0,'56',NULL),('325',50,0,'56',NULL),('326',51,0,'56',NULL),('327',64,0,'56',NULL),('328',47,0,'57',NULL),('329',50,0,'57',NULL),('330',51,0,'57',NULL),('331',64,0,'57',NULL),('332',47,0,'58',NULL),('333',50,0,'58',NULL),('334',51,0,'58',NULL),('335',64,0,'58',NULL),('336',47,0,'38',NULL),('337',50,0,'38',NULL),('338',51,0,'38',NULL),('339',64,0,'38',NULL),('340',47,0,'59',NULL),('341',50,0,'59',NULL),('342',51,0,'59',NULL),('343',64,0,'59',NULL),('344',47,0,'60',NULL),('345',50,0,'60',NULL),('346',51,0,'60',NULL),('347',64,0,'60',NULL),('348',47,0,'61',NULL),('349',50,0,'61',NULL),('350',51,0,'61',NULL),('351',64,0,'61',NULL),('352',47,0,'41',NULL),('353',50,0,'41',NULL),('354',51,0,'41',NULL),('355',64,0,'41',NULL),('387',47,0,'62',NULL),('388',50,0,'62',NULL),('389',51,0,'62',NULL),('390',64,0,'62',NULL),('391',47,0,'73',NULL),('392',50,0,'73',NULL),('393',51,0,'73',NULL),('394',64,0,'73',NULL),('395',47,0,'74',NULL),('396',50,0,'74',NULL),('397',51,0,'74',NULL),('398',64,0,'74',NULL),('399',47,0,'75',NULL),('400',50,0,'75',NULL),('401',51,0,'75',NULL),('402',64,0,'75',NULL),('403',47,0,'76',NULL),('404',50,0,'76',NULL),('405',51,0,'76',NULL),('406',64,0,'76',NULL),('407',47,0,'64',NULL),('408',50,0,'64',NULL),('409',51,0,'64',NULL),('410',64,0,'64',NULL),('411',47,0,'77',NULL),('412',50,0,'77',NULL),('413',51,0,'77',NULL),('414',64,0,'77',NULL),('415',47,0,'78',NULL),('416',50,0,'78',NULL),('417',51,0,'78',NULL),('418',64,0,'78',NULL),('419',47,0,'79',NULL),('420',50,0,'79',NULL),('421',51,0,'79',NULL),('422',64,0,'79',NULL),('423',47,0,'80',NULL),('424',50,0,'80',NULL),('425',51,0,'80',NULL),('426',64,0,'80',NULL),('427',47,0,'65',NULL),('428',50,0,'65',NULL),('429',51,0,'65',NULL),('430',64,0,'65',NULL),('431',47,0,'81',NULL),('432',50,0,'81',NULL),('433',51,0,'81',NULL),('434',64,0,'81',NULL),('435',47,0,'82',NULL),('436',50,0,'82',NULL),('437',51,0,'82',NULL),('438',64,0,'82',NULL),('439',47,0,'83',NULL),('440',50,0,'83',NULL),('441',51,0,'83',NULL),('442',64,0,'83',NULL),('443',47,0,'84',NULL),('444',50,0,'84',NULL),('445',51,0,'84',NULL),('446',64,0,'84',NULL),('447',47,0,'66',NULL),('448',50,0,'66',NULL),('449',51,0,'66',NULL),('450',64,0,'66',NULL),('451',47,0,'67',NULL),('452',50,0,'67',NULL),('453',51,0,'67',NULL),('454',64,0,'67',NULL),('455',47,0,'85',NULL),('456',50,0,'85',NULL),('457',51,0,'85',NULL),('458',64,0,'85',NULL),('459',47,0,'86',NULL),('460',50,0,'86',NULL),('461',51,0,'86',NULL),('462',64,0,'86',NULL),('463',47,0,'87',NULL),('464',50,0,'87',NULL),('465',51,0,'87',NULL),('466',64,0,'87',NULL),('467',47,0,'88',NULL),('468',50,0,'88',NULL),('469',51,0,'88',NULL),('470',64,0,'88',NULL),('471',47,0,'68',NULL),('472',50,0,'68',NULL),('473',51,0,'68',NULL),('474',64,0,'68',NULL),('475',47,0,'69',NULL),('476',50,0,'69',NULL),('477',51,0,'69',NULL),('478',64,0,'69',NULL),('479',47,0,'70',NULL),('480',50,0,'70',NULL),('481',51,0,'70',NULL),('482',64,0,'70',NULL),('483',47,0,'71',NULL),('484',50,0,'71',NULL),('485',51,0,'71',NULL),('486',64,0,'71',NULL),('487',47,0,'72',NULL),('488',50,0,'72',NULL),('489',51,0,'72',NULL),('490',64,0,'72',NULL),('560',47,0,'90',NULL),('561',50,0,'90',NULL),('562',51,0,'90',NULL),('563',64,0,'90',NULL),('564',47,0,'100',NULL),('565',50,0,'100',NULL),('566',51,0,'100',NULL),('567',64,0,'100',NULL),('568',47,0,'101',NULL),('569',50,0,'101',NULL),('570',51,0,'101',NULL),('571',64,0,'101',NULL),('572',47,0,'102',NULL),('573',50,0,'102',NULL),('574',51,0,'102',NULL),('575',64,0,'102',NULL),('576',47,0,'91',NULL),('577',50,0,'91',NULL),('578',51,0,'91',NULL),('579',64,0,'91',NULL),('580',47,0,'93',NULL),('581',50,0,'93',NULL),('582',51,0,'93',NULL),('583',64,0,'93',NULL),('588',47,0,'94',NULL),('589',50,0,'94',NULL),('590',51,0,'94',NULL),('591',64,0,'94',NULL),('592',47,0,'95',NULL),('593',50,0,'95',NULL),('594',51,0,'95',NULL),('595',64,0,'95',NULL),('596',47,0,'96',NULL),('597',50,0,'96',NULL),('598',51,0,'96',NULL),('599',64,0,'96',NULL),('600',47,0,'97',NULL),('601',50,0,'97',NULL),('602',51,0,'97',NULL),('603',64,0,'97',NULL),('604',47,0,'98',NULL),('605',50,0,'98',NULL),('606',51,0,'98',NULL),('607',64,0,'98',NULL),('608',47,0,'99',NULL),('609',50,0,'99',NULL),('610',51,0,'99',NULL),('611',64,0,'99',NULL),('636',47,13,'2',NULL),('637',50,13,'2',NULL),('638',51,13,'2',NULL),('639',64,13,'2',NULL),('647',47,13,'4',NULL),('648',50,13,'4',NULL),('649',51,13,'4',NULL),('650',64,13,'4',NULL),('651',47,13,'9',NULL),('652',50,13,'9',NULL),('653',51,13,'9',NULL),('654',64,13,'9',NULL),('655',47,13,'5',NULL),('656',50,13,'5',NULL),('657',51,13,'5',NULL),('658',64,13,'5',NULL),('659',47,13,'6',NULL),('660',50,13,'6',NULL),('661',51,13,'6',NULL),('662',64,13,'6',NULL),('663',47,13,'7',NULL),('664',50,13,'7',NULL),('665',51,13,'7',NULL),('666',64,13,'7',NULL),('667',47,13,'8',NULL),('668',50,13,'8',NULL),('669',51,13,'8',NULL),('670',64,13,'8',NULL),('671',47,13,'10',NULL),('672',50,13,'10',NULL),('673',51,13,'10',NULL),('674',64,13,'10',NULL),('675',47,13,'11',NULL),('676',50,13,'11',NULL),('677',51,13,'11',NULL),('678',64,13,'11',NULL),('679',47,13,'12',NULL),('680',50,13,'12',NULL),('681',51,13,'12',NULL),('682',64,13,'12',NULL);
/*!40000 ALTER TABLE `catalog_category_entity_text` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_entity_varchar`
--

DROP TABLE IF EXISTS `catalog_category_entity_varchar`;
CREATE TABLE `catalog_category_entity_varchar` (
  `value_id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `attribute_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `value` varchar(255) DEFAULT NULL COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `CATALOG_CATEGORY_ENTITY_VARCHAR_ENTITY_ID_ATTRIBUTE_ID_STORE_ID` (`entity_id`,`attribute_id`,`store_id`),
  KEY `CATALOG_CATEGORY_ENTITY_VARCHAR_ENTITY_ID` (`entity_id`),
  KEY `CATALOG_CATEGORY_ENTITY_VARCHAR_ATTRIBUTE_ID` (`attribute_id`),
  KEY `CATALOG_CATEGORY_ENTITY_VARCHAR_STORE_ID` (`store_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2175 DEFAULT CHARSET=utf8 COMMENT='Catalog Category Varchar Attribute Backend Table';

--
-- Dumping data for table `catalog_category_entity_varchar`
--

LOCK TABLES `catalog_category_entity_varchar` WRITE;
/*!40000 ALTER TABLE `catalog_category_entity_varchar` DISABLE KEYS */;
INSERT INTO `catalog_category_entity_varchar` VALUES ('1',45,0,'1','Root Catalog'),('2',45,0,'2','CHS products'),('3',52,0,'2','PRODUCTS'),('8',45,0,'4','Laptop & Computer'),('9',52,0,'4','PRODUCTS'),('10',117,0,'4','laptop-computer'),('11',118,0,'4','laptop-computer'),('12',45,0,'5','TV & Audio'),('13',52,0,'5','PRODUCTS'),('14',117,0,'5','tv-audio'),('15',118,0,'5','tv-audio'),('16',45,0,'6','Camera & Photo'),('17',52,0,'6','PRODUCTS'),('18',117,0,'6','camera-photo'),('19',118,0,'6','camera-photo'),('20',45,0,'7','Consoles & Games'),('21',52,0,'7','PRODUCTS'),('22',117,0,'7','consoles-games'),('23',118,0,'7','consoles-games'),('24',45,0,'8','Home Appliancces'),('25',52,0,'8','PRODUCTS'),('26',117,0,'8','home-appliancces'),('27',118,0,'8','home-appliancces'),('28',45,0,'9','Test jurian'),('29',52,0,'9','PRODUCTS'),('30',117,0,'9','car-electronic-gps'),('31',118,0,'9','car-electronic-gps'),('32',45,0,'10','Smart Phones & Tablets'),('33',52,0,'10','PRODUCTS'),('34',117,0,'10','smart-phones-tablets'),('35',118,0,'10','smart-phones-tablets'),('36',45,0,'11','Virtual Reality'),('37',52,0,'11','PRODUCTS'),('38',117,0,'11','virtual-reality'),('39',118,0,'11','virtual-reality'),('40',45,0,'12','Category Jurian'),('41',52,0,'12','PRODUCTS'),('42',117,0,'12','minigame'),('43',118,0,'12','minigame'),('128',45,0,'34','Foods'),('129',52,0,'34','PRODUCTS'),('130',117,0,'34','foot'),('131',45,0,'35','Fruits & Vegetables'),('132',52,0,'35','PRODUCTS'),('133',117,0,'35','fruits-vegetables'),('134',118,0,'35','fruits-vegetables'),('135',45,0,'36','Grocery & Staples'),('136',52,0,'36','PRODUCTS'),('137',117,0,'36','grocery-staples'),('138',118,0,'36','grocery-staples'),('139',45,0,'37','Breakfast & Dairy'),('140',52,0,'37','PRODUCTS'),('141',117,0,'37','breakfast-dairy'),('142',118,0,'37','breakfast-dairy'),('143',45,0,'38','Biscuits, Snacks'),('144',52,0,'38','PRODUCTS'),('145',117,0,'38','biscuits-snacks'),('146',118,0,'38','biscuits-snacks'),('147',48,0,'34',NULL),('148',49,0,'34',NULL),('149',60,0,'34',NULL),('150',63,0,'34',NULL),('152',135,0,'34',NULL),('153',138,0,'34',NULL),('154',141,0,'34',NULL),('155',45,0,'39','Meats & Seafood'),('156',52,0,'39','PRODUCTS'),('157',117,0,'39','meats-seafood'),('158',118,0,'39','meats-seafood'),('159',45,0,'40','Vegetables'),('160',52,0,'40','PRODUCTS'),('161',117,0,'40','vegetables'),('162',118,0,'40','fruits-vegetables/vegetables'),('163',45,0,'41','Oganic Food'),('164',52,0,'41','PRODUCTS'),('165',117,0,'41','oganic-food'),('166',118,0,'41','oganic-food'),('167',45,0,'42','Imported Fruits'),('168',52,0,'42','PRODUCTS'),('169',117,0,'42','imported-fruits'),('170',118,0,'42','fruits-vegetables/imported-fruits'),('171',45,0,'43','Juice'),('172',52,0,'43','PRODUCTS'),('173',117,0,'43','fresh-snacks'),('174',118,0,'43','fruits-vegetables/fresh-snacks'),('175',45,0,'44','Fresh Carrots'),('176',52,0,'44','PRODUCTS'),('177',117,0,'44','fresh-carrots'),('178',118,0,'44','fruits-vegetables/vegetables/fresh-carrots'),('179',45,0,'45','Fresh Avocados'),('180',52,0,'45','PRODUCTS'),('181',117,0,'45','fresh-avocados'),('182',118,0,'45','fruits-vegetables/vegetables/fresh-avocados'),('183',45,0,'46','Frozen Vegetables'),('184',52,0,'46','PRODUCTS'),('185',117,0,'46','frozen-vegetables'),('186',118,0,'46','fruits-vegetables/vegetables/frozen-vegetables'),('187',45,0,'47','Fresh Lettuce'),('188',52,0,'47','PRODUCTS'),('189',117,0,'47','fresh-lettuce'),('190',118,0,'47','fruits-vegetables/vegetables/fresh-lettuce'),('191',45,0,'48','Fresh Onions'),('192',52,0,'48','PRODUCTS'),('193',117,0,'48','fresh-onions'),('194',118,0,'48','fruits-vegetables/vegetables/fresh-onions'),('195',45,0,'49','Exotic Fruits'),('196',52,0,'49','PRODUCTS'),('197',117,0,'49','exotic-fruits'),('198',118,0,'49','fruits-vegetables/imported-fruits/exotic-fruits'),('199',45,0,'50','Fresh Pears'),('200',52,0,'50','PRODUCTS'),('201',117,0,'50','fresh-pears'),('202',118,0,'50','fruits-vegetables/imported-fruits/fresh-pears'),('203',45,0,'51','Fruit & Nut Gifts'),('204',52,0,'51','PRODUCTS'),('205',117,0,'51','fruit-nut-gifts'),('206',118,0,'51','fruits-vegetables/imported-fruits/fruit-nut-gifts'),('207',45,0,'52','Fresh Fruits'),('208',52,0,'52','PRODUCTS'),('209',117,0,'52','fresh-fruits'),('210',118,0,'52','fruits-vegetables/imported-fruits/fresh-fruits'),('211',45,0,'53','Fresh Lemons'),('212',52,0,'53','PRODUCTS'),('213',117,0,'53','fresh-lemons'),('214',118,0,'53','fruits-vegetables/imported-fruits/fresh-lemons'),('215',45,0,'54','Fruit Juice'),('216',52,0,'54','PRODUCTS'),('217',117,0,'54','fruit-juice'),('218',118,0,'54','fruits-vegetables/fresh-snacks/fruit-juice'),('220',48,0,'43',NULL),('221',49,0,'43',NULL),('222',60,0,'43',NULL),('223',63,0,'43',NULL),('224',135,0,'43',NULL),('225',138,0,'43',NULL),('226',141,0,'43',NULL),('227',45,0,'55','Vegetable Juice'),('228',52,0,'55','PRODUCTS'),('229',117,0,'55','vegetable-juice'),('230',118,0,'55','fruits-vegetables/fresh-snacks/vegetable-juice'),('231',45,0,'56','Sparkling Juice'),('232',52,0,'56','PRODUCTS'),('233',117,0,'56','sparkling-juice'),('234',118,0,'56','fruits-vegetables/fresh-snacks/sparkling-juice'),('235',45,0,'57','Lemonade'),('236',52,0,'57','PRODUCTS'),('237',117,0,'57','lemonade'),('238',118,0,'57','fruits-vegetables/fresh-snacks/lemonade'),('239',45,0,'58','Ciders'),('240',52,0,'58','PRODUCTS'),('241',117,0,'58','ciders'),('242',118,0,'58','fruits-vegetables/fresh-snacks/ciders'),('243',45,0,'59','Meat Spices'),('244',52,0,'59','PRODUCTS'),('245',117,0,'59','meat-spices'),('246',118,0,'59','meats-seafood/meat-spices'),('247',45,0,'60','Frozen Food'),('248',52,0,'60','PRODUCTS'),('249',117,0,'60','frozen-food'),('250',118,0,'60','meats-seafood/frozen-food'),('251',45,0,'61','Seafood'),('252',52,0,'61','PRODUCTS'),('253',117,0,'61','seafood'),('254',118,0,'61','meats-seafood/seafood'),('255',45,0,'62','Furniture'),('256',52,0,'62','PRODUCTS'),('257',117,0,'62','furniture'),('258',45,0,'63','Living Room'),('259',52,0,'63','PRODUCTS'),('260',117,0,'63','living-room'),('261',118,0,'63','living-room'),('262',45,0,'64','Dining Room'),('263',52,0,'64','PRODUCTS'),('264',117,0,'64','dining-room'),('265',118,0,'64','dining-room'),('266',45,0,'65','Bed Room'),('267',52,0,'65','PRODUCTS'),('268',117,0,'65','bed-room'),('269',118,0,'65','bed-room'),('270',45,0,'66','Entertainment'),('271',52,0,'66','PRODUCTS'),('272',117,0,'66','entertainment'),('273',118,0,'66','entertainment'),('274',45,0,'67','Home Office'),('275',52,0,'67','PRODUCTS'),('276',117,0,'67','home-office'),('277',118,0,'67','home-office'),('278',45,0,'68','Tables'),('279',52,0,'68','PRODUCTS'),('280',117,0,'68','tables'),('281',118,0,'68','tables'),('282',45,0,'69','Accent Furniture'),('283',52,0,'69','PRODUCTS'),('284',117,0,'69','accent-furniture'),('285',118,0,'69','accent-furniture'),('286',45,0,'70','Mattress Sets'),('287',52,0,'70','PRODUCTS'),('288',117,0,'70','mattress-sets'),('289',118,0,'70','mattress-sets'),('290',45,0,'71','Small Appliances'),('291',52,0,'71','PRODUCTS'),('292',117,0,'71','small-appliances'),('293',118,0,'71','small-appliances'),('294',45,0,'72','Outdoor'),('295',52,0,'72','PRODUCTS'),('296',117,0,'72','outdoor'),('297',118,0,'72','outdoor'),('298',45,0,'73','Sofas'),('299',52,0,'73','PRODUCTS'),('300',117,0,'73','sofas'),('301',118,0,'73','living-room/sofas'),('302',45,0,'74','Loveseats'),('303',52,0,'74','PRODUCTS'),('304',117,0,'74','loveseats'),('305',118,0,'74','living-room/loveseats'),('306',45,0,'75','Sectionals'),('307',52,0,'75','PRODUCTS'),('308',117,0,'75','sectionals'),('309',118,0,'75','living-room/sectionals'),('310',45,0,'76','Chairs & Chaises'),('311',52,0,'76','PRODUCTS'),('312',117,0,'76','chairs-chaises'),('313',118,0,'76','living-room/chairs-chaises'),('314',45,0,'77','Dining Sets'),('315',52,0,'77','PRODUCTS'),('316',117,0,'77','dining-sets'),('317',118,0,'77','dining-room/dining-sets'),('318',45,0,'78','Dining Tables'),('319',52,0,'78','PRODUCTS'),('320',117,0,'78','dining-tables'),('321',118,0,'78','dining-room/dining-tables'),('322',45,0,'79','Chairs'),('323',52,0,'79','PRODUCTS'),('324',117,0,'79','chairs'),('325',118,0,'79','dining-room/chairs'),('326',45,0,'80','Benches'),('327',52,0,'80','PRODUCTS'),('328',117,0,'80','benches'),('329',118,0,'80','dining-room/benches'),('330',45,0,'81','King Beds'),('331',52,0,'81','PRODUCTS'),('332',117,0,'81','king-beds'),('333',118,0,'81','bed-room/king-beds'),('334',45,0,'82','Daybeds & Futons'),('335',52,0,'82','PRODUCTS'),('336',117,0,'82','daybeds-futons'),('337',118,0,'82','bed-room/daybeds-futons'),('338',45,0,'83','Queen Beds'),('339',52,0,'83','PRODUCTS'),('340',117,0,'83','queen-beds'),('341',118,0,'83','bed-room/queen-beds'),('342',45,0,'84','Full Beds'),('343',52,0,'84','PRODUCTS'),('344',117,0,'84','full-beds'),('345',118,0,'84','bed-room/full-beds'),('346',45,0,'85','Desks'),('347',52,0,'85','PRODUCTS'),('348',117,0,'85','desks'),('349',118,0,'85','home-office/desks'),('350',45,0,'86','Chairs'),('351',52,0,'86','PRODUCTS'),('352',117,0,'86','chairs'),('353',118,0,'86','home-office/chairs'),('354',45,0,'87','Filing Cabinets'),('355',52,0,'87','PRODUCTS'),('356',117,0,'87','filing-cabinets'),('357',118,0,'87','home-office/filing-cabinets'),('358',45,0,'88','Bookcases'),('359',52,0,'88','PRODUCTS'),('360',117,0,'88','bookcases'),('361',118,0,'88','home-office/bookcases'),('362',45,0,'89','Houseware'),('363',52,0,'89','PRODUCTS'),('364',117,0,'89','home-electric'),('365',48,0,'89',NULL),('366',49,0,'89',NULL),('367',60,0,'89',NULL),('368',63,0,'89',NULL),('370',135,0,'89',NULL),('371',138,0,'89',NULL),('372',141,0,'89',NULL),('373',45,0,'90','Cookware'),('374',52,0,'90','PRODUCTS'),('375',117,0,'90','cookware'),('376',118,0,'90','cookware'),('377',45,0,'91','Electrical & Appliances'),('378',52,0,'91','PRODUCTS'),('379',117,0,'91','electrical-appliances'),('380',118,0,'91','electrical-appliances'),('385',45,0,'93','Knife Sets'),('386',52,0,'93','PRODUCTS'),('387',117,0,'93','knife-sets'),('388',118,0,'93','knife-sets'),('389',45,0,'94','Egg Poachers'),('390',52,0,'94','PRODUCTS'),('391',117,0,'94','egg-poachers'),('392',118,0,'94','egg-poachers'),('393',45,0,'95','Crepe Pans'),('394',52,0,'95','PRODUCTS'),('395',117,0,'95','crepe-pans'),('396',118,0,'95','crepe-pans'),('397',45,0,'96','Tableware'),('398',52,0,'96','PRODUCTS'),('399',117,0,'96','tableware'),('400',118,0,'96','tableware'),('401',45,0,'97','Stand Mixers'),('402',52,0,'97','PRODUCTS'),('403',117,0,'97','stand-mixers'),('404',118,0,'97','stand-mixers'),('405',45,0,'98','Barware'),('406',52,0,'98','PRODUCTS'),('407',117,0,'98','barware'),('408',118,0,'98','barware'),('409',45,0,'99','Coffee Machine'),('410',52,0,'99','PRODUCTS'),('411',117,0,'99','coffee-machine'),('412',118,0,'99','coffee-machine'),('413',45,0,'100','Cookware Sets'),('414',52,0,'100','PRODUCTS'),('415',117,0,'100','cookware-sets'),('416',118,0,'100','cookware/cookware-sets'),('417',45,0,'101','Egg Poachers'),('418',52,0,'101','PRODUCTS'),('419',117,0,'101','egg-poachers'),('420',118,0,'101','cookware/egg-poachers'),('421',45,0,'102','Frying Pans'),('422',52,0,'102','PRODUCTS'),('423',117,0,'102','frying-pans'),('424',118,0,'102','cookware/frying-pans'),('425',48,0,'2',NULL),('426',49,0,'2',NULL),('427',60,0,'2',NULL),('428',63,0,'2',NULL),('429',117,0,'2','digital'),('431',135,0,'2',NULL),('432',138,0,'2',NULL),('433',141,0,'2',NULL),('455',48,0,'4',NULL),('456',49,0,'4',NULL),('457',60,0,'4',NULL),('458',63,0,'4',NULL),('459',135,0,'4',NULL),('460',138,0,'4',NULL),('461',141,0,'4',NULL),('463',48,0,'6',NULL),('464',49,0,'6',NULL),('465',60,0,'6',NULL),('466',63,0,'6',NULL),('467',135,0,'6',NULL),('468',138,0,'6',NULL),('469',141,0,'6',NULL),('471',48,0,'7',NULL),('472',49,0,'7',NULL),('473',60,0,'7',NULL),('474',63,0,'7',NULL),('475',135,0,'7',NULL),('476',138,0,'7',NULL),('477',141,0,'7','cate2.png'),('481',48,0,'5',NULL),('482',49,0,'5',NULL),('483',60,0,'5',NULL),('484',63,0,'5',NULL),('485',135,0,'5',NULL),('486',138,0,'5',NULL),('487',141,0,'5',NULL),('489',48,0,'8',NULL),('490',49,0,'8',NULL),('491',60,0,'8',NULL),('492',63,0,'8',NULL),('493',135,0,'8',NULL),('494',138,0,'8',NULL),('495',141,0,'8',NULL),('497',48,0,'9',NULL),('498',49,0,'9',NULL),('499',60,0,'9',NULL),('500',63,0,'9',NULL),('501',135,0,'9',NULL),('502',138,0,'9',NULL),('503',141,0,'9',NULL),('505',48,0,'10',NULL),('506',49,0,'10',NULL),('507',60,0,'10',NULL),('508',63,0,'10',NULL),('509',135,0,'10',NULL),('510',138,0,'10',NULL),('511',141,0,'10',NULL),('513',48,0,'11',NULL),('514',49,0,'11',NULL),('515',60,0,'11',NULL),('516',63,0,'11',NULL),('517',135,0,'11',NULL),('518',138,0,'11',NULL),('519',141,0,'11',NULL),('521',48,0,'12',NULL),('522',49,0,'12',NULL),('523',60,0,'12',NULL),('524',63,0,'12',NULL),('525',135,0,'12',NULL),('526',138,0,'12',NULL),('527',141,0,'12',NULL),('584',48,0,'35',NULL),('585',49,0,'35',NULL),('586',60,0,'35',NULL),('587',63,0,'35',NULL),('588',135,0,'35',NULL),('589',138,0,'35',NULL),('590',141,0,'35','cateh2-1.png'),('592',48,0,'36',NULL),('593',49,0,'36',NULL),('594',60,0,'36',NULL),('595',63,0,'36',NULL),('596',135,0,'36',NULL),('597',138,0,'36',NULL),('598',141,0,'36','cateh2-2.png'),('600',48,0,'37',NULL),('601',49,0,'37',NULL),('602',60,0,'37',NULL),('603',63,0,'37',NULL),('604',135,0,'37',NULL),('605',138,0,'37',NULL),('606',141,0,'37','cateh2-3.png'),('608',48,0,'39',NULL),('609',49,0,'39',NULL),('610',60,0,'39',NULL),('611',63,0,'39',NULL),('612',135,0,'39',NULL),('613',138,0,'39',NULL),('614',141,0,'39','cateh2-5.png'),('969',118,1,'5','tv-audio'),('970',48,1,'5',NULL),('971',49,1,'5',NULL),('972',52,1,'5','PRODUCTS'),('973',60,1,'5',NULL),('974',63,1,'5',NULL),('975',117,1,'5','tv-audio'),('976',135,1,'5',NULL),('977',138,1,'5',NULL),('978',141,1,'5',NULL),('979',118,1,'6','camera-photo'),('980',48,1,'6',NULL),('981',49,1,'6',NULL),('982',52,1,'6','PRODUCTS'),('983',60,1,'6',NULL),('984',63,1,'6',NULL),('985',117,1,'6','camera-photo'),('986',135,1,'6',NULL),('987',138,1,'6',NULL),('988',141,1,'6',NULL),('1029',118,1,'7','consoles-games'),('1030',48,1,'7',NULL),('1031',49,1,'7',NULL),('1032',52,1,'7','PRODUCTS'),('1033',60,1,'7',NULL),('1034',63,1,'7',NULL),('1035',117,1,'7','consoles-games'),('1036',135,1,'7',NULL),('1037',138,1,'7',NULL),('1038',141,1,'7','cate2.png'),('1082',118,0,'34',NULL),('1084',48,0,'63',NULL),('1085',49,0,'63',NULL),('1086',60,0,'63',NULL),('1087',63,0,'63',NULL),('1088',135,0,'63',NULL),('1089',138,0,'63',NULL),('1090',141,0,'63',NULL),('1093',48,0,'40',NULL),('1094',49,0,'40',NULL),('1095',60,0,'40',NULL),('1096',63,0,'40',NULL),('1097',135,0,'40',NULL),('1098',138,0,'40',NULL),('1099',141,0,'40',NULL),('1101',48,0,'44',NULL),('1102',49,0,'44',NULL),('1103',60,0,'44',NULL),('1104',63,0,'44',NULL),('1105',135,0,'44',NULL),('1106',138,0,'44',NULL),('1107',141,0,'44',NULL),('1109',48,0,'45',NULL),('1110',49,0,'45',NULL),('1111',60,0,'45',NULL),('1112',63,0,'45',NULL),('1113',135,0,'45',NULL),('1114',138,0,'45',NULL),('1115',141,0,'45',NULL),('1117',48,0,'46',NULL),('1118',49,0,'46',NULL),('1119',60,0,'46',NULL),('1120',63,0,'46',NULL),('1121',135,0,'46',NULL),('1122',138,0,'46',NULL),('1123',141,0,'46',NULL),('1125',48,0,'47',NULL),('1126',49,0,'47',NULL),('1127',60,0,'47',NULL),('1128',63,0,'47',NULL),('1129',135,0,'47',NULL),('1130',138,0,'47',NULL),('1131',141,0,'47',NULL),('1133',48,0,'48',NULL),('1134',49,0,'48',NULL),('1135',60,0,'48',NULL),('1136',63,0,'48',NULL),('1137',135,0,'48',NULL),('1138',138,0,'48',NULL),('1139',141,0,'48',NULL),('1141',48,0,'42',NULL),('1142',49,0,'42',NULL),('1143',60,0,'42',NULL),('1144',63,0,'42',NULL),('1145',135,0,'42',NULL),('1146',138,0,'42',NULL),('1147',141,0,'42',NULL),('1149',48,0,'49',NULL),('1150',49,0,'49',NULL),('1151',60,0,'49',NULL),('1152',63,0,'49',NULL),('1153',135,0,'49',NULL),('1154',138,0,'49',NULL),('1155',141,0,'49',NULL),('1157',48,0,'50',NULL),('1158',49,0,'50',NULL),('1159',60,0,'50',NULL),('1160',63,0,'50',NULL),('1161',135,0,'50',NULL),('1162',138,0,'50',NULL),('1163',141,0,'50',NULL),('1165',48,0,'51',NULL),('1166',49,0,'51',NULL),('1167',60,0,'51',NULL),('1168',63,0,'51',NULL),('1169',135,0,'51',NULL),('1170',138,0,'51',NULL),('1171',141,0,'51',NULL),('1173',48,0,'52',NULL),('1174',49,0,'52',NULL),('1175',60,0,'52',NULL),('1176',63,0,'52',NULL),('1177',135,0,'52',NULL),('1178',138,0,'52',NULL),('1179',141,0,'52',NULL),('1181',48,0,'53',NULL),('1182',49,0,'53',NULL),('1183',60,0,'53',NULL),('1184',63,0,'53',NULL),('1185',135,0,'53',NULL),('1186',138,0,'53',NULL),('1187',141,0,'53',NULL),('1190',48,0,'54',NULL),('1191',49,0,'54',NULL),('1192',60,0,'54',NULL),('1193',63,0,'54',NULL),('1194',135,0,'54',NULL),('1195',138,0,'54',NULL),('1196',141,0,'54',NULL),('1198',48,0,'55',NULL),('1199',49,0,'55',NULL),('1200',60,0,'55',NULL),('1201',63,0,'55',NULL),('1202',135,0,'55',NULL),('1203',138,0,'55',NULL),('1204',141,0,'55',NULL),('1206',48,0,'56',NULL),('1207',49,0,'56',NULL),('1208',60,0,'56',NULL),('1209',63,0,'56',NULL),('1210',135,0,'56',NULL),('1211',138,0,'56',NULL),('1212',141,0,'56',NULL),('1214',48,0,'57',NULL),('1215',49,0,'57',NULL),('1216',60,0,'57',NULL),('1217',63,0,'57',NULL),('1218',135,0,'57',NULL),('1219',138,0,'57',NULL),('1220',141,0,'57',NULL),('1222',48,0,'58',NULL),('1223',49,0,'58',NULL),('1224',60,0,'58',NULL),('1225',63,0,'58',NULL),('1226',135,0,'58',NULL),('1227',138,0,'58',NULL),('1228',141,0,'58',NULL),('1232',48,0,'38',NULL),('1233',49,0,'38',NULL),('1234',60,0,'38',NULL),('1235',63,0,'38',NULL),('1236',135,0,'38',NULL),('1237',138,0,'38',NULL),('1238',141,0,'38','cateh2-4_1.png'),('1241',48,0,'59',NULL),('1242',49,0,'59',NULL),('1243',60,0,'59',NULL),('1244',63,0,'59',NULL),('1245',135,0,'59',NULL),('1246',138,0,'59',NULL),('1247',141,0,'59',NULL),('1249',48,0,'60',NULL),('1250',49,0,'60',NULL),('1251',60,0,'60',NULL),('1252',63,0,'60',NULL),('1253',135,0,'60',NULL),('1254',138,0,'60',NULL),('1255',141,0,'60',NULL),('1257',48,0,'61',NULL),('1258',49,0,'61',NULL),('1259',60,0,'61',NULL),('1260',63,0,'61',NULL),('1261',135,0,'61',NULL),('1262',138,0,'61',NULL),('1263',141,0,'61',NULL),('1265',48,0,'41',NULL),('1266',49,0,'41',NULL),('1267',60,0,'41',NULL),('1268',63,0,'41',NULL),('1269',135,0,'41',NULL),('1270',138,0,'41',NULL),('1271',141,0,'41','cateh2-1.png'),('1374',48,0,'62',NULL),('1375',49,0,'62',NULL),('1376',60,0,'62',NULL),('1377',63,0,'62',NULL),('1378',118,0,'62',NULL),('1379',135,0,'62',NULL),('1380',138,0,'62',NULL),('1381',141,0,'62',NULL),('1383',48,0,'73',NULL),('1384',49,0,'73',NULL),('1385',60,0,'73',NULL),('1386',63,0,'73',NULL),('1387',135,0,'73',NULL),('1388',138,0,'73',NULL),('1389',141,0,'73',NULL),('1391',48,0,'74',NULL),('1392',49,0,'74',NULL),('1393',60,0,'74',NULL),('1394',63,0,'74',NULL),('1395',135,0,'74',NULL),('1396',138,0,'74',NULL),('1397',141,0,'74',NULL),('1399',48,0,'75',NULL),('1400',49,0,'75',NULL),('1401',60,0,'75',NULL),('1402',63,0,'75',NULL),('1403',135,0,'75',NULL),('1404',138,0,'75',NULL),('1405',141,0,'75',NULL),('1407',48,0,'76',NULL),('1408',49,0,'76',NULL),('1409',60,0,'76',NULL),('1410',63,0,'76',NULL),('1411',135,0,'76',NULL),('1412',138,0,'76',NULL),('1413',141,0,'76',NULL),('1415',48,0,'64',NULL),('1416',49,0,'64',NULL),('1417',60,0,'64',NULL),('1418',63,0,'64',NULL),('1419',135,0,'64',NULL),('1420',138,0,'64',NULL),('1421',141,0,'64',NULL),('1423',48,0,'77',NULL),('1424',49,0,'77',NULL),('1425',60,0,'77',NULL),('1426',63,0,'77',NULL),('1427',135,0,'77',NULL),('1428',138,0,'77',NULL),('1429',141,0,'77',NULL),('1431',48,0,'78',NULL),('1432',49,0,'78',NULL),('1433',60,0,'78',NULL),('1434',63,0,'78',NULL),('1435',135,0,'78',NULL),('1436',138,0,'78',NULL),('1437',141,0,'78',NULL),('1439',48,0,'79',NULL),('1440',49,0,'79',NULL),('1441',60,0,'79',NULL),('1442',63,0,'79',NULL),('1443',135,0,'79',NULL),('1444',138,0,'79',NULL),('1445',141,0,'79',NULL),('1447',48,0,'80',NULL),('1448',49,0,'80',NULL),('1449',60,0,'80',NULL),('1450',63,0,'80',NULL),('1451',135,0,'80',NULL),('1452',138,0,'80',NULL),('1453',141,0,'80',NULL),('1455',48,0,'65',NULL),('1456',49,0,'65',NULL),('1457',60,0,'65',NULL),('1458',63,0,'65',NULL),('1459',135,0,'65',NULL),('1460',138,0,'65',NULL),('1461',141,0,'65',NULL),('1463',48,0,'81',NULL),('1464',49,0,'81',NULL),('1465',60,0,'81',NULL),('1466',63,0,'81',NULL),('1467',135,0,'81',NULL),('1468',138,0,'81',NULL),('1469',141,0,'81',NULL),('1471',48,0,'82',NULL),('1472',49,0,'82',NULL),('1473',60,0,'82',NULL),('1474',63,0,'82',NULL),('1475',135,0,'82',NULL),('1476',138,0,'82',NULL),('1477',141,0,'82',NULL),('1479',48,0,'83',NULL),('1480',49,0,'83',NULL),('1481',60,0,'83',NULL),('1482',63,0,'83',NULL),('1483',135,0,'83',NULL),('1484',138,0,'83',NULL),('1485',141,0,'83',NULL),('1487',48,0,'84',NULL),('1488',49,0,'84',NULL),('1489',60,0,'84',NULL),('1490',63,0,'84',NULL),('1491',135,0,'84',NULL),('1492',138,0,'84',NULL),('1493',141,0,'84',NULL),('1495',48,0,'66',NULL),('1496',49,0,'66',NULL),('1497',60,0,'66',NULL),('1498',63,0,'66',NULL),('1499',135,0,'66',NULL),('1500',138,0,'66',NULL),('1501',141,0,'66',NULL),('1503',48,0,'67',NULL),('1504',49,0,'67',NULL),('1505',60,0,'67',NULL),('1506',63,0,'67',NULL),('1507',135,0,'67',NULL),('1508',138,0,'67',NULL),('1509',141,0,'67',NULL),('1511',48,0,'85',NULL),('1512',49,0,'85',NULL),('1513',60,0,'85',NULL),('1514',63,0,'85',NULL),('1515',135,0,'85',NULL),('1516',138,0,'85',NULL),('1517',141,0,'85',NULL),('1519',48,0,'86',NULL),('1520',49,0,'86',NULL),('1521',60,0,'86',NULL),('1522',63,0,'86',NULL),('1523',135,0,'86',NULL),('1524',138,0,'86',NULL),('1525',141,0,'86',NULL),('1527',48,0,'87',NULL),('1528',49,0,'87',NULL),('1529',60,0,'87',NULL),('1530',63,0,'87',NULL),('1531',135,0,'87',NULL),('1532',138,0,'87',NULL),('1533',141,0,'87',NULL),('1535',48,0,'88',NULL),('1536',49,0,'88',NULL),('1537',60,0,'88',NULL),('1538',63,0,'88',NULL),('1539',135,0,'88',NULL),('1540',138,0,'88',NULL),('1541',141,0,'88',NULL),('1543',48,0,'68',NULL),('1544',49,0,'68',NULL),('1545',60,0,'68',NULL),('1546',63,0,'68',NULL),('1547',135,0,'68',NULL),('1548',138,0,'68',NULL),('1549',141,0,'68',NULL),('1551',48,0,'69',NULL),('1552',49,0,'69',NULL),('1553',60,0,'69',NULL),('1554',63,0,'69',NULL),('1555',135,0,'69',NULL),('1556',138,0,'69',NULL),('1557',141,0,'69',NULL),('1559',48,0,'70',NULL),('1560',49,0,'70',NULL),('1561',60,0,'70',NULL),('1562',63,0,'70',NULL),('1563',135,0,'70',NULL),('1564',138,0,'70',NULL),('1565',141,0,'70',NULL),('1567',48,0,'71',NULL),('1568',49,0,'71',NULL),('1569',60,0,'71',NULL),('1570',63,0,'71',NULL),('1571',135,0,'71',NULL),('1572',138,0,'71',NULL),('1573',141,0,'71',NULL),('1575',48,0,'72',NULL),('1576',49,0,'72',NULL),('1577',60,0,'72',NULL),('1578',63,0,'72',NULL),('1579',135,0,'72',NULL),('1580',138,0,'72',NULL),('1581',141,0,'72',NULL),('1812',118,0,'89',NULL),('1814',48,0,'90',NULL),('1815',49,0,'90',NULL),('1816',60,0,'90',NULL),('1817',63,0,'90',NULL),('1818',135,0,'90',NULL),('1819',138,0,'90',NULL),('1820',141,0,'90',NULL),('1822',48,0,'100',NULL),('1823',49,0,'100',NULL),('1824',60,0,'100',NULL),('1825',63,0,'100',NULL),('1826',135,0,'100',NULL),('1827',138,0,'100','cate1h4.png'),('1828',141,0,'100','cate1h4.png'),('1830',48,0,'101',NULL),('1831',49,0,'101',NULL),('1832',60,0,'101',NULL),('1833',63,0,'101',NULL),('1834',135,0,'101',NULL),('1835',138,0,'101',NULL),('1836',141,0,'101',NULL),('1838',48,0,'102',NULL),('1839',49,0,'102',NULL),('1840',60,0,'102',NULL),('1841',63,0,'102',NULL),('1842',135,0,'102',NULL),('1843',138,0,'102',NULL),('1844',141,0,'102',NULL),('1846',48,0,'91',NULL),('1847',49,0,'91',NULL),('1848',60,0,'91',NULL),('1849',63,0,'91',NULL),('1850',135,0,'91',NULL),('1851',138,0,'91',NULL),('1852',141,0,'91',NULL),('1853',45,0,'109','Stand Mixers '),('1854',52,0,'109','PRODUCTS'),('1855',117,0,'109','stand-mixers'),('1856',118,0,'109','electrical-appliances/stand-mixers'),('1857',45,0,'110','Toasters'),('1858',52,0,'110','PRODUCTS'),('1859',117,0,'110','toasters'),('1860',118,0,'110','electrical-appliances/toasters'),('1861',45,0,'111','Blenders'),('1862',52,0,'111','PRODUCTS'),('1863',117,0,'111','blenders'),('1864',118,0,'111','electrical-appliances/blenders'),('1866',48,0,'93',NULL),('1867',49,0,'93',NULL),('1868',60,0,'93',NULL),('1869',63,0,'93',NULL),('1870',135,0,'93',NULL),('1871',138,0,'93',NULL),('1872',141,0,'93',NULL),('1882',48,0,'94',NULL),('1883',49,0,'94',NULL),('1884',60,0,'94',NULL),('1885',63,0,'94',NULL),('1886',135,0,'94',NULL),('1887',138,0,'94',NULL),('1888',141,0,'94',NULL),('1890',48,0,'95',NULL),('1891',49,0,'95',NULL),('1892',60,0,'95',NULL),('1893',63,0,'95',NULL),('1894',135,0,'95',NULL),('1895',138,0,'95',NULL),('1896',141,0,'95',NULL),('1898',48,0,'96',NULL),('1899',49,0,'96',NULL),('1900',60,0,'96',NULL),('1901',63,0,'96',NULL),('1902',135,0,'96',NULL),('1903',138,0,'96',NULL),('1904',141,0,'96',NULL),('1906',48,0,'97',NULL),('1907',49,0,'97',NULL),('1908',60,0,'97',NULL),('1909',63,0,'97',NULL),('1910',135,0,'97',NULL),('1911',138,0,'97',NULL),('1912',141,0,'97',NULL),('1914',48,0,'98',NULL),('1915',49,0,'98',NULL),('1916',60,0,'98',NULL),('1917',63,0,'98',NULL),('1918',135,0,'98',NULL),('1919',138,0,'98',NULL),('1920',141,0,'98',NULL),('1922',48,0,'99',NULL),('1923',49,0,'99',NULL),('1924',60,0,'99',NULL),('1925',63,0,'99',NULL),('1926',135,0,'99',NULL),('1927',138,0,'99',NULL),('1928',141,0,'99',NULL),('2013',118,13,'100','cookware/cookware-sets'),('2016',48,13,'2',NULL),('2017',49,13,'2',NULL),('2018',52,13,'2','PRODUCTS'),('2019',60,13,'2',NULL),('2020',63,13,'2',NULL),('2021',135,13,'2',NULL),('2022',138,13,'2',NULL),('2023',141,13,'2',NULL),('2048',118,13,'4','notebooks'),('2049',45,13,'4','Notebooks'),('2050',48,13,'4',NULL),('2051',49,13,'4',NULL),('2052',52,13,'4','PRODUCTS'),('2053',60,13,'4',NULL),('2054',63,13,'4',NULL),('2055',117,13,'4','notebooks'),('2056',135,13,'4',NULL),('2057',138,13,'4',NULL),('2058',141,13,'4',NULL),('2059',118,13,'9','ups-backup'),('2060',45,13,'9','UPS & Backup'),('2061',48,13,'9',NULL),('2062',49,13,'9',NULL),('2063',52,13,'9','PRODUCTS'),('2064',60,13,'9',NULL),('2065',63,13,'9',NULL),('2066',117,13,'9','ups-backup'),('2067',135,13,'9',NULL),('2068',138,13,'9',NULL),('2069',141,13,'9',NULL),('2072',118,0,'2',NULL),('2074',118,13,'12','switches'),('2075',118,13,'5','desktops'),('2076',45,13,'5','Desktops'),('2077',48,13,'5',NULL),('2078',49,13,'5',NULL),('2079',52,13,'5','PRODUCTS'),('2080',60,13,'5',NULL),('2081',63,13,'5',NULL),('2082',117,13,'5','desktops'),('2083',135,13,'5',NULL),('2084',138,13,'5',NULL),('2085',141,13,'5',NULL),('2086',118,13,'6','monitors'),('2087',45,13,'6','Monitors'),('2088',48,13,'6',NULL),('2089',49,13,'6',NULL),('2090',52,13,'6','PRODUCTS'),('2091',60,13,'6',NULL),('2092',63,13,'6',NULL),('2093',117,13,'6','monitors'),('2094',135,13,'6',NULL),('2095',138,13,'6',NULL),('2096',141,13,'6',NULL),('2097',118,13,'7','printers'),('2098',45,13,'7','Printers'),('2099',48,13,'7',NULL),('2100',49,13,'7',NULL),('2101',52,13,'7','PRODUCTS'),('2102',60,13,'7',NULL),('2103',63,13,'7',NULL),('2104',117,13,'7','printers'),('2105',135,13,'7',NULL),('2106',138,13,'7',NULL),('2107',141,13,'7','cate2.png'),('2108',118,13,'8','networking'),('2109',45,13,'8','Networking'),('2110',48,13,'8',NULL),('2111',49,13,'8',NULL),('2112',52,13,'8','PRODUCTS'),('2113',60,13,'8',NULL),('2114',63,13,'8',NULL),('2115',117,13,'8','networking'),('2116',135,13,'8',NULL),('2117',138,13,'8',NULL),('2118',141,13,'8',NULL),('2120',118,13,'10','point-of-sale'),('2121',45,13,'10','Point-of-Sale'),('2122',48,13,'10',NULL),('2123',49,13,'10',NULL),('2124',52,13,'10','PRODUCTS'),('2125',60,13,'10',NULL),('2126',63,13,'10',NULL),('2127',117,13,'10','point-of-sale'),('2128',135,13,'10',NULL),('2129',138,13,'10',NULL),('2130',141,13,'10',NULL),('2131',118,13,'11','bags'),('2132',45,13,'11','Bags & Backpacks'),('2133',48,13,'11',NULL),('2134',49,13,'11',NULL),('2135',52,13,'11','PRODUCTS'),('2136',60,13,'11',NULL),('2137',63,13,'11',NULL),('2138',117,13,'11','bags'),('2139',135,13,'11',NULL),('2140',138,13,'11',NULL),('2141',141,13,'11',NULL),('2143',45,13,'12','Switches'),('2144',48,13,'12',NULL),('2145',49,13,'12',NULL),('2146',52,13,'12','PRODUCTS'),('2147',60,13,'12',NULL),('2148',63,13,'12',NULL),('2149',117,13,'12','switches'),('2150',135,13,'12',NULL),('2151',138,13,'12',NULL),('2152',141,13,'12',NULL);
/*!40000 ALTER TABLE `catalog_category_entity_varchar` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_product`
--

DROP TABLE IF EXISTS `catalog_category_product`;
CREATE TABLE `catalog_category_product` (
  `entity_id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `category_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Category ID',
  `product_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Product ID',
  `position` int(11) NOT NULL DEFAULT '0' COMMENT 'Position',
  PRIMARY KEY (`entity_id`,`category_id`,`product_id`),
  UNIQUE KEY `CATALOG_CATEGORY_PRODUCT_CATEGORY_ID_PRODUCT_ID` (`category_id`,`product_id`),
  KEY `CATALOG_CATEGORY_PRODUCT_PRODUCT_ID` (`product_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1468 DEFAULT CHARSET=utf8 COMMENT='Catalog Product To Category Linkage Table';

--
-- Dumping data for table `catalog_category_product`
--

LOCK TABLES `catalog_category_product` WRITE;
/*!40000 ALTER TABLE `catalog_category_product` DISABLE KEYS */;
INSERT INTO `catalog_category_product` VALUES ('1262','2','77','0'),('1263','2','78','0'),('1264','2','79','0'),('1265','2','80','0'),('1266','2','81','0'),('1267','2','82','0'),('1268','2','83','0'),('1269','2','84','0'),('1270','2','85','0'),('1271','2','86','0'),('1272','2','87','0'),('1273','2','88','0'),('1274','2','89','0'),('1275','2','90','0'),('1276','2','91','0'),('1277','2','92','0'),('1278','2','93','0'),('1279','2','94','0'),('1280','2','95','0'),('1281','2','96','0'),('1282','2','97','0'),('1283','2','98','0'),('1284','2','99','0'),('1285','2','100','0'),('1286','2','101','0'),('1287','2','102','0'),('1288','2','103','0'),('1289','2','104','0'),('1290','2','105','0'),('1291','2','106','0'),('1292','2','107','0'),('1293','2','108','0'),('1294','2','109','0'),('1295','2','110','0'),('1296','2','111','0'),('1297','2','112','0'),('1298','2','113','0'),('1299','2','114','0'),('1300','2','115','0'),('1301','2','116','0'),('1302','2','117','0'),('1303','2','118','0'),('1304','2','119','0'),('1305','2','120','0'),('1306','2','121','0'),('1307','2','122','0'),('1308','2','123','0'),('1309','2','124','0'),('1310','2','125','0'),('1311','2','126','0'),('1312','2','127','0'),('1313','2','128','0'),('1314','2','129','0'),('1315','2','130','0'),('1316','2','131','0'),('1317','2','132','0'),('1318','2','133','0'),('1319','2','134','0'),('1320','2','135','0'),('1321','2','136','0'),('1322','2','137','0'),('1323','2','138','0'),('1324','2','139','0'),('1325','2','140','0'),('1326','2','141','0'),('1327','2','142','0'),('1328','2','143','0'),('1329','2','144','0'),('1330','2','145','0'),('1331','2','146','0'),('1332','2','147','0'),('1333','2','148','0'),('1334','2','149','0'),('1335','2','150','0'),('1336','2','151','0'),('1337','2','152','0'),('1338','2','153','0'),('1339','2','154','0'),('1340','2','155','0'),('1341','2','156','0'),('1342','2','157','0'),('1343','2','158','0'),('1344','2','159','0'),('1345','2','160','0'),('1346','2','161','0'),('1347','2','162','0'),('1348','2','163','0'),('1349','2','164','0'),('1351','2','169','0'),('1352','2','170','0'),('1353','2','171','0'),('1354','2','172','0'),('1355','2','173','0'),('1356','2','174','0'),('1357','2','175','0'),('1358','2','176','0'),('1359','2','177','0'),('1360','2','178','0'),('1361','2','179','0'),('1362','2','180','0'),('1363','2','181','0'),('1364','2','182','0'),('1365','2','183','0'),('1366','4','76','0'),('1367','4','77','0'),('1368','4','78','0'),('1369','4','79','0'),('1370','4','80','0'),('1371','5','81','0'),('1372','5','82','0'),('1373','5','83','0'),('1374','5','84','0'),('1375','5','85','0'),('1376','5','86','0'),('1377','5','87','0'),('1378','5','88','0'),('1379','5','89','0'),('1380','6','142','0'),('1381','6','143','0'),('1382','6','144','0'),('1383','6','145','0'),('1384','6','146','0'),('1385','7','90','0'),('1386','7','91','0'),('1387','7','92','0'),('1388','7','93','0'),('1389','7','94','0'),('1390','7','95','0'),('1391','7','96','0'),('1392','7','97','0'),('1393','7','98','0'),('1394','7','99','0'),('1395','7','100','0'),('1396','7','101','0'),('1397','7','102','0'),('1398','7','103','0'),('1399','7','104','0'),('1400','7','105','0'),('1401','7','106','0'),('1402','7','107','0'),('1403','12','126','0'),('1404','12','127','0'),('1405','12','128','0'),('1406','12','129','0'),('1407','12','130','0'),('1408','12','131','0'),('1409','12','132','0'),('1410','12','133','0'),('1411','12','134','0'),('1412','12','135','0'),('1413','12','136','0'),('1414','12','137','0'),('1415','12','138','0'),('1416','12','139','0'),('1417','12','140','0'),('1418','12','141','0'),('1419','8','112','0'),('1420','8','113','0'),('1421','8','114','0'),('1422','8','115','0'),('1423','8','116','0'),('1424','8','117','0'),('1425','8','118','0'),('1426','8','119','0'),('1427','8','120','0'),('1428','8','121','0'),('1429','8','122','0'),('1430','8','123','0'),('1431','8','124','0'),('1432','8','125','0'),('1433','9','171','0'),('1434','9','172','0'),('1435','9','173','0'),('1436','9','174','0'),('1437','9','175','0'),('1438','9','176','0'),('1439','9','177','0'),('1440','9','178','0'),('1441','9','179','0'),('1442','9','180','0'),('1443','9','181','0'),('1444','9','182','0'),('1445','9','183','0'),('1446','10','154','0'),('1447','10','155','0'),('1448','10','156','0'),('1449','10','157','0'),('1450','10','158','0'),('1451','10','159','0'),('1452','10','160','0'),('1453','10','161','0'),('1454','10','162','0'),('1455','10','163','0'),('1456','10','164','0'),('1457','10','169','0'),('1458','10','170','0'),('1459','11','147','0'),('1460','11','148','0'),('1461','11','149','0'),('1462','11','150','0'),('1463','11','151','0'),('1464','11','152','0'),('1465','11','153','0'),('1466','2','184','0'),('1467','2','185','0');
/*!40000 ALTER TABLE `catalog_category_product` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_product_cl`
--

DROP TABLE IF EXISTS `catalog_category_product_cl`;
CREATE TABLE `catalog_category_product_cl` (
  `version_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Version ID',
  `entity_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  PRIMARY KEY (`version_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1139 DEFAULT CHARSET=utf8 COMMENT='catalog_category_product_cl';

--
-- Dumping data for table `catalog_category_product_cl`
--

LOCK TABLES `catalog_category_product_cl` WRITE;
/*!40000 ALTER TABLE `catalog_category_product_cl` DISABLE KEYS */;
INSERT INTO `catalog_category_product_cl` VALUES ('1','3'),('2','3'),('3','4'),('4','4'),('5','4'),('6','6'),('7','6'),('8','7'),('9','7'),('10','4'),('11','4'),('12','4'),('13','2'),('14','2'),('15','2'),('16','5'),('17','5'),('18','5'),('19','8'),('20','8'),('21','8'),('22','9'),('23','9'),('24','9'),('25','10'),('26','10'),('27','10'),('28','11'),('29','11'),('30','11'),('31','12'),('32','12'),('33','12'),('34','3'),('35','3'),('36','3'),('37','13'),('38','13'),('39','33'),('40','33'),('41','1'),('42','2'),('43','7'),('44','106'),('45','106'),('46','106'),('47','106'),('48','106'),('49','106'),('50','106'),('51','106'),('52','106'),('53','106'),('54','1'),('55','2'),('56','7'),('57','107'),('58','107'),('59','107'),('60','107'),('61','107'),('62','107'),('63','107'),('64','107'),('65','107'),('66','107'),('67','1'),('68','2'),('69','7'),('70','108'),('71','108'),('72','108'),('73','108'),('74','108'),('75','108'),('76','108'),('77','108'),('78','108'),('79','108'),('80','32'),('81','32'),('82','6'),('83','6'),('84','6'),('85','4'),('86','4'),('87','4'),('88','15'),('89','15'),('90','14'),('91','14'),('92','35'),('93','35'),('94','36'),('95','36'),('96','37'),('97','37'),('98','39'),('99','39'),('100','13'),('101','13'),('102','13'),('103','16'),('104','16'),('105','16'),('106','17'),('107','17'),('108','17'),('109','18'),('110','18'),('111','18'),('112','19'),('113','19'),('114','19'),('115','20'),('116','20'),('117','20'),('118','14'),('119','14'),('120','14'),('121','21'),('122','21'),('123','21'),('124','22'),('125','22'),('126','22'),('127','23'),('128','23'),('129','23'),('130','24'),('131','24'),('132','24'),('133','25'),('134','25'),('135','25'),('136','15'),('137','15'),('138','15'),('139','26'),('140','26'),('141','26'),('142','27'),('143','27'),('144','27'),('145','28'),('146','28'),('147','28'),('148','29'),('149','29'),('150','29'),('151','30'),('152','30'),('153','30'),('154','32'),('155','32'),('156','32'),('157','103'),('158','103'),('159','103'),('160','104'),('161','104'),('162','104'),('163','105'),('164','105'),('165','105'),('166','7'),('167','7'),('168','7'),('169','33'),('170','33'),('171','33'),('172','106'),('173','106'),('174','106'),('175','107'),('176','107'),('177','107'),('178','108'),('179','108'),('180','108'),('181','13'),('182','13'),('183','13'),('184','13'),('185','13'),('186','13'),('187','16'),('188','16'),('189','16'),('190','16'),('191','16'),('192','16'),('193','17'),('194','17'),('195','17'),('196','17'),('197','17'),('198','17'),('199','18'),('200','18'),('201','18'),('202','18'),('203','18'),('204','18'),('205','19'),('206','19'),('207','19'),('208','19'),('209','19'),('210','19'),('211','20'),('212','20'),('213','20'),('214','20'),('215','20'),('216','20'),('217','14'),('218','14'),('219','14'),('220','14'),('221','14'),('222','14'),('223','21'),('224','21'),('225','21'),('226','21'),('227','21'),('228','21'),('229','22'),('230','22'),('231','22'),('232','22'),('233','22'),('234','22'),('235','23'),('236','23'),('237','23'),('238','23'),('239','23'),('240','23'),('241','24'),('242','24'),('243','24'),('244','24'),('245','24'),('246','24'),('247','25'),('248','25'),('249','25'),('250','25'),('251','25'),('252','25'),('253','15'),('254','15'),('255','15'),('256','15'),('257','15'),('258','15'),('259','26'),('260','26'),('261','26'),('262','26'),('263','26'),('264','26'),('265','27'),('266','27'),('267','27'),('268','27'),('269','27'),('270','27'),('271','28'),('272','28'),('273','28'),('274','28'),('275','28'),('276','28'),('277','29'),('278','29'),('279','29'),('280','29'),('281','29'),('282','29'),('283','30'),('284','30'),('285','30'),('286','30'),('287','30'),('288','30'),('289','5'),('290','5'),('291','5'),('292','5'),('293','5'),('294','5'),('295','6'),('296','6'),('297','6'),('298','6'),('299','6'),('300','6'),('301','32'),('302','32'),('303','32'),('304','32'),('305','32'),('306','32'),('307','103'),('308','103'),('309','103'),('310','103'),('311','103'),('312','103'),('313','104'),('314','104'),('315','104'),('316','104'),('317','104'),('318','104'),('319','105'),('320','105'),('321','105'),('322','105'),('323','105'),('324','105'),('325','7'),('326','7'),('327','7'),('328','7'),('329','7'),('330','7'),('331','33'),('332','33'),('333','33'),('334','33'),('335','33'),('336','33'),('337','106'),('338','106'),('339','106'),('340','106'),('341','106'),('342','106'),('343','107'),('344','107'),('345','107'),('346','107'),('347','107'),('348','107'),('349','108'),('350','108'),('351','108'),('352','108'),('353','108'),('354','108'),('355','6'),('356','6'),('357','32'),('358','32'),('359','103'),('360','103'),('361','34'),('362','34'),('363','34'),('364','63'),('365','63'),('366','63'),('367','35'),('368','35'),('369','35'),('370','40'),('371','40'),('372','40'),('373','44'),('374','44'),('375','44'),('376','45'),('377','45'),('378','45'),('379','46'),('380','46'),('381','46'),('382','47'),('383','47'),('384','47'),('385','48'),('386','48'),('387','48'),('388','42'),('389','42'),('390','42'),('391','49'),('392','49'),('393','49'),('394','50'),('395','50'),('396','50'),('397','51'),('398','51'),('399','51'),('400','52'),('401','52'),('402','52'),('403','53'),('404','53'),('405','53'),('406','43'),('407','43'),('408','43'),('409','54'),('410','54'),('411','54'),('412','55'),('413','55'),('414','55'),('415','56'),('416','56'),('417','56'),('418','57'),('419','57'),('420','57'),('421','58'),('422','58'),('423','58'),('424','36'),('425','36'),('426','36'),('427','37'),('428','37'),('429','37'),('430','38'),('431','38'),('432','38'),('433','39'),('434','39'),('435','39'),('436','59'),('437','59'),('438','59'),('439','60'),('440','60'),('441','60'),('442','61'),('443','61'),('444','61'),('445','41'),('446','41'),('447','41'),('448','35'),('449','35'),('450','35'),('451','35'),('452','35'),('453','35'),('454','36'),('455','36'),('456','36'),('457','36'),('458','36'),('459','36'),('460','37'),('461','37'),('462','37'),('463','37'),('464','37'),('465','37'),('466','38'),('467','38'),('468','38'),('469','38'),('470','38'),('471','38'),('472','39'),('473','39'),('474','39'),('475','39'),('476','39'),('477','39'),('478','59'),('479','59'),('480','59'),('481','59'),('482','59'),('483','59'),('484','59'),('485','59'),('486','38'),('487','38'),('488','38'),('489','39'),('490','39'),('491','39'),('492','39'),('493','39'),('494','39'),('495','39'),('496','59'),('497','59'),('498','60'),('499','60'),('500','60'),('501','60'),('502','60'),('503','60'),('504','61'),('505','61'),('506','61'),('507','61'),('508','61'),('509','61'),('510','41'),('511','41'),('512','41'),('513','41'),('514','41'),('515','41'),('516','31'),('517','31'),('518','31'),('519','5'),('520','5'),('521','41'),('522','41'),('523','16'),('524','16'),('525','17'),('526','17'),('527','41'),('528','16'),('529','17'),('530','62'),('531','62'),('532','62'),('533','73'),('534','73'),('535','73'),('536','74'),('537','74'),('538','74'),('539','75'),('540','75'),('541','75'),('542','76'),('543','76'),('544','76'),('545','64'),('546','64'),('547','64'),('548','77'),('549','77'),('550','77'),('551','78'),('552','78'),('553','78'),('554','79'),('555','79'),('556','79'),('557','80'),('558','80'),('559','80'),('560','65'),('561','65'),('562','65'),('563','81'),('564','81'),('565','81'),('566','82'),('567','82'),('568','82'),('569','83'),('570','83'),('571','83'),('572','84'),('573','84'),('574','84'),('575','66'),('576','66'),('577','66'),('578','67'),('579','67'),('580','67'),('581','85'),('582','85'),('583','85'),('584','86'),('585','86'),('586','86'),('587','87'),('588','87'),('589','87'),('590','88'),('591','88'),('592','88'),('593','68'),('594','68'),('595','68'),('596','69'),('597','69'),('598','69'),('599','70'),('600','70'),('601','70'),('602','71'),('603','71'),('604','71'),('605','72'),('606','72'),('607','72'),('608','63'),('609','63'),('610','63'),('611','63'),('612','63'),('613','63'),('614','64'),('615','64'),('616','64'),('617','64'),('618','64'),('619','64'),('620','65'),('621','65'),('622','65'),('623','65'),('624','65'),('625','65'),('626','67'),('627','67'),('628','67'),('629','67'),('630','67'),('631','67'),('632','68'),('633','68'),('634','68'),('635','68'),('636','68'),('637','68'),('638','69'),('639','69'),('640','69'),('641','69'),('642','69'),('643','69'),('644','73'),('645','73'),('646','73'),('647','73'),('648','73'),('649','73'),('650','74'),('651','74'),('652','74'),('653','74'),('654','74'),('655','74'),('656','75'),('657','75'),('658','75'),('659','75'),('660','75'),('661','75'),('662','76'),('663','76'),('664','76'),('665','76'),('666','76'),('667','76'),('668','77'),('669','77'),('670','77'),('671','77'),('672','77'),('673','77'),('674','78'),('675','78'),('676','78'),('677','78'),('678','78'),('679','78'),('680','79'),('681','79'),('682','79'),('683','79'),('684','79'),('685','79'),('686','80'),('687','80'),('688','80'),('689','80'),('690','80'),('691','80'),('692','81'),('693','81'),('694','81'),('695','81'),('696','81'),('697','81'),('698','82'),('699','82'),('700','82'),('701','82'),('702','82'),('703','82'),('704','83'),('705','83'),('706','83'),('707','83'),('708','83'),('709','83'),('710','84'),('711','84'),('712','84'),('713','84'),('714','84'),('715','84'),('716','85'),('717','85'),('718','85'),('719','85'),('720','85'),('721','85'),('722','86'),('723','86'),('724','86'),('725','86'),('726','86'),('727','86'),('728','87'),('729','87'),('730','87'),('731','87'),('732','87'),('733','87'),('734','88'),('735','88'),('736','88'),('737','88'),('738','88'),('739','88'),('740','92'),('741','92'),('742','92'),('743','92'),('744','92'),('745','92'),('746','89'),('747','89'),('748','89'),('749','90'),('750','90'),('751','90'),('752','100'),('753','100'),('754','100'),('755','101'),('756','101'),('757','101'),('758','102'),('759','102'),('760','102'),('761','91'),('762','91'),('763','91'),('764','1'),('765','89'),('766','91'),('767','109'),('768','109'),('769','109'),('770','109'),('771','109'),('772','109'),('773','109'),('774','109'),('775','109'),('776','109'),('777','1'),('778','89'),('779','91'),('780','110'),('781','110'),('782','110'),('783','110'),('784','110'),('785','110'),('786','110'),('787','110'),('788','110'),('789','110'),('790','1'),('791','89'),('792','91'),('793','111'),('794','111'),('795','111'),('796','111'),('797','111'),('798','111'),('799','111'),('800','111'),('801','111'),('802','111'),('803','93'),('804','93'),('805','93'),('806','92'),('807','92'),('808','92'),('809','94'),('810','94'),('811','94'),('812','95'),('813','95'),('814','95'),('815','96'),('816','96'),('817','96'),('818','97'),('819','97'),('820','97'),('821','98'),('822','98'),('823','98'),('824','99'),('825','99'),('826','99'),('827','93'),('828','93'),('829','93'),('830','93'),('831','93'),('832','93'),('833','1'),('834','89'),('835','92'),('836','100'),('837','100'),('838','101'),('839','101'),('840','102'),('841','102'),('842','90'),('843','90'),('844','90'),('845','90'),('846','90'),('847','90'),('848','94'),('849','94'),('850','94'),('851','94'),('852','94'),('853','94'),('854','95'),('855','95'),('856','95'),('857','95'),('858','95'),('859','95'),('860','96'),('861','96'),('862','96'),('863','96'),('864','96'),('865','96'),('866','97'),('867','97'),('868','97'),('869','97'),('870','97'),('871','97'),('872','98'),('873','98'),('874','98'),('875','98'),('876','98'),('877','98'),('878','98'),('879','98'),('880','99'),('881','99'),('882','99'),('883','99'),('884','99'),('885','99'),('886','100'),('887','100'),('888','100'),('889','1'),('890','2'),('891','3'),('892','31'),('893','100'),('894','100'),('895','1'),('896','2'),('897','3'),('898','2'),('899','2'),('900','2'),('901','2'),('902','2'),('903','2'),('904','2'),('905','2'),('906','2'),('907','2'),('908','2'),('909','2'),('910','2'),('911','2'),('912','2'),('913','13'),('914','13'),('915','13'),('916','13'),('917','13'),('918','13'),('919','16'),('920','16'),('921','16'),('922','16'),('923','16'),('924','16'),('925','16'),('926','2'),('927','2'),('928','2'),('929','2'),('930','2'),('931','4'),('932','4'),('933','4'),('934','4'),('935','4'),('936','4'),('937','4'),('938','2'),('939','2'),('940','9'),('941','9'),('942','9'),('943','9'),('944','9'),('945','9'),('946','9'),('947','9'),('948','9'),('949','2'),('950','2'),('951','2'),('952','2'),('953','9'),('954','9'),('955','12'),('956','12'),('957','2'),('958','2'),('959','5'),('960','5'),('961','5'),('962','5'),('963','5'),('964','5'),('965','5'),('966','6'),('967','6'),('968','6'),('969','6'),('970','6'),('971','6'),('972','6'),('973','7'),('974','7'),('975','7'),('976','7'),('977','7'),('978','7'),('979','7'),('980','8'),('981','8'),('982','8'),('983','8'),('984','8'),('985','8'),('986','8'),('987','9'),('988','9'),('989','10'),('990','10'),('991','10'),('992','10'),('993','10'),('994','10'),('995','10'),('996','11'),('997','11'),('998','11'),('999','11'),('1000','11'),('1001','11'),('1002','11'),('1003','12'),('1004','12'),('1005','12'),('1006','12'),('1007','12'),('1008','12'),('1009','12'),('1010','1'),('1011','2'),('1012','1'),('1013','2'),('1014','8'),('1015','9'),('1016','10'),('1017','11'),('1018','12'),('1019','12'),('1020','1'),('1021','2'),('1022','4'),('1023','1'),('1024','2'),('1025','4'),('1026','13'),('1027','16'),('1028','1'),('1029','2'),('1030','4'),('1031','13'),('1032','17'),('1033','1'),('1034','2'),('1035','4'),('1036','13'),('1037','18'),('1038','1'),('1039','2'),('1040','4'),('1041','13'),('1042','19'),('1043','1'),('1044','2'),('1045','4'),('1046','13'),('1047','20'),('1048','13'),('1049','1'),('1050','2'),('1051','4'),('1052','1'),('1053','2'),('1054','4'),('1055','14'),('1056','21'),('1057','1'),('1058','2'),('1059','4'),('1060','14'),('1061','22'),('1062','1'),('1063','2'),('1064','4'),('1065','14'),('1066','23'),('1067','1'),('1068','2'),('1069','4'),('1070','14'),('1071','24'),('1072','1'),('1073','2'),('1074','4'),('1075','14'),('1076','25'),('1077','14'),('1078','1'),('1079','2'),('1080','4'),('1081','1'),('1082','2'),('1083','4'),('1084','15'),('1085','26'),('1086','1'),('1087','2'),('1088','4'),('1089','15'),('1090','27'),('1091','1'),('1092','2'),('1093','4'),('1094','15'),('1095','28'),('1096','1'),('1097','2'),('1098','4'),('1099','15'),('1100','29'),('1101','1'),('1102','2'),('1103','4'),('1104','15'),('1105','30'),('1106','15'),('1107','1'),('1108','2'),('1109','6'),('1110','32'),('1111','1'),('1112','2'),('1113','6'),('1114','103'),('1115','1'),('1116','2'),('1117','6'),('1118','104'),('1119','1'),('1120','2'),('1121','6'),('1122','105'),('1123','1'),('1124','2'),('1125','7'),('1126','33'),('1127','1'),('1128','2'),('1129','7'),('1130','106'),('1131','1'),('1132','2'),('1133','7'),('1134','107'),('1135','1'),('1136','2'),('1137','7'),('1138','108');
/*!40000 ALTER TABLE `catalog_category_product_cl` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_product_index`
--

DROP TABLE IF EXISTS `catalog_category_product_index`;
CREATE TABLE `catalog_category_product_index` (
  `category_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Category ID',
  `product_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Product ID',
  `position` int(11) DEFAULT NULL COMMENT 'Position',
  `is_parent` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Parent',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `visibility` smallint(5) unsigned NOT NULL COMMENT 'Visibility',
  PRIMARY KEY (`category_id`,`product_id`,`store_id`),
  KEY `CAT_CTGR_PRD_IDX_PRD_ID_STORE_ID_CTGR_ID_VISIBILITY` (`product_id`,`store_id`,`category_id`,`visibility`),
  KEY `CAT_CTGR_PRD_IDX_STORE_ID_CTGR_ID_VISIBILITY_IS_PARENT_POSITION` (`store_id`,`category_id`,`visibility`,`is_parent`,`position`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Category Product Index';

--
-- Dumping data for table `catalog_category_product_index`
--

LOCK TABLES `catalog_category_product_index` WRITE;
/*!40000 ALTER TABLE `catalog_category_product_index` DISABLE KEYS */;
INSERT INTO `catalog_category_product_index` VALUES ('2','76','10000',0,1,4),('2','77','10000',0,1,4),('2','78','10000',0,1,4),('2','79','10000',0,1,4),('2','80','10000',0,1,4),('2','81','10000',0,1,4),('2','82','10000',0,1,4),('2','83','10000',0,1,4),('2','84','10000',0,1,4),('2','85','10000',0,1,4),('2','86','10000',0,1,4),('2','87','10000',0,1,4),('2','88','10000',0,1,4),('2','89','10000',0,1,4),('2','90','10000',0,1,4),('2','91','10000',0,1,4),('2','92','10000',0,1,4),('2','93','10000',0,1,4),('2','94','10000',0,1,4),('2','96','10000',0,1,4),('2','97','10000',0,1,4),('2','98','10000',0,1,4),('2','99','10000',0,1,4),('2','100','10000',0,1,4),('2','101','10000',0,1,4),('2','102','10000',0,1,4),('2','103','10000',0,1,4),('2','104','10000',0,1,4),('2','105','10000',0,1,4),('2','106','10000',0,1,4),('2','112','10000',0,1,4),('2','113','10000',0,1,4),('2','114','10000',0,1,4),('2','115','10000',0,1,4),('2','116','10000',0,1,4),('2','117','10000',0,1,4),('2','118','10000',0,1,4),('2','119','10000',0,1,4),('2','120','10000',0,1,4),('2','121','10000',0,1,4),('2','122','10000',0,1,4),('2','123','10000',0,1,4),('2','124','10000',0,1,4),('2','125','10000',0,1,4),('2','126','10000',0,1,4),('2','127','10000',0,1,4),('2','128','10000',0,1,4),('2','129','10000',0,1,4),('2','130','10000',0,1,4),('2','131','10000',0,1,4),('2','132','10000',0,1,4),('2','133','10000',0,1,4),('2','134','10000',0,1,4),('2','135','10000',0,1,4),('2','136','10000',0,1,4),('2','137','10000',0,1,4),('2','138','10000',0,1,4),('2','139','10000',0,1,4),('2','140','10000',0,1,4),('2','141','10000',0,1,4),('2','142','10000',0,1,4),('2','143','10000',0,1,4),('2','144','10000',0,1,4),('2','145','10000',0,1,4),('2','146','10000',0,1,4),('2','147','10000',0,1,4),('2','148','10000',0,1,4),('2','149','10000',0,1,4),('2','150','10000',0,1,4),('2','151','10000',0,1,4),('2','152','10000',0,1,4),('2','153','10000',0,1,4),('2','154','10000',0,1,4),('2','155','10000',0,1,4),('2','156','10000',0,1,4),('2','157','10000',0,1,4),('2','158','10000',0,1,4),('2','159','10000',0,1,4),('2','160','10000',0,1,4),('2','161','10000',0,1,4),('2','162','10000',0,1,4),('2','163','10000',0,1,4),('2','164','10000',0,1,4),('2','169','10000',0,1,4),('2','170','10000',0,1,4),('2','171','10000',0,1,4),('2','172','10000',0,1,4),('2','173','10000',0,1,4),('2','174','10000',0,1,4),('2','175','10000',0,1,4),('2','176','10000',0,1,4),('2','177','10000',0,1,4),('2','178','10000',0,1,4),('2','179','10000',0,1,4),('2','180','10000',0,1,4),('2','181','10000',0,1,4),('2','182','10000',0,1,4),('2','183','10000',0,1,4),('2','108','0',1,1,4),('2','109','0',1,1,4),('2','110','0',1,1,4),('2','111','0',1,1,4),('2','184','0',1,1,4),('2','185','0',1,1,4),('4','76','0',1,1,4),('4','77','0',1,1,4),('4','78','0',1,1,4),('4','79','0',1,1,4),('4','80','0',1,1,4),('5','81','0',1,1,4),('5','82','0',1,1,4),('5','83','0',1,1,4),('5','84','0',1,1,4),('5','85','0',1,1,4),('5','86','0',1,1,4),('5','87','0',1,1,4),('5','88','0',1,1,4),('5','89','0',1,1,4),('6','142','0',1,1,4),('6','143','0',1,1,4),('6','144','0',1,1,4),('6','145','0',1,1,4),('6','146','0',1,1,4),('7','90','0',1,1,4),('7','91','0',1,1,4),('7','92','0',1,1,4),('7','93','0',1,1,4),('7','94','0',1,1,4),('7','96','0',1,1,4),('7','97','0',1,1,4),('7','98','0',1,1,4),('7','99','0',1,1,4),('7','100','0',1,1,4),('7','101','0',1,1,4),('7','102','0',1,1,4),('7','103','0',1,1,4),('7','104','0',1,1,4),('7','105','0',1,1,4),('7','106','0',1,1,4),('8','112','0',1,1,4),('8','113','0',1,1,4),('8','114','0',1,1,4),('8','115','0',1,1,4),('8','116','0',1,1,4),('8','117','0',1,1,4),('8','118','0',1,1,4),('8','119','0',1,1,4),('8','120','0',1,1,4),('8','121','0',1,1,4),('8','122','0',1,1,4),('8','123','0',1,1,4),('8','124','0',1,1,4),('8','125','0',1,1,4),('9','171','0',1,1,4),('9','172','0',1,1,4),('9','173','0',1,1,4),('9','174','0',1,1,4),('9','175','0',1,1,4),('9','176','0',1,1,4),('9','177','0',1,1,4),('9','178','0',1,1,4),('9','179','0',1,1,4),('9','180','0',1,1,4),('9','181','0',1,1,4),('9','182','0',1,1,4),('9','183','0',1,1,4),('10','154','0',1,1,4),('10','155','0',1,1,4),('10','156','0',1,1,4),('10','157','0',1,1,4),('10','158','0',1,1,4),('10','159','0',1,1,4),('10','160','0',1,1,4),('10','161','0',1,1,4),('10','162','0',1,1,4),('10','163','0',1,1,4),('10','164','0',1,1,4),('10','169','0',1,1,4),('10','170','0',1,1,4),('11','147','0',1,1,4),('11','148','0',1,1,4),('11','149','0',1,1,4),('11','150','0',1,1,4),('11','151','0',1,1,4),('11','152','0',1,1,4),('11','153','0',1,1,4),('12','126','0',1,1,4),('12','127','0',1,1,4),('12','128','0',1,1,4),('12','129','0',1,1,4),('12','130','0',1,1,4),('12','131','0',1,1,4),('12','132','0',1,1,4),('12','133','0',1,1,4),('12','134','0',1,1,4),('12','135','0',1,1,4),('12','136','0',1,1,4),('12','137','0',1,1,4),('12','138','0',1,1,4),('12','139','0',1,1,4),('12','140','0',1,1,4),('12','141','0',1,1,4),('2','76','10000',0,2,4),('2','77','10000',0,2,4),('2','78','10000',0,2,4),('2','79','10000',0,2,4),('2','80','10000',0,2,4),('2','81','10000',0,2,4),('2','82','10000',0,2,4),('2','83','10000',0,2,4),('2','84','10000',0,2,4),('2','85','10000',0,2,4),('2','86','10000',0,2,4),('2','87','10000',0,2,4),('2','88','10000',0,2,4),('2','89','10000',0,2,4),('2','90','10000',0,2,4),('2','91','10000',0,2,4),('2','92','10000',0,2,4),('2','93','10000',0,2,4),('2','94','10000',0,2,4),('2','96','10000',0,2,4),('2','97','10000',0,2,4),('2','98','10000',0,2,4),('2','99','10000',0,2,4),('2','100','10000',0,2,4),('2','101','10000',0,2,4),('2','102','10000',0,2,4),('2','103','10000',0,2,4),('2','104','10000',0,2,4),('2','105','10000',0,2,4),('2','106','10000',0,2,4),('2','112','10000',0,2,4),('2','113','10000',0,2,4),('2','114','10000',0,2,4),('2','115','10000',0,2,4),('2','116','10000',0,2,4),('2','117','10000',0,2,4),('2','118','10000',0,2,4),('2','119','10000',0,2,4),('2','120','10000',0,2,4),('2','121','10000',0,2,4),('2','122','10000',0,2,4),('2','123','10000',0,2,4),('2','124','10000',0,2,4),('2','125','10000',0,2,4),('2','126','10000',0,2,4),('2','127','10000',0,2,4),('2','128','10000',0,2,4),('2','129','10000',0,2,4),('2','130','10000',0,2,4),('2','131','10000',0,2,4),('2','132','10000',0,2,4),('2','133','10000',0,2,4),('2','134','10000',0,2,4),('2','135','10000',0,2,4),('2','136','10000',0,2,4),('2','137','10000',0,2,4),('2','138','10000',0,2,4),('2','139','10000',0,2,4),('2','140','10000',0,2,4),('2','141','10000',0,2,4),('2','142','10000',0,2,4),('2','143','10000',0,2,4),('2','144','10000',0,2,4),('2','145','10000',0,2,4),('2','146','10000',0,2,4),('2','147','10000',0,2,4),('2','148','10000',0,2,4),('2','149','10000',0,2,4),('2','150','10000',0,2,4),('2','151','10000',0,2,4),('2','152','10000',0,2,4),('2','153','10000',0,2,4),('2','154','10000',0,2,4),('2','155','10000',0,2,4),('2','156','10000',0,2,4),('2','157','10000',0,2,4),('2','158','10000',0,2,4),('2','159','10000',0,2,4),('2','160','10000',0,2,4),('2','161','10000',0,2,4),('2','162','10000',0,2,4),('2','163','10000',0,2,4),('2','164','10000',0,2,4),('2','169','10000',0,2,4),('2','170','10000',0,2,4),('2','171','10000',0,2,4),('2','172','10000',0,2,4),('2','173','10000',0,2,4),('2','174','10000',0,2,4),('2','175','10000',0,2,4),('2','176','10000',0,2,4),('2','177','10000',0,2,4),('2','178','10000',0,2,4),('2','179','10000',0,2,4),('2','180','10000',0,2,4),('2','181','10000',0,2,4),('2','182','10000',0,2,4),('2','183','10000',0,2,4),('2','108','0',1,2,4),('2','109','0',1,2,4),('2','110','0',1,2,4),('2','111','0',1,2,4),('2','184','0',1,2,4),('2','185','0',1,2,4),('4','76','0',1,2,4),('4','77','0',1,2,4),('4','78','0',1,2,4),('4','79','0',1,2,4),('4','80','0',1,2,4),('5','81','0',1,2,4),('5','82','0',1,2,4),('5','83','0',1,2,4),('5','84','0',1,2,4),('5','85','0',1,2,4),('5','86','0',1,2,4),('5','87','0',1,2,4),('5','88','0',1,2,4),('5','89','0',1,2,4),('6','142','0',1,2,4),('6','143','0',1,2,4),('6','144','0',1,2,4),('6','145','0',1,2,4),('6','146','0',1,2,4),('7','90','0',1,2,4),('7','91','0',1,2,4),('7','92','0',1,2,4),('7','93','0',1,2,4),('7','94','0',1,2,4),('7','96','0',1,2,4),('7','97','0',1,2,4),('7','98','0',1,2,4),('7','99','0',1,2,4),('7','100','0',1,2,4),('7','101','0',1,2,4),('7','102','0',1,2,4),('7','103','0',1,2,4),('7','104','0',1,2,4),('7','105','0',1,2,4),('7','106','0',1,2,4),('8','112','0',1,2,4),('8','113','0',1,2,4),('8','114','0',1,2,4),('8','115','0',1,2,4),('8','116','0',1,2,4),('8','117','0',1,2,4),('8','118','0',1,2,4),('8','119','0',1,2,4),('8','120','0',1,2,4),('8','121','0',1,2,4),('8','122','0',1,2,4),('8','123','0',1,2,4),('8','124','0',1,2,4),('8','125','0',1,2,4),('9','171','0',1,2,4),('9','172','0',1,2,4),('9','173','0',1,2,4),('9','174','0',1,2,4),('9','175','0',1,2,4),('9','176','0',1,2,4),('9','177','0',1,2,4),('9','178','0',1,2,4),('9','179','0',1,2,4),('9','180','0',1,2,4),('9','181','0',1,2,4),('9','182','0',1,2,4),('9','183','0',1,2,4),('10','154','0',1,2,4),('10','155','0',1,2,4),('10','156','0',1,2,4),('10','157','0',1,2,4),('10','158','0',1,2,4),('10','159','0',1,2,4),('10','160','0',1,2,4),('10','161','0',1,2,4),('10','162','0',1,2,4),('10','163','0',1,2,4),('10','164','0',1,2,4),('10','169','0',1,2,4),('10','170','0',1,2,4),('11','147','0',1,2,4),('11','148','0',1,2,4),('11','149','0',1,2,4),('11','150','0',1,2,4),('11','151','0',1,2,4),('11','152','0',1,2,4),('11','153','0',1,2,4),('12','126','0',1,2,4),('12','127','0',1,2,4),('12','128','0',1,2,4),('12','129','0',1,2,4),('12','130','0',1,2,4),('12','131','0',1,2,4),('12','132','0',1,2,4),('12','133','0',1,2,4),('12','134','0',1,2,4),('12','135','0',1,2,4),('12','136','0',1,2,4),('12','137','0',1,2,4),('12','138','0',1,2,4),('12','139','0',1,2,4),('12','140','0',1,2,4),('12','141','0',1,2,4),('2','76','10000',0,3,4),('2','77','10000',0,3,4),('2','78','10000',0,3,4),('2','79','10000',0,3,4),('2','80','10000',0,3,4),('2','81','10000',0,3,4),('2','82','10000',0,3,4),('2','83','10000',0,3,4),('2','84','10000',0,3,4),('2','85','10000',0,3,4),('2','86','10000',0,3,4),('2','87','10000',0,3,4),('2','88','10000',0,3,4),('2','89','10000',0,3,4),('2','90','10000',0,3,4),('2','91','10000',0,3,4),('2','92','10000',0,3,4),('2','93','10000',0,3,4),('2','94','10000',0,3,4),('2','96','10000',0,3,4),('2','97','10000',0,3,4),('2','98','10000',0,3,4),('2','99','10000',0,3,4),('2','100','10000',0,3,4),('2','101','10000',0,3,4),('2','102','10000',0,3,4),('2','103','10000',0,3,4),('2','104','10000',0,3,4),('2','105','10000',0,3,4),('2','106','10000',0,3,4),('2','112','10000',0,3,4),('2','113','10000',0,3,4),('2','114','10000',0,3,4),('2','115','10000',0,3,4),('2','116','10000',0,3,4),('2','117','10000',0,3,4),('2','118','10000',0,3,4),('2','119','10000',0,3,4),('2','120','10000',0,3,4),('2','121','10000',0,3,4),('2','122','10000',0,3,4),('2','123','10000',0,3,4),('2','124','10000',0,3,4),('2','125','10000',0,3,4),('2','126','10000',0,3,4),('2','127','10000',0,3,4),('2','128','10000',0,3,4),('2','129','10000',0,3,4),('2','130','10000',0,3,4),('2','131','10000',0,3,4),('2','132','10000',0,3,4),('2','133','10000',0,3,4),('2','134','10000',0,3,4),('2','135','10000',0,3,4),('2','136','10000',0,3,4),('2','137','10000',0,3,4),('2','138','10000',0,3,4),('2','139','10000',0,3,4),('2','140','10000',0,3,4),('2','141','10000',0,3,4),('2','142','10000',0,3,4),('2','143','10000',0,3,4),('2','144','10000',0,3,4),('2','145','10000',0,3,4),('2','146','10000',0,3,4),('2','147','10000',0,3,4),('2','148','10000',0,3,4),('2','149','10000',0,3,4),('2','150','10000',0,3,4),('2','151','10000',0,3,4),('2','152','10000',0,3,4),('2','153','10000',0,3,4),('2','154','10000',0,3,4),('2','155','10000',0,3,4),('2','156','10000',0,3,4),('2','157','10000',0,3,4),('2','158','10000',0,3,4),('2','159','10000',0,3,4),('2','160','10000',0,3,4),('2','161','10000',0,3,4),('2','162','10000',0,3,4),('2','163','10000',0,3,4),('2','164','10000',0,3,4),('2','169','10000',0,3,4),('2','170','10000',0,3,4),('2','171','10000',0,3,4),('2','172','10000',0,3,4),('2','173','10000',0,3,4),('2','174','10000',0,3,4),('2','175','10000',0,3,4),('2','176','10000',0,3,4),('2','177','10000',0,3,4),('2','178','10000',0,3,4),('2','179','10000',0,3,4),('2','180','10000',0,3,4),('2','181','10000',0,3,4),('2','182','10000',0,3,4),('2','183','10000',0,3,4),('2','108','0',1,3,4),('2','109','0',1,3,4),('2','110','0',1,3,4),('2','111','0',1,3,4),('2','184','0',1,3,4),('2','185','0',1,3,4),('4','76','0',1,3,4),('4','77','0',1,3,4),('4','78','0',1,3,4),('4','79','0',1,3,4),('4','80','0',1,3,4),('5','81','0',1,3,4),('5','82','0',1,3,4),('5','83','0',1,3,4),('5','84','0',1,3,4),('5','85','0',1,3,4),('5','86','0',1,3,4),('5','87','0',1,3,4),('5','88','0',1,3,4),('5','89','0',1,3,4),('6','142','0',1,3,4),('6','143','0',1,3,4),('6','144','0',1,3,4),('6','145','0',1,3,4),('6','146','0',1,3,4),('7','90','0',1,3,4),('7','91','0',1,3,4),('7','92','0',1,3,4),('7','93','0',1,3,4),('7','94','0',1,3,4),('7','96','0',1,3,4),('7','97','0',1,3,4),('7','98','0',1,3,4),('7','99','0',1,3,4),('7','100','0',1,3,4),('7','101','0',1,3,4),('7','102','0',1,3,4),('7','103','0',1,3,4),('7','104','0',1,3,4),('7','105','0',1,3,4),('7','106','0',1,3,4),('8','112','0',1,3,4),('8','113','0',1,3,4),('8','114','0',1,3,4),('8','115','0',1,3,4),('8','116','0',1,3,4),('8','117','0',1,3,4),('8','118','0',1,3,4),('8','119','0',1,3,4),('8','120','0',1,3,4),('8','121','0',1,3,4),('8','122','0',1,3,4),('8','123','0',1,3,4),('8','124','0',1,3,4),('8','125','0',1,3,4),('9','171','0',1,3,4),('9','172','0',1,3,4),('9','173','0',1,3,4),('9','174','0',1,3,4),('9','175','0',1,3,4),('9','176','0',1,3,4),('9','177','0',1,3,4),('9','178','0',1,3,4),('9','179','0',1,3,4),('9','180','0',1,3,4),('9','181','0',1,3,4),('9','182','0',1,3,4),('9','183','0',1,3,4),('10','154','0',1,3,4),('10','155','0',1,3,4),('10','156','0',1,3,4),('10','157','0',1,3,4),('10','158','0',1,3,4),('10','159','0',1,3,4),('10','160','0',1,3,4),('10','161','0',1,3,4),('10','162','0',1,3,4),('10','163','0',1,3,4),('10','164','0',1,3,4),('10','169','0',1,3,4),('10','170','0',1,3,4),('11','147','0',1,3,4),('11','148','0',1,3,4),('11','149','0',1,3,4),('11','150','0',1,3,4),('11','151','0',1,3,4),('11','152','0',1,3,4),('11','153','0',1,3,4),('12','126','0',1,3,4),('12','127','0',1,3,4),('12','128','0',1,3,4),('12','129','0',1,3,4),('12','130','0',1,3,4),('12','131','0',1,3,4),('12','132','0',1,3,4),('12','133','0',1,3,4),('12','134','0',1,3,4),('12','135','0',1,3,4),('12','136','0',1,3,4),('12','137','0',1,3,4),('12','138','0',1,3,4),('12','139','0',1,3,4),('12','140','0',1,3,4),('12','141','0',1,3,4),('2','76','10000',0,13,4),('2','77','10000',0,13,4),('2','78','10000',0,13,4),('2','79','10000',0,13,4),('2','80','10000',0,13,4),('2','81','10000',0,13,4),('2','82','10000',0,13,4),('2','83','10000',0,13,4),('2','84','10000',0,13,4),('2','85','10000',0,13,4),('2','86','10000',0,13,4),('2','87','10000',0,13,4),('2','88','10000',0,13,4),('2','89','10000',0,13,4),('2','90','10000',0,13,4),('2','91','10000',0,13,4),('2','92','10000',0,13,4),('2','93','10000',0,13,4),('2','94','10000',0,13,4),('2','96','10000',0,13,4),('2','97','10000',0,13,4),('2','98','10000',0,13,4),('2','99','10000',0,13,4),('2','100','10000',0,13,4),('2','101','10000',0,13,4),('2','102','10000',0,13,4),('2','103','10000',0,13,4),('2','104','10000',0,13,4),('2','105','10000',0,13,4),('2','106','10000',0,13,4),('2','112','10000',0,13,4),('2','113','10000',0,13,4),('2','114','10000',0,13,4),('2','115','10000',0,13,4),('2','116','10000',0,13,4),('2','117','10000',0,13,4),('2','118','10000',0,13,4),('2','119','10000',0,13,4),('2','120','10000',0,13,4),('2','121','10000',0,13,4),('2','122','10000',0,13,4),('2','123','10000',0,13,4),('2','124','10000',0,13,4),('2','125','10000',0,13,4),('2','126','10000',0,13,4),('2','127','10000',0,13,4),('2','128','10000',0,13,4),('2','129','10000',0,13,4),('2','130','10000',0,13,4),('2','131','10000',0,13,4),('2','132','10000',0,13,4),('2','133','10000',0,13,4),('2','134','10000',0,13,4),('2','135','10000',0,13,4),('2','136','10000',0,13,4),('2','137','10000',0,13,4),('2','138','10000',0,13,4),('2','139','10000',0,13,4),('2','140','10000',0,13,4),('2','141','10000',0,13,4),('2','142','10000',0,13,4),('2','143','10000',0,13,4),('2','144','10000',0,13,4),('2','145','10000',0,13,4),('2','146','10000',0,13,4),('2','147','10000',0,13,4),('2','148','10000',0,13,4),('2','149','10000',0,13,4),('2','150','10000',0,13,4),('2','151','10000',0,13,4),('2','152','10000',0,13,4),('2','153','10000',0,13,4),('2','154','10000',0,13,4),('2','155','10000',0,13,4),('2','156','10000',0,13,4),('2','157','10000',0,13,4),('2','158','10000',0,13,4),('2','159','10000',0,13,4),('2','160','10000',0,13,4),('2','161','10000',0,13,4),('2','162','10000',0,13,4),('2','163','10000',0,13,4),('2','164','10000',0,13,4),('2','169','10000',0,13,4),('2','170','10000',0,13,4),('2','171','10000',0,13,4),('2','172','10000',0,13,4),('2','173','10000',0,13,4),('2','174','10000',0,13,4),('2','175','10000',0,13,4),('2','176','10000',0,13,4),('2','177','10000',0,13,4),('2','178','10000',0,13,4),('2','179','10000',0,13,4),('2','180','10000',0,13,4),('2','181','10000',0,13,4),('2','182','10000',0,13,4),('2','183','10000',0,13,4),('2','108','0',1,13,4),('2','109','0',1,13,4),('2','110','0',1,13,4),('2','111','0',1,13,4),('2','184','0',1,13,4),('2','185','0',1,13,4),('4','76','0',1,13,4),('4','77','0',1,13,4),('4','78','0',1,13,4),('4','79','0',1,13,4),('4','80','0',1,13,4),('5','81','0',1,13,4),('5','82','0',1,13,4),('5','83','0',1,13,4),('5','84','0',1,13,4),('5','85','0',1,13,4),('5','86','0',1,13,4),('5','87','0',1,13,4),('5','88','0',1,13,4),('5','89','0',1,13,4),('6','142','0',1,13,4),('6','143','0',1,13,4),('6','144','0',1,13,4),('6','145','0',1,13,4),('6','146','0',1,13,4),('7','90','0',1,13,4),('7','91','0',1,13,4),('7','92','0',1,13,4),('7','93','0',1,13,4),('7','94','0',1,13,4),('7','96','0',1,13,4),('7','97','0',1,13,4),('7','98','0',1,13,4),('7','99','0',1,13,4),('7','100','0',1,13,4),('7','101','0',1,13,4),('7','102','0',1,13,4),('7','103','0',1,13,4),('7','104','0',1,13,4),('7','105','0',1,13,4),('7','106','0',1,13,4),('8','112','0',1,13,4),('8','113','0',1,13,4),('8','114','0',1,13,4),('8','115','0',1,13,4),('8','116','0',1,13,4),('8','117','0',1,13,4),('8','118','0',1,13,4),('8','119','0',1,13,4),('8','120','0',1,13,4),('8','121','0',1,13,4),('8','122','0',1,13,4),('8','123','0',1,13,4),('8','124','0',1,13,4),('8','125','0',1,13,4),('9','171','0',1,13,4),('9','172','0',1,13,4),('9','173','0',1,13,4),('9','174','0',1,13,4),('9','175','0',1,13,4),('9','176','0',1,13,4),('9','177','0',1,13,4),('9','178','0',1,13,4),('9','179','0',1,13,4),('9','180','0',1,13,4),('9','181','0',1,13,4),('9','182','0',1,13,4),('9','183','0',1,13,4),('10','154','0',1,13,4),('10','155','0',1,13,4),('10','156','0',1,13,4),('10','157','0',1,13,4),('10','158','0',1,13,4),('10','159','0',1,13,4),('10','160','0',1,13,4),('10','161','0',1,13,4),('10','162','0',1,13,4),('10','163','0',1,13,4),('10','164','0',1,13,4),('10','169','0',1,13,4),('10','170','0',1,13,4),('11','147','0',1,13,4),('11','148','0',1,13,4),('11','149','0',1,13,4),('11','150','0',1,13,4),('11','151','0',1,13,4),('11','152','0',1,13,4),('11','153','0',1,13,4),('12','126','0',1,13,4),('12','127','0',1,13,4),('12','128','0',1,13,4),('12','129','0',1,13,4),('12','130','0',1,13,4),('12','131','0',1,13,4),('12','132','0',1,13,4),('12','133','0',1,13,4),('12','134','0',1,13,4),('12','135','0',1,13,4),('12','136','0',1,13,4),('12','137','0',1,13,4),('12','138','0',1,13,4),('12','139','0',1,13,4),('12','140','0',1,13,4),('12','141','0',1,13,4);
/*!40000 ALTER TABLE `catalog_category_product_index` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_product_index_replica`
--

DROP TABLE IF EXISTS `catalog_category_product_index_replica`;
CREATE TABLE `catalog_category_product_index_replica` (
  `category_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Category ID',
  `product_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Product ID',
  `position` int(11) DEFAULT NULL COMMENT 'Position',
  `is_parent` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Parent',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `visibility` smallint(5) unsigned NOT NULL COMMENT 'Visibility',
  PRIMARY KEY (`category_id`,`product_id`,`store_id`),
  KEY `CAT_CTGR_PRD_IDX_PRD_ID_STORE_ID_CTGR_ID_VISIBILITY` (`product_id`,`store_id`,`category_id`,`visibility`),
  KEY `CAT_CTGR_PRD_IDX_STORE_ID_CTGR_ID_VISIBILITY_IS_PARENT_POSITION` (`store_id`,`category_id`,`visibility`,`is_parent`,`position`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Category Product Index';

--
-- Dumping data for table `catalog_category_product_index_replica`
--

LOCK TABLES `catalog_category_product_index_replica` WRITE;
/*!40000 ALTER TABLE `catalog_category_product_index_replica` DISABLE KEYS */;
INSERT INTO `catalog_category_product_index_replica` VALUES ('2','76','10000',0,1,4),('2','77','10000',0,1,4),('2','78','10000',0,1,4),('2','79','10000',0,1,4),('2','80','10000',0,1,4),('2','81','10000',0,1,4),('2','82','10000',0,1,4),('2','83','10000',0,1,4),('2','84','10000',0,1,4),('2','85','10000',0,1,4),('2','86','10000',0,1,4),('2','87','10000',0,1,4),('2','88','10000',0,1,4),('2','89','10000',0,1,4),('2','90','10000',0,1,4),('2','91','10000',0,1,4),('2','92','10000',0,1,4),('2','93','10000',0,1,4),('2','94','10000',0,1,4),('2','95','10000',0,1,4),('2','96','10000',0,1,4),('2','97','10000',0,1,4),('2','98','10000',0,1,4),('2','99','10000',0,1,4),('2','100','10000',0,1,4),('2','101','10000',0,1,4),('2','102','10000',0,1,4),('2','103','10000',0,1,4),('2','104','10000',0,1,4),('2','105','10000',0,1,4),('2','106','10000',0,1,4),('2','112','10000',0,1,4),('2','113','10000',0,1,4),('2','114','10000',0,1,4),('2','115','10000',0,1,4),('2','116','10000',0,1,4),('2','117','10000',0,1,4),('2','118','10000',0,1,4),('2','119','10000',0,1,4),('2','120','10000',0,1,4),('2','121','10000',0,1,4),('2','122','10000',0,1,4),('2','123','10000',0,1,4),('2','124','10000',0,1,4),('2','125','10000',0,1,4),('2','126','10000',0,1,4),('2','127','10000',0,1,4),('2','128','10000',0,1,4),('2','129','10000',0,1,4),('2','130','10000',0,1,4),('2','131','10000',0,1,4),('2','132','10000',0,1,4),('2','133','10000',0,1,4),('2','134','10000',0,1,4),('2','135','10000',0,1,4),('2','136','10000',0,1,4),('2','137','10000',0,1,4),('2','138','10000',0,1,4),('2','139','10000',0,1,4),('2','140','10000',0,1,4),('2','141','10000',0,1,4),('2','142','10000',0,1,4),('2','143','10000',0,1,4),('2','144','10000',0,1,4),('2','145','10000',0,1,4),('2','146','10000',0,1,4),('2','147','10000',0,1,4),('2','148','10000',0,1,4),('2','149','10000',0,1,4),('2','150','10000',0,1,4),('2','151','10000',0,1,4),('2','152','10000',0,1,4),('2','153','10000',0,1,4),('2','154','10000',0,1,4),('2','155','10000',0,1,4),('2','156','10000',0,1,4),('2','157','10000',0,1,4),('2','158','10000',0,1,4),('2','159','10000',0,1,4),('2','160','10000',0,1,4),('2','161','10000',0,1,4),('2','162','10000',0,1,4),('2','163','10000',0,1,4),('2','164','10000',0,1,4),('2','169','10000',0,1,4),('2','170','10000',0,1,4),('2','171','10000',0,1,4),('2','172','10000',0,1,4),('2','173','10000',0,1,4),('2','174','10000',0,1,4),('2','175','10000',0,1,4),('2','176','10000',0,1,4),('2','177','10000',0,1,4),('2','178','10000',0,1,4),('2','179','10000',0,1,4),('2','180','10000',0,1,4),('2','181','10000',0,1,4),('2','182','10000',0,1,4),('2','183','10000',0,1,4),('2','108','0',1,1,4),('2','109','0',1,1,4),('2','110','0',1,1,4),('2','111','0',1,1,4),('2','184','0',1,1,4),('2','185','0',1,1,4),('4','76','0',1,1,4),('4','77','0',1,1,4),('4','78','0',1,1,4),('4','79','0',1,1,4),('4','80','0',1,1,4),('5','81','0',1,1,4),('5','82','0',1,1,4),('5','83','0',1,1,4),('5','84','0',1,1,4),('5','85','0',1,1,4),('5','86','0',1,1,4),('5','87','0',1,1,4),('5','88','0',1,1,4),('5','89','0',1,1,4),('6','142','0',1,1,4),('6','143','0',1,1,4),('6','144','0',1,1,4),('6','145','0',1,1,4),('6','146','0',1,1,4),('7','90','0',1,1,4),('7','91','0',1,1,4),('7','92','0',1,1,4),('7','93','0',1,1,4),('7','94','0',1,1,4),('7','95','0',1,1,4),('7','96','0',1,1,4),('7','97','0',1,1,4),('7','98','0',1,1,4),('7','99','0',1,1,4),('7','100','0',1,1,4),('7','101','0',1,1,4),('7','102','0',1,1,4),('7','103','0',1,1,4),('7','104','0',1,1,4),('7','105','0',1,1,4),('7','106','0',1,1,4),('8','112','0',1,1,4),('8','113','0',1,1,4),('8','114','0',1,1,4),('8','115','0',1,1,4),('8','116','0',1,1,4),('8','117','0',1,1,4),('8','118','0',1,1,4),('8','119','0',1,1,4),('8','120','0',1,1,4),('8','121','0',1,1,4),('8','122','0',1,1,4),('8','123','0',1,1,4),('8','124','0',1,1,4),('8','125','0',1,1,4),('9','171','0',1,1,4),('9','172','0',1,1,4),('9','173','0',1,1,4),('9','174','0',1,1,4),('9','175','0',1,1,4),('9','176','0',1,1,4),('9','177','0',1,1,4),('9','178','0',1,1,4),('9','179','0',1,1,4),('9','180','0',1,1,4),('9','181','0',1,1,4),('9','182','0',1,1,4),('9','183','0',1,1,4),('10','154','0',1,1,4),('10','155','0',1,1,4),('10','156','0',1,1,4),('10','157','0',1,1,4),('10','158','0',1,1,4),('10','159','0',1,1,4),('10','160','0',1,1,4),('10','161','0',1,1,4),('10','162','0',1,1,4),('10','163','0',1,1,4),('10','164','0',1,1,4),('10','169','0',1,1,4),('10','170','0',1,1,4),('11','147','0',1,1,4),('11','148','0',1,1,4),('11','149','0',1,1,4),('11','150','0',1,1,4),('11','151','0',1,1,4),('11','152','0',1,1,4),('11','153','0',1,1,4),('12','126','0',1,1,4),('12','127','0',1,1,4),('12','128','0',1,1,4),('12','129','0',1,1,4),('12','130','0',1,1,4),('12','131','0',1,1,4),('12','132','0',1,1,4),('12','133','0',1,1,4),('12','134','0',1,1,4),('12','135','0',1,1,4),('12','136','0',1,1,4),('12','137','0',1,1,4),('12','138','0',1,1,4),('12','139','0',1,1,4),('12','140','0',1,1,4),('12','141','0',1,1,4),('2','76','10000',0,2,4),('2','77','10000',0,2,4),('2','78','10000',0,2,4),('2','79','10000',0,2,4),('2','80','10000',0,2,4),('2','81','10000',0,2,4),('2','82','10000',0,2,4),('2','83','10000',0,2,4),('2','84','10000',0,2,4),('2','85','10000',0,2,4),('2','86','10000',0,2,4),('2','87','10000',0,2,4),('2','88','10000',0,2,4),('2','89','10000',0,2,4),('2','90','10000',0,2,4),('2','91','10000',0,2,4),('2','92','10000',0,2,4),('2','93','10000',0,2,4),('2','94','10000',0,2,4),('2','95','10000',0,2,4),('2','96','10000',0,2,4),('2','97','10000',0,2,4),('2','98','10000',0,2,4),('2','99','10000',0,2,4),('2','100','10000',0,2,4),('2','101','10000',0,2,4),('2','102','10000',0,2,4),('2','103','10000',0,2,4),('2','104','10000',0,2,4),('2','105','10000',0,2,4),('2','106','10000',0,2,4),('2','112','10000',0,2,4),('2','113','10000',0,2,4),('2','114','10000',0,2,4),('2','115','10000',0,2,4),('2','116','10000',0,2,4),('2','117','10000',0,2,4),('2','118','10000',0,2,4),('2','119','10000',0,2,4),('2','120','10000',0,2,4),('2','121','10000',0,2,4),('2','122','10000',0,2,4),('2','123','10000',0,2,4),('2','124','10000',0,2,4),('2','125','10000',0,2,4),('2','126','10000',0,2,4),('2','127','10000',0,2,4),('2','128','10000',0,2,4),('2','129','10000',0,2,4),('2','130','10000',0,2,4),('2','131','10000',0,2,4),('2','132','10000',0,2,4),('2','133','10000',0,2,4),('2','134','10000',0,2,4),('2','135','10000',0,2,4),('2','136','10000',0,2,4),('2','137','10000',0,2,4),('2','138','10000',0,2,4),('2','139','10000',0,2,4),('2','140','10000',0,2,4),('2','141','10000',0,2,4),('2','142','10000',0,2,4),('2','143','10000',0,2,4),('2','144','10000',0,2,4),('2','145','10000',0,2,4),('2','146','10000',0,2,4),('2','147','10000',0,2,4),('2','148','10000',0,2,4),('2','149','10000',0,2,4),('2','150','10000',0,2,4),('2','151','10000',0,2,4),('2','152','10000',0,2,4),('2','153','10000',0,2,4),('2','154','10000',0,2,4),('2','155','10000',0,2,4),('2','156','10000',0,2,4),('2','157','10000',0,2,4),('2','158','10000',0,2,4),('2','159','10000',0,2,4),('2','160','10000',0,2,4),('2','161','10000',0,2,4),('2','162','10000',0,2,4),('2','163','10000',0,2,4),('2','164','10000',0,2,4),('2','169','10000',0,2,4),('2','170','10000',0,2,4),('2','171','10000',0,2,4),('2','172','10000',0,2,4),('2','173','10000',0,2,4),('2','174','10000',0,2,4),('2','175','10000',0,2,4),('2','176','10000',0,2,4),('2','177','10000',0,2,4),('2','178','10000',0,2,4),('2','179','10000',0,2,4),('2','180','10000',0,2,4),('2','181','10000',0,2,4),('2','182','10000',0,2,4),('2','183','10000',0,2,4),('2','108','0',1,2,4),('2','109','0',1,2,4),('2','110','0',1,2,4),('2','111','0',1,2,4),('2','184','0',1,2,4),('2','185','0',1,2,4),('4','76','0',1,2,4),('4','77','0',1,2,4),('4','78','0',1,2,4),('4','79','0',1,2,4),('4','80','0',1,2,4),('5','81','0',1,2,4),('5','82','0',1,2,4),('5','83','0',1,2,4),('5','84','0',1,2,4),('5','85','0',1,2,4),('5','86','0',1,2,4),('5','87','0',1,2,4),('5','88','0',1,2,4),('5','89','0',1,2,4),('6','142','0',1,2,4),('6','143','0',1,2,4),('6','144','0',1,2,4),('6','145','0',1,2,4),('6','146','0',1,2,4),('7','90','0',1,2,4),('7','91','0',1,2,4),('7','92','0',1,2,4),('7','93','0',1,2,4),('7','94','0',1,2,4),('7','95','0',1,2,4),('7','96','0',1,2,4),('7','97','0',1,2,4),('7','98','0',1,2,4),('7','99','0',1,2,4),('7','100','0',1,2,4),('7','101','0',1,2,4),('7','102','0',1,2,4),('7','103','0',1,2,4),('7','104','0',1,2,4),('7','105','0',1,2,4),('7','106','0',1,2,4),('8','112','0',1,2,4),('8','113','0',1,2,4),('8','114','0',1,2,4),('8','115','0',1,2,4),('8','116','0',1,2,4),('8','117','0',1,2,4),('8','118','0',1,2,4),('8','119','0',1,2,4),('8','120','0',1,2,4),('8','121','0',1,2,4),('8','122','0',1,2,4),('8','123','0',1,2,4),('8','124','0',1,2,4),('8','125','0',1,2,4),('9','171','0',1,2,4),('9','172','0',1,2,4),('9','173','0',1,2,4),('9','174','0',1,2,4),('9','175','0',1,2,4),('9','176','0',1,2,4),('9','177','0',1,2,4),('9','178','0',1,2,4),('9','179','0',1,2,4),('9','180','0',1,2,4),('9','181','0',1,2,4),('9','182','0',1,2,4),('9','183','0',1,2,4),('10','154','0',1,2,4),('10','155','0',1,2,4),('10','156','0',1,2,4),('10','157','0',1,2,4),('10','158','0',1,2,4),('10','159','0',1,2,4),('10','160','0',1,2,4),('10','161','0',1,2,4),('10','162','0',1,2,4),('10','163','0',1,2,4),('10','164','0',1,2,4),('10','169','0',1,2,4),('10','170','0',1,2,4),('11','147','0',1,2,4),('11','148','0',1,2,4),('11','149','0',1,2,4),('11','150','0',1,2,4),('11','151','0',1,2,4),('11','152','0',1,2,4),('11','153','0',1,2,4),('12','126','0',1,2,4),('12','127','0',1,2,4),('12','128','0',1,2,4),('12','129','0',1,2,4),('12','130','0',1,2,4),('12','131','0',1,2,4),('12','132','0',1,2,4),('12','133','0',1,2,4),('12','134','0',1,2,4),('12','135','0',1,2,4),('12','136','0',1,2,4),('12','137','0',1,2,4),('12','138','0',1,2,4),('12','139','0',1,2,4),('12','140','0',1,2,4),('12','141','0',1,2,4),('2','76','10000',0,3,4),('2','77','10000',0,3,4),('2','78','10000',0,3,4),('2','79','10000',0,3,4),('2','80','10000',0,3,4),('2','81','10000',0,3,4),('2','82','10000',0,3,4),('2','83','10000',0,3,4),('2','84','10000',0,3,4),('2','85','10000',0,3,4),('2','86','10000',0,3,4),('2','87','10000',0,3,4),('2','88','10000',0,3,4),('2','89','10000',0,3,4),('2','90','10000',0,3,4),('2','91','10000',0,3,4),('2','92','10000',0,3,4),('2','93','10000',0,3,4),('2','94','10000',0,3,4),('2','95','10000',0,3,4),('2','96','10000',0,3,4),('2','97','10000',0,3,4),('2','98','10000',0,3,4),('2','99','10000',0,3,4),('2','100','10000',0,3,4),('2','101','10000',0,3,4),('2','102','10000',0,3,4),('2','103','10000',0,3,4),('2','104','10000',0,3,4),('2','105','10000',0,3,4),('2','106','10000',0,3,4),('2','112','10000',0,3,4),('2','113','10000',0,3,4),('2','114','10000',0,3,4),('2','115','10000',0,3,4),('2','116','10000',0,3,4),('2','117','10000',0,3,4),('2','118','10000',0,3,4),('2','119','10000',0,3,4),('2','120','10000',0,3,4),('2','121','10000',0,3,4),('2','122','10000',0,3,4),('2','123','10000',0,3,4),('2','124','10000',0,3,4),('2','125','10000',0,3,4),('2','126','10000',0,3,4),('2','127','10000',0,3,4),('2','128','10000',0,3,4),('2','129','10000',0,3,4),('2','130','10000',0,3,4),('2','131','10000',0,3,4),('2','132','10000',0,3,4),('2','133','10000',0,3,4),('2','134','10000',0,3,4),('2','135','10000',0,3,4),('2','136','10000',0,3,4),('2','137','10000',0,3,4),('2','138','10000',0,3,4),('2','139','10000',0,3,4),('2','140','10000',0,3,4),('2','141','10000',0,3,4),('2','142','10000',0,3,4),('2','143','10000',0,3,4),('2','144','10000',0,3,4),('2','145','10000',0,3,4),('2','146','10000',0,3,4),('2','147','10000',0,3,4),('2','148','10000',0,3,4),('2','149','10000',0,3,4),('2','150','10000',0,3,4),('2','151','10000',0,3,4),('2','152','10000',0,3,4),('2','153','10000',0,3,4),('2','154','10000',0,3,4),('2','155','10000',0,3,4),('2','156','10000',0,3,4),('2','157','10000',0,3,4),('2','158','10000',0,3,4),('2','159','10000',0,3,4),('2','160','10000',0,3,4),('2','161','10000',0,3,4),('2','162','10000',0,3,4),('2','163','10000',0,3,4),('2','164','10000',0,3,4),('2','169','10000',0,3,4),('2','170','10000',0,3,4),('2','171','10000',0,3,4),('2','172','10000',0,3,4),('2','173','10000',0,3,4),('2','174','10000',0,3,4),('2','175','10000',0,3,4),('2','176','10000',0,3,4),('2','177','10000',0,3,4),('2','178','10000',0,3,4),('2','179','10000',0,3,4),('2','180','10000',0,3,4),('2','181','10000',0,3,4),('2','182','10000',0,3,4),('2','183','10000',0,3,4),('2','108','0',1,3,4),('2','109','0',1,3,4),('2','110','0',1,3,4),('2','111','0',1,3,4),('2','184','0',1,3,4),('2','185','0',1,3,4),('4','76','0',1,3,4),('4','77','0',1,3,4),('4','78','0',1,3,4),('4','79','0',1,3,4),('4','80','0',1,3,4),('5','81','0',1,3,4),('5','82','0',1,3,4),('5','83','0',1,3,4),('5','84','0',1,3,4),('5','85','0',1,3,4),('5','86','0',1,3,4),('5','87','0',1,3,4),('5','88','0',1,3,4),('5','89','0',1,3,4),('6','142','0',1,3,4),('6','143','0',1,3,4),('6','144','0',1,3,4),('6','145','0',1,3,4),('6','146','0',1,3,4),('7','90','0',1,3,4),('7','91','0',1,3,4),('7','92','0',1,3,4),('7','93','0',1,3,4),('7','94','0',1,3,4),('7','95','0',1,3,4),('7','96','0',1,3,4),('7','97','0',1,3,4),('7','98','0',1,3,4),('7','99','0',1,3,4),('7','100','0',1,3,4),('7','101','0',1,3,4),('7','102','0',1,3,4),('7','103','0',1,3,4),('7','104','0',1,3,4),('7','105','0',1,3,4),('7','106','0',1,3,4),('8','112','0',1,3,4),('8','113','0',1,3,4),('8','114','0',1,3,4),('8','115','0',1,3,4),('8','116','0',1,3,4),('8','117','0',1,3,4),('8','118','0',1,3,4),('8','119','0',1,3,4),('8','120','0',1,3,4),('8','121','0',1,3,4),('8','122','0',1,3,4),('8','123','0',1,3,4),('8','124','0',1,3,4),('8','125','0',1,3,4),('9','171','0',1,3,4),('9','172','0',1,3,4),('9','173','0',1,3,4),('9','174','0',1,3,4),('9','175','0',1,3,4),('9','176','0',1,3,4),('9','177','0',1,3,4),('9','178','0',1,3,4),('9','179','0',1,3,4),('9','180','0',1,3,4),('9','181','0',1,3,4),('9','182','0',1,3,4),('9','183','0',1,3,4),('10','154','0',1,3,4),('10','155','0',1,3,4),('10','156','0',1,3,4),('10','157','0',1,3,4),('10','158','0',1,3,4),('10','159','0',1,3,4),('10','160','0',1,3,4),('10','161','0',1,3,4),('10','162','0',1,3,4),('10','163','0',1,3,4),('10','164','0',1,3,4),('10','169','0',1,3,4),('10','170','0',1,3,4),('11','147','0',1,3,4),('11','148','0',1,3,4),('11','149','0',1,3,4),('11','150','0',1,3,4),('11','151','0',1,3,4),('11','152','0',1,3,4),('11','153','0',1,3,4),('12','126','0',1,3,4),('12','127','0',1,3,4),('12','128','0',1,3,4),('12','129','0',1,3,4),('12','130','0',1,3,4),('12','131','0',1,3,4),('12','132','0',1,3,4),('12','133','0',1,3,4),('12','134','0',1,3,4),('12','135','0',1,3,4),('12','136','0',1,3,4),('12','137','0',1,3,4),('12','138','0',1,3,4),('12','139','0',1,3,4),('12','140','0',1,3,4),('12','141','0',1,3,4),('2','76','10000',0,13,4),('2','77','10000',0,13,4),('2','78','10000',0,13,4),('2','79','10000',0,13,4),('2','80','10000',0,13,4),('2','81','10000',0,13,4),('2','82','10000',0,13,4),('2','83','10000',0,13,4),('2','84','10000',0,13,4),('2','85','10000',0,13,4),('2','86','10000',0,13,4),('2','87','10000',0,13,4),('2','88','10000',0,13,4),('2','89','10000',0,13,4),('2','90','10000',0,13,4),('2','91','10000',0,13,4),('2','92','10000',0,13,4),('2','93','10000',0,13,4),('2','94','10000',0,13,4),('2','95','10000',0,13,4),('2','96','10000',0,13,4),('2','97','10000',0,13,4),('2','98','10000',0,13,4),('2','99','10000',0,13,4),('2','100','10000',0,13,4),('2','101','10000',0,13,4),('2','102','10000',0,13,4),('2','103','10000',0,13,4),('2','104','10000',0,13,4),('2','105','10000',0,13,4),('2','106','10000',0,13,4),('2','112','10000',0,13,4),('2','113','10000',0,13,4),('2','114','10000',0,13,4),('2','115','10000',0,13,4),('2','116','10000',0,13,4),('2','117','10000',0,13,4),('2','118','10000',0,13,4),('2','119','10000',0,13,4),('2','120','10000',0,13,4),('2','121','10000',0,13,4),('2','122','10000',0,13,4),('2','123','10000',0,13,4),('2','124','10000',0,13,4),('2','125','10000',0,13,4),('2','126','10000',0,13,4),('2','127','10000',0,13,4),('2','128','10000',0,13,4),('2','129','10000',0,13,4),('2','130','10000',0,13,4),('2','131','10000',0,13,4),('2','132','10000',0,13,4),('2','133','10000',0,13,4),('2','134','10000',0,13,4),('2','135','10000',0,13,4),('2','136','10000',0,13,4),('2','137','10000',0,13,4),('2','138','10000',0,13,4),('2','139','10000',0,13,4),('2','140','10000',0,13,4),('2','141','10000',0,13,4),('2','142','10000',0,13,4),('2','143','10000',0,13,4),('2','144','10000',0,13,4),('2','145','10000',0,13,4),('2','146','10000',0,13,4),('2','147','10000',0,13,4),('2','148','10000',0,13,4),('2','149','10000',0,13,4),('2','150','10000',0,13,4),('2','151','10000',0,13,4),('2','152','10000',0,13,4),('2','153','10000',0,13,4),('2','154','10000',0,13,4),('2','155','10000',0,13,4),('2','156','10000',0,13,4),('2','157','10000',0,13,4),('2','158','10000',0,13,4),('2','159','10000',0,13,4),('2','160','10000',0,13,4),('2','161','10000',0,13,4),('2','162','10000',0,13,4),('2','163','10000',0,13,4),('2','164','10000',0,13,4),('2','169','10000',0,13,4),('2','170','10000',0,13,4),('2','171','10000',0,13,4),('2','172','10000',0,13,4),('2','173','10000',0,13,4),('2','174','10000',0,13,4),('2','175','10000',0,13,4),('2','176','10000',0,13,4),('2','177','10000',0,13,4),('2','178','10000',0,13,4),('2','179','10000',0,13,4),('2','180','10000',0,13,4),('2','181','10000',0,13,4),('2','182','10000',0,13,4),('2','183','10000',0,13,4),('2','108','0',1,13,4),('2','109','0',1,13,4),('2','110','0',1,13,4),('2','111','0',1,13,4),('2','184','0',1,13,4),('2','185','0',1,13,4),('4','76','0',1,13,4),('4','77','0',1,13,4),('4','78','0',1,13,4),('4','79','0',1,13,4),('4','80','0',1,13,4),('5','81','0',1,13,4),('5','82','0',1,13,4),('5','83','0',1,13,4),('5','84','0',1,13,4),('5','85','0',1,13,4),('5','86','0',1,13,4),('5','87','0',1,13,4),('5','88','0',1,13,4),('5','89','0',1,13,4),('6','142','0',1,13,4),('6','143','0',1,13,4),('6','144','0',1,13,4),('6','145','0',1,13,4),('6','146','0',1,13,4),('7','90','0',1,13,4),('7','91','0',1,13,4),('7','92','0',1,13,4),('7','93','0',1,13,4),('7','94','0',1,13,4),('7','95','0',1,13,4),('7','96','0',1,13,4),('7','97','0',1,13,4),('7','98','0',1,13,4),('7','99','0',1,13,4),('7','100','0',1,13,4),('7','101','0',1,13,4),('7','102','0',1,13,4),('7','103','0',1,13,4),('7','104','0',1,13,4),('7','105','0',1,13,4),('7','106','0',1,13,4),('8','112','0',1,13,4),('8','113','0',1,13,4),('8','114','0',1,13,4),('8','115','0',1,13,4),('8','116','0',1,13,4),('8','117','0',1,13,4),('8','118','0',1,13,4),('8','119','0',1,13,4),('8','120','0',1,13,4),('8','121','0',1,13,4),('8','122','0',1,13,4),('8','123','0',1,13,4),('8','124','0',1,13,4),('8','125','0',1,13,4),('9','171','0',1,13,4),('9','172','0',1,13,4),('9','173','0',1,13,4),('9','174','0',1,13,4),('9','175','0',1,13,4),('9','176','0',1,13,4),('9','177','0',1,13,4),('9','178','0',1,13,4),('9','179','0',1,13,4),('9','180','0',1,13,4),('9','181','0',1,13,4),('9','182','0',1,13,4),('9','183','0',1,13,4),('10','154','0',1,13,4),('10','155','0',1,13,4),('10','156','0',1,13,4),('10','157','0',1,13,4),('10','158','0',1,13,4),('10','159','0',1,13,4),('10','160','0',1,13,4),('10','161','0',1,13,4),('10','162','0',1,13,4),('10','163','0',1,13,4),('10','164','0',1,13,4),('10','169','0',1,13,4),('10','170','0',1,13,4),('11','147','0',1,13,4),('11','148','0',1,13,4),('11','149','0',1,13,4),('11','150','0',1,13,4),('11','151','0',1,13,4),('11','152','0',1,13,4),('11','153','0',1,13,4),('12','126','0',1,13,4),('12','127','0',1,13,4),('12','128','0',1,13,4),('12','129','0',1,13,4),('12','130','0',1,13,4),('12','131','0',1,13,4),('12','132','0',1,13,4),('12','133','0',1,13,4),('12','134','0',1,13,4),('12','135','0',1,13,4),('12','136','0',1,13,4),('12','137','0',1,13,4),('12','138','0',1,13,4),('12','139','0',1,13,4),('12','140','0',1,13,4),('12','141','0',1,13,4);
/*!40000 ALTER TABLE `catalog_category_product_index_replica` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_category_product_index_tmp`
--

DROP TABLE IF EXISTS `catalog_category_product_index_tmp`;
CREATE TABLE `catalog_category_product_index_tmp` (
  `category_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Category ID',
  `product_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Product ID',
  `position` int(11) NOT NULL DEFAULT '0' COMMENT 'Position',
  `is_parent` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Parent',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `visibility` smallint(5) unsigned NOT NULL COMMENT 'Visibility',
  PRIMARY KEY (`category_id`,`product_id`,`store_id`)
) ENGINE=MEMORY DEFAULT CHARSET=utf8 COMMENT='Catalog Category Product Indexer temporary table';

--
-- Dumping data for table `catalog_category_product_index_tmp`
--

LOCK TABLES `catalog_category_product_index_tmp` WRITE;
/*!40000 ALTER TABLE `catalog_category_product_index_tmp` DISABLE KEYS */;
INSERT INTO `catalog_category_product_index_tmp` VALUES ('10','154','0',1,3,4),('10','155','0',1,3,4),('10','156','0',1,3,4),('10','157','0',1,3,4),('10','158','0',1,3,4),('10','159','0',1,3,4),('10','160','0',1,3,4),('10','161','0',1,3,4),('10','162','0',1,3,4),('10','163','0',1,3,4),('10','164','0',1,3,4),('10','169','0',1,3,4),('10','170','0',1,3,4),('11','147','0',1,3,4),('11','148','0',1,3,4),('11','149','0',1,3,4),('11','150','0',1,3,4),('11','151','0',1,3,4),('11','152','0',1,3,4),('11','153','0',1,3,4),('12','126','0',1,3,4),('12','127','0',1,3,4),('12','128','0',1,3,4),('12','129','0',1,3,4),('12','130','0',1,3,4),('12','131','0',1,3,4),('12','132','0',1,3,4),('12','133','0',1,3,4),('12','134','0',1,3,4),('12','135','0',1,3,4),('12','136','0',1,3,4),('12','137','0',1,3,4),('12','138','0',1,3,4),('12','139','0',1,3,4),('12','140','0',1,3,4),('12','141','0',1,3,4),('4','76','0',1,3,4),('4','77','0',1,3,4),('4','78','0',1,3,4),('4','79','0',1,3,4),('4','80','0',1,3,4),('5','81','0',1,3,4),('5','82','0',1,3,4),('5','83','0',1,3,4),('5','84','0',1,3,4),('5','85','0',1,3,4),('5','86','0',1,3,4),('5','87','0',1,3,4),('5','88','0',1,3,4),('5','89','0',1,3,4),('6','142','0',1,3,4),('6','143','0',1,3,4),('6','144','0',1,3,4),('6','145','0',1,3,4),('6','146','0',1,3,4),('7','90','0',1,3,4),('7','91','0',1,3,4),('7','92','0',1,3,4),('7','93','0',1,3,4),('7','94','0',1,3,4),('7','95','0',1,3,4),('7','96','0',1,3,4),('7','97','0',1,3,4),('7','98','0',1,3,4),('7','99','0',1,3,4),('7','100','0',1,3,4),('7','101','0',1,3,4),('7','102','0',1,3,4),('7','103','0',1,3,4),('7','104','0',1,3,4),('7','105','0',1,3,4),('7','106','0',1,3,4),('8','112','0',1,3,4),('8','113','0',1,3,4),('8','114','0',1,3,4),('8','115','0',1,3,4),('8','116','0',1,3,4),('8','117','0',1,3,4),('8','118','0',1,3,4),('8','119','0',1,3,4),('8','120','0',1,3,4),('8','121','0',1,3,4),('8','122','0',1,3,4),('8','123','0',1,3,4),('8','124','0',1,3,4),('8','125','0',1,3,4),('9','171','0',1,3,4),('9','172','0',1,3,4),('9','173','0',1,3,4),('9','174','0',1,3,4),('9','175','0',1,3,4),('9','176','0',1,3,4),('9','177','0',1,3,4),('9','178','0',1,3,4),('9','179','0',1,3,4),('9','180','0',1,3,4),('9','181','0',1,3,4),('9','182','0',1,3,4),('9','183','0',1,3,4);
/*!40000 ALTER TABLE `catalog_category_product_index_tmp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_compare_item`
--

DROP TABLE IF EXISTS `catalog_compare_item`;
CREATE TABLE `catalog_compare_item` (
  `catalog_compare_item_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Compare Item ID',
  `visitor_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Visitor ID',
  `customer_id` int(10) unsigned DEFAULT NULL COMMENT 'Customer ID',
  `product_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Product ID',
  `store_id` smallint(5) unsigned DEFAULT NULL COMMENT 'Store ID',
  PRIMARY KEY (`catalog_compare_item_id`),
  KEY `CATALOG_COMPARE_ITEM_PRODUCT_ID` (`product_id`),
  KEY `CATALOG_COMPARE_ITEM_VISITOR_ID_PRODUCT_ID` (`visitor_id`,`product_id`),
  KEY `CATALOG_COMPARE_ITEM_CUSTOMER_ID_PRODUCT_ID` (`customer_id`,`product_id`),
  KEY `CATALOG_COMPARE_ITEM_STORE_ID` (`store_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Compare Table';

--
-- Table structure for table `catalog_eav_attribute`
--

DROP TABLE IF EXISTS `catalog_eav_attribute`;
CREATE TABLE `catalog_eav_attribute` (
  `attribute_id` smallint(5) unsigned NOT NULL COMMENT 'Attribute ID',
  `frontend_input_renderer` varchar(255) DEFAULT NULL COMMENT 'Frontend Input Renderer',
  `is_global` smallint(5) unsigned NOT NULL DEFAULT '1' COMMENT 'Is Global',
  `is_visible` smallint(5) unsigned NOT NULL DEFAULT '1' COMMENT 'Is Visible',
  `is_searchable` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Searchable',
  `is_filterable` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Filterable',
  `is_comparable` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Comparable',
  `is_visible_on_front` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Visible On Front',
  `is_html_allowed_on_front` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is HTML Allowed On Front',
  `is_used_for_price_rules` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Used For Price Rules',
  `is_filterable_in_search` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Filterable In Search',
  `used_in_product_listing` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Used In Product Listing',
  `used_for_sort_by` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Used For Sorting',
  `apply_to` varchar(255) DEFAULT NULL COMMENT 'Apply To',
  `is_visible_in_advanced_search` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Visible In Advanced Search',
  `position` int(11) NOT NULL DEFAULT '0' COMMENT 'Position',
  `is_wysiwyg_enabled` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is WYSIWYG Enabled',
  `is_used_for_promo_rules` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Used For Promo Rules',
  `is_required_in_admin_store` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Required In Admin Store',
  `is_used_in_grid` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Used in Grid',
  `is_visible_in_grid` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Visible in Grid',
  `is_filterable_in_grid` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Filterable in Grid',
  `search_weight` float NOT NULL DEFAULT '1' COMMENT 'Search Weight',
  `additional_data` text COMMENT 'Additional swatch attributes data',
  PRIMARY KEY (`attribute_id`),
  KEY `CATALOG_EAV_ATTRIBUTE_USED_FOR_SORT_BY` (`used_for_sort_by`),
  KEY `CATALOG_EAV_ATTRIBUTE_USED_IN_PRODUCT_LISTING` (`used_in_product_listing`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog EAV Attribute Table';

--
-- Dumping data for table `catalog_eav_attribute`
--

LOCK TABLES `catalog_eav_attribute` WRITE;
/*!40000 ALTER TABLE `catalog_eav_attribute` DISABLE KEYS */;
INSERT INTO `catalog_eav_attribute` VALUES (45,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,0,0,0,'1',NULL),(46,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,0,0,0,'1',NULL),(47,NULL,0,1,0,0,0,0,1,0,0,0,0,NULL,0,'0',1,0,0,0,0,0,'1',NULL),(48,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,0,0,0,'1',NULL),(49,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,0,0,0,'1',NULL),(50,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,0,0,0,'1',NULL),(51,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,0,0,0,'1',NULL),(52,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,0,0,0,'1',NULL),(53,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,0,0,0,'1',NULL),(54,NULL,1,1,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,0,0,0,'1',NULL),(55,NULL,1,0,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,0,0,0,'1',NULL),(56,NULL,1,0,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,0,0,0,'1',NULL),(57,NULL,1,0,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,0,0,0,'1',NULL),(58,NULL,1,0,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,0,0,0,'1',NULL),(59,NULL,1,0,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,0,0,0,'1',NULL),(60,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,0,0,0,'1',NULL),(61,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,0,0,0,'1',NULL),(62,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,0,0,0,'1',NULL),(63,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,0,0,0,'1',NULL),(64,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,0,0,0,'1',NULL),(65,NULL,1,0,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,0,0,0,'1',NULL),(66,NULL,1,0,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,0,0,0,'1',NULL),(67,'Magento\\Catalog\\Block\\Adminhtml\\Category\\Helper\\Sortby\\Available',0,1,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,0,0,0,'1',NULL),(68,'Magento\\Catalog\\Block\\Adminhtml\\Category\\Helper\\Sortby\\DefaultSortby',0,1,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,0,0,0,'1',NULL),(69,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,0,0,0,'1',NULL),(70,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,0,0,0,'1',NULL),(71,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,0,0,0,'1',NULL),(72,'Magento\\Catalog\\Block\\Adminhtml\\Category\\Helper\\Pricestep',0,1,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,0,0,0,'1',NULL),(73,NULL,0,1,1,0,0,0,0,0,0,1,1,NULL,1,'0',0,0,0,0,0,0,'5',NULL),(74,NULL,1,1,1,0,1,0,0,0,0,0,0,NULL,1,'0',0,0,0,0,0,0,'6',NULL),(75,NULL,0,1,1,0,1,0,1,0,0,0,0,NULL,1,'0',1,0,0,0,0,0,'1',NULL),(76,NULL,0,1,1,0,1,0,1,0,0,1,0,NULL,1,'0',1,0,0,1,0,0,'1',NULL),(77,NULL,1,1,1,1,0,0,0,0,0,1,1,'simple,virtual,bundle,downloadable,configurable',1,'0',0,0,0,0,0,0,'1',NULL),(78,NULL,1,1,0,0,0,0,0,0,0,1,0,'simple,virtual,bundle,downloadable,configurable',0,'0',0,0,0,1,0,1,'1',NULL),(79,NULL,2,1,0,0,0,0,0,0,0,1,0,'simple,virtual,bundle,downloadable,configurable',0,'0',0,0,0,1,0,0,'1',NULL),(80,NULL,2,1,0,0,0,0,0,0,0,1,0,'simple,virtual,bundle,downloadable,configurable',0,'0',0,0,0,1,0,0,'1',NULL),(81,NULL,1,1,0,0,0,0,0,0,0,0,0,'simple,virtual,downloadable',0,'0',0,0,0,1,0,1,'1',NULL),(82,'Magento\\Catalog\\Block\\Adminhtml\\Product\\Helper\\Form\\Weight',1,1,0,0,0,0,0,0,0,0,0,'simple,virtual,bundle,downloadable,configurable',0,'0',0,0,0,1,0,1,'1',NULL),(83,NULL,1,1,1,1,1,0,0,0,0,0,0,NULL,1,'0',0,0,0,1,0,1,'1',NULL),(84,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,1,0,1,'1',NULL),(85,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,1,0,1,'1',NULL),(86,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,1,0,1,'1',NULL),(87,NULL,0,1,0,0,0,0,0,0,0,1,0,NULL,0,'0',0,0,0,0,0,0,'1',NULL),(88,NULL,0,1,0,0,0,0,0,0,0,1,0,NULL,0,'0',0,0,0,0,0,0,'1',NULL),(89,NULL,0,1,0,0,0,0,0,0,0,1,0,NULL,0,'0',0,0,0,0,0,0,'1',NULL),(90,NULL,1,1,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,0,0,0,'1',NULL),(91,NULL,1,0,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,0,0,0,'1',NULL),(92,NULL,2,1,0,0,0,0,0,0,0,0,0,'simple,virtual,bundle,downloadable',0,'0',0,0,0,0,0,0,'1',NULL),(93,NULL,1,1,1,1,1,0,0,0,0,0,0,NULL,1,'0',0,0,0,1,0,1,'1',NULL),(94,NULL,2,1,0,0,0,0,0,0,0,1,0,NULL,0,'0',0,0,0,1,0,0,'1',NULL),(95,NULL,2,1,0,0,0,0,0,0,0,1,0,NULL,0,'0',0,0,0,1,0,0,'1',NULL),(96,NULL,1,1,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,0,0,0,'1',NULL),(97,'Magento\\Framework\\Data\\Form\\Element\\Hidden',2,1,1,0,0,0,0,0,0,1,0,NULL,0,'0',0,0,1,0,0,0,'1',NULL),(98,NULL,1,0,0,0,0,0,0,0,0,0,0,'simple,virtual,bundle,downloadable,configurable',0,'0',0,0,0,0,0,0,'1',NULL),(99,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,1,0,0,0,'1',NULL),(100,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,1,0,1,'1',NULL),(101,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,1,0,0,'1',NULL),(102,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,1,0,0,'1',NULL),(103,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,0,0,0,'1',NULL),(104,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,1,0,0,'1',NULL),(105,'Magento\\Catalog\\Block\\Adminhtml\\Product\\Helper\\Form\\Category',1,1,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,0,0,0,'1',NULL),(106,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,0,0,0,'1',NULL),(107,NULL,1,0,0,0,0,0,0,0,0,1,0,NULL,0,'0',0,0,0,0,0,0,'1',NULL),(108,NULL,1,0,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,0,0,0,'1',NULL),(109,NULL,0,0,0,0,0,0,0,0,0,1,0,NULL,0,'0',0,0,0,0,0,0,'1',NULL),(110,NULL,0,0,0,0,0,0,0,0,0,1,0,NULL,0,'0',0,0,0,0,0,0,'1',NULL),(111,NULL,0,0,0,0,0,0,0,0,0,1,0,NULL,0,'0',0,0,0,0,0,0,'1',NULL),(112,NULL,1,0,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,0,0,0,'1',NULL),(113,NULL,1,0,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,0,0,0,'1',NULL),(114,NULL,2,1,0,0,0,0,0,0,0,0,0,'simple,bundle,grouped,configurable',0,'0',0,0,0,1,0,1,'1',NULL),(115,'Magento\\CatalogInventory\\Block\\Adminhtml\\Form\\Field\\Stock',1,1,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,0,0,0,'1',NULL),(116,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,1,0,0,'1',NULL),(117,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,0,0,0,'1',NULL),(118,NULL,0,0,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,0,0,0,'1',NULL),(119,NULL,0,1,0,0,0,0,0,0,0,1,0,NULL,0,'0',0,0,0,1,0,1,'1',NULL),(120,NULL,0,0,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,0,0,0,'1',NULL),(121,'Magento\\Msrp\\Block\\Adminhtml\\Product\\Helper\\Form\\Type',1,1,0,0,0,0,0,0,0,1,0,'simple,virtual,downloadable,bundle,configurable',0,'0',0,0,0,1,0,1,'1',NULL),(122,'Magento\\Msrp\\Block\\Adminhtml\\Product\\Helper\\Form\\Type\\Price',2,1,0,0,0,0,0,0,0,1,0,'simple,virtual,downloadable,bundle,configurable',0,'0',0,0,0,0,0,0,'1',NULL),(123,NULL,1,1,0,0,0,0,0,0,0,1,0,'bundle',0,'0',0,0,0,0,0,0,'1',NULL),(124,NULL,1,1,0,0,0,0,0,0,0,0,0,'bundle',0,'0',0,0,0,0,0,0,'1',NULL),(125,NULL,1,1,0,0,0,0,0,0,0,1,0,'bundle',0,'0',0,0,0,0,0,0,'1',NULL),(126,NULL,1,1,0,0,0,0,0,0,0,1,0,'bundle',0,'0',0,0,0,0,0,0,'1',NULL),(127,NULL,1,1,0,0,0,0,0,0,0,1,0,'bundle',0,'0',0,0,0,0,0,0,'1',NULL),(128,NULL,1,0,0,0,0,0,0,0,0,1,0,'downloadable',0,'0',0,0,0,0,0,0,'1',NULL),(129,NULL,0,0,0,0,0,0,0,0,0,0,0,'downloadable',0,'0',0,0,0,0,0,0,'1',NULL),(130,NULL,0,0,0,0,0,0,0,0,0,0,0,'downloadable',0,'0',0,0,0,0,0,0,'1',NULL),(131,NULL,1,0,0,0,0,0,0,0,0,1,0,'downloadable',0,'0',0,0,0,0,0,0,'1',NULL),(132,'Magento\\GiftMessage\\Block\\Adminhtml\\Product\\Helper\\Form\\Config',1,1,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,1,0,0,'1',NULL),(133,NULL,0,1,0,0,0,0,0,0,0,1,0,NULL,0,'0',0,0,0,0,0,0,'1',NULL),(134,NULL,2,1,1,0,0,0,0,0,0,1,0,'simple,virtual,bundle,downloadable,configurable',0,'0',0,0,0,1,0,1,'1',NULL),(135,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,0,0,0,'1',NULL),(136,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,0,0,0,'1',NULL),(137,NULL,0,1,0,0,0,0,0,0,0,1,0,'simple,virtual,configurable',0,'0',0,0,0,1,0,1,'1',NULL),(138,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,0,0,0,'1',NULL),(139,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,0,0,0,'1',NULL),(140,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,0,0,0,'1',NULL),(141,NULL,0,1,0,0,0,0,0,0,0,0,0,NULL,0,'0',0,0,0,0,0,0,'1',NULL),(142,NULL,1,1,0,0,0,0,0,0,0,0,0,'simple,configurable,bundle,virtual,downloadable',0,'0',0,0,0,0,0,1,'1',NULL),(143,NULL,0,1,0,0,0,0,0,0,0,1,0,NULL,0,'0',0,0,0,0,0,0,'1',NULL);
/*!40000 ALTER TABLE `catalog_eav_attribute` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_attribute_cl`
--

DROP TABLE IF EXISTS `catalog_product_attribute_cl`;
CREATE TABLE `catalog_product_attribute_cl` (
  `version_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Version ID',
  `entity_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  PRIMARY KEY (`version_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5209 DEFAULT CHARSET=utf8 COMMENT='catalog_product_attribute_cl';

--
-- Dumping data for table `catalog_product_attribute_cl`
--

LOCK TABLES `catalog_product_attribute_cl` WRITE;
/*!40000 ALTER TABLE `catalog_product_attribute_cl` DISABLE KEYS */;
INSERT INTO `catalog_product_attribute_cl` VALUES ('1','1'),('2','1'),('3','1'),('4','1'),('5','4'),('6','4'),('7','5'),('8','5'),('9','6'),('10','6'),('11','7'),('12','7'),('13','8'),('14','8'),('15','9'),('16','9'),('17','10'),('18','10'),('19','11'),('20','11'),('21','12'),('22','12'),('23','13'),('24','13'),('25','14'),('26','14'),('27','15'),('28','15'),('29','16'),('30','16'),('31','17'),('32','17'),('33','18'),('34','18'),('35','19'),('36','19'),('37','20'),('38','20'),('39','21'),('40','21'),('41','21'),('42','21'),('43','21'),('44','21'),('45','21'),('46','21'),('47','21'),('48','21'),('49','21'),('50','21'),('51','21'),('52','21'),('53','21'),('54','21'),('55','21'),('56','21'),('57','21'),('58','21'),('59','21'),('60','21'),('61','21'),('62','21'),('63','21'),('64','22'),('65','22'),('66','22'),('67','22'),('68','22'),('69','22'),('70','22'),('71','22'),('72','22'),('73','22'),('74','22'),('75','22'),('76','22'),('77','22'),('78','22'),('79','22'),('80','22'),('81','22'),('82','22'),('83','22'),('84','22'),('85','22'),('86','22'),('87','22'),('88','22'),('89','23'),('90','23'),('91','23'),('92','23'),('93','23'),('94','23'),('95','23'),('96','23'),('97','23'),('98','23'),('99','23'),('100','23'),('101','23'),('102','23'),('103','23'),('104','23'),('105','23'),('106','23'),('107','23'),('108','23'),('109','23'),('110','23'),('111','23'),('112','23'),('113','23'),('114','24'),('115','24'),('116','24'),('117','24'),('118','24'),('119','24'),('120','24'),('121','24'),('122','24'),('123','24'),('124','24'),('125','24'),('126','24'),('127','24'),('128','24'),('129','24'),('130','24'),('131','24'),('132','24'),('133','24'),('134','24'),('135','24'),('136','24'),('137','24'),('138','24'),('139','25'),('140','25'),('141','25'),('142','25'),('143','25'),('144','25'),('145','25'),('146','25'),('147','25'),('148','25'),('149','25'),('150','25'),('151','25'),('152','25'),('153','25'),('154','25'),('155','25'),('156','25'),('157','25'),('158','25'),('159','25'),('160','25'),('161','25'),('162','25'),('163','25'),('164','25'),('165','26'),('166','26'),('167','26'),('168','26'),('169','26'),('170','26'),('171','26'),('172','26'),('173','26'),('174','26'),('175','26'),('176','26'),('177','26'),('178','26'),('179','26'),('180','26'),('181','26'),('182','26'),('183','26'),('184','26'),('185','26'),('186','26'),('187','26'),('188','26'),('189','26'),('190','26'),('191','27'),('192','27'),('193','27'),('194','27'),('195','27'),('196','27'),('197','27'),('198','27'),('199','27'),('200','27'),('201','27'),('202','27'),('203','27'),('204','27'),('205','27'),('206','27'),('207','27'),('208','27'),('209','27'),('210','27'),('211','27'),('212','27'),('213','27'),('214','27'),('215','27'),('216','28'),('217','28'),('218','28'),('219','28'),('220','28'),('221','28'),('222','28'),('223','28'),('224','28'),('225','28'),('226','28'),('227','28'),('228','28'),('229','28'),('230','28'),('231','28'),('232','28'),('233','28'),('234','28'),('235','28'),('236','28'),('237','28'),('238','28'),('239','28'),('240','28'),('241','29'),('242','29'),('243','29'),('244','29'),('245','29'),('246','29'),('247','29'),('248','29'),('249','29'),('250','29'),('251','29'),('252','29'),('253','29'),('254','29'),('255','29'),('256','29'),('257','29'),('258','29'),('259','29'),('260','29'),('261','29'),('262','29'),('263','29'),('264','29'),('265','29'),('266','21'),('267','21'),('268','29'),('269','29'),('270','30'),('271','30'),('272','30'),('273','30'),('274','30'),('275','30'),('276','30'),('277','30'),('278','30'),('279','30'),('280','30'),('281','30'),('282','30'),('283','30'),('284','30'),('285','30'),('286','30'),('287','30'),('288','30'),('289','30'),('290','30'),('291','30'),('292','30'),('293','30'),('294','30'),('295','22'),('296','22'),('297','23'),('298','23'),('299','24'),('300','24'),('301','25'),('302','25'),('303','26'),('304','26'),('305','27'),('306','27'),('307','28'),('308','28'),('309','31'),('310','31'),('311','31'),('312','31'),('313','31'),('314','31'),('315','31'),('316','31'),('317','31'),('318','31'),('319','31'),('320','31'),('321','31'),('322','31'),('323','31'),('324','31'),('325','31'),('326','31'),('327','31'),('328','31'),('329','31'),('330','31'),('331','31'),('332','31'),('333','31'),('334','32'),('335','32'),('336','32'),('337','32'),('338','32'),('339','32'),('340','32'),('341','32'),('342','32'),('343','32'),('344','32'),('345','32'),('346','32'),('347','32'),('348','32'),('349','32'),('350','32'),('351','32'),('352','32'),('353','32'),('354','32'),('355','32'),('356','32'),('357','32'),('358','32'),('359','33'),('360','33'),('361','33'),('362','33'),('363','33'),('364','33'),('365','33'),('366','33'),('367','33'),('368','33'),('369','33'),('370','33'),('371','33'),('372','33'),('373','33'),('374','33'),('375','33'),('376','33'),('377','33'),('378','33'),('379','33'),('380','33'),('381','33'),('382','33'),('383','33'),('384','34'),('385','34'),('386','34'),('387','34'),('388','34'),('389','34'),('390','34'),('391','34'),('392','34'),('393','34'),('394','34'),('395','34'),('396','34'),('397','34'),('398','34'),('399','34'),('400','34'),('401','34'),('402','34'),('403','34'),('404','34'),('405','34'),('406','34'),('407','34'),('408','34'),('409','34'),('410','35'),('411','35'),('412','35'),('413','35'),('414','35'),('415','35'),('416','35'),('417','35'),('418','35'),('419','35'),('420','35'),('421','35'),('422','35'),('423','35'),('424','35'),('425','35'),('426','35'),('427','35'),('428','35'),('429','35'),('430','35'),('431','35'),('432','35'),('433','35'),('434','35'),('435','36'),('436','36'),('437','36'),('438','36'),('439','36'),('440','36'),('441','36'),('442','36'),('443','36'),('444','36'),('445','36'),('446','36'),('447','36'),('448','36'),('449','36'),('450','36'),('451','36'),('452','36'),('453','36'),('454','36'),('455','36'),('456','36'),('457','36'),('458','36'),('459','36'),('460','37'),('461','37'),('462','37'),('463','37'),('464','37'),('465','37'),('466','37'),('467','37'),('468','37'),('469','37'),('470','37'),('471','37'),('472','37'),('473','37'),('474','37'),('475','37'),('476','37'),('477','37'),('478','37'),('479','37'),('480','37'),('481','37'),('482','37'),('483','37'),('484','37'),('485','37'),('486','38'),('487','38'),('488','38'),('489','38'),('490','38'),('491','38'),('492','38'),('493','38'),('494','38'),('495','38'),('496','38'),('497','38'),('498','38'),('499','38'),('500','38'),('501','38'),('502','38'),('503','38'),('504','38'),('505','38'),('506','38'),('507','38'),('508','38'),('509','38'),('510','38'),('511','39'),('512','39'),('513','39'),('514','39'),('515','39'),('516','39'),('517','39'),('518','39'),('519','39'),('520','39'),('521','39'),('522','39'),('523','39'),('524','39'),('525','39'),('526','39'),('527','39'),('528','39'),('529','39'),('530','39'),('531','39'),('532','39'),('533','39'),('534','39'),('535','39'),('536','40'),('537','40'),('538','40'),('539','40'),('540','40'),('541','40'),('542','40'),('543','40'),('544','40'),('545','40'),('546','40'),('547','40'),('548','40'),('549','40'),('550','40'),('551','40'),('552','40'),('553','40'),('554','40'),('555','40'),('556','40'),('557','40'),('558','40'),('559','40'),('560','40'),('561','41'),('562','41'),('563','41'),('564','41'),('565','41'),('566','41'),('567','41'),('568','41'),('569','41'),('570','41'),('571','41'),('572','41'),('573','41'),('574','41'),('575','41'),('576','41'),('577','41'),('578','41'),('579','41'),('580','41'),('581','41'),('582','41'),('583','41'),('584','41'),('585','41'),('586','42'),('587','42'),('588','42'),('589','42'),('590','42'),('591','42'),('592','42'),('593','42'),('594','42'),('595','42'),('596','42'),('597','42'),('598','42'),('599','42'),('600','42'),('601','42'),('602','42'),('603','42'),('604','42'),('605','42'),('606','42'),('607','42'),('608','42'),('609','42'),('610','42'),('611','43'),('612','43'),('613','43'),('614','43'),('615','43'),('616','43'),('617','43'),('618','43'),('619','43'),('620','43'),('621','43'),('622','43'),('623','43'),('624','43'),('625','43'),('626','43'),('627','43'),('628','43'),('629','43'),('630','43'),('631','43'),('632','43'),('633','43'),('634','43'),('635','43'),('636','44'),('637','44'),('638','44'),('639','44'),('640','44'),('641','44'),('642','44'),('643','44'),('644','44'),('645','44'),('646','44'),('647','44'),('648','44'),('649','44'),('650','44'),('651','44'),('652','44'),('653','44'),('654','44'),('655','44'),('656','44'),('657','44'),('658','44'),('659','44'),('660','44'),('661','45'),('662','45'),('663','45'),('664','45'),('665','45'),('666','45'),('667','45'),('668','45'),('669','45'),('670','45'),('671','45'),('672','45'),('673','45'),('674','45'),('675','45'),('676','45'),('677','45'),('678','45'),('679','45'),('680','45'),('681','45'),('682','45'),('683','45'),('684','45'),('685','45'),('686','46'),('687','46'),('688','46'),('689','46'),('690','46'),('691','46'),('692','46'),('693','46'),('694','46'),('695','46'),('696','46'),('697','46'),('698','46'),('699','46'),('700','46'),('701','46'),('702','46'),('703','46'),('704','46'),('705','46'),('706','46'),('707','46'),('708','46'),('709','46'),('710','46'),('711','47'),('712','47'),('713','47'),('714','47'),('715','47'),('716','47'),('717','47'),('718','47'),('719','47'),('720','47'),('721','47'),('722','47'),('723','47'),('724','47'),('725','47'),('726','47'),('727','47'),('728','47'),('729','47'),('730','47'),('731','47'),('732','47'),('733','47'),('734','47'),('735','47'),('736','48'),('737','48'),('738','48'),('739','48'),('740','48'),('741','48'),('742','48'),('743','48'),('744','48'),('745','48'),('746','48'),('747','48'),('748','48'),('749','48'),('750','48'),('751','48'),('752','48'),('753','48'),('754','48'),('755','48'),('756','48'),('757','48'),('758','48'),('759','48'),('760','48'),('761','49'),('762','49'),('763','49'),('764','49'),('765','49'),('766','49'),('767','49'),('768','49'),('769','49'),('770','49'),('771','49'),('772','49'),('773','49'),('774','49'),('775','49'),('776','49'),('777','49'),('778','49'),('779','49'),('780','49'),('781','49'),('782','49'),('783','49'),('784','49'),('785','49'),('786','49'),('787','50'),('788','50'),('789','50'),('790','50'),('791','50'),('792','50'),('793','50'),('794','50'),('795','50'),('796','50'),('797','50'),('798','50'),('799','50'),('800','50'),('801','50'),('802','50'),('803','50'),('804','50'),('805','50'),('806','50'),('807','50'),('808','50'),('809','50'),('810','50'),('811','50'),('812','51'),('813','51'),('814','51'),('815','51'),('816','51'),('817','51'),('818','51'),('819','51'),('820','51'),('821','51'),('822','51'),('823','51'),('824','51'),('825','51'),('826','51'),('827','51'),('828','51'),('829','51'),('830','51'),('831','51'),('832','51'),('833','51'),('834','51'),('835','51'),('836','51'),('837','52'),('838','52'),('839','52'),('840','52'),('841','52'),('842','52'),('843','52'),('844','52'),('845','52'),('846','52'),('847','52'),('848','52'),('849','52'),('850','52'),('851','52'),('852','52'),('853','52'),('854','52'),('855','52'),('856','52'),('857','52'),('858','52'),('859','52'),('860','52'),('861','52'),('862','53'),('863','53'),('864','53'),('865','53'),('866','53'),('867','53'),('868','53'),('869','53'),('870','53'),('871','53'),('872','53'),('873','53'),('874','53'),('875','53'),('876','53'),('877','53'),('878','53'),('879','53'),('880','53'),('881','53'),('882','53'),('883','53'),('884','53'),('885','53'),('886','53'),('887','53'),('888','54'),('889','54'),('890','54'),('891','54'),('892','54'),('893','54'),('894','54'),('895','54'),('896','54'),('897','54'),('898','54'),('899','54'),('900','54'),('901','54'),('902','54'),('903','54'),('904','54'),('905','54'),('906','54'),('907','54'),('908','54'),('909','54'),('910','54'),('911','54'),('912','54'),('913','55'),('914','55'),('915','55'),('916','55'),('917','55'),('918','55'),('919','55'),('920','55'),('921','55'),('922','55'),('923','55'),('924','55'),('925','55'),('926','55'),('927','55'),('928','55'),('929','55'),('930','55'),('931','55'),('932','55'),('933','55'),('934','55'),('935','55'),('936','55'),('937','55'),('938','55'),('939','38'),('940','38'),('941','39'),('942','39'),('943','40'),('944','40'),('945','41'),('946','41'),('947','42'),('948','42'),('949','43'),('950','43'),('951','44'),('952','44'),('953','45'),('954','45'),('1001','58'),('1002','58'),('1003','58'),('1004','58'),('1005','58'),('1006','58'),('1007','58'),('1008','58'),('1009','58'),('1010','58'),('1011','58'),('1012','58'),('1013','58'),('1014','58'),('1015','58'),('1016','58'),('1017','58'),('1018','58'),('1019','58'),('1020','58'),('1021','58'),('1022','58'),('1023','58'),('1024','58'),('1025','58'),('1026','59'),('1027','59'),('1028','59'),('1029','59'),('1030','59'),('1031','59'),('1032','59'),('1033','59'),('1034','59'),('1035','59'),('1036','59'),('1037','59'),('1038','59'),('1039','59'),('1040','59'),('1041','59'),('1042','59'),('1043','59'),('1044','59'),('1045','59'),('1046','59'),('1047','59'),('1048','59'),('1049','59'),('1050','59'),('1051','59'),('1052','60'),('1053','60'),('1054','60'),('1055','60'),('1056','60'),('1057','60'),('1058','60'),('1059','60'),('1060','60'),('1061','60'),('1062','60'),('1063','60'),('1064','60'),('1065','60'),('1066','60'),('1067','60'),('1068','60'),('1069','60'),('1070','60'),('1071','60'),('1072','60'),('1073','60'),('1074','60'),('1075','60'),('1076','60'),('1077','60'),('1078','61'),('1079','61'),('1080','61'),('1081','61'),('1082','61'),('1083','61'),('1084','61'),('1085','61'),('1086','61'),('1087','61'),('1088','61'),('1089','61'),('1090','61'),('1091','61'),('1092','61'),('1093','61'),('1094','61'),('1095','61'),('1096','61'),('1097','61'),('1098','61'),('1099','61'),('1100','61'),('1101','61'),('1102','61'),('1103','62'),('1104','62'),('1105','62'),('1106','62'),('1107','62'),('1108','62'),('1109','62'),('1110','62'),('1111','62'),('1112','62'),('1113','62'),('1114','62'),('1115','62'),('1116','62'),('1117','62'),('1118','62'),('1119','62'),('1120','62'),('1121','62'),('1122','62'),('1123','62'),('1124','62'),('1125','62'),('1126','62'),('1127','62'),('1128','63'),('1129','63'),('1130','63'),('1131','63'),('1132','63'),('1133','63'),('1134','63'),('1135','63'),('1136','63'),('1137','63'),('1138','63'),('1139','63'),('1140','63'),('1141','63'),('1142','63'),('1143','63'),('1144','63'),('1145','63'),('1146','63'),('1147','63'),('1148','63'),('1149','63'),('1150','63'),('1151','63'),('1152','63'),('1153','63'),('1154','64'),('1155','64'),('1156','64'),('1157','64'),('1158','64'),('1159','64'),('1160','64'),('1161','64'),('1162','64'),('1163','64'),('1164','64'),('1165','64'),('1166','64'),('1167','64'),('1168','64'),('1169','64'),('1170','64'),('1171','64'),('1172','64'),('1173','64'),('1174','64'),('1175','64'),('1176','64'),('1177','64'),('1178','64'),('1179','65'),('1180','65'),('1181','65'),('1182','65'),('1183','65'),('1184','65'),('1185','65'),('1186','65'),('1187','65'),('1188','65'),('1189','65'),('1190','65'),('1191','65'),('1192','65'),('1193','65'),('1194','65'),('1195','65'),('1196','65'),('1197','65'),('1198','65'),('1199','65'),('1200','65'),('1201','65'),('1202','65'),('1203','65'),('1204','66'),('1205','66'),('1206','66'),('1207','66'),('1208','66'),('1209','66'),('1210','66'),('1211','66'),('1212','66'),('1213','66'),('1214','66'),('1215','66'),('1216','66'),('1217','66'),('1218','66'),('1219','66'),('1220','66'),('1221','66'),('1222','66'),('1223','66'),('1224','66'),('1225','66'),('1226','66'),('1227','66'),('1228','66'),('1229','67'),('1230','67'),('1231','67'),('1232','67'),('1233','67'),('1234','67'),('1235','67'),('1236','67'),('1237','67'),('1238','67'),('1239','67'),('1240','67'),('1241','67'),('1242','67'),('1243','67'),('1244','67'),('1245','67'),('1246','67'),('1247','67'),('1248','67'),('1249','67'),('1250','67'),('1251','67'),('1252','67'),('1253','67'),('1254','68'),('1255','68'),('1256','68'),('1257','68'),('1258','68'),('1259','68'),('1260','68'),('1261','68'),('1262','68'),('1263','68'),('1264','68'),('1265','68'),('1266','68'),('1267','68'),('1268','68'),('1269','68'),('1270','68'),('1271','68'),('1272','68'),('1273','68'),('1274','68'),('1275','68'),('1276','68'),('1277','68'),('1278','68'),('1279','69'),('1280','69'),('1281','69'),('1282','69'),('1283','69'),('1284','69'),('1285','69'),('1286','69'),('1287','69'),('1288','69'),('1289','69'),('1290','69'),('1291','69'),('1292','69'),('1293','69'),('1294','69'),('1295','69'),('1296','69'),('1297','69'),('1298','69'),('1299','69'),('1300','69'),('1301','69'),('1302','69'),('1303','69'),('1304','70'),('1305','70'),('1306','70'),('1307','70'),('1308','70'),('1309','70'),('1310','70'),('1311','70'),('1312','70'),('1313','70'),('1314','70'),('1315','70'),('1316','70'),('1317','70'),('1318','70'),('1319','70'),('1320','70'),('1321','70'),('1322','70'),('1323','70'),('1324','70'),('1325','70'),('1326','70'),('1327','70'),('1328','70'),('1329','70'),('1330','71'),('1331','71'),('1332','71'),('1333','71'),('1334','71'),('1335','71'),('1336','71'),('1337','71'),('1338','71'),('1339','71'),('1340','71'),('1341','71'),('1342','71'),('1343','71'),('1344','71'),('1345','71'),('1346','71'),('1347','71'),('1348','71'),('1349','71'),('1350','71'),('1351','71'),('1352','71'),('1353','71'),('1354','71'),('1355','72'),('1356','72'),('1357','72'),('1358','72'),('1359','72'),('1360','72'),('1361','72'),('1362','72'),('1363','72'),('1364','72'),('1365','72'),('1366','72'),('1367','72'),('1368','72'),('1369','72'),('1370','72'),('1371','72'),('1372','72'),('1373','72'),('1374','72'),('1375','72'),('1376','72'),('1377','72'),('1378','72'),('1379','72'),('1380','73'),('1381','73'),('1382','73'),('1383','73'),('1384','73'),('1385','73'),('1386','73'),('1387','73'),('1388','73'),('1389','73'),('1390','73'),('1391','73'),('1392','73'),('1393','73'),('1394','73'),('1395','73'),('1396','73'),('1397','73'),('1398','73'),('1399','73'),('1400','73'),('1401','73'),('1402','73'),('1403','73'),('1404','73'),('1405','74'),('1406','74'),('1407','74'),('1408','74'),('1409','74'),('1410','74'),('1411','74'),('1412','74'),('1413','74'),('1414','74'),('1415','74'),('1416','74'),('1417','74'),('1418','74'),('1419','74'),('1420','74'),('1421','74'),('1422','74'),('1423','74'),('1424','74'),('1425','74'),('1426','74'),('1427','74'),('1428','74'),('1429','74'),('1430','75'),('1431','75'),('1432','75'),('1433','75'),('1434','75'),('1435','75'),('1436','75'),('1437','75'),('1438','75'),('1439','75'),('1440','75'),('1441','75'),('1442','75'),('1443','75'),('1444','75'),('1445','75'),('1446','75'),('1447','75'),('1448','75'),('1449','75'),('1450','75'),('1451','75'),('1452','75'),('1453','75'),('1454','75'),('1455','1'),('1456','1'),('1457','1'),('1458','1'),('1459','1'),('1460','1'),('1461','1'),('1462','1'),('1463','1'),('1464','1'),('1465','4'),('1466','4'),('1467','4'),('1468','4'),('1469','4'),('1470','4'),('1471','4'),('1472','4'),('1473','4'),('1474','4'),('1475','5'),('1476','5'),('1477','5'),('1478','5'),('1479','5'),('1480','5'),('1481','5'),('1482','5'),('1483','5'),('1484','5'),('1485','6'),('1486','6'),('1487','6'),('1488','6'),('1489','6'),('1490','6'),('1491','6'),('1492','6'),('1493','6'),('1494','6'),('1495','7'),('1496','7'),('1497','7'),('1498','7'),('1499','7'),('1500','7'),('1501','7'),('1502','7'),('1503','7'),('1504','7'),('1505','8'),('1506','8'),('1507','8'),('1508','8'),('1509','8'),('1510','8'),('1511','8'),('1512','8'),('1513','8'),('1514','8'),('1515','9'),('1516','9'),('1517','9'),('1518','9'),('1519','9'),('1520','9'),('1521','9'),('1522','9'),('1523','9'),('1524','9'),('1525','10'),('1526','10'),('1527','10'),('1528','10'),('1529','10'),('1530','10'),('1531','10'),('1532','10'),('1533','10'),('1534','10'),('1535','11'),('1536','11'),('1537','11'),('1538','11'),('1539','11'),('1540','11'),('1541','11'),('1542','11'),('1543','11'),('1544','11'),('1545','12'),('1546','12'),('1547','12'),('1548','12'),('1549','12'),('1550','12'),('1551','12'),('1552','12'),('1553','12'),('1554','12'),('1555','13'),('1556','13'),('1557','13'),('1558','13'),('1559','13'),('1560','13'),('1561','13'),('1562','13'),('1563','13'),('1564','13'),('1565','14'),('1566','14'),('1567','14'),('1568','14'),('1569','14'),('1570','14'),('1571','14'),('1572','14'),('1573','14'),('1574','14'),('1575','15'),('1576','15'),('1577','15'),('1578','15'),('1579','15'),('1580','15'),('1581','15'),('1582','15'),('1583','15'),('1584','15'),('1585','16'),('1586','16'),('1587','16'),('1588','16'),('1589','16'),('1590','16'),('1591','16'),('1592','16'),('1593','16'),('1594','16'),('1595','17'),('1596','17'),('1597','17'),('1598','17'),('1599','17'),('1600','17'),('1601','17'),('1602','17'),('1603','17'),('1604','17'),('1605','18'),('1606','18'),('1607','18'),('1608','18'),('1609','18'),('1610','18'),('1611','18'),('1612','18'),('1613','18'),('1614','18'),('1615','19'),('1616','19'),('1617','19'),('1618','19'),('1619','19'),('1620','19'),('1621','19'),('1622','19'),('1623','19'),('1624','19'),('1625','20'),('1626','20'),('1627','20'),('1628','20'),('1629','20'),('1630','20'),('1631','20'),('1632','20'),('1633','20'),('1634','20'),('1635','21'),('1636','21'),('1637','21'),('1638','21'),('1639','21'),('1640','21'),('1641','21'),('1642','21'),('1643','21'),('1644','21'),('1645','22'),('1646','22'),('1647','22'),('1648','22'),('1649','22'),('1650','22'),('1651','22'),('1652','22'),('1653','22'),('1654','22'),('1655','23'),('1656','23'),('1657','23'),('1658','23'),('1659','23'),('1660','23'),('1661','23'),('1662','23'),('1663','23'),('1664','23'),('1665','24'),('1666','24'),('1667','24'),('1668','24'),('1669','24'),('1670','24'),('1671','24'),('1672','24'),('1673','24'),('1674','24'),('1675','25'),('1676','25'),('1677','25'),('1678','25'),('1679','25'),('1680','25'),('1681','25'),('1682','25'),('1683','25'),('1684','25'),('1685','26'),('1686','26'),('1687','26'),('1688','26'),('1689','26'),('1690','26'),('1691','26'),('1692','26'),('1693','26'),('1694','26'),('1695','27'),('1696','27'),('1697','27'),('1698','27'),('1699','27'),('1700','27'),('1701','27'),('1702','27'),('1703','27'),('1704','27'),('1705','28'),('1706','28'),('1707','28'),('1708','28'),('1709','28'),('1710','28'),('1711','28'),('1712','28'),('1713','28'),('1714','28'),('1715','29'),('1716','29'),('1717','29'),('1718','29'),('1719','29'),('1720','29'),('1721','29'),('1722','29'),('1723','29'),('1724','29'),('1725','30'),('1726','30'),('1727','30'),('1728','30'),('1729','30'),('1730','30'),('1731','30'),('1732','30'),('1733','30'),('1734','30'),('1735','31'),('1736','31'),('1737','31'),('1738','31'),('1739','31'),('1740','31'),('1741','31'),('1742','31'),('1743','31'),('1744','31'),('1745','32'),('1746','32'),('1747','32'),('1748','32'),('1749','32'),('1750','32'),('1751','32'),('1752','32'),('1753','32'),('1754','32'),('1755','33'),('1756','33'),('1757','33'),('1758','33'),('1759','33'),('1760','33'),('1761','33'),('1762','33'),('1763','33'),('1764','33'),('1765','34'),('1766','34'),('1767','34'),('1768','34'),('1769','34'),('1770','34'),('1771','34'),('1772','34'),('1773','34'),('1774','34'),('1775','35'),('1776','35'),('1777','35'),('1778','35'),('1779','35'),('1780','35'),('1781','35'),('1782','35'),('1783','35'),('1784','35'),('1785','36'),('1786','36'),('1787','36'),('1788','36'),('1789','36'),('1790','36'),('1791','36'),('1792','36'),('1793','36'),('1794','36'),('1795','37'),('1796','37'),('1797','37'),('1798','37'),('1799','37'),('1800','37'),('1801','37'),('1802','37'),('1803','37'),('1804','37'),('1805','38'),('1806','38'),('1807','38'),('1808','38'),('1809','38'),('1810','38'),('1811','38'),('1812','38'),('1813','38'),('1814','38'),('1815','39'),('1816','39'),('1817','39'),('1818','39'),('1819','39'),('1820','39'),('1821','39'),('1822','39'),('1823','39'),('1824','39'),('1825','40'),('1826','40'),('1827','40'),('1828','40'),('1829','40'),('1830','40'),('1831','40'),('1832','40'),('1833','40'),('1834','40'),('1835','41'),('1836','41'),('1837','41'),('1838','41'),('1839','41'),('1840','41'),('1841','41'),('1842','41'),('1843','41'),('1844','41'),('1845','42'),('1846','42'),('1847','42'),('1848','42'),('1849','42'),('1850','42'),('1851','42'),('1852','42'),('1853','42'),('1854','42'),('1855','43'),('1856','43'),('1857','43'),('1858','43'),('1859','43'),('1860','43'),('1861','43'),('1862','43'),('1863','43'),('1864','43'),('1865','44'),('1866','44'),('1867','44'),('1868','44'),('1869','44'),('1870','44'),('1871','44'),('1872','44'),('1873','44'),('1874','44'),('1875','45'),('1876','45'),('1877','45'),('1878','45'),('1879','45'),('1880','45'),('1881','45'),('1882','45'),('1883','45'),('1884','45'),('1885','46'),('1886','46'),('1887','46'),('1888','46'),('1889','46'),('1890','46'),('1891','46'),('1892','46'),('1893','46'),('1894','46'),('1895','47'),('1896','47'),('1897','47'),('1898','47'),('1899','47'),('1900','47'),('1901','47'),('1902','47'),('1903','47'),('1904','47'),('1905','48'),('1906','48'),('1907','48'),('1908','48'),('1909','48'),('1910','48'),('1911','48'),('1912','48'),('1913','48'),('1914','48'),('1915','49'),('1916','49'),('1917','49'),('1918','49'),('1919','49'),('1920','49'),('1921','49'),('1922','49'),('1923','49'),('1924','49'),('1925','50'),('1926','50'),('1927','50'),('1928','50'),('1929','50'),('1930','50'),('1931','50'),('1932','50'),('1933','50'),('1934','50'),('1935','51'),('1936','51'),('1937','51'),('1938','51'),('1939','51'),('1940','51'),('1941','51'),('1942','51'),('1943','51'),('1944','51'),('1945','52'),('1946','52'),('1947','52'),('1948','52'),('1949','52'),('1950','52'),('1951','52'),('1952','52'),('1953','52'),('1954','52'),('1955','53'),('1956','53'),('1957','53'),('1958','53'),('1959','53'),('1960','53'),('1961','53'),('1962','53'),('1963','53'),('1964','53'),('1965','54'),('1966','54'),('1967','54'),('1968','54'),('1969','54'),('1970','54'),('1971','54'),('1972','54'),('1973','54'),('1974','54'),('1975','55'),('1976','55'),('1977','55'),('1978','55'),('1979','55'),('1980','55'),('1981','55'),('1982','55'),('1983','55'),('1984','55'),('1985','58'),('1986','58'),('1987','58'),('1988','58'),('1989','58'),('1990','58'),('1991','58'),('1992','58'),('1993','58'),('1994','58'),('1995','59'),('1996','59'),('1997','59'),('1998','59'),('1999','59'),('2000','59'),('2001','59'),('2002','59'),('2003','59'),('2004','59'),('2005','60'),('2006','60'),('2007','60'),('2008','60'),('2009','60'),('2010','60'),('2011','60'),('2012','60'),('2013','60'),('2014','60'),('2015','61'),('2016','61'),('2017','61'),('2018','61'),('2019','61'),('2020','61'),('2021','61'),('2022','61'),('2023','61'),('2024','61'),('2025','62'),('2026','62'),('2027','62'),('2028','62'),('2029','62'),('2030','62'),('2031','62'),('2032','62'),('2033','62'),('2034','62'),('2035','63'),('2036','63'),('2037','63'),('2038','63'),('2039','63'),('2040','63'),('2041','63'),('2042','63'),('2043','63'),('2044','63'),('2045','64'),('2046','64'),('2047','64'),('2048','64'),('2049','64'),('2050','64'),('2051','64'),('2052','64'),('2053','64'),('2054','64'),('2055','65'),('2056','65'),('2057','65'),('2058','65'),('2059','65'),('2060','65'),('2061','65'),('2062','65'),('2063','65'),('2064','65'),('2065','66'),('2066','66'),('2067','66'),('2068','66'),('2069','66'),('2070','66'),('2071','66'),('2072','66'),('2073','66'),('2074','66'),('2075','67'),('2076','67'),('2077','67'),('2078','67'),('2079','67'),('2080','67'),('2081','67'),('2082','67'),('2083','67'),('2084','67'),('2085','68'),('2086','68'),('2087','68'),('2088','68'),('2089','68'),('2090','68'),('2091','68'),('2092','68'),('2093','68'),('2094','68'),('2095','69'),('2096','69'),('2097','69'),('2098','69'),('2099','69'),('2100','69'),('2101','69'),('2102','69'),('2103','69'),('2104','69'),('2105','70'),('2106','70'),('2107','70'),('2108','70'),('2109','70'),('2110','70'),('2111','70'),('2112','70'),('2113','70'),('2114','70'),('2115','71'),('2116','71'),('2117','71'),('2118','71'),('2119','71'),('2120','71'),('2121','71'),('2122','71'),('2123','71'),('2124','71'),('2125','72'),('2126','72'),('2127','72'),('2128','72'),('2129','72'),('2130','72'),('2131','72'),('2132','72'),('2133','72'),('2134','72'),('2135','73'),('2136','73'),('2137','73'),('2138','73'),('2139','73'),('2140','73'),('2141','73'),('2142','73'),('2143','73'),('2144','73'),('2145','74'),('2146','74'),('2147','74'),('2148','74'),('2149','74'),('2150','74'),('2151','74'),('2152','74'),('2153','74'),('2154','74'),('2155','75'),('2156','75'),('2157','75'),('2158','75'),('2159','75'),('2160','75'),('2161','75'),('2162','75'),('2163','75'),('2164','75'),('2165','76'),('2166','76'),('2167','76'),('2168','76'),('2169','76'),('2170','76'),('2171','76'),('2172','76'),('2173','76'),('2174','76'),('2175','76'),('2176','76'),('2177','76'),('2178','76'),('2179','76'),('2180','76'),('2181','76'),('2182','76'),('2183','76'),('2184','76'),('2185','76'),('2186','76'),('2187','76'),('2188','76'),('2189','76'),('2190','76'),('2191','76'),('2192','76'),('2193','76'),('2194','76'),('2195','76'),('2196','76'),('2197','76'),('2198','76'),('2199','76'),('2200','76'),('2201','76'),('2202','76'),('2203','76'),('2204','76'),('2205','76'),('2206','76'),('2207','76'),('2208','76'),('2209','76'),('2210','76'),('2211','77'),('2212','77'),('2213','77'),('2214','77'),('2215','77'),('2216','77'),('2217','77'),('2218','77'),('2219','77'),('2220','77'),('2221','77'),('2222','77'),('2223','77'),('2224','77'),('2225','77'),('2226','77'),('2227','77'),('2228','77'),('2229','77'),('2230','77'),('2231','77'),('2232','77'),('2233','77'),('2234','77'),('2235','77'),('2236','76'),('2237','76'),('2238','76'),('2239','76'),('2240','76'),('2241','76'),('2242','76'),('2243','77'),('2244','77'),('2245','77'),('2246','77'),('2247','77'),('2248','77'),('2249','77'),('2250','77'),('2251','77'),('2252','77'),('2253','77'),('2254','77'),('2255','77'),('2256','77'),('2257','77'),('2258','77'),('2259','77'),('2260','77'),('2261','77'),('2262','77'),('2263','77'),('2264','77'),('2265','77'),('2266','77'),('2267','78'),('2268','78'),('2269','78'),('2270','78'),('2271','78'),('2272','78'),('2273','78'),('2274','78'),('2275','78'),('2276','78'),('2277','78'),('2278','78'),('2279','78'),('2280','78'),('2281','78'),('2282','78'),('2283','78'),('2284','78'),('2285','78'),('2286','78'),('2287','78'),('2288','78'),('2289','78'),('2290','78'),('2291','78'),('2292','79'),('2293','79'),('2294','79'),('2295','79'),('2296','79'),('2297','79'),('2298','79'),('2299','79'),('2300','79'),('2301','79'),('2302','79'),('2303','79'),('2304','79'),('2305','79'),('2306','79'),('2307','79'),('2308','79'),('2309','79'),('2310','79'),('2311','79'),('2312','79'),('2313','79'),('2314','79'),('2315','79'),('2316','79'),('2317','80'),('2318','80'),('2319','80'),('2320','80'),('2321','80'),('2322','80'),('2323','80'),('2324','80'),('2325','80'),('2326','80'),('2327','80'),('2328','80'),('2329','80'),('2330','80'),('2331','80'),('2332','80'),('2333','80'),('2334','80'),('2335','80'),('2336','80'),('2337','80'),('2338','80'),('2339','80'),('2340','80'),('2341','80'),('2342','76'),('2343','76'),('2344','76'),('2345','77'),('2346','77'),('2347','77'),('2348','77'),('2349','78'),('2350','78'),('2351','78'),('2352','78'),('2353','78'),('2354','78'),('2355','78'),('2356','78'),('2357','80'),('2358','80'),('2359','80'),('2360','80'),('2361','80'),('2362','80'),('2363','80'),('2364','80'),('2365','78'),('2366','78'),('2367','78'),('2368','78'),('2369','78'),('2370','78'),('2371','78'),('2372','78'),('2373','78'),('2374','78'),('2375','78'),('2376','78'),('2377','78'),('2378','80'),('2379','80'),('2380','80'),('2381','80'),('2382','80'),('2383','80'),('2384','80'),('2385','80'),('2386','80'),('2387','80'),('2388','80'),('2389','80'),('2390','80'),('2391','81'),('2392','81'),('2393','81'),('2394','81'),('2395','81'),('2396','81'),('2397','81'),('2398','81'),('2399','81'),('2400','81'),('2401','81'),('2402','81'),('2403','81'),('2404','81'),('2405','81'),('2406','81'),('2407','81'),('2408','81'),('2409','81'),('2410','81'),('2411','81'),('2412','81'),('2413','81'),('2414','81'),('2415','81'),('2416','82'),('2417','82'),('2418','82'),('2419','82'),('2420','82'),('2421','82'),('2422','82'),('2423','82'),('2424','82'),('2425','82'),('2426','82'),('2427','82'),('2428','82'),('2429','82'),('2430','82'),('2431','82'),('2432','82'),('2433','82'),('2434','82'),('2435','82'),('2436','82'),('2437','82'),('2438','82'),('2439','82'),('2440','82'),('2441','82'),('2442','82'),('2443','82'),('2444','82'),('2445','82'),('2446','82'),('2447','82'),('2448','82'),('2449','82'),('2450','82'),('2451','82'),('2452','82'),('2453','82'),('2454','82'),('2455','82'),('2456','82'),('2457','82'),('2458','82'),('2459','82'),('2460','82'),('2461','82'),('2462','83'),('2463','83'),('2464','83'),('2465','83'),('2466','83'),('2467','83'),('2468','83'),('2469','83'),('2470','83'),('2471','83'),('2472','83'),('2473','83'),('2474','83'),('2475','83'),('2476','83'),('2477','83'),('2478','83'),('2479','83'),('2480','83'),('2481','83'),('2482','83'),('2483','83'),('2484','83'),('2485','83'),('2486','83'),('2487','84'),('2488','84'),('2489','84'),('2490','84'),('2491','84'),('2492','84'),('2493','84'),('2494','84'),('2495','84'),('2496','84'),('2497','84'),('2498','84'),('2499','84'),('2500','84'),('2501','84'),('2502','84'),('2503','84'),('2504','84'),('2505','84'),('2506','84'),('2507','84'),('2508','84'),('2509','84'),('2510','84'),('2511','84'),('2512','85'),('2513','85'),('2514','85'),('2515','85'),('2516','85'),('2517','85'),('2518','85'),('2519','85'),('2520','85'),('2521','85'),('2522','85'),('2523','85'),('2524','85'),('2525','85'),('2526','85'),('2527','85'),('2528','85'),('2529','85'),('2530','85'),('2531','85'),('2532','85'),('2533','85'),('2534','85'),('2535','85'),('2536','85'),('2537','86'),('2538','86'),('2539','86'),('2540','86'),('2541','86'),('2542','86'),('2543','86'),('2544','86'),('2545','86'),('2546','86'),('2547','86'),('2548','86'),('2549','86'),('2550','86'),('2551','86'),('2552','86'),('2553','86'),('2554','86'),('2555','86'),('2556','86'),('2557','86'),('2558','86'),('2559','86'),('2560','86'),('2561','86'),('2562','86'),('2563','86'),('2564','86'),('2565','86'),('2566','86'),('2567','86'),('2568','86'),('2569','86'),('2570','87'),('2571','87'),('2572','87'),('2573','87'),('2574','87'),('2575','87'),('2576','87'),('2577','87'),('2578','87'),('2579','87'),('2580','87'),('2581','87'),('2582','87'),('2583','87'),('2584','87'),('2585','87'),('2586','87'),('2587','87'),('2588','87'),('2589','87'),('2590','87'),('2591','87'),('2592','87'),('2593','87'),('2594','87'),('2595','88'),('2596','88'),('2597','88'),('2598','88'),('2599','88'),('2600','88'),('2601','88'),('2602','88'),('2603','88'),('2604','88'),('2605','88'),('2606','88'),('2607','88'),('2608','88'),('2609','88'),('2610','88'),('2611','88'),('2612','88'),('2613','88'),('2614','88'),('2615','88'),('2616','88'),('2617','88'),('2618','88'),('2619','88'),('2620','89'),('2621','89'),('2622','89'),('2623','89'),('2624','89'),('2625','89'),('2626','89'),('2627','89'),('2628','89'),('2629','89'),('2630','89'),('2631','89'),('2632','89'),('2633','89'),('2634','89'),('2635','89'),('2636','89'),('2637','89'),('2638','89'),('2639','89'),('2640','89'),('2641','89'),('2642','89'),('2643','89'),('2644','89'),('2645','89'),('2646','89'),('2647','89'),('2648','90'),('2649','90'),('2650','90'),('2651','90'),('2652','90'),('2653','90'),('2654','90'),('2655','90'),('2656','90'),('2657','90'),('2658','90'),('2659','90'),('2660','90'),('2661','90'),('2662','90'),('2663','90'),('2664','90'),('2665','90'),('2666','90'),('2667','90'),('2668','90'),('2669','90'),('2670','90'),('2671','90'),('2672','90'),('2673','91'),('2674','91'),('2675','91'),('2676','91'),('2677','91'),('2678','91'),('2679','91'),('2680','91'),('2681','91'),('2682','91'),('2683','91'),('2684','91'),('2685','91'),('2686','91'),('2687','91'),('2688','91'),('2689','91'),('2690','91'),('2691','91'),('2692','91'),('2693','91'),('2694','91'),('2695','91'),('2696','91'),('2697','91'),('2698','92'),('2699','92'),('2700','92'),('2701','92'),('2702','92'),('2703','92'),('2704','92'),('2705','92'),('2706','92'),('2707','92'),('2708','92'),('2709','92'),('2710','92'),('2711','92'),('2712','92'),('2713','92'),('2714','92'),('2715','92'),('2716','92'),('2717','92'),('2718','92'),('2719','92'),('2720','92'),('2721','92'),('2722','92'),('2723','93'),('2724','93'),('2725','93'),('2726','93'),('2727','93'),('2728','93'),('2729','93'),('2730','93'),('2731','93'),('2732','93'),('2733','93'),('2734','93'),('2735','93'),('2736','93'),('2737','93'),('2738','93'),('2739','93'),('2740','93'),('2741','93'),('2742','93'),('2743','93'),('2744','93'),('2745','93'),('2746','93'),('2747','93'),('2748','94'),('2749','94'),('2750','94'),('2751','94'),('2752','94'),('2753','94'),('2754','94'),('2755','94'),('2756','94'),('2757','94'),('2758','94'),('2759','94'),('2760','94'),('2761','94'),('2762','94'),('2763','94'),('2764','94'),('2765','94'),('2766','94'),('2767','94'),('2768','94'),('2769','94'),('2770','94'),('2771','94'),('2772','94'),('2773','94'),('2774','94'),('2775','94'),('2776','94'),('2777','94'),('2778','94'),('2779','94'),('2780','94'),('2781','95'),('2782','95'),('2783','95'),('2784','95'),('2785','95'),('2786','95'),('2787','95'),('2788','95'),('2789','95'),('2790','95'),('2791','95'),('2792','95'),('2793','95'),('2794','95'),('2795','95'),('2796','95'),('2797','95'),('2798','95'),('2799','95'),('2800','95'),('2801','95'),('2802','95'),('2803','95'),('2804','95'),('2805','95'),('2806','95'),('2807','95'),('2808','95'),('2809','95'),('2810','95'),('2811','95'),('2812','95'),('2813','95'),('2814','96'),('2815','96'),('2816','96'),('2817','96'),('2818','96'),('2819','96'),('2820','96'),('2821','96'),('2822','96'),('2823','96'),('2824','96'),('2825','96'),('2826','96'),('2827','96'),('2828','96'),('2829','96'),('2830','96'),('2831','96'),('2832','96'),('2833','96'),('2834','96'),('2835','96'),('2836','96'),('2837','96'),('2838','96'),('2839','97'),('2840','97'),('2841','97'),('2842','97'),('2843','97'),('2844','97'),('2845','97'),('2846','97'),('2847','97'),('2848','97'),('2849','97'),('2850','97'),('2851','97'),('2852','97'),('2853','97'),('2854','97'),('2855','97'),('2856','97'),('2857','97'),('2858','97'),('2859','97'),('2860','97'),('2861','97'),('2862','97'),('2863','97'),('2864','98'),('2865','98'),('2866','98'),('2867','98'),('2868','98'),('2869','98'),('2870','98'),('2871','98'),('2872','98'),('2873','98'),('2874','98'),('2875','98'),('2876','98'),('2877','98'),('2878','98'),('2879','98'),('2880','98'),('2881','98'),('2882','98'),('2883','98'),('2884','98'),('2885','98'),('2886','98'),('2887','98'),('2888','98'),('2889','99'),('2890','99'),('2891','99'),('2892','99'),('2893','99'),('2894','99'),('2895','99'),('2896','99'),('2897','99'),('2898','99'),('2899','99'),('2900','99'),('2901','99'),('2902','99'),('2903','99'),('2904','99'),('2905','99'),('2906','99'),('2907','99'),('2908','99'),('2909','99'),('2910','99'),('2911','99'),('2912','99'),('2913','99'),('2914','100'),('2915','100'),('2916','100'),('2917','100'),('2918','100'),('2919','100'),('2920','100'),('2921','100'),('2922','100'),('2923','100'),('2924','100'),('2925','100'),('2926','100'),('2927','100'),('2928','100'),('2929','100'),('2930','100'),('2931','100'),('2932','100'),('2933','100'),('2934','100'),('2935','100'),('2936','100'),('2937','100'),('2938','100'),('2939','101'),('2940','101'),('2941','101'),('2942','101'),('2943','101'),('2944','101'),('2945','101'),('2946','101'),('2947','101'),('2948','101'),('2949','101'),('2950','101'),('2951','101'),('2952','101'),('2953','101'),('2954','101'),('2955','101'),('2956','101'),('2957','101'),('2958','101'),('2959','101'),('2960','101'),('2961','101'),('2962','101'),('2963','101'),('2964','102'),('2965','102'),('2966','102'),('2967','102'),('2968','102'),('2969','102'),('2970','102'),('2971','102'),('2972','102'),('2973','102'),('2974','102'),('2975','102'),('2976','102'),('2977','102'),('2978','102'),('2979','102'),('2980','102'),('2981','102'),('2982','102'),('2983','102'),('2984','102'),('2985','102'),('2986','102'),('2987','102'),('2988','102'),('2989','103'),('2990','103'),('2991','103'),('2992','103'),('2993','103'),('2994','103'),('2995','103'),('2996','103'),('2997','103'),('2998','103'),('2999','103'),('3000','103'),('3001','103'),('3002','103'),('3003','103'),('3004','103'),('3005','103'),('3006','103'),('3007','103'),('3008','103'),('3009','103'),('3010','103'),('3011','103'),('3012','103'),('3013','103'),('3014','104'),('3015','104'),('3016','104'),('3017','104'),('3018','104'),('3019','104'),('3020','104'),('3021','104'),('3022','104'),('3023','104'),('3024','104'),('3025','104'),('3026','104'),('3027','104'),('3028','104'),('3029','104'),('3030','104'),('3031','104'),('3032','104'),('3033','104'),('3034','104'),('3035','104'),('3036','104'),('3037','104'),('3038','104'),('3039','105'),('3040','105'),('3041','105'),('3042','105'),('3043','105'),('3044','105'),('3045','105'),('3046','105'),('3047','105'),('3048','105'),('3049','105'),('3050','105'),('3051','105'),('3052','105'),('3053','105'),('3054','105'),('3055','105'),('3056','105'),('3057','105'),('3058','105'),('3059','105'),('3060','105'),('3061','105'),('3062','105'),('3063','105'),('3064','106'),('3065','106'),('3066','106'),('3067','106'),('3068','106'),('3069','106'),('3070','106'),('3071','106'),('3072','106'),('3073','106'),('3074','106'),('3075','106'),('3076','106'),('3077','106'),('3078','106'),('3079','106'),('3080','106'),('3081','106'),('3082','106'),('3083','106'),('3084','106'),('3085','106'),('3086','106'),('3087','106'),('3088','106'),('3089','107'),('3090','107'),('3091','107'),('3092','107'),('3093','107'),('3094','107'),('3095','107'),('3096','107'),('3097','107'),('3098','107'),('3099','107'),('3100','107'),('3101','107'),('3102','107'),('3103','107'),('3104','108'),('3105','108'),('3106','108'),('3107','108'),('3108','108'),('3109','108'),('3110','108'),('3111','108'),('3112','108'),('3113','108'),('3114','108'),('3115','108'),('3116','108'),('3117','108'),('3118','108'),('3119','108'),('3120','108'),('3121','108'),('3122','108'),('3123','108'),('3124','108'),('3125','108'),('3126','108'),('3127','108'),('3128','108'),('3129','109'),('3130','109'),('3131','109'),('3132','109'),('3133','109'),('3134','109'),('3135','109'),('3136','109'),('3137','109'),('3138','109'),('3139','109'),('3140','109'),('3141','109'),('3142','109'),('3143','109'),('3144','109'),('3145','109'),('3146','109'),('3147','109'),('3148','109'),('3149','109'),('3150','109'),('3151','109'),('3152','109'),('3153','109'),('3154','109'),('3155','109'),('3156','109'),('3157','109'),('3158','109'),('3159','109'),('3160','109'),('3161','109'),('3162','109'),('3163','109'),('3164','109'),('3165','109'),('3166','109'),('3167','109'),('3168','109'),('3169','108'),('3170','108'),('3171','108'),('3172','108'),('3173','108'),('3174','108'),('3175','108'),('3176','108'),('3177','109'),('3178','109'),('3179','109'),('3180','109'),('3181','109'),('3182','109'),('3183','109'),('3184','109'),('3185','109'),('3186','109'),('3187','109'),('3188','109'),('3189','109'),('3190','109'),('3191','109'),('3192','109'),('3193','109'),('3194','109'),('3195','110'),('3196','110'),('3197','110'),('3198','110'),('3199','110'),('3200','110'),('3201','110'),('3202','110'),('3203','110'),('3204','110'),('3205','110'),('3206','110'),('3207','110'),('3208','110'),('3209','110'),('3210','110'),('3211','110'),('3212','110'),('3213','110'),('3214','110'),('3215','110'),('3216','110'),('3217','110'),('3218','110'),('3219','110'),('3220','111'),('3221','111'),('3222','111'),('3223','111'),('3224','111'),('3225','111'),('3226','111'),('3227','111'),('3228','111'),('3229','111'),('3230','111'),('3231','111'),('3232','111'),('3233','111'),('3234','111'),('3235','111'),('3236','111'),('3237','111'),('3238','111'),('3239','111'),('3240','111'),('3241','111'),('3242','111'),('3243','111'),('3244','111'),('3245','112'),('3246','112');
INSERT INTO `catalog_product_attribute_cl` VALUES ('3247','112'),('3248','112'),('3249','112'),('3250','112'),('3251','112'),('3252','112'),('3253','112'),('3254','112'),('3255','112'),('3256','112'),('3257','112'),('3258','112'),('3259','112'),('3260','112'),('3261','112'),('3262','112'),('3263','112'),('3264','112'),('3265','112'),('3266','112'),('3267','112'),('3268','112'),('3269','112'),('3270','113'),('3271','113'),('3272','113'),('3273','113'),('3274','113'),('3275','113'),('3276','113'),('3277','113'),('3278','113'),('3279','113'),('3280','113'),('3281','113'),('3282','113'),('3283','113'),('3284','113'),('3285','113'),('3286','113'),('3287','113'),('3288','113'),('3289','113'),('3290','113'),('3291','113'),('3292','113'),('3293','113'),('3294','113'),('3295','114'),('3296','114'),('3297','114'),('3298','114'),('3299','114'),('3300','114'),('3301','114'),('3302','114'),('3303','114'),('3304','114'),('3305','114'),('3306','114'),('3307','114'),('3308','114'),('3309','114'),('3310','114'),('3311','114'),('3312','114'),('3313','114'),('3314','114'),('3315','114'),('3316','114'),('3317','114'),('3318','114'),('3319','114'),('3320','115'),('3321','115'),('3322','115'),('3323','115'),('3324','115'),('3325','115'),('3326','115'),('3327','115'),('3328','115'),('3329','115'),('3330','115'),('3331','115'),('3332','115'),('3333','115'),('3334','115'),('3335','115'),('3336','115'),('3337','115'),('3338','115'),('3339','115'),('3340','115'),('3341','115'),('3342','115'),('3343','115'),('3344','115'),('3345','116'),('3346','116'),('3347','116'),('3348','116'),('3349','116'),('3350','116'),('3351','116'),('3352','116'),('3353','116'),('3354','116'),('3355','116'),('3356','116'),('3357','116'),('3358','116'),('3359','116'),('3360','116'),('3361','116'),('3362','116'),('3363','116'),('3364','116'),('3365','116'),('3366','116'),('3367','116'),('3368','116'),('3369','116'),('3370','117'),('3371','117'),('3372','117'),('3373','117'),('3374','117'),('3375','117'),('3376','117'),('3377','117'),('3378','117'),('3379','117'),('3380','117'),('3381','117'),('3382','117'),('3383','117'),('3384','117'),('3385','117'),('3386','117'),('3387','117'),('3388','117'),('3389','117'),('3390','117'),('3391','117'),('3392','117'),('3393','117'),('3394','117'),('3395','118'),('3396','118'),('3397','118'),('3398','118'),('3399','118'),('3400','118'),('3401','118'),('3402','118'),('3403','118'),('3404','118'),('3405','118'),('3406','118'),('3407','118'),('3408','118'),('3409','118'),('3410','118'),('3411','118'),('3412','118'),('3413','118'),('3414','118'),('3415','118'),('3416','118'),('3417','118'),('3418','118'),('3419','118'),('3420','119'),('3421','119'),('3422','119'),('3423','119'),('3424','119'),('3425','119'),('3426','119'),('3427','119'),('3428','119'),('3429','119'),('3430','119'),('3431','119'),('3432','119'),('3433','119'),('3434','119'),('3435','119'),('3436','119'),('3437','119'),('3438','119'),('3439','119'),('3440','119'),('3441','119'),('3442','119'),('3443','119'),('3444','119'),('3445','120'),('3446','120'),('3447','120'),('3448','120'),('3449','120'),('3450','120'),('3451','120'),('3452','120'),('3453','120'),('3454','120'),('3455','120'),('3456','120'),('3457','120'),('3458','120'),('3459','120'),('3460','120'),('3461','120'),('3462','120'),('3463','120'),('3464','120'),('3465','120'),('3466','120'),('3467','120'),('3468','120'),('3469','120'),('3470','121'),('3471','121'),('3472','121'),('3473','121'),('3474','121'),('3475','121'),('3476','121'),('3477','121'),('3478','121'),('3479','121'),('3480','121'),('3481','121'),('3482','121'),('3483','121'),('3484','121'),('3485','121'),('3486','121'),('3487','121'),('3488','121'),('3489','121'),('3490','121'),('3491','121'),('3492','121'),('3493','121'),('3494','121'),('3495','122'),('3496','122'),('3497','122'),('3498','122'),('3499','122'),('3500','122'),('3501','122'),('3502','122'),('3503','122'),('3504','122'),('3505','122'),('3506','122'),('3507','122'),('3508','122'),('3509','122'),('3510','122'),('3511','122'),('3512','122'),('3513','122'),('3514','122'),('3515','122'),('3516','122'),('3517','122'),('3518','122'),('3519','122'),('3520','123'),('3521','123'),('3522','123'),('3523','123'),('3524','123'),('3525','123'),('3526','123'),('3527','123'),('3528','123'),('3529','123'),('3530','123'),('3531','123'),('3532','123'),('3533','123'),('3534','123'),('3535','123'),('3536','123'),('3537','123'),('3538','123'),('3539','123'),('3540','123'),('3541','123'),('3542','123'),('3543','123'),('3544','123'),('3545','123'),('3546','123'),('3547','123'),('3548','123'),('3549','123'),('3550','123'),('3551','123'),('3552','123'),('3553','123'),('3554','123'),('3555','123'),('3556','123'),('3557','123'),('3558','124'),('3559','124'),('3560','124'),('3561','124'),('3562','124'),('3563','124'),('3564','124'),('3565','124'),('3566','124'),('3567','124'),('3568','124'),('3569','124'),('3570','124'),('3571','124'),('3572','124'),('3573','124'),('3574','124'),('3575','124'),('3576','124'),('3577','124'),('3578','124'),('3579','124'),('3580','124'),('3581','124'),('3582','124'),('3583','125'),('3584','125'),('3585','125'),('3586','125'),('3587','125'),('3588','125'),('3589','125'),('3590','125'),('3591','125'),('3592','125'),('3593','125'),('3594','125'),('3595','125'),('3596','125'),('3597','125'),('3598','125'),('3599','125'),('3600','125'),('3601','125'),('3602','125'),('3603','125'),('3604','125'),('3605','125'),('3606','125'),('3607','125'),('3608','126'),('3609','126'),('3610','126'),('3611','126'),('3612','126'),('3613','126'),('3614','126'),('3615','126'),('3616','126'),('3617','126'),('3618','126'),('3619','126'),('3620','126'),('3621','126'),('3622','126'),('3623','126'),('3624','126'),('3625','126'),('3626','126'),('3627','126'),('3628','126'),('3629','126'),('3630','126'),('3631','126'),('3632','126'),('3633','127'),('3634','127'),('3635','127'),('3636','127'),('3637','127'),('3638','127'),('3639','127'),('3640','127'),('3641','127'),('3642','127'),('3643','127'),('3644','127'),('3645','127'),('3646','127'),('3647','127'),('3648','127'),('3649','127'),('3650','127'),('3651','127'),('3652','127'),('3653','127'),('3654','127'),('3655','127'),('3656','127'),('3657','127'),('3658','128'),('3659','128'),('3660','128'),('3661','128'),('3662','128'),('3663','128'),('3664','128'),('3665','128'),('3666','128'),('3667','128'),('3668','128'),('3669','128'),('3670','128'),('3671','128'),('3672','128'),('3673','128'),('3674','128'),('3675','128'),('3676','128'),('3677','128'),('3678','128'),('3679','128'),('3680','128'),('3681','128'),('3682','128'),('3683','129'),('3684','129'),('3685','129'),('3686','129'),('3687','129'),('3688','129'),('3689','129'),('3690','129'),('3691','129'),('3692','129'),('3693','129'),('3694','129'),('3695','129'),('3696','129'),('3697','129'),('3698','129'),('3699','129'),('3700','129'),('3701','129'),('3702','129'),('3703','129'),('3704','129'),('3705','129'),('3706','129'),('3707','129'),('3708','130'),('3709','130'),('3710','130'),('3711','130'),('3712','130'),('3713','130'),('3714','130'),('3715','130'),('3716','130'),('3717','130'),('3718','130'),('3719','130'),('3720','130'),('3721','130'),('3722','130'),('3723','130'),('3724','130'),('3725','130'),('3726','130'),('3727','130'),('3728','130'),('3729','130'),('3730','130'),('3731','130'),('3732','130'),('3733','131'),('3734','131'),('3735','131'),('3736','131'),('3737','131'),('3738','131'),('3739','131'),('3740','131'),('3741','131'),('3742','131'),('3743','131'),('3744','131'),('3745','131'),('3746','131'),('3747','131'),('3748','131'),('3749','131'),('3750','131'),('3751','131'),('3752','131'),('3753','131'),('3754','131'),('3755','131'),('3756','131'),('3757','131'),('3758','132'),('3759','132'),('3760','132'),('3761','132'),('3762','132'),('3763','132'),('3764','132'),('3765','132'),('3766','132'),('3767','132'),('3768','132'),('3769','132'),('3770','132'),('3771','132'),('3772','132'),('3773','132'),('3774','132'),('3775','132'),('3776','132'),('3777','132'),('3778','132'),('3779','132'),('3780','132'),('3781','132'),('3782','132'),('3783','133'),('3784','133'),('3785','133'),('3786','133'),('3787','133'),('3788','133'),('3789','133'),('3790','133'),('3791','133'),('3792','133'),('3793','133'),('3794','133'),('3795','133'),('3796','133'),('3797','133'),('3798','133'),('3799','133'),('3800','133'),('3801','133'),('3802','133'),('3803','133'),('3804','133'),('3805','133'),('3806','133'),('3807','133'),('3808','134'),('3809','134'),('3810','134'),('3811','134'),('3812','134'),('3813','134'),('3814','134'),('3815','134'),('3816','134'),('3817','134'),('3818','134'),('3819','134'),('3820','134'),('3821','134'),('3822','134'),('3823','134'),('3824','134'),('3825','134'),('3826','134'),('3827','134'),('3828','134'),('3829','134'),('3830','134'),('3831','134'),('3832','134'),('3833','135'),('3834','135'),('3835','135'),('3836','135'),('3837','135'),('3838','135'),('3839','135'),('3840','135'),('3841','135'),('3842','135'),('3843','135'),('3844','135'),('3845','135'),('3846','135'),('3847','135'),('3848','135'),('3849','135'),('3850','135'),('3851','135'),('3852','135'),('3853','135'),('3854','135'),('3855','135'),('3856','135'),('3857','135'),('3858','134'),('3859','134'),('3860','134'),('3861','134'),('3862','134'),('3863','134'),('3864','134'),('3865','134'),('3866','136'),('3867','136'),('3868','136'),('3869','136'),('3870','136'),('3871','136'),('3872','136'),('3873','136'),('3874','136'),('3875','136'),('3876','136'),('3877','136'),('3878','136'),('3879','136'),('3880','136'),('3881','136'),('3882','136'),('3883','136'),('3884','136'),('3885','136'),('3886','136'),('3887','136'),('3888','136'),('3889','136'),('3890','136'),('3891','137'),('3892','137'),('3893','137'),('3894','137'),('3895','137'),('3896','137'),('3897','137'),('3898','137'),('3899','137'),('3900','137'),('3901','137'),('3902','137'),('3903','137'),('3904','137'),('3905','137'),('3906','137'),('3907','137'),('3908','137'),('3909','137'),('3910','137'),('3911','137'),('3912','137'),('3913','137'),('3914','137'),('3915','137'),('3916','138'),('3917','138'),('3918','138'),('3919','138'),('3920','138'),('3921','138'),('3922','138'),('3923','138'),('3924','138'),('3925','138'),('3926','138'),('3927','138'),('3928','138'),('3929','138'),('3930','138'),('3931','138'),('3932','138'),('3933','138'),('3934','138'),('3935','138'),('3936','138'),('3937','138'),('3938','138'),('3939','138'),('3940','138'),('3941','139'),('3942','139'),('3943','139'),('3944','139'),('3945','139'),('3946','139'),('3947','139'),('3948','139'),('3949','139'),('3950','139'),('3951','139'),('3952','139'),('3953','139'),('3954','139'),('3955','139'),('3956','139'),('3957','139'),('3958','139'),('3959','139'),('3960','139'),('3961','139'),('3962','139'),('3963','139'),('3964','139'),('3965','139'),('3966','140'),('3967','140'),('3968','140'),('3969','140'),('3970','140'),('3971','140'),('3972','140'),('3973','140'),('3974','140'),('3975','140'),('3976','140'),('3977','140'),('3978','140'),('3979','140'),('3980','140'),('3981','140'),('3982','140'),('3983','140'),('3984','140'),('3985','140'),('3986','140'),('3987','140'),('3988','140'),('3989','140'),('3990','140'),('3991','141'),('3992','141'),('3993','141'),('3994','141'),('3995','141'),('3996','141'),('3997','141'),('3998','141'),('3999','141'),('4000','141'),('4001','141'),('4002','141'),('4003','141'),('4004','141'),('4005','141'),('4006','141'),('4007','141'),('4008','141'),('4009','141'),('4010','141'),('4011','141'),('4012','141'),('4013','141'),('4014','141'),('4015','141'),('4016','140'),('4017','140'),('4018','140'),('4019','140'),('4020','140'),('4021','140'),('4022','140'),('4023','140'),('4024','140'),('4025','140'),('4026','140'),('4027','140'),('4028','140'),('4029','141'),('4030','141'),('4031','141'),('4032','141'),('4033','141'),('4034','141'),('4035','141'),('4036','141'),('4037','141'),('4038','142'),('4039','142'),('4040','142'),('4041','142'),('4042','142'),('4043','142'),('4044','142'),('4045','142'),('4046','142'),('4047','142'),('4048','142'),('4049','142'),('4050','142'),('4051','142'),('4052','142'),('4053','142'),('4054','142'),('4055','142'),('4056','142'),('4057','142'),('4058','142'),('4059','142'),('4060','142'),('4061','142'),('4062','142'),('4063','143'),('4064','143'),('4065','143'),('4066','143'),('4067','143'),('4068','143'),('4069','143'),('4070','143'),('4071','143'),('4072','143'),('4073','143'),('4074','143'),('4075','143'),('4076','143'),('4077','143'),('4078','143'),('4079','143'),('4080','143'),('4081','143'),('4082','143'),('4083','143'),('4084','143'),('4085','143'),('4086','143'),('4087','143'),('4088','144'),('4089','144'),('4090','144'),('4091','144'),('4092','144'),('4093','144'),('4094','144'),('4095','144'),('4096','144'),('4097','144'),('4098','144'),('4099','144'),('4100','144'),('4101','144'),('4102','144'),('4103','144'),('4104','144'),('4105','144'),('4106','144'),('4107','144'),('4108','144'),('4109','144'),('4110','144'),('4111','144'),('4112','144'),('4113','145'),('4114','145'),('4115','145'),('4116','145'),('4117','145'),('4118','145'),('4119','145'),('4120','145'),('4121','145'),('4122','145'),('4123','145'),('4124','145'),('4125','145'),('4126','145'),('4127','145'),('4128','145'),('4129','145'),('4130','145'),('4131','145'),('4132','145'),('4133','145'),('4134','145'),('4135','145'),('4136','145'),('4137','145'),('4138','145'),('4139','145'),('4140','145'),('4141','145'),('4142','145'),('4143','145'),('4144','145'),('4145','145'),('4146','145'),('4147','146'),('4148','146'),('4149','146'),('4150','146'),('4151','146'),('4152','146'),('4153','146'),('4154','146'),('4155','146'),('4156','146'),('4157','146'),('4158','146'),('4159','146'),('4160','146'),('4161','146'),('4162','146'),('4163','146'),('4164','146'),('4165','146'),('4166','146'),('4167','146'),('4168','146'),('4169','146'),('4170','146'),('4171','146'),('4172','147'),('4173','147'),('4174','147'),('4175','147'),('4176','147'),('4177','147'),('4178','147'),('4179','147'),('4180','147'),('4181','147'),('4182','147'),('4183','147'),('4184','147'),('4185','147'),('4186','147'),('4187','147'),('4188','147'),('4189','147'),('4190','147'),('4191','147'),('4192','147'),('4193','147'),('4194','147'),('4195','147'),('4196','147'),('4197','148'),('4198','148'),('4199','148'),('4200','148'),('4201','148'),('4202','148'),('4203','148'),('4204','148'),('4205','148'),('4206','148'),('4207','148'),('4208','148'),('4209','148'),('4210','148'),('4211','148'),('4212','148'),('4213','148'),('4214','148'),('4215','148'),('4216','148'),('4217','148'),('4218','148'),('4219','148'),('4220','148'),('4221','148'),('4222','149'),('4223','149'),('4224','149'),('4225','149'),('4226','149'),('4227','149'),('4228','149'),('4229','149'),('4230','149'),('4231','149'),('4232','149'),('4233','149'),('4234','149'),('4235','149'),('4236','149'),('4237','149'),('4238','149'),('4239','149'),('4240','149'),('4241','149'),('4242','149'),('4243','149'),('4244','149'),('4245','149'),('4246','149'),('4247','150'),('4248','150'),('4249','150'),('4250','150'),('4251','150'),('4252','150'),('4253','150'),('4254','150'),('4255','150'),('4256','150'),('4257','150'),('4258','150'),('4259','150'),('4260','150'),('4261','150'),('4262','150'),('4263','150'),('4264','150'),('4265','150'),('4266','150'),('4267','150'),('4268','150'),('4269','150'),('4270','150'),('4271','150'),('4272','151'),('4273','151'),('4274','151'),('4275','151'),('4276','151'),('4277','151'),('4278','151'),('4279','151'),('4280','151'),('4281','151'),('4282','151'),('4283','151'),('4284','151'),('4285','151'),('4286','151'),('4287','151'),('4288','151'),('4289','151'),('4290','151'),('4291','151'),('4292','151'),('4293','151'),('4294','151'),('4295','151'),('4296','151'),('4297','152'),('4298','152'),('4299','152'),('4300','152'),('4301','152'),('4302','152'),('4303','152'),('4304','152'),('4305','152'),('4306','152'),('4307','152'),('4308','152'),('4309','152'),('4310','152'),('4311','152'),('4312','152'),('4313','152'),('4314','152'),('4315','152'),('4316','152'),('4317','152'),('4318','152'),('4319','152'),('4320','152'),('4321','152'),('4322','153'),('4323','153'),('4324','153'),('4325','153'),('4326','153'),('4327','153'),('4328','153'),('4329','153'),('4330','153'),('4331','153'),('4332','153'),('4333','153'),('4334','153'),('4335','153'),('4336','153'),('4337','153'),('4338','153'),('4339','153'),('4340','153'),('4341','153'),('4342','153'),('4343','153'),('4344','153'),('4345','153'),('4346','153'),('4347','154'),('4348','154'),('4349','154'),('4350','154'),('4351','154'),('4352','154'),('4353','154'),('4354','154'),('4355','154'),('4356','154'),('4357','154'),('4358','154'),('4359','154'),('4360','154'),('4361','154'),('4362','154'),('4363','154'),('4364','154'),('4365','154'),('4366','154'),('4367','154'),('4368','154'),('4369','154'),('4370','154'),('4371','154'),('4372','155'),('4373','155'),('4374','155'),('4375','155'),('4376','155'),('4377','155'),('4378','155'),('4379','155'),('4380','155'),('4381','155'),('4382','155'),('4383','155'),('4384','155'),('4385','155'),('4386','155'),('4387','155'),('4388','155'),('4389','155'),('4390','155'),('4391','155'),('4392','155'),('4393','155'),('4394','155'),('4395','155'),('4396','155'),('4397','156'),('4398','156'),('4399','156'),('4400','156'),('4401','156'),('4402','156'),('4403','156'),('4404','156'),('4405','156'),('4406','156'),('4407','156'),('4408','156'),('4409','156'),('4410','156'),('4411','156'),('4412','156'),('4413','156'),('4414','156'),('4415','156'),('4416','156'),('4417','156'),('4418','156'),('4419','156'),('4420','156'),('4421','156'),('4422','157'),('4423','157'),('4424','157'),('4425','157'),('4426','157'),('4427','157'),('4428','157'),('4429','157'),('4430','157'),('4431','157'),('4432','157'),('4433','157'),('4434','157'),('4435','157'),('4436','157'),('4437','157'),('4438','157'),('4439','157'),('4440','157'),('4441','157'),('4442','157'),('4443','157'),('4444','157'),('4445','157'),('4446','157'),('4447','157'),('4448','157'),('4449','157'),('4450','157'),('4451','157'),('4452','157'),('4453','157'),('4454','157'),('4455','158'),('4456','158'),('4457','158'),('4458','158'),('4459','158'),('4460','158'),('4461','158'),('4462','158'),('4463','158'),('4464','158'),('4465','158'),('4466','158'),('4467','158'),('4468','158'),('4469','158'),('4470','158'),('4471','158'),('4472','158'),('4473','158'),('4474','158'),('4475','158'),('4476','158'),('4477','158'),('4478','158'),('4479','158'),('4480','159'),('4481','159'),('4482','159'),('4483','159'),('4484','159'),('4485','159'),('4486','159'),('4487','159'),('4488','159'),('4489','159'),('4490','159'),('4491','159'),('4492','159'),('4493','159'),('4494','159'),('4495','159'),('4496','159'),('4497','159'),('4498','159'),('4499','159'),('4500','159'),('4501','159'),('4502','159'),('4503','159'),('4504','159'),('4505','160'),('4506','160'),('4507','160'),('4508','160'),('4509','160'),('4510','160'),('4511','160'),('4512','160'),('4513','160'),('4514','160'),('4515','160'),('4516','160'),('4517','160'),('4518','160'),('4519','160'),('4520','160'),('4521','160'),('4522','160'),('4523','160'),('4524','160'),('4525','160'),('4526','160'),('4527','160'),('4528','160'),('4529','160'),('4530','161'),('4531','161'),('4532','161'),('4533','161'),('4534','161'),('4535','161'),('4536','161'),('4537','161'),('4538','161'),('4539','161'),('4540','161'),('4541','161'),('4542','161'),('4543','161'),('4544','161'),('4545','161'),('4546','161'),('4547','161'),('4548','161'),('4549','161'),('4550','161'),('4551','161'),('4552','161'),('4553','161'),('4554','161'),('4555','162'),('4556','162'),('4557','162'),('4558','162'),('4559','162'),('4560','162'),('4561','162'),('4562','162'),('4563','162'),('4564','162'),('4565','162'),('4566','162'),('4567','162'),('4568','162'),('4569','162'),('4570','162'),('4571','162'),('4572','162'),('4573','162'),('4574','162'),('4575','162'),('4576','162'),('4577','162'),('4578','162'),('4579','162'),('4580','163'),('4581','163'),('4582','163'),('4583','163'),('4584','163'),('4585','163'),('4586','163'),('4587','163'),('4588','163'),('4589','163'),('4590','163'),('4591','163'),('4592','163'),('4593','163'),('4594','163'),('4595','163'),('4596','163'),('4597','163'),('4598','163'),('4599','163'),('4600','163'),('4601','163'),('4602','163'),('4603','163'),('4604','163'),('4605','164'),('4606','164'),('4607','164'),('4608','164'),('4609','164'),('4610','164'),('4611','164'),('4612','164'),('4613','164'),('4614','164'),('4615','164'),('4616','164'),('4617','164'),('4618','164'),('4619','164'),('4620','164'),('4621','164'),('4622','164'),('4623','164'),('4624','164'),('4625','164'),('4626','164'),('4627','164'),('4628','164'),('4629','164'),('4718','169'),('4719','169'),('4720','169'),('4721','169'),('4722','169'),('4723','169'),('4724','169'),('4725','169'),('4726','169'),('4727','169'),('4728','169'),('4729','169'),('4730','169'),('4731','169'),('4732','169'),('4733','169'),('4734','169'),('4735','169'),('4736','169'),('4737','169'),('4738','169'),('4739','169'),('4740','169'),('4741','169'),('4742','169'),('4743','170'),('4744','170'),('4745','170'),('4746','170'),('4747','170'),('4748','170'),('4749','170'),('4750','170'),('4751','170'),('4752','170'),('4753','170'),('4754','170'),('4755','170'),('4756','170'),('4757','170'),('4758','170'),('4759','170'),('4760','170'),('4761','170'),('4762','170'),('4763','170'),('4764','170'),('4765','170'),('4766','170'),('4767','170'),('4768','171'),('4769','171'),('4770','171'),('4771','171'),('4772','171'),('4773','171'),('4774','171'),('4775','171'),('4776','171'),('4777','171'),('4778','171'),('4779','171'),('4780','171'),('4781','171'),('4782','171'),('4783','171'),('4784','171'),('4785','171'),('4786','171'),('4787','171'),('4788','171'),('4789','171'),('4790','171'),('4791','171'),('4792','171'),('4793','172'),('4794','172'),('4795','172'),('4796','172'),('4797','172'),('4798','172'),('4799','172'),('4800','172'),('4801','172'),('4802','172'),('4803','172'),('4804','172'),('4805','172'),('4806','172'),('4807','172'),('4808','172'),('4809','172'),('4810','172'),('4811','172'),('4812','172'),('4813','172'),('4814','172'),('4815','172'),('4816','172'),('4817','172'),('4818','171'),('4819','171'),('4820','171'),('4821','171'),('4822','171'),('4823','171'),('4824','171'),('4825','171'),('4826','171'),('4827','173'),('4828','173'),('4829','173'),('4830','173'),('4831','173'),('4832','173'),('4833','173'),('4834','173'),('4835','173'),('4836','173'),('4837','173'),('4838','173'),('4839','173'),('4840','173'),('4841','173'),('4842','173'),('4843','173'),('4844','173'),('4845','173'),('4846','173'),('4847','173'),('4848','173'),('4849','173'),('4850','173'),('4851','173'),('4852','174'),('4853','174'),('4854','174'),('4855','174'),('4856','174'),('4857','174'),('4858','174'),('4859','174'),('4860','174'),('4861','174'),('4862','174'),('4863','174'),('4864','174'),('4865','174'),('4866','174'),('4867','174'),('4868','174'),('4869','174'),('4870','174'),('4871','174'),('4872','174'),('4873','174'),('4874','174'),('4875','174'),('4876','174'),('4877','175'),('4878','175'),('4879','175'),('4880','175'),('4881','175'),('4882','175'),('4883','175'),('4884','175'),('4885','175'),('4886','175'),('4887','175'),('4888','175'),('4889','175'),('4890','175'),('4891','175'),('4892','175'),('4893','175'),('4894','175'),('4895','175'),('4896','175'),('4897','175'),('4898','175'),('4899','175'),('4900','175'),('4901','175'),('4902','176'),('4903','176'),('4904','176'),('4905','176'),('4906','176'),('4907','176'),('4908','176'),('4909','176'),('4910','176'),('4911','176'),('4912','176'),('4913','176'),('4914','176'),('4915','176'),('4916','176'),('4917','176'),('4918','176'),('4919','176'),('4920','176'),('4921','176'),('4922','176'),('4923','176'),('4924','176'),('4925','176'),('4926','176'),('4927','177'),('4928','177'),('4929','177'),('4930','177'),('4931','177'),('4932','177'),('4933','177'),('4934','177'),('4935','177'),('4936','177'),('4937','177'),('4938','177'),('4939','177'),('4940','177'),('4941','177'),('4942','177'),('4943','177'),('4944','177'),('4945','177'),('4946','177'),('4947','177'),('4948','177'),('4949','177'),('4950','177'),('4951','177'),('4952','178'),('4953','178'),('4954','178'),('4955','178'),('4956','178'),('4957','178'),('4958','178'),('4959','178'),('4960','178'),('4961','178'),('4962','178'),('4963','178'),('4964','178'),('4965','178'),('4966','178'),('4967','178'),('4968','178'),('4969','178'),('4970','178'),('4971','178'),('4972','178'),('4973','178'),('4974','178'),('4975','178'),('4976','178'),('4977','179'),('4978','179'),('4979','179'),('4980','179'),('4981','179'),('4982','179'),('4983','179'),('4984','179'),('4985','179'),('4986','179'),('4987','179'),('4988','179'),('4989','179'),('4990','179'),('4991','179'),('4992','179'),('4993','179'),('4994','179'),('4995','179'),('4996','179'),('4997','179'),('4998','179'),('4999','179'),('5000','179'),('5001','179'),('5002','180'),('5003','180'),('5004','180'),('5005','180'),('5006','180'),('5007','180'),('5008','180'),('5009','180'),('5010','180'),('5011','180'),('5012','180'),('5013','180'),('5014','180'),('5015','180'),('5016','180'),('5017','180'),('5018','180'),('5019','180'),('5020','180'),('5021','180'),('5022','180'),('5023','180'),('5024','180'),('5025','180'),('5026','180'),('5027','181'),('5028','181'),('5029','181'),('5030','181'),('5031','181'),('5032','181'),('5033','181'),('5034','181'),('5035','181'),('5036','181'),('5037','181'),('5038','181'),('5039','181'),('5040','181'),('5041','181'),('5042','181'),('5043','181'),('5044','181'),('5045','181'),('5046','181'),('5047','181'),('5048','181'),('5049','181'),('5050','181'),('5051','181'),('5052','181'),('5053','181'),('5054','181'),('5055','181'),('5056','181'),('5057','181'),('5058','181'),('5059','181'),('5060','182'),('5061','182'),('5062','182'),('5063','182'),('5064','182'),('5065','182'),('5066','182'),('5067','182'),('5068','182'),('5069','182'),('5070','182'),('5071','182'),('5072','182'),('5073','182'),('5074','182'),('5075','182'),('5076','182'),('5077','182'),('5078','182'),('5079','182'),('5080','182'),('5081','182'),('5082','182'),('5083','182'),('5084','182'),('5085','183'),('5086','183'),('5087','183'),('5088','183'),('5089','183'),('5090','183'),('5091','183'),('5092','183'),('5093','183'),('5094','183'),('5095','183'),('5096','183'),('5097','183'),('5098','183'),('5099','183'),('5100','183'),('5101','183'),('5102','183'),('5103','183'),('5104','183'),('5105','183'),('5106','183'),('5107','183'),('5108','183'),('5109','183'),('5110','19'),('5111','19'),('5112','19'),('5113','19'),('5114','19'),('5115','19'),('5116','19'),('5117','19'),('5118','19'),('5119','19'),('5120','19'),('5121','19'),('5122','19'),('5123','19'),('5124','19'),('5125','19'),('5126','19'),('5127','19'),('5128','19'),('5129','19'),('5130','19'),('5131','19'),('5132','19'),('5133','19'),('5134','19'),('5135','19'),('5136','19'),('5137','19'),('5138','19'),('5139','20'),('5140','20'),('5141','20'),('5142','20'),('5143','20'),('5144','20'),('5145','20'),('5146','20'),('5147','20'),('5148','20'),('5149','20'),('5150','20'),('5151','20'),('5152','20'),('5153','20'),('5154','20'),('5155','20'),('5156','20'),('5157','20'),('5158','20'),('5159','20'),('5160','1'),('5161','1'),('5162','1'),('5163','1'),('5164','1'),('5165','1'),('5166','1'),('5167','1'),('5168','1'),('5169','1'),('5170','1'),('5171','1'),('5172','1'),('5173','1'),('5174','1'),('5175','1'),('5176','1'),('5177','1'),('5178','1'),('5179','4'),('5180','4'),('5181','4'),('5182','4'),('5183','4'),('5184','4'),('5185','4'),('5186','4'),('5187','4'),('5188','4'),('5189','4'),('5190','4'),('5191','4'),('5192','4'),('5193','4'),('5194','4'),('5195','4'),('5196','4'),('5197','4'),('5198','4'),('5199','4'),('5200','4'),('5201','4'),('5202','4'),('5203','4'),('5204','4'),('5205','4'),('5206','4'),('5207','4'),('5208','4');
/*!40000 ALTER TABLE `catalog_product_attribute_cl` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_bundle_option`
--

DROP TABLE IF EXISTS `catalog_product_bundle_option`;
CREATE TABLE `catalog_product_bundle_option` (
  `option_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Option Id',
  `parent_id` int(10) unsigned NOT NULL COMMENT 'Parent Id',
  `required` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Required',
  `position` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Position',
  `type` varchar(255) DEFAULT NULL COMMENT 'Type',
  PRIMARY KEY (`option_id`),
  KEY `CATALOG_PRODUCT_BUNDLE_OPTION_PARENT_ID` (`parent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Product Bundle Option';

--
-- Table structure for table `catalog_product_bundle_option_value`
--

DROP TABLE IF EXISTS `catalog_product_bundle_option_value`;
CREATE TABLE `catalog_product_bundle_option_value` (
  `value_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Value Id',
  `option_id` int(10) unsigned NOT NULL COMMENT 'Option Id',
  `parent_product_id` int(10) unsigned NOT NULL COMMENT 'Parent Product Id',
  `store_id` smallint(5) unsigned NOT NULL COMMENT 'Store Id',
  `title` varchar(255) DEFAULT NULL COMMENT 'Title',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `CAT_PRD_BNDL_OPT_VAL_OPT_ID_PARENT_PRD_ID_STORE_ID` (`option_id`,`parent_product_id`,`store_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Product Bundle Option Value';

--
-- Table structure for table `catalog_product_bundle_price_index`
--

DROP TABLE IF EXISTS `catalog_product_bundle_price_index`;
CREATE TABLE `catalog_product_bundle_price_index` (
  `entity_id` int(10) unsigned NOT NULL COMMENT 'Entity Id',
  `website_id` smallint(5) unsigned NOT NULL COMMENT 'Website Id',
  `customer_group_id` int(10) unsigned NOT NULL COMMENT 'Customer Group Id',
  `min_price` decimal(12,4) NOT NULL COMMENT 'Min Price',
  `max_price` decimal(12,4) NOT NULL COMMENT 'Max Price',
  PRIMARY KEY (`entity_id`,`website_id`,`customer_group_id`),
  KEY `CATALOG_PRODUCT_BUNDLE_PRICE_INDEX_WEBSITE_ID` (`website_id`),
  KEY `CATALOG_PRODUCT_BUNDLE_PRICE_INDEX_CUSTOMER_GROUP_ID` (`customer_group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Product Bundle Price Index';

--
-- Table structure for table `catalog_product_bundle_selection`
--

DROP TABLE IF EXISTS `catalog_product_bundle_selection`;
CREATE TABLE `catalog_product_bundle_selection` (
  `selection_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Selection Id',
  `option_id` int(10) unsigned NOT NULL COMMENT 'Option Id',
  `parent_product_id` int(10) unsigned NOT NULL COMMENT 'Parent Product Id',
  `product_id` int(10) unsigned NOT NULL COMMENT 'Product Id',
  `position` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Position',
  `is_default` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Default',
  `selection_price_type` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Selection Price Type',
  `selection_price_value` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Selection Price Value',
  `selection_qty` decimal(12,4) DEFAULT NULL COMMENT 'Selection Qty',
  `selection_can_change_qty` smallint(6) NOT NULL DEFAULT '0' COMMENT 'Selection Can Change Qty',
  PRIMARY KEY (`selection_id`),
  KEY `CATALOG_PRODUCT_BUNDLE_SELECTION_OPTION_ID` (`option_id`),
  KEY `CATALOG_PRODUCT_BUNDLE_SELECTION_PRODUCT_ID` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Product Bundle Selection';

--
-- Table structure for table `catalog_product_bundle_selection_price`
--

DROP TABLE IF EXISTS `catalog_product_bundle_selection_price`;
CREATE TABLE `catalog_product_bundle_selection_price` (
  `selection_id` int(10) unsigned NOT NULL COMMENT 'Selection Id',
  `parent_product_id` int(10) unsigned NOT NULL COMMENT 'Parent Product Id',
  `website_id` smallint(5) unsigned NOT NULL COMMENT 'Website Id',
  `selection_price_type` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Selection Price Type',
  `selection_price_value` decimal(12,4) NOT NULL DEFAULT '0.0000' COMMENT 'Selection Price Value',
  PRIMARY KEY (`selection_id`,`parent_product_id`,`website_id`),
  KEY `CATALOG_PRODUCT_BUNDLE_SELECTION_PRICE_WEBSITE_ID` (`website_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Product Bundle Selection Price';

--
-- Table structure for table `catalog_product_bundle_stock_index`
--

DROP TABLE IF EXISTS `catalog_product_bundle_stock_index`;
CREATE TABLE `catalog_product_bundle_stock_index` (
  `entity_id` int(10) unsigned NOT NULL COMMENT 'Entity Id',
  `website_id` smallint(5) unsigned NOT NULL COMMENT 'Website Id',
  `stock_id` smallint(5) unsigned NOT NULL COMMENT 'Stock Id',
  `option_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Option Id',
  `stock_status` smallint(6) DEFAULT '0' COMMENT 'Stock Status',
  PRIMARY KEY (`entity_id`,`website_id`,`stock_id`,`option_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Product Bundle Stock Index';

--
-- Table structure for table `catalog_product_category_cl`
--

DROP TABLE IF EXISTS `catalog_product_category_cl`;
CREATE TABLE `catalog_product_category_cl` (
  `version_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Version ID',
  `entity_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  PRIMARY KEY (`version_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3173 DEFAULT CHARSET=utf8 COMMENT='catalog_product_category_cl';

--
-- Dumping data for table `catalog_product_category_cl`
--

LOCK TABLES `catalog_product_category_cl` WRITE;
/*!40000 ALTER TABLE `catalog_product_category_cl` DISABLE KEYS */;
INSERT INTO `catalog_product_category_cl` VALUES ('1','1'),('2','1'),('3','1'),('4','1'),('5','4'),('6','4'),('7','4'),('8','4'),('9','4'),('10','4'),('11','4'),('12','4'),('13','5'),('14','5'),('15','5'),('16','5'),('17','5'),('18','5'),('19','5'),('20','5'),('21','6'),('22','6'),('23','6'),('24','6'),('25','6'),('26','7'),('27','7'),('28','7'),('29','7'),('30','7'),('31','7'),('32','7'),('33','7'),('34','8'),('35','8'),('36','8'),('37','8'),('38','8'),('39','9'),('40','9'),('41','9'),('42','9'),('43','9'),('44','10'),('45','10'),('46','10'),('47','10'),('48','10'),('49','11'),('50','11'),('51','11'),('52','11'),('53','11'),('54','12'),('55','12'),('56','12'),('57','12'),('58','12'),('59','13'),('60','13'),('61','13'),('62','13'),('63','13'),('64','14'),('65','14'),('66','14'),('67','14'),('68','14'),('69','15'),('70','15'),('71','15'),('72','15'),('73','15'),('74','16'),('75','16'),('76','16'),('77','16'),('78','16'),('79','17'),('80','17'),('81','17'),('82','17'),('83','17'),('84','18'),('85','18'),('86','18'),('87','18'),('88','18'),('89','18'),('90','18'),('91','18'),('92','19'),('93','19'),('94','19'),('95','19'),('96','19'),('97','20'),('98','20'),('99','20'),('100','20'),('101','20'),('102','20'),('103','20'),('104','20'),('105','21'),('106','21'),('107','21'),('108','21'),('109','21'),('110','21'),('111','21'),('112','21'),('113','21'),('114','21'),('115','21'),('116','21'),('117','21'),('118','21'),('119','21'),('120','21'),('121','21'),('122','21'),('123','21'),('124','21'),('125','21'),('126','22'),('127','22'),('128','22'),('129','22'),('130','22'),('131','22'),('132','22'),('133','22'),('134','22'),('135','22'),('136','22'),('137','22'),('138','22'),('139','22'),('140','22'),('141','22'),('142','22'),('143','22'),('144','22'),('145','22'),('146','22'),('147','23'),('148','23'),('149','23'),('150','23'),('151','23'),('152','23'),('153','23'),('154','23'),('155','23'),('156','23'),('157','23'),('158','23'),('159','23'),('160','23'),('161','23'),('162','23'),('163','23'),('164','23'),('165','23'),('166','23'),('167','23'),('168','24'),('169','24'),('170','24'),('171','24'),('172','24'),('173','24'),('174','24'),('175','24'),('176','24'),('177','24'),('178','24'),('179','24'),('180','24'),('181','24'),('182','24'),('183','24'),('184','24'),('185','24'),('186','24'),('187','24'),('188','24'),('189','25'),('190','25'),('191','25'),('192','25'),('193','25'),('194','25'),('195','25'),('196','25'),('197','25'),('198','25'),('199','25'),('200','25'),('201','25'),('202','25'),('203','25'),('204','25'),('205','25'),('206','25'),('207','25'),('208','25'),('209','25'),('210','26'),('211','26'),('212','26'),('213','26'),('214','26'),('215','26'),('216','26'),('217','26'),('218','26'),('219','26'),('220','26'),('221','26'),('222','26'),('223','26'),('224','26'),('225','26'),('226','26'),('227','26'),('228','26'),('229','26'),('230','26'),('231','27'),('232','27'),('233','27'),('234','27'),('235','27'),('236','27'),('237','27'),('238','27'),('239','27'),('240','27'),('241','27'),('242','27'),('243','27'),('244','27'),('245','27'),('246','27'),('247','27'),('248','27'),('249','27'),('250','27'),('251','27'),('252','28'),('253','28'),('254','28'),('255','28'),('256','28'),('257','28'),('258','28'),('259','28'),('260','28'),('261','28'),('262','28'),('263','28'),('264','28'),('265','28'),('266','28'),('267','28'),('268','28'),('269','28'),('270','28'),('271','28'),('272','28'),('273','29'),('274','29'),('275','29'),('276','29'),('277','29'),('278','29'),('279','29'),('280','29'),('281','29'),('282','29'),('283','29'),('284','29'),('285','29'),('286','29'),('287','29'),('288','29'),('289','29'),('290','29'),('291','29'),('292','29'),('293','29'),('294','30'),('295','30'),('296','30'),('297','30'),('298','30'),('299','30'),('300','30'),('301','30'),('302','30'),('303','30'),('304','30'),('305','30'),('306','30'),('307','30'),('308','30'),('309','30'),('310','30'),('311','30'),('312','30'),('313','30'),('314','30'),('315','31'),('316','31'),('317','31'),('318','31'),('319','31'),('320','31'),('321','31'),('322','31'),('323','31'),('324','31'),('325','31'),('326','31'),('327','31'),('328','31'),('329','31'),('330','31'),('331','31'),('332','31'),('333','31'),('334','31'),('335','32'),('336','32'),('337','32'),('338','32'),('339','32'),('340','32'),('341','32'),('342','32'),('343','32'),('344','32'),('345','32'),('346','32'),('347','32'),('348','32'),('349','32'),('350','32'),('351','32'),('352','32'),('353','32'),('354','32'),('355','32'),('356','33'),('357','33'),('358','33'),('359','33'),('360','33'),('361','33'),('362','33'),('363','33'),('364','33'),('365','33'),('366','33'),('367','33'),('368','33'),('369','33'),('370','33'),('371','33'),('372','33'),('373','33'),('374','33'),('375','33'),('376','33'),('377','34'),('378','34'),('379','34'),('380','34'),('381','34'),('382','34'),('383','34'),('384','34'),('385','34'),('386','34'),('387','34'),('388','34'),('389','34'),('390','34'),('391','34'),('392','34'),('393','34'),('394','34'),('395','34'),('396','34'),('397','34'),('398','35'),('399','35'),('400','35'),('401','35'),('402','35'),('403','35'),('404','35'),('405','35'),('406','35'),('407','35'),('408','35'),('409','35'),('410','35'),('411','35'),('412','35'),('413','35'),('414','35'),('415','35'),('416','35'),('417','35'),('418','35'),('419','36'),('420','36'),('421','36'),('422','36'),('423','36'),('424','36'),('425','36'),('426','36'),('427','36'),('428','36'),('429','36'),('430','36'),('431','36'),('432','36'),('433','36'),('434','36'),('435','36'),('436','36'),('437','36'),('438','36'),('439','36'),('440','37'),('441','37'),('442','37'),('443','37'),('444','37'),('445','37'),('446','37'),('447','37'),('448','37'),('449','37'),('450','37'),('451','37'),('452','37'),('453','37'),('454','37'),('455','37'),('456','37'),('457','37'),('458','37'),('459','37'),('460','37'),('461','38'),('462','38'),('463','38'),('464','38'),('465','38'),('466','38'),('467','38'),('468','38'),('469','38'),('470','38'),('471','38'),('472','38'),('473','38'),('474','38'),('475','38'),('476','38'),('477','38'),('478','38'),('479','38'),('480','38'),('481','38'),('482','38'),('483','38'),('484','38'),('485','38'),('486','38'),('487','38'),('488','39'),('489','39'),('490','39'),('491','39'),('492','39'),('493','39'),('494','39'),('495','39'),('496','39'),('497','39'),('498','39'),('499','39'),('500','39'),('501','39'),('502','39'),('503','39'),('504','39'),('505','39'),('506','39'),('507','39'),('508','39'),('509','39'),('510','39'),('511','39'),('512','39'),('513','39'),('514','39'),('515','40'),('516','40'),('517','40'),('518','40'),('519','40'),('520','40'),('521','40'),('522','40'),('523','40'),('524','40'),('525','40'),('526','40'),('527','40'),('528','40'),('529','40'),('530','40'),('531','40'),('532','40'),('533','40'),('534','40'),('535','40'),('536','40'),('537','40'),('538','40'),('539','40'),('540','40'),('541','40'),('542','41'),('543','41'),('544','41'),('545','41'),('546','41'),('547','41'),('548','41'),('549','41'),('550','41'),('551','41'),('552','41'),('553','41'),('554','41'),('555','41'),('556','41'),('557','41'),('558','41'),('559','41'),('560','41'),('561','41'),('562','41'),('563','41'),('564','41'),('565','41'),('566','41'),('567','41'),('568','41'),('569','42'),('570','42'),('571','42'),('572','42'),('573','42'),('574','42'),('575','42'),('576','42'),('577','42'),('578','42'),('579','42'),('580','42'),('581','42'),('582','42'),('583','42'),('584','42'),('585','42'),('586','42'),('587','42'),('588','42'),('589','42'),('590','42'),('591','42'),('592','42'),('593','42'),('594','42'),('595','42'),('596','43'),('597','43'),('598','43'),('599','43'),('600','43'),('601','43'),('602','43'),('603','43'),('604','43'),('605','43'),('606','43'),('607','43'),('608','43'),('609','43'),('610','43'),('611','43'),('612','43'),('613','43'),('614','43'),('615','43'),('616','43'),('617','43'),('618','43'),('619','43'),('620','43'),('621','43'),('622','43'),('623','44'),('624','44'),('625','44'),('626','44'),('627','44'),('628','44'),('629','44'),('630','44'),('631','44'),('632','44'),('633','44'),('634','44'),('635','44'),('636','44'),('637','44'),('638','44'),('639','44'),('640','44'),('641','44'),('642','44'),('643','44'),('644','44'),('645','44'),('646','44'),('647','44'),('648','44'),('649','44'),('650','45'),('651','45'),('652','45'),('653','45'),('654','45'),('655','45'),('656','45'),('657','45'),('658','45'),('659','45'),('660','45'),('661','45'),('662','45'),('663','45'),('664','45'),('665','45'),('666','45'),('667','45'),('668','45'),('669','45'),('670','45'),('671','45'),('672','45'),('673','45'),('674','45'),('675','45'),('676','45'),('677','46'),('678','46'),('679','46'),('680','46'),('681','46'),('682','46'),('683','46'),('684','46'),('685','46'),('686','46'),('687','46'),('688','46'),('689','46'),('690','46'),('691','46'),('692','46'),('693','46'),('694','46'),('695','46'),('696','46'),('697','46'),('698','46'),('699','46'),('700','46'),('701','46'),('702','46'),('703','46'),('704','47'),('705','47'),('706','47'),('707','47'),('708','47'),('709','47'),('710','47'),('711','47'),('712','47'),('713','47'),('714','47'),('715','47'),('716','47'),('717','47'),('718','47'),('719','47'),('720','47'),('721','47'),('722','47'),('723','47'),('724','47'),('725','47'),('726','47'),('727','47'),('728','47'),('729','47'),('730','47'),('731','48'),('732','48'),('733','48'),('734','48'),('735','48'),('736','48'),('737','48'),('738','48'),('739','48'),('740','48'),('741','48'),('742','48'),('743','48'),('744','48'),('745','48'),('746','48'),('747','48'),('748','48'),('749','48'),('750','48'),('751','48'),('752','48'),('753','48'),('754','48'),('755','48'),('756','48'),('757','48'),('758','49'),('759','49'),('760','49'),('761','49'),('762','49'),('763','49'),('764','49'),('765','49'),('766','49'),('767','49'),('768','49'),('769','49'),('770','49'),('771','49'),('772','49'),('773','49'),('774','49'),('775','49'),('776','49'),('777','49'),('778','49'),('779','49'),('780','49'),('781','49'),('782','49'),('783','49'),('784','49'),('785','50'),('786','50'),('787','50'),('788','50'),('789','50'),('790','50'),('791','50'),('792','50'),('793','50'),('794','50'),('795','50'),('796','50'),('797','50'),('798','50'),('799','50'),('800','50'),('801','50'),('802','50'),('803','50'),('804','50'),('805','50'),('806','50'),('807','50'),('808','50'),('809','50'),('810','50'),('811','50'),('812','51'),('813','51'),('814','51'),('815','51'),('816','51'),('817','51'),('818','51'),('819','51'),('820','51'),('821','51'),('822','51'),('823','51'),('824','51'),('825','51'),('826','51'),('827','51'),('828','51'),('829','51'),('830','51'),('831','51'),('832','51'),('833','51'),('834','51'),('835','51'),('836','51'),('837','51'),('838','51'),('839','52'),('840','52'),('841','52'),('842','52'),('843','52'),('844','52'),('845','52'),('846','52'),('847','52'),('848','52'),('849','52'),('850','52'),('851','52'),('852','52'),('853','52'),('854','52'),('855','52'),('856','52'),('857','52'),('858','52'),('859','52'),('860','52'),('861','52'),('862','52'),('863','52'),('864','52'),('865','52'),('866','53'),('867','53'),('868','53'),('869','53'),('870','53'),('871','53'),('872','53'),('873','53'),('874','53'),('875','53'),('876','53'),('877','53'),('878','53'),('879','53'),('880','53'),('881','53'),('882','53'),('883','53'),('884','53'),('885','53'),('886','53'),('887','53'),('888','53'),('889','53'),('890','53'),('891','53'),('892','53'),('893','54'),('894','54'),('895','54'),('896','54'),('897','54'),('898','54'),('899','54'),('900','54'),('901','54'),('902','54'),('903','54'),('904','54'),('905','54'),('906','54'),('907','54'),('908','54'),('909','54'),('910','54'),('911','54'),('912','54'),('913','54'),('914','54'),('915','54'),('916','54'),('917','54'),('918','54'),('919','54'),('920','55'),('921','55'),('922','55'),('923','55'),('924','55'),('925','55'),('926','55'),('927','55'),('928','55'),('929','55'),('930','55'),('931','55'),('932','55'),('933','55'),('934','55'),('935','55'),('936','55'),('937','55'),('938','55'),('939','55'),('940','55'),('941','55'),('942','55'),('943','55'),('944','55'),('945','55'),('946','55'),('978','58'),('979','58'),('980','58'),('981','58'),('982','58'),('983','58'),('984','58'),('985','58'),('986','58'),('987','58'),('988','58'),('989','58'),('990','58'),('991','58'),('992','58'),('993','58'),('994','58'),('995','58'),('996','58'),('997','58'),('998','58'),('999','58'),('1000','58'),('1001','59'),('1002','59'),('1003','59'),('1004','59'),('1005','59'),('1006','59'),('1007','59'),('1008','59'),('1009','59'),('1010','59'),('1011','59'),('1012','59'),('1013','59'),('1014','59'),('1015','59'),('1016','59'),('1017','59'),('1018','59'),('1019','59'),('1020','59'),('1021','59'),('1022','59'),('1023','59'),('1024','59'),('1025','60'),('1026','60'),('1027','60'),('1028','60'),('1029','60'),('1030','60'),('1031','60'),('1032','60'),('1033','60'),('1034','60'),('1035','60'),('1036','60'),('1037','60'),('1038','60'),('1039','60'),('1040','60'),('1041','60'),('1042','60'),('1043','60'),('1044','60'),('1045','60'),('1046','60'),('1047','60'),('1048','60'),('1049','61'),('1050','61'),('1051','61'),('1052','61'),('1053','61'),('1054','61'),('1055','61'),('1056','61'),('1057','61'),('1058','61'),('1059','61'),('1060','61'),('1061','61'),('1062','61'),('1063','61'),('1064','61'),('1065','61'),('1066','61'),('1067','61'),('1068','61'),('1069','61'),('1070','61'),('1071','61'),('1072','61'),('1073','62'),('1074','62'),('1075','62'),('1076','62'),('1077','62'),('1078','62'),('1079','62'),('1080','62'),('1081','62'),('1082','62'),('1083','62'),('1084','62'),('1085','62'),('1086','62'),('1087','62'),('1088','62'),('1089','62'),('1090','62'),('1091','62'),('1092','62'),('1093','62'),('1094','62'),('1095','62'),('1096','62'),('1097','63'),('1098','63'),('1099','63'),('1100','63'),('1101','63'),('1102','63'),('1103','63'),('1104','63'),('1105','63'),('1106','63'),('1107','63'),('1108','63'),('1109','63'),('1110','63'),('1111','63'),('1112','63'),('1113','63'),('1114','63'),('1115','63'),('1116','63'),('1117','63'),('1118','63'),('1119','63'),('1120','63'),('1121','64'),('1122','64'),('1123','64'),('1124','64'),('1125','64'),('1126','64'),('1127','64'),('1128','64'),('1129','64'),('1130','64'),('1131','64'),('1132','64'),('1133','64'),('1134','64'),('1135','64'),('1136','64'),('1137','64'),('1138','64'),('1139','64'),('1140','64'),('1141','64'),('1142','64'),('1143','64'),('1144','64'),('1145','65'),('1146','65'),('1147','65'),('1148','65'),('1149','65'),('1150','65'),('1151','65'),('1152','65'),('1153','65'),('1154','65'),('1155','65'),('1156','65'),('1157','65'),('1158','65'),('1159','65'),('1160','65'),('1161','65'),('1162','65'),('1163','65'),('1164','65'),('1165','65'),('1166','65'),('1167','65'),('1168','65'),('1169','66'),('1170','66'),('1171','66'),('1172','66'),('1173','66'),('1174','66'),('1175','66'),('1176','66'),('1177','66'),('1178','66'),('1179','66'),('1180','66'),('1181','66'),('1182','66'),('1183','66'),('1184','66'),('1185','66'),('1186','66'),('1187','66'),('1188','66'),('1189','66'),('1190','66'),('1191','66'),('1192','66'),('1193','67'),('1194','67'),('1195','67'),('1196','67'),('1197','67'),('1198','67'),('1199','67'),('1200','67'),('1201','67'),('1202','67'),('1203','67'),('1204','67'),('1205','67'),('1206','67'),('1207','67'),('1208','67'),('1209','67'),('1210','67'),('1211','67'),('1212','67'),('1213','67'),('1214','67'),('1215','67'),('1216','67'),('1217','68'),('1218','68'),('1219','68'),('1220','68'),('1221','68'),('1222','68'),('1223','68'),('1224','68'),('1225','68'),('1226','68'),('1227','68'),('1228','68'),('1229','68'),('1230','68'),('1231','68'),('1232','68'),('1233','68'),('1234','68'),('1235','68'),('1236','68'),('1237','68'),('1238','68'),('1239','68'),('1240','68'),('1241','69'),('1242','69'),('1243','69'),('1244','69'),('1245','69'),('1246','69'),('1247','69'),('1248','69'),('1249','69'),('1250','69'),('1251','69'),('1252','69'),('1253','69'),('1254','69'),('1255','69'),('1256','69'),('1257','69'),('1258','69'),('1259','69'),('1260','69'),('1261','69'),('1262','69'),('1263','69'),('1264','69'),('1265','70'),('1266','70'),('1267','70'),('1268','70'),('1269','70'),('1270','70'),('1271','70'),('1272','70'),('1273','70'),('1274','70'),('1275','70'),('1276','70'),('1277','70'),('1278','70'),('1279','70'),('1280','70'),('1281','70'),('1282','70'),('1283','70'),('1284','70'),('1285','70'),('1286','70'),('1287','70'),('1288','70'),('1289','71'),('1290','71'),('1291','71'),('1292','71'),('1293','71'),('1294','71'),('1295','71'),('1296','71'),('1297','71'),('1298','71'),('1299','71'),('1300','71'),('1301','71'),('1302','71'),('1303','71'),('1304','71'),('1305','71'),('1306','71'),('1307','71'),('1308','71'),('1309','71'),('1310','71'),('1311','71'),('1312','71'),('1313','72'),('1314','72'),('1315','72'),('1316','72'),('1317','72'),('1318','72'),('1319','72'),('1320','72'),('1321','72'),('1322','72'),('1323','72'),('1324','72'),('1325','72'),('1326','72'),('1327','72'),('1328','72'),('1329','72'),('1330','72'),('1331','72'),('1332','72'),('1333','72'),('1334','72'),('1335','72'),('1336','72'),('1337','73'),('1338','73'),('1339','73'),('1340','73'),('1341','73'),('1342','73'),('1343','73'),('1344','73'),('1345','73'),('1346','73'),('1347','73'),('1348','73'),('1349','73'),('1350','73'),('1351','73'),('1352','73'),('1353','73'),('1354','73'),('1355','73'),('1356','73'),('1357','73'),('1358','73'),('1359','73'),('1360','73'),('1361','74'),('1362','74'),('1363','74'),('1364','74'),('1365','74'),('1366','74'),('1367','74'),('1368','74'),('1369','74'),('1370','74'),('1371','74'),('1372','74'),('1373','74'),('1374','74'),('1375','74'),('1376','74'),('1377','74'),('1378','74'),('1379','74'),('1380','74'),('1381','74'),('1382','74'),('1383','74'),('1384','74'),('1385','75'),('1386','75'),('1387','75'),('1388','75'),('1389','75'),('1390','75'),('1391','75'),('1392','75'),('1393','75'),('1394','75'),('1395','75'),('1396','75'),('1397','75'),('1398','75'),('1399','75'),('1400','75'),('1401','75'),('1402','75'),('1403','75'),('1404','75'),('1405','75'),('1406','75'),('1407','75'),('1408','75'),('1409','4'),('1410','5'),('1411','6'),('1412','7'),('1413','8'),('1414','9'),('1415','10'),('1416','11'),('1417','12'),('1418','13'),('1419','14'),('1420','15'),('1421','16'),('1422','17'),('1423','18'),('1424','19'),('1425','20'),('1426','1'),('1427','1'),('1428','1'),('1429','1'),('1430','1'),('1431','1'),('1432','1'),('1433','1'),('1434','1'),('1435','1'),('1436','4'),('1437','4'),('1438','4'),('1439','4'),('1440','4'),('1441','4'),('1442','4'),('1443','4'),('1444','4'),('1445','4'),('1446','5'),('1447','5'),('1448','5'),('1449','5'),('1450','5'),('1451','5'),('1452','5'),('1453','5'),('1454','5'),('1455','5'),('1456','6'),('1457','6'),('1458','6'),('1459','6'),('1460','6'),('1461','6'),('1462','6'),('1463','6'),('1464','6'),('1465','6'),('1466','7'),('1467','7'),('1468','7'),('1469','7'),('1470','7'),('1471','7'),('1472','7'),('1473','7'),('1474','7'),('1475','7'),('1476','8'),('1477','8'),('1478','8'),('1479','8'),('1480','8'),('1481','8'),('1482','8'),('1483','8'),('1484','8'),('1485','8'),('1486','9'),('1487','9'),('1488','9'),('1489','9'),('1490','9'),('1491','9'),('1492','9'),('1493','9'),('1494','9'),('1495','9'),('1496','10'),('1497','10'),('1498','10'),('1499','10'),('1500','10'),('1501','10'),('1502','10'),('1503','10'),('1504','10'),('1505','10'),('1506','11'),('1507','11'),('1508','11'),('1509','11'),('1510','11'),('1511','11'),('1512','11'),('1513','11'),('1514','11'),('1515','11'),('1516','12'),('1517','12'),('1518','12'),('1519','12'),('1520','12'),('1521','12'),('1522','12'),('1523','12'),('1524','12'),('1525','12'),('1526','13'),('1527','13'),('1528','13'),('1529','13'),('1530','13'),('1531','13'),('1532','13'),('1533','13'),('1534','13'),('1535','13'),('1536','14'),('1537','14'),('1538','14'),('1539','14'),('1540','14'),('1541','14'),('1542','14'),('1543','14'),('1544','14'),('1545','14'),('1546','15'),('1547','15'),('1548','15'),('1549','15'),('1550','15'),('1551','15'),('1552','15'),('1553','15'),('1554','15'),('1555','15'),('1556','16'),('1557','16'),('1558','16'),('1559','16'),('1560','16'),('1561','16'),('1562','16'),('1563','16'),('1564','16'),('1565','16'),('1566','17'),('1567','17'),('1568','17'),('1569','17'),('1570','17'),('1571','17'),('1572','17'),('1573','17'),('1574','17'),('1575','17'),('1576','18'),('1577','18'),('1578','18'),('1579','18'),('1580','18'),('1581','18'),('1582','18'),('1583','18'),('1584','18'),('1585','18'),('1586','19'),('1587','19'),('1588','19'),('1589','19'),('1590','19'),('1591','19'),('1592','19'),('1593','19'),('1594','19'),('1595','19'),('1596','20'),('1597','20'),('1598','20'),('1599','20'),('1600','20'),('1601','20'),('1602','20'),('1603','20'),('1604','20'),('1605','20'),('1606','21'),('1607','21'),('1608','21'),('1609','21'),('1610','21'),('1611','21'),('1612','21'),('1613','21'),('1614','21'),('1615','21'),('1616','22'),('1617','22'),('1618','22'),('1619','22'),('1620','22'),('1621','22'),('1622','22'),('1623','22'),('1624','22'),('1625','22'),('1626','23'),('1627','23'),('1628','23'),('1629','23'),('1630','23'),('1631','23'),('1632','23'),('1633','23'),('1634','23'),('1635','23'),('1636','24'),('1637','24'),('1638','24'),('1639','24'),('1640','24'),('1641','24'),('1642','24'),('1643','24'),('1644','24'),('1645','24'),('1646','25'),('1647','25'),('1648','25'),('1649','25'),('1650','25'),('1651','25'),('1652','25'),('1653','25'),('1654','25'),('1655','25'),('1656','26'),('1657','26'),('1658','26'),('1659','26'),('1660','26'),('1661','26'),('1662','26'),('1663','26'),('1664','26'),('1665','26'),('1666','27'),('1667','27'),('1668','27'),('1669','27'),('1670','27'),('1671','27'),('1672','27'),('1673','27'),('1674','27'),('1675','27'),('1676','28'),('1677','28'),('1678','28'),('1679','28'),('1680','28'),('1681','28'),('1682','28'),('1683','28'),('1684','28'),('1685','28'),('1686','29'),('1687','29'),('1688','29'),('1689','29'),('1690','29'),('1691','29'),('1692','29'),('1693','29'),('1694','29'),('1695','29'),('1696','30'),('1697','30'),('1698','30'),('1699','30'),('1700','30'),('1701','30'),('1702','30'),('1703','30'),('1704','30'),('1705','30'),('1706','31'),('1707','31'),('1708','31'),('1709','31'),('1710','31'),('1711','31'),('1712','31'),('1713','31'),('1714','31'),('1715','31'),('1716','32'),('1717','32'),('1718','32'),('1719','32'),('1720','32'),('1721','32'),('1722','32'),('1723','32'),('1724','32'),('1725','32'),('1726','33'),('1727','33'),('1728','33'),('1729','33'),('1730','33'),('1731','33'),('1732','33'),('1733','33'),('1734','33'),('1735','33'),('1736','34'),('1737','34'),('1738','34'),('1739','34'),('1740','34'),('1741','34'),('1742','34'),('1743','34'),('1744','34'),('1745','34'),('1746','35'),('1747','35'),('1748','35'),('1749','35'),('1750','35'),('1751','35'),('1752','35'),('1753','35'),('1754','35'),('1755','35'),('1756','36'),('1757','36'),('1758','36'),('1759','36'),('1760','36'),('1761','36'),('1762','36'),('1763','36'),('1764','36'),('1765','36'),('1766','37'),('1767','37'),('1768','37'),('1769','37'),('1770','37'),('1771','37'),('1772','37'),('1773','37'),('1774','37'),('1775','37'),('1776','38'),('1777','38'),('1778','38'),('1779','38'),('1780','38'),('1781','38'),('1782','38'),('1783','38'),('1784','38'),('1785','38'),('1786','39'),('1787','39'),('1788','39'),('1789','39'),('1790','39'),('1791','39'),('1792','39'),('1793','39'),('1794','39'),('1795','39'),('1796','40'),('1797','40'),('1798','40'),('1799','40'),('1800','40'),('1801','40'),('1802','40'),('1803','40'),('1804','40'),('1805','40'),('1806','41'),('1807','41'),('1808','41'),('1809','41'),('1810','41'),('1811','41'),('1812','41'),('1813','41'),('1814','41'),('1815','41'),('1816','42'),('1817','42'),('1818','42'),('1819','42'),('1820','42'),('1821','42'),('1822','42'),('1823','42'),('1824','42'),('1825','42'),('1826','43'),('1827','43'),('1828','43'),('1829','43'),('1830','43'),('1831','43'),('1832','43'),('1833','43'),('1834','43'),('1835','43'),('1836','44'),('1837','44'),('1838','44'),('1839','44'),('1840','44'),('1841','44'),('1842','44'),('1843','44'),('1844','44'),('1845','44'),('1846','45'),('1847','45'),('1848','45'),('1849','45'),('1850','45'),('1851','45'),('1852','45'),('1853','45'),('1854','45'),('1855','45'),('1856','46'),('1857','46'),('1858','46'),('1859','46'),('1860','46'),('1861','46'),('1862','46'),('1863','46'),('1864','46'),('1865','46'),('1866','47'),('1867','47'),('1868','47'),('1869','47'),('1870','47'),('1871','47'),('1872','47'),('1873','47'),('1874','47'),('1875','47'),('1876','48'),('1877','48'),('1878','48'),('1879','48'),('1880','48'),('1881','48'),('1882','48'),('1883','48'),('1884','48'),('1885','48'),('1886','49'),('1887','49'),('1888','49'),('1889','49'),('1890','49'),('1891','49'),('1892','49'),('1893','49'),('1894','49'),('1895','49'),('1896','50'),('1897','50'),('1898','50'),('1899','50'),('1900','50'),('1901','50'),('1902','50'),('1903','50'),('1904','50'),('1905','50'),('1906','51'),('1907','51'),('1908','51'),('1909','51'),('1910','51'),('1911','51'),('1912','51'),('1913','51'),('1914','51'),('1915','51'),('1916','52'),('1917','52'),('1918','52'),('1919','52'),('1920','52'),('1921','52'),('1922','52'),('1923','52'),('1924','52'),('1925','52'),('1926','53'),('1927','53'),('1928','53'),('1929','53'),('1930','53'),('1931','53'),('1932','53'),('1933','53'),('1934','53'),('1935','53'),('1936','54'),('1937','54'),('1938','54'),('1939','54'),('1940','54'),('1941','54'),('1942','54'),('1943','54'),('1944','54'),('1945','54'),('1946','55'),('1947','55'),('1948','55'),('1949','55'),('1950','55'),('1951','55'),('1952','55'),('1953','55'),('1954','55'),('1955','55'),('1956','58'),('1957','58'),('1958','58'),('1959','58'),('1960','58'),('1961','58'),('1962','58'),('1963','58'),('1964','58'),('1965','58'),('1966','59'),('1967','59'),('1968','59'),('1969','59'),('1970','59'),('1971','59'),('1972','59'),('1973','59'),('1974','59'),('1975','59'),('1976','60'),('1977','60'),('1978','60'),('1979','60'),('1980','60'),('1981','60'),('1982','60'),('1983','60'),('1984','60'),('1985','60'),('1986','61'),('1987','61'),('1988','61'),('1989','61'),('1990','61'),('1991','61'),('1992','61'),('1993','61'),('1994','61'),('1995','61'),('1996','62'),('1997','62'),('1998','62'),('1999','62'),('2000','62'),('2001','62'),('2002','62'),('2003','62'),('2004','62'),('2005','62'),('2006','63'),('2007','63'),('2008','63'),('2009','63'),('2010','63'),('2011','63'),('2012','63'),('2013','63'),('2014','63'),('2015','63'),('2016','64'),('2017','64'),('2018','64'),('2019','64'),('2020','64'),('2021','64'),('2022','64'),('2023','64'),('2024','64'),('2025','64'),('2026','65'),('2027','65'),('2028','65'),('2029','65'),('2030','65'),('2031','65'),('2032','65'),('2033','65'),('2034','65'),('2035','65'),('2036','66'),('2037','66'),('2038','66'),('2039','66'),('2040','66'),('2041','66'),('2042','66'),('2043','66'),('2044','66'),('2045','66'),('2046','67'),('2047','67'),('2048','67'),('2049','67'),('2050','67'),('2051','67'),('2052','67'),('2053','67'),('2054','67'),('2055','67'),('2056','68'),('2057','68'),('2058','68'),('2059','68'),('2060','68'),('2061','68'),('2062','68'),('2063','68'),('2064','68'),('2065','68'),('2066','69'),('2067','69'),('2068','69'),('2069','69'),('2070','69'),('2071','69'),('2072','69'),('2073','69'),('2074','69'),('2075','69'),('2076','70'),('2077','70'),('2078','70'),('2079','70'),('2080','70'),('2081','70'),('2082','70'),('2083','70'),('2084','70'),('2085','70'),('2086','71'),('2087','71'),('2088','71'),('2089','71'),('2090','71'),('2091','71'),('2092','71'),('2093','71'),('2094','71'),('2095','71'),('2096','72'),('2097','72'),('2098','72'),('2099','72'),('2100','72'),('2101','72'),('2102','72'),('2103','72'),('2104','72'),('2105','72'),('2106','73'),('2107','73'),('2108','73'),('2109','73'),('2110','73'),('2111','73'),('2112','73'),('2113','73'),('2114','73'),('2115','73'),('2116','74'),('2117','74'),('2118','74'),('2119','74'),('2120','74'),('2121','74'),('2122','74'),('2123','74'),('2124','74'),('2125','74'),('2126','75'),('2127','75'),('2128','75'),('2129','75'),('2130','75'),('2131','75'),('2132','75'),('2133','75'),('2134','75'),('2135','75'),('2136','76'),('2137','76'),('2138','76'),('2139','76'),('2140','76'),('2141','76'),('2142','76'),('2143','76'),('2144','77'),('2145','77'),('2146','77'),('2147','77'),('2148','77'),('2149','77'),('2150','77'),('2151','77'),('2152','77'),('2153','78'),('2154','78'),('2155','78'),('2156','78'),('2157','78'),('2158','78'),('2159','78'),('2160','78'),('2161','78'),('2162','79'),('2163','79'),('2164','79'),('2165','79'),('2166','79'),('2167','79'),('2168','79'),('2169','79'),('2170','79'),('2171','80'),('2172','80'),('2173','80'),('2174','80'),('2175','80'),('2176','80'),('2177','80'),('2178','80'),('2179','80'),('2180','81'),('2181','81'),('2182','81'),('2183','81'),('2184','81'),('2185','81'),('2186','81'),('2187','81'),('2188','81'),('2189','82'),('2190','82'),('2191','82'),('2192','82'),('2193','82'),('2194','82'),('2195','82'),('2196','82'),('2197','82'),('2198','83'),('2199','83'),('2200','83'),('2201','83'),('2202','83'),('2203','83'),('2204','83'),('2205','83'),('2206','83'),('2207','84'),('2208','84'),('2209','84'),('2210','84'),('2211','84'),('2212','84'),('2213','84'),('2214','84'),('2215','84'),('2216','85'),('2217','85'),('2218','85'),('2219','85'),('2220','85'),('2221','85'),('2222','85'),('2223','85'),('2224','85'),('2225','86'),('2226','86'),('2227','86'),('2228','86'),('2229','86'),('2230','86'),('2231','86'),('2232','86'),('2233','86'),('2234','87'),('2235','87'),('2236','87'),('2237','87'),('2238','87'),('2239','87'),('2240','87'),('2241','87'),('2242','87'),('2243','88'),('2244','88'),('2245','88'),('2246','88'),('2247','88'),('2248','88'),('2249','88'),('2250','88'),('2251','88'),('2252','89'),('2253','89'),('2254','89'),('2255','89'),('2256','89'),('2257','89'),('2258','89'),('2259','89'),('2260','89'),('2261','90'),('2262','90'),('2263','90'),('2264','90'),('2265','90'),('2266','90'),('2267','90'),('2268','90'),('2269','90'),('2270','91'),('2271','91'),('2272','91'),('2273','91'),('2274','91'),('2275','91'),('2276','91'),('2277','91'),('2278','91'),('2279','92'),('2280','92'),('2281','92'),('2282','92'),('2283','92'),('2284','92'),('2285','92'),('2286','92'),('2287','92'),('2288','93'),('2289','93'),('2290','93'),('2291','93'),('2292','93'),('2293','93'),('2294','93'),('2295','93'),('2296','93'),('2297','94'),('2298','94'),('2299','94'),('2300','94'),('2301','94'),('2302','94'),('2303','94'),('2304','94'),('2305','94'),('2306','95'),('2307','95'),('2308','95'),('2309','95'),('2310','95'),('2311','95'),('2312','95'),('2313','95'),('2314','95'),('2315','96'),('2316','96'),('2317','96'),('2318','96'),('2319','96'),('2320','96'),('2321','96'),('2322','96'),('2323','96'),('2324','97'),('2325','97'),('2326','97'),('2327','97'),('2328','97'),('2329','97'),('2330','97'),('2331','97'),('2332','97'),('2333','98'),('2334','98'),('2335','98'),('2336','98'),('2337','98'),('2338','98'),('2339','98'),('2340','98'),('2341','98'),('2342','99'),('2343','99'),('2344','99'),('2345','99'),('2346','99'),('2347','99'),('2348','99'),('2349','99'),('2350','99'),('2351','100'),('2352','100'),('2353','100'),('2354','100'),('2355','100'),('2356','100'),('2357','100'),('2358','100'),('2359','100'),('2360','101'),('2361','101'),('2362','101'),('2363','101'),('2364','101'),('2365','101'),('2366','101'),('2367','101'),('2368','101'),('2369','102'),('2370','102'),('2371','102'),('2372','102'),('2373','102'),('2374','102'),('2375','102'),('2376','102'),('2377','102'),('2378','103'),('2379','103'),('2380','103'),('2381','103'),('2382','103'),('2383','103'),('2384','103'),('2385','103'),('2386','103'),('2387','104'),('2388','104'),('2389','104'),('2390','104'),('2391','104'),('2392','104'),('2393','104'),('2394','104'),('2395','104'),('2396','105'),('2397','105'),('2398','105'),('2399','105'),('2400','105'),('2401','105'),('2402','105'),('2403','105'),('2404','105'),('2405','106'),('2406','106'),('2407','106'),('2408','106'),('2409','106'),('2410','106'),('2411','106'),('2412','106'),('2413','106'),('2414','107'),('2415','107'),('2416','107'),('2417','107'),('2418','107'),('2419','107'),('2420','107'),('2421','107'),('2422','107'),('2423','108'),('2424','108'),('2425','108'),('2426','108'),('2427','108'),('2428','108'),('2429','108'),('2430','108'),('2431','108'),('2432','109'),('2433','109'),('2434','109'),('2435','109'),('2436','109'),('2437','109'),('2438','109'),('2439','109'),('2440','109'),('2441','109'),('2442','109'),('2443','109'),('2444','109'),('2445','109'),('2446','109'),('2447','109'),('2448','109'),('2449','109'),('2450','109'),('2451','109'),('2452','110'),('2453','110'),('2454','110'),('2455','110'),('2456','110'),('2457','110'),('2458','110'),('2459','110'),('2460','110'),('2461','111'),('2462','111'),('2463','111'),('2464','111'),('2465','111'),('2466','111'),('2467','111'),('2468','111'),('2469','111'),('2470','112'),('2471','112'),('2472','112'),('2473','112'),('2474','112'),('2475','112'),('2476','112'),('2477','112'),('2478','112'),('2479','113'),('2480','113'),('2481','113'),('2482','113'),('2483','113'),('2484','113'),('2485','113'),('2486','113'),('2487','113'),('2488','114'),('2489','114'),('2490','114'),('2491','114'),('2492','114'),('2493','114'),('2494','114'),('2495','114'),('2496','114'),('2497','115'),('2498','115'),('2499','115'),('2500','115'),('2501','115'),('2502','115'),('2503','115'),('2504','115'),('2505','115'),('2506','116'),('2507','116'),('2508','116'),('2509','116'),('2510','116'),('2511','116'),('2512','116'),('2513','116'),('2514','116'),('2515','117'),('2516','117'),('2517','117'),('2518','117'),('2519','117'),('2520','117'),('2521','117'),('2522','117'),('2523','117'),('2524','118'),('2525','118'),('2526','118'),('2527','118'),('2528','118'),('2529','118'),('2530','118'),('2531','118'),('2532','118'),('2533','119'),('2534','119'),('2535','119'),('2536','119'),('2537','119'),('2538','119'),('2539','119'),('2540','119'),('2541','119'),('2542','120'),('2543','120'),('2544','120'),('2545','120'),('2546','120'),('2547','120'),('2548','120'),('2549','120'),('2550','120'),('2551','121'),('2552','121'),('2553','121'),('2554','121'),('2555','121'),('2556','121'),('2557','121'),('2558','121'),('2559','121'),('2560','122'),('2561','122'),('2562','122'),('2563','122'),('2564','122'),('2565','122'),('2566','122'),('2567','122'),('2568','122'),('2569','123'),('2570','123'),('2571','123'),('2572','123'),('2573','123'),('2574','123'),('2575','123'),('2576','123'),('2577','123'),('2578','124'),('2579','124'),('2580','124'),('2581','124'),('2582','124'),('2583','124'),('2584','124'),('2585','124'),('2586','124'),('2587','125'),('2588','125'),('2589','125'),('2590','125'),('2591','125'),('2592','125'),('2593','125'),('2594','125'),('2595','125'),('2596','126'),('2597','126'),('2598','126'),('2599','126'),('2600','126'),('2601','126'),('2602','126'),('2603','126'),('2604','126'),('2605','127'),('2606','127'),('2607','127'),('2608','127'),('2609','127'),('2610','127'),('2611','127'),('2612','127'),('2613','127'),('2614','128'),('2615','128'),('2616','128'),('2617','128'),('2618','128'),('2619','128'),('2620','128'),('2621','128'),('2622','128'),('2623','129'),('2624','129'),('2625','129'),('2626','129'),('2627','129'),('2628','129'),('2629','129'),('2630','129'),('2631','129'),('2632','130'),('2633','130'),('2634','130'),('2635','130'),('2636','130'),('2637','130'),('2638','130'),('2639','130'),('2640','130'),('2641','131'),('2642','131'),('2643','131'),('2644','131'),('2645','131'),('2646','131'),('2647','131'),('2648','131'),('2649','131'),('2650','132'),('2651','132'),('2652','132'),('2653','132'),('2654','132'),('2655','132'),('2656','132'),('2657','132'),('2658','132'),('2659','133'),('2660','133'),('2661','133'),('2662','133'),('2663','133'),('2664','133'),('2665','133'),('2666','133'),('2667','133'),('2668','134'),('2669','134'),('2670','134'),('2671','134'),('2672','134'),('2673','134'),('2674','134'),('2675','134'),('2676','134'),('2677','135'),('2678','135'),('2679','135'),('2680','135'),('2681','135'),('2682','135'),('2683','135'),('2684','135'),('2685','135'),('2686','136'),('2687','136'),('2688','136'),('2689','136'),('2690','136'),('2691','136'),('2692','136'),('2693','136'),('2694','136'),('2695','137'),('2696','137'),('2697','137'),('2698','137'),('2699','137'),('2700','137'),('2701','137'),('2702','137'),('2703','137'),('2704','138'),('2705','138'),('2706','138'),('2707','138'),('2708','138'),('2709','138'),('2710','138'),('2711','138'),('2712','138'),('2713','139'),('2714','139'),('2715','139'),('2716','139'),('2717','139'),('2718','139'),('2719','139'),('2720','139'),('2721','139'),('2722','140'),('2723','140'),('2724','140'),('2725','140'),('2726','140'),('2727','140'),('2728','140'),('2729','140'),('2730','140'),('2731','141'),('2732','141'),('2733','141'),('2734','141'),('2735','141'),('2736','141'),('2737','141'),('2738','141'),('2739','141'),('2740','142'),('2741','142'),('2742','142'),('2743','142'),('2744','142'),('2745','142'),('2746','142'),('2747','142'),('2748','142'),('2749','143'),('2750','143'),('2751','143'),('2752','143'),('2753','143'),('2754','143'),('2755','143'),('2756','143'),('2757','143'),('2758','144'),('2759','144'),('2760','144'),('2761','144'),('2762','144'),('2763','144'),('2764','144'),('2765','144'),('2766','144'),('2767','145'),('2768','145'),('2769','145'),('2770','145'),('2771','145'),('2772','145'),('2773','145'),('2774','145'),('2775','145'),('2776','146'),('2777','146'),('2778','146'),('2779','146'),('2780','146'),('2781','146'),('2782','146'),('2783','146'),('2784','146'),('2785','147'),('2786','147'),('2787','147'),('2788','147'),('2789','147'),('2790','147'),('2791','147'),('2792','147'),('2793','147'),('2794','148'),('2795','148'),('2796','148'),('2797','148'),('2798','148'),('2799','148'),('2800','148'),('2801','148'),('2802','148'),('2803','149'),('2804','149'),('2805','149'),('2806','149'),('2807','149'),('2808','149'),('2809','149'),('2810','149'),('2811','149'),('2812','150'),('2813','150'),('2814','150'),('2815','150'),('2816','150'),('2817','150'),('2818','150'),('2819','150'),('2820','150'),('2821','151'),('2822','151'),('2823','151'),('2824','151'),('2825','151'),('2826','151'),('2827','151'),('2828','151'),('2829','151'),('2830','152'),('2831','152'),('2832','152'),('2833','152'),('2834','152'),('2835','152'),('2836','152'),('2837','152'),('2838','152'),('2839','153'),('2840','153'),('2841','153'),('2842','153'),('2843','153'),('2844','153'),('2845','153'),('2846','153'),('2847','153'),('2848','154'),('2849','154'),('2850','154'),('2851','154'),('2852','154'),('2853','154'),('2854','154'),('2855','154'),('2856','154'),('2857','155'),('2858','155'),('2859','155'),('2860','155'),('2861','155'),('2862','155'),('2863','155'),('2864','155'),('2865','155'),('2866','156'),('2867','156'),('2868','156'),('2869','156'),('2870','156'),('2871','156'),('2872','156'),('2873','156'),('2874','156'),('2875','157');
INSERT INTO `catalog_product_category_cl` VALUES ('2876','157'),('2877','157'),('2878','157'),('2879','157'),('2880','157'),('2881','157'),('2882','157'),('2883','157'),('2884','158'),('2885','158'),('2886','158'),('2887','158'),('2888','158'),('2889','158'),('2890','158'),('2891','158'),('2892','158'),('2893','159'),('2894','159'),('2895','159'),('2896','159'),('2897','159'),('2898','159'),('2899','159'),('2900','159'),('2901','159'),('2902','160'),('2903','160'),('2904','160'),('2905','160'),('2906','160'),('2907','160'),('2908','160'),('2909','160'),('2910','160'),('2911','161'),('2912','161'),('2913','161'),('2914','161'),('2915','161'),('2916','161'),('2917','161'),('2918','161'),('2919','161'),('2920','162'),('2921','162'),('2922','162'),('2923','162'),('2924','162'),('2925','162'),('2926','162'),('2927','162'),('2928','162'),('2929','163'),('2930','163'),('2931','163'),('2932','163'),('2933','163'),('2934','163'),('2935','163'),('2936','163'),('2937','163'),('2938','164'),('2939','164'),('2940','164'),('2941','164'),('2942','164'),('2943','164'),('2944','164'),('2945','164'),('2946','164'),('2977','169'),('2978','169'),('2979','169'),('2980','169'),('2981','169'),('2982','169'),('2983','169'),('2984','169'),('2985','169'),('2986','170'),('2987','170'),('2988','170'),('2989','170'),('2990','170'),('2991','170'),('2992','170'),('2993','170'),('2994','170'),('2995','171'),('2996','171'),('2997','171'),('2998','171'),('2999','171'),('3000','171'),('3001','171'),('3002','171'),('3003','171'),('3004','172'),('3005','172'),('3006','172'),('3007','172'),('3008','172'),('3009','172'),('3010','172'),('3011','172'),('3012','172'),('3013','173'),('3014','173'),('3015','173'),('3016','173'),('3017','173'),('3018','173'),('3019','173'),('3020','173'),('3021','173'),('3022','174'),('3023','174'),('3024','174'),('3025','174'),('3026','174'),('3027','174'),('3028','174'),('3029','174'),('3030','174'),('3031','175'),('3032','175'),('3033','175'),('3034','175'),('3035','175'),('3036','175'),('3037','175'),('3038','175'),('3039','175'),('3040','176'),('3041','176'),('3042','176'),('3043','176'),('3044','176'),('3045','176'),('3046','176'),('3047','176'),('3048','176'),('3049','177'),('3050','177'),('3051','177'),('3052','177'),('3053','177'),('3054','177'),('3055','177'),('3056','177'),('3057','177'),('3058','178'),('3059','178'),('3060','178'),('3061','178'),('3062','178'),('3063','178'),('3064','178'),('3065','178'),('3066','178'),('3067','179'),('3068','179'),('3069','179'),('3070','179'),('3071','179'),('3072','179'),('3073','179'),('3074','179'),('3075','179'),('3076','180'),('3077','180'),('3078','180'),('3079','180'),('3080','180'),('3081','180'),('3082','180'),('3083','180'),('3084','180'),('3085','181'),('3086','181'),('3087','181'),('3088','181'),('3089','181'),('3090','181'),('3091','181'),('3092','181'),('3093','181'),('3094','182'),('3095','182'),('3096','182'),('3097','182'),('3098','182'),('3099','182'),('3100','182'),('3101','182'),('3102','182'),('3103','183'),('3104','183'),('3105','183'),('3106','183'),('3107','183'),('3108','183'),('3109','183'),('3110','183'),('3111','183'),('3112','19'),('3113','19'),('3114','19'),('3115','19'),('3116','19'),('3117','19'),('3118','19'),('3119','19'),('3120','19'),('3121','19'),('3122','19'),('3123','19'),('3124','19'),('3125','19'),('3126','19'),('3127','19'),('3128','19'),('3129','19'),('3130','19'),('3131','19'),('3132','20'),('3133','20'),('3134','20'),('3135','20'),('3136','20'),('3137','20'),('3138','20'),('3139','20'),('3140','20'),('3141','20'),('3142','1'),('3143','1'),('3144','1'),('3145','1'),('3146','1'),('3147','1'),('3148','1'),('3149','1'),('3150','1'),('3151','1'),('3152','4'),('3153','4'),('3154','4'),('3155','4'),('3156','4'),('3157','4'),('3158','4'),('3159','4'),('3160','4'),('3161','4'),('3162','4'),('3163','4'),('3164','4'),('3165','4'),('3166','4'),('3167','4'),('3168','4'),('3169','4'),('3170','4'),('3171','4'),('3172','4');
/*!40000 ALTER TABLE `catalog_product_category_cl` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_entity`
--

DROP TABLE IF EXISTS `catalog_product_entity`;
CREATE TABLE `catalog_product_entity` (
  `entity_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Entity ID',
  `attribute_set_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute Set ID',
  `type_id` varchar(32) NOT NULL DEFAULT 'simple' COMMENT 'Type ID',
  `sku` varchar(64) DEFAULT NULL COMMENT 'SKU',
  `has_options` smallint(6) NOT NULL DEFAULT '0' COMMENT 'Has Options',
  `required_options` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Required Options',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Creation Time',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Update Time',
  PRIMARY KEY (`entity_id`),
  KEY `CATALOG_PRODUCT_ENTITY_ATTRIBUTE_SET_ID` (`attribute_set_id`),
  KEY `CATALOG_PRODUCT_ENTITY_SKU` (`sku`)
) ENGINE=InnoDB AUTO_INCREMENT=186 DEFAULT CHARSET=utf8 COMMENT='Catalog Product Table';

--
-- Dumping data for table `catalog_product_entity`
--

LOCK TABLES `catalog_product_entity` WRITE;
/*!40000 ALTER TABLE `catalog_product_entity` DISABLE KEYS */;
INSERT INTO `catalog_product_entity` VALUES ('76',4,'simple','20JW0005US',0,0,'2018-09-17 15:34:50','2018-10-17 13:28:44'),('77',4,'simple','20KS003LUS',0,0,'2018-09-17 15:44:17','2018-09-18 14:35:47'),('78',4,'simple','20KS003WUS',0,0,'2018-09-17 16:03:28','2018-09-18 14:38:36'),('79',4,'simple','80UD00V2US',0,0,'2018-09-17 16:18:44','2018-10-08 13:16:54'),('80',4,'simple','80XM0000US',0,0,'2018-09-18 14:33:24','2018-09-18 14:39:13'),('81',4,'simple','10KH0023US',0,0,'2018-09-18 15:05:48','2018-09-18 15:05:48'),('82',4,'simple','10KH003MUS',0,0,'2018-09-19 14:54:14','2018-09-19 15:29:52'),('83',4,'simple','10M7000SUS',0,0,'2018-09-19 15:35:27','2018-09-19 15:35:27'),('84',4,'simple','10M70031US',0,0,'2018-09-19 15:44:41','2018-09-19 15:44:41'),('85',4,'simple','10M9000TUS',0,0,'2018-09-19 15:50:24','2018-09-19 15:50:24'),('86',4,'simple','10NM000KUS',0,0,'2018-09-19 15:54:53','2018-09-19 15:56:15'),('87',4,'simple','90GV0000US',0,0,'2018-09-19 16:01:57','2018-10-08 13:15:20'),('88',4,'simple','F0D30002US',0,0,'2018-09-19 16:07:44','2018-10-08 13:12:05'),('89',4,'simple','F0D8001LUS',0,0,'2018-09-19 16:18:39','2018-09-19 16:24:04'),('90',4,'simple','11C0099',0,0,'2018-09-19 16:29:11','2018-09-19 16:29:11'),('91',4,'simple','28C0050',0,0,'2018-09-19 16:35:33','2018-09-19 16:35:33'),('92',4,'simple','35S0060',0,0,'2018-09-19 18:53:05','2018-09-19 18:53:05'),('93',4,'simple','35S5700',0,0,'2018-09-19 18:58:49','2018-09-19 18:58:49'),('94',4,'simple','35S6702',0,0,'2018-09-19 19:08:20','2018-09-19 19:13:46'),('95',4,'simple','C11C558001',0,0,'2018-09-19 19:32:08','2018-10-12 16:40:12'),('96',4,'simple','C11CC24001',0,0,'2018-09-19 19:44:46','2018-09-19 19:44:46'),('97',4,'simple','C5F93A#BGJ',0,0,'2018-09-19 19:55:14','2018-09-19 19:55:14'),('98',4,'simple','C5J91A#BGJ',0,0,'2018-09-20 12:37:06','2018-09-20 12:37:06'),('99',4,'simple','CE711A#BGJ',0,0,'2018-09-20 12:49:15','2018-09-20 12:49:15'),('100',4,'simple','CF394A#BGJ',0,0,'2018-09-20 12:53:42','2018-09-20 12:53:42'),('101',4,'simple','CF456A#BGJ',0,0,'2018-09-20 12:58:57','2018-09-20 12:58:57'),('102',4,'simple','CR768A#AKY',0,0,'2018-09-20 13:19:18','2018-09-20 13:19:18'),('103',4,'simple','CZ181A#BGJ',0,0,'2018-09-20 13:33:11','2018-09-20 13:33:11'),('104',4,'simple','F5S29A#AKY',0,0,'2018-09-20 13:39:07','2018-10-08 13:21:08'),('105',4,'simple','G3Q35A#BGJ',0,0,'2018-09-20 13:42:55','2018-09-20 13:42:55'),('106',4,'simple','G3Q47A#BGJ',0,0,'2018-09-20 13:46:47','2018-09-20 13:46:47'),('107',4,'simple','G5J38A#AKY',0,0,'2018-09-20 13:48:51','2018-09-20 13:48:51'),('108',4,'simple','191454',0,0,'2018-09-20 14:13:51','2018-09-20 14:19:42'),('109',4,'simple','191511',0,0,'2018-09-20 14:13:52','2018-09-20 14:21:33'),('110',4,'simple','T6B74A#BGJ',0,0,'2018-09-20 14:30:46','2018-09-20 14:30:46'),('111',4,'simple','V1N01A#B1H',0,0,'2018-09-20 14:41:11','2018-09-20 14:41:11'),('112',4,'simple','201021',0,0,'2018-09-20 15:07:24','2018-09-20 15:07:24'),('113',4,'simple','201022',0,0,'2018-09-20 15:13:09','2018-09-20 15:13:09'),('114',4,'simple','205002',0,0,'2018-09-20 15:20:34','2018-09-20 15:20:34'),('115',4,'simple','301001',0,0,'2018-09-20 15:34:00','2018-09-20 15:34:00'),('116',4,'simple','516113',0,0,'2018-09-20 15:41:21','2018-09-20 15:41:21'),('117',4,'simple','516208',0,0,'2018-09-20 15:58:22','2018-09-20 15:58:22'),('118',4,'simple','516210',0,0,'2018-09-20 16:09:10','2018-09-20 16:09:10'),('119',4,'simple','652519',0,0,'2018-09-20 16:19:25','2018-09-20 16:19:25'),('120',4,'simple','951027',0,0,'2018-09-20 16:24:12','2018-09-20 16:24:12'),('121',4,'simple','978301',0,0,'2018-09-20 16:32:41','2018-09-20 16:32:41'),('122',4,'simple','AW220NXT82',0,0,'2018-09-20 16:46:39','2018-09-20 16:46:39'),('123',4,'simple','AW221NXT01',0,0,'2018-09-20 16:51:02','2018-09-20 16:54:03'),('124',4,'simple','PCRWESKD12U55BK',0,0,'2018-09-20 16:56:08','2018-09-20 16:56:08'),('125',4,'simple','SR1UBRUSH',0,0,'2018-09-20 17:01:15','2018-09-20 17:01:15'),('126',4,'simple','MGBBX1',0,0,'2018-09-20 17:06:19','2018-09-20 17:06:19'),('127',4,'simple','SF300-24PP-K9-NA',0,0,'2018-09-20 17:10:36','2018-09-20 17:10:36'),('128',4,'simple','SLM2008T-NA',0,0,'2018-09-20 17:13:51','2018-09-20 17:13:51'),('129',4,'simple','SLM2024T-NA',0,0,'2018-09-20 18:11:33','2018-09-20 18:11:33'),('130',4,'simple','SLM224PT-NA',0,0,'2018-09-20 18:22:47','2018-09-20 18:22:47'),('131',4,'simple','SLM248PT-NA',0,0,'2018-09-20 18:31:57','2018-09-20 18:31:57'),('132',4,'simple','SRW224G4-K9-NA',0,0,'2018-09-20 19:57:29','2018-09-20 19:57:29'),('133',4,'simple','TE100-S24G',0,0,'2018-09-20 20:04:27','2018-09-20 20:04:27'),('134',4,'simple','TE100-S5',0,0,'2018-09-20 20:14:14','2018-09-20 20:21:33'),('135',4,'simple','TE100-S8',0,0,'2018-09-20 20:20:47','2018-09-20 20:20:47'),('136',4,'simple','TEG-S24D',0,0,'2018-09-20 20:27:28','2018-09-20 20:27:28'),('137',4,'simple','TEG-S80G',0,0,'2018-09-20 21:45:31','2018-10-08 13:29:16'),('138',4,'simple','TPE-S44',0,0,'2018-09-20 21:53:20','2018-10-08 13:19:22'),('139',4,'simple','TPE-TG240G',0,0,'2018-09-20 22:01:22','2018-09-20 22:01:22'),('140',4,'simple','WS-C2960X-24TS-L',0,0,'2018-09-20 22:05:57','2018-09-20 22:14:13'),('141',4,'simple','WS-C2960X-48TS-L',0,0,'2018-09-20 22:09:54','2018-09-20 22:16:13'),('142',4,'simple','60DFAAR1US',0,0,'2018-09-20 22:25:13','2018-09-20 22:25:13'),('143',4,'simple','60G1MAR2US',0,0,'2018-09-20 22:29:09','2018-09-20 22:29:09'),('144',4,'simple','61A9MAR1US',0,0,'2018-09-20 22:34:33','2018-09-20 22:34:33'),('145',4,'simple','65D2GCC3US',0,0,'2018-09-20 22:42:08','2018-09-20 22:43:42'),('146',4,'simple','65DAKCC3US',0,0,'2018-09-21 00:20:32','2018-09-21 00:20:32'),('147',4,'simple','41U5062',0,0,'2018-09-21 00:23:36','2018-09-21 00:23:36'),('148',4,'simple','4X40E77325',0,0,'2018-09-21 00:31:50','2018-09-21 00:31:50'),('149',4,'simple','4X40E77328',0,0,'2018-09-21 00:34:46','2018-10-08 13:23:05'),('150',4,'simple','4X40E77329',0,0,'2018-09-21 00:37:45','2018-09-21 00:37:45'),('151',4,'simple','4X40E77337',0,0,'2018-09-21 00:40:59','2018-09-21 00:40:59'),('152',4,'simple','VNCI-215',0,0,'2018-09-21 00:49:39','2018-09-21 00:49:39'),('153',4,'simple','VNCI-217',0,0,'2018-09-21 00:53:24','2018-09-21 00:53:24'),('154',4,'simple','115481',0,0,'2018-09-21 01:01:34','2018-09-21 01:01:34'),('155',4,'simple','CD330S',0,0,'2018-09-21 01:07:16','2018-09-21 01:07:16'),('156',4,'simple','CD415',0,0,'2018-09-21 01:11:51','2018-09-21 01:11:51'),('157',4,'simple','LDX1000UP',0,0,'2018-09-21 01:14:34','2018-09-21 01:15:31'),('158',4,'simple','LR2000',0,0,'2018-09-21 01:17:58','2018-09-21 01:17:58'),('159',4,'simple','LR2000E',0,0,'2018-09-21 01:23:20','2018-09-21 01:23:20'),('160',4,'simple','LV4000U',0,0,'2018-09-21 01:26:43','2018-09-21 01:26:43'),('161',4,'simple','MK7120-31A38',0,0,'2018-09-21 01:30:04','2018-09-21 01:30:04'),('162',4,'simple','MSR90',0,0,'2018-09-21 01:36:42','2018-09-21 01:36:42'),('163',4,'simple','S303D',0,0,'2018-09-21 01:40:52','2018-09-21 01:40:52'),('164',4,'simple','S500U',0,0,'2018-09-21 01:45:15','2018-09-21 01:45:15'),('169',4,'simple','SPR15505',0,0,'2018-09-21 02:24:26','2018-09-21 02:24:26'),('170',4,'simple','TMCT-10',0,0,'2018-09-21 02:30:30','2018-09-26 18:39:17'),('171',4,'simple','5E1200USB',0,0,'2018-09-21 02:36:47','2018-09-21 11:48:09'),('172',4,'simple','5E2200USB',0,0,'2018-09-21 02:43:04','2018-09-21 02:43:04'),('173',4,'simple','5S1500G',0,0,'2018-09-21 11:56:42','2018-09-21 11:56:42'),('174',4,'simple','BE425M',0,0,'2018-09-21 12:14:39','2018-09-21 12:14:39'),('175',4,'simple','BE600M1',0,0,'2018-09-21 12:25:26','2018-09-21 12:25:26'),('176',4,'simple','BR1000G',0,0,'2018-09-21 12:33:32','2018-09-21 12:33:32'),('177',4,'simple','BR1000MS',0,0,'2018-09-21 12:37:20','2018-09-21 12:37:20'),('178',4,'simple','BR1500MS',0,0,'2018-09-21 12:42:47','2018-09-21 12:42:47'),('179',4,'simple','APC BR700G 700VA 420w UPS',0,0,'2018-09-21 12:51:54','2018-09-21 12:51:54'),('180',4,'simple','FVR-1211B',0,0,'2018-09-21 12:56:03','2018-09-21 12:56:03'),('181',4,'simple','NT-1001',0,0,'2018-09-21 12:59:00','2018-09-21 12:59:44'),('182',4,'simple','NT-511',0,0,'2018-09-21 13:02:25','2018-09-21 13:02:25'),('183',4,'simple','SL-1011LCD',0,0,'2018-09-21 13:11:05','2018-10-08 13:25:17'),('184',4,'simple','ZA2T0000US',0,0,'2018-10-08 17:23:01','2018-10-08 17:41:38'),('185',4,'simple','10R0PAR1US',0,0,'2018-10-08 17:40:23','2018-10-15 16:45:19');
/*!40000 ALTER TABLE `catalog_product_entity` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_entity_datetime`
--

DROP TABLE IF EXISTS `catalog_product_entity_datetime`;
CREATE TABLE `catalog_product_entity_datetime` (
  `value_id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `attribute_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `value` datetime DEFAULT NULL COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `CATALOG_PRODUCT_ENTITY_DATETIME_ENTITY_ID_ATTRIBUTE_ID_STORE_ID` (`entity_id`,`attribute_id`,`store_id`),
  KEY `CATALOG_PRODUCT_ENTITY_DATETIME_ATTRIBUTE_ID` (`attribute_id`),
  KEY `CATALOG_PRODUCT_ENTITY_DATETIME_STORE_ID` (`store_id`)
) ENGINE=InnoDB AUTO_INCREMENT=138 DEFAULT CHARSET=utf8 COMMENT='Catalog Product Datetime Attribute Backend Table';

--
-- Dumping data for table `catalog_product_entity_datetime`
--

LOCK TABLES `catalog_product_entity_datetime` WRITE;
/*!40000 ALTER TABLE `catalog_product_entity_datetime` DISABLE KEYS */;
INSERT INTO `catalog_product_entity_datetime` VALUES ('114',94,13,'170','2018-09-26 00:00:00'),('115',94,1,'170','2018-09-26 00:00:00'),('116',94,2,'170','2018-09-26 00:00:00'),('117',94,3,'170','2018-09-26 00:00:00'),('118',95,13,'170','2018-09-30 00:00:00'),('119',95,1,'170','2018-09-30 00:00:00'),('120',95,2,'170','2018-09-30 00:00:00'),('121',95,3,'170','2018-09-30 00:00:00'),('122',79,13,'183','2018-09-26 00:00:00'),('123',79,1,'183','2018-09-26 00:00:00'),('124',79,2,'183','2018-09-26 00:00:00'),('125',79,3,'183','2018-09-26 00:00:00'),('126',79,13,'138','2018-10-08 00:00:00'),('127',79,1,'138','2018-10-08 00:00:00'),('128',79,2,'138','2018-10-08 00:00:00'),('129',79,3,'138','2018-10-08 00:00:00'),('130',79,13,'104','2018-10-08 00:00:00'),('131',79,1,'104','2018-10-08 00:00:00'),('132',79,2,'104','2018-10-08 00:00:00'),('133',79,3,'104','2018-10-08 00:00:00'),('134',79,13,'149','2018-10-08 00:00:00'),('135',79,1,'149','2018-10-08 00:00:00'),('136',79,2,'149','2018-10-08 00:00:00'),('137',79,3,'149','2018-10-08 00:00:00');
/*!40000 ALTER TABLE `catalog_product_entity_datetime` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_entity_decimal`
--

DROP TABLE IF EXISTS `catalog_product_entity_decimal`;
CREATE TABLE `catalog_product_entity_decimal` (
  `value_id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `attribute_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `value` decimal(12,4) DEFAULT NULL COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `CATALOG_PRODUCT_ENTITY_DECIMAL_ENTITY_ID_ATTRIBUTE_ID_STORE_ID` (`entity_id`,`attribute_id`,`store_id`),
  KEY `CATALOG_PRODUCT_ENTITY_DECIMAL_STORE_ID` (`store_id`),
  KEY `CATALOG_PRODUCT_ENTITY_DECIMAL_ATTRIBUTE_ID` (`attribute_id`)
) ENGINE=InnoDB AUTO_INCREMENT=275 DEFAULT CHARSET=utf8 COMMENT='Catalog Product Decimal Attribute Backend Table';

--
-- Dumping data for table `catalog_product_entity_decimal`
--

LOCK TABLES `catalog_product_entity_decimal` WRITE;
/*!40000 ALTER TABLE `catalog_product_entity_decimal` DISABLE KEYS */;
INSERT INTO `catalog_product_entity_decimal` VALUES ('124',77,0,'76','1467.0000'),('125',78,0,'76',NULL),('126',77,0,'77','1197.0000'),('127',78,0,'77',NULL),('128',77,0,'78','876.0000'),('129',77,0,'79','380.0000'),('130',77,0,'80','768.0000'),('131',78,0,'78',NULL),('132',78,0,'80',NULL),('133',77,0,'81','366.0000'),('134',77,0,'82','425.0000'),('135',78,0,'82',NULL),('136',77,0,'83','902.0000'),('137',77,0,'84','789.0000'),('138',77,0,'85','1179.0000'),('139',77,0,'86','743.0000'),('140',78,0,'86',NULL),('141',77,0,'87','514.0000'),('142',77,0,'88','777.0000'),('143',77,0,'89','551.0000'),('144',78,0,'89',NULL),('145',77,0,'90','457.1000'),('146',77,0,'91','428.6000'),('147',77,0,'92','171.4000'),('148',77,0,'93','300.0000'),('149',77,0,'94','1228.6000'),('150',78,0,'94',NULL),('151',77,0,'95','430.0000'),('152',78,0,'95',NULL),('153',77,0,'96','301.0000'),('154',77,0,'97','247.0000'),('155',77,0,'98','309.0000'),('156',77,0,'99','2300.0000'),('157',77,0,'100','580.0000'),('158',77,0,'101','100.0000'),('159',77,0,'102','185.0000'),('160',77,0,'103','279.0000'),('161',77,0,'104','75.0000'),('162',77,0,'105','141.0000'),('163',77,0,'106','200.0000'),('164',77,0,'107','297.0000'),('165',77,0,'108','45.7000'),('166',77,0,'109','33.0000'),('168',78,0,'109',NULL),('169',78,0,'108',NULL),('170',77,0,'110','421.0000'),('171',77,0,'111','79.0000'),('172',77,0,'112','25.0000'),('173',77,0,'113','35.0000'),('174',77,0,'114','7.5000'),('175',77,0,'115','20.0000'),('176',77,0,'116','119.4000'),('177',77,0,'117','45.0000'),('178',77,0,'118','100.0000'),('179',77,0,'119','12.9000'),('180',77,0,'120','1500.0000'),('181',77,0,'121','2015.0000'),('182',77,0,'122','25.0000'),('183',77,0,'123','195.0000'),('184',78,0,'123',NULL),('185',77,0,'124','324.0000'),('186',77,0,'125','65.0000'),('187',77,0,'126','358.0000'),('188',77,0,'127','629.0000'),('189',77,0,'128','126.0000'),('190',77,0,'129','342.0000'),('191',77,0,'130','404.0000'),('192',77,0,'131','726.0000'),('193',77,0,'132','326.0000'),('194',77,0,'133','78.0000'),('195',77,0,'134','17.0000'),('196',77,0,'135','26.0000'),('197',78,0,'134',NULL),('198',77,0,'136','133.0000'),('199',77,0,'137','49.0000'),('200',77,0,'138','78.0000'),('201',77,0,'139','618.0000'),('202',77,0,'140','1159.0000'),('203',77,0,'141','1730.0000'),('204',78,0,'140',NULL),('205',78,0,'141',NULL),('206',77,0,'142','155.0000'),('207',77,0,'143','224.0000'),('208',77,0,'144','252.0000'),('209',77,0,'145','268.0000'),('210',78,0,'145',NULL),('211',77,0,'146','249.0000'),('212',77,0,'147','61.0000'),('213',77,0,'148','63.0000'),('214',77,0,'149','45.0000'),('215',77,0,'150','60.0000'),('216',77,0,'151','50.0000'),('217',77,0,'152','38.0000'),('218',77,0,'153','53.0000'),('219',77,0,'154','268.0000'),('220',77,0,'155','65.0000'),('221',77,0,'156','74.0000'),('222',77,0,'157','99.0000'),('223',78,0,'157',NULL),('224',77,0,'158','150.0000'),('225',77,0,'159','160.0000'),('226',77,0,'160','310.0000'),('227',77,0,'161','252.0000'),('228',77,0,'162','24.0000'),('229',77,0,'163','223.0000'),('230',77,0,'164','141.0000'),('238',77,0,'169','42.0000'),('239',77,0,'170','107.0000'),('240',77,0,'171','164.0000'),('241',77,0,'172','239.0000'),('242',78,0,'171',NULL),('243',77,0,'173','215.0000'),('244',77,0,'174','62.0000'),('245',77,0,'175','68.0000'),('246',77,0,'176','185.0000'),('247',77,0,'177','185.0000'),('248',77,0,'178','258.0000'),('249',77,0,'179','136.0000'),('250',77,0,'180','20.0000'),('251',77,0,'181','79.0000'),('252',78,0,'181',NULL),('253',77,0,'182','50.0000'),('254',77,0,'183','140.0000'),('257',78,0,'137',NULL),('258',78,0,'170',NULL),('259',78,0,'183',NULL),('260',78,0,'87',NULL),('261',78,0,'79',NULL),('262',78,0,'88',NULL),('263',78,0,'138','74.0000'),('264',78,0,'104','70.0000'),('265',78,0,'149','42.0000'),('266',81,0,'149','48.0000'),('267',77,0,'184','376.0000'),('268',77,0,'185','341.0000'),('269',78,0,'184',NULL),('270',78,0,'185',NULL);
/*!40000 ALTER TABLE `catalog_product_entity_decimal` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_entity_gallery`
--

DROP TABLE IF EXISTS `catalog_product_entity_gallery`;
CREATE TABLE `catalog_product_entity_gallery` (
  `value_id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `attribute_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `position` int(11) NOT NULL DEFAULT '0' COMMENT 'Position',
  `value` varchar(255) DEFAULT NULL COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `CATALOG_PRODUCT_ENTITY_GALLERY_ENTITY_ID_ATTRIBUTE_ID_STORE_ID` (`entity_id`,`attribute_id`,`store_id`),
  KEY `CATALOG_PRODUCT_ENTITY_GALLERY_ENTITY_ID` (`entity_id`),
  KEY `CATALOG_PRODUCT_ENTITY_GALLERY_ATTRIBUTE_ID` (`attribute_id`),
  KEY `CATALOG_PRODUCT_ENTITY_GALLERY_STORE_ID` (`store_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Product Gallery Attribute Backend Table';

--
-- Table structure for table `catalog_product_entity_int`
--

DROP TABLE IF EXISTS `catalog_product_entity_int`;
CREATE TABLE `catalog_product_entity_int` (
  `value_id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `attribute_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `value` int(11) DEFAULT NULL COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `CATALOG_PRODUCT_ENTITY_INT_ENTITY_ID_ATTRIBUTE_ID_STORE_ID` (`entity_id`,`attribute_id`,`store_id`),
  KEY `CATALOG_PRODUCT_ENTITY_INT_ATTRIBUTE_ID` (`attribute_id`),
  KEY `CATALOG_PRODUCT_ENTITY_INT_STORE_ID` (`store_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2752 DEFAULT CHARSET=utf8 COMMENT='Catalog Product Integer Attribute Backend Table';

--
-- Dumping data for table `catalog_product_entity_int`
--

LOCK TABLES `catalog_product_entity_int` WRITE;
/*!40000 ALTER TABLE `catalog_product_entity_int` DISABLE KEYS */;
INSERT INTO `catalog_product_entity_int` VALUES ('1236',83,0,'76','9'),('1237',93,0,'76','4'),('1238',97,0,'76','1'),('1239',99,0,'76','4'),('1240',115,0,'76','1'),('1241',134,0,'76','0'),('1242',137,0,'76','0'),('1243',83,0,'77','9'),('1244',93,0,'77','4'),('1245',97,0,'77','1'),('1246',99,0,'77','4'),('1247',115,0,'77','1'),('1248',134,0,'77','0'),('1249',137,0,'77','0'),('1250',83,0,'78','9'),('1251',93,0,'78','4'),('1252',97,0,'78','1'),('1253',99,0,'78','4'),('1254',115,0,'78','1'),('1255',134,0,'78','0'),('1256',137,0,'78','0'),('1257',83,0,'79','9'),('1258',93,0,'79','4'),('1259',97,0,'79','1'),('1260',99,0,'79','4'),('1261',115,0,'79','1'),('1262',134,0,'79','0'),('1263',137,0,'79','1'),('1264',83,0,'80','9'),('1265',93,0,'80','4'),('1266',97,0,'80','1'),('1267',99,0,'80','4'),('1268',115,0,'80','1'),('1269',134,0,'80','0'),('1270',137,0,'80','0'),('1271',83,0,'81','9'),('1272',93,0,'81','4'),('1273',97,0,'81','1'),('1274',99,0,'81','4'),('1275',115,0,'81','1'),('1276',134,0,'81','0'),('1277',137,0,'81','0'),('1278',83,0,'82','9'),('1279',93,0,'82','4'),('1280',97,0,'82','1'),('1281',99,0,'82','4'),('1282',115,0,'82','1'),('1283',134,0,'82','0'),('1284',137,0,'82','0'),('1285',83,0,'83','9'),('1286',93,0,'83','4'),('1287',97,0,'83','1'),('1288',99,0,'83','4'),('1289',115,0,'83','1'),('1290',134,0,'83','0'),('1291',137,0,'83','0'),('1292',83,0,'84','9'),('1293',93,0,'84','4'),('1294',97,0,'84','1'),('1295',99,0,'84','4'),('1296',115,0,'84','1'),('1297',134,0,'84','0'),('1298',137,0,'84','0'),('1299',83,0,'85','9'),('1300',93,0,'85','4'),('1301',97,0,'85','1'),('1302',99,0,'85','4'),('1303',115,0,'85','1'),('1304',134,0,'85','0'),('1305',137,0,'85','0'),('1306',83,0,'86','9'),('1307',93,0,'86','4'),('1308',97,0,'86','1'),('1309',99,0,'86','4'),('1310',115,0,'86','1'),('1311',134,0,'86','0'),('1312',137,0,'86','0'),('1313',83,0,'87','9'),('1314',93,0,'87','4'),('1315',97,0,'87','1'),('1316',99,0,'87','4'),('1317',115,0,'87','1'),('1318',134,0,'87','0'),('1319',137,0,'87','1'),('1320',83,0,'88','9'),('1321',93,0,'88','4'),('1322',97,0,'88','1'),('1323',99,0,'88','4'),('1324',115,0,'88','1'),('1325',134,0,'88','0'),('1326',137,0,'88','1'),('1327',83,0,'89','9'),('1328',93,0,'89','4'),('1329',97,0,'89','1'),('1330',99,0,'89','4'),('1331',115,0,'89','1'),('1332',134,0,'89','0'),('1333',137,0,'89','0'),('1334',83,0,'90','9'),('1335',93,0,'90','4'),('1336',97,0,'90','1'),('1337',99,0,'90','4'),('1338',115,0,'90','1'),('1339',134,0,'90','0'),('1340',137,0,'90','0'),('1341',83,0,'91','9'),('1342',93,0,'91','4'),('1343',97,0,'91','1'),('1344',99,0,'91','4'),('1345',115,0,'91','1'),('1346',134,0,'91','0'),('1347',137,0,'91','0'),('1348',83,0,'92','9'),('1349',93,0,'92','4'),('1350',97,0,'92','1'),('1351',99,0,'92','4'),('1352',115,0,'92','1'),('1353',134,0,'92','0'),('1354',137,0,'92','0'),('1355',83,0,'93','9'),('1356',93,0,'93','4'),('1357',97,0,'93','1'),('1358',99,0,'93','4'),('1359',115,0,'93','1'),('1360',134,0,'93','0'),('1361',137,0,'93','0'),('1362',83,0,'94','9'),('1363',93,0,'94','4'),('1364',97,0,'94','1'),('1365',99,0,'94','4'),('1366',115,0,'94','1'),('1367',134,0,'94','0'),('1368',137,0,'94','0'),('1369',83,0,'95','9'),('1370',93,0,'95','4'),('1371',97,0,'95','1'),('1372',99,0,'95','4'),('1373',115,0,'95','1'),('1374',134,0,'95','0'),('1375',137,0,'95','0'),('1376',83,0,'96','9'),('1377',93,0,'96','4'),('1378',97,0,'96','1'),('1379',99,0,'96','4'),('1380',115,0,'96','1'),('1381',134,0,'96','0'),('1382',137,0,'96','0'),('1383',83,0,'97','9'),('1384',93,0,'97','4'),('1385',97,0,'97','1'),('1386',99,0,'97','4'),('1387',115,0,'97','1'),('1388',134,0,'97','0'),('1389',137,0,'97','0'),('1390',83,0,'98','9'),('1391',93,0,'98','4'),('1392',97,0,'98','1'),('1393',99,0,'98','4'),('1394',115,0,'98','1'),('1395',134,0,'98','0'),('1396',137,0,'98','0'),('1397',83,0,'99','9'),('1398',93,0,'99','4'),('1399',97,0,'99','1'),('1400',99,0,'99','4'),('1401',115,0,'99','1'),('1402',134,0,'99','0'),('1403',137,0,'99','0'),('1404',83,0,'100','9'),('1405',93,0,'100','4'),('1406',97,0,'100','1'),('1407',99,0,'100','4'),('1408',115,0,'100','1'),('1409',134,0,'100','0'),('1410',137,0,'100','0'),('1411',83,0,'101','9'),('1412',93,0,'101','4'),('1413',97,0,'101','1'),('1414',99,0,'101','4'),('1415',115,0,'101','1'),('1416',134,0,'101','0'),('1417',137,0,'101','0'),('1418',83,0,'102','9'),('1419',93,0,'102','4'),('1420',97,0,'102','1'),('1421',99,0,'102','4'),('1422',115,0,'102','1'),('1423',134,0,'102','0'),('1424',137,0,'102','0'),('1425',83,0,'103','9'),('1426',93,0,'103','4'),('1427',97,0,'103','1'),('1428',99,0,'103','4'),('1429',115,0,'103','1'),('1430',134,0,'103','0'),('1431',137,0,'103','0'),('1432',83,0,'104','9'),('1433',93,0,'104','4'),('1434',97,0,'104','1'),('1435',99,0,'104','4'),('1436',115,0,'104','1'),('1437',134,0,'104','0'),('1438',137,0,'104','0'),('1439',83,0,'105','9'),('1440',93,0,'105','4'),('1441',97,0,'105','1'),('1442',99,0,'105','4'),('1443',115,0,'105','1'),('1444',134,0,'105','0'),('1445',137,0,'105','0'),('1446',83,0,'106','9'),('1447',93,0,'106','4'),('1448',97,0,'106','1'),('1449',99,0,'106','4'),('1450',115,0,'106','1'),('1451',134,0,'106','0'),('1452',137,0,'106','0'),('1453',83,0,'107','9'),('1454',93,0,'107','4'),('1455',97,0,'107','2'),('1456',99,0,'107','4'),('1457',115,0,'107','1'),('1458',134,0,'107','0'),('1459',137,0,'107','0'),('1460',83,0,'108','9'),('1461',93,0,'108','4'),('1462',97,0,'108','1'),('1463',99,0,'108','4'),('1464',115,0,'108','1'),('1465',134,0,'108','0'),('1466',137,0,'108','0'),('1467',83,0,'109','9'),('1468',93,0,'109','4'),('1469',97,0,'109','2'),('1470',99,0,'109','4'),('1471',115,0,'109','1'),('1472',134,0,'109','0'),('1473',137,0,'109','0'),('1475',97,13,'109','1'),('1476',97,1,'109','1'),('1479',97,2,'109','1'),('1482',97,3,'109','1'),('1485',83,0,'110','9'),('1486',93,0,'110','4'),('1487',97,0,'110','1'),('1488',99,0,'110','4'),('1489',115,0,'110','1'),('1490',134,0,'110','0'),('1491',137,0,'110','0'),('1492',83,0,'111','9'),('1493',93,0,'111','4'),('1494',97,0,'111','1'),('1495',99,0,'111','4'),('1496',115,0,'111','1'),('1497',134,0,'111','0'),('1498',137,0,'111','0'),('1499',83,0,'112','9'),('1500',93,0,'112','4'),('1501',97,0,'112','1'),('1502',99,0,'112','4'),('1503',115,0,'112','1'),('1504',134,0,'112','0'),('1505',137,0,'112','0'),('1506',83,0,'113','9'),('1507',93,0,'113','4'),('1508',97,0,'113','1'),('1509',99,0,'113','4'),('1510',115,0,'113','1'),('1511',134,0,'113','0'),('1512',137,0,'113','0'),('1513',83,0,'114','9'),('1514',93,0,'114','4'),('1515',97,0,'114','1'),('1516',99,0,'114','4'),('1517',115,0,'114','1'),('1518',134,0,'114','0'),('1519',137,0,'114','0'),('1520',83,0,'115','9'),('1521',93,0,'115','4'),('1522',97,0,'115','1'),('1523',99,0,'115','4'),('1524',115,0,'115','1'),('1525',134,0,'115','0'),('1526',137,0,'115','0'),('1527',83,0,'116','9'),('1528',93,0,'116','4'),('1529',97,0,'116','1'),('1530',99,0,'116','4'),('1531',115,0,'116','1'),('1532',134,0,'116','0'),('1533',137,0,'116','0'),('1534',83,0,'117','9'),('1535',93,0,'117','4'),('1536',97,0,'117','1'),('1537',99,0,'117','4'),('1538',115,0,'117','1'),('1539',134,0,'117','0'),('1540',137,0,'117','0'),('1541',83,0,'118','9'),('1542',93,0,'118','4'),('1543',97,0,'118','1'),('1544',99,0,'118','4'),('1545',115,0,'118','1'),('1546',134,0,'118','0'),('1547',137,0,'118','0'),('1548',83,0,'119','9'),('1549',93,0,'119','4'),('1550',97,0,'119','1'),('1551',99,0,'119','4'),('1552',115,0,'119','1'),('1553',134,0,'119','0'),('1554',137,0,'119','0'),('1555',83,0,'120','9'),('1556',93,0,'120','4'),('1557',97,0,'120','1'),('1558',99,0,'120','4'),('1559',115,0,'120','1'),('1560',134,0,'120','0'),('1561',137,0,'120','0'),('1562',83,0,'121','9'),('1563',93,0,'121','4'),('1564',97,0,'121','1'),('1565',99,0,'121','4'),('1566',115,0,'121','1'),('1567',134,0,'121','0'),('1568',137,0,'121','0'),('1569',83,0,'122','9'),('1570',93,0,'122','4'),('1571',97,0,'122','1'),('1572',99,0,'122','4'),('1573',115,0,'122','1'),('1574',134,0,'122','0'),('1575',137,0,'122','0'),('1576',83,0,'123','9'),('1577',93,0,'123','4'),('1578',97,0,'123','1'),('1579',99,0,'123','4'),('1580',115,0,'123','1'),('1581',134,0,'123','0'),('1582',137,0,'123','0'),('1583',83,0,'124','9'),('1584',93,0,'124','4'),('1585',97,0,'124','1'),('1586',99,0,'124','4'),('1587',115,0,'124','1'),('1588',134,0,'124','0'),('1589',137,0,'124','0'),('1590',83,0,'125','9'),('1591',93,0,'125','4'),('1592',97,0,'125','1'),('1593',99,0,'125','4'),('1594',115,0,'125','1'),('1595',134,0,'125','0'),('1596',137,0,'125','0'),('1597',83,0,'126','9'),('1598',93,0,'126','4'),('1599',97,0,'126','1'),('1600',99,0,'126','4'),('1601',115,0,'126','1'),('1602',134,0,'126','0'),('1603',137,0,'126','0'),('1604',83,0,'127','9'),('1605',93,0,'127','4'),('1606',97,0,'127','1'),('1607',99,0,'127','4'),('1608',115,0,'127','1'),('1609',134,0,'127','0'),('1610',137,0,'127','0'),('1611',83,0,'128','9'),('1612',93,0,'128','4'),('1613',97,0,'128','1'),('1614',99,0,'128','4'),('1615',115,0,'128','1'),('1616',134,0,'128','0'),('1617',137,0,'128','0'),('1618',83,0,'129','9'),('1619',93,0,'129','4'),('1620',97,0,'129','1'),('1621',99,0,'129','4'),('1622',115,0,'129','1'),('1623',134,0,'129','0'),('1624',137,0,'129','0'),('1625',83,0,'130','9'),('1626',93,0,'130','4'),('1627',97,0,'130','1'),('1628',99,0,'130','4'),('1629',115,0,'130','1'),('1630',134,0,'130','0'),('1631',137,0,'130','0'),('1632',83,0,'131','9'),('1633',93,0,'131','4'),('1634',97,0,'131','1'),('1635',99,0,'131','4'),('1636',115,0,'131','1'),('1637',134,0,'131','0'),('1638',137,0,'131','0'),('1639',83,0,'132','9'),('1640',93,0,'132','4'),('1641',97,0,'132','1'),('1642',99,0,'132','4'),('1643',115,0,'132','1'),('1644',134,0,'132','0'),('1645',137,0,'132','0'),('1646',83,0,'133','9'),('1647',93,0,'133','4'),('1648',97,0,'133','1'),('1649',99,0,'133','4'),('1650',115,0,'133','1'),('1651',134,0,'133','2'),('1652',137,0,'133','0'),('1653',83,0,'134','9'),('1654',93,0,'134','4'),('1655',97,0,'134','1'),('1656',99,0,'134','4'),('1657',115,0,'134','1'),('1658',134,0,'134','0'),('1659',137,0,'134','0'),('1660',83,0,'135','9'),('1661',93,0,'135','4'),('1662',97,0,'135','1'),('1663',99,0,'135','4'),('1664',115,0,'135','1'),('1665',134,0,'135','0'),('1666',137,0,'135','0'),('1667',83,0,'136','9'),('1668',93,0,'136','4'),('1669',97,0,'136','1'),('1670',99,0,'136','4'),('1671',115,0,'136','1'),('1672',134,0,'136','0'),('1673',137,0,'136','0'),('1674',83,0,'137','9'),('1675',93,0,'137','4'),('1676',97,0,'137','1'),('1677',99,0,'137','4'),('1678',115,0,'137','1'),('1679',134,0,'137','0'),('1680',137,0,'137','0'),('1681',83,0,'138','9'),('1682',93,0,'138','4'),('1683',97,0,'138','1'),('1684',99,0,'138','4'),('1685',115,0,'138','1'),('1686',134,0,'138','0'),('1687',137,0,'138','0'),('1688',83,0,'139','9'),('1689',93,0,'139','4'),('1690',97,0,'139','1'),('1691',99,0,'139','4'),('1692',115,0,'139','1'),('1693',134,0,'139','0'),('1694',137,0,'139','0'),('1695',83,0,'140','9'),('1696',93,0,'140','4'),('1697',97,0,'140','1'),('1698',99,0,'140','4'),('1699',115,0,'140','1'),('1700',134,0,'140','0'),('1701',137,0,'140','0'),('1702',83,0,'141','9'),('1703',93,0,'141','4'),('1704',97,0,'141','1'),('1705',99,0,'141','4'),('1706',115,0,'141','1'),('1707',134,0,'141','0'),('1708',137,0,'141','0'),('1709',83,0,'142','9'),('1710',93,0,'142','4'),('1711',97,0,'142','1'),('1712',99,0,'142','4'),('1713',115,0,'142','1'),('1714',134,0,'142','0'),('1715',137,0,'142','0'),('1716',83,0,'143','9'),('1717',93,0,'143','4'),('1718',97,0,'143','1'),('1719',99,0,'143','4'),('1720',115,0,'143','1'),('1721',134,0,'143','0'),('1722',137,0,'143','0'),('1723',83,0,'144','9'),('1724',93,0,'144','4'),('1725',97,0,'144','1'),('1726',99,0,'144','4'),('1727',115,0,'144','1'),('1728',134,0,'144','0'),('1729',137,0,'144','0'),('1730',83,0,'145','9'),('1731',93,0,'145','4'),('1732',97,0,'145','1'),('1733',99,0,'145','4'),('1734',115,0,'145','1'),('1735',134,0,'145','0'),('1736',137,0,'145','0'),('1737',83,0,'146','9'),('1738',93,0,'146','4'),('1739',97,0,'146','1'),('1740',99,0,'146','4'),('1741',115,0,'146','1'),('1742',134,0,'146','0'),('1743',137,0,'146','0'),('1744',83,0,'147','9'),('1745',93,0,'147','4'),('1746',97,0,'147','1'),('1747',99,0,'147','4'),('1748',115,0,'147','1'),('1749',134,0,'147','0'),('1750',137,0,'147','0'),('1751',83,0,'148','9'),('1752',93,0,'148','4'),('1753',97,0,'148','1'),('1754',99,0,'148','4'),('1755',115,0,'148','1'),('1756',134,0,'148','0'),('1757',137,0,'148','0'),('1758',83,0,'149','9'),('1759',93,0,'149','4'),('1760',97,0,'149','1'),('1761',99,0,'149','4'),('1762',115,0,'149','1'),('1763',134,0,'149','0'),('1764',137,0,'149','0'),('1765',83,0,'150','9'),('1766',93,0,'150','4'),('1767',97,0,'150','1'),('1768',99,0,'150','4'),('1769',115,0,'150','1'),('1770',134,0,'150','0'),('1771',137,0,'150','0'),('1772',83,0,'151','9'),('1773',93,0,'151','4'),('1774',97,0,'151','1'),('1775',99,0,'151','4'),('1776',115,0,'151','1'),('1777',134,0,'151','0'),('1778',137,0,'151','0'),('1779',83,0,'152','9'),('1780',93,0,'152','4'),('1781',97,0,'152','1'),('1782',99,0,'152','4'),('1783',115,0,'152','1'),('1784',134,0,'152','0'),('1785',137,0,'152','0'),('1786',83,0,'153','9'),('1787',93,0,'153','4'),('1788',97,0,'153','1'),('1789',99,0,'153','4'),('1790',115,0,'153','1'),('1791',134,0,'153','0'),('1792',137,0,'153','0'),('1793',83,0,'154','9'),('1794',93,0,'154','4'),('1795',97,0,'154','1'),('1796',99,0,'154','4'),('1797',115,0,'154','1'),('1798',134,0,'154','0'),('1799',137,0,'154','0'),('1800',83,0,'155','9'),('1801',93,0,'155','4'),('1802',97,0,'155','1'),('1803',99,0,'155','4'),('1804',115,0,'155','1'),('1805',134,0,'155','0'),('1806',137,0,'155','0'),('1807',83,0,'156','9'),('1808',93,0,'156','4'),('1809',97,0,'156','1'),('1810',99,0,'156','4'),('1811',115,0,'156','1'),('1812',134,0,'156','0'),('1813',137,0,'156','0'),('1814',83,0,'157','9'),('1815',93,0,'157','4'),('1816',97,0,'157','1'),('1817',99,0,'157','4'),('1818',115,0,'157','1'),('1819',134,0,'157','0'),('1820',137,0,'157','0'),('1821',83,0,'158','9'),('1822',93,0,'158','4'),('1823',97,0,'158','1'),('1824',99,0,'158','4'),('1825',115,0,'158','1'),('1826',134,0,'158','0'),('1827',137,0,'158','0'),('1828',83,0,'159','9'),('1829',93,0,'159','4'),('1830',97,0,'159','1'),('1831',99,0,'159','4'),('1832',115,0,'159','1'),('1833',134,0,'159','0'),('1834',137,0,'159','0'),('1835',83,0,'160','9'),('1836',93,0,'160','4'),('1837',97,0,'160','1'),('1838',99,0,'160','4'),('1839',115,0,'160','1'),('1840',134,0,'160','0'),('1841',137,0,'160','0'),('1842',83,0,'161','9'),('1843',93,0,'161','4'),('1844',97,0,'161','1'),('1845',99,0,'161','4'),('1846',115,0,'161','1'),('1847',134,0,'161','0'),('1848',137,0,'161','0'),('1849',83,0,'162','9'),('1850',93,0,'162','4'),('1851',97,0,'162','1'),('1852',99,0,'162','4'),('1853',115,0,'162','1'),('1854',134,0,'162','0'),('1855',137,0,'162','0'),('1856',83,0,'163','9'),('1857',93,0,'163','4'),('1858',97,0,'163','1'),('1859',99,0,'163','4'),('1860',115,0,'163','1'),('1861',134,0,'163','0'),('1862',137,0,'163','0'),('1863',83,0,'164','9'),('1864',93,0,'164','4'),('1865',97,0,'164','1'),('1866',99,0,'164','4'),('1867',115,0,'164','1'),('1868',134,0,'164','0'),('1869',137,0,'164','0'),('1898',83,0,'169','9'),('1899',93,0,'169','4'),('1900',97,0,'169','1'),('1901',99,0,'169','4'),('1902',115,0,'169','1'),('1903',134,0,'169','0'),('1904',137,0,'169','0'),('1905',83,0,'170','9'),('1906',93,0,'170','4'),('1907',97,0,'170','1'),('1908',99,0,'170','4'),('1909',115,0,'170','1'),('1910',134,0,'170','0'),('1911',137,0,'170','1'),('1912',83,0,'171','9'),('1913',93,0,'171','4'),('1914',97,0,'171','1'),('1915',99,0,'171','4'),('1916',115,0,'171','1'),('1917',134,0,'171','0'),('1918',137,0,'171','0'),('1919',83,0,'172','9'),('1920',93,0,'172','4'),('1921',97,0,'172','1'),('1922',99,0,'172','4'),('1923',115,0,'172','1'),('1924',134,0,'172','0'),('1925',137,0,'172','0'),('1926',83,0,'173','9'),('1927',93,0,'173','4'),('1928',97,0,'173','1'),('1929',99,0,'173','4'),('1930',115,0,'173','1'),('1931',134,0,'173','0'),('1932',137,0,'173','0'),('1933',83,0,'174','9'),('1934',93,0,'174','4'),('1935',97,0,'174','1'),('1936',99,0,'174','4'),('1937',115,0,'174','1'),('1938',134,0,'174','0'),('1939',137,0,'174','0'),('1940',83,0,'175','9'),('1941',93,0,'175','4'),('1942',97,0,'175','1'),('1943',99,0,'175','4'),('1944',115,0,'175','1'),('1945',134,0,'175','0'),('1946',137,0,'175','0'),('1947',83,0,'176','9'),('1948',93,0,'176','4'),('1949',97,0,'176','1'),('1950',99,0,'176','4'),('1951',115,0,'176','1'),('1952',134,0,'176','0'),('1953',137,0,'176','0'),('1954',83,0,'177','9'),('1955',93,0,'177','4'),('1956',97,0,'177','1'),('1957',99,0,'177','4'),('1958',115,0,'177','1'),('1959',134,0,'177','0'),('1960',137,0,'177','0'),('1961',83,0,'178','9'),('1962',93,0,'178','4'),('1963',97,0,'178','1'),('1964',99,0,'178','4'),('1965',115,0,'178','1'),('1966',134,0,'178','0'),('1967',137,0,'178','0'),('1968',83,0,'179','9'),('1969',93,0,'179','4'),('1970',97,0,'179','1'),('1971',99,0,'179','4'),('1972',115,0,'179','1'),('1973',134,0,'179','0'),('1974',137,0,'179','0'),('1975',83,0,'180','9'),('1976',93,0,'180','4'),('1977',97,0,'180','1'),('1978',99,0,'180','4'),('1979',115,0,'180','1'),('1980',134,0,'180','2'),('1981',137,0,'180','0'),('1982',83,0,'181','9'),('1983',93,0,'181','4'),('1984',97,0,'181','1'),('1985',99,0,'181','4'),('1986',115,0,'181','1'),('1987',134,0,'181','0'),('1988',137,0,'181','0'),('1989',83,0,'182','9'),('1990',93,0,'182','4'),('1991',97,0,'182','1'),('1992',99,0,'182','4'),('1993',115,0,'182','1'),('1994',134,0,'182','0'),('1995',137,0,'182','0'),('1996',83,0,'183','9'),('1997',93,0,'183','4'),('1998',97,0,'183','1'),('1999',99,0,'183','4'),('2000',115,0,'183','1'),('2001',134,0,'183','0'),('2002',137,0,'183','0'),('2716',83,0,'184','9'),('2717',93,0,'184','4'),('2718',97,0,'184','1'),('2719',99,0,'184','4'),('2720',115,0,'184','1'),('2721',134,0,'184','0'),('2722',137,0,'184','1'),('2723',83,0,'185','9'),('2724',93,0,'185','4'),('2725',97,0,'185','1'),('2726',99,0,'185','4'),('2727',115,0,'185','1'),('2728',134,0,'185','0'),('2729',137,0,'185','1'),('2730',97,13,'95','2'),('2731',97,1,'95','2'),('2732',97,2,'95','2'),('2733',97,3,'95','2'),('2734',97,13,'185','1'),('2735',97,1,'185','1'),('2736',97,2,'185','1'),('2737',97,3,'185','1'),('2744',97,13,'76','1'),('2745',97,1,'76','1'),('2746',97,2,'76','1'),('2747',97,3,'76','1');
/*!40000 ALTER TABLE `catalog_product_entity_int` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_entity_media_gallery`
--

DROP TABLE IF EXISTS `catalog_product_entity_media_gallery`;
CREATE TABLE `catalog_product_entity_media_gallery` (
  `value_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `attribute_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `value` varchar(255) DEFAULT NULL COMMENT 'Value',
  `media_type` varchar(32) NOT NULL DEFAULT 'image' COMMENT 'Media entry type',
  `disabled` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Visibility status',
  PRIMARY KEY (`value_id`),
  KEY `CATALOG_PRODUCT_ENTITY_MEDIA_GALLERY_ATTRIBUTE_ID` (`attribute_id`)
) ENGINE=InnoDB AUTO_INCREMENT=825 DEFAULT CHARSET=utf8 COMMENT='Catalog Product Media Gallery Attribute Backend Table';

--
-- Dumping data for table `catalog_product_entity_media_gallery`
--

LOCK TABLES `catalog_product_entity_media_gallery` WRITE;
/*!40000 ALTER TABLE `catalog_product_entity_media_gallery` DISABLE KEYS */;
INSERT INTO `catalog_product_entity_media_gallery` VALUES ('1',90,'//1/_/1.jpg','image',0),('2',90,'//2/_/2.jpg','image',0),('3',90,'//3/_/3.jpg','image',0),('4',90,'//4/_/4.jpg','image',0),('5',90,'//5/_/5.jpg','image',0),('6',90,'//6/_/6.jpg','image',0),('13',90,'//2/_/2_2.jpg','image',0),('14',90,'//3/_/3_2.jpg','image',0),('15',90,'//4/_/4_2.jpg','image',0),('16',90,'//5/_/5_2.jpg','image',0),('17',90,'//6/_/6_2.jpg','image',0),('18',90,'//7/_/7_1.jpg','image',0),('19',90,'//3/_/3_3.jpg','image',0),('20',90,'//4/_/4_3.jpg','image',0),('21',90,'//5/_/5_3.jpg','image',0),('22',90,'//6/_/6_3.jpg','image',0),('23',90,'//7/_/7_2.jpg','image',0),('24',90,'//8/_/8.jpg','image',0),('25',90,'//4/_/4_4.jpg','image',0),('26',90,'//5/_/5_4.jpg','image',0),('27',90,'//6/_/6_4.jpg','image',0),('28',90,'//7/_/7_3.jpg','image',0),('29',90,'//8/_/8_1.jpg','image',0),('30',90,'//9/_/9.jpg','image',0),('31',90,'//5/_/5_5.jpg','image',0),('32',90,'//6/_/6_5.jpg','image',0),('33',90,'//7/_/7_4.jpg','image',0),('34',90,'//8/_/8_2.jpg','image',0),('35',90,'//9/_/9_1.jpg','image',0),('36',90,'//1/0/10.jpg','image',0),('37',90,'//6/_/6_6.jpg','image',0),('38',90,'//7/_/7_5.jpg','image',0),('39',90,'//8/_/8_3.jpg','image',0),('40',90,'//9/_/9_2.jpg','image',0),('41',90,'//1/0/10_1.jpg','image',0),('42',90,'//1/1/11.jpg','image',0),('43',90,'//7/_/7_6.jpg','image',0),('44',90,'//8/_/8_4.jpg','image',0),('45',90,'//9/_/9_3.jpg','image',0),('46',90,'//1/0/10_2.jpg','image',0),('47',90,'//1/1/11_1.jpg','image',0),('48',90,'//1/2/12.jpg','image',0),('49',90,'//8/_/8_5.jpg','image',0),('50',90,'//9/_/9_4.jpg','image',0),('51',90,'//1/0/10_3.jpg','image',0),('52',90,'//1/1/11_2.jpg','image',0),('53',90,'//1/2/12_1.jpg','image',0),('54',90,'//1/3/13.jpg','image',0),('55',90,'//9/_/9_5.jpg','image',0),('56',90,'//1/0/10_4.jpg','image',0),('57',90,'//1/1/11_3.jpg','image',0),('58',90,'//1/2/12_2.jpg','image',0),('59',90,'//1/3/13_1.jpg','image',0),('60',90,'//1/4/14.jpg','image',0),('61',90,'//1/0/10_5.jpg','image',0),('62',90,'//1/1/11_4.jpg','image',0),('63',90,'//1/2/12_3.jpg','image',0),('64',90,'//1/3/13_2.jpg','image',0),('65',90,'//1/4/14_1.jpg','image',0),('66',90,'//1/5/15.jpg','image',0),('67',90,'//1/1/11_5.jpg','image',0),('68',90,'//1/2/12_4.jpg','image',0),('69',90,'//1/3/13_3.jpg','image',0),('70',90,'//1/4/14_2.jpg','image',0),('71',90,'//1/5/15_1.jpg','image',0),('72',90,'//1/6/16.jpg','image',0),('73',90,'//1/2/12_5.jpg','image',0),('74',90,'//1/3/13_4.jpg','image',0),('75',90,'//1/4/14_3.jpg','image',0),('76',90,'//1/5/15_2.jpg','image',0),('77',90,'//1/6/16_1.jpg','image',0),('78',90,'//1/7/17.jpg','image',0),('79',90,'//1/3/13_5.jpg','image',0),('80',90,'//1/4/14_4.jpg','image',0),('81',90,'//1/5/15_3.jpg','image',0),('82',90,'//1/6/16_2.jpg','image',0),('83',90,'//1/7/17_1.jpg','image',0),('84',90,'//1/8/18.jpg','image',0),('85',90,'//1/4/14_5.jpg','image',0),('86',90,'//1/5/15_4.jpg','image',0),('87',90,'//1/6/16_3.jpg','image',0),('88',90,'//1/7/17_2.jpg','image',0),('89',90,'//1/8/18_1.jpg','image',0),('90',90,'//1/_/1_1.jpg','image',0),('91',90,'//1/5/15_5.jpg','image',0),('92',90,'//1/6/16_4.jpg','image',0),('93',90,'//1/7/17_3.jpg','image',0),('94',90,'//1/8/18_2.jpg','image',0),('95',90,'//1/_/1_2.jpg','image',0),('96',90,'//2/_/2_3.jpg','image',0),('97',90,'//1/6/16_5.jpg','image',0),('98',90,'//1/7/17_4.jpg','image',0),('99',90,'//1/8/18_3.jpg','image',0),('100',90,'//1/_/1_3.jpg','image',0),('101',90,'//2/_/2_4.jpg','image',0),('102',90,'//3/_/3_4.jpg','image',0),('103',90,'//1/7/17_5.jpg','image',0),('104',90,'//1/8/18_4.jpg','image',0),('105',90,'//1/_/1_4.jpg','image',0),('106',90,'//2/_/2_5.jpg','image',0),('107',90,'//3/_/3_5.jpg','image',0),('108',90,'//4/_/4_5.jpg','image',0),('109',90,'//1/8/18_5.jpg','image',0),('110',90,'//1/_/1_5.jpg','image',0),('111',90,'//2/_/2_6.jpg','image',0),('112',90,'//3/_/3_6.jpg','image',0),('113',90,'//4/_/4_6.jpg','image',0),('114',90,'//5/_/5_6.jpg','image',0),('115',90,'//1/_/1_6.jpg','image',0),('116',90,'//2/_/2_7.jpg','image',0),('117',90,'//3/_/3_7.jpg','image',0),('118',90,'//4/_/4_7.jpg','image',0),('119',90,'//5/_/5_7.jpg','image',0),('120',90,'//6/_/6_7.jpg','image',0),('121',90,'//2/_/2_8.jpg','image',0),('122',90,'//3/_/3_8.jpg','image',0),('123',90,'//4/_/4_8.jpg','image',0),('124',90,'//5/_/5_8.jpg','image',0),('125',90,'//6/_/6_8.jpg','image',0),('126',90,'//7/_/7_7.jpg','image',0),('127',90,'//3/_/3_9.jpg','image',0),('128',90,'//4/_/4_9.jpg','image',0),('129',90,'//5/_/5_9.jpg','image',0),('130',90,'//6/_/6_9.jpg','image',0),('131',90,'//7/_/7_8.jpg','image',0),('132',90,'//8/_/8_6.jpg','image',0),('133',90,'//4/_/4_10.jpg','image',0),('134',90,'//5/_/5_10.jpg','image',0),('135',90,'//6/_/6_10.jpg','image',0),('136',90,'//7/_/7_9.jpg','image',0),('137',90,'//8/_/8_7.jpg','image',0),('138',90,'//9/_/9_6.jpg','image',0),('139',90,'//5/_/5_11.jpg','image',0),('140',90,'//6/_/6_11.jpg','image',0),('141',90,'//7/_/7_10.jpg','image',0),('142',90,'//8/_/8_8.jpg','image',0),('143',90,'//9/_/9_7.jpg','image',0),('144',90,'//1/0/10_6.jpg','image',0),('145',90,'//6/_/6_12.jpg','image',0),('146',90,'//7/_/7_11.jpg','image',0),('147',90,'//8/_/8_9.jpg','image',0),('148',90,'//9/_/9_8.jpg','image',0),('149',90,'//1/0/10_7.jpg','image',0),('150',90,'//1/1/11_6.jpg','image',0),('151',90,'//7/_/7_12.jpg','image',0),('152',90,'//8/_/8_10.jpg','image',0),('153',90,'//9/_/9_9.jpg','image',0),('154',90,'//1/0/10_8.jpg','image',0),('155',90,'//1/1/11_7.jpg','image',0),('156',90,'//1/2/12_6.jpg','image',0),('157',90,'//8/_/8_11.jpg','image',0),('158',90,'//9/_/9_10.jpg','image',0),('159',90,'//1/0/10_9.jpg','image',0),('160',90,'//1/1/11_8.jpg','image',0),('161',90,'//1/2/12_7.jpg','image',0),('162',90,'//1/3/13_6.jpg','image',0),('163',90,'//9/_/9_11.jpg','image',0),('164',90,'//1/0/10_10.jpg','image',0),('165',90,'//1/1/11_9.jpg','image',0),('166',90,'//1/2/12_8.jpg','image',0),('167',90,'//1/3/13_7.jpg','image',0),('168',90,'//1/4/14_6.jpg','image',0),('169',90,'//1/0/10_11.jpg','image',0),('170',90,'//1/1/11_10.jpg','image',0),('171',90,'//1/2/12_9.jpg','image',0),('172',90,'//1/3/13_8.jpg','image',0),('173',90,'//1/4/14_7.jpg','image',0),('174',90,'//1/5/15_6.jpg','image',0),('175',90,'//1/1/11_11.jpg','image',0),('176',90,'//1/2/12_10.jpg','image',0),('177',90,'//1/3/13_9.jpg','image',0),('178',90,'//1/4/14_8.jpg','image',0),('179',90,'//1/5/15_7.jpg','image',0),('180',90,'//1/6/16_6.jpg','image',0),('181',90,'//1/2/12_11.jpg','image',0),('182',90,'//1/3/13_10.jpg','image',0),('183',90,'//1/4/14_9.jpg','image',0),('184',90,'//1/5/15_8.jpg','image',0),('185',90,'//1/6/16_7.jpg','image',0),('186',90,'//1/7/17_6.jpg','image',0),('187',90,'//1/3/13_11.jpg','image',0),('188',90,'//1/4/14_10.jpg','image',0),('189',90,'//1/5/15_9.jpg','image',0),('190',90,'//1/6/16_8.jpg','image',0),('191',90,'//1/7/17_7.jpg','image',0),('192',90,'//1/2/12_12.jpg','image',0),('193',90,'//1/4/14_11.jpg','image',0),('194',90,'//1/5/15_10.jpg','image',0),('195',90,'//1/6/16_9.jpg','image',0),('196',90,'//1/7/17_8.jpg','image',0),('197',90,'//1/2/12_13.jpg','image',0),('198',90,'//1/3/13_12.jpg','image',0),('199',90,'//1/5/15_11.jpg','image',0),('200',90,'//1/6/16_10.jpg','image',0),('201',90,'//1/7/17_9.jpg','image',0),('202',90,'//1/3/13_13.jpg','image',0),('203',90,'//1/4/14_12.jpg','image',0),('204',90,'//1/6/16_11.jpg','image',0),('205',90,'//1/7/17_10.jpg','image',0),('206',90,'//1/2/12_14.jpg','image',0),('207',90,'//1/3/13_14.jpg','image',0),('208',90,'//1/4/14_13.jpg','image',0),('209',90,'//1/5/15_12.jpg','image',0),('210',90,'//1/7/17_11.jpg','image',0),('211',90,'//1/2/12_15.jpg','image',0),('212',90,'//1/3/13_15.jpg','image',0),('213',90,'//1/4/14_14.jpg','image',0),('214',90,'//1/5/15_13.jpg','image',0),('215',90,'//1/6/16_12.jpg','image',0),('216',90,'//1/_/1_1_1.jpg','image',0),('217',90,'//2/_/2_1_1.jpg','image',0),('218',90,'//3/_/3_1_1.jpg','image',0),('219',90,'//4/_/4_1_1.jpg','image',0),('220',90,'//5/_/5_1_1.jpg','image',0),('221',90,'//6/_/6_1_1.jpg','image',0),('222',90,'//2/_/2_1_2.jpg','image',0),('223',90,'//3/_/3_1_2.jpg','image',0),('224',90,'//4/_/4_1_2.jpg','image',0),('225',90,'//5/_/5_1_2.jpg','image',0),('226',90,'//6/_/6_1_2.jpg','image',0),('227',90,'//7/_/7_13.jpg','image',0),('228',90,'//3/_/3_1_3.jpg','image',0),('229',90,'//4/_/4_1_3.jpg','image',0),('230',90,'//5/_/5_1_3.jpg','image',0),('231',90,'//6/_/6_1_3.jpg','image',0),('232',90,'//7/_/7_14.jpg','image',0),('233',90,'//8/_/8_12.jpg','image',0),('234',90,'//4/_/4_1_4.jpg','image',0),('235',90,'//5/_/5_1_4.jpg','image',0),('236',90,'//6/_/6_1_4.jpg','image',0),('237',90,'//7/_/7_15.jpg','image',0),('238',90,'//8/_/8_13.jpg','image',0),('239',90,'//9/_/9_12.jpg','image',0),('240',90,'//5/_/5_1_5.jpg','image',0),('241',90,'//6/_/6_1_5.jpg','image',0),('242',90,'//7/_/7_16.jpg','image',0),('243',90,'//8/_/8_14.jpg','image',0),('244',90,'//9/_/9_13.jpg','image',0),('245',90,'//1/0/10_12.jpg','image',0),('246',90,'//6/_/6_1_6.jpg','image',0),('247',90,'//7/_/7_17.jpg','image',0),('248',90,'//8/_/8_15.jpg','image',0),('249',90,'//9/_/9_14.jpg','image',0),('250',90,'//1/0/10_13.jpg','image',0),('251',90,'//1/1/11_12.jpg','image',0),('252',90,'//7/_/7_18.jpg','image',0),('253',90,'//8/_/8_16.jpg','image',0),('254',90,'//9/_/9_15.jpg','image',0),('255',90,'//1/0/10_14.jpg','image',0),('256',90,'//1/1/11_13.jpg','image',0),('257',90,'//1/2/12_16.jpg','image',0),('258',90,'//8/_/8_17.jpg','image',0),('259',90,'//9/_/9_16.jpg','image',0),('260',90,'//1/0/10_15.jpg','image',0),('261',90,'//1/1/11_14.jpg','image',0),('262',90,'//1/2/12_17.jpg','image',0),('263',90,'//1/3/13_16.jpg','image',0),('264',90,'//9/_/9_17.jpg','image',0),('265',90,'//1/0/10_16.jpg','image',0),('266',90,'//1/1/11_15.jpg','image',0),('267',90,'//1/2/12_18.jpg','image',0),('268',90,'//1/3/13_17.jpg','image',0),('269',90,'//1/4/14_15.jpg','image',0),('270',90,'//1/0/10_17.jpg','image',0),('271',90,'//1/1/11_16.jpg','image',0),('272',90,'//1/2/12_19.jpg','image',0),('273',90,'//1/3/13_18.jpg','image',0),('274',90,'//1/4/14_16.jpg','image',0),('275',90,'//1/5/15_14.jpg','image',0),('276',90,'//1/1/11_17.jpg','image',0),('277',90,'//1/2/12_20.jpg','image',0),('278',90,'//1/3/13_19.jpg','image',0),('279',90,'//1/4/14_17.jpg','image',0),('280',90,'//1/5/15_15.jpg','image',0),('281',90,'//1/6/16_13.jpg','image',0),('282',90,'//1/2/12_21.jpg','image',0),('283',90,'//1/3/13_20.jpg','image',0),('284',90,'//1/4/14_18.jpg','image',0),('285',90,'//1/5/15_16.jpg','image',0),('286',90,'//1/6/16_14.jpg','image',0),('287',90,'//1/7/17_12.jpg','image',0),('288',90,'//1/3/13_21.jpg','image',0),('289',90,'//1/4/14_19.jpg','image',0),('290',90,'//1/5/15_17.jpg','image',0),('291',90,'//1/6/16_15.jpg','image',0),('292',90,'//1/7/17_13.jpg','image',0),('293',90,'//1/8/18_6.jpg','image',0),('294',90,'//1/4/14_20.jpg','image',0),('295',90,'//1/5/15_18.jpg','image',0),('296',90,'//1/6/16_16.jpg','image',0),('297',90,'//1/7/17_14.jpg','image',0),('298',90,'//1/8/18_7.jpg','image',0),('299',90,'//6/_/6_1_7.jpg','image',0),('300',90,'//1/5/15_19.jpg','image',0),('301',90,'//1/6/16_17.jpg','image',0),('302',90,'//1/7/17_15.jpg','image',0),('303',90,'//1/8/18_8.jpg','image',0),('304',90,'//6/_/6_1_8.jpg','image',0),('305',90,'//1/3/13_22.jpg','image',0),('306',90,'//1/6/16_18.jpg','image',0),('307',90,'//1/7/17_16.jpg','image',0),('308',90,'//1/8/18_9.jpg','image',0),('309',90,'//1/_/1_1_2.jpg','image',0),('310',90,'//2/_/2_1_3.jpg','image',0),('311',90,'//3/_/3_1_4.jpg','image',0),('312',90,'//1/7/17_17.jpg','image',0),('313',90,'//1/8/18_10.jpg','image',0),('314',90,'//1/_/1_1_3.jpg','image',0),('315',90,'//2/_/2_1_4.jpg','image',0),('316',90,'//3/_/3_1_5.jpg','image',0),('317',90,'//4/_/4_1_5.jpg','image',0),('318',90,'//1/8/18_11.jpg','image',0),('319',90,'//1/3/13_23.jpg','image',0),('320',90,'//1/4/14_21.jpg','image',0),('321',90,'//1/5/15_20.jpg','image',0),('322',90,'//1/6/16_19.jpg','image',0),('323',90,'//1/7/17_18.jpg','image',0),('330',90,'//0/1/01_1.jpg','image',0),('331',90,'//2/_/2_2_1.jpg','image',0),('332',90,'//3/_/3_2_1.jpg','image',0),('333',90,'//4/_/4_2_1.jpg','image',0),('334',90,'//5/_/5_2_1.jpg','image',0),('335',90,'//6/_/6_2_1.jpg','image',0),('336',90,'//2/_/2_2_2.jpg','image',0),('337',90,'//3/_/3_2_2.jpg','image',0),('338',90,'//4/_/4_2_2.jpg','image',0),('339',90,'//5/_/5_2_2.jpg','image',0),('340',90,'//6/_/6_2_2.jpg','image',0),('341',90,'//7/_/7_19.jpg','image',0),('342',90,'//3/_/3_2_3.jpg','image',0),('343',90,'//4/_/4_2_3.jpg','image',0),('344',90,'//5/_/5_2_3.jpg','image',0),('345',90,'//6/_/6_2_3.jpg','image',0),('346',90,'//7/_/7_20.jpg','image',0),('347',90,'//8/_/8_18.jpg','image',0),('348',90,'//4/_/4_2_4.jpg','image',0),('349',90,'//5/_/5_2_4.jpg','image',0),('350',90,'//6/_/6_2_4.jpg','image',0),('351',90,'//7/_/7_21.jpg','image',0),('352',90,'//8/_/8_19.jpg','image',0),('353',90,'//9/_/9_18.jpg','image',0),('354',90,'//5/_/5_2_5.jpg','image',0),('355',90,'//6/_/6_2_5.jpg','image',0),('356',90,'//7/_/7_22.jpg','image',0),('357',90,'//8/_/8_20.jpg','image',0),('358',90,'//9/_/9_19.jpg','image',0),('359',90,'//1/0/10_18.jpg','image',0),('360',90,'//6/_/6_2_6.jpg','image',0),('361',90,'//7/_/7_23.jpg','image',0),('362',90,'//8/_/8_21.jpg','image',0),('363',90,'//9/_/9_20.jpg','image',0),('364',90,'//1/0/10_19.jpg','image',0),('365',90,'//1/1/11_18.jpg','image',0),('366',90,'//7/_/7_24.jpg','image',0),('367',90,'//8/_/8_22.jpg','image',0),('368',90,'//9/_/9_21.jpg','image',0),('369',90,'//1/0/10_20.jpg','image',0),('370',90,'//1/1/11_19.jpg','image',0),('371',90,'//1/2/12_22.jpg','image',0),('372',90,'//8/_/8_23.jpg','image',0),('373',90,'//9/_/9_22.jpg','image',0),('374',90,'//1/0/10_21.jpg','image',0),('375',90,'//1/1/11_20.jpg','image',0),('376',90,'//1/2/12_23.jpg','image',0),('377',90,'//1/3/13_24.jpg','image',0),('378',90,'//9/_/9_23.jpg','image',0),('379',90,'//1/0/10_22.jpg','image',0),('380',90,'//1/1/11_21.jpg','image',0),('381',90,'//1/2/12_24.jpg','image',0),('382',90,'//1/3/13_25.jpg','image',0),('383',90,'//1/4/14_22.jpg','image',0),('384',90,'//1/0/10_23.jpg','image',0),('385',90,'//1/1/11_22.jpg','image',0),('386',90,'//1/2/12_25.jpg','image',0),('387',90,'//1/3/13_26.jpg','image',0),('388',90,'//1/4/14_23.jpg','image',0),('389',90,'//1/5/15_21.jpg','image',0),('390',90,'//1/1/11_23.jpg','image',0),('391',90,'//1/2/12_26.jpg','image',0),('392',90,'//1/3/13_27.jpg','image',0),('393',90,'//1/4/14_24.jpg','image',0),('394',90,'//1/5/15_22.jpg','image',0),('395',90,'//1/6/16_20.jpg','image',0),('396',90,'//1/2/12_27.jpg','image',0),('397',90,'//1/3/13_28.jpg','image',0),('398',90,'//1/4/14_25.jpg','image',0),('399',90,'//1/5/15_23.jpg','image',0),('400',90,'//1/6/16_21.jpg','image',0),('401',90,'//1/7/17_19.jpg','image',0),('402',90,'//1/3/13_29.jpg','image',0),('403',90,'//1/4/14_26.jpg','image',0),('404',90,'//1/5/15_24.jpg','image',0),('405',90,'//1/6/16_22.jpg','image',0),('406',90,'//1/7/17_20.jpg','image',0),('407',90,'//1/8/18_12.jpg','image',0),('408',90,'//1/4/14_27.jpg','image',0),('409',90,'//1/5/15_25.jpg','image',0),('410',90,'//1/6/16_23.jpg','image',0),('411',90,'//1/7/17_21.jpg','image',0),('412',90,'//1/8/18_13.jpg','image',0),('413',90,'//1/3/13_30.jpg','image',0),('414',90,'//1/5/15_26.jpg','image',0),('415',90,'//1/6/16_24.jpg','image',0),('416',90,'//1/7/17_22.jpg','image',0),('417',90,'//1/8/18_14.jpg','image',0),('418',90,'//1/3/13_31.jpg','image',0),('419',90,'//1/4/14_28.jpg','image',0),('420',90,'//1/6/16_25.jpg','image',0),('421',90,'//1/7/17_23.jpg','image',0),('422',90,'//1/8/18_15.jpg','image',0),('423',90,'//0/1/01_1_1.jpg','image',0),('424',90,'//2/_/2_2_3.jpg','image',0),('425',90,'//3/_/3_2_4.jpg','image',0),('426',90,'//1/7/17_24.jpg','image',0),('427',90,'//1/8/18_16.jpg','image',0),('428',90,'//0/1/01_1_2.jpg','image',0),('429',90,'//2/_/2_2_4.jpg','image',0),('430',90,'//1/4/14_29.jpg','image',0),('431',90,'//1/6/16_26.jpg','image',0),('432',90,'//1/8/18_17.jpg','image',0),('433',90,'//1/3/13_32.jpg','image',0),('434',90,'//1/4/14_30.jpg','image',0),('435',90,'//1/5/15_27.jpg','image',0),('436',90,'//1/6/16_27.jpg','image',0),('437',90,'//1/7/17_25.jpg','image',0),('438',90,'/b/1/b1.jpg','image',0),('439',90,'/b/2/b2.jpg','image',0),('440',90,'/b/4/b4.jpg','image',0),('441',90,'/b/8/b8.jpg','image',0),('442',90,'/b/6/b6.jpg','image',0),('443',90,'/b/7/b7.jpg','image',0),('444',90,'/b/3/b3.jpg','image',0),('445',90,'/b/5/b5.jpg','image',0),('446',90,'/c/1/c1.jpg','image',0),('447',90,'/c/2/c2.jpg','image',0),('448',90,'/c/3/c3.jpg','image',0),('449',90,'/c/4/c4.jpg','image',0),('450',90,'/c/5/c5.jpg','image',0),('451',90,'/c/6/c6.jpg','image',0),('452',90,'/c/7/c7.jpg','image',0),('453',90,'/c/1/c1_1.jpg','image',0),('454',90,'/c/2/c2_1.jpg','image',0),('455',90,'/c/3/c3_1.jpg','image',0),('456',90,'/c/4/c4_1.jpg','image',0),('457',90,'/c/5/c5_1.jpg','image',0),('458',90,'/c/6/c6_1.jpg','image',0),('459',90,'/c/7/c7_1.jpg','image',0),('460',90,'/e/2/e2.jpg','image',0),('461',90,'/e/1/e1.jpg','image',0),('462',90,'/e/3/e3.jpg','image',0),('463',90,'/e/4/e4.jpg','image',0),('464',90,'/e/5/e5.jpg','image',0),('465',90,'/e/6/e6.jpg','image',0),('466',90,'/e/7/e7.jpg','image',0),('467',90,'/f/1/f1.jpg','image',0),('468',90,'/f/6/f6.jpg','image',0),('469',90,'/f/2/f2.jpg','image',0),('470',90,'/f/5/f5.jpg','image',0),('471',90,'/f/3/f3.jpg','image',0),('472',90,'/f/4/f4.jpg','image',0),('473',90,'/f/7/f7.jpg','image',0),('474',90,'/f/8/f8.jpg','image',0),('475',90,'/f/9/f9.jpg','image',0),('476',90,'/f/1/f10.jpg','image',0),('477',90,'/f/7/f7_1.jpg','image',0),('478',90,'/f/1/f10_1.jpg','image',0),('479',90,'/f/8/f8_1.jpg','image',0),('480',90,'/f/9/f9_1.jpg','image',0),('481',90,'/g/4/g4.jpg','image',0),('482',90,'/g/1/g1.jpg','image',0),('483',90,'/g/3/g3.jpg','image',0),('484',90,'/g/2/g2.jpg','image',0),('485',90,'/g/2/g2_1.jpg','image',0),('486',90,'/g/3/g3_1.jpg','image',0),('487',90,'/g/4/g4_1.jpg','image',0),('488',90,'/g/5/g5.jpg','image',0),('489',90,'/g/6/g6.jpg','image',0),('490',90,'/g/7/g7.jpg','image',0),('491',90,'/g/8/g8.jpg','image',0),('492',90,'/g/9/g9.jpg','image',0),('493',90,'/h/1/h1.jpg','image',0),('494',90,'/h/2/h2.jpg','image',0),('495',90,'/h/6/h6.jpg','image',0),('496',90,'/h/3/h3.jpg','image',0),('497',90,'/h/4/h4.jpg','image',0),('498',90,'/h/5/h5.jpg','image',0),('499',90,'/h/7/h7.jpg','image',0),('500',90,'/h/8/h8.jpg','image',0),('501',90,'/h/9/h9.jpg','image',0),('502',90,'/h/1/h11.jpg','image',0),('503',90,'/h/1/h12.jpg','image',0),('504',90,'/h/1/h13.jpg','image',0),('505',90,'/h/1/h14.jpg','image',0),('506',90,'/q/1/q1.jpg','image',0),('507',90,'/q/2/q2.jpg','image',0),('508',90,'/q/3/q3.jpg','image',0),('509',90,'/q/4/q4.jpg','image',0),('510',90,'/q/5/q5.jpg','image',0),('511',90,'/q/6/q6.jpg','image',0),('512',90,'/q/7/q7.jpg','image',0),('513',90,'/q/8/q8.jpg','image',0),('514',90,'/w/1/w1.jpg','image',0),('515',90,'/w/2/w2.jpg','image',0),('516',90,'/w/3/w3.jpg','image',0),('517',90,'/w/4/w4.jpg','image',0),('518',90,'/w/5/w5.jpg','image',0),('519',90,'/a/a/aa1.jpg','image',0),('520',90,'/a/a/aa2.jpg','image',0),('521',90,'/a/a/aa3.jpg','image',0),('522',90,'/a/a/aa4.jpg','image',0),('523',90,'/a/a/aa5.jpg','image',0),('524',90,'/a/a/aa6.jpg','image',0),('525',90,'/a/a/aa7.jpg','image',0),('526',90,'/w/6/w6.jpg','image',0),('527',90,'/w/7/w7.jpg','image',0),('528',90,'/q/q/qq2.png','image',0),('529',90,'/q/q/qq1.jpg','image',0),('530',90,'/q/q/qq3.jpg','image',0),('531',90,'/w/w/ww1.jpg','image',0),('532',90,'/w/w/ww2.jpg','image',0),('533',90,'/w/w/ww3.jpg','image',0),('534',90,'/w/w/ww4.jpg','image',0),('535',90,'/w/w/ww5.jpg','image',0),('536',90,'/w/w/ww6.jpg','image',0),('537',90,'/w/w/ww7.jpg','image',0),('538',90,'/w/w/ww8.jpg','image',0),('539',90,'/e/e/ee2.jpg','image',0),('540',90,'/e/e/ee1.jpg','image',0),('541',90,'/e/e/ee3.jpg','image',0),('542',90,'/e/e/ee4.jpg','image',0),('543',90,'/e/e/ee5.jpg','image',0),('544',90,'/a/1/a1.jpg','image',0),('545',90,'/a/2/a2.jpg','image',0),('546',90,'/a/3/a3.jpg','image',0),('547',90,'/a/4/a4.jpg','image',0),('548',90,'/a/5/a5.jpg','image',0),('549',90,'/a/6/a6.jpg','image',0),('550',90,'/a/7/a7.png','image',0),('551',90,'/a/8/a8.jpg','image',0),('552',90,'/a/9/a9.jpg','image',0),('553',90,'/a/1/a10.jpg','image',0),('554',90,'/a/1/a11.jpg','image',0),('555',90,'/a/1/a12.jpg','image',0),('556',90,'/a/1/a13.jpg','image',0),('557',90,'/b/1/b1_1.jpg','image',0),('558',90,'/b/2/b2_1.jpg','image',0),('559',90,'/b/3/b3_1.jpg','image',0),('560',90,'/b/4/b4_1.jpg','image',0),('561',90,'/b/5/b5_1.jpg','image',0),('562',90,'/b/6/b6_1.jpg','image',0),('563',90,'/b/7/b7_1.jpg','image',0),('564',90,'/b/8/b8_1.jpg','image',0),('565',90,'/b/9/b9.jpg','image',0),('566',90,'/b/1/b10.jpg','image',0),('567',90,'/b/1/b11.jpg','image',0),('568',90,'/b/1/b12.jpg','image',0),('569',90,'/b/1/b13.jpg','image',0),('570',90,'/c/1/c1_2.jpg','image',0),('571',90,'/c/2/c2_2.jpg','image',0),('572',90,'/c/3/c3_2.jpg','image',0),('573',90,'/c/4/c4_2.jpg','image',0),('574',90,'/c/5/c5_2.jpg','image',0),('575',90,'/c/6/c6_2.jpg','image',0),('576',90,'/c/7/c7_2.jpg','image',0),('577',90,'/d/1/d1.jpg','image',0),('578',90,'/d/3/d3.jpg','image',0),('579',90,'/d/4/d4.jpg','image',0),('580',90,'/d/5/d5.jpg','image',0),('581',90,'/d/6/d6.jpg','image',0),('582',90,'/d/7/d7.jpg','image',0),('583',90,'/d/8/d8.jpg','image',0),('584',90,'/d/9/d9.jpg','image',0),('585',90,'/d/1/d10.jpg','image',0),('586',90,'/d/1/d11.jpg','image',0),('587',90,'/a/1/a1.jpeg','image',0),('588',90,'/a/2/a2.jpeg','image',0),('589',90,'/a/3/a3.jpeg','image',0),('590',90,'/a/4/a4.jpeg','image',0),('591',90,'/e/1/e1_1.jpg','image',0),('592',90,'/e/2/e2_1.jpg','image',0),('593',90,'/e/3/e3_1.jpg','image',0),('594',90,'/e/4/e4_1.jpg','image',0),('595',90,'/e/5/e5_1.jpg','image',0),('596',90,'/e/6/e6_1.jpg','image',0),('597',90,'/e/7/e7_1.jpg','image',0),('598',90,'/e/8/e8.jpg','image',0),('599',90,'/e/9/e9.jpg','image',0),('600',90,'/e/1/e10.jpg','image',0),('601',90,'/e/1/e11.jpg','image',0),('602',90,'/e/1/e12.jpg','image',0),('603',90,'/4/5/454.jpg','image',0),('605',90,'/5/1/511.jpg','image',0),('606',90,'/f/1/f1_1.jpg','image',0),('607',90,'/f/2/f2_1.jpg','image',0),('608',90,'/f/3/f3_1.jpg','image',0),('609',90,'/f/4/f4_1.jpg','image',0),('610',90,'/f/5/f5_1.jpg','image',0),('611',90,'/f/6/f6_1.jpg','image',0),('612',90,'/f/7/f7_2.jpg','image',0),('613',90,'/f/8/f8_2.jpg','image',0),('614',90,'/f/9/f9_2.jpg','image',0),('615',90,'/f/1/f10_2.jpg','image',0),('616',90,'/f/1/f11.jpg','image',0),('617',90,'/f/1/f12.jpg','image',0),('618',90,'/g/1/g1_1.jpg','image',0),('619',90,'/g/2/g2_2.jpg','image',0),('620',90,'/g/3/g3_2.jpg','image',0),('621',90,'/g/4/g4_2.jpg','image',0),('622',90,'/g/5/g5_1.jpg','image',0),('623',90,'/g/6/g6_1.jpg','image',0),('624',90,'/g/7/g7_1.jpg','image',0),('625',90,'/g/8/g8_1.jpg','image',0),('626',90,'/1/1/11_24.jpg','image',0),('627',90,'/u/n/untitled.jpg','image',0),('628',90,'/u/n/unit.jpg','image',0),('629',90,'/g/h/ghfghj.jpg','image',0),('630',90,'/n/b/nbvn.jpg','image',0),('631',90,'/g/h/ghg.jpg','image',0),('632',90,'/n/b/nbvn_1.jpg','image',0),('633',90,'/f/d/fdfsdf.jpg','image',0),('634',90,'/h/f/hfghgh.jpg','image',0),('635',90,'/k/j/kjkjhkh.jpg','image',0),('636',90,'/c/8/c8.jpg','image',0),('638',90,'/x/x/xx1.jpg','image',0),('639',90,'/x/x/xx2.png','image',0),('640',90,'/x/x/xx3.jpg','image',0),('641',90,'/x/x/xx4.jpg','image',0),('642',90,'/a/1/a1_1.jpg','image',0),('643',90,'/1/_/1_1_6.jpg','image',0),('644',90,'/2/_/2_2_5.jpg','image',0),('645',90,'/3/_/3_2_5.jpg','image',0),('646',90,'/4/_/4_2_5.jpg','image',0),('647',90,'/5/_/5_2_6.jpg','image',0),('648',90,'/6/_/6_2_7.jpg','image',0),('649',90,'/7/_/7_25.jpg','image',0),('650',90,'/8/_/8_24.jpg','image',0),('651',90,'/9/_/9_24.jpg','image',0),('652',90,'/1/0/10_24.jpg','image',0),('653',90,'/1/1/11_25.jpg','image',0),('654',90,'/1/2/12_28.jpg','image',0),('655',90,'/1/3/13_33.jpg','image',0),('656',90,'/a/2/a2_1.jpg','image',0),('657',90,'/a/3/a3_1.jpg','image',0),('658',90,'/a/4/a4_1.jpg','image',0),('659',90,'/a/5/a5_1.jpg','image',0),('660',90,'/a/6/a6_1.jpg','image',0),('661',90,'/a/7/a7.jpg','image',0),('662',90,'/a/8/a8_1.jpg','image',0),('663',90,'/a/9/a9_1.jpg','image',0),('664',90,'/b/1/b1_2.jpg','image',0),('665',90,'/b/2/b2_2.jpg','image',0),('666',90,'/b/3/b3_2.jpg','image',0),('667',90,'/b/4/b4_2.jpg','image',0),('668',90,'/b/5/b5_2.jpg','image',0),('669',90,'/b/6/b6_2.jpg','image',0),('670',90,'/b/7/b7_2.jpg','image',0),('671',90,'/b/8/b8_2.jpg','image',0),('672',90,'/c/1/c1_3.jpg','image',0),('673',90,'/c/2/c2_3.jpg','image',0),('674',90,'/c/3/c3_3.jpg','image',0),('675',90,'/c/4/c4_3.jpg','image',0),('676',90,'/c/5/c5_3.jpg','image',0),('677',90,'/c/6/c6_3.jpg','image',0),('678',90,'/c/7/c7_3.jpg','image',0),('679',90,'/c/8/c8_1.jpg','image',0),('680',90,'/c/9/c9.jpg','image',0),('681',90,'/c/1/c10.jpg','image',0),('682',90,'/c/1/c11.jpg','image',0),('683',90,'/d/4/d4_1.jpg','image',0),('684',90,'/d/2/d2.jpg','image',0),('685',90,'/d/1/d1_1.jpg','image',0),('686',90,'/d/3/d3_1.jpg','image',0),('687',90,'/d/5/d5_1.jpg','image',0),('688',90,'/d/7/d7_1.jpg','image',0),('689',90,'/d/6/d6_1.jpg','image',0),('690',90,'/d/8/d8_1.jpg','image',0),('691',90,'/e/1/e1_2.jpg','image',0),('692',90,'/e/2/e2_2.jpg','image',0),('693',90,'/e/3/e3_2.jpg','image',0),('694',90,'/e/4/e4_2.jpg','image',0),('695',90,'/e/5/e5_2.jpg','image',0),('696',90,'/e/6/e6_2.jpg','image',0),('697',90,'/e/7/e7_2.jpg','image',0),('698',90,'/e/8/e8_1.jpg','image',0),('699',90,'/f/1/f1_2.jpg','image',0),('700',90,'/f/2/f2_2.jpg','image',0),('701',90,'/f/3/f3_2.jpg','image',0),('702',90,'/f/4/f4_2.jpg','image',0),('703',90,'/f/5/f5_2.jpg','image',0),('704',90,'/f/6/f6_2.jpg','image',0),('705',90,'/f/7/f7_1_1.jpg','image',0),('706',90,'/f/8/f8_1_1.jpg','image',0),('707',90,'/f/9/f9_1_1.jpg','image',0),('708',90,'/g/1/g1_2.jpg','image',0),('709',90,'/g/2/g2_1_1.jpg','image',0),('710',90,'/g/3/g3_1_1.jpg','image',0),('711',90,'/g/4/g4_1_1.jpg','image',0),('712',90,'/g/5/g5_2.jpg','image',0),('713',90,'/g/6/g6_2.jpg','image',0),('714',90,'/g/7/g7_2.jpg','image',0),('715',90,'/g/8/g8_2.jpg','image',0),('716',90,'/g/9/g9_1.jpg','image',0),('717',90,'/h/1/h1_1.jpg','image',0),('718',90,'/h/2/h2_1.jpg','image',0),('719',90,'/h/3/h3_1.jpg','image',0),('720',90,'/h/4/h4_1.jpg','image',0),('721',90,'/h/5/h5_1.jpg','image',0),('722',90,'/h/6/h6_1.jpg','image',0),('723',90,'/h/7/h7_1.jpg','image',0),('724',90,'/h/8/h8_1.jpg','image',0),('725',90,'/h/1/h1_2.jpg','image',0),('726',90,'/h/2/h2_2.jpg','image',0),('727',90,'/h/3/h3_2.jpg','image',0),('728',90,'/h/4/h4_2.jpg','image',0),('729',90,'/h/5/h5_2.jpg','image',0),('730',90,'/h/6/h6_2.jpg','image',0),('731',90,'/h/7/h7_2.jpg','image',0),('732',90,'/h/8/h8_2.jpg','image',0),('733',90,'/q/1/q1_1.jpg','image',0),('734',90,'/q/2/q2_1.jpg','image',0),('735',90,'/q/3/q3_1.jpg','image',0),('736',90,'/q/4/q4_1.jpg','image',0),('737',90,'/q/5/q5_1.jpg','image',0),('738',90,'/q/6/q6_1.jpg','image',0),('739',90,'/q/7/q7_1.jpg','image',0),('740',90,'/w/1/w1_1.jpg','image',0),('741',90,'/w/2/w2_1.jpg','image',0),('742',90,'/w/3/w3_1.jpg','image',0),('743',90,'/w/4/w4.png','image',0),('744',90,'/w/5/w5.png','image',0),('745',90,'/w/6/w6.png','image',0),('746',90,'/w/7/w7.png','image',0),('747',90,'/w/8/w8.jpg','image',0),('748',90,'/w/9/w9.png','image',0),('749',90,'/w/1/w10.png','image',0),('750',90,'/i/m/impresora-de-tickets-termica-bematech-usb-serial-y-ethernet-lr2000e.jpg','image',0),('751',90,'/w/8/w8_1.jpg','image',0),('752',90,'/l/v/lv4000u-picture.jpg','image',0),('753',90,'/s/1/s1.jpg','image',0),('754',90,'/s/2/s2.jpg','image',0),('755',90,'/s/3/s3.jpg','image',0),('756',90,'/s/4/s4.jpg','image',0),('757',90,'/s/5/s5.jpg','image',0),('758',90,'/w/1/w12.jpg','image',0),('759',90,'/w/w/ww1_1.jpg','image',0),('760',90,'/w/w/ww2_1.jpg','image',0),('761',90,'/w/w/ww3_1.jpg','image',0),('762',90,'/w/w/ww5_1.jpg','image',0),('763',90,'/w/w/ww4.png','image',0),('768',90,'/z/1/z1.jpg','image',0),('769',90,'/z/2/z2.jpg','image',0),('770',90,'/z/3/z3.jpg','image',0),('771',90,'/z/4/z4.jpg','image',0),('772',90,'/z/z/zz1.jpg','image',0),('773',90,'/z/z/zz2.jpg','image',0),('774',90,'/z/z/zz3.jpg','image',0),('775',90,'/z/z/zz4.jpg','image',0),('776',90,'/z/z/zz5.jpg','image',0),('777',90,'/z/z/zz6z.jpg','image',0),('778',90,'/z/z/zz7.jpg','image',0),('779',90,'/z/z/zz8.jpg','image',0),('780',90,'/d/f/dfs.jpg','image',0),('781',90,'/g/d/gdfgdfs.jpg','image',0),('782',90,'/i/i/ii.jpg','image',0),('783',90,'/z/z/zz9.jpg','image',0),('784',90,'/1/_/1_1_7.jpg','image',0),('785',90,'/2/_/2_2_6.jpg','image',0),('786',90,'/7/_/7_26.jpg','image',0),('787',90,'/3/_/3_2_6.jpg','image',0),('788',90,'/4/_/4_2_6.jpg','image',0),('789',90,'/5/_/5_2_7.jpg','image',0),('790',90,'/6/_/6_2_8.jpg','image',0),('791',90,'/8/_/8_25.jpg','image',0),('792',90,'/9/_/9_25.jpg','image',0),('793',90,'/a/1/a1_2.jpg','image',0),('794',90,'/a/2/a2_2.jpg','image',0),('795',90,'/a/3/a3_2.jpg','image',0),('796',90,'/a/4/a4_2.jpg','image',0),('797',90,'/a/5/a5_2.jpg','image',0),('798',90,'/a/6/a6_2.jpg','image',0),('799',90,'/a/7/a7_1.jpg','image',0),('800',90,'/a/8/a8_2.jpg','image',0),('801',90,'/b/1/b1_3.jpg','image',0),('802',90,'/b/2/b2_3.jpg','image',0),('803',90,'/b/3/b3_3.jpg','image',0),('804',90,'/b/4/b4_3.jpg','image',0),('805',90,'/b/5/b5_3.jpg','image',0),('806',90,'/b/6/b6_3.jpg','image',0),('807',90,'/b/7/b7_3.jpg','image',0),('808',90,'/b/8/b8_3.jpg','image',0),('809',90,'/b/9/b9.png','image',0),('810',90,'/b/9/b9_1.jpg','image',0),('811',90,'/a/a/aa1_1.jpg','image',0),('812',90,'/a/a/aa2_1.jpg','image',0),('813',90,'/a/a/aa3_1.jpg','image',0),('814',90,'/a/a/aa4_1.jpg','image',0),('815',90,'/a/a/aa5_1.jpg','image',0),('816',90,'/a/a/aa6_1.jpg','image',0),('817',90,'/a/a/aa7_1.jpg','image',0),('818',90,'/a/a/aa8.jpg','image',0),('819',90,'/b/b/bb1.jpg','image',0),('820',90,'/b/b/bb2.jpg','image',0),('821',90,'/b/b/bb3.jpg','image',0),('822',90,'/b/b/bb4.jpg','image',0),('823',90,'/b/b/bb5.jpg','image',0),('824',90,'/b/b/bb6.jpg','image',0);
/*!40000 ALTER TABLE `catalog_product_entity_media_gallery` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_entity_media_gallery_value`
--

DROP TABLE IF EXISTS `catalog_product_entity_media_gallery_value`;
CREATE TABLE `catalog_product_entity_media_gallery_value` (
  `value_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Value ID',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `label` varchar(255) DEFAULT NULL COMMENT 'Label',
  `position` int(10) unsigned DEFAULT NULL COMMENT 'Position',
  `disabled` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Is Disabled',
  `record_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Record Id',
  PRIMARY KEY (`record_id`),
  KEY `CATALOG_PRODUCT_ENTITY_MEDIA_GALLERY_VALUE_STORE_ID` (`store_id`),
  KEY `CATALOG_PRODUCT_ENTITY_MEDIA_GALLERY_VALUE_ENTITY_ID` (`entity_id`),
  KEY `CATALOG_PRODUCT_ENTITY_MEDIA_GALLERY_VALUE_VALUE_ID` (`value_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1352 DEFAULT CHARSET=utf8 COMMENT='Catalog Product Media Gallery Attribute Value Table';

--
-- Dumping data for table `catalog_product_entity_media_gallery_value`
--

LOCK TABLES `catalog_product_entity_media_gallery_value` WRITE;
/*!40000 ALTER TABLE `catalog_product_entity_media_gallery_value` DISABLE KEYS */;
INSERT INTO `catalog_product_entity_media_gallery_value` VALUES ('446',0,'77',NULL,'1',0,'749'),('447',0,'77',NULL,'2',0,'750'),('448',0,'77',NULL,'3',0,'751'),('449',0,'77',NULL,'4',0,'752'),('450',0,'77',NULL,'5',0,'753'),('451',0,'77',NULL,'6',0,'754'),('452',0,'77',NULL,'7',0,'755'),('453',0,'78',NULL,'1',0,'769'),('454',0,'78',NULL,'2',0,'770'),('455',0,'78',NULL,'3',0,'771'),('456',0,'78',NULL,'4',0,'772'),('457',0,'78',NULL,'5',0,'773'),('458',0,'78',NULL,'6',0,'774'),('459',0,'78',NULL,'7',0,'775'),('467',0,'80',NULL,'0',0,'776'),('468',0,'80',NULL,'1',0,'777'),('469',0,'80',NULL,'2',0,'778'),('470',0,'80',NULL,'3',0,'779'),('471',0,'80',NULL,'4',0,'780'),('472',0,'80',NULL,'5',0,'781'),('473',0,'81',NULL,'1',0,'782'),('474',0,'81',NULL,'2',0,'783'),('475',0,'81',NULL,'3',0,'784'),('476',0,'81',NULL,'4',0,'785'),('477',0,'82',NULL,'0',0,'794'),('478',0,'82',NULL,'1',0,'795'),('479',0,'82',NULL,'2',0,'796'),('480',0,'82',NULL,'3',0,'797'),('481',0,'83',NULL,'0',0,'798'),('482',0,'83',NULL,'1',0,'799'),('483',0,'83',NULL,'2',0,'800'),('484',0,'83',NULL,'3',0,'801'),('485',0,'84',NULL,'1',0,'802'),('486',0,'84',NULL,'2',0,'803'),('487',0,'84',NULL,'3',0,'804'),('488',0,'85',NULL,'1',0,'805'),('489',0,'85',NULL,'2',0,'806'),('490',0,'85',NULL,'3',0,'807'),('491',0,'85',NULL,'4',0,'808'),('492',0,'85',NULL,'5',0,'809'),('493',0,'86',NULL,'0',0,'816'),('494',0,'86',NULL,'1',0,'817'),('495',0,'86',NULL,'2',0,'818'),('496',0,'86',NULL,'3',0,'819'),('497',0,'86',NULL,'4',0,'820'),('498',0,'86',NULL,'5',0,'821'),('514',0,'89',NULL,'1',0,'837'),('515',0,'89',NULL,'2',0,'838'),('516',0,'89',NULL,'3',0,'839'),('517',0,'89',NULL,'4',0,'840'),('518',0,'89',NULL,'5',0,'841'),('519',0,'90',NULL,'1',0,'842'),('520',0,'90',NULL,'2',0,'843'),('521',0,'90',NULL,'3',0,'844'),('522',0,'90',NULL,'4',0,'845'),('523',0,'90',NULL,'5',0,'846'),('524',0,'90',NULL,'6',0,'847'),('525',0,'90',NULL,'7',0,'848'),('526',0,'91',NULL,'1',0,'849'),('527',0,'91',NULL,'2',0,'850'),('528',0,'92',NULL,'0',0,'851'),('529',0,'92',NULL,'1',0,'852'),('530',0,'92',NULL,'2',0,'853'),('531',0,'93',NULL,'1',0,'854'),('532',0,'93',NULL,'2',0,'855'),('533',0,'93',NULL,'3',0,'856'),('534',0,'93',NULL,'4',0,'857'),('535',0,'93',NULL,'5',0,'858'),('536',0,'93',NULL,'6',0,'859'),('537',0,'93',NULL,'7',0,'860'),('538',0,'93',NULL,'8',0,'861'),('539',0,'94',NULL,'0',0,'867'),('540',0,'94',NULL,'1',0,'868'),('541',0,'94',NULL,'2',0,'869'),('542',0,'94',NULL,'3',0,'870'),('543',0,'94',NULL,'4',0,'871'),('547',0,'96',NULL,'1',0,'878'),('548',0,'96',NULL,'2',0,'879'),('549',0,'96',NULL,'3',0,'880'),('550',0,'96',NULL,'4',0,'881'),('551',0,'97',NULL,'1',0,'882'),('552',0,'97',NULL,'2',0,'883'),('553',0,'97',NULL,'3',0,'884'),('554',0,'97',NULL,'4',0,'885'),('555',0,'97',NULL,'5',0,'886'),('556',0,'97',NULL,'6',0,'887'),('557',0,'98',NULL,'1',0,'888'),('558',0,'98',NULL,'2',0,'889'),('559',0,'98',NULL,'3',0,'890'),('560',0,'98',NULL,'4',0,'891'),('561',0,'98',NULL,'5',0,'892'),('562',0,'99',NULL,'1',0,'893'),('563',0,'99',NULL,'2',0,'894'),('564',0,'99',NULL,'3',0,'895'),('565',0,'99',NULL,'4',0,'896'),('566',0,'99',NULL,'5',0,'897'),('567',0,'99',NULL,'6',0,'898'),('568',0,'99',NULL,'7',0,'899'),('569',0,'99',NULL,'8',0,'900'),('570',0,'100',NULL,'1',0,'901'),('571',0,'100',NULL,'2',0,'902'),('572',0,'100',NULL,'3',0,'903'),('573',0,'100',NULL,'4',0,'904'),('574',0,'100',NULL,'5',0,'905'),('575',0,'100',NULL,'6',0,'906'),('576',0,'100',NULL,'7',0,'907'),('577',0,'101',NULL,'1',0,'908'),('578',0,'101',NULL,'2',0,'909'),('579',0,'102',NULL,'1',0,'910'),('580',0,'102',NULL,'2',0,'911'),('581',0,'102',NULL,'3',0,'912'),('582',0,'102',NULL,'4',0,'913'),('583',0,'103',NULL,'1',0,'914'),('584',0,'103',NULL,'2',0,'915'),('585',0,'103',NULL,'3',0,'916'),('586',0,'103',NULL,'4',0,'917'),('591',0,'105',NULL,'1',0,'922'),('592',0,'105',NULL,'2',0,'923'),('593',0,'105',NULL,'3',0,'924'),('594',0,'105',NULL,'4',0,'925'),('595',0,'105',NULL,'5',0,'926'),('596',0,'105',NULL,'6',0,'927'),('597',0,'106',NULL,'1',0,'928'),('598',0,'106',NULL,'2',0,'929'),('599',0,'106',NULL,'3',0,'930'),('600',0,'106',NULL,'4',0,'931'),('601',0,'106',NULL,'5',0,'932'),('602',0,'106',NULL,'6',0,'933'),('603',0,'108',NULL,'1',0,'937'),('605',0,'109',NULL,'2',0,'938'),('606',0,'110',NULL,'1',0,'939'),('607',0,'110',NULL,'2',0,'940'),('608',0,'110',NULL,'3',0,'941'),('609',0,'110',NULL,'4',0,'942'),('610',0,'110',NULL,'5',0,'943'),('611',0,'110',NULL,'6',0,'944'),('612',0,'110',NULL,'7',0,'945'),('613',0,'110',NULL,'8',0,'946'),('614',0,'110',NULL,'9',0,'947'),('615',0,'110',NULL,'10',0,'948'),('616',0,'110',NULL,'11',0,'949'),('617',0,'110',NULL,'12',0,'950'),('618',0,'111',NULL,'1',0,'951'),('619',0,'111',NULL,'2',0,'952'),('620',0,'111',NULL,'3',0,'953'),('621',0,'111',NULL,'4',0,'954'),('622',0,'111',NULL,'5',0,'955'),('623',0,'111',NULL,'6',0,'956'),('624',0,'111',NULL,'7',0,'957'),('625',0,'111',NULL,'8',0,'958'),('626',0,'112',NULL,'1',0,'959'),('627',0,'113',NULL,'1',0,'960'),('628',0,'114',NULL,'1',0,'961'),('629',0,'115',NULL,'1',0,'962'),('630',0,'116',NULL,'1',0,'963'),('631',0,'117',NULL,'1',0,'964'),('632',0,'118',NULL,'1',0,'965'),('633',0,'119',NULL,'1',0,'966'),('634',0,'120',NULL,'1',0,'967'),('635',0,'121',NULL,'1',0,'968'),('636',0,'122',NULL,'1',0,'969'),('638',0,'123',NULL,'2',0,'971'),('639',0,'124',NULL,'1',0,'972'),('640',0,'125',NULL,'1',0,'973'),('641',0,'125',NULL,'2',0,'974'),('642',0,'126',NULL,'1',0,'975'),('643',0,'127',NULL,'1',0,'976'),('644',0,'127',NULL,'2',0,'977'),('645',0,'127',NULL,'3',0,'978'),('646',0,'127',NULL,'4',0,'979'),('647',0,'128',NULL,'1',0,'980'),('648',0,'129',NULL,'1',0,'981'),('649',0,'129',NULL,'2',0,'982'),('650',0,'130',NULL,'1',0,'983'),('651',0,'130',NULL,'2',0,'984'),('652',0,'131',NULL,'1',0,'985'),('653',0,'132',NULL,'1',0,'986'),('654',0,'132',NULL,'2',0,'987'),('655',0,'132',NULL,'3',0,'988'),('656',0,'133',NULL,'1',0,'989'),('657',0,'133',NULL,'2',0,'990'),('658',0,'133',NULL,'3',0,'991'),('659',0,'133',NULL,'4',0,'992'),('664',0,'135',NULL,'1',0,'997'),('665',0,'135',NULL,'2',0,'998'),('666',0,'135',NULL,'3',0,'999'),('667',0,'135',NULL,'4',0,'1000'),('660',0,'134',NULL,'1',0,'1001'),('661',0,'134',NULL,'2',0,'1002'),('662',0,'134',NULL,'3',0,'1003'),('663',0,'134',NULL,'4',0,'1004'),('668',0,'136',NULL,'1',0,'1005'),('669',0,'136',NULL,'2',0,'1006'),('670',0,'136',NULL,'3',0,'1007'),('671',0,'136',NULL,'4',0,'1008'),('677',0,'139',NULL,'1',0,'1014'),('678',0,'139',NULL,'2',0,'1015'),('679',0,'139',NULL,'3',0,'1016'),('680',0,'139',NULL,'4',0,'1017'),('681',0,'140',NULL,'1',0,'1021'),('682',0,'141',NULL,'1',0,'1022'),('683',0,'142',NULL,'0',0,'1023'),('684',0,'142',NULL,'1',0,'1024'),('685',0,'142',NULL,'2',0,'1025'),('686',0,'142',NULL,'3',0,'1026'),('687',0,'143',NULL,'0',0,'1027'),('688',0,'143',NULL,'1',0,'1028'),('689',0,'143',NULL,'2',0,'1029'),('690',0,'143',NULL,'3',0,'1030'),('691',0,'144',NULL,'1',0,'1031'),('692',0,'144',NULL,'2',0,'1032'),('693',0,'144',NULL,'3',0,'1033'),('694',0,'144',NULL,'4',0,'1034'),('695',0,'144',NULL,'5',0,'1035'),('696',0,'145',NULL,'1',0,'1039'),('697',0,'145',NULL,'2',0,'1040'),('698',0,'145',NULL,'3',0,'1041'),('699',0,'146',NULL,'1',0,'1042'),('700',0,'146',NULL,'2',0,'1043'),('701',0,'146',NULL,'3',0,'1044'),('702',0,'146',NULL,'4',0,'1045'),('703',0,'147',NULL,'1',0,'1046'),('704',0,'148',NULL,'1',0,'1047'),('705',0,'148',NULL,'5',0,'1048'),('706',0,'148',NULL,'6',0,'1049'),('707',0,'148',NULL,'7',0,'1050'),('711',0,'150',NULL,'1',0,'1054'),('712',0,'150',NULL,'2',0,'1055'),('713',0,'150',NULL,'3',0,'1056'),('714',0,'151',NULL,'1',0,'1057'),('715',0,'151',NULL,'2',0,'1058'),('716',0,'151',NULL,'3',0,'1059'),('717',0,'152',NULL,'1',0,'1060'),('718',0,'152',NULL,'2',0,'1061'),('719',0,'152',NULL,'3',0,'1062'),('720',0,'152',NULL,'4',0,'1063'),('721',0,'152',NULL,'5',0,'1064'),('722',0,'152',NULL,'6',0,'1065'),('723',0,'152',NULL,'7',0,'1066'),('724',0,'152',NULL,'8',0,'1067'),('725',0,'153',NULL,'1',0,'1068'),('726',0,'153',NULL,'2',0,'1069'),('727',0,'153',NULL,'3',0,'1070'),('728',0,'153',NULL,'4',0,'1071'),('729',0,'153',NULL,'5',0,'1072'),('730',0,'153',NULL,'6',0,'1073'),('731',0,'153',NULL,'7',0,'1074'),('732',0,'153',NULL,'8',0,'1075'),('733',0,'154',NULL,'1',0,'1076'),('734',0,'154',NULL,'2',0,'1077'),('735',0,'154',NULL,'3',0,'1078'),('736',0,'154',NULL,'4',0,'1079'),('737',0,'154',NULL,'5',0,'1080'),('738',0,'155',NULL,'1',0,'1081'),('739',0,'155',NULL,'2',0,'1082'),('740',0,'156',NULL,'1',0,'1083'),('741',0,'156',NULL,'2',0,'1084'),('742',0,'156',NULL,'3',0,'1085'),('743',0,'156',NULL,'4',0,'1086'),('744',0,'156',NULL,'5',0,'1087'),('745',0,'156',NULL,'6',0,'1088'),('746',0,'157',NULL,'1',0,'1090'),('747',0,'158',NULL,'1',0,'1091'),('748',0,'158',NULL,'2',0,'1092'),('749',0,'158',NULL,'3',0,'1093'),('750',0,'159',NULL,'1',0,'1094'),('751',0,'159',NULL,'2',0,'1095'),('752',0,'160',NULL,'1',0,'1096'),('753',0,'161',NULL,'1',0,'1097'),('754',0,'161',NULL,'2',0,'1098'),('755',0,'161',NULL,'3',0,'1099'),('756',0,'161',NULL,'4',0,'1100'),('757',0,'161',NULL,'5',0,'1101'),('758',0,'162',NULL,'1',0,'1102'),('759',0,'163',NULL,'1',0,'1103'),('760',0,'163',NULL,'2',0,'1104'),('761',0,'163',NULL,'3',0,'1105'),('762',0,'164',NULL,'0',0,'1106'),('763',0,'164',NULL,'1',0,'1107'),('768',0,'169',NULL,'1',0,'1112'),('769',0,'169',NULL,'2',0,'1113'),('770',0,'169',NULL,'3',0,'1114'),('771',0,'169',NULL,'4',0,'1115'),('782',0,'172',NULL,'1',0,'1126'),('780',0,'171',NULL,'1',0,'1127'),('781',0,'171',NULL,'2',0,'1128'),('783',0,'173',NULL,'1',0,'1129'),('784',0,'174',NULL,'1',0,'1130'),('785',0,'174',NULL,'2',0,'1131'),('786',0,'175',NULL,'0',0,'1132'),('787',0,'175',NULL,'1',0,'1133'),('788',0,'175',NULL,'2',0,'1134'),('789',0,'175',NULL,'3',0,'1135'),('790',0,'175',NULL,'4',0,'1136'),('791',0,'176',NULL,'1',0,'1137'),('792',0,'176',NULL,'2',0,'1138'),('793',0,'177',NULL,'1',0,'1139'),('794',0,'177',NULL,'2',0,'1140'),('795',0,'177',NULL,'3',0,'1141'),('796',0,'177',NULL,'4',0,'1142'),('797',0,'178',NULL,'1',0,'1143'),('798',0,'178',NULL,'2',0,'1144'),('799',0,'178',NULL,'3',0,'1145'),('800',0,'178',NULL,'4',0,'1146'),('801',0,'179',NULL,'1',0,'1147'),('802',0,'179',NULL,'2',0,'1148'),('803',0,'180',NULL,'1',0,'1149'),('804',0,'180',NULL,'2',0,'1150'),('805',0,'180',NULL,'3',0,'1151'),('806',0,'181',NULL,'1',0,'1154'),('807',0,'181',NULL,'2',0,'1155'),('808',0,'182',NULL,'1',0,'1156'),('809',0,'182',NULL,'2',0,'1157'),('772',0,'170',NULL,'1',0,'1209'),('773',0,'170',NULL,'2',0,'1210'),('774',0,'170',NULL,'3',0,'1211'),('775',0,'170',NULL,'4',0,'1212'),('776',0,'170',NULL,'5',0,'1213'),('777',0,'170',NULL,'6',0,'1214'),('778',0,'170',NULL,'7',0,'1215'),('779',0,'170',NULL,'8',0,'1216'),('506',0,'88',NULL,'1',0,'1234'),('507',0,'88',NULL,'2',0,'1235'),('508',0,'88',NULL,'3',0,'1236'),('509',0,'88',NULL,'4',0,'1237'),('510',0,'88',NULL,'5',0,'1238'),('511',0,'88',NULL,'6',0,'1239'),('512',0,'88',NULL,'7',0,'1240'),('513',0,'88',NULL,'8',0,'1241'),('499',0,'87',NULL,'1',0,'1249'),('500',0,'87',NULL,'2',0,'1250'),('501',0,'87',NULL,'3',0,'1251'),('502',0,'87',NULL,'4',0,'1252'),('503',0,'87',NULL,'5',0,'1253'),('504',0,'87',NULL,'6',0,'1254'),('505',0,'87',NULL,'7',0,'1255'),('460',0,'79',NULL,'0',0,'1256'),('461',0,'79',NULL,'1',0,'1257'),('462',0,'79',NULL,'2',0,'1258'),('463',0,'79',NULL,'3',0,'1259'),('464',0,'79',NULL,'4',0,'1260'),('465',0,'79',NULL,'5',0,'1261'),('466',0,'79',NULL,'6',0,'1262'),('674',0,'138',NULL,'1',0,'1263'),('675',0,'138',NULL,'2',0,'1264'),('676',0,'138',NULL,'3',0,'1265'),('587',0,'104',NULL,'1',0,'1266'),('588',0,'104',NULL,'2',0,'1267'),('589',0,'104',NULL,'3',0,'1268'),('590',0,'104',NULL,'4',0,'1269'),('708',0,'149',NULL,'1',0,'1270'),('709',0,'149',NULL,'4',0,'1271'),('710',0,'149',NULL,'5',0,'1272'),('810',0,'183',NULL,'1',0,'1273'),('672',0,'137',NULL,'1',0,'1274'),('673',0,'137',NULL,'2',0,'1275'),('811',0,'184',NULL,'1',0,'1290'),('812',0,'184',NULL,'2',0,'1291'),('813',0,'184',NULL,'3',0,'1292'),('814',0,'184',NULL,'4',0,'1293'),('815',0,'184',NULL,'5',0,'1294'),('816',0,'184',NULL,'6',0,'1295'),('817',0,'184',NULL,'7',0,'1296'),('818',0,'184',NULL,'8',0,'1297'),('544',0,'95',NULL,'1',0,'1313'),('545',0,'95',NULL,'2',0,'1314'),('546',0,'95',NULL,'3',0,'1315'),('819',0,'185',NULL,'1',0,'1322'),('820',0,'185',NULL,'2',0,'1323'),('821',0,'185',NULL,'3',0,'1324'),('822',0,'185',NULL,'4',0,'1325'),('823',0,'185',NULL,'5',0,'1326'),('824',0,'185',NULL,'6',0,'1327'),('438',0,'76',NULL,'0',0,'1328'),('439',0,'76',NULL,'1',0,'1329'),('440',0,'76',NULL,'2',0,'1330'),('441',0,'76',NULL,'3',0,'1331'),('442',0,'76',NULL,'4',0,'1332'),('443',0,'76',NULL,'5',0,'1333'),('444',0,'76',NULL,'6',0,'1334'),('445',0,'76',NULL,'7',0,'1335'),('438',13,'76',NULL,'0',0,'1344'),('439',13,'76',NULL,'1',0,'1345'),('440',13,'76',NULL,'2',0,'1346'),('441',13,'76',NULL,'3',0,'1347'),('442',13,'76',NULL,'4',0,'1348'),('443',13,'76',NULL,'5',0,'1349'),('444',13,'76',NULL,'6',0,'1350'),('445',13,'76',NULL,'7',0,'1351');
/*!40000 ALTER TABLE `catalog_product_entity_media_gallery_value` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_entity_media_gallery_value_to_entity`
--

DROP TABLE IF EXISTS `catalog_product_entity_media_gallery_value_to_entity`;
CREATE TABLE `catalog_product_entity_media_gallery_value_to_entity` (
  `value_id` int(10) unsigned NOT NULL COMMENT 'Value media Entry ID',
  `entity_id` int(10) unsigned NOT NULL COMMENT 'Product entity ID',
  UNIQUE KEY `CAT_PRD_ENTT_MDA_GLR_VAL_TO_ENTT_VAL_ID_ENTT_ID` (`value_id`,`entity_id`),
  KEY `CAT_PRD_ENTT_MDA_GLR_VAL_TO_ENTT_ENTT_ID_CAT_PRD_ENTT_ENTT_ID` (`entity_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Link Media value to Product entity table';

--
-- Dumping data for table `catalog_product_entity_media_gallery_value_to_entity`
--

LOCK TABLES `catalog_product_entity_media_gallery_value_to_entity` WRITE;
/*!40000 ALTER TABLE `catalog_product_entity_media_gallery_value_to_entity` DISABLE KEYS */;
INSERT INTO `catalog_product_entity_media_gallery_value_to_entity` VALUES ('438','76'),('439','76'),('440','76'),('441','76'),('442','76'),('443','76'),('444','76'),('445','76'),('446','77'),('447','77'),('448','77'),('449','77'),('450','77'),('451','77'),('452','77'),('453','78'),('454','78'),('455','78'),('456','78'),('457','78'),('458','78'),('459','78'),('460','79'),('461','79'),('462','79'),('463','79'),('464','79'),('465','79'),('466','79'),('467','80'),('468','80'),('469','80'),('470','80'),('471','80'),('472','80'),('473','81'),('474','81'),('475','81'),('476','81'),('477','82'),('478','82'),('479','82'),('480','82'),('481','83'),('482','83'),('483','83'),('484','83'),('485','84'),('486','84'),('487','84'),('488','85'),('489','85'),('490','85'),('491','85'),('492','85'),('493','86'),('494','86'),('495','86'),('496','86'),('497','86'),('498','86'),('499','87'),('500','87'),('501','87'),('502','87'),('503','87'),('504','87'),('505','87'),('506','88'),('507','88'),('508','88'),('509','88'),('510','88'),('511','88'),('512','88'),('513','88'),('514','89'),('515','89'),('516','89'),('517','89'),('518','89'),('519','90'),('520','90'),('521','90'),('522','90'),('523','90'),('524','90'),('525','90'),('526','91'),('527','91'),('528','92'),('529','92'),('530','92'),('531','93'),('532','93'),('533','93'),('534','93'),('535','93'),('536','93'),('537','93'),('538','93'),('539','94'),('540','94'),('541','94'),('542','94'),('543','94'),('544','95'),('545','95'),('546','95'),('547','96'),('548','96'),('549','96'),('550','96'),('551','97'),('552','97'),('553','97'),('554','97'),('555','97'),('556','97'),('557','98'),('558','98'),('559','98'),('560','98'),('561','98'),('562','99'),('563','99'),('564','99'),('565','99'),('566','99'),('567','99'),('568','99'),('569','99'),('570','100'),('571','100'),('572','100'),('573','100'),('574','100'),('575','100'),('576','100'),('577','101'),('578','101'),('579','102'),('580','102'),('581','102'),('582','102'),('583','103'),('584','103'),('585','103'),('586','103'),('587','104'),('588','104'),('589','104'),('590','104'),('591','105'),('592','105'),('593','105'),('594','105'),('595','105'),('596','105'),('597','106'),('598','106'),('599','106'),('600','106'),('601','106'),('602','106'),('603','108'),('605','109'),('606','110'),('607','110'),('608','110'),('609','110'),('610','110'),('611','110'),('612','110'),('613','110'),('614','110'),('615','110'),('616','110'),('617','110'),('618','111'),('619','111'),('620','111'),('621','111'),('622','111'),('623','111'),('624','111'),('625','111'),('626','112'),('627','113'),('628','114'),('629','115'),('630','116'),('631','117'),('632','118'),('633','119'),('634','120'),('635','121'),('636','122'),('638','123'),('639','124'),('640','125'),('641','125'),('642','126'),('643','127'),('644','127'),('645','127'),('646','127'),('647','128'),('648','129'),('649','129'),('650','130'),('651','130'),('652','131'),('653','132'),('654','132'),('655','132'),('656','133'),('657','133'),('658','133'),('659','133'),('660','134'),('661','134'),('662','134'),('663','134'),('664','135'),('665','135'),('666','135'),('667','135'),('668','136'),('669','136'),('670','136'),('671','136'),('672','137'),('673','137'),('674','138'),('675','138'),('676','138'),('677','139'),('678','139'),('679','139'),('680','139'),('681','140'),('682','141'),('683','142'),('684','142'),('685','142'),('686','142'),('687','143'),('688','143'),('689','143'),('690','143'),('691','144'),('692','144'),('693','144'),('694','144'),('695','144'),('696','145'),('697','145'),('698','145'),('699','146'),('700','146'),('701','146'),('702','146'),('703','147'),('704','148'),('705','148'),('706','148'),('707','148'),('708','149'),('709','149'),('710','149'),('711','150'),('712','150'),('713','150'),('714','151'),('715','151'),('716','151'),('717','152'),('718','152'),('719','152'),('720','152'),('721','152'),('722','152'),('723','152'),('724','152'),('725','153'),('726','153'),('727','153'),('728','153'),('729','153'),('730','153'),('731','153'),('732','153'),('733','154'),('734','154'),('735','154'),('736','154'),('737','154'),('738','155'),('739','155'),('740','156'),('741','156'),('742','156'),('743','156'),('744','156'),('745','156'),('746','157'),('747','158'),('748','158'),('749','158'),('750','159'),('751','159'),('752','160'),('753','161'),('754','161'),('755','161'),('756','161'),('757','161'),('758','162'),('759','163'),('760','163'),('761','163'),('762','164'),('763','164'),('768','169'),('769','169'),('770','169'),('771','169'),('772','170'),('773','170'),('774','170'),('775','170'),('776','170'),('777','170'),('778','170'),('779','170'),('780','171'),('781','171'),('782','172'),('783','173'),('784','174'),('785','174'),('786','175'),('787','175'),('788','175'),('789','175'),('790','175'),('791','176'),('792','176'),('793','177'),('794','177'),('795','177'),('796','177'),('797','178'),('798','178'),('799','178'),('800','178'),('801','179'),('802','179'),('803','180'),('804','180'),('805','180'),('806','181'),('807','181'),('808','182'),('809','182'),('810','183'),('811','184'),('812','184'),('813','184'),('814','184'),('815','184'),('816','184'),('817','184'),('818','184'),('819','185'),('820','185'),('821','185'),('822','185'),('823','185'),('824','185');
/*!40000 ALTER TABLE `catalog_product_entity_media_gallery_value_to_entity` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `catalog_product_entity_media_gallery_value_video`
--

DROP TABLE IF EXISTS `catalog_product_entity_media_gallery_value_video`;
CREATE TABLE `catalog_product_entity_media_gallery_value_video` (
  `value_id` int(10) unsigned NOT NULL COMMENT 'Media Entity ID',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `provider` varchar(32) DEFAULT NULL COMMENT 'Video provider ID',
  `url` text COMMENT 'Video URL',
  `title` varchar(255) DEFAULT NULL COMMENT 'Title',
  `description` text COMMENT 'Page Meta Description',
  `metadata` text COMMENT 'Video meta data',
  UNIQUE KEY `CAT_PRD_ENTT_MDA_GLR_VAL_VIDEO_VAL_ID_STORE_ID` (`value_id`,`store_id`),
  KEY `CAT_PRD_ENTT_MDA_GLR_VAL_VIDEO_STORE_ID_STORE_STORE_ID` (`store_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Catalog Product Video Table';

--
-- Table structure for table `catalog_product_entity_text`
--

DROP TABLE IF EXISTS `catalog_product_entity_text`;
CREATE TABLE `catalog_product_entity_text` (
  `value_id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Value ID',
  `attribute_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Attribute ID',
  `store_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'Store ID',
  `entity_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Entity ID',
  `value` text COMMENT 'Value',
  PRIMARY KEY (`value_id`),
  UNIQUE KEY `CATALOG_PRODUCT_ENTITY_TEXT_ENTITY_ID_ATTRIBUTE_ID_STORE_ID` (`entity_id`,`attribute_id`,`store_id`),
  KEY `CATALOG_PRODUCT_ENTITY_TEXT_ATTRIBUTE_ID` (`attribute_id`),
  KEY `CATALOG_PRODUCT_ENTITY_TEXT_STORE_ID` (`store_id`)
) ENGINE=InnoDB AUTO_INCREMENT=557 DEFAULT CHARSET=utf8 COMMENT='Catalog Product Text Attribute Backend Table';

--
-- Dumping data for table `catalog_product_entity_text`
--

LOCK TABLES `catalog_product_entity_text` WRITE;
/*!40000 ALTER TABLE `catalog_product_entity_text` DISABLE KEYS */;
INSERT INTO `catalog_product_entity_text` VALUES ('224',75,0,'76','<div class=\"ov-wrapper js-overview-desc\">\r\n<div class=\"ov-desc\">\r\n<table class=\"specTable\" data-selenium=\"specTable\">\r\n<tbody data-selenium=\"specBody\">\r\n<tr><th class=\"specHeader Header\" colspan=\"2\" data-selenium=\"specHeader\"><a id=\"11011\" class=\"fs32 OpenSans-300-normal\" name=\"11011\" data-selenium=\"specHeaderLink\"></a>Performance</th></tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Processor</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Intel Core i5-6300U Dual-Core</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Base Clock Speed</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">2.4 GHz</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Maximum Boost Speed</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">3.0 GHz</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Total Installed Memory</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">4 GB</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Maximum Memory Capacity</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">32 GB</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Memory Type</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">DDR4 SDRAM</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Memory Speed</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">2400 MHz</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">User-Replaceable Memory</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">1 x 4 GB</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Available Memory Slots</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">1</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Memory Slot Type</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">260-Pin SO-DIMM</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Graphics Type</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Integrated</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">GPU</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Intel HD Graphics 520</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<table class=\"specTable\" data-selenium=\"specTable\">\r\n<tbody data-selenium=\"specBody\">\r\n<tr><th class=\"specHeader Header\" colspan=\"2\" data-selenium=\"specHeader\"><a id=\"8004\" class=\"fs32 OpenSans-300-normal\" name=\"8004\" data-selenium=\"specHeaderLink\"></a>Display</th></tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Panel Type</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">IPS</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Size</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">15.6\"</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Aspect Ratio</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">16:9</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Native Resolution</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">1920 x 1080</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Touchscreen</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\"><i>None</i></td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Finish</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Matte</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Maximum Brightness</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">250 cd/m<sup>2</sup></td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Viewing Angle</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">170° Horizontal, 170° Vertical</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<table class=\"specTable\" data-selenium=\"specTable\">\r\n<tbody data-selenium=\"specBody\">\r\n<tr><th class=\"specHeader Header\" colspan=\"2\" data-selenium=\"specHeader\"><a id=\"15001\" class=\"fs32 OpenSans-300-normal\" name=\"15001\" data-selenium=\"specHeaderLink\"></a>Drives</th></tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Available Slots</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\"><span class=\"notSpecfMon\">Not Specified by Manufacturer</span></td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Total Capacity</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">500 GB</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Hard Disk Storage</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">1 x 500 GB 2.5\" SATA (7200 rpm)</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Optical Drive</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\"><i>None</i></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<table class=\"specTable\" data-selenium=\"specTable\">\r\n<tbody data-selenium=\"specBody\">\r\n<tr><th class=\"specHeader Header\" colspan=\"2\" data-selenium=\"specHeader\"><a id=\"8007\" class=\"fs32 OpenSans-300-normal\" name=\"8007\" data-selenium=\"specHeaderLink\"></a>Input/Output Connectors</th></tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Ports</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">3 x USB 3.1 Gen 1 Type-A<br />1 x Thunderbolt 3</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Display</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">1 x HDMI 1.4</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Audio</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">1 x 1/8\" (3.5 mm) Headphone/Microphone Combo Jack<br />Integrated Microphone<br />Integrated Speaker</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Expansion Slots</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\"><span class=\"notSpecfMon\">Not Specified by Manufacturer</span></td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Media Card Slots</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">SD/SDHC/SDXC<br />MMC</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<table class=\"specTable\" data-selenium=\"specTable\">\r\n<tbody data-selenium=\"specBody\">\r\n<tr><th class=\"specHeader Header\" colspan=\"2\" data-selenium=\"specHeader\"><a id=\"15002\" class=\"fs32 OpenSans-300-normal\" name=\"15002\" data-selenium=\"specHeaderLink\"></a>Communications</th></tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Network</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">1 x 10/100/1000 Mb/s Gigabit Ethernet (RJ45)</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Modem</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\"><i>None</i></td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Wi-Fi</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">802.11ac</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">MU-MIMO Support</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">2 x 2</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Bluetooth</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Bluetooth 4.1</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Mobile Broadband</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\"><i>None</i></td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">GPS</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\"><i>None</i></td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">NFC</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\"><i>None</i></td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Webcam</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">User-Facing: 720p Video</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<table class=\"specTable\" data-selenium=\"specTable\">\r\n<tbody data-selenium=\"specBody\">\r\n<tr><th class=\"specHeader Header\" colspan=\"2\" data-selenium=\"specHeader\"><a id=\"192175\" class=\"fs32 OpenSans-300-normal\" name=\"192175\" data-selenium=\"specHeaderLink\"></a>Battery</th></tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Battery Chemistry</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Lithium-Ion Polymer</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Watt Hours / Type</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">32 Wh<br />24 Wh</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Maximum Runtime</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">13.8 Hours</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Power Requirements</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\"><span class=\"notSpecfMon\">Not Specified by Manufacturer</span></td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Power Supply</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">1 x 45 W</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<table class=\"specTable\" data-selenium=\"specTable\">\r\n<tbody data-selenium=\"specBody\">\r\n<tr><th class=\"specHeader Header\" colspan=\"2\" data-selenium=\"specHeader\"><a id=\"8008\" class=\"fs32 OpenSans-300-normal\" name=\"8008\" data-selenium=\"specHeaderLink\"></a>General</th></tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Operating System</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Windows 7 Professional (64-Bit)</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Security</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">HDD User Password Protection, Power-On Password, Accepts 3rd Party Security Lock Devices, Infineon TPM Software Professional Package, Fingerprint Reader</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Keyboard</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Type: Standard Notebook Keyboard<br />Features: Backlight</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Pointing Device</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">TouchPad &amp; Pointing Stick</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Dimensions (W x H x D)</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">14.4 x 0.8 x 10.0\" / 365.8 x 20.3 x 254.0 mm</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Weight</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">4.34 lb / 1.97 kg</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n</div>'),('225',76,0,'76','<ul class=\"top-section-list\" data-selenium=\"highlightList\">\r\n<li class=\"top-section-list-item\">2.4 GHz Intel Core i5-6300U Dual-Core</li>\r\n<li class=\"top-section-list-item\">4GB DDR4 RAM | 500GB 7200 rpm HDD</li>\r\n<li class=\"top-section-list-item\">15.6\" 1920 x 1080 Display</li>\r\n<li class=\"top-section-list-item\">Integrated Intel HD Graphics 520</li>\r\n<li class=\"top-section-list-item\">4-in-1 Media Card Reader</li>\r\n<li class=\"top-section-list-item\">802.11ac Wi-Fi | Bluetooth 4.1</li>\r\n<li class=\"top-section-list-item\">USB 3.0 | Thunderbolt 3 | HDMI</li>\r\n<li class=\"top-section-list-item\">Windows 7 Pro + Windows 10 Pro License</li>\r\n</ul>\r\n<div class=\"ov-wrapper js-overview-desc\">\r\n<div class=\"ov-desc\">\r\n<p class=\"ov-desc-paragraph\">The <strong>15.6\" ThinkPad T570 Notebook from Lenovo</strong> is a business-oriented system made for users who are constantly on-the-go. It features a fingerprint reader, TPM 2.0, vPro, as well as power-on and hard disk password protection to keep your system secure. Specs-wise, it\'s equipped with a 2.4 GHz Intel Core i5-6300U dual-core processor, 4GB of DDR4 RAM, integrated Intel HD graphics, and a 500GB 7200 rpm HDD. Furthermore, its 15.6\" display is built on an IPS panel and has a 1920 x 1080 resolution for crisp and clear Full HD content playback. Other integrated features include a 4-in-1 media card reader for transferring files from mobile devices, 802.11ac Wi-Fi, Bluetooth 4.1, multiple USB ports, a Thunderbolt 3 port, an HDMI port, speakers, a webcam with dual microphones, and a 3.5mm mic and headphone combo jack. The operating system installed is Windows 7 Pro (64-Bit), and it comes with a Windows 10 Pro upgrade license.</p>\r\n</div>\r\n</div>\r\n<div class=\"sectionHeaders js-hiddenFeatures\" data-selenium=\"sectionHeaders\"><dl class=\"js-featureSectionDL\"><dt class=\"featureTitle\"><strong>Durability</strong></dt><dd class=\"c28\">ThinkPad laptops undergo 12 military tests and over 200 quality checks to ensure that they are durable enough for everyday use.</dd></dl><dl class=\"js-featureSectionDL\"><dt class=\"featureTitle\"><strong>Fingerprint Reader</strong></dt><dd class=\"c28\">This notebook features a fingerprint reader so you can secure the system and easily log into Windows without remembering your password.</dd></dl><dl class=\"js-featureSectionDL\"><dt class=\"featureTitle\"><strong>Dual Batteries</strong></dt><dd class=\"c28\">The ThinkPad T570 is built with dual batteries, which can last up to 13 hours of use on a single charge. Actual battery life will depend on usage.</dd></dl><dl class=\"js-featureSectionDL\"><dt class=\"featureTitle\"><strong>Enhanced TrackPad &amp; TrackPoint</strong></dt><dd class=\"c28\">Upgraded with a better TrackPad and TrackPoint, the T570 will have less jumps and gaps when scrolling for smoother and more accurate navigation.</dd></dl><dl class=\"js-featureSectionDL\"><dt class=\"featureTitle\"><strong>Thunderbolt 3</strong></dt><dd class=\"c28\">Thunderbolt 3 is a hardware interface that utilizes the reversible USB Type-C connector. Doubling the speed of its predecessor, Thunderbolt 3 features a maximum throughput of 40 Gb/s when used with compatible devices. The connector also transmits data via USB 3.1 at up to 10 Gb/s, and dual-bandwidth DisplayPort 1.2 allows you to connect up to two 4K displays simultaneously. Additionally, you can daisy chain up to six devices from a single Thunderbolt 3 port.</dd></dl>\r\n<div class=\"js-featureSection\">\r\n<h3 class=\"featureHeader c27 fs24\"><span style=\"text-decoration: underline;\">Windows 10 Pro</span></h3>\r\n<dl class=\"js-featureSectionDL\"><dt class=\"featureTitle\"><strong>Start Menu</strong></dt><dd class=\"c28\">After its hiatus in Windows 8, the Start Menu has returned. Utilizing a combination of the traditional menu system and Windows 8\'s Live Tiles, the improved Start Menu gives you more information at a glance, showing notification information alongside your applications and other pinned items.</dd></dl><dl class=\"js-featureSectionDL\"><dt class=\"featureTitle\"><strong>Cortana</strong></dt><dd class=\"c28\">Microsoft\'s digital personal assistant, Cortana, can answer your questions with information gleaned from both your device and the Internet at large. You can type or even talk with her, if your system has a microphone. Using her Notebook, Cortana keeps track of your needs and wants, and she learns over time to improve her information-gathering skills.</dd></dl><dl class=\"js-featureSectionDL\"><dt class=\"featureTitle\"><strong>Microsoft Edge</strong></dt><dd class=\"c28\">After nearly 20 years, Microsoft has finally replaced its Internet Explorer web browser. With Microsoft Edge, users can write directly on web pages and share notes with friends and colleagues. It also improves the online reading experience by adding a distraction-free mode and read-it-later functionality. Edge also has built-in Cortana integration; you can have her help you find a restaurant, make a reservation, and pull up directions without leaving your browser.</dd></dl><dl class=\"js-featureSectionDL\"><dt class=\"featureTitle\"><strong>Windows Store</strong></dt><dd class=\"c28\">For Windows 10, Microsoft has unified the Windows Store. Now, apps for PCs, tablets, and phones will all be accessible from one place. And with support for Universal Apps, one version of an app can work across all your compatible devices automatically.</dd></dl><dl class=\"js-featureSectionDL\"><dt class=\"featureTitle\"><strong>Windows Continuum</strong></dt><dd class=\"c28\">Windows 10 was designed for a variety of screen sizes and input styles, and with its Continuum feature, it automatically adapts to fit your needs. A Windows 10 tablet on its own requires a touch-centric approach, but attaching a mouse and keyboard will shift everything to a more traditional interface. You can even attach an external monitor to your Windows 10 phone for a near-desktop experience. But it\'s not just the operating system; Windows Universal Apps take advantage of Continuum as well.</dd></dl><dl class=\"js-featureSectionDL\"><dt class=\"featureTitle\"><strong>Xbox on Windows 10</strong></dt><dd class=\"c28\">Gaming is a big focus of Windows 10. Xbox integration allows for PC players to match up against Xbox One players on supported games, and if you have an Xbox One, you can even stream compatible titles to your PC. Native support for recording with the new Game DVR feature makes it easy to capture and share your gameplay. The new DirectX12 takes better advantage of multi-core processors, giving games a performance boost, even on older hardware. Windows 10 also features native support for virtual reality headsets, such as the Oculus Rift.</dd></dl><dl class=\"js-featureSectionDL\"><dt class=\"featureTitle\"><strong>Windows 10 Pro</strong></dt><dd class=\"c28\">The Pro version of Windows 10 includes all of the features of Windows 10 Home plus many designed specifically for businesses users, including Hyper-V virtualization, BitLocker disk encryption, and remote desktop access. Devices will also be able to join domains and the Azure Active Directory, and they can even access a specialized version of the Windows Store featuring custom, company-specific applications.</dd></dl></div>\r\n</div>'),('226',85,0,'76','Lenovo ThinkPad T570 '),('227',75,0,'77','<table class=\"specTable\" data-selenium=\"specTable\">\r\n<tbody data-selenium=\"specBody\">\r\n<tr><th class=\"specHeader Header\" colspan=\"2\" data-selenium=\"specHeader\"><a id=\"11011\" class=\"fs32 OpenSans-300-normal\" name=\"11011\" data-selenium=\"specHeaderLink\"></a>Performance</th></tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Processor</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Intel Core i7-8550U Quad-Core</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Base Clock Speed</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">1.8 GHz</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Maximum Boost Speed</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">4.0 GHz</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Total Installed Memory</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">8 GB</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Maximum Memory Capacity</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">32 GB</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Memory Type</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">DDR4 SDRAM</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Memory Speed</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">2400 MHz</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">User-Replaceable Memory</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">1 x 8 GB</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Available Memory Slots</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">1</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Memory Slot Type</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">260-Pin SO-DIMM</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Graphics Type</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Integrated</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">GPU</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Intel UHD Graphics 620</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<table class=\"specTable\" data-selenium=\"specTable\">\r\n<tbody data-selenium=\"specBody\">\r\n<tr><th class=\"specHeader Header\" colspan=\"2\" data-selenium=\"specHeader\"><a id=\"8004\" class=\"fs32 OpenSans-300-normal\" name=\"8004\" data-selenium=\"specHeaderLink\"></a>Display</th></tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Panel Type</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">IPS</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Size</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">15.6\"</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Aspect Ratio</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">16:9</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Native Resolution</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">1920 x 1080</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Touchscreen</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">No</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Finish</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Matte</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Maximum Brightness</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">250 cd/m<sup>2</sup></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<table class=\"specTable\" data-selenium=\"specTable\">\r\n<tbody data-selenium=\"specBody\">\r\n<tr><th class=\"specHeader Header\" colspan=\"2\" data-selenium=\"specHeader\"><a id=\"15001\" class=\"fs32 OpenSans-300-normal\" name=\"15001\" data-selenium=\"specHeaderLink\"></a>Drives</th></tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Available Slots</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">1 x M.2</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Total Capacity</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">500 GB</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Hard Disk Storage</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">1 x 500 GB 2.5\" SATA (7200 rpm)</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Optical Drive</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\"><i>None</i></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<table class=\"specTable\" data-selenium=\"specTable\">\r\n<tbody data-selenium=\"specBody\">\r\n<tr><th class=\"specHeader Header\" colspan=\"2\" data-selenium=\"specHeader\"><a id=\"8007\" class=\"fs32 OpenSans-300-normal\" name=\"8007\" data-selenium=\"specHeaderLink\"></a>Input/Output Connectors</th></tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Ports</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">1 x USB 2.0 Type-A<br />2 x USB 3.1 Gen 1 Type-A<br />1 x USB 3.1 Gen 2 Type-C</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Display</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">1 x HDMI 1.4</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Audio</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">1 x 1/8\" (3.5 mm) Headphone/Microphone Combo Jack<br />Integrated Microphone<br />Integrated Speaker</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Expansion Slots</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\"><span class=\"notSpecfMon\">Not Specified by Manufacturer</span></td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Media Card Slots</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">microSD</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<table class=\"specTable\" data-selenium=\"specTable\">\r\n<tbody data-selenium=\"specBody\">\r\n<tr><th class=\"specHeader Header\" colspan=\"2\" data-selenium=\"specHeader\"><a id=\"15002\" class=\"fs32 OpenSans-300-normal\" name=\"15002\" data-selenium=\"specHeaderLink\"></a>Communications</th></tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Network</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">1 x 10/100/1000 Mb/s Gigabit Ethernet (RJ45)</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Modem</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\"><i>None</i></td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Wi-Fi</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">802.11ac</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">MU-MIMO Support</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">2 x 2</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Bluetooth</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Bluetooth 4.1</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Mobile Broadband</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\"><i>None</i></td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">GPS</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\"><i>None</i></td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">NFC</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\"><i>None</i></td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Webcam</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">User-Facing: 720p Video</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<table class=\"specTable\" data-selenium=\"specTable\">\r\n<tbody data-selenium=\"specBody\">\r\n<tr><th class=\"specHeader Header\" colspan=\"2\" data-selenium=\"specHeader\"><a id=\"192175\" class=\"fs32 OpenSans-300-normal\" name=\"192175\" data-selenium=\"specHeaderLink\"></a>Battery</th></tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Battery Chemistry</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\"><span class=\"notSpecfMon\">Not Specified by Manufacturer</span></td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Watt Hours / Type</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">45 Wh</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Maximum Runtime</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">12.23 Hours</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Power Requirements</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\"><span class=\"notSpecfMon\">Not Specified by Manufacturer</span></td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Power Supply</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">1 x 65 W</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<table class=\"specTable\" data-selenium=\"specTable\">\r\n<tbody data-selenium=\"specBody\">\r\n<tr><th class=\"specHeader Header\" colspan=\"2\" data-selenium=\"specHeader\"><a id=\"8008\" class=\"fs32 OpenSans-300-normal\" name=\"8008\" data-selenium=\"specHeaderLink\"></a>General</th></tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Operating System</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Windows 10 Pro (64-Bit)</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Security</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">HDD User Password Protection, Power-On Password, Kensington Lock Slot, Infineon TPM Software Professional Package, Fingerprint Reader</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Keyboard</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Type: Standard Notebook Keyboard</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Pointing Device</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">TouchPad &amp; Pointing Stick</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Dimensions (W x H x D)</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">14.5 x 0.8 x 9.9\" / 369.0 x 19.9 x 252.0 mm</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Weight</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">4.7 lb / 2.1 kg</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<table class=\"specTable\" data-selenium=\"specTable\">\r\n<tbody data-selenium=\"specBody\">\r\n<tr><th class=\"specHeader Header\" colspan=\"2\" data-selenium=\"specHeader\"><a id=\"shipping\" class=\"fs32 OpenSans-300-normal\" name=\"shipping\" data-selenium=\"specHeaderLink\"></a>Packaging Info</th></tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Package Weight</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">6.45 lb</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Box Dimensions (LxWxH)</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">19.1 x 13.0 x 3.2\"</td>\r\n</tr>\r\n</tbody>\r\n</table>'),('228',76,0,'77','<ul class=\"top-section-list\" data-selenium=\"highlightList\">\r\n<li class=\"top-section-list-item\">1.8 GHz Intel Core i7-8550U Quad-Core</li>\r\n<li class=\"top-section-list-item\">8GB DDR4 | 500GB 7200 rpm HDD</li>\r\n<li class=\"top-section-list-item\">15.6\" 1920 x 1080 Anti-Glare IPS Display</li>\r\n<li class=\"top-section-list-item\">Integrated Intel UHD Graphics 620</li>\r\n<li class=\"top-section-list-item\">MicroSD Card Reader</li>\r\n<li class=\"top-section-list-item\">USB Type-A | USB Type-C | HDMI</li>\r\n<li class=\"top-section-list-item\">802.11ac Wi-Fi | Bluetooth 4.1</li>\r\n<li class=\"top-section-list-item\">Integrated Fingerprint Reader</li>\r\n<li class=\"top-section-list-item\">Windows 10 Pro (64-Bit)</li>\r\n</ul>\r\n<div class=\"ov-wrapper js-overview-desc\">\r\n<div class=\"ov-desc\">\r\n<p>The <strong>15.6\" ThinkPad E580 Notebook from Lenovo</strong> is designed for business purposes, featuring the performance, security, and portability users need. Specs-wise, it\'s powered by a 1.8 GHz Intel Core i7-8550U quad-core processor, 8GB of DDR4 RAM, and a 500GB 7200 rpm HDD. Should you need more room, you can install an additional storage drive, attach external storage solutions using its USB ports, as well as quickly offload data to other devices with its microSD card reader.</p>\r\n<p>Its 15.6\" display, driven by integrated Intel UHD graphics, features a 1920 x 1080 resolution for crisp and clear Full HD playback. Moreover, it has an HDMI port that you can use for connecting a display for larger viewing and enhanced multitasking. Other integrated features include a fingerprint reader, 802.11ac Wi-Fi, Gigabit Ethernet LAN, Bluetooth 4.1, a webcam, a microphone, speakers, and an audio in/out jack. The operating system installed is Windows 10 Pro.</p>\r\n</div>\r\n</div>\r\n<div class=\"sectionHeaders js-hiddenFeatures\" data-selenium=\"sectionHeaders\"><dl class=\"js-featureSectionDL\"><dt class=\"featureTitle\"><strong>All-Day Battery</strong></dt><dd class=\"c28\">The battery in this system is designed for all-day use to keep up with you while you\'re on-the-go. Moreover, it features RapidCharge technology that can provides up to 80% capacity within an hour of charging.</dd></dl><dl class=\"js-featureSectionDL\"><dt class=\"featureTitle\"><strong>Security</strong></dt><dd class=\"c28\">The ThinkPad E580 is equipped with a webcam, a fingerprint reader, and TPM security. With Windows Hello, you can easily log into your system with just a glance or a tap of your finger, even if you forgot your password. Meanwhile, the Kensington lock slot and TPM security keeps your device and data protected.</dd></dl>\r\n<div class=\"js-featureSection\">\r\n<h3 class=\"featureHeader c27 fs24\"><span style=\"text-decoration: underline;\">Windows 10 Pro</span></h3>\r\n<dl class=\"js-featureSectionDL\"><dt class=\"featureTitle\"><strong>Start Menu</strong></dt><dd class=\"c28\">After its hiatus in Windows 8, the Start Menu has returned. Utilizing a combination of the traditional menu system and Windows 8\'s Live Tiles, the improved Start Menu gives you more information at a glance, showing notification information alongside your applications and other pinned items.</dd></dl><dl class=\"js-featureSectionDL\"><dt class=\"featureTitle\"><strong>Cortana</strong></dt><dd class=\"c28\">Microsoft\'s digital personal assistant, Cortana can answer your questions with information gleaned from both your device and the internet at large. You can type or even talk with her, if your system has a microphone. Using her Notebook, Cortana keeps track of your needs and wants, and she learns over time to improve her information gathering skills.</dd></dl><dl class=\"js-featureSectionDL\"><dt class=\"featureTitle\"><strong>Microsoft Edge</strong></dt><dd class=\"c28\">After nearly 20 years, Microsoft has finally replaced its Internet Explorer web browser. With Microsoft Edge, users can write directly on web pages and share notes with friends and colleagues. It also improves the online reading experience by adding a distraction-free mode and read-it-later functionality. Edge also has built-in Cortana integration; you can have her help you find a restaurant, make a reservation, and pull up directions without leaving your browser.</dd></dl><dl class=\"js-featureSectionDL\"><dt class=\"featureTitle\"><strong>Windows Store</strong></dt><dd class=\"c28\">For Windows 10, Microsoft has unified the Windows Store. Now, apps for PCs, tablets, and phones will all be accessible from one place. And with support for Universal Apps, one version of an app can work across all your compatible devices automatically.</dd></dl><dl class=\"js-featureSectionDL\"><dt class=\"featureTitle\"><strong>Windows Continuum</strong></dt><dd class=\"c28\">Windows 10 was designed for a variety of screen sizes and input styles, and with its Continuum feature, it automatically adapts to fit your needs. A Windows 10 tablet on its own requires a touch-centric approach, but attaching a mouse and keyboard will shift everything to a more traditional interface. You can even attach an external monitor to your Windows 10 phone for a near-desktop experience. But it\'s not just the operating system; Windows Universal Apps take advantage of Continuum as well.</dd></dl><dl class=\"js-featureSectionDL\"><dt class=\"featureTitle\"><strong>Xbox on Windows 10</strong></dt><dd class=\"c28\">Gaming is a big focus of Windows 10. Xbox integration allows for PC players to match up against Xbox One players on supported games, and if you have an Xbox One, you can even stream compatible titles to your PC. Native support for recording with the new Game DVR feature makes it easy to capture and share your gameplay. The new DirectX12 takes better advantage of multi-core processors, giving games a performance boost, even on older hardware. Windows 10 also features native support for virtual reality headsets, such as the Oculus Rift.</dd></dl><dl class=\"js-featureSectionDL\"><dt class=\"featureTitle\"><strong>Windows 10 Pro</strong></dt><dd class=\"c28\">The Pro version of Windows 10 includes all of the features of Windows 10 Home plus many designed specifically for business users, including Hyper-V virtualization, BitLocker disk encryption, and remote desktop access. Devices will also be able to join domains and the Azure Active Directory, and they can even access a specialized version of the Windows Store featuring custom, company-specific applications.</dd></dl></div>\r\n</div>'),('229',85,0,'77','Lenovo ThinkPad E580 15.6\"'),('230',75,0,'78','<table class=\"specTable\" data-selenium=\"specTable\">\r\n<tbody data-selenium=\"specBody\">\r\n<tr><th class=\"specHeader Header\" colspan=\"2\" data-selenium=\"specHeader\"><a id=\"11011\" class=\"fs32 OpenSans-300-normal\" name=\"11011\" data-selenium=\"specHeaderLink\"></a>Performance</th></tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Processor</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Intel Core i5-7200U Dual-Core</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Base Clock Speed</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">2.5 GHz</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Maximum Boost Speed</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">3.1 GHz</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Total Installed Memory</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">4 GB</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Maximum Memory Capacity</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">32 GB</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Memory Type</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">DDR4 SDRAM</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Memory Speed</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">2400 MHz</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">User-Replaceable Memory</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">1 x 4 GB</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Available Memory Slots</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">1</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Memory Slot Type</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">260-Pin SO-DIMM</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Graphics Type</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Integrated</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">GPU</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Intel HD Graphics 620</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<table class=\"specTable\" data-selenium=\"specTable\">\r\n<tbody data-selenium=\"specBody\">\r\n<tr><th class=\"specHeader Header\" colspan=\"2\" data-selenium=\"specHeader\"><a id=\"8004\" class=\"fs32 OpenSans-300-normal\" name=\"8004\" data-selenium=\"specHeaderLink\"></a>Display</th></tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Panel Type</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">LCD</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Size</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">15.6\"</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Aspect Ratio</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">16:9</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Native Resolution</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">1366 x 768</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Touchscreen</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">No</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Finish</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Matte</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Maximum Brightness</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">220 cd/m<sup>2</sup></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<table class=\"specTable\" data-selenium=\"specTable\">\r\n<tbody data-selenium=\"specBody\">\r\n<tr><th class=\"specHeader Header\" colspan=\"2\" data-selenium=\"specHeader\"><a id=\"15001\" class=\"fs32 OpenSans-300-normal\" name=\"15001\" data-selenium=\"specHeaderLink\"></a>Drives</th></tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Available Slots</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">1 x M.2</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Total Capacity</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">500 GB</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Hard Disk Storage</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">1 x 500 GB 2.5\" SATA (7200 rpm)</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Optical Drive</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\"><i>None</i></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<table class=\"specTable\" data-selenium=\"specTable\">\r\n<tbody data-selenium=\"specBody\">\r\n<tr><th class=\"specHeader Header\" colspan=\"2\" data-selenium=\"specHeader\"><a id=\"8007\" class=\"fs32 OpenSans-300-normal\" name=\"8007\" data-selenium=\"specHeaderLink\"></a>Input/Output Connectors</th></tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Ports</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">1 x USB 2.0 Type-A<br />2 x USB 3.1 Gen 1 Type-A<br />1 x USB 3.1 Gen 2 Type-C</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Display</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">1 x HDMI 1.4</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Audio</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">1 x 1/8\" (3.5 mm) Headphone/Microphone Combo Jack<br />Integrated Microphone<br />Integrated Speaker</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Expansion Slots</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\"><span class=\"notSpecfMon\">Not Specified by Manufacturer</span></td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Media Card Slots</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">microSD</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<table class=\"specTable\" data-selenium=\"specTable\">\r\n<tbody data-selenium=\"specBody\">\r\n<tr><th class=\"specHeader Header\" colspan=\"2\" data-selenium=\"specHeader\"><a id=\"15002\" class=\"fs32 OpenSans-300-normal\" name=\"15002\" data-selenium=\"specHeaderLink\"></a>Communications</th></tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Network</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">1 x 10/100/1000 Mb/s Gigabit Ethernet (RJ45)</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Modem</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\"><i>None</i></td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Wi-Fi</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">802.11ac</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">MU-MIMO Support</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">2 x 2</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Bluetooth</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Bluetooth 4.1</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Mobile Broadband</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\"><i>None</i></td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">GPS</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\"><i>None</i></td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">NFC</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\"><i>None</i></td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Webcam</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">User-Facing: 720p Video</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<table class=\"specTable\" data-selenium=\"specTable\">\r\n<tbody data-selenium=\"specBody\">\r\n<tr><th class=\"specHeader Header\" colspan=\"2\" data-selenium=\"specHeader\"><a id=\"192175\" class=\"fs32 OpenSans-300-normal\" name=\"192175\" data-selenium=\"specHeaderLink\"></a>Battery</th></tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Battery Chemistry</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\"><span class=\"notSpecfMon\">Not Specified by Manufacturer</span></td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Watt Hours / Type</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">45 Wh</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Maximum Runtime</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">12.23 Hours</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Power Requirements</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\"><span class=\"notSpecfMon\">Not Specified by Manufacturer</span></td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Power Supply</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">1 x 65 W</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<table class=\"specTable\" data-selenium=\"specTable\">\r\n<tbody data-selenium=\"specBody\">\r\n<tr><th class=\"specHeader Header\" colspan=\"2\" data-selenium=\"specHeader\"><a id=\"8008\" class=\"fs32 OpenSans-300-normal\" name=\"8008\" data-selenium=\"specHeaderLink\"></a>General</th></tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Operating System</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Windows 10 Pro (64-Bit)</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Security</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">HDD User Password Protection, Power-On Password, Kensington Lock Slot, Infineon TPM Software Professional Package, Fingerprint Reader</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Keyboard</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Type: Standard Notebook Keyboard</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Pointing Device</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">TouchPad &amp; Pointing Stick</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Dimensions (W x H x D)</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">14.5 x 0.8 x 9.9\" / 369.0 x 19.9 x 252.0 mm</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Weight</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">4.7 lb / 2.1 kg</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<table class=\"specTable\" data-selenium=\"specTable\">\r\n<tbody data-selenium=\"specBody\">\r\n<tr><th class=\"specHeader Header\" colspan=\"2\" data-selenium=\"specHeader\"><a id=\"shipping\" class=\"fs32 OpenSans-300-normal\" name=\"shipping\" data-selenium=\"specHeaderLink\"></a>Packaging Info</th></tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Package Weight</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">6.4 lb</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Box Dimensions (LxWxH)</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">19.1 x 13.0 x 3.2\"</td>\r\n</tr>\r\n</tbody>\r\n</table>'),('231',76,0,'78','<ul class=\"top-section-list\" data-selenium=\"highlightList\">\r\n<li class=\"top-section-list-item\">2.5 GHz Intel Core i5-7200 Dual-Core</li>\r\n<li class=\"top-section-list-item\">4GB DDR4 | 500GB 7200 rpm HDD</li>\r\n<li class=\"top-section-list-item\">15.6\" 1366 x 768 Anti-Glare Display</li>\r\n<li class=\"top-section-list-item\">Integrated Intel HD Graphics 620</li>\r\n<li class=\"top-section-list-item\">MicroSD Card Reader</li>\r\n<li class=\"top-section-list-item\">USB Type-A | USB Type-C | HDMI</li>\r\n<li class=\"top-section-list-item\">802.11ac Wi-Fi | Bluetooth 4.1</li>\r\n<li class=\"top-section-list-item\">Integrated Fingerprint Reader</li>\r\n<li class=\"top-section-list-item\">Windows 10 Pro (64-Bit)</li>\r\n</ul>\r\n<div class=\"ov-wrapper js-overview-desc\">\r\n<div class=\"ov-desc\">\r\n<p>The <strong>15.6\" ThinkPad E580 Notebook from Lenovo</strong> is designed for business purposes, featuring the performance, security, and portability users need. Specs-wise, it\'s powered by a 2.5 GHz Intel Core i5-7200 dual-core processor, 4GB of DDR4 RAM, and a 500GB 7200 rpm HDD. Should you need more room, you can install an additional storage drive, attach external storage solutions using its USB ports, as well as quickly offload data to other devices with its microSD card reader.</p>\r\n<p>Its 15.6\" display, driven by integrated Intel HD graphics, features a 1366 x 768 resolution for crisp and clear HD playback. Moreover, it has an HDMI port that you can use for connecting a display for larger viewing and enhanced multitasking. Other integrated features include a fingerprint reader, 802.11ac Wi-Fi, Gigabit Ethernet LAN, Bluetooth 4.1, a webcam, a microphone, speakers, and an audio in/out jack. The operating system installed is Windows 10 Pro.</p>\r\n</div>\r\n</div>\r\n<div class=\"sectionHeaders js-hiddenFeatures\" data-selenium=\"sectionHeaders\"><dl class=\"js-featureSectionDL\"><dt class=\"featureTitle\"><strong>All-Day Battery</strong></dt><dd class=\"c28\">The battery in this system is designed for all-day use to keep up with you while you\'re on-the-go. Moreover, it features RapidCharge technology that can provide up to 80% capacity within an hour of charging.</dd></dl><dl class=\"js-featureSectionDL\"><dt class=\"featureTitle\"><strong>Security</strong></dt><dd class=\"c28\">The ThinkPad E580 is equipped with a webcam, a fingerprint reader, and TPM security. With Windows Hello, you can easily log into your system with just a glance or a tap of your finger, even if you forgot your password. Meanwhile, the Kensington lock slot and TPM security keeps your device and data protected.</dd></dl>\r\n<div class=\"js-featureSection\">\r\n<h3 class=\"featureHeader c27 fs24\"><span style=\"text-decoration: underline;\">Windows 10 Pro</span></h3>\r\n<dl class=\"js-featureSectionDL\"><dt class=\"featureTitle\"><strong>Start Menu</strong></dt><dd class=\"c28\">After its hiatus in Windows 8, the Start Menu has returned. Utilizing a combination of the traditional menu system and Windows 8\'s Live Tiles, the improved Start Menu gives you more information at a glance, showing notification information alongside your applications and other pinned items.</dd></dl><dl class=\"js-featureSectionDL\"><dt class=\"featureTitle\"><strong>Cortana</strong></dt><dd class=\"c28\">Microsoft\'s digital personal assistant, Cortana can answer your questions with information gleaned from both your device and the internet at large. You can type or even talk with her, if your system has a microphone. Using her Notebook, Cortana keeps track of your needs and wants, and she learns over time to improve her information gathering skills.</dd></dl><dl class=\"js-featureSectionDL\"><dt class=\"featureTitle\"><strong>Microsoft Edge</strong></dt><dd class=\"c28\">After nearly 20 years, Microsoft has finally replaced its Internet Explorer web browser. With Microsoft Edge, users can write directly on web pages and share notes with friends and colleagues. It also improves the online reading experience by adding a distraction-free mode and read-it-later functionality. Edge also has built-in Cortana integration; you can have her help you find a restaurant, make a reservation, and pull up directions without leaving your browser.</dd></dl><dl class=\"js-featureSectionDL\"><dt class=\"featureTitle\"><strong>Windows Store</strong></dt><dd class=\"c28\">For Windows 10, Microsoft has unified the Windows Store. Now, apps for PCs, tablets, and phones will all be accessible from one place. And with support for Universal Apps, one version of an app can work across all your compatible devices automatically.</dd></dl><dl class=\"js-featureSectionDL\"><dt class=\"featureTitle\"><strong>Windows Continuum</strong></dt><dd class=\"c28\">Windows 10 was designed for a variety of screen sizes and input styles, and with its Continuum feature, it automatically adapts to fit your needs. A Windows 10 tablet on its own requires a touch-centric approach, but attaching a mouse and keyboard will shift everything to a more traditional interface. You can even attach an external monitor to your Windows 10 phone for a near-desktop experience. But it\'s not just the operating system; Windows Universal Apps take advantage of Continuum as well.</dd></dl><dl class=\"js-featureSectionDL\"><dt class=\"featureTitle\"><strong>Xbox on Windows 10</strong></dt><dd class=\"c28\">Gaming is a big focus of Windows 10. Xbox integration allows for PC players to match up against Xbox One players on supported games, and if you have an Xbox One, you can even stream compatible titles to your PC. Native support for recording with the new Game DVR feature makes it easy to capture and share your gameplay. The new DirectX12 takes better advantage of multi-core processors, giving games a performance boost, even on older hardware. Windows 10 also features native support for virtual reality headsets, such as the Oculus Rift.</dd></dl><dl class=\"js-featureSectionDL\"><dt class=\"featureTitle\"><strong>Windows 10 Pro</strong></dt><dd class=\"c28\">The Pro version of Windows 10 includes all of the features of Windows 10 Home plus many designed specifically for business users, including Hyper-V virtualization, BitLocker disk encryption, and remote desktop access. Devices will also be able to join domains and the Azure Active Directory, and they can even access a specialized version of the Windows Store featuring custom, company-specific applications.</dd></dl></div>\r\n</div>'),('232',85,0,'78','Lenovo ThinkPad E580 15.6\" (i5 Model)'),('233',75,0,'79','<h5>Model</h5>\r\n<table class=\"table\" cellspacing=\"0\" cellpadding=\"0\">\r\n<tbody>\r\n<tr><th class=\"table-w180\">Brand</th>\r\n<td>Lenovo</td>\r\n</tr>\r\n<tr><th>Series</th>\r\n<td>110-15ISK</td>\r\n</tr>\r\n<tr><th>Model</th>\r\n<td>80UD00V2US</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<h5>Quick Info</h5>\r\n<table class=\"table\" cellspacing=\"0\" cellpadding=\"0\">\r\n<tbody>\r\n<tr><th class=\"table-w180\">Color</th>\r\n<td>Black Textured</td>\r\n</tr>\r\n<tr><th><a id=\"spec_2787\" class=\"spec-tooltip\" title=\"\" data-toggle=\"popover\" data-html=\"true\" data-placement=\"top\" data-original-title=\"\">Operating System</a></th>\r\n<td>Windows 10 Home</td>\r\n</tr>\r\n<tr><th><a id=\"spec_2774\" class=\"spec-tooltip\" title=\"\" data-toggle=\"popover\" data-html=\"true\" data-placement=\"top\" data-original-title=\"\">CPU</a></th>\r\n<td>Intel Pentium 4405U (2.10 GHz)</td>\r\n</tr>\r\n<tr><th>Screen</th>\r\n<td>15.6\"</td>\r\n</tr>\r\n<tr><th><a id=\"spec_2775\" class=\"spec-tooltip\" title=\"\" data-toggle=\"popover\" data-html=\"true\" data-placement=\"top\" data-original-title=\"\">Memory</a></th>\r\n<td>4 GB DDR4</td>\r\n</tr>\r\n<tr><th><a id=\"spec_2779\" class=\"spec-tooltip\" title=\"\" data-toggle=\"popover\" data-html=\"true\" data-placement=\"top\" data-original-title=\"\">Storage</a></th>\r\n<td>500 GB</td>\r\n</tr>\r\n<tr><th><a id=\"spec_2780\" class=\"spec-tooltip\" title=\"\" data-toggle=\"popover\" data-html=\"true\" data-placement=\"top\" data-original-title=\"\">Optical Drive</a></th>\r\n<td>DVD-R/W</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<h5>CPU</h5>\r\n<table class=\"table\" cellspacing=\"0\" cellpadding=\"0\">\r\n<tbody>\r\n<tr><th class=\"table-w180\">CPU Type</th>\r\n<td>Intel Pentium</td>\r\n</tr>\r\n<tr><th><a id=\"spec_394\" class=\"spec-tooltip\" title=\"\" data-toggle=\"popover\" data-html=\"true\" data-placement=\"top\" data-original-title=\"\">CPU Speed</a></th>\r\n<td>4405U (2.10 GHz)</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<h5>Display</h5>\r\n<table class=\"table\" cellspacing=\"0\" cellpadding=\"0\">\r\n<tbody>\r\n<tr><th class=\"table-w180\"><a id=\"spec_398\" class=\"spec-tooltip\" title=\"\" data-toggle=\"popover\" data-html=\"true\" data-placement=\"top\" data-original-title=\"\">Screen Size</a></th>\r\n<td>15.6\"</td>\r\n</tr>\r\n<tr><th><a id=\"spec_34568\" class=\"spec-tooltip\" title=\"\" data-toggle=\"popover\" data-html=\"true\" data-placement=\"top\" data-original-title=\"\">Touchscreen</a></th>\r\n<td>No</td>\r\n</tr>\r\n<tr><th><a id=\"spec_400\" class=\"spec-tooltip\" title=\"\" data-toggle=\"popover\" data-html=\"true\" data-placement=\"top\" data-original-title=\"\">Resolution</a></th>\r\n<td>1366 x 768</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<h5>Operating System</h5>\r\n<table class=\"table\" cellspacing=\"0\" cellpadding=\"0\">\r\n<tbody>\r\n<tr><th class=\"table-w180\">Operating System</th>\r\n<td>Windows 10 Home</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<h5>Graphics</h5>\r\n<table class=\"table\" cellspacing=\"0\" cellpadding=\"0\">\r\n<tbody>\r\n<tr><th class=\"table-w180\"><a id=\"spec_2923\" class=\"spec-tooltip\" title=\"\" data-toggle=\"popover\" data-html=\"true\" data-placement=\"top\" data-original-title=\"\">Graphic Type</a></th>\r\n<td>Integrated Card</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<h5>Storage</h5>\r\n<table class=\"table\" cellspacing=\"0\" cellpadding=\"0\">\r\n<tbody>\r\n<tr><th class=\"table-w180\">HDD</th>\r\n<td>500 GB</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<h5>Memory</h5>\r\n<table class=\"table\" cellspacing=\"0\" cellpadding=\"0\">\r\n<tbody>\r\n<tr><th class=\"table-w180\"><a id=\"spec_410\" class=\"spec-tooltip\" title=\"\" data-toggle=\"popover\" data-html=\"true\" data-placement=\"top\" data-original-title=\"\">Memory</a></th>\r\n<td>4 GB</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<h5>Optical Drive</h5>\r\n<table class=\"table\" cellspacing=\"0\" cellpadding=\"0\">\r\n<tbody>\r\n<tr><th class=\"table-w180\">Optical Drive Type</th>\r\n<td>DVD-R/W</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<h5>Communications</h5>\r\n<table class=\"table\" cellspacing=\"0\" cellpadding=\"0\">\r\n<tbody>\r\n<tr><th class=\"table-w180\"><a id=\"spec_424\" class=\"spec-tooltip\" title=\"\" data-toggle=\"popover\" data-html=\"true\" data-placement=\"top\" data-original-title=\"\">WLAN</a></th>\r\n<td>802.11ac Wireless LAN</td>\r\n</tr>\r\n<tr><th><a id=\"spec_425\" class=\"spec-tooltip\" title=\"\" data-toggle=\"popover\" data-html=\"true\" data-placement=\"top\" data-original-title=\"\">Bluetooth</a></th>\r\n<td>Yes</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<h5>Ports</h5>\r\n<table class=\"table\" cellspacing=\"0\" cellpadding=\"0\">\r\n<tbody>\r\n<tr><th class=\"table-w180\">HDMI</th>\r\n<td>Yes</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<h5>Input Device</h5>\r\n<table class=\"table\" cellspacing=\"0\" cellpadding=\"0\">\r\n<tbody>\r\n<tr><th class=\"table-w180\"><a id=\"spec_443\" class=\"spec-tooltip\" title=\"\" data-toggle=\"popover\" data-html=\"true\" data-placement=\"top\" data-original-title=\"\">Webcam</a></th>\r\n<td>0.3 MP</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<h5>Power</h5>\r\n<table class=\"table\" cellspacing=\"0\" cellpadding=\"0\">\r\n<tbody>\r\n<tr><th class=\"table-w180\">Battery</th>\r\n<td>3 Cell 24Whr</td>\r\n</tr>\r\n</tbody>\r\n</table>'),('234',76,0,'79','<ul id=\"BulletDescription\" class=\"item-bullet\">\r\n<li>Intel Pentium 4405U (2.10 GHz)</li>\r\n<li>4 GB Memory 500 GB HDD</li>\r\n<li>1366 x 768</li>\r\n<li>Windows 10 Home</li>\r\n<li>DVD-R/W</li>\r\n</ul>\r\n<div id=\"wc-overview-e16820fc\" class=\"wc-fragment wc-no-focus\" data-channel-product-name=\"\" data-compiler-v=\"2018.16.2.395\" data-cpi=\"N82E16834332723\" data-is-capdesc-open=\"false\" data-language-code=\"en\" data-module-brand=\"Lenovo\" data-module-code=\"lenovo\" data-module-name=\"Lenovo\" data-mpn=\"80UD00V2US\" data-produced=\"2018-09-03 15:50\" data-section-caption=\"Overview\" data-section-tag=\"overview\" data-section-template-code=\"rich-features\" data-vendor-name=\"Lenovo IdeaPad 110 15” Laptop (80UD00V2US)\" data-wcpc=\"1490621074776\" data-is-reported-view=\"true\">\r\n<div class=\"wc-aplus-body\">\r\n<div class=\"wc-reset\">\r\n<ul class=\"wc-rich-features wc-rich-content-orientation-zigzag wc-first wc-last wc-no-line-seperator wc-rich-features-center-984\">\r\n<li class=\"wc-rich-feature-item wc-text-placement-true wc-odd-0 wc-first wc-has-media wc-thumb-medium wc-last \">\r\n<div class=\"wc-text-wrap\">\r\n<h3 class=\"wc-rich-content-header wc-feature-main-header \">AFFORDABLE 15.6” LAPTOP</h3>\r\n<div class=\"wc-rich-content-description\">Get the features you need without the big price tag from this affordably priced laptop: dependable processing power, good memory, lots of storage, an attractive display, and integrated graphics.</div>\r\n</div>\r\n</li>\r\n</ul>\r\n</div>\r\n</div>\r\n<div class=\"wc-clear-both\"></div>\r\n</div>\r\n<div id=\"wc-features-7ec9dd39\" class=\"wc-fragment wc-no-focus\" data-channel-product-name=\"\" data-compiler-v=\"2018.16.2.395\" data-cpi=\"N82E16834332723\" data-is-capdesc-open=\"false\" data-language-code=\"en\" data-module-brand=\"Lenovo\" data-module-code=\"lenovo\" data-module-name=\"Lenovo\" data-mpn=\"80UD00V2US\" data-produced=\"2018-09-03 15:50\" data-section-caption=\"Features\" data-section-tag=\"features\" data-section-template-code=\"rich-features\" data-vendor-name=\"Lenovo IdeaPad 110 15” Laptop (80UD00V2US)\" data-wcpc=\"1490621074776\" data-is-reported-view=\"true\">\r\n<h2 class=\"wc-rich-features-center-984\">FEATURES</h2>\r\n<div class=\"wc-aplus-body\">\r\n<div class=\"wc-reset\">\r\n<ul class=\"wc-rich-features wc-rich-content-orientation-zigzag wc-first wc-last wc-no-line-seperator wc-rich-features-center-984\">\r\n<li class=\"wc-rich-feature-item wc-text-placement-true wc-odd-0 wc-first wc-has-media wc-thumb-medium \">\r\n<div class=\"wc-media-wrap\">\r\n<div class=\"wc-media-inner-wrap\"><img class=\"wc-media wc-image\" title=\"Powered for Fun\" src=\"https://smedia.webcollage.net/rwvfp/wc/cp/22567368_legacycode/module/lenovo/_cp/products/1477580691237/tab-ed260eb5-da82-444d-8099-7c24a947b922/4be592c4-39e4-450d-855a-b8bb1e039420.jpg.w960.jpg\" alt=\"\" width=\"960\" height=\"693\" data-asset-title=\"Powered for Fun\" data-asset-type=\"image\" data-asset-url=\"/_cp/products/1477580691237/tab-ed260eb5-da82-444d-8099-7c24a947b922/4be592c4-39e4-450d-855a-b8bb1e039420.jpg\" data-asset-wrapper=\"rich-features\" data-height=\"693\" data-section-template-code=\"rich-features\" data-width=\"960\" /></div>\r\n</div>\r\n<div class=\"wc-text-wrap\">\r\n<h3 class=\"wc-rich-content-header wc-feature-main-header \">POWERED FOR FUN</h3>\r\n<div class=\"wc-rich-content-description\">The IdeaPad 110 is powered by an Intel processor with integrated Intel graphics, giving you plenty of processing power for casual surfing, streaming, and playing.</div>\r\n</div>\r\n</li>\r\n<li class=\"wc-rich-feature-item wc-text-placement-true wc-even-0 wc-has-media wc-thumb-medium \">\r\n<div class=\"wc-media-wrap\">\r\n<div class=\"wc-media-inner-wrap\"><img class=\"wc-media wc-image\" title=\"Lightning-Fast Web Browsing\" src=\"https://smedia.webcollage.net/rwvfp/wc/cp/22567368_legacycode/module/lenovo/_cp/products/1477580691237/tab-ed260eb5-da82-444d-8099-7c24a947b922/4f685d69-daa4-48a9-8359-52c67d1dd4ef.jpg.w960.jpg\" alt=\"\" width=\"960\" height=\"977\" data-asset-title=\"Lightning-Fast Web Browsing\" data-asset-type=\"image\" data-asset-url=\"/_cp/products/1477580691237/tab-ed260eb5-da82-444d-8099-7c24a947b922/4f685d69-daa4-48a9-8359-52c67d1dd4ef.jpg\" data-asset-wrapper=\"rich-features\" data-height=\"977\" data-section-template-code=\"rich-features\" data-width=\"960\" /></div>\r\n</div>\r\n<div class=\"wc-text-wrap\">\r\n<h3 class=\"wc-rich-content-header wc-feature-main-header \">LIGHTNING-FAST WEB BROWSING</h3>\r\n<div class=\"wc-rich-content-description\">802.11 a/c WiFi connectivity comes standard on the IdeaPad 110, making it perfect for blazing-fast browsing, streaming, and downloading. 802.11 a/c WiFi delivers up to 3 times the connection speeds of 802.11 b/g/n.</div>\r\n</div>\r\n</li>\r\n<li class=\"wc-rich-feature-item wc-text-placement-true wc-odd-0 wc-has-media wc-thumb-medium \">\r\n<div class=\"wc-media-wrap\">\r\n<div class=\"wc-media-inner-wrap\"><img class=\"wc-media wc-image\" title=\"Productivity and Comfort\" src=\"https://smedia.webcollage.net/rwvfp/wc/cp/22567368_legacycode/module/lenovo/_cp/products/1477580691237/tab-ed260eb5-da82-444d-8099-7c24a947b922/39ac6e9b-d90d-4256-985d-05e6391c71e0.jpg.w960.jpg\" alt=\"\" width=\"960\" height=\"618\" data-asset-title=\"Productivity and Comfort\" data-asset-type=\"image\" data-asset-url=\"/_cp/products/1477580691237/tab-ed260eb5-da82-444d-8099-7c24a947b922/39ac6e9b-d90d-4256-985d-05e6391c71e0.jpg\" data-asset-wrapper=\"rich-features\" data-height=\"618\" data-section-template-code=\"rich-features\" data-width=\"960\" /></div>\r\n</div>\r\n<div class=\"wc-text-wrap\">\r\n<h3 class=\"wc-rich-content-header wc-feature-main-header \">PRODUCTIVITY AND COMFORT</h3>\r\n<div class=\"wc-rich-content-description\">The IdeaPad 110 has a number of features to maximize your productivity and comfort. The improved hinge design is more robust and allows for smooth 180-degree action to a flat position. The frameless keyboard allows your fingers to move freely without bumping, and the textured palm rest resists fingerprints and helps keep your hands in place without slipping – perfect for speedy touch-typing.</div>\r\n</div>\r\n</li>\r\n<li class=\"wc-rich-feature-item wc-text-placement-true wc-even-0 wc-has-media wc-thumb-medium \">\r\n<div class=\"wc-media-wrap\">\r\n<div class=\"wc-media-inner-wrap\"><img class=\"wc-media wc-image\" title=\"Integrated Optical Drive\" src=\"https://smedia.webcollage.net/rwvfp/wc/cp/22567368_legacycode/module/lenovo/_cp/products/1477580691237/tab-ed260eb5-da82-444d-8099-7c24a947b922/a3165f9a-122e-4072-ad08-808af25eb70b.png.w960.png\" alt=\"\" width=\"590\" height=\"368\" data-asset-title=\"Integrated Optical Drive\" data-asset-type=\"image\" data-asset-url=\"/_cp/products/1477580691237/tab-ed260eb5-da82-444d-8099-7c24a947b922/a3165f9a-122e-4072-ad08-808af25eb70b.png\" data-asset-wrapper=\"rich-features\" data-height=\"368\" data-section-template-code=\"rich-features\" data-width=\"590\" /></div>\r\n</div>\r\n<div class=\"wc-text-wrap\">\r\n<h3 class=\"wc-rich-content-header wc-feature-main-header \">INTEGRATED OPTICAL DRIVE</h3>\r\n<div class=\"wc-rich-content-description\">There’s no need to purchase an external optical drive with the IdeaPad 110. It comes standard with an integrated DVD/CD-RW drive so you can load programs, listen to CDs, or watch movies offline.</div>\r\n</div>\r\n</li>\r\n<li class=\"wc-rich-feature-item wc-text-placement-true wc-odd-0 wc-has-media wc-thumb-medium \">\r\n<div class=\"wc-media-wrap\">\r\n<div class=\"wc-media-inner-wrap\"><img class=\"wc-media wc-image\" title=\"Plenty of Storage\" src=\"https://smedia.webcollage.net/rwvfp/wc/cp/22567368_legacycode/module/lenovo/_cp/products/1477580691237/tab-ed260eb5-da82-444d-8099-7c24a947b922/873c40c7-0887-4e45-bdee-78966924d243.jpg.w960.jpg\" alt=\"\" width=\"960\" height=\"788\" data-asset-title=\"Plenty of Storage\" data-asset-type=\"image\" data-asset-url=\"/_cp/products/1477580691237/tab-ed260eb5-da82-444d-8099-7c24a947b922/873c40c7-0887-4e45-bdee-78966924d243.jpg\" data-asset-wrapper=\"rich-features\" data-height=\"788\" data-section-template-code=\"rich-features\" data-width=\"960\" /></div>\r\n</div>\r\n<div class=\"wc-text-wrap\">\r\n<h3 class=\"wc-rich-content-header wc-feature-main-header \">PLENTY OF STORAGE</h3>\r\n<div class=\"wc-rich-content-description\">With lots of HDD storage, you won\'t have to worry about where to put all your data, videos, music, or photos.</div>\r\n</div>\r\n</li>\r\n</ul>\r\n</div>\r\n</div>\r\n</div>'),('235',85,0,'79','Lenovo 110-15ISK 15.6\" '),('236',75,0,'80','<fieldset>\r\n<h3 class=\"specTitle\">Model</h3>\r\n<dl><dt>Brand</dt><dd>Lenovo</dd></dl><dl><dt>Series</dt><dd>IdeaPad 320-17IKB</dd></dl><dl><dt>Model</dt><dd>80XM0000US</dd></dl></fieldset><fieldset>\r\n<h3 class=\"specTitle\">Quick Info</h3>\r\n<dl><dt>Color</dt><dd>Platinum Grey</dd></dl><dl><dt><a id=\"def_colorPopup__2787\" class=\"specs-popup\" name=\"def-color\" data-t-events=\"A\" data-t-e-var78=\"Specification Popup:Operating System\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>Operating System</dt><dd>Windows 10 Home</dd></dl><dl><dt><a id=\"def_colorPopup__2774\" class=\"specs-popup\" name=\"def-color\" data-t-events=\"A\" data-t-e-var78=\"Specification Popup:CPU\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>CPU</dt><dd>Intel Core i5-7200U 2.50 GHz</dd></dl><dl><dt>Screen</dt><dd>17.3\"</dd></dl><dl><dt><a id=\"def_colorPopup__2775\" class=\"specs-popup\" name=\"def-color\" data-t-events=\"A\" data-t-e-var78=\"Specification Popup:Memory\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>Memory</dt><dd>8 GB</dd></dl><dl><dt><a id=\"def_colorPopup__2779\" class=\"specs-popup\" name=\"def-color\" data-t-events=\"A\" data-t-e-var78=\"Specification Popup:Storage\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>Storage</dt><dd>1 TB</dd></dl><dl><dt><a id=\"def_colorPopup__2780\" class=\"specs-popup\" name=\"def-color\" data-t-events=\"A\" data-t-e-var78=\"Specification Popup:Optical Drive\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>Optical Drive</dt><dd>DVD±R/RW</dd></dl><dl><dt><a id=\"def_colorPopup__2777\" class=\"specs-popup\" name=\"def-color\" data-t-events=\"A\" data-t-e-var78=\"Specification Popup:Graphics Card\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>Graphics Card</dt><dd>Intel HD Graphics 620</dd></dl><dl><dt><a id=\"def_colorPopup__2778\" class=\"specs-popup\" name=\"def-color\" data-t-events=\"A\" data-t-e-var78=\"Specification Popup:Video Memory\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>Video Memory</dt><dd>Shared memory</dd></dl><dl><dt>Dimensions (W x D x H)</dt><dd>16.45\" x 11.52\" x 0.98\"</dd></dl><dl><dt>Weight</dt><dd>6.17 lbs.</dd></dl></fieldset><fieldset>\r\n<h3 class=\"specTitle\">CPU</h3>\r\n<dl><dt>CPU Type</dt><dd>Intel Core i5 7th Gen</dd></dl><dl><dt><a id=\"def_colorPopup__394\" class=\"specs-popup\" name=\"def-color\" data-t-events=\"A\" data-t-e-var78=\"Specification Popup:CPU Speed\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>CPU Speed</dt><dd>7200U (2.50 GHz)</dd></dl><dl><dt>Core Name</dt><dd>Kaby Lake</dd></dl><dl><dt><a id=\"def_colorPopup__37494\" class=\"specs-popup\" name=\"def-color\" data-t-events=\"A\" data-t-e-var78=\"Specification Popup:Number of Cores\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>Number of Cores</dt><dd>Dual-core Processor</dd></dl><dl><dt><a id=\"def_colorPopup__37564\" class=\"specs-popup\" name=\"def-color\" data-t-events=\"A\" data-t-e-var78=\"Specification Popup:CPU L3 Cache\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>CPU L3 Cache</dt><dd>3 MB</dd></dl></fieldset><fieldset>\r\n<h3 class=\"specTitle\">Display</h3>\r\n<dl><dt><a id=\"def_colorPopup__398\" class=\"specs-popup\" name=\"def-color\" data-t-events=\"A\" data-t-e-var78=\"Specification Popup:Screen Size\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>Screen Size</dt><dd>17.3\"</dd></dl><dl><dt><a id=\"def_colorPopup__34568\" class=\"specs-popup\" name=\"def-color\" data-t-events=\"A\" data-t-e-var78=\"Specification Popup:Touchscreen\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>Touchscreen</dt><dd>No</dd></dl><dl><dt><a id=\"def_colorPopup__3021\" class=\"specs-popup\" name=\"def-color\" data-t-events=\"A\" data-t-e-var78=\"Specification Popup:Wide Screen Support\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>Wide Screen Support</dt><dd>Yes</dd></dl><dl><dt>Display Type</dt><dd>HD+</dd></dl><dl><dt><a id=\"def_colorPopup__400\" class=\"specs-popup\" name=\"def-color\" data-t-events=\"A\" data-t-e-var78=\"Specification Popup:Resolution\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>Resolution</dt><dd>1600 x 900</dd></dl></fieldset><fieldset>\r\n<h3 class=\"specTitle\">Operating System</h3>\r\n<dl><dt>Operating System</dt><dd>Windows 10 Home 64-Bit</dd></dl></fieldset><fieldset>\r\n<h3 class=\"specTitle\">Graphics</h3>\r\n<dl><dt><a id=\"def_colorPopup__402\" class=\"specs-popup\" name=\"def-color\" data-t-events=\"A\" data-t-e-var78=\"Specification Popup:GPU/VPU\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>GPU/VPU</dt><dd>Intel HD Graphics 620</dd></dl><dl><dt>Video Memory</dt><dd>Shared system memory</dd></dl><dl><dt><a id=\"def_colorPopup__2923\" class=\"specs-popup\" name=\"def-color\" data-t-events=\"A\" data-t-e-var78=\"Specification Popup:Graphic Type\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>Graphic Type</dt><dd>Integrated Card</dd></dl></fieldset><fieldset>\r\n<h3 class=\"specTitle\">Storage</h3>\r\n<dl><dt>HDD</dt><dd>1 TB</dd></dl></fieldset><fieldset>\r\n<h3 class=\"specTitle\">Memory</h3>\r\n<dl><dt><a id=\"def_colorPopup__410\" class=\"specs-popup\" name=\"def-color\" data-t-events=\"A\" data-t-e-var78=\"Specification Popup:Memory\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>Memory</dt><dd>8 GB</dd></dl></fieldset><fieldset>\r\n<h3 class=\"specTitle\">Optical Drive</h3>\r\n<dl><dt>Optical Drive Type</dt><dd>DVD±R/RW</dd></dl></fieldset><fieldset>\r\n<h3 class=\"specTitle\">Communications</h3>\r\n<dl><dt><a id=\"def_colorPopup__424\" class=\"specs-popup\" name=\"def-color\" data-t-events=\"A\" data-t-e-var78=\"Specification Popup:WLAN\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>WLAN</dt><dd>802.11ac Wireless LAN</dd></dl><dl><dt><a id=\"def_colorPopup__425\" class=\"specs-popup\" name=\"def-color\" data-t-events=\"A\" data-t-e-var78=\"Specification Popup:Bluetooth\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>Bluetooth</dt><dd>Yes</dd></dl></fieldset><fieldset>\r\n<h3 class=\"specTitle\">Ports</h3>\r\n<dl><dt>HDMI</dt><dd>1 x HDMI</dd></dl></fieldset><fieldset>\r\n<h3 class=\"specTitle\">Input Device</h3>\r\n<dl><dt><a id=\"def_colorPopup__443\" class=\"specs-popup\" name=\"def-color\" data-t-events=\"A\" data-t-e-var78=\"Specification Popup:Webcam\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>Webcam</dt><dd>720P HD</dd></dl></fieldset><fieldset>\r\n<h3 class=\"specTitle\">General</h3>\r\n<dl><dt>Style</dt><dd>Standard</dd></dl><dl><dt>Type</dt><dd>Mainstream</dd></dl><dl><dt>Usage</dt><dd>Consumer</dd></dl></fieldset><fieldset>\r\n<h3 class=\"specTitle\">Power</h3>\r\n<dl><dt>Battery</dt><dd>2-Cell 30 Whr</dd></dl></fieldset><fieldset>\r\n<h3 class=\"specTitle\">Dimensions &amp; Weight</h3>\r\n<dl><dt>Dimensions (W x D x H)</dt><dd>16.45\" x 11.52\" x 0.98\"</dd></dl><dl><dt>Weight</dt><dd>6.17 lbs.</dd></dl></fieldset>'),('237',76,0,'80','<ul class=\"wc-rich-features wc-rich-content-orientation-zigzag wc-first wc-last wc-no-line-seperator wc-rich-features-center-984\">\r\n<li class=\"item\">Intel Core i5 7th Gen 7200U (2.50 GHz)</li>\r\n<li class=\"item\">8 GB Memory 1 TB HDD</li>\r\n<li class=\"item\">Intel HD Graphics 620</li>\r\n<li class=\"item\">1600 x 900</li>\r\n<li class=\"item\">Windows 10 Home 64-Bit</li>\r\n<li class=\"item\">DVD±R/RW</li>\r\n</ul>\r\n<p><strong><span style=\"font-size: 1.17em;\">LIFE JUST GOT EASIER.</span></strong><br />Everything about the IdeaPad 320 is designed to simplify your life. It will handle any task with ease, thanks to powerful processing and integrated Intel HD graphics. Preloaded with Windows 10 Home, you\'ll have the personal assistance of Cortana, designed to help open apps and answer your questions — whether typed or spoken. From the new streamlined design to a cleaner desktop interface, you\'ll enjoy the simplicity the IdeaPad 320 offers.<br /><br /><strong>FEATURES</strong></p>\r\n<div class=\"wc-media-wrap\" style=\"display: inline !important;\">\r\n<div class=\"wc-media-inner-wrap\" style=\"display: inline !important;\"><img class=\"wc-media wc-image\" title=\"Performance You Can Count On\" src=\"https://smedia.webcollage.net/rwvfp/wc/cp/24017774_legacycode/module/lenovo/_cp/products/1492531407425/tab-8cab0c06-3c81-4be8-ba56-99cda0d3381a/f29adce5-0aee-4941-9c43-7fb5449c5d06.jpg.w960.jpg\" alt=\"\" width=\"960\" height=\"540\" data-asset-title=\"Performance You Can Count On\" data-asset-type=\"image\" data-asset-url=\"/_cp/products/1492531407425/tab-8cab0c06-3c81-4be8-ba56-99cda0d3381a/f29adce5-0aee-4941-9c43-7fb5449c5d06.jpg\" data-asset-wrapper=\"rich-features\" data-height=\"540\" data-section-template-code=\"rich-features\" data-width=\"960\" /></div>\r\n</div>\r\n<div class=\"wc-text-wrap\">\r\n<h3 class=\"wc-rich-content-header wc-feature-main-header \">PERFORMANCE YOU CAN COUNT ON</h3>\r\n<ul>\r\n<li>Powered by 7th Gen Intel Core processors along with plenty of DDR4 memory, you’ll get lightning-fast responsiveness and reliable performance. Run multiple programs simultaneously, and transition seamlessly between web tabs — you\'ll be able to multitask with ease.</li>\r\n</ul>\r\n</div>\r\n<div class=\"wc-media-wrap\" style=\"display: inline !important;\">\r\n<div class=\"wc-media-inner-wrap\" style=\"display: inline !important;\"><img class=\"wc-media wc-image\" title=\"Durability Down to the Finish\" src=\"https://smedia.webcollage.net/rwvfp/wc/cp/24017774_legacycode/module/lenovo/_cp/products/1492531407425/tab-8cab0c06-3c81-4be8-ba56-99cda0d3381a/f94ee9d4-288f-479c-b09b-a0ef29d75a70.png.w960.png\" alt=\"\" width=\"960\" height=\"540\" data-asset-title=\"Durability Down to the Finish\" data-asset-type=\"image\" data-asset-url=\"/_cp/products/1492531407425/tab-8cab0c06-3c81-4be8-ba56-99cda0d3381a/f94ee9d4-288f-479c-b09b-a0ef29d75a70.png\" data-asset-wrapper=\"rich-features\" data-height=\"540\" data-section-template-code=\"rich-features\" data-width=\"960\" /></div>\r\n</div>\r\n<div class=\"wc-text-wrap\">\r\n<h3 class=\"wc-rich-content-header wc-feature-main-header \">DURABILITY DOWN TO THE FINISH</h3>\r\n<ul>\r\n<li>We redesigned the IdeaPad 320 with a sleek unibody chassis and added a uniquely playful tone-on-tone Platinum Grey color. Better yet, the IdeaPad 320 is designed to keep up with you. We treated it with a special protective finish to guard against wear and tear, and added rubber detailing on the bottom cover to maximize ventilation and extend product life.</li>\r\n</ul>\r\n</div>\r\n<div class=\"wc-media-wrap\" style=\"display: inline !important;\">\r\n<div class=\"wc-media-inner-wrap\" style=\"display: inline !important;\"><img class=\"wc-media wc-image\" title=\"Brilliant Resolution on a 17” Display\" src=\"https://smedia.webcollage.net/rwvfp/wc/cp/24017774_legacycode/module/lenovo/_cp/products/1492531407425/tab-8cab0c06-3c81-4be8-ba56-99cda0d3381a/315f28e0-4f8c-48c0-8a3d-8850dac87632.jpg.w960.jpg\" alt=\"\" width=\"960\" height=\"540\" data-asset-title=\"Brilliant Resolution on a 17” Display\" data-asset-type=\"image\" data-asset-url=\"/_cp/products/1492531407425/tab-8cab0c06-3c81-4be8-ba56-99cda0d3381a/315f28e0-4f8c-48c0-8a3d-8850dac87632.jpg\" data-asset-wrapper=\"rich-features\" data-height=\"540\" data-section-template-code=\"rich-features\" data-width=\"960\" /></div>\r\n</div>\r\n<div class=\"wc-text-wrap\">\r\n<h3 class=\"wc-rich-content-header wc-feature-main-header \">BRILLIANT RESOLUTION ON A 17” DISPLAY</h3>\r\n<ul>\r\n<li>The IdeaPad 320 offers HD+ 1600 x 900 resolution on a 17\" display, with anti-glare technology. You\'ll enjoy true visual clarity when you watch movies, browse the web, and more.</li>\r\n</ul>\r\n</div>\r\n<div class=\"wc-media-wrap\" style=\"display: inline !important;\">\r\n<div class=\"wc-media-inner-wrap\" style=\"display: inline !important;\"><img class=\"wc-media wc-image\" title=\"Streamline Your Day With Windows 10 Home\" src=\"https://smedia.webcollage.net/rwvfp/wc/cp/24017774_legacycode/module/lenovo/_cp/products/1492531407425/tab-8cab0c06-3c81-4be8-ba56-99cda0d3381a/0be14182-6ae9-461e-95dc-2cad73d90e48.jpg.w960.jpg\" alt=\"\" width=\"960\" height=\"540\" data-asset-title=\"Streamline Your Day With Windows 10 Home\" data-asset-type=\"image\" data-asset-url=\"/_cp/products/1492531407425/tab-8cab0c06-3c81-4be8-ba56-99cda0d3381a/0be14182-6ae9-461e-95dc-2cad73d90e48.jpg\" data-asset-wrapper=\"rich-features\" data-height=\"540\" data-section-template-code=\"rich-features\" data-width=\"960\" /></div>\r\n</div>\r\n<div class=\"wc-text-wrap\">\r\n<h3 class=\"wc-rich-content-header wc-feature-main-header \">STREAMLINE YOUR DAY WITH WINDOWS 10 HOME</h3>\r\n<ul>\r\n<li>The IdeaPad 320 brings you Windows 10 Home, featuring a host of exciting new features. Want to find a local restaurant, or need gift suggestions? Ask Cortana — your very own digital personal assistant. Cortana works with more than a thousand apps and services to ensure you\'ll always have the answers you need. Best of all, it works across all your Windows 10 devices to keep you organized.</li>\r\n</ul>\r\n</div>\r\n<div class=\"wc-media-wrap\" style=\"display: inline !important;\">\r\n<div class=\"wc-media-inner-wrap\" style=\"display: inline !important;\"><img class=\"wc-media wc-image\" title=\"Keep it Simple With Lenovo App Explorer\" src=\"https://smedia.webcollage.net/rwvfp/wc/cp/24017774_legacycode/module/lenovo/_cp/products/1492531407425/tab-8cab0c06-3c81-4be8-ba56-99cda0d3381a/4ef2f533-2270-4206-804f-8448928b41d2.png.w480.png\" alt=\"\" width=\"480\" height=\"478\" data-asset-title=\"Keep it Simple With Lenovo App Explorer\" data-asset-type=\"image\" data-asset-url=\"/_cp/products/1492531407425/tab-8cab0c06-3c81-4be8-ba56-99cda0d3381a/4ef2f533-2270-4206-804f-8448928b41d2.png\" data-asset-wrapper=\"rich-features\" data-height=\"478\" data-section-template-code=\"rich-features\" data-width=\"480\" /></div>\r\n</div>\r\n<div class=\"wc-text-wrap\">\r\n<h3 class=\"wc-rich-content-header wc-feature-main-header \">KEEP IT SIMPLE WITH LENOVO APP EXPLORER</h3>\r\n<ul>\r\n<li>With Lenovo App Explorer, choose only the apps you want. It\'s a straightforward and secure way to personalize your computer, and an essential part of Lenovo\'s commitment to cleaner, safer PCs.</li>\r\n</ul>\r\n</div>\r\n<div class=\"wc-media-wrap\" style=\"display: inline !important;\">\r\n<div class=\"wc-media-inner-wrap\" style=\"display: inline !important;\"><img class=\"wc-media wc-image\" title=\"Redesigned Touchpad, for Improved Responsiveness\" src=\"https://smedia.webcollage.net/rwvfp/wc/cp/24017774_legacycode/module/lenovo/_cp/products/1492531407425/tab-8cab0c06-3c81-4be8-ba56-99cda0d3381a/0f446844-096c-4e26-9710-cfee0edc19b6.jpg.w960.jpg\" alt=\"\" width=\"960\" height=\"540\" data-asset-title=\"Redesigned Touchpad, for Improved Responsiveness\" data-asset-type=\"image\" data-asset-url=\"/_cp/products/1492531407425/tab-8cab0c06-3c81-4be8-ba56-99cda0d3381a/0f446844-096c-4e26-9710-cfee0edc19b6.jpg\" data-asset-wrapper=\"rich-features\" data-height=\"540\" data-section-template-code=\"rich-features\" data-width=\"960\" /></div>\r\n</div>\r\n<div class=\"wc-text-wrap\">\r\n<h3 class=\"wc-rich-content-header wc-feature-main-header \">REDESIGNED TOUCHPAD, FOR IMPROVED RESPONSIVENESS</h3>\r\n<ul>\r\n<li>We redesigned the touchpad on the IdeaPad 320, for a better user experience with multifinger gestures. Touch, click and zoom — you\'ll feel the difference.</li>\r\n</ul>\r\n<h3 class=\"wc-rich-content-header wc-feature-main-header \">EASY ACCESS TO MOVIES AND MORE</h3>\r\n<ul>\r\n<li>The IdeaPad 320 comes equipped with a DVD drive, so you\'ll be able to watch and listen to the movies and music you already own and love.</li>\r\n</ul>\r\n</div>\r\n<div class=\"wc-media-wrap\" style=\"display: inline !important;\">\r\n<div class=\"wc-media-inner-wrap\" style=\"display: inline !important;\"><img class=\"wc-media wc-image\" title=\"Audio Clarity at any Volume\" src=\"https://smedia.webcollage.net/rwvfp/wc/cp/24017774_legacycode/module/lenovo/_cp/products/1492531407425/tab-8cab0c06-3c81-4be8-ba56-99cda0d3381a/4fb4d993-b7ef-4f10-b645-d9cc2ff7c867.jpg.w960.jpg\" alt=\"\" width=\"960\" height=\"540\" data-asset-title=\"Audio Clarity at any Volume\" data-asset-type=\"image\" data-asset-url=\"/_cp/products/1492531407425/tab-8cab0c06-3c81-4be8-ba56-99cda0d3381a/4fb4d993-b7ef-4f10-b645-d9cc2ff7c867.jpg\" data-asset-wrapper=\"rich-features\" data-height=\"540\" data-section-template-code=\"rich-features\" data-width=\"960\" /></div>\r\n</div>\r\n<div class=\"wc-text-wrap\">\r\n<h3 class=\"wc-rich-content-header wc-feature-main-header \">AUDIO CLARITY AT ANY VOLUME</h3>\r\n<ul>\r\n<li>Featuring Dolby Audio-optimized speakers, the IdeaPad 320 delivers crystal-clear audio with minimal distortion at any volume. Stream your favorite playlist or video chat with family — you\'ll hear every detail.</li>\r\n</ul>\r\n</div>\r\n<p><span style=\"font-size: 1.17em;\"></span></p>\r\n<p><span style=\"font-size: 1.17em;\"></span></p>\r\n<p><span style=\"font-size: 1.17em;\"></span></p>\r\n<p><span style=\"font-size: 1.17em;\"></span></p>\r\n<p><span style=\"font-size: 1.17em;\"></span></p>\r\n<p><span style=\"font-size: 1.17em;\"></span></p>\r\n<p><span style=\"font-size: 1.17em;\"></span></p>\r\n<div id=\"wc-overview-fa323867\" class=\"wc-fragment wc-no-focus\" data-channel-product-name=\"\" data-compiler-v=\"2018.17.2.401\" data-cpi=\"N82E16834332734\" data-is-capdesc-open=\"false\" data-language-code=\"en\" data-module-brand=\"Lenovo\" data-module-code=\"lenovo\" data-module-name=\"Lenovo\" data-mpn=\"80XM0000US\" data-produced=\"2018-09-17 05:36\" data-section-caption=\"Overview\" data-section-tag=\"overview\" data-section-template-code=\"rich-features\" data-vendor-name=\"IdeaPad 320 17 (80XM0000US)\" data-wcpc=\"1492531407425\" data-is-reported-view=\"true\">\r\n<div class=\"wc-aplus-body\">\r\n<div class=\"wc-reset\"></div>\r\n</div>\r\n</div>\r\n<div id=\"wc-features-49eb97b5\" class=\"wc-fragment wc-no-focus\" data-channel-product-name=\"\" data-compiler-v=\"2018.17.2.401\" data-cpi=\"N82E16834332734\" data-is-capdesc-open=\"false\" data-language-code=\"en\" data-module-brand=\"Lenovo\" data-module-code=\"lenovo\" data-module-name=\"Lenovo\" data-mpn=\"80XM0000US\" data-produced=\"2018-09-17 05:36\" data-section-caption=\"Features\" data-section-tag=\"features\" data-section-template-code=\"rich-features\" data-vendor-name=\"IdeaPad 320 17 (80XM0000US)\" data-wcpc=\"1492531407425\" data-is-reported-view=\"true\">\r\n<div class=\"wc-aplus-body\">\r\n<div class=\"wc-reset\"></div>\r\n</div>\r\n</div>'),('238',85,0,'80','Lenovo IdeaPad 320-17IKB '),('239',75,0,'81','<table class=\"specTable\" data-selenium=\"specTable\">\r\n<tbody data-selenium=\"specBody\">\r\n<tr><th class=\"specHeader Header\" colspan=\"2\" data-selenium=\"specHeader\"><a id=\"11011\" class=\"fs32 OpenSans-300-normal\" name=\"11011\" data-selenium=\"specHeaderLink\"></a>Performance</th></tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Processor</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Intel Celeron N3010 Dual-Core</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Base Clock Speed</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">1.04 GHz</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Maximum Boost Speed</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">2.24 GHz</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">L2 Cache</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">1 x 2 MB</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Total Installed Memory</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">2 GB</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Maximum Memory Capacity</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">8 GB</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Memory Type</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">DDR3L SDRAM</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Memory Speed</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">1600 MHz</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Available Memory Slots</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">1</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Memory Slot Type</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">204-Pin SO-DIMM</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Graphics Type</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Integrated</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">GPU</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Intel HD Graphics 400</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<table class=\"specTable\" data-selenium=\"specTable\">\r\n<tbody data-selenium=\"specBody\">\r\n<tr><th class=\"specHeader Header\" colspan=\"2\" data-selenium=\"specHeader\"><a id=\"15001\" class=\"fs32 OpenSans-300-normal\" name=\"15001\" data-selenium=\"specHeaderLink\"></a>Drives</th></tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Storage Drive</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Installed: 16 GB SSD</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Optical Drive</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\"><i>None</i></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<table class=\"specTable\" data-selenium=\"specTable\">\r\n<tbody data-selenium=\"specBody\">\r\n<tr><th class=\"specHeader Header\" colspan=\"2\" data-selenium=\"specHeader\"><a id=\"60547\" class=\"fs32 OpenSans-300-normal\" name=\"60547\" data-selenium=\"specHeaderLink\"></a>Inputs / Outputs</th></tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Ports</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">4 x USB 3.1 Gen 1 Type-A<br />2 x USB 2.0 Type-A</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Display</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">2 x DisplayPort</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Audio</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">1 x 1/8\" (3.5 mm) Headphone/Microphone Combo Jack<br />1 x 1/8\" (3.5 mm) Headphone Output<br />1 x 1/8\" (3.5 mm) Microphone Input<br />1 x Integrated Speaker</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Flash Media Slot</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\"><i>None</i></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<table class=\"specTable\" data-selenium=\"specTable\">\r\n<tbody data-selenium=\"specBody\">\r\n<tr><th class=\"specHeader Header\" colspan=\"2\" data-selenium=\"specHeader\"><a id=\"15002\" class=\"fs32 OpenSans-300-normal\" name=\"15002\" data-selenium=\"specHeaderLink\"></a>Communications</th></tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Network</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">1 x 10/100/1000 Mb/s Gigabit Ethernet (RJ45)</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Wi-Fi</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">802.11ac; Dual-Band</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Bluetooth</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Bluetooth 4.0</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<table class=\"specTable\" data-selenium=\"specTable\">\r\n<tbody data-selenium=\"specBody\">\r\n<tr><th class=\"specHeader Header\" colspan=\"2\" data-selenium=\"specHeader\"><a id=\"91003\" class=\"fs32 OpenSans-300-normal\" name=\"91003\" data-selenium=\"specHeaderLink\"></a>Keyboard &amp; Mouse</th></tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Keyboard</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Type: Full-Size</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Mouse</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">USB</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<table class=\"specTable\" data-selenium=\"specTable\">\r\n<tbody data-selenium=\"specBody\">\r\n<tr><th class=\"specHeader Header\" colspan=\"2\" data-selenium=\"specHeader\"><a id=\"8008\" class=\"fs32 OpenSans-300-normal\" name=\"8008\" data-selenium=\"specHeaderLink\"></a>General</th></tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Power Supply</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">65 W</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Dimensions (W x H x D)</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">7.0 x 1.3 x 7.2\" / 17.8 x 3.3 x 18.3 cm</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Weight</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">2.9 lb / 1.3 kg</td>\r\n</tr>\r\n</tbody>\r\n</table>'),('240',76,0,'81','<div class=\"ov-wrapper js-overview-desc\">\r\n<div class=\"ov-desc\">\r\n<p class=\"ov-desc-paragraph\">Stay productive without taking up too much space with the <strong>Lenovo ThinkCentre M600 Tiny Desktop Computer</strong>. Its smaller design provides more desk space. It has integrated Intel HD Graphics 400 and you can connect to an external display via DisplayPort.</p>\r\n<p>The system is powered by a 1.04 GHz Intel Celeron N3010 Dual-Core processor. It also has 2GB of 1600 MHz DDR3L RAM, a 16GB M.2 SSD, two DisplayPort outputs that support resolutions up to 3840 x 2160 @ 30 Hz, four USB 3.0 Type-A ports, and two USB 2.0 Type-A ports. A Lenovo wired keyboard and mouse are included, as is an external 65W power adapter. There is also a floor stand so you can place the ThinkCentre M600 vertically. LeTOS (Lenovo Terminal Operating System is the installed operating system.</p>\r\n</div>\r\n</div>\r\n<div class=\"sectionHeaders js-hiddenFeatures\" data-selenium=\"sectionHeaders\"><dl class=\"js-featureSectionDL\">Trusted Platform Module, TCG 1.2 compliant</dl><br /><dl class=\"js-featureSectionDL\">Security slot in rear for optional Kensington MicroSaver cable</dl><br /><dl class=\"js-featureSectionDL\">Chassis intrusion switch</dl><br /><dl class=\"js-featureSectionDL\">Padlock loop</dl><br /><dl class=\"js-featureSectionDL\">Smart USB protection allows keyboard/mouse only and blocks all storage devices</dl><br /><dl class=\"js-featureSectionDL\">Power-on, administrator, and hard disk passwords</dl><br /><dl class=\"js-featureSectionDL\">Boot sequence control</dl><br /><dl class=\"js-featureSectionDL\">Boot without keyboard and mouse</dl><br /><dl class=\"js-featureSectionDL\">Individual USB port disablement</dl><br /><dl class=\"js-featureSectionDL\">Realtek ALC223 high definition (HD) audio</dl><br /><dl class=\"js-featureSectionDL\">One 1W speaker</dl><br /><dl class=\"js-featureSectionDL\">Realtek RTL8111GN Ethernet with Wake on LAN</dl></div>'),('241',85,0,'81','Lenovo ThinkCentre M600 \"Tiny\" (Celeron Model)'),('242',75,0,'82','<ul class=\"specs\">\r\n<li>\r\n<h4>Processor</h4>\r\n<ul>\r\n<li><label>Clock Speed :</label><span>1.04 GHz</span></li>\r\n<li><label>Installed Qty :</label><span>1</span></li>\r\n<li><label>Manufacturer :</label><span>Intel</span></li>\r\n<li><label>Max Supported Qty :</label><span>1</span></li>\r\n<li><label>Max Turbo Speed :</label><span>2.24 GHz</span></li>\r\n<li><label>Number of Cores :</label><span>Dual-Core</span></li>\r\n<li><label>Processor Main Features :</label><span>Intel Burst Technology</span></li>\r\n<li><label>Processor Number :</label><span>N3010</span></li>\r\n<li><label>Type :</label><span>Celeron</span></li>\r\n</ul>\r\n</li>\r\n<li>\r\n<h4>Optical Storage</h4>\r\n<ul>\r\n<li><label>Drive Type :</label><span>No optical drive</span></li>\r\n<li><label>Type :</label><span>None</span></li>\r\n</ul>\r\n</li>\r\n<li>\r\n<h4>Service &amp; Support</h4>\r\n<ul>\r\n<li><label>On-Site Warranty :</label><span>On-site</span></li>\r\n<li><label>Type :</label><span>1 year warranty</span></li>\r\n</ul>\r\n</li>\r\n<li>\r\n<h4>Storage Hard Drive</h4>\r\n<ul>\r\n<li><label>Capacity :</label><span>32 GB</span></li>\r\n<li><label>Interface Type :</label><span>Serial ATA-600</span></li>\r\n</ul>\r\n</li>\r\n<li>\r\n<h4>Audio Input</h4>\r\n<ul>\r\n<li><label>Type :</label><span>None</span></li>\r\n</ul>\r\n</li>\r\n<li>\r\n<h4>Audio Output</h4>\r\n<ul>\r\n<li><label>Compliant Standards :</label><span>High Definition Audio</span></li>\r\n<li><label>Sound Output Mode :</label><span>Stereo</span></li>\r\n</ul>\r\n</li>\r\n<li>\r\n<h4>Bay Provided</h4>\r\n<ul>\r\n<li><label>Form Factor :</label><span>2.5\"</span></li>\r\n<li><label>Free Qty :</label><span>1</span></li>\r\n<li><label>Total Qty :</label><span>1</span></li>\r\n</ul>\r\n</li>\r\n<li>\r\n<h4>Cabinet</h4>\r\n<ul>\r\n<li><label>Chassis Built-in Devices :</label><span>Speaker</span></li>\r\n</ul>\r\n</li>\r\n<li>\r\n<h4>Dimensions &amp; Weight</h4>\r\n<ul>\r\n<li><label>Depth :</label><span>7.2 in</span></li>\r\n<li><label>Height :</label><span>1.4 in</span></li>\r\n<li><label>Weight :</label><span>2.87 lbs</span></li>\r\n<li><label>Width :</label><span>7 in</span></li>\r\n</ul>\r\n</li>\r\n<li>\r\n<h4>Display</h4>\r\n<ul>\r\n<li><label>Type :</label><span>None.</span></li>\r\n</ul>\r\n</li>\r\n<li>\r\n<h4>Header</h4>\r\n<ul>\r\n<li><label>Brand :</label><span>Lenovo</span></li>\r\n<li><label>Compatibility :</label><span>PC</span></li>\r\n<li><label>Country Kits :</label><span>United States</span></li>\r\n<li><label>Localization :</label><span>English</span></li>\r\n<li><label>Manufacturer :</label><span>Lenovo Express Models</span></li>\r\n<li><label>Model :</label><span>10KH</span></li>\r\n<li><label>Packaged Quantity :</label><span>1</span></li>\r\n<li><label>Product Line :</label><span>Lenovo ThinkCentre M600</span></li>\r\n</ul>\r\n</li>\r\n<li>\r\n<h4>Input Device</h4>\r\n<ul>\r\n<li><label>Type :</label><span>Keyboard, Mouse</span></li>\r\n</ul>\r\n</li>\r\n<li>\r\n<h4>Interface Provided</h4>\r\n<ul>\r\n<li><label>Comment :</label><span>One of them is Always On and fast-charging</span></li>\r\n<li><label>Location :</label><span>2 front, 2 rear</span></li>\r\n<li><label>Qty :</label><span>4</span></li>\r\n<li><label>Type :</label><span>USB 3.0</span></li>\r\n<li><label>Location :</label><span>1 in front</span></li>\r\n<li><label>Qty :</label><span>1</span></li>\r\n<li><label>Type :</label><span>Microphone</span></li>\r\n<li><label>Qty :</label><span>2</span></li>\r\n<li><label>Type :</label><span>USB 2.0</span></li>\r\n<li><label>Type :</label><span>DisplayPort</span></li>\r\n<li><label>Type :</label><span>Headphones</span></li>\r\n<li><label>Type :</label><span>Headphones/microphone</span></li>\r\n<li><label>Type :</label><span>LAN (Gigabit Ethernet)</span></li>\r\n</ul>\r\n</li>\r\n<li>\r\n<h4>Miscellaneous</h4>\r\n<ul>\r\n<li><label>Color :</label><span>Black</span></li>\r\n<li><label>Color Category :</label><span>Black</span></li>\r\n<li><label>Compliant Standards :</label><span>Energy-Related Products (ErP) Lot 3, GREENGUARD, RoHS</span></li>\r\n<li><label>Included Accessories :</label><span>Vertical stand</span></li>\r\n<li><label>Manufacturer Selling Program :</label><span>TopSeller</span></li>\r\n<li><label>Security Slot Type :</label><span>Kensington security slot</span></li>\r\n<li><label>Theft/Intrusion Protection :</label><span>Chassis intrusion switch, Padlock loop, Security lock slot (cable lock sold separately)</span></li>\r\n</ul>\r\n</li>\r\n<li>\r\n<h4>Networking</h4>\r\n<ul>\r\n<li><label>Data Link Protocol :</label><span>Ethernet, Fast Ethernet, Gigabit Ethernet</span></li>\r\n<li><label>Ethernet Controller(s) :</label><span>Realtek RTL8111GN</span></li>\r\n<li><label>Features :</label><span>Wake on LAN (WoL)</span></li>\r\n</ul>\r\n</li>\r\n<li>\r\n<h4>Optical Storage (2nd)</h4>\r\n<ul>\r\n<li><label>Drive Type :</label><span>No optical drive</span></li>\r\n<li><label>Type :</label><span>None</span></li>\r\n</ul>\r\n</li>\r\n<li>\r\n<h4>OS Provided</h4>\r\n<ul>\r\n<li><label>Edition :</label><span>Windows 10 IOT</span></li>\r\n<li><label>Family :</label><span>Windows 10</span></li>\r\n<li><label>Type :</label><span>Windows 10 IOT Enterprise</span></li>\r\n</ul>\r\n</li>\r\n<li>\r\n<h4>Power Device</h4>\r\n<ul>\r\n<li><label>Efficiency :</label><span>88%</span></li>\r\n<li><label>Frequency Required :</label><span>50/60 Hz</span></li>\r\n<li><label>Nominal Voltage :</label><span>AC 120/230 V</span></li>\r\n<li><label>Power Provided :</label><span>65 Watt</span></li>\r\n<li><label>Type :</label><span>Power adapter</span></li>\r\n</ul>\r\n</li>\r\n<li>\r\n<h4>Printer</h4>\r\n<ul>\r\n<li><label>Type :</label><span>None</span></li>\r\n</ul>\r\n</li>\r\n<li>\r\n<h4>RAM</h4>\r\n<ul>\r\n<li><label>Configuration Features :</label><span>1 x 4 GB</span></li>\r\n<li><label>Data Integrity Check :</label><span>Non-ECC</span></li>\r\n<li><label>Empty Slots :</label><span>0</span></li>\r\n<li><label>Features :</label><span>Low-voltage</span></li>\r\n<li><label>Form Factor :</label><span>SO-DIMM 204-pin</span></li>\r\n<li><label>Installed Size :</label><span>4 GB</span></li>\r\n<li><label>Max Supported Size :</label><span>8 GB</span></li>\r\n<li><label>Memory Speed :</label><span>1600 MHz</span></li>\r\n<li><label>Rated Memory Speed :</label><span>1600 MHz</span></li>\r\n<li><label>Slots Qty :</label><span>1</span></li>\r\n<li><label>Technology :</label><span>DDR3L SDRAM</span></li>\r\n</ul>\r\n</li>\r\n<li>\r\n<h4>Service</h4>\r\n<ul>\r\n<li><label>Support Details Full Contract Period :</label><span>1 year</span></li>\r\n<li><label>Support Details Location :</label><span>On-site</span></li>\r\n<li><label>Support Details Type :</label><span>Limited warranty</span></li>\r\n</ul>\r\n</li>\r\n<li>\r\n<h4>Slot Provided</h4>\r\n<ul>\r\n<li><label>Free Qty :</label><span>0</span></li>\r\n<li><label>Total Qty :</label><span>1</span></li>\r\n</ul>\r\n</li>\r\n<li>\r\n<h4>Storage Controller</h4>\r\n<ul>\r\n<li><label>Channel Qty :</label><span>1</span></li>\r\n<li><label>Installed Qty :</label><span>1</span></li>\r\n<li><label>Interface Type :</label><span>Serial ATA-600</span></li>\r\n<li><label>Type :</label><span>Serial ATA</span></li>\r\n</ul>\r\n</li>\r\n<li>\r\n<h4>Storage Controller (2nd)</h4>\r\n<ul>\r\n<li><label>Type :</label><span>None</span></li>\r\n</ul>\r\n</li>\r\n<li>\r\n<h4>Storage Removable</h4>\r\n<ul>\r\n<li><label>Type :</label><span>None</span></li>\r\n</ul>\r\n</li>\r\n<li>\r\n<h4>System</h4>\r\n<ul>\r\n<li><label>Embedded Security :</label><span>Trusted Platform Module (TPM 1.2) Security Chip</span></li>\r\n<li><label>Hard Drive Capacity :</label><span>32 GB</span></li>\r\n<li><label>Type :</label><span>Thin client</span></li>\r\n</ul>\r\n</li>\r\n<li>\r\n<h4>Video Output</h4>\r\n<ul>\r\n<li><label>Graphics Processor Series :</label><span>Intel HD Graphics</span></li>\r\n<li><label>Graphics Processor Vendor :</label><span>Intel HD Graphics 400</span></li>\r\n<li><label>Max Monitors Supported :</label><span>2</span></li>\r\n<li><label>Video Interfaces :</label><span>DisplayPort</span></li>\r\n</ul>\r\n</li>\r\n<li>\r\n<h4>Audio Output Details</h4>\r\n<ul>\r\n<li><label>Speaker Type :</label><span>None</span></li>\r\n</ul>\r\n</li>\r\n<li>\r\n<h4>Cache Memory</h4>\r\n<ul>\r\n<li><label>Installed Size :</label><span>2 MB</span></li>\r\n<li><label>Per Processor Size :</label><span>2 MB</span></li>\r\n</ul>\r\n</li>\r\n<li>\r\n<h4>Chassis</h4>\r\n<ul>\r\n<li><label>Form Factor :</label><span>Ultra small form factor</span></li>\r\n<li><label>Manufacturer Form Factor :</label><span>Tiny desktop</span></li>\r\n</ul>\r\n</li>\r\n<li>\r\n<h4>Environmental Standards</h4>\r\n<ul>\r\n<li><label>ENERGY STAR Certified :</label><span>Yes</span></li>\r\n<li><label>ENERGY STAR Version :</label><span>6.0</span></li>\r\n</ul>\r\n</li>\r\n<li>\r\n<h4>Expansion Bays</h4>\r\n<ul>\r\n<li><label>Form Factor (metric) :</label><span>6.4 cm</span></li>\r\n<li><label>Type :</label><span>Internal</span></li>\r\n</ul>\r\n</li>\r\n<li>\r\n<h4>Expansion Slots</h4>\r\n<ul>\r\n<li><label>Type :</label><span>CPU</span></li>\r\n<li><label>Type :</label><span>SO-DIMM 204-pin</span></li>\r\n</ul>\r\n</li>\r\n<li>\r\n<h4>Hard Drive</h4>\r\n<ul>\r\n<li><label>Installed Qty :</label><span>1</span></li>\r\n<li><label>Interface Class :</label><span>Serial ATA</span></li>\r\n<li><label>SSD Form Factor :</label><span>M.2 2242</span></li>\r\n<li><label>Type :</label><span>SSD</span></li>\r\n</ul>\r\n</li>\r\n<li>\r\n<h4>Keyboard</h4>\r\n<ul>\r\n<li><label>Interface :</label><span>USB</span></li>\r\n</ul>\r\n</li>\r\n<li>\r\n<h4>Mouse</h4>\r\n<ul>\r\n<li><label>Interface :</label><span>USB</span></li>\r\n</ul>\r\n</li>\r\n</ul>'),('243',76,0,'82','<ul>\r\n<li>Thin Client</li>\r\n<li>Tiny Desktop</li>\r\n<li>1 x Celeron N3010 / 1.04 GHz</li>\r\n<li>RAM 4 GB</li>\r\n<li>SSD 32 GB</li>\r\n<li>HD Graphics 400</li>\r\n<li>GigE</li>\r\n<li>Win 10 IOT Enterprise</li>\r\n</ul>\r\n<div id=\"header-229dd4\" class=\"ccs-cc-inline-section ccs-cc-inline-header\" data-elementid=\"inline-content-header[len]\" data-ccs-cc-inline-jumplink=\"Overview\">\r\n<div class=\"ccs-cc-inline-header-layout\" data-type=\"text media\">\r\n<div class=\"ccs-cc-inline-header-description\">\r\n<div data-cnet-ccs-icb-annotation=\"true\"><span data-cnet-ccs-icb-annotation=\"true\"></span></div>\r\n<div data-cnet-ccs-icb-annotation=\"true\"><span data-cnet-ccs-icb-annotation=\"true\"></span></div>\r\n<div data-cnet-ccs-icb-annotation=\"true\"><span data-cnet-ccs-icb-annotation=\"true\"></span></div>\r\n<div data-cnet-ccs-icb-annotation=\"true\"><span data-cnet-ccs-icb-annotation=\"true\"></span></div>\r\n<div data-cnet-ccs-icb-annotation=\"true\"><span data-cnet-ccs-icb-annotation=\"true\"></span></div>\r\n<div data-cnet-ccs-icb-annotation=\"true\"><strong><span data-cnet-ccs-icb-annotation=\"true\">ULTRACOMPACT PERFORMANCE THIN CLIENT.</span></strong></div>\r\n<div data-cnet-ccs-icb-annotation=\"true\">The ThinkCentre M600 Thin Client is a great solution for businesses looking for a quiet, compact thin client that can be deployed anywhere. It supports multiple independent monitors and 4K resolution content, and has plenty of ports for robust connectivity and speedy data transfer.</div>\r\n</div>\r\n<div class=\"ccs-cc-inline-header-hero\"></div>\r\n<div class=\"ccs-cc-inline-header-hero\"><strong><a class=\"ccs-cc-thumbnail-wrapper\" tabindex=\"0\">Nimble Performer</a></strong></div>\r\n</div>\r\n</div>\r\n<div class=\"ccs-cc-inline-section ccs-cc-inline-features\" data-elementid=\"inline-content-features[len]\" data-ccs-cc-inline-jumplink=\"Features\">\r\n<div class=\"ccs-cc-inline-features-block ccs-cc-inline-single-feature\">\r\n<div class=\"ccs-cc-inline-feature\" data-type=\"text media\" data-pos=\"right\">\r\n<div class=\"ccs-cc-inline-feature-content ccs-cc-inline-feature-description\">For speed without all the bells and whistles, the M600\'s processor delivers the processing power you need to help you work smarter. And the ultrasmall form factor fits just about anywhere – you can even mount it on a wall, or on the back of a monitor – yet provides reliable enterprise-level performance.\r\n<div data-cnet-ccs-icb-annotation=\"true\"></div>\r\n<div data-cnet-ccs-icb-annotation=\"true\"><span data-cnet-ccs-icb-annotation=\"true\"><strong>Flexible Performer</strong><br data-cnet-ccs-icb-annotation=\"true\" /></span>Transfer data quickly and connect all your peripherals with USB 3.0 ports and USB 2.0 ports. Connect multiple monitors to expand workspace, which makes navigation between applications easier and improves productivity.</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"ccs-cc-inline-features-block ccs-cc-inline-single-feature\">\r\n<div class=\"ccs-cc-inline-feature\" data-type=\"text media\" data-pos=\"left\">\r\n<div class=\"ccs-cc-inline-feature-content ccs-cc-inline-thumbnail\"></div>\r\n<div class=\"ccs-cc-inline-feature-content ccs-cc-inline-feature-description\">\r\n<div data-cnet-ccs-icb-annotation=\"true\"><strong><span data-cnet-ccs-icb-annotation=\"true\">Strong, Silent Type</span></strong></div>\r\n<div data-cnet-ccs-icb-annotation=\"true\">The ThinkCentre M600 Tiny Thin Client features a fanless design that produces absolutely no noise – perfect for a quiet office or dusty environments.</div>\r\n<div data-cnet-ccs-icb-annotation=\"true\"></div>\r\n<div data-cnet-ccs-icb-annotation=\"true\"><strong><span data-cnet-ccs-icb-annotation=\"true\">Power On</span></strong></div>\r\n<div data-cnet-ccs-icb-annotation=\"true\">If you choose to mount this compact unit on the back of your monitor, you can still power on conveniently from the front.</div>\r\n</div>\r\n</div>\r\n</div>\r\n</div>'),('244',85,0,'82','Lenovo ThinkCentre M600 \"Tiny\" (SSD Model)');
INSERT INTO `catalog_product_entity_text` VALUES ('245',75,0,'83','<fieldset>\r\n<h3 class=\"specTitle\">Model</h3>\r\n<dl><dt>Brand</dt><dd>Lenovo</dd></dl><dl><dt>Series</dt><dd>ThinkCentre</dd></dl><dl><dt>Model</dt><dd>M710s (10M7000SUS)</dd></dl><dl><dt>Part Number</dt><dd>10M7000SUS</dd></dl></fieldset><fieldset>\r\n<h3 class=\"specTitle\">Quick Info</h3>\r\n<dl><dt>Type</dt><dd>Business Desktops &amp; Workstations</dd></dl><dl><dt><a id=\"def_colorPopup__1415\" class=\"specs-popup\" name=\"def-color\" data-t-events=\"A\" data-t-e-var78=\"Specification Popup:Form Factor\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>Form Factor</dt><dd>Slim/Small form factor</dd></dl><dl><dt>Usage</dt><dd>Business</dd></dl><dl><dt>Colors</dt><dd>Black</dd></dl><dl><dt><a id=\"def_colorPopup__2640\" class=\"specs-popup\" name=\"def-color\" data-t-events=\"A\" data-t-e-var78=\"Specification Popup:Processor\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>Processor</dt><dd>Intel Core i5-7400 3.00 GHz</dd></dl><dl><dt><a id=\"def_colorPopup__2665\" class=\"specs-popup\" name=\"def-color\" data-t-events=\"A\" data-t-e-var78=\"Specification Popup:Processor Main Features\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>Processor Main Features</dt><dd>64 bit Quad-Core Processor</dd></dl><dl><dt><a id=\"def_colorPopup__2664\" class=\"specs-popup\" name=\"def-color\" data-t-events=\"A\" data-t-e-var78=\"Specification Popup:Cache Per Processor\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>Cache Per Processor</dt><dd>6 MB L3 Cache</dd></dl><dl><dt><a id=\"def_colorPopup__2642\" class=\"specs-popup\" name=\"def-color\" data-t-events=\"A\" data-t-e-var78=\"Specification Popup:Memory\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>Memory</dt><dd>8 GB DDR4 2400</dd></dl><dl><dt><a id=\"def_colorPopup__2643\" class=\"specs-popup\" name=\"def-color\" data-t-events=\"A\" data-t-e-var78=\"Specification Popup:Storage\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>Storage</dt><dd>1 TB 7200 RPM HDD</dd></dl><dl><dt><a id=\"def_colorPopup__2644\" class=\"specs-popup\" name=\"def-color\" data-t-events=\"A\" data-t-e-var78=\"Specification Popup:Optical Drive\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>Optical Drive</dt><dd>DVDRW</dd></dl><dl><dt><a id=\"def_colorPopup__2647\" class=\"specs-popup\" name=\"def-color\" data-t-events=\"A\" data-t-e-var78=\"Specification Popup:Graphics\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>Graphics</dt><dd>Intel HD Graphics 630</dd></dl><dl><dt>Power Supply</dt><dd>210W</dd></dl><dl><dt><a id=\"def_colorPopup__1413\" class=\"specs-popup\" name=\"def-color\" data-t-events=\"A\" data-t-e-var78=\"Specification Popup:Operating System\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>Operating System</dt><dd>Windows 10 Pro 64-Bit</dd></dl></fieldset><fieldset>\r\n<h3 class=\"specTitle\">CPU</h3>\r\n<dl><dt><a id=\"def_colorPopup__1418\" class=\"specs-popup\" name=\"def-color\" data-t-events=\"A\" data-t-e-var78=\"Specification Popup:CPU Type\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>CPU Type</dt><dd>Intel Core i5 7th Gen</dd></dl><dl><dt><a id=\"def_colorPopup__1419\" class=\"specs-popup\" name=\"def-color\" data-t-events=\"A\" data-t-e-var78=\"Specification Popup:CPU Speed\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>CPU Speed</dt><dd>7400 (3.00 GHz)</dd></dl><dl><dt><a id=\"def_colorPopup__7456\" class=\"specs-popup\" name=\"def-color\" data-t-events=\"A\" data-t-e-var78=\"Specification Popup:L3 Cache Per CPU\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>L3 Cache Per CPU</dt><dd>6 MB</dd></dl><dl><dt>CPU Main Features</dt><dd>64 bit Quad-Core Processor</dd></dl></fieldset><fieldset>\r\n<h3 class=\"specTitle\">Graphics</h3>\r\n<dl><dt><a id=\"def_colorPopup__1436\" class=\"specs-popup\" name=\"def-color\" data-t-events=\"A\" data-t-e-var78=\"Specification Popup:GPU/VGA Type\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>GPU/VGA Type</dt><dd>Intel HD Graphics 630</dd></dl><dl><dt>Graphics Interface</dt><dd>Integrated video</dd></dl></fieldset><fieldset>\r\n<h3 class=\"specTitle\">Memory</h3>\r\n<dl><dt><a id=\"def_colorPopup__1423\" class=\"specs-popup\" name=\"def-color\" data-t-events=\"A\" data-t-e-var78=\"Specification Popup:Memory Capacity\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>Memory Capacity</dt><dd>8 GB DDR4</dd></dl><dl><dt><a id=\"def_colorPopup__1424\" class=\"specs-popup\" name=\"def-color\" data-t-events=\"A\" data-t-e-var78=\"Specification Popup:Memory Speed\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>Memory Speed</dt><dd>DDR4 2400</dd></dl><dl><dt>Memory Spec</dt><dd>8 GB x 1</dd></dl></fieldset><fieldset>\r\n<h3 class=\"specTitle\">Storage</h3>\r\n<dl><dt><a id=\"def_colorPopup__37707\" class=\"specs-popup\" name=\"def-color\" data-t-events=\"A\" data-t-e-var78=\"Specification Popup:SSD\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>SSD</dt><dd>No</dd></dl><dl><dt>HDD</dt><dd>1 TB</dd></dl><dl><dt><a id=\"def_colorPopup__1428\" class=\"specs-popup\" name=\"def-color\" data-t-events=\"A\" data-t-e-var78=\"Specification Popup:HDD RPM\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>HDD RPM</dt><dd>7200rpm</dd></dl></fieldset><fieldset>\r\n<h3 class=\"specTitle\">Optical Drive</h3>\r\n<dl><dt>Optical Drive Type</dt><dd>DVD±RW</dd></dl></fieldset><fieldset>\r\n<h3 class=\"specTitle\">Display</h3>\r\n<dl><dt><a id=\"def_colorPopup__1440\" class=\"specs-popup\" name=\"def-color\" data-t-events=\"A\" data-t-e-var78=\"Specification Popup:Screen Size\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>Screen Size</dt><dd>No Screen</dd></dl></fieldset><fieldset>\r\n<h3 class=\"specTitle\">Mouse</h3>\r\n<dl><dt>Mouse Type</dt><dd>USB Mouse</dd></dl></fieldset><fieldset>\r\n<h3 class=\"specTitle\">Keyboard</h3>\r\n<dl><dt>Keyboard Type</dt><dd>USB Keyboard</dd></dl></fieldset><fieldset>\r\n<h3 class=\"specTitle\">Dimensions &amp; Weight</h3>\r\n<dl><dt>Dimensions (H x W x D)</dt><dd>13.50\" x 3.60\" x 11.40\"</dd></dl><dl><dt>Weight</dt><dd>13.20 lbs.</dd></dl></fieldset>'),('246',76,0,'83','<ul>\r\n<li class=\"item\">Intel Core i5 7th Gen 7400 (3.00 GHz)</li>\r\n<li class=\"item\">8 GB DDR4</li>\r\n<li class=\"item\">1 TB HDD</li>\r\n<li class=\"item\">Windows 10 Pro 64-Bit</li>\r\n<li class=\"item\">No Screen</li>\r\n<li class=\"item\">Intel HD Graphics 630</li>\r\n</ul>\r\n<div id=\"header-930ab1\" class=\"ccs-cc-inline-section ccs-cc-inline-header\" data-elementid=\"inline-content-header[len]\" data-ccs-cc-inline-jumplink=\"Overview\">\r\n<div class=\"ccs-cc-inline-header-layout\" data-type=\"text media\">\r\n<div class=\"ccs-cc-inline-header-description\"><span><b>The Power to Drive Your Business</b></span>\r\n<div><b><br /></b>\r\n<div><span>Extremely powerful, easy to manage, and configurable, ThinkCentre M710 SFF can be tailored to meet your computing needs today – and tomorrow. Boasting great performance and storage technology, this PC is super-fast, responsive, and efficient. As well as being able to empower you and your business, it comes with robust security features to safeguard your critical data and the built-in reliability your organization can count on.</span></div>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div id=\"media-930ab1\" class=\"ccs-cc-inline-section ccs-cc-inline-media\" data-elementid=\"inline-content-gallery[len]\" data-ccs-cc-inline-jumplink=\"Media\">\r\n<div class=\"ccs-cc-ig ccs-cc-ig-cloud\" data-config=\"{&quot;layout&quot;:&quot;cloud&quot;,&quot;logCall&quot;:&quot;{\\&quot;logFunctionName\\&quot;:\\&quot;ccs_cc_loge_258540\\&quot;,\\&quot;paramsFunctionName\\&quot;:\\&quot;ccs_cc_gete_params_258540\\&quot;,\\&quot;eventId\\&quot;:\\&quot;ac7c13b2\\&quot;}&quot;,&quot;errorLogCall&quot;:&quot;{\\&quot;logFunctionName\\&quot;:\\&quot;ccs_cc_loge_258540\\&quot;,\\&quot;paramsFunctionName\\&quot;:\\&quot;ccs_cc_gete_params_258540\\&quot;,\\&quot;eventId\\&quot;:\\&quot;7c8099d6\\&quot;}&quot;}\">\r\n<div class=\"ccs-slick-initialized ccs-slick-slider\">\r\n<div class=\"ccs-slick-list\">\r\n<div class=\"ccs-slick-track\">\r\n<div class=\"ccs-slick-slide ccs-slick-current ccs-slick-active ccs-ig-cloud-active\" tabindex=\"-1\" data-media-type=\"image\" data-image-url=\"https://cc.cnetcontent.com/inlinecontent/mediaserver/all/bd1/c85/bd1c85f753735d2d492ae3b8ad2e9d24/original.png\" data-caption=\"\" data-zoom-log-call=\"{&quot;logFunctionName&quot;:&quot;ccs_cc_loge_258540&quot;,&quot;paramsFunctionName&quot;:&quot;ccs_cc_gete_params_258540&quot;,&quot;eventId&quot;:&quot;cd0817bc&quot;}\" data-ccs-fancybox=\"media-930ab1\" data-src=\"https://cc.cnetcontent.com/inlinecontent/mediaserver/all/bd1/c85/bd1c85f753735d2d492ae3b8ad2e9d24/original.png\" data-slick-index=\"0\"></div>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"ccs-cc-inline-section ccs-cc-inline-features\" data-elementid=\"inline-content-features[len]\" data-ccs-cc-inline-jumplink=\"Features\">\r\n<div class=\"ccs-cc-inline-features-block ccs-cc-inline-single-feature\">\r\n<div class=\"ccs-cc-inline-feature\" data-type=\"text media\" data-pos=\"right\">\r\n<div class=\"ccs-cc-inline-feature-content ccs-cc-inline-feature-description\">\r\n<h3>B.I.G. on Power</h3>\r\n<div data-cnet-ccs-icb-annotation=\"true\">Powered by an excellent processor, a ThinkCentre M710 SFF is designed for speed, responsiveness, and efficiency — three key features, that can help propel your business.</div>\r\n<div data-cnet-ccs-icb-annotation=\"true\"></div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"ccs-cc-inline-features-block ccs-cc-inline-single-feature\">\r\n<div class=\"ccs-cc-inline-feature\" data-type=\"text media\" data-pos=\"left\">\r\n<div class=\"ccs-cc-inline-feature-content ccs-cc-inline-thumbnail\"><a class=\"ccs-cc-inline-thumbnail-image ccs-cc-inline-thumbnail-media ccs-cc-inline-clickable\" title=\"Lenovo ThinkCentre M710 SFF show larger image\" href=\"https://cc.cnetcontent.com/inlinecontent/mediaserver/all/511/479/511479f95ab2e608dec6366fd52422c3/original.png\" data-media-type=\"image\" data-zoom-log-call=\"{&quot;logFunctionName&quot;:&quot;ccs_cc_loge_258540&quot;,&quot;paramsFunctionName&quot;:&quot;ccs_cc_gete_params_258540&quot;,&quot;eventId&quot;:&quot;c84685dc&quot;}\" data-hover-log-call=\"{&quot;logFunctionName&quot;:&quot;ccs_cc_loge_258540&quot;,&quot;paramsFunctionName&quot;:&quot;ccs_cc_gete_params_258540&quot;,&quot;eventId&quot;:&quot;1f922bc0&quot;}\" data-caption=\"Lenovo ThinkCentre M710 SFF\"><span class=\"ccs-cc-inline-image-zoom\"></span><img src=\"https://cc.cnetcontent.com/inlinecontent/mediaserver/all/511/479/511479f95ab2e608dec6366fd52422c3/width(400).png\" alt=\"Lenovo ThinkCentre M710 SFF\" data-large=\"https://cc.cnetcontent.com/inlinecontent/mediaserver/all/511/479/511479f95ab2e608dec6366fd52422c3/original.png\" /></a></div>\r\n<div class=\"ccs-cc-inline-feature-content ccs-cc-inline-feature-description\">\r\n<div data-cnet-ccs-icb-annotation=\"true\"><b data-cnet-ccs-icb-annotation=\"true\"><br /></b></div>\r\n<div data-cnet-ccs-icb-annotation=\"true\"><b data-cnet-ccs-icb-annotation=\"true\">Though Shall Not Pass</b></div>\r\n<div data-cnet-ccs-icb-annotation=\"true\"><span data-cnet-ccs-icb-annotation=\"true\">Hardwired into every ThinkCentre M710 SFF is the TPM (Trusted Platform Module). This international standard for securing hardware gives you extra peace of mind should the PC ever fall into the wrong hands or someone tries to tamper with it.</span></div>\r\n<div data-cnet-ccs-icb-annotation=\"true\"><span data-cnet-ccs-icb-annotation=\"true\"><br data-cnet-ccs-icb-annotation=\"true\" /></span></div>\r\n<div data-cnet-ccs-icb-annotation=\"true\"><span data-cnet-ccs-icb-annotation=\"true\"><b data-cnet-ccs-icb-annotation=\"true\">Plenty of Ports</b></span></div>\r\n<div data-cnet-ccs-icb-annotation=\"true\"><span data-cnet-ccs-icb-annotation=\"true\">Boasting an array of ports, including USB 3.0, VGA, DisplayPort, serial, PS2, and parallel ports, the ThinkCentre M710 SFF lets you connect all your computing and smart devices, comfortably.</span></div>\r\n<div data-cnet-ccs-icb-annotation=\"true\"><span data-cnet-ccs-icb-annotation=\"true\"><br data-cnet-ccs-icb-annotation=\"true\" /></span></div>\r\n<div data-cnet-ccs-icb-annotation=\"true\"><span data-cnet-ccs-icb-annotation=\"true\"><b data-cnet-ccs-icb-annotation=\"true\">Built for Today — and Tomorrow</b></span></div>\r\n<div data-cnet-ccs-icb-annotation=\"true\"><span data-cnet-ccs-icb-annotation=\"true\">From processing to memory, and storage to graphics, the ThinkCentre M710 SFF can meet your business needs – now and in the future.</span></div>\r\n</div>\r\n</div>\r\n</div>\r\n</div>'),('247',85,0,'83','Lenovo ThinkCentre M710s (i5 Model)'),('248',75,0,'84','<fieldset>\r\n<h3 class=\"specTitle\">Model</h3>\r\n<dl><dt>Brand</dt><dd>Lenovo</dd></dl><dl><dt>Series</dt><dd>ThinkCentre</dd></dl><dl><dt>Model</dt><dd>M710s (10M70031US)</dd></dl><dl><dt>Part Number</dt><dd>10M70031US</dd></dl></fieldset><fieldset>\r\n<h3 class=\"specTitle\">Quick Info</h3>\r\n<dl><dt>Type</dt><dd>Business Desktops &amp; Workstations</dd></dl><dl><dt><a id=\"def_colorPopup__1415\" class=\"specs-popup\" name=\"def-color\" data-t-events=\"A\" data-t-e-var78=\"Specification Popup:Form Factor\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>Form Factor</dt><dd>Slim/Small form factor</dd></dl><dl><dt>Usage</dt><dd>Business</dd></dl><dl><dt>Colors</dt><dd>Black</dd></dl><dl><dt><a id=\"def_colorPopup__2640\" class=\"specs-popup\" name=\"def-color\" data-t-events=\"A\" data-t-e-var78=\"Specification Popup:Processor\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>Processor</dt><dd>Intel Core i3-7100 3.90 GHz</dd></dl><dl><dt><a id=\"def_colorPopup__2665\" class=\"specs-popup\" name=\"def-color\" data-t-events=\"A\" data-t-e-var78=\"Specification Popup:Processor Main Features\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>Processor Main Features</dt><dd>64 bit Dual Core Processor</dd></dl><dl><dt><a id=\"def_colorPopup__2664\" class=\"specs-popup\" name=\"def-color\" data-t-events=\"A\" data-t-e-var78=\"Specification Popup:Cache Per Processor\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>Cache Per Processor</dt><dd>3 MB L3 Cache</dd></dl><dl><dt><a id=\"def_colorPopup__2642\" class=\"specs-popup\" name=\"def-color\" data-t-events=\"A\" data-t-e-var78=\"Specification Popup:Memory\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>Memory</dt><dd>4 GB DDR4 2400</dd></dl><dl><dt><a id=\"def_colorPopup__2643\" class=\"specs-popup\" name=\"def-color\" data-t-events=\"A\" data-t-e-var78=\"Specification Popup:Storage\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>Storage</dt><dd>500 GB 7200 RPM HDD</dd></dl><dl><dt><a id=\"def_colorPopup__2644\" class=\"specs-popup\" name=\"def-color\" data-t-events=\"A\" data-t-e-var78=\"Specification Popup:Optical Drive\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>Optical Drive</dt><dd>DVDRW</dd></dl><dl><dt><a id=\"def_colorPopup__2647\" class=\"specs-popup\" name=\"def-color\" data-t-events=\"A\" data-t-e-var78=\"Specification Popup:Graphics\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>Graphics</dt><dd>Intel HD Graphics 630</dd></dl><dl><dt>Power Supply</dt><dd>210W</dd></dl><dl><dt><a id=\"def_colorPopup__1413\" class=\"specs-popup\" name=\"def-color\" data-t-events=\"A\" data-t-e-var78=\"Specification Popup:Operating System\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>Operating System</dt><dd>Windows 10 Pro 64-Bit</dd></dl></fieldset><fieldset>\r\n<h3 class=\"specTitle\">CPU</h3>\r\n<dl><dt><a id=\"def_colorPopup__1418\" class=\"specs-popup\" name=\"def-color\" data-t-events=\"A\" data-t-e-var78=\"Specification Popup:CPU Type\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>CPU Type</dt><dd>Intel Core i3 7th Gen</dd></dl><dl><dt><a id=\"def_colorPopup__1419\" class=\"specs-popup\" name=\"def-color\" data-t-events=\"A\" data-t-e-var78=\"Specification Popup:CPU Speed\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>CPU Speed</dt><dd>Processor Model i3-7100 Processor Speed 3.90 GHz</dd></dl><dl><dt><a id=\"def_colorPopup__7456\" class=\"specs-popup\" name=\"def-color\" data-t-events=\"A\" data-t-e-var78=\"Specification Popup:L3 Cache Per CPU\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>L3 Cache Per CPU</dt><dd>3 MB</dd></dl><dl><dt>CPU Main Features</dt><dd>64 bit Dual Core Processor</dd></dl></fieldset><fieldset>\r\n<h3 class=\"specTitle\">Graphics</h3>\r\n<dl><dt><a id=\"def_colorPopup__1436\" class=\"specs-popup\" name=\"def-color\" data-t-events=\"A\" data-t-e-var78=\"Specification Popup:GPU/VGA Type\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>GPU/VGA Type</dt><dd>Intel HD Graphics 630</dd></dl><dl><dt>Graphics Interface</dt><dd>Integrated video</dd></dl></fieldset><fieldset>\r\n<h3 class=\"specTitle\">Memory</h3>\r\n<dl><dt><a id=\"def_colorPopup__1423\" class=\"specs-popup\" name=\"def-color\" data-t-events=\"A\" data-t-e-var78=\"Specification Popup:Memory Capacity\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>Memory Capacity</dt><dd>4 GB DDR4</dd></dl><dl><dt><a id=\"def_colorPopup__1424\" class=\"specs-popup\" name=\"def-color\" data-t-events=\"A\" data-t-e-var78=\"Specification Popup:Memory Speed\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>Memory Speed</dt><dd>DDR4 2400</dd></dl><dl><dt>Memory Spec</dt><dd>4 GB x 1</dd></dl></fieldset><fieldset>\r\n<h3 class=\"specTitle\">Storage</h3>\r\n<dl><dt><a id=\"def_colorPopup__37707\" class=\"specs-popup\" name=\"def-color\" data-t-events=\"A\" data-t-e-var78=\"Specification Popup:SSD\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>SSD</dt><dd>No</dd></dl><dl><dt>HDD</dt><dd>500 GB</dd></dl><dl><dt><a id=\"def_colorPopup__1428\" class=\"specs-popup\" name=\"def-color\" data-t-events=\"A\" data-t-e-var78=\"Specification Popup:HDD RPM\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>HDD RPM</dt><dd>7200rpm</dd></dl></fieldset><fieldset>\r\n<h3 class=\"specTitle\">Optical Drive</h3>\r\n<dl><dt>Optical Drive Type</dt><dd>DVD±RW</dd></dl></fieldset><fieldset>\r\n<h3 class=\"specTitle\">Display</h3>\r\n<dl><dt><a id=\"def_colorPopup__1440\" class=\"specs-popup\" name=\"def-color\" data-t-events=\"A\" data-t-e-var78=\"Specification Popup:Screen Size\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>Screen Size</dt><dd>No Screen</dd></dl></fieldset><fieldset>\r\n<h3 class=\"specTitle\">Mouse</h3>\r\n<dl><dt>Mouse Type</dt><dd>USB Mouse</dd></dl></fieldset><fieldset>\r\n<h3 class=\"specTitle\">Keyboard</h3>\r\n<dl><dt>Keyboard Type</dt><dd>USB Keyboard</dd></dl></fieldset><fieldset>\r\n<h3 class=\"specTitle\">Dimensions &amp; Weight</h3>\r\n<dl><dt>Dimensions (H x W x D)</dt><dd>13.50\" x 3.60\" x 11.40\"</dd></dl><dl><dt>Weight</dt><dd>13.20 lbs.</dd></dl></fieldset>'),('249',76,0,'84','<ul>\r\n<li class=\"item\">Intel Core i3 7th Gen Processor Model i3-7100 Processor Speed 3.90 GHz</li>\r\n<li class=\"item\">4 GB DDR4</li>\r\n<li class=\"item\">500 GB HDD</li>\r\n<li class=\"item\">Windows 10 Pro 64-Bit</li>\r\n<li class=\"item\">No Screen</li>\r\n<li class=\"item\">Intel HD Graphics 630</li>\r\n</ul>\r\n<div id=\"header-1b9e99\" class=\"ccs-cc-inline-section ccs-cc-inline-header\" data-elementid=\"inline-content-header[len]\" data-ccs-cc-inline-jumplink=\"Overview\">\r\n<div class=\"ccs-cc-inline-header-layout\" data-type=\"text media\">\r\n<div class=\"ccs-cc-inline-header-description\">\r\n<div data-cnet-ccs-icb-annotation=\"true\"><b data-cnet-ccs-icb-annotation=\"true\">The power to drive your business</b></div>\r\n<div data-cnet-ccs-icb-annotation=\"true\">Extremley powerful, easy to manage, and configurable, the ThinkCentre M710 SFF can be tailored to meet your computing needs,  today and tomorrow. This PC is super fast, responsive, and efficient. As well as being able to empower you and your business, it comes with robust security features to safeguard your critical data and the built-in reliability your organization can count on.</div>\r\n</div>\r\n<div class=\"ccs-cc-inline-header-hero\"></div>\r\n</div>\r\n</div>\r\n<div id=\"media-1b9e99\" class=\"ccs-cc-inline-section ccs-cc-inline-media\" data-elementid=\"inline-content-gallery[len]\" data-ccs-cc-inline-jumplink=\"Media\">\r\n<div class=\"ccs-cc-ig ccs-cc-ig-cloud\" data-config=\"{&quot;layout&quot;:&quot;cloud&quot;,&quot;logCall&quot;:&quot;{\\&quot;logFunctionName\\&quot;:\\&quot;ccs_cc_loge_3f6b84\\&quot;,\\&quot;paramsFunctionName\\&quot;:\\&quot;ccs_cc_gete_params_3f6b84\\&quot;,\\&quot;eventId\\&quot;:\\&quot;ac0675f5\\&quot;}&quot;,&quot;errorLogCall&quot;:&quot;{\\&quot;logFunctionName\\&quot;:\\&quot;ccs_cc_loge_3f6b84\\&quot;,\\&quot;paramsFunctionName\\&quot;:\\&quot;ccs_cc_gete_params_3f6b84\\&quot;,\\&quot;eventId\\&quot;:\\&quot;19606314\\&quot;}&quot;}\">\r\n<div class=\"ccs-slick-initialized ccs-slick-slider\">\r\n<div class=\"ccs-slick-list\">\r\n<div class=\"ccs-slick-track\">\r\n<div class=\"ccs-slick-slide ccs-slick-current ccs-slick-active ccs-ig-cloud-active\" tabindex=\"-1\" data-media-type=\"image\" data-image-url=\"https://cc.cnetcontent.com/inlinecontent/mediaserver/all/bd1/c85/bd1c85f753735d2d492ae3b8ad2e9d24/original.png\" data-caption=\"\" data-zoom-log-call=\"{&quot;logFunctionName&quot;:&quot;ccs_cc_loge_3f6b84&quot;,&quot;paramsFunctionName&quot;:&quot;ccs_cc_gete_params_3f6b84&quot;,&quot;eventId&quot;:&quot;8fc6a74b&quot;}\" data-ccs-fancybox=\"media-1b9e99\" data-src=\"https://cc.cnetcontent.com/inlinecontent/mediaserver/all/bd1/c85/bd1c85f753735d2d492ae3b8ad2e9d24/original.png\" data-slick-index=\"0\"><b data-cnet-ccs-icb-annotation=\"true\">B.I.G. on Power</b></div>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"ccs-cc-inline-section ccs-cc-inline-features\" data-elementid=\"inline-content-features[len]\" data-ccs-cc-inline-jumplink=\"Features\">\r\n<div class=\"ccs-cc-inline-features-block ccs-cc-inline-single-feature\">\r\n<div class=\"ccs-cc-inline-feature\" data-type=\"text media\" data-pos=\"right\">\r\n<div class=\"ccs-cc-inline-feature-content ccs-cc-inline-feature-description\">\r\n<div data-cnet-ccs-icb-annotation=\"true\">Powered by high performance processors, a ThinkCentre M710 SFF is designed for speed, responsiveness, and efficiency—three key features that can help propel your business.</div>\r\n<div data-cnet-ccs-icb-annotation=\"true\"></div>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"ccs-cc-inline-features-block ccs-cc-inline-single-feature\">\r\n<div class=\"ccs-cc-inline-feature\" data-type=\"text media\" data-pos=\"left\">\r\n<div class=\"ccs-cc-inline-feature-content ccs-cc-inline-thumbnail\"><a class=\"ccs-cc-inline-thumbnail-image ccs-cc-inline-thumbnail-media ccs-cc-inline-clickable\" title=\"Lenovo ThinkCentre M710 Small Form Factor show larger image\" href=\"https://cdn.cnetcontent.com/syndication/mediaserverredirect/511479f95ab2e608dec6366fd52422c3/original.png\" data-media-type=\"image\" data-zoom-log-call=\"{&quot;logFunctionName&quot;:&quot;ccs_cc_loge_3f6b84&quot;,&quot;paramsFunctionName&quot;:&quot;ccs_cc_gete_params_3f6b84&quot;,&quot;eventId&quot;:&quot;6ca2b844&quot;}\" data-hover-log-call=\"{&quot;logFunctionName&quot;:&quot;ccs_cc_loge_3f6b84&quot;,&quot;paramsFunctionName&quot;:&quot;ccs_cc_gete_params_3f6b84&quot;,&quot;eventId&quot;:&quot;dbf753dc&quot;}\" data-caption=\"Lenovo ThinkCentre M710 Small Form Factor\"><span class=\"ccs-cc-inline-image-zoom\"></span><img src=\"https://cdn.cnetcontent.com/syndication/mediaserverredirect/511479f95ab2e608dec6366fd52422c3/maxsize(400x500).png\" alt=\"Lenovo ThinkCentre M710 Small Form Factor\" data-large=\"https://cdn.cnetcontent.com/syndication/mediaserverredirect/511479f95ab2e608dec6366fd52422c3/original.png\" /></a></div>\r\n<div class=\"ccs-cc-inline-feature-content ccs-cc-inline-feature-description\">\r\n<div data-cnet-ccs-icb-annotation=\"true\"><b data-cnet-ccs-icb-annotation=\"true\"><br /></b></div>\r\n<div data-cnet-ccs-icb-annotation=\"true\"><b data-cnet-ccs-icb-annotation=\"true\">Thou Shall Not Pass</b></div>\r\n<div data-cnet-ccs-icb-annotation=\"true\">Hardwired into every ThinkCentre M710 SFF is the TPM (Trusted Platform Module). This international standard for securing hardware gives you extra peace of mind should the PC ever fall into the wrong hands or someone tries to tamper with it.</div>\r\n<div data-cnet-ccs-icb-annotation=\"true\"><b data-cnet-ccs-icb-annotation=\"true\"><br data-cnet-ccs-icb-annotation=\"true\" /></b></div>\r\n<div data-cnet-ccs-icb-annotation=\"true\"><b data-cnet-ccs-icb-annotation=\"true\">Plenty of Ports</b></div>\r\n<div data-cnet-ccs-icb-annotation=\"true\">Boasting an array of ports, including  USB 3.0, VGA, DP, Serial, PS2, and parallel ports, the ThinkCentre M710 SFF lets you connect all your computing and smart devices, comfortably.</div>\r\n<div data-cnet-ccs-icb-annotation=\"true\"></div>\r\n<div data-cnet-ccs-icb-annotation=\"true\"><b data-cnet-ccs-icb-annotation=\"true\">Built for Today—and Tomorrow</b></div>\r\n<div data-cnet-ccs-icb-annotation=\"true\">From processing to memory, and storage to graphics, the ThinkCentre M710 SFF can be configured to meet your business needs– now and in the future</div>\r\n</div>\r\n</div>\r\n</div>\r\n</div>'),('250',85,0,'84','Lenovo ThinkCentre M710s (i3 Model)'),('251',75,0,'85','<table class=\"specTable\" data-selenium=\"specTable\">\r\n<tbody data-selenium=\"specBody\">\r\n<tr><th class=\"specHeader Header\" colspan=\"2\" data-selenium=\"specHeader\"><a id=\"11011\" class=\"fs32 OpenSans-300-normal\" name=\"11011\" data-selenium=\"specHeaderLink\"></a>Performance</th></tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Processor</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Intel Core i7-7700 Quad-Core</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Base Clock Speed</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">3.6 GHz</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Maximum Boost Speed</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">4.2 GHz</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">L3 Cache</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">8 MB</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">System Bus</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">8 GT/s Direct Media Interface</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Total Installed Memory</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">8 GB</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Maximum Memory Capacity</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">64 GB</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Memory Type</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">DDR4 SDRAM</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Memory Speed</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">2400 MHz</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">User-Replaceable Memory</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">1 x 8 GB</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Available Memory Slots</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">3</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Memory Slot Type</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">288-Pin DIMM</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Graphics Type</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Integrated</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">GPU</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Intel HD Graphics 630</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<table class=\"specTable\" data-selenium=\"specTable\">\r\n<tbody data-selenium=\"specBody\">\r\n<tr><th class=\"specHeader Header\" colspan=\"2\" data-selenium=\"specHeader\"><a id=\"15001\" class=\"fs32 OpenSans-300-normal\" name=\"15001\" data-selenium=\"specHeaderLink\"></a>Drives</th></tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Storage Drive</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Bays: 1 x 3.5\"<br />Installed: 1 TB 7200 rpm HDD<br />Type: SATA</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Optical Drive</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Tray-Load SuperMulti DVD Burner with Dual Layer Support</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Drive Expansion</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">1 x 3.5\" (Internal)<br />1 x M.2 (Internal)</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">PCI Expansion</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">1 x PCIe Gen 3 x16<br />2 x PCIe Gen 2 x1<br />1 x M.2</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<table class=\"specTable\" data-selenium=\"specTable\">\r\n<tbody data-selenium=\"specBody\">\r\n<tr><th class=\"specHeader Header\" colspan=\"2\" data-selenium=\"specHeader\"><a id=\"60547\" class=\"fs32 OpenSans-300-normal\" name=\"60547\" data-selenium=\"specHeaderLink\"></a>Inputs / Outputs</th></tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Ports</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">6 x USB 3.1 Gen 1 Type-A<br />2 x USB 2.0 Type-A<br />2 x PS/2</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Display</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">2 x DisplayPort<br />1 x VGA</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Audio</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">1 x 1/8\" (3.5 mm) Headphone Output<br />2 x 1/8\" (3.5 mm) Microphone Input<br />1 x 1/8\" (3.5 mm) Line-In<br />1 x 1/8\" (3.5 mm) Line-Out<br />1 x Integrated Speaker</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Flash Media Slot</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\"><i>None</i></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<table class=\"specTable\" data-selenium=\"specTable\">\r\n<tbody data-selenium=\"specBody\">\r\n<tr><th class=\"specHeader Header\" colspan=\"2\" data-selenium=\"specHeader\"><a id=\"15002\" class=\"fs32 OpenSans-300-normal\" name=\"15002\" data-selenium=\"specHeaderLink\"></a>Communications</th></tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Network</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">1 x 10/100/1000 Mb/s Gigabit Ethernet (RJ45)</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Wi-Fi</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\"><i>None</i></td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Bluetooth</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\"><i>None</i></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<table class=\"specTable\" data-selenium=\"specTable\">\r\n<tbody data-selenium=\"specBody\">\r\n<tr><th class=\"specHeader Header\" colspan=\"2\" data-selenium=\"specHeader\"><a id=\"91003\" class=\"fs32 OpenSans-300-normal\" name=\"91003\" data-selenium=\"specHeaderLink\"></a>Keyboard &amp; Mouse</th></tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Keyboard</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Type: Full-Size<br />Features: Numeric Keypad</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Mouse</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">USB</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<table class=\"specTable\" data-selenium=\"specTable\">\r\n<tbody data-selenium=\"specBody\">\r\n<tr><th class=\"specHeader Header\" colspan=\"2\" data-selenium=\"specHeader\"><a id=\"8008\" class=\"fs32 OpenSans-300-normal\" name=\"8008\" data-selenium=\"specHeaderLink\"></a>General</th></tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Operating System</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Windows 10 Pro (64-Bit)</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Power Supply</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">210 W</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Dimensions (W x H x D)</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">5.7 x 14.4 x 11.5\" / 144.8 x 365.8 x 292.1 mm</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Weight</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">14.3 lb / 6.5 kg <i>(Weight may vary by configuration)</i></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<table class=\"specTable\" data-selenium=\"specTable\">\r\n<tbody data-selenium=\"specBody\">\r\n<tr><th class=\"specHeader Header\" colspan=\"2\" data-selenium=\"specHeader\"><a id=\"shipping\" class=\"fs32 OpenSans-300-normal\" name=\"shipping\" data-selenium=\"specHeaderLink\"></a>Packaging Info</th></tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Package Weight</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">21.0 lb</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Box Dimensions (LxWxH)</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">21.0 x 15.0 x 9.25\"</td>\r\n</tr>\r\n</tbody>\r\n</table>'),('252',76,0,'85','<ul class=\"top-section-list\" data-selenium=\"highlightList\">\r\n<li class=\"top-section-list-item\">3.6 GHz Intel Core i7-7700 Quad-Core</li>\r\n<li class=\"top-section-list-item\">8GB of 2400 MHz DDR4 RAM</li>\r\n<li class=\"top-section-list-item\">Integrated Intel HD Graphics 630</li>\r\n<li class=\"top-section-list-item\">1TB 7200 rpm SATA 3.5\" Hard Drive</li>\r\n<li class=\"top-section-list-item\">SuperMulti DVD Burner</li>\r\n<li class=\"top-section-list-item\">1 x Gigabit Ethernet Port</li>\r\n<li class=\"top-section-list-item\">USB 3.0 Type-A | USB 2.0 Type-A | PS/2</li>\r\n<li class=\"top-section-list-item\">DisplayPort | VGA</li>\r\n<li class=\"top-section-list-item\">USB Wired Keyboard &amp; Mouse Included</li>\r\n<li class=\"top-section-list-item\">Windows 10 Pro (64-bit)</li>\r\n</ul>\r\n<div class=\"ov-wrapper js-overview-desc\">\r\n<div class=\"ov-desc\">\r\n<p>Fast, responsive, and efficient, the <strong>ThinkCentre M710 Tower Desktop Computer</strong> from <span>Lenovo</span> is powerful, easy to manage, configurable, and backed by security features to meet present and future computing needs. The system is powered by a 3.6 GHz Intel Core i7-7700 Quad-Core processor which will allow you to run multiple applications simultaneously. If you need more power, the CPU can be overclocked to 4.2 GHz using Intel\'s Turbo Boost 2.0 technology.</p>\r\n<p>The 8GB of 2400 MHz DDR4 RAM helps to ensure smooth multitasking and also allows the computer to quickly access frequently-used files and programs. While the current memory configuration is 1 x 8GB, there are four total 288-pin DIMM memory slots that will allow the RAM to be upgraded to 64GB, using one 16GB module in each of the memory slots.</p>\r\n<p>For long-term storage of your files, a 1TB 7200 rpm SATA 3.5\" hard drive offers quick access to your data, and there is an empty 3.5\" drive bay and M.2 slot for additional internal storage, plus an additional M.2 slot for Wi-Fi. If you want to add external storage drives, optical drives, printers, memory card readers, or other peripherals, the M710 Tower features six USB 3.0 Type-A ports, two USB 2.0 Type-A ports, and two PS/2 ports. The integrated Intel HD Graphics 630 chipset delivers a sharp, clear picture while allowing for multiple simultaneous displays to be used via its two DisplayPort and one VGA video outputs. Whether you are listening to music, watching a movie, or playing a game, the integrated Realtek ALC662 audio codec outputs high-definition audio and delivers higher fidelity than standard audio controllers.</p>\r\n<p>Lenovo\'s ThinkCentre M710 Tower Desktop Computer includes a USB keyboard, a USB mouse, and an auto-sensing 210W power adapter. The installed operating system is Windows 10 Pro (64-bit).</p>\r\n</div>\r\n</div>\r\n<div class=\"sectionHeaders js-hiddenFeatures\" data-selenium=\"sectionHeaders\">\r\n<div class=\"js-featureSection\">\r\n<h3 class=\"featureHeader c27 fs24\">General Features</h3>\r\n<dl class=\"js-featureSectionDL\"><dt class=\"featureTitle\"><strong>SuperMulti DVD Burner</strong></dt><dd class=\"c28\">The SuperMulti DVD Burner supports a wide variety of optical DVD and CD media, including DVD±RW.</dd></dl><dl class=\"js-featureSectionDL\"><dt class=\"featureTitle\"><strong>Gigabit Ethernet</strong></dt><dd class=\"c28\">The system uses an integrated Realtek RTL8111GN Gigabit Ethernet controller for Internet access when connected to a router, modem, or network switch.</dd></dl><dl class=\"js-featureSectionDL\"><dt class=\"featureTitle\"><strong>6 x USB 3.0 Ports Type-A Ports | 2 x USB 2.0 Type-A Ports</strong></dt><dd class=\"c28\">The M710 Tower features six 5 Gb/s USB 3.0 Type-A ports and two USB 2.0 Type-A ports that will allow you to connect external peripherals such as hard drives, printers, and memory card readers. At 5 Gb/s, USB 3.0 transfers data up to 10 times faster than USB 2.0, which operates at 480 Mb/s. USB 3.0\'s high-speed transfer rate helps to significantly reduce data transfer times, meaning you spend less time waiting and more time focusing on the task at hand.</dd></dl><dl class=\"js-featureSectionDL\"><dt class=\"featureTitle\"><strong>2 x DisplayPort | 1 x VGA</strong></dt><dd class=\"c28\">The two DisplayPort outputs support resolutions up to 4096 x 2304 @ 60 Hz, while the VGA port supports resolutions up to 2048 x 1536 @ 50 Hz. Up to three independent displays are supported.</dd></dl><dl class=\"js-featureSectionDL\"><dt class=\"featureTitle\"><strong>PCI Express Connectors</strong></dt><dd class=\"c28\">1 x PCIe 3.0 x16<br />2 x PCIe 2.0 x1</dd></dl><dl class=\"js-featureSectionDL\"><dt class=\"featureTitle\"><strong>Energy Efficient Power Supply</strong></dt><dd class=\"c28\">The 210W power supply is 85% efficient.</dd></dl></div>\r\n<div class=\"js-featureSection\">\r\n<h3 class=\"featureHeader c27 fs24\"><span style=\"text-decoration: underline;\">Windows 10 Pro (64-bit)</span></h3>\r\n<dl class=\"js-featureSectionDL\"><dt class=\"featureTitle\"><strong>Start Menu</strong></dt><dd class=\"c28\">After its hiatus in Windows 8, the Start Menu has returned. Utilizing a combination of the traditional menu system and Windows 8\'s Live Tiles, the improved Start Menu gives you more information at a glance, showing notification information alongside your applications and other pinned items.</dd></dl><dl class=\"js-featureSectionDL\"><dt class=\"featureTitle\"><strong>Cortana</strong></dt><dd class=\"c28\">Microsoft\'s digital personal assistant, Cortana can answer your questions with information gleaned from both your device and the internet at large. You can type or even talk with her, if your system has a microphone. Using her Notebook, Cortana keeps track of your needs and wants, and she learns over time to improve her information gathering skills.</dd></dl><dl class=\"js-featureSectionDL\"><dt class=\"featureTitle\"><strong>Microsoft Edge</strong></dt><dd class=\"c28\">After nearly 20 years, Microsoft has finally replaced its Internet Explorer web browser. With Microsoft Edge, users can write directly on web pages and share notes with friends and colleagues. It also improves the online reading experience by adding a distraction-free mode and read-it-later functionality. Edge also has built-in Cortana integration; you can have her help you find a restaurant, make a reservation, and pull up directions without leaving your browser.</dd></dl><dl class=\"js-featureSectionDL\"><dt class=\"featureTitle\"><strong>Windows Store</strong></dt><dd class=\"c28\">For Windows 10, Microsoft has unified the Windows Store. Now, apps for PCs, tablets, and phones will all be accessible from one place. And with support for Universal Apps, one version of an app can work across all your compatible devices automatically.</dd></dl><dl class=\"js-featureSectionDL\"><dt class=\"featureTitle\"><strong>Windows Continuum</strong></dt><dd class=\"c28\">Windows 10 was designed for a variety of screen sizes and input styles, and with its Continuum feature, it automatically adapts to fit your needs. A Windows 10 tablet on its own requires a touch-centric approach, but attaching a mouse and keyboard will shift everything to a more traditional interface. You can even attach an external monitor to your Windows 10 phone for a near-desktop experience. But it\'s not just the operating system; Windows Universal Apps take advantage of Continuum as well.</dd></dl><dl class=\"js-featureSectionDL\"><dt class=\"featureTitle\"><strong>Xbox on Windows 10</strong></dt><dd class=\"c28\">Gaming is a big focus of Windows 10. Xbox integration allows for PC players to match up against Xbox One players on supported games, and if you have an Xbox One, you can even stream compatible titles to your PC. Native support for recording with the new Game DVR feature makes it easy to capture and share your gameplay. The new DirectX12 takes better advantage of multi-core processors, giving games a performance boost, even on older hardware. Windows 10 also features native support for virtual reality headsets, such as the Oculus Rift.</dd></dl><dl class=\"js-featureSectionDL\"><dt class=\"featureTitle\"><strong>Windows 10 Pro</strong></dt><dd class=\"c28\">The Pro version of Windows 10 includes all of the features of Windows 10 Home plus many designed specifically for businesses users, including Hyper-V virtualization, BitLocker disk encryption, and remote desktop access. Devices will also be able to join domains and the Azure Active Directory, and they can even access a specialized version of the Windows Store featuring custom, company-specific applications.</dd></dl></div>\r\n</div>'),('253',85,0,'85','Lenovo ThinkCentre M710t 10M9'),('254',75,0,'86','<table class=\"specTable\" data-selenium=\"specTable\">\r\n<tbody data-selenium=\"specBody\">\r\n<tr><th class=\"specHeader Header\" colspan=\"2\" data-selenium=\"specHeader\"><a id=\"11011\" class=\"fs32 OpenSans-300-normal\" name=\"11011\" data-selenium=\"specHeaderLink\"></a>Performance</th></tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Processor</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Intel Core i3-7100 Dual-Core</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Base Clock Speed</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">3.9 GHz</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">L3 Cache</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">3 MB</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Chipset</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Socket: B250<br />Type: LGA1151</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Total Installed Memory</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">4 GB</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Maximum Memory Capacity</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">32 GB</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Memory Type</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">DDR4 SDRAM</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Memory Speed</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">2400 MHz</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">User-Replaceable Memory</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">1 x 4 GB</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Available Memory Slots</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">1</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Memory Slot Type</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">288-Pin DIMM</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Graphics Type</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Integrated</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">GPU</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Intel HD Graphics 630</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<table class=\"specTable\" data-selenium=\"specTable\">\r\n<tbody data-selenium=\"specBody\">\r\n<tr><th class=\"specHeader Header\" colspan=\"2\" data-selenium=\"specHeader\"><a id=\"15001\" class=\"fs32 OpenSans-300-normal\" name=\"15001\" data-selenium=\"specHeaderLink\"></a>Drives</th></tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Storage Drive</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Bays: 1 x 3.5\"<br />Installed: 500 GB 7200 rpm HDD</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Optical Drive</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">SuperMulti DVD Burner</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Drive Expansion</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">1 x 3.5\" (Internal)<br />1 x M.2 (Internal)</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">PCI Expansion</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">1 x PCIe Gen 3 x16<br />1 x PCIe Gen 3 x1</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<table class=\"specTable\" data-selenium=\"specTable\">\r\n<tbody data-selenium=\"specBody\">\r\n<tr><th class=\"specHeader Header\" colspan=\"2\" data-selenium=\"specHeader\"><a id=\"60547\" class=\"fs32 OpenSans-300-normal\" name=\"60547\" data-selenium=\"specHeaderLink\"></a>Inputs / Outputs</th></tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Ports</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">6 x USB 3.1 Gen 1 Type-A<br />2 x USB 2.0 Type-A<br />1 x DE-9 Serial</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Display</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">1 x HDMI<br />1 x DisplayPort<br />1 x VGA</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Audio</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">1 x 1/8\" (3.5 mm) Headphone Output<br />1 x 1/8\" (3.5 mm) Microphone Input<br />1 x Integrated Speaker</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Flash Media Slot</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\"><i>None</i></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<table class=\"specTable\" data-selenium=\"specTable\">\r\n<tbody data-selenium=\"specBody\">\r\n<tr><th class=\"specHeader Header\" colspan=\"2\" data-selenium=\"specHeader\"><a id=\"15002\" class=\"fs32 OpenSans-300-normal\" name=\"15002\" data-selenium=\"specHeaderLink\"></a>Communications</th></tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Network</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">1 x 10/100/1000 Mb/s Gigabit Ethernet (RJ45)</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Modem</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\"><i>None</i></td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Wi-Fi</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\"><i>None</i></td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Bluetooth</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\"><i>None</i></td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Webcam</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\"><i>None</i></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<table class=\"specTable\" data-selenium=\"specTable\">\r\n<tbody data-selenium=\"specBody\">\r\n<tr><th class=\"specHeader Header\" colspan=\"2\" data-selenium=\"specHeader\"><a id=\"91003\" class=\"fs32 OpenSans-300-normal\" name=\"91003\" data-selenium=\"specHeaderLink\"></a>Keyboard &amp; Mouse</th></tr>\r\n</tbody>\r\n</table>\r\n<table class=\"specTable\" data-selenium=\"specTable\">\r\n<tbody data-selenium=\"specBody\">\r\n<tr><th class=\"specHeader Header\" colspan=\"2\" data-selenium=\"specHeader\"><a id=\"8008\" class=\"fs32 OpenSans-300-normal\" name=\"8008\" data-selenium=\"specHeaderLink\"></a>General</th></tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Operating System</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Windows 10 Pro</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Power Supply</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">180 W</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Dimensions (W x H x D)</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">11.4 x 3.5 x 13.6\" / 289.6 x 88.9 x 345.4 mm</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Weight</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">10.5 lb / 4.8 kg</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<table class=\"specTable\" data-selenium=\"specTable\">\r\n<tbody data-selenium=\"specBody\">\r\n<tr><th class=\"specHeader Header\" colspan=\"2\" data-selenium=\"specHeader\"><a id=\"shipping\" class=\"fs32 OpenSans-300-normal\" name=\"shipping\" data-selenium=\"specHeaderLink\"></a>Packaging Info</th></tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Package Weight</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">15.5 lb</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Box Dimensions (LxWxH)</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">19.3 x 15.7 x 7.8\"</td>\r\n</tr>\r\n</tbody>\r\n</table>'),('255',76,0,'86','<ul class=\"top-section-list\" data-selenium=\"highlightList\">\r\n<li class=\"top-section-list-item\">3.9 GHz Intel Core i3-7100 Dual-Core</li>\r\n<li class=\"top-section-list-item\">4GB 2400 MHz DDR4 RAM</li>\r\n<li class=\"top-section-list-item\">Integrated Intel HD Graphics 630</li>\r\n<li class=\"top-section-list-item\">500GB 7200 rpm 3.5\" Hard Drive</li>\r\n<li class=\"top-section-list-item\">SuperMulti DVD Burner</li>\r\n<li class=\"top-section-list-item\">1 x Gigabit Ethernet Port</li>\r\n<li class=\"top-section-list-item\">HDMI, DisplayPort, and VGA Ports</li>\r\n<li class=\"top-section-list-item\">6 x USB 3.0, 2 x USB 2.0 Ports</li>\r\n<li class=\"top-section-list-item\">Windows 10 Pro (64-bit)</li>\r\n</ul>\r\n<div class=\"ov-wrapper js-overview-desc\">\r\n<div class=\"ov-desc\">\r\n<p>The <strong>Lenovo V520S desktop</strong> features a small-form-factor design, which takes up a small amount of space on your desk, as well as an Intel Core i3-7100 processor and 4GB of 2400 MHz DDR4 memory to provide performance for everyday tasks. The 7th-generation Intel Core i3-7100 processor comes with 3MB of cache memory and two cores that operate at 3.9 GHz speeds. With an integrated Intel HD Graphics 630 chipset, visuals are delivered through the desktop\'s HDMI, DisplayPort, and VGA outputs. To complete the multimedia experience, an internal 1.5W speaker is on board, or you can connect an optional headset to its two 3.5mm audio jacks.</p>\r\n<p>The 500GB 7200 rpm 3.5\" hard drive provides ample space to store photos, music, files, and more. Windows 10 Pro is the preinstalled operating system to manage your files and programs. For USB connections, this desktop offers six USB 3.0 and two USB 2.0 ports to access USB devices, such as external storage drives, printers, and scanners. Other notable features include a Gigabit Ethernet port and a SuperMulti DVD burner for creating DVD home movies and installing software.</p>\r\n<p>The Lenovo V520S can be upgraded by installing up to 32GB of memory chips along with up to two low-profile PCIe cards for keeping up with future demands. To handle additional storage drives, an M.2 slot and 2.5\" drive bay are on board. Additionally, a second M.2 slot is available for accommodating a user-supplied Wi-Fi/Bluetooth module.</p>\r\n</div>\r\n</div>\r\n<div class=\"sectionHeaders js-hiddenFeatures\" data-selenium=\"sectionHeaders\">\r\n<div class=\"js-featureSection\">\r\n<h3 class=\"featureHeader c27 fs24\">Lenovo V520S Features</h3>\r\n<dl class=\"js-featureSectionDL\"><dt class=\"featureTitle\"><strong>Connectivity</strong></dt><dd class=\"c28\">With four forward-facing USB 3.0 ports, the V520S lets you connect other devices for charging or transferring data.</dd></dl><dl class=\"js-featureSectionDL\"><dt class=\"featureTitle\"><strong>Companion App</strong></dt><dd class=\"c28\">The V520S desktop includes a Lenovo Companion app, which is a one-stop guide to maximizing system performance. This app ensures that your PC remains current on critical updates, while also providing key system information like serial number, user guides, and warranty details in one convenient location. Lenovo Companion also offers insight and advice via tutorials, articles, and tech news.</dd></dl><dl class=\"js-featureSectionDL\"><dt class=\"featureTitle\"><strong>Security</strong></dt><dd class=\"c28\">To safeguard sensitive data, Smart USB Protection lets you restrict USB power access while still allowing the use of the keyboard and mouse.</dd></dl></div>\r\n<div class=\"js-featureSection\">\r\n<h3 class=\"featureHeader c27 fs24\"><span style=\"text-decoration: underline;\">Windows 10 Pro Features</span></h3>\r\n<dl class=\"js-featureSectionDL\"><dt class=\"featureTitle\"><strong>Start Menu</strong></dt><dd class=\"c28\">After its hiatus in Windows 8, the Start Menu has returned. Utilizing a combination of the traditional menu system and Windows 8\'s Live Tiles, the improved Start Menu gives you more information at a glance, showing notification information alongside your applications and other pinned items.</dd></dl><dl class=\"js-featureSectionDL\"><dt class=\"featureTitle\"><strong>Cortana</strong></dt><dd class=\"c28\">Microsoft\'s digital personal assistant, Cortana can answer your questions with information gleaned from both your device and the internet at large. You can type or even talk with her, if your system has a microphone. Using her Notebook, Cortana keeps track of your needs and wants, and she learns over time to improve her information gathering skills.</dd></dl><dl class=\"js-featureSectionDL\"><dt class=\"featureTitle\"><strong>Microsoft Edge</strong></dt><dd class=\"c28\">After nearly 20 years, Microsoft has finally replaced its Internet Explorer web browser. With Microsoft Edge, users can write directly on web pages and share notes with friends and colleagues. It also improves the online reading experience by adding a distraction-free mode and read-it-later functionality. Edge also has built-in Cortana integration; you can have her help you find a restaurant, make a reservation, and pull up directions without leaving your browser.</dd></dl><dl class=\"js-featureSectionDL\"><dt class=\"featureTitle\"><strong>Windows Store</strong></dt><dd class=\"c28\">For Windows 10, Microsoft has unified the Windows Store. Now, apps for PCs, tablets, and phones will all be accessible from one place. And with support for Universal Apps, one version of an app can work across all your compatible devices automatically.</dd></dl><dl class=\"js-featureSectionDL\"><dt class=\"featureTitle\"><strong>Windows Continuum</strong></dt><dd class=\"c28\">Windows 10 was designed for a variety of screen sizes and input styles, and with its Continuum feature, it automatically adapts to fit your needs. A Windows 10 tablet on its own requires a touch-centric approach, but attaching a mouse and keyboard will shift everything to a more traditional interface. You can even attach an external monitor to your Windows 10 phone for a near-desktop experience. But it\'s not just the operating system; Windows Universal Apps take advantage of Continuum as well.</dd></dl><dl class=\"js-featureSectionDL\"><dt class=\"featureTitle\"><strong>Xbox on Windows 10</strong></dt><dd class=\"c28\">Gaming is a big focus of Windows 10. Xbox integration allows for PC players to match up against Xbox One players on supported games, and if you have an Xbox One, you can even stream compatible titles to your PC. Native support for recording with the new Game DVR feature makes it easy to capture and share your gameplay. The new DirectX12 takes better advantage of multi-core processors, giving games a performance boost, even on older hardware. Windows 10 also features native support for virtual reality headsets, such as the Oculus Rift.</dd></dl><dl class=\"js-featureSectionDL\"><dt class=\"featureTitle\"><strong>Windows 10 Pro</strong></dt><dd class=\"c28\">The Pro version of Windows 10 includes all of the features of Windows 10 Home plus many designed specifically for businesses users, including Hyper-V virtualization, BitLocker disk encryption, and remote desktop access. Devices will also be able to join domains and the Azure Active Directory, and they can even access a specialized version of the Windows Store featuring custom, company-specific applications.</dd></dl></div>\r\n</div>'),('256',85,0,'86','Lenovo V520S SFF'),('257',75,0,'87','<table class=\"specTable\" data-selenium=\"specTable\">\r\n<tbody data-selenium=\"specBody\">\r\n<tr><th class=\"specHeader Header\" colspan=\"2\" data-selenium=\"specHeader\"><a id=\"11011\" class=\"fs32 OpenSans-300-normal\" name=\"11011\" data-selenium=\"specHeaderLink\"></a>Performance</th></tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Processor</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Intel Core i3-7100 Dual-Core</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Base Clock Speed</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">3.9 GHz</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">L3 Cache</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">3 MB</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Total Installed Memory</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">4 GB</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Memory Type</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">DDR4 SDRAM</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Memory Slot Type</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">288-Pin DIMM</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Graphics Type</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Integrated</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">GPU</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Intel HD Graphics 630</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<table class=\"specTable\" data-selenium=\"specTable\">\r\n<tbody data-selenium=\"specBody\">\r\n<tr><th class=\"specHeader Header\" colspan=\"2\" data-selenium=\"specHeader\"><a id=\"15001\" class=\"fs32 OpenSans-300-normal\" name=\"15001\" data-selenium=\"specHeaderLink\"></a>Drives</th></tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Storage Drive</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Installed: 1 TB </td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Optical Drive</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">SuperMulti DVD Burner</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<table class=\"specTable\" data-selenium=\"specTable\">\r\n<tbody data-selenium=\"specBody\">\r\n<tr><th class=\"specHeader Header\" colspan=\"2\" data-selenium=\"specHeader\"><a id=\"60547\" class=\"fs32 OpenSans-300-normal\" name=\"60547\" data-selenium=\"specHeaderLink\"></a>Inputs / Outputs</th></tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Ports</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">6 x USB 3.1 Gen 1<br />2 x USB 2.0</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Display</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">1 x HDMI<br />1 x VGA</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Audio</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">2 x 1/8\" (3.5 mm) Headphone/Microphone Combo Jack</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Flash Media Slot</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\"><i>None</i></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<table class=\"specTable\" data-selenium=\"specTable\">\r\n<tbody data-selenium=\"specBody\">\r\n<tr><th class=\"specHeader Header\" colspan=\"2\" data-selenium=\"specHeader\"><a id=\"15002\" class=\"fs32 OpenSans-300-normal\" name=\"15002\" data-selenium=\"specHeaderLink\"></a>Communications</th></tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Network</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">1 x Ethernet (RJ45)</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Wi-Fi</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">802.11ac</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Bluetooth</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Bluetooth 4.0</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<table class=\"specTable\" data-selenium=\"specTable\">\r\n<tbody data-selenium=\"specBody\">\r\n<tr><th class=\"specHeader Header\" colspan=\"2\" data-selenium=\"specHeader\"><a id=\"8008\" class=\"fs32 OpenSans-300-normal\" name=\"8008\" data-selenium=\"specHeaderLink\"></a>General</th></tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Operating System</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Windows 10 Home</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Dimensions (W x H x D)</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">5.7 x 14.4 x 11.2\" / 144.8 x 365.8 x 284.5 mm</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Weight</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">12.8 lb / 5.8 kg</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<table class=\"specTable\" data-selenium=\"specTable\">\r\n<tbody data-selenium=\"specBody\">\r\n<tr><th class=\"specHeader Header\" colspan=\"2\" data-selenium=\"specHeader\"><a id=\"shipping\" class=\"fs32 OpenSans-300-normal\" name=\"shipping\" data-selenium=\"specHeaderLink\"></a>Packaging Info</th></tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Package Weight</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">18.0 lb</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Box Dimensions (LxWxH)</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">20.8 x 15.4 x 9.8\"</td>\r\n</tr>\r\n</tbody>\r\n</table>'),('258',76,0,'87','<ul class=\"top-section-list\" data-selenium=\"highlightList\">\r\n<li class=\"top-section-list-item\">3.9 GHz Intel Core i3-7100 Dual-Core</li>\r\n<li class=\"top-section-list-item\">4GB DDR4 RAM</li>\r\n<li class=\"top-section-list-item\">Integrated Intel HD Graphics 630</li>\r\n<li class=\"top-section-list-item\">1TB Hard Drive</li>\r\n<li class=\"top-section-list-item\">SuperMulti DVD Burner</li>\r\n<li class=\"top-section-list-item\">1 x Ethernet Port</li>\r\n<li class=\"top-section-list-item\">802.11ac Wi-Fi &amp; Bluetooth 4.0</li>\r\n<li class=\"top-section-list-item\">6 x USB 3.0, 2 x USB 2.0 Ports</li>\r\n<li class=\"top-section-list-item\">Windows 10 Home</li>\r\n</ul>\r\n<div class=\"ov-wrapper js-overview-desc\">\r\n<div class=\"ov-desc\">\r\n<p>The <strong>IdeaCentre 510A from Lenovo</strong> is a compact Windows 10 system that runs on an Intel Core i3-7100 processor as well as 4GB of DDR4 memory. With these features, the IdeaCentre 510A can be used to handle spreadsheets and play digital content. It comes outfitted with 1TB hard drive that offers ample storage capacity for your videos, songs, and files. Aside from storing data, Lenovo has armed this desktop with a SuperMulti DVD burner, so you can create as well as watch DVD home movies.</p>\r\n<p>The IdeaCentre 510A is equipped an integrated Intel HD Graphics 630 chipset that delivers detailed visuals through its VGA and HDMI ports. For accessing USB devices, the desktop sports six USB 3.0 and two USB 2.0 ports. Accessing networks can be accomplished wired or wirelessly via an Ethernet port or 802.11ac Wi-Fi module. Another notable included wireless feature is Bluetooth 4.0, which lets the system connect with speakers, keyboards, or headsets. Additionally, two audio combo jacks are on board for wired connections to microphones and speakers.</p>\r\n</div>\r\n</div>\r\n<div class=\"sectionHeaders js-hiddenFeatures\" data-selenium=\"sectionHeaders\">\r\n<div class=\"js-featureSection\">\r\n<h3 class=\"featureHeader c27 fs24\"><span style=\"text-decoration: underline;\">IdeaCentre 510A Features</span></h3>\r\n<dl class=\"js-featureSectionDL\"><dt class=\"featureTitle\"><strong>Performance</strong></dt><dd class=\"c28\">Built with 7th-generation Intel Core processor and Intel HD Graphics, the IdeaCentre 510A is a suitable combination of daily work and entertainment. The Intel Core i3-7100 processor features two cores that operate at a base frequency of 3.9 GHz. In addition, it sports 3MB of cache memory for these cores.</dd></dl><dl class=\"js-featureSectionDL\"><dt class=\"featureTitle\"><strong>Lenovo Family Cloud</strong></dt><dd class=\"c28\">Lenovo provides a central interface for your secured data storage and features smart recognition technology. You can effortlessly upload and download between your mobile and desktop within the same network.</dd></dl><dl class=\"js-featureSectionDL\"><dt class=\"featureTitle\"><strong>Connectivity</strong></dt><dd class=\"c28\">The IdeaCentre 510A comes with a variety of ports for connecting monitors, keyboards, external storage drives, webcams, speakers, and other devices.</dd></dl><dl class=\"js-featureSectionDL\"><dt class=\"featureTitle\"><strong>Software</strong></dt><dd class=\"c28\">Lenovo includes 30-day trials for McAfee LiveSafe and Microsoft Office 365, so you can start using the IdeaCentre 510A right away.</dd></dl></div>\r\n<div class=\"js-featureSection\">\r\n<h3 class=\"featureHeader c27 fs24\"><span style=\"text-decoration: underline;\">Windows 10 Home Features</span></h3>\r\n<dl class=\"js-featureSectionDL\"><dt class=\"featureTitle\"><strong>Start Menu</strong></dt><dd class=\"c28\">After its hiatus in Windows 8, the Start Menu has returned. Utilizing a combination of the traditional menu system and Windows 8\'s Live Tiles, the improved Start Menu gives you more information at a glance, showing notification information alongside your applications and other pinned items.</dd></dl><dl class=\"js-featureSectionDL\"><dt class=\"featureTitle\"><strong>Cortana</strong></dt><dd class=\"c28\">Microsoft\'s digital personal assistant, Cortana can answer your questions with information gleaned from both your device and the internet at large. You can type or even talk with her, if your system has a microphone. Using her Notebook, Cortana keeps track of your needs and wants, and she learns over time to improve her information gathering skills.</dd></dl><dl class=\"js-featureSectionDL\"><dt class=\"featureTitle\"><strong>Microsoft Edge</strong></dt><dd class=\"c28\">After nearly 20 years, Microsoft has finally replaced its Internet Explorer web browser. With Microsoft Edge, users can write directly on web pages and share notes with friends and colleagues. It also improves the online reading experience by adding a distraction-free mode and read-it-later functionality. Edge also has built-in Cortana integration; you can have her help you find a restaurant, make a reservation, and pull up directions without leaving your browser.</dd></dl><dl class=\"js-featureSectionDL\"><dt class=\"featureTitle\"><strong>Windows Store</strong></dt><dd class=\"c28\">For Windows 10, Microsoft has unified the Windows Store. Now, apps for PCs, tablets, and phones will all be accessible from one place. And with support for Universal Apps, one version of an app can work across all your compatible devices automatically.</dd></dl><dl class=\"js-featureSectionDL\"><dt class=\"featureTitle\"><strong>Windows Continuum</strong></dt><dd class=\"c28\">Windows 10 was designed for a variety of screen sizes and input styles, and with its Continuum feature, it automatically adapts to fit your needs. A Windows 10 tablet on its own requires a touch-centric approach, but attaching a mouse and keyboard will shift everything to a more traditional interface. You can even attach an external monitor to your Windows 10 phone for a near-desktop experience. But it\'s not just the operating system; Windows Universal Apps take advantage of Continuum as well.</dd></dl><dl class=\"js-featureSectionDL\"><dt class=\"featureTitle\"><strong>Xbox on Windows 10</strong></dt><dd class=\"c28\">Gaming is a big focus of Windows 10. Xbox integration allows for PC players to match up against Xbox One players on supported games, and if you have an Xbox One, you can even stream compatible titles to your PC. Native support for recording with the new Game DVR feature makes it easy to capture and share your gameplay. The new DirectX12 takes better advantage of multi-core processors, giving games a performance boost, even on older hardware. Windows 10 also features native support for virtual reality headsets, such as the Oculus Rift.</dd></dl></div>\r\n</div>'),('259',85,0,'87','Lenovo IdeaCentre 510A '),('260',75,0,'88','<table class=\"specTable\" data-selenium=\"specTable\">\r\n<tbody data-selenium=\"specBody\">\r\n<tr><th class=\"specHeader Header\" colspan=\"2\" data-selenium=\"specHeader\"><a id=\"11011\" class=\"fs32 OpenSans-300-normal\" name=\"11011\" data-selenium=\"specHeaderLink\"></a>Performance</th></tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Processor</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">AMD A6-9220 Dual-Core</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Base Clock Speed</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">2.5 GHz</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Maximum Boost Speed</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">2.9 GHz</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">L2 Cache</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">1 MB</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Total Installed Memory</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">4 GB</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Maximum Memory Capacity</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">16 GB</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Memory Type</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">DDR4 SDRAM</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Memory Speed</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">2400 MHz</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Graphics Type</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Integrated</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">GPU</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">AMD Radeon R5</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<table class=\"specTable\" data-selenium=\"specTable\">\r\n<tbody data-selenium=\"specBody\">\r\n<tr><th class=\"specHeader Header\" colspan=\"2\" data-selenium=\"specHeader\"><a id=\"8004\" class=\"fs32 OpenSans-300-normal\" name=\"8004\" data-selenium=\"specHeaderLink\"></a>Display</th></tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Panel Type</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">LCD</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Size</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">23.8\"</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Aspect Ratio</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">16:9</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Native Resolution</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">1920 x 1080</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Touchscreen</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Yes</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Maximum Brightness</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">250 cd/m<sup>2</sup></td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<table class=\"specTable\" data-selenium=\"specTable\">\r\n<tbody data-selenium=\"specBody\">\r\n<tr><th class=\"specHeader Header\" colspan=\"2\" data-selenium=\"specHeader\"><a id=\"15001\" class=\"fs32 OpenSans-300-normal\" name=\"15001\" data-selenium=\"specHeaderLink\"></a>Drives</th></tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Storage Drive</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Installed: 1 TB 7200 rpm HDD<br />Type: SATA</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Optical Drive</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">SuperMulti DVD Burner</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<table class=\"specTable\" data-selenium=\"specTable\">\r\n<tbody data-selenium=\"specBody\">\r\n<tr><th class=\"specHeader Header\" colspan=\"2\" data-selenium=\"specHeader\"><a id=\"60547\" class=\"fs32 OpenSans-300-normal\" name=\"60547\" data-selenium=\"specHeaderLink\"></a>Inputs / Outputs</th></tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Ports</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">3 x USB 2.0 Type-A<br />2 x USB 3.1 Gen 1 Type-A</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Display</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">1 x HDMI</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Audio</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">1 x 1/8\" (3.5 mm) Headphone/Microphone Combo Jack<br />Integrated Microphone<br />Integrated Speaker</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Flash Media Slot</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">SD<br />SDHC<br />SDXC</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<table class=\"specTable\" data-selenium=\"specTable\">\r\n<tbody data-selenium=\"specBody\">\r\n<tr><th class=\"specHeader Header\" colspan=\"2\" data-selenium=\"specHeader\"><a id=\"15002\" class=\"fs32 OpenSans-300-normal\" name=\"15002\" data-selenium=\"specHeaderLink\"></a>Communications</th></tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Network</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">1 x 10/100/1000 Mb/s Gigabit Ethernet (RJ45)</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Modem</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\"><i>None</i></td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Wi-Fi</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">802.11ac</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Bluetooth</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Bluetooth 4.0</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Webcam</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Front: 1.0 MP</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<table class=\"specTable\" data-selenium=\"specTable\">\r\n<tbody data-selenium=\"specBody\">\r\n<tr><th class=\"specHeader Header\" colspan=\"2\" data-selenium=\"specHeader\"><a id=\"91003\" class=\"fs32 OpenSans-300-normal\" name=\"91003\" data-selenium=\"specHeaderLink\"></a>Keyboard &amp; Mouse</th></tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Keyboard</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Type: Full-Size<br />Features: Wireless</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Mouse</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Wireless</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<table class=\"specTable\" data-selenium=\"specTable\">\r\n<tbody data-selenium=\"specBody\">\r\n<tr><th class=\"specHeader Header\" colspan=\"2\" data-selenium=\"specHeader\"><a id=\"8008\" class=\"fs32 OpenSans-300-normal\" name=\"8008\" data-selenium=\"specHeaderLink\"></a>General</th></tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Operating System</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Windows 10 Home</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Power Supply</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">90 W</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Dimensions (W x H x D)</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">21.3 x 16.4 x 2.3\" / 541.0 x 416.6 x 58.4 mm</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Weight</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">13.57 lb / 6.16 kg</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<table class=\"specTable\" data-selenium=\"specTable\">\r\n<tbody data-selenium=\"specBody\">\r\n<tr><th class=\"specHeader Header\" colspan=\"2\" data-selenium=\"specHeader\"><a id=\"shipping\" class=\"fs32 OpenSans-300-normal\" name=\"shipping\" data-selenium=\"specHeaderLink\"></a>Packaging Info</th></tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Package Weight</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">21.15 lb</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Box Dimensions (LxWxH)</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">25.0 x 20.0 x 8.0\"</td>\r\n</tr>\r\n</tbody>\r\n</table>'),('261',76,0,'88','<ul class=\"top-section-list\" data-selenium=\"highlightList\">\r\n<li class=\"top-section-list-item\">2.5 GHz AMD A6-9220 Dual-Core</li>\r\n<li class=\"top-section-list-item\">4GB DDR4 | 1TB 7200 rpm HDD</li>\r\n<li class=\"top-section-list-item\">23.8\" 1920 x 1080 Full HD Touchscreen</li>\r\n<li class=\"top-section-list-item\">Integrated AMD Radeon R5 Graphics</li>\r\n<li class=\"top-section-list-item\">SuperMulti DVD Drive | SD Card Reader</li>\r\n<li class=\"top-section-list-item\">802.11ac Wi-Fi | Bluetooth 4.0</li>\r\n<li class=\"top-section-list-item\">USB 3.0 Type-A | USB 2.0 Type-A | HDMI</li>\r\n<li class=\"top-section-list-item\">Windows 10 Home (64-Bit)</li>\r\n</ul>\r\n<div class=\"ov-wrapper js-overview-desc\">\r\n<div class=\"ov-desc\">\r\n<p>The <strong>23.8\" Ideacentre 520 Multi-Touch All-in-One Desktop Computer</strong> from <span>Lenovo</span> is a compact system with a small footprint thanks to its built-in touchscreen display. Measuring 23.8\" diagonally, the screen has a 1920 x 1080 Full HD resolution and is driven by integrated graphics to provide you with crisp and clear content reproduction. With touch support, you\'ll be able to utilize touch gestures and commands within Windows 10 to enhance its efficiency and accessibility. Moreover, it also has a combination HDMI Input/Output port, which you can use as an output to connect an external display for enhanced multitasking and larger viewing or as an input to use the all-in-one as a display for an external video source.</p>\r\n<p>Specs-wise, it\'s equipped with a 2.5 GHz AMD A6-9220 dual-core processor, 4GB of DDR4 RAM, and a 1TB 7200 rpm hard drive. Should you need more storage space, you can attach external storage solutions using its multiple USB ports. Other integrated features include 802.11ac Wi-Fi, a Gigabit LAN jack, Bluetooth 4.0, a SuperMulti DVD drive, an SD card reader, a webcam, speakers, microphones, and a mic/audio combo jack. The operating system installed is Windows 10 Home, and it comes with a wireless keyboard and mouse to help you get started.</p>\r\n</div>\r\n</div>\r\n<div class=\"sectionHeaders js-hiddenFeatures\" data-selenium=\"sectionHeaders\">\r\n<div class=\"js-featureSection\">\r\n<h3 class=\"featureHeader c27 fs24\"><span style=\"text-decoration: underline;\">Windows 10 Home</span></h3>\r\n<dl class=\"js-featureSectionDL\"><dt class=\"featureTitle\"><strong>Start Menu</strong></dt><dd class=\"c28\">After its hiatus in Windows 8, the Start Menu has returned. Utilizing a combination of the traditional menu system and Windows 8\'s Live Tiles, the improved Start Menu gives you more information at a glance, showing notification information alongside your applications and other pinned items.</dd></dl><dl class=\"js-featureSectionDL\"><dt class=\"featureTitle\"><strong>Cortana</strong></dt><dd class=\"c28\">Microsoft\'s digital personal assistant, Cortana can answer your questions with information gleaned from both your device and the internet at large. You can type or even talk with her, if your system has a microphone. Using her Notebook, Cortana keeps track of your needs and wants, and she learns over time to improve her information gathering skills.</dd></dl><dl class=\"js-featureSectionDL\"><dt class=\"featureTitle\"><strong>Microsoft Edge</strong></dt><dd class=\"c28\">After nearly 20 years, Microsoft has finally replaced its Internet Explorer web browser. With Microsoft Edge, users can write directly on web pages and share notes with friends and colleagues. It also improves the online reading experience by adding a distraction-free mode and read-it-later functionality. Edge also has built-in Cortana integration; you can have her help you find a restaurant, make a reservation, and pull up directions without leaving your browser.</dd></dl><dl class=\"js-featureSectionDL\"><dt class=\"featureTitle\"><strong>Windows Store</strong></dt><dd class=\"c28\">For Windows 10, Microsoft has unified the Windows Store. Now, apps for PCs, tablets, and phones will all be accessible from one place. And with support for Universal Apps, one version of an app can work across all your compatible devices automatically.</dd></dl><dl class=\"js-featureSectionDL\"><dt class=\"featureTitle\"><strong>Windows Continuum</strong></dt><dd class=\"c28\">Windows 10 was designed for a variety of screen sizes and input styles, and with its Continuum feature, it automatically adapts to fit your needs. A Windows 10 tablet on its own requires a touch-centric approach, but attaching a mouse and keyboard will shift everything to a more traditional interface. You can even attach an external monitor to your Windows 10 phone for a near-desktop experience. But it\'s not just the operating system; Windows Universal Apps take advantage of Continuum as well.</dd></dl><dl class=\"js-featureSectionDL\"><dt class=\"featureTitle\"><strong>Xbox on Windows 10</strong></dt><dd class=\"c28\">Gaming is a big focus of Windows 10. Xbox integration allows for PC players to match up against Xbox One players on supported games, and if you have an Xbox One, you can even stream compatible titles to your PC. Native support for recording with the new Game DVR feature makes it easy to capture and share your gameplay. The new DirectX12 takes better advantage of multi-core processors, giving games a performance boost, even on older hardware. Windows 10 also features native support for virtual reality headsets, such as the Oculus Rift.</dd></dl></div>\r\n</div>'),('262',85,0,'88','Lenovo IdeaCentre 520 Multi-Touch All-in-One'),('263',75,0,'89','<fieldset>\r\n<h3 class=\"specTitle\">Model</h3>\r\n<dl><dt>Brand</dt><dd>Lenovo</dd></dl><dl><dt>Model</dt><dd>F0D8001LUS</dd></dl><dl><dt>Part Number</dt><dd>C217-DTA072</dd></dl></fieldset><fieldset>\r\n<h3 class=\"specTitle\">Quick Info</h3>\r\n<dl><dt>Type</dt><dd>All-in-One PC</dd></dl><dl><dt><a id=\"def_colorPopup__1415\" class=\"specs-popup\" name=\"def-color\" data-t-events=\"A\" data-t-e-var78=\"Specification Popup:Form Factor\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>Form Factor</dt><dd>All-in-One</dd></dl><dl><dt>Usage</dt><dd>Consumer</dd></dl><dl><dt>Colors</dt><dd>Black</dd></dl><dl><dt><a id=\"def_colorPopup__2640\" class=\"specs-popup\" name=\"def-color\" data-t-events=\"A\" data-t-e-var78=\"Specification Popup:Processor\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>Processor</dt><dd>AMD E2-9000 1.80 GHz</dd></dl><dl><dt><a id=\"def_colorPopup__2642\" class=\"specs-popup\" name=\"def-color\" data-t-events=\"A\" data-t-e-var78=\"Specification Popup:Memory\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>Memory</dt><dd>4 GB DDR4</dd></dl><dl><dt><a id=\"def_colorPopup__2643\" class=\"specs-popup\" name=\"def-color\" data-t-events=\"A\" data-t-e-var78=\"Specification Popup:Storage\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>Storage</dt><dd>500 GB 5400 RPM</dd></dl><dl><dt><a id=\"def_colorPopup__2644\" class=\"specs-popup\" name=\"def-color\" data-t-events=\"A\" data-t-e-var78=\"Specification Popup:Optical Drive\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>Optical Drive</dt><dd>DVDRW</dd></dl><dl><dt><a id=\"def_colorPopup__2647\" class=\"specs-popup\" name=\"def-color\" data-t-events=\"A\" data-t-e-var78=\"Specification Popup:Graphics\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>Graphics</dt><dd>AMD Radeon R2 series</dd></dl><dl><dt>Power Supply</dt><dd>45W</dd></dl><dl><dt>Monitor</dt><dd>19.5\"</dd></dl><dl><dt><a id=\"def_colorPopup__1413\" class=\"specs-popup\" name=\"def-color\" data-t-events=\"A\" data-t-e-var78=\"Specification Popup:Operating System\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>Operating System</dt><dd>Windows 10 Home 64-Bit</dd></dl></fieldset><fieldset>\r\n<h3 class=\"specTitle\">CPU</h3>\r\n<dl><dt><a id=\"def_colorPopup__1418\" class=\"specs-popup\" name=\"def-color\" data-t-events=\"A\" data-t-e-var78=\"Specification Popup:CPU Type\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>CPU Type</dt><dd>E Series</dd></dl><dl><dt><a id=\"def_colorPopup__1419\" class=\"specs-popup\" name=\"def-color\" data-t-events=\"A\" data-t-e-var78=\"Specification Popup:CPU Speed\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>CPU Speed</dt><dd>E2-9000 (1.80 GHz)</dd></dl><dl><dt>CPU Main Features</dt><dd>64 bit Dual Core Processor</dd></dl></fieldset><fieldset>\r\n<h3 class=\"specTitle\">Graphics</h3>\r\n<dl><dt><a id=\"def_colorPopup__1436\" class=\"specs-popup\" name=\"def-color\" data-t-events=\"A\" data-t-e-var78=\"Specification Popup:GPU/VGA Type\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>GPU/VGA Type</dt><dd>AMD Radeon R2</dd></dl><dl><dt>Graphics Interface</dt><dd>Integrated video</dd></dl></fieldset><fieldset>\r\n<h3 class=\"specTitle\">Memory</h3>\r\n<dl><dt><a id=\"def_colorPopup__1423\" class=\"specs-popup\" name=\"def-color\" data-t-events=\"A\" data-t-e-var78=\"Specification Popup:Memory Capacity\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>Memory Capacity</dt><dd>4 GB DDR4</dd></dl></fieldset><fieldset>\r\n<h3 class=\"specTitle\">Storage</h3>\r\n<dl><dt>HDD</dt><dd>500 GB</dd></dl><dl><dt><a id=\"def_colorPopup__1428\" class=\"specs-popup\" name=\"def-color\" data-t-events=\"A\" data-t-e-var78=\"Specification Popup:HDD RPM\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>HDD RPM</dt><dd>5400rpm</dd></dl></fieldset><fieldset>\r\n<h3 class=\"specTitle\">Optical Drive</h3>\r\n<dl><dt>Optical Drive Type</dt><dd>DVD±RW</dd></dl></fieldset><fieldset>\r\n<h3 class=\"specTitle\">Display</h3>\r\n<dl><dt><a id=\"def_colorPopup__1440\" class=\"specs-popup\" name=\"def-color\" data-t-events=\"A\" data-t-e-var78=\"Specification Popup:Screen Size\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>Screen Size</dt><dd>19.5\"</dd></dl><dl><dt><a id=\"def_colorPopup__36997\" class=\"specs-popup\" name=\"def-color\" data-t-events=\"A\" data-t-e-var78=\"Specification Popup:Screen Resolution\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>Screen Resolution</dt><dd>1440 x 900</dd></dl><dl><dt><a id=\"def_colorPopup__34569\" class=\"specs-popup\" name=\"def-color\" data-t-events=\"A\" data-t-e-var78=\"Specification Popup:Touchscreen\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>Touchscreen</dt><dd>No</dd></dl><dl><dt>Screen Type</dt><dd>Non-Touch Screen</dd></dl></fieldset><fieldset>\r\n<h3 class=\"specTitle\">Communications</h3>\r\n<dl><dt><a id=\"def_colorPopup__1444\" class=\"specs-popup\" name=\"def-color\" data-t-events=\"A\" data-t-e-var78=\"Specification Popup:WLAN\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>WLAN</dt><dd>802.11ac Wireless LAN</dd></dl><dl><dt><a id=\"def_colorPopup__1446\" class=\"specs-popup\" name=\"def-color\" data-t-events=\"A\" data-t-e-var78=\"Specification Popup:Bluetooth\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>Bluetooth</dt><dd>Yes</dd></dl></fieldset>'),('264',76,0,'89','<ul>\r\n<li class=\"item\">E Series E2-9000 (1.80 GHz)</li>\r\n<li class=\"item\">4 GB DDR4 500 GB HDD</li>\r\n<li class=\"item\">19.5\" 1440 x 900</li>\r\n<li class=\"item\">Windows 10 Home 64-Bit</li>\r\n<li class=\"item\">AMD Radeon R2</li>\r\n</ul>\r\n<div class=\"list-row\">\r\n<h3 class=\"feature-title body-copy-lg v-fw-medium\">Microsoft Windows 10 operating system</h3>\r\n<p class=\"body-copy-lg\">Windows 10 brings back the popular Start Menu from Windows 7 and introduces new features, like the Edge Web browser that lets you markup Web pages on your screen.</p>\r\n</div>\r\n<div class=\"list-row\">\r\n<h3 class=\"feature-title body-copy-lg v-fw-medium\">19.5\" WXGA+ LED display</h3>\r\n<p class=\"body-copy-lg\">Native 1440 x 900 resolution makes navigation simple. 16:10 aspect ratio.</p>\r\n</div>\r\n<div class=\"list-row\">\r\n<h3 class=\"feature-title body-copy-lg v-fw-medium\">AMD E2 accelerated processor</h3>\r\n<p class=\"body-copy-lg\">Dual-core processing. AMD E2 APU handles the AMD Radeon graphics alongside the central processor to balance the load, providing essential performance and productivity for the tasks you do the most.</p>\r\n</div>\r\n<div class=\"list-row\">\r\n<h3 class=\"feature-title body-copy-lg v-fw-medium\">4GB system memory for basic multitasking</h3>\r\n<p class=\"body-copy-lg\">Adequate high-bandwidth RAM to smoothly run multiple applications and browser tabs all at once.</p>\r\n</div>\r\n<div class=\"list-row\">\r\n<h3 class=\"feature-title body-copy-lg v-fw-medium\">DVD/CD burner</h3>\r\n<p class=\"body-copy-lg\">Reads and writes to a variety of media formats, including DVD+R/RW, DVD-R/RW and CD-R/RW.</p>\r\n</div>\r\n<div class=\"list-row\">\r\n<h3 class=\"feature-title body-copy-lg v-fw-medium\">500GB hard drive for serviceable file storage space</h3>\r\n<p class=\"body-copy-lg\">Holds your growing collection of digital photos, music and videos. 5400 rpm spindle speed for standard read/write times.</p>\r\n</div>\r\n<div class=\"list-row\">\r\n<h3 class=\"feature-title body-copy-lg v-fw-medium\">Built-in media reader for simple photo transfer</h3>\r\n<p class=\"body-copy-lg\">Supports a variety of memory card formats.</p>\r\n</div>\r\n<div class=\"list-row\">\r\n<h3 class=\"feature-title body-copy-lg v-fw-medium\">1 USB 3.0 port maximizes the latest high-speed devices</h3>\r\n<p class=\"body-copy-lg\">Also includes 2 USB 2.0 ports to connect more accessories and peripherals. The USB 3.0 port is backward-compatible with USB 2.0 devices (at 2.0 speeds).</p>\r\n</div>\r\n<div class=\"list-row\">\r\n<h3 class=\"feature-title body-copy-lg v-fw-medium\">Next-generation wireless connectivity</h3>\r\n<p class=\"body-copy-lg\">Connects to your network on all current Wi-Fi standards. Connect to a Wireless-AC router for speed nearly 3x faster than Wireless-N. Gigabit Ethernet LAN port plugs into wired networks.</p>\r\n</div>\r\n<div class=\"list-row\">\r\n<h3 class=\"feature-title body-copy-lg v-fw-medium\">Bluetooth 4.0 interface syncs with compatible devices</h3>\r\n<p class=\"body-copy-lg\">Wirelessly transfer photos, music and other media between the computer and your Bluetooth-enabled cell phone or MP3 player, or connect Bluetooth wireless accessories.</p>\r\n</div>\r\n<div class=\"list-row\">\r\n<h3 class=\"feature-title body-copy-lg v-fw-medium\">Additional ports</h3>\r\n<p class=\"body-copy-lg\">Microphone and headphone jacks.</p>\r\n</div>'),('265',85,0,'89','Lenovo 330-20AST All-in-One');
INSERT INTO `catalog_product_entity_text` VALUES ('266',75,0,'90','<fieldset>\r\n<h3 class=\"specTitle\">Model</h3>\r\n<dl><dt>Brand</dt><dd>LEXMARK</dd></dl><dl><dt>Model</dt><dd>2580+</dd></dl></fieldset><fieldset>\r\n<h3 class=\"specTitle\">Print</h3>\r\n<dl><dt>Print Speed</dt><dd>Up to 618 cps Fast Draft @ 12 cpi<br />Up to 400 cps Draft @ 12 cpi<br />Up to 100 cps Near Letter Quality @ 12 cpi</dd></dl><dl><dt>Max Resolution</dt><dd>240 x 144 dpi</dd></dl><dl><dt>Number of Pins</dt><dd>9 pins</dd></dl><dl><dt>Ribbon Life</dt><dd>4 million</dd></dl><dl><dt>Language Simulation</dt><dd>Epson Emulation, Personal Printer Data Stream (PPDS), Okidata MICROLINE Emulation</dd></dl><dl><dt>Fonts Included</dt><dd>Fast Draft, Draft, Courier, Gothic, 10, 12, 15, 17.1, 20 cpi, Proportional Spaced (PS)</dd></dl><dl><dt>Monthly Duty Cycle</dt><dd>12,500 POH @ 25%</dd></dl></fieldset><fieldset>\r\n<h3 class=\"specTitle\">Media Handling</h3>\r\n<dl><dt>Media Type</dt><dd>Multi-part forms - Up to 1+5 parts (up to 0.020 in. or 0.51 mm paper thickness)<br />Single-part forms - 16 to 24 lb., 60 to 90 gsm (0.0045 in. or 0.11 mm paper thickness)<br />Forms or Paper - 16 to 24 lb., 60 to 90 gsm (0.0045 in. or 0.11 mm maximum paper thickness)</dd></dl><dl><dt>Media Sizes</dt><dd>Single-part or multi-part continuous forms (10 in. or 254 mm maximum page width, 3.0 in. or 76 mm minimum page width, 22.0 in. or 559 mm maximum page length, 3.0 in. or 76 mm minimum page length)<br />Narrow sheet fed paper (8.5 in. or 215 mm maximum page width, 4.13 in. or 105 mm minimum page width, 22.0 in. or 559 mm maximum page length, 5.5 in. or 139 mm minimum page length)<br />Single-part or multi-part cut forms (11.7 in. or 297 mm maximum page width, 3.0 in. or 76 mm minimum page width, 22.0 in. or 559 mm maximum page length, 3.0 in. or 76 mm minimum page length)</dd></dl></fieldset><fieldset>\r\n<h3 class=\"specTitle\">Hardware</h3>\r\n<dl><dt>Noise Level</dt><dd>56 dBA</dd></dl></fieldset><fieldset>\r\n<h3 class=\"specTitle\">Ports</h3>\r\n<dl><dt>USB Ports</dt><dd>Centronics IEEE 1284 Bidirectional Parallel</dd></dl><dl><dt>Network Ports</dt><dd>Optional</dd></dl><dl><dt>Other Ports</dt><dd>Standard Ports: <br />Centronics IEEE 1284 Bidirectional Parallel<br /><br />Optional Local Ports: Internal RS-232C serial<br />Optional Network Ports:<br /><br />External MarkNet N7020e Gigabit Ethernet, External MarkNet N7000e Fast Ethernet (USB), External MarkNet N7002e Fast Ethernet (parallel)</dd></dl></fieldset><fieldset>\r\n<h3 class=\"specTitle\">Compatibility</h3>\r\n<dl><dt>Windows Compatible</dt><dd>Microsoft Windows 2000<br />Microsoft Windows XP<br />Microsoft Windows Server 2003<br />Microsoft Windows XP x64<br />Microsoft Windows Server 2003 x64<br />Microsoft Windows Vista<br />Microsoft Windows Vista x64<br />Microsoft Windows Server 2008<br />Microsoft Windows Server 2008 x64<br />Microsoft Windows 7<br />Microsoft Windows 7 x64<br />Microsoft Windows Server 2008 R2</dd></dl><dl><dt>Other</dt><dd>Red Hat Enterprise Linux WS 3.0, 4.0, 5.0<br />SUSE Linux Enterprise Server 8.0, 9.0, 10, 11<br />Debian GNU/Linux 3.1, 4.0<br />Linspire Linux 5.0<br />SUSE Linux 10.0, 10.1, 10.2<br />Sun Solaris SPARC 8, 9, 10<br />IBM AIX 5.1, 5.2, 5.3<br />Sun Solaris x86 10<br />HP-UX 11.11</dd></dl></fieldset><fieldset>\r\n<h3 class=\"specTitle\">Dimensions &amp; Weight</h3>\r\n<dl><dt>Dimensions</dt><dd>7.7\" x 19.4\" x 11.4\"</dd></dl><dl><dt>Weight</dt><dd>17.6 lbs.</dd></dl></fieldset>'),('267',76,0,'90','<ul>\r\n<li class=\"item\">240 x 144 dpi</li>\r\n<li class=\"item\">Up to 618 cps Fast Draft @ 12 cpi</li>\r\n<li class=\"item\">Up to 400 cps Draft @ 12 cpi</li>\r\n<li class=\"item\">Up to 100 cps Near Letter Quality @ 12 cpi Max Resolution</li>\r\n<li class=\"item\">Print Speed</li>\r\n</ul>\r\n<h2 class=\"wc-first-header wc-rich-features-center-984\">FEATURES</h2>\r\n<div class=\"wc-aplus-body\">\r\n<div class=\"wc-reset\">\r\n<ul class=\"wc-rich-features wc-rich-content-orientation-right-aligned wc-first wc-rich-features-center-984\">\r\n<li class=\"wc-rich-feature-item wc-text-placement-false wc-odd-0 wc-first wc-has-media wc-thumb-medium wc-last \">\r\n<div class=\"wc-media-wrap\">\r\n<div class=\"wc-media-inner-wrap\"><img class=\"wc-media wc-image\" title=\"Fast, reliable forms printing\" src=\"https://smedia.webcollage.net/rwvfp/wc/live/lexmark-20180802154025/module/lexmark/media.lexmark.com/www/asset/16/6828/@plimage_small.jpg.w1920.jpg\" alt=\"\" width=\"182\" height=\"182\" data-asset-title=\"Fast, reliable forms printing\" data-asset-type=\"image\" data-asset-url=\"/media.lexmark.com/www/asset/16/6828/@plimage_small.jpg\" data-asset-wrapper=\"rich-features\" data-height=\"182\" data-section-template-code=\"rich-features\" data-width=\"182\" /></div>\r\n</div>\r\n<div class=\"wc-text-wrap\">\r\n<h3 class=\"wc-rich-content-header wc-feature-main-header \">FAST, RELIABLE FORMS PRINTING</h3>\r\n<div class=\"wc-rich-content-description\">\r\n<div>The Lexmark Forms Printer 2580+ provides high-speed narrow form printing and features such as high-yield ribbons, multi-part form support, and character and page monitoring.</div>\r\n</div>\r\n</div>\r\n</li>\r\n</ul>\r\n</div>\r\n<div class=\"wc-reset\">\r\n<ul class=\"wc-rich-features wc-rich-content-orientation-two-columns wc-rf-columns wc-rich-features-center-984\">\r\n<li class=\"wc-rich-feature-item wc-text-placement-false wc-odd-0 wc-first wc-has-media wc-thumb-medium \">\r\n<div class=\"wc-media-wrap\">\r\n<div class=\"wc-media-inner-wrap\"><img class=\"wc-media wc-image\" title=\"Reliability and performance\" src=\"https://smedia.webcollage.net/rwvfp/wc/live/lexmark-20180802154025/module/lexmark/media.lexmark.com/www/image/feature/BulletTrain.jpg.w1920.jpg\" alt=\"\" width=\"199\" height=\"120\" data-asset-title=\"Reliability and performance\" data-asset-type=\"image\" data-asset-url=\"/media.lexmark.com/www/image/feature/BulletTrain.jpg\" data-asset-wrapper=\"rich-features\" data-height=\"120\" data-section-template-code=\"rich-features\" data-width=\"199\" /></div>\r\n</div>\r\n<h3 class=\"wc-rich-content-header wc-feature-main-header \">RELIABILITY AND PERFORMANCE</h3>\r\n<div class=\"wc-rich-content-description\">\r\n<p>Print speeds up to 618 cps at 12 cpi and a rugged design that can handle extreme environments and workloads help you to be productive no matter where you are.</p>\r\n</div>\r\n</li>\r\n \r\n<li class=\"wc-rich-feature-item wc-text-placement-false wc-even-0 wc-has-media wc-thumb-medium \">\r\n<div class=\"wc-media-wrap\">\r\n<div class=\"wc-media-inner-wrap\"><img class=\"wc-media wc-image\" title=\"Flexible paper handling\" src=\"https://smedia.webcollage.net/rwvfp/wc/live/lexmark-20180802154025/module/lexmark/media.lexmark.com/www/image/feature/flexpaperhandling.jpg.w1920.jpg\" alt=\"\" width=\"120\" height=\"100\" data-asset-title=\"Flexible paper handling\" data-asset-type=\"image\" data-asset-url=\"/media.lexmark.com/www/image/feature/flexpaperhandling.jpg\" data-asset-wrapper=\"rich-features\" data-height=\"100\" data-section-template-code=\"rich-features\" data-width=\"120\" /></div>\r\n</div>\r\n<h3 class=\"wc-rich-content-header wc-feature-main-header \">FLEXIBLE PAPER HANDLING</h3>\r\n<div class=\"wc-rich-content-description\">\r\n<p>Easily switch between push and pull feeds and print on multiple types of media, including single-part or multi-part continuous forms, sheet-fed paper, and single-part or multi-part cut forms.</p>\r\n</div>\r\n</li>\r\n \r\n<li class=\"wc-rich-feature-item wc-text-placement-false wc-odd-0 wc-has-media wc-thumb-medium \">\r\n<div class=\"wc-media-wrap\">\r\n<div class=\"wc-media-inner-wrap\"><img class=\"wc-media wc-image\" title=\"Easy to use\" src=\"https://smedia.webcollage.net/rwvfp/wc/live/lexmark-20180802154025/module/lexmark/media.lexmark.com/www/image/feature/operator-pane.jpg.w1920.jpg\" alt=\"\" width=\"120\" height=\"100\" data-asset-title=\"Easy to use\" data-asset-type=\"image\" data-asset-url=\"/media.lexmark.com/www/image/feature/operator-pane.jpg\" data-asset-wrapper=\"rich-features\" data-height=\"100\" data-section-template-code=\"rich-features\" data-width=\"120\" /></div>\r\n</div>\r\n<h3 class=\"wc-rich-content-header wc-feature-main-header \">EASY TO USE</h3>\r\n<div class=\"wc-rich-content-description\">\r\n<p>The easy-to-use operator panel lets you access all of the printer functions, monitor character and page counts and preview fonts.</p>\r\n</div>\r\n</li>\r\n \r\n<li class=\"wc-rich-feature-item wc-text-placement-false wc-even-0 wc-has-media wc-thumb-medium wc-last \">\r\n<div class=\"wc-media-wrap\">\r\n<div class=\"wc-media-inner-wrap\"><img class=\"wc-media wc-image\" title=\"Long lasting supplies\" src=\"https://smedia.webcollage.net/rwvfp/wc/live/lexmark-20180802154025/module/lexmark/media.lexmark.com/www/image/feature/high-yield-ribbon.jpg.w1920.jpg\" alt=\"\" width=\"120\" height=\"100\" data-asset-title=\"Long lasting supplies\" data-asset-type=\"image\" data-asset-url=\"/media.lexmark.com/www/image/feature/high-yield-ribbon.jpg\" data-asset-wrapper=\"rich-features\" data-height=\"100\" data-section-template-code=\"rich-features\" data-width=\"120\" /></div>\r\n</div>\r\n<h3 class=\"wc-rich-content-header wc-feature-main-header \">LONG LASTING SUPPLIES</h3>\r\n<div class=\"wc-rich-content-description\">\r\n<p>Replace supplies less often with powerful printheads that last up to 300 million characters and the availability of re-inking ribbons that can print up to 8 million characters.</p>\r\n</div>\r\n</li>\r\n</ul>\r\n</div>\r\n</div>'),('268',85,0,'90','LEXMARK 2580+ 9-Pin Dot Matrix Printer'),('269',75,0,'91','<div class=\"product-detail-in-the-box section\">\r\n<div class=\"row\">\r\n<div class=\"col-md-3\">\r\n<h3 class=\"margin-top-none\">In the Box</h3>\r\n</div>\r\n<div class=\"col-md-9\">\r\n<div class=\"row\">\r\n<div class=\"col-xs-12\">\r\n<ul class=\"column-fill-xs-1 column-fill-sm-2 padding-before-2\">\r\n<li>Software and Documentation CD</li>\r\n<li>Photoconductor unit</li>\r\n<li>4 Developer units (K, C M, Y)</li>\r\n<li>Lexmark Cartridge Collection Program information</li>\r\n<li>Statement of limited warranty / guarantee</li>\r\n<li>Setup guide or sheet (network and local attachment)</li>\r\n<li>Power cord(s)</li>\r\n<li>1,400*-page starter Black Toner Cartridge</li>\r\n<li>1,400*-page Colour (CMY) Toner Cartridges</li>\r\n<li>Lexmark CS310dn colour laser printer</li>\r\n</ul>\r\n</div>\r\n<div class=\"col-xs-12\">\r\n<p class=\"text-tiny\">Box contents may vary by country and/or reseller. Subject to change without notice.</p>\r\n<p class=\"text-tiny\">Ethernet, USB or parallel cable not included.</p>\r\n<p class=\"text-tiny\">*Average continuous black or continuous composite CMY declared cartridge yield in one-sided (simplex) mode up to this number of standard pages in accordance with ISO/IEC 19798.</p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<hr /></div>\r\n<div class=\"product-detail-tech-specs section\">\r\n<div class=\"row\">\r\n<div class=\"col-md-3\">\r\n<h3>General Specs</h3>\r\n</div>\r\n<div class=\"col-md-9\">\r\n<div class=\"row\">\r\n<div class=\"col-xs-12\">\r\n<table class=\"table margin-top-2\">\r\n<tbody>\r\n<tr><th scope=\"row\">Part #</th>\r\n<td>28C0050</td>\r\n</tr>\r\n<tr><th scope=\"row\">Print Technology</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>Color Laser</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">Workgroup Size</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>Small-Medium Workgroup</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">Display</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>16 character, 2-line backlit All Points Addressable (APA) LCD Display</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">Media Sizes Supported</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>A4, Legal, A5, Letter, Executive, Universal, Folio, Oficio, JIS-B5</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">Included Paper Handling</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>Integrated Duplex, Single-Sheet Manual Feed, 125-Sheet Output Bin, 250-Sheet Input</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">Standard Ports</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>Ethernet 10/100BaseTX (RJ-45), also works with 1000Base-T, USB 2.0 Specification Hi-Speed Certified (Type B)</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">Size (mm - H x W x D)</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>291 x 442 x 407 mm</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">Weight</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>20.3 kg</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">Packaged Size (mm - H x W x D)</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>402 x 595 x 495 mm</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">Packaged Weight, kg</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>23.6 kg</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<hr />\r\n<div class=\"row\">\r\n<div class=\"col-md-3\">\r\n<h3>Printing</h3>\r\n</div>\r\n<div class=\"col-md-9\">\r\n<div class=\"row\">\r\n<div class=\"col-xs-12\">\r\n<table class=\"table margin-top-2\">\r\n<tbody>\r\n<tr><th scope=\"row\">Print Speed</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>Black: 23 ppm<span>1</span> (A4)</li>\r\n<li>Black: 25 ppm (Letter)</li>\r\n<li>Color: 23 ppm (A4)</li>\r\n<li>25 ppm</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">Print Speed Duplex</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>Up to:</li>\r\n<li>Black: 12 spm (A4)</li>\r\n<li>Black: 12 spm (Letter)</li>\r\n<li>Color: 12 spm (A4)</li>\r\n<li>Color: 12 spm (Letter)</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">Time to First Page</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>As fast as:</li>\r\n<li>Black: 10 seconds</li>\r\n<li>Color: 11 seconds</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">Print Resolution</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>Black: 1200 x 1200 dpi, 4800 Color Quality (2400 x 600 dpi)</li>\r\n<li>Color: 4800 Color Quality (2400 x 600 dpi), 1200 x 1200 dpi</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">Duplex (2-sided) Printing</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>Integrated Duplex</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">Printable Area</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>metric: 4.2 mm of the top, bottom, right and left edges (within)</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<hr />\r\n<div class=\"row\">\r\n<div class=\"col-md-3\">\r\n<h3>Paper Handling</h3>\r\n</div>\r\n<div class=\"col-md-9\">\r\n<div class=\"row\">\r\n<div class=\"col-xs-12\">\r\n<table class=\"table margin-top-2\">\r\n<tbody>\r\n<tr><th scope=\"row\">Media Types Supported</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>Paper Labels, Card Stock, Plain Paper, Transparencies, Refer to the Card Stock &amp; Label Guide.</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">Finishing Option</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>No</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">Number of Paper Inputs</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>Standard: 1</li>\r\n<li>Maximum: 3</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">Paper Input Capacity</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>Standard: 250+1 pages 20 lb or 75 gsm bond</li>\r\n<li>Maximum: 900+1 pages 20 lb or 75 gsm bond</li>\r\n<li>250+1 pages 20 lb or 75 gsm bond</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">Paper Output Capacity</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>Up to:</li>\r\n<li>Standard: 125 pages 20 lb or 75 gsm bond</li>\r\n<li>Maximum: 125 pages 20 lb or 75 gsm bond</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">Paper Weight Range Supported</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>gsm:</li>\r\n<li>60 - 176 gsm (Standard Tray)</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">Integrated Tray Card Stock Upper limit</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>Index Bristol - 120 gsm (67 lb) (grain long)</li>\r\n<li>Cover - 135 gsm (50 lb) (grain long)</li>\r\n<li>Tag - 120 gsm (74 lb) (grain long)</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">Optional Paper Handling</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>550-Sheet Duo Tray with 100-Sheet Feeder</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">Recommended Monthly Page Volume</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>500 - 5000 pages<span>2</span></li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">Maximum Monthly Duty Cycle</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>Up to:</li>\r\n<li>60000 pages per month<span>3</span></li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<hr />\r\n<div class=\"row\">\r\n<div class=\"col-md-3\">\r\n<h3>Cartridges &amp; Imaging</h3>\r\n</div>\r\n<div class=\"col-md-9\">\r\n<div class=\"row\">\r\n<div class=\"col-xs-12\">\r\n<table class=\"table margin-top-2\">\r\n<tbody>\r\n<tr><th scope=\"row\">Laser Cartridge Yields</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>up to:</li>\r\n<li>1,000<span>4</span> -page Black and Colour (CMYK) Cartridges</li>\r\n<li>3,000<span>4</span> -page Colour (CMY) High Yield Cartridges</li>\r\n<li>4,000<span>4</span> -page Black High Yield Cartridge</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">Cartridge(s) Shipping with Product</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>1,400<span>0</span> -page Black and Color (CMYK) Starter Return Program Toner Cartridges</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">Replacement Cartridges:</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>Product functions only with replacement cartridges designed for use in a specific geographical region. See www.lexmark.com/regions for more details.</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<hr />\r\n<div class=\"row\">\r\n<div class=\"col-md-3\">\r\n<h3>Hardware</h3>\r\n</div>\r\n<div class=\"col-md-9\">\r\n<div class=\"row\">\r\n<div class=\"col-xs-12\">\r\n<table class=\"table margin-top-2\">\r\n<tbody>\r\n<tr><th scope=\"row\">Processor</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>Dual Core, 800 MHz</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">Memory</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>Standard: 256 MB</li>\r\n<li>Maximum: 2304 MB</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">Hard Disk</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>Not Available</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">Printer Languages</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>Standard:</li>\r\n<li>PCL 5c Emulation, PCL 6 Emulation, Microsoft XPS (XML Paper Specification), Personal Printer Data Stream (PPDS), PostScript 3 Emulation, PDF 1.7 emulation, Direct Image, AirPrint™</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">Fonts and Symbol Sets</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>2 PCL bitmap fonts, 158 scalable PostScript fonts, OCR-A, OCR-B scalable PCL 5e fonts, For more information, refer to the Technical Reference., 84 scalable PCL fonts, 3 of 9 scalable PCL 5e fonts in Narrow, Regular and Wide, 5 PPDS bitmap fonts, 39 scalable PPDS fonts</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">Touch Screen Display</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>No</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<hr />\r\n<div class=\"row\">\r\n<div class=\"col-md-3\">\r\n<h3>Connectivity</h3>\r\n</div>\r\n<div class=\"col-md-9\">\r\n<div class=\"row\">\r\n<div class=\"col-xs-12\">\r\n<table class=\"table margin-top-2\">\r\n<tbody>\r\n<tr><th scope=\"row\">Direct USB</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>No</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">Ethernet Network</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>Yes</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">Network Protocol Support</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>TCP/IP IPv6, TCP/IP IPv4, AppleTalk™, TCP, UDP</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">Network Printing Methods</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>LPR/LPD, Direct IP (Port 9100), Telnet, FTP, TFTP, Enhanced IP (Port 9400), IPP 1.0, 1.1, 2.0 (Internet Printing Protocol)</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">Network Management Protocols</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>DHCP, APIPA (AutoIP), mDNS, IGMP, Bonjour, WINS, DDNS, SNMPv3, SNMPv1, SNMPv2c, Telnet, NTP, ICMP, HTTP, DNS, ARP, HTTPs (SSL<span>5</span>/TLS), Finger</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">Network Security</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>IPSec, SNMPv3</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">Optional Network Ports</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>External MarkNet™ N7020e Gigabit Ethernet, MarkNet N8352 802.11b/g/n Wireless</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<hr />\r\n<div class=\"row\">\r\n<div class=\"col-md-3\">\r\n<h3>Supported Operating Systems</h3>\r\n</div>\r\n<div class=\"col-md-9\">\r\n<div class=\"row\">\r\n<div class=\"col-xs-12\">\r\n<table class=\"table margin-top-2\">\r\n<tbody>\r\n<tr><th scope=\"row\">Microsoft Windows Operating Systems Supported</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>Windows 10, Windows Server 2008 x64, Windows 8.1, Windows 8, Windows Server 2008, Windows Server 2008 R2, Windows 8 x64, Windows 7 x64, Windows Server 2012, Windows RT 8.1, Windows XP x64, Windows Server 2003 x64, Windows RT, Windows Server 2003, Windows Server 2012 R2, Windows XP, Windows 8.1 x64, Windows Vista x64, Windows Vista, Windows 7</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">Apple Operating Systems Supported</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>Apple OS X (10.5, 10.6, 10.7, 10.8, 10.9, 10.10)</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">Linux Operating Systems Supported</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>PCLinuxOS 2011, Ubuntu 11.04, 11.10, 12.04, 12.10, openSUSE 11.3, 11.4, 12.1, 12.2, Linpus Linux Desktop 9.6, Mint 9, 10, 11, 12, 13, Debian GNU/Linux 5.0, 6.0, Fedora 14, 15, 16, 17, Red Hat Enterprise Linux WS 4.0, 5.0, 6.0, SUSE Linux Enterprise Desktop 10, 11, Red Flag Linux Desktop 6.0, SUSE Linux Enterprise Server 10, 11</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">Citrix MetaFrame</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>Microsoft Windows Server 2003 and 2003 X64 Edition with Citrix XenApp 5.0, Microsoft Windows Server 2003 x64 running Terminal Services with Citrix Presentation Server 4.0 x64, 4.5 x64, Microsoft Windows Server 2003 running Terminal Services with Citrix Presentation Server 4.0, 4.5, Microsoft Windows Server 2008 R2 with Citrix XenApp 6.0, Microsoft Windows Server 2008 and 2008 X64 Edition with Citrix XenApp 5.0</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">Novell Operating Systems Supported</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>Novell Open Enterprise Server on SUSE Linux Enterprise Server, Novell NetWare 5.1(SP 6+), 6.0(SP 3+) with Novell Distributed Print Services (NDPS), Novell NetWare 6.5 Open Enterprise Server</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">UNIX Operating Systems Supported</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>Sun Solaris x86 10, 11, Sun Solaris SPARC 9, 10, 11, IBM AIX 5.3, 6.1, 7.1, HP-UX 11.11, 11.23, 11.31</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<hr />\r\n<div class=\"row\">\r\n<div class=\"col-md-3\">\r\n<h3>Electrical &amp; Operation</h3>\r\n</div>\r\n<div class=\"col-md-9\">\r\n<div class=\"row\">\r\n<div class=\"col-xs-12\">\r\n<table class=\"table margin-top-2\">\r\n<tbody>\r\n<tr><th scope=\"row\">ENERGY STAR</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>Yes</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">ENERGY STAR Typical Electricity Consumption</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>TEC:</li>\r\n<li>1.8 kilowatt-hours per week</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">Noise Level</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>Operating:</li>\r\n<li>16 dBA (Idle)</li>\r\n<li>48 dBA (Print)</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">Duplex Print Noise Level</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>Operating:</li>\r\n<li>50 dBA</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">Average Power</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>0.5 watts (Hibernate Mode)</li>\r\n<li>2.5 watts (Sleep Mode)</li>\r\n<li>30 watts (Ready Mode)</li>\r\n<li>480 watts (Printing)</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">Specified Operating Environment</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>Humidity: 8 to 80% Relative Humidity</li>\r\n<li>Temperature: 16 to 32°C (60 to 90°F)</li>\r\n<li>Altitude: 0 - 2896 Meters (9,500 Feet)</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">Product Certifications</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>ENERGY STAR, Blue Angel RAL-UZ-171, ICES-003 Class B, BSMI Class B, VCCI Class B, US FDA, UL 60950-1, FCC Class B, cUL CAN/CSA-C22.2 60950-1, CB EN/IEC 60950-1, CB EN/IEC 60825-1, CE DoC (EN 62301 Class B, EN 62311, CE EN/IEC 60950-1, CE EN/IEC 60825-1, EN 61000-3, EN 55022 Class B, EN 55024, UL), EFTA (CE), KCC, CCC, CECP, CEL, C-tick DoC, UL-AR, KC mark, UL GS mark, UCRF, EC 1275</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">ENERGY STAR</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>Yes</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">UNSPSC Code</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>43212105</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">Harmonized Tariff Code</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>8443.32.1010</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">Country of Origin</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>China (PRC)</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">License/Agreement Terms</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>Printers are sold subject to certain license/agreement conditions. See www.lexmark.com/printerlicense for details.</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n</div>'),('270',76,0,'91','<ul class=\"margin-bottom-none padding-before-2\">\r\n<li>Color Laser</li>\r\n<li>Duplex (2-sided) Printing: Integrated Duplex</li>\r\n<li>Print Speed: 25 ppm</li>\r\n<li>Recommended Monthly Page Volume: 500 - 5000 pages</li>\r\n</ul>\r\n<div class=\"wells section\">\r\n<div class=\" well no-shadow border-b8 border-top border-bottom well-sm padding-before-4 padding-after-4 margin-top-1\">\r\n<div class=\"product-detail-marketing-desc\">\r\n<p class=\"lead padding-bottom-1\">The small and quiet <strong>Lexmark CS310dn network-ready color laser printer</strong> with 2-sided printing standard, a 800 MHz dual-core processor and 256MB of standard memory prints at up to 25 ppm black and color.</p>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"product-detail-addtl-marketing-desc section\">\r\n<div class=\"row\">\r\n<div class=\"col-md-3\">\r\n<h4 class=\"margin-top-none\">Freedom to Print on the Fly</h4>\r\n</div>\r\n<div class=\"col-md-9\">\r\n<p>With the ability to print professional color-in-house, you’ll save time and money typically spent on expensive, outside printing alternatives.</p>\r\n</div>\r\n</div>\r\n<hr />\r\n<div class=\"row\">\r\n<div class=\"col-md-3\">\r\n<h4 class=\"margin-top-none\">Reliable Performance</h4>\r\n</div>\r\n<div class=\"col-md-9\">\r\n<p>Easily print up to 5,000 pages per month, plus enjoy fewer maintenance hassles, thanks to our state-of-the-art paper handling.</p>\r\n</div>\r\n</div>\r\n<hr />\r\n<div class=\"row\">\r\n<div class=\"col-md-3\">\r\n<h4 class=\"margin-top-none\">Super Fast and Quiet Output</h4>\r\n</div>\r\n<div class=\"col-md-9\">\r\n<p>Quickly print up to 25 pages per minute in black and color, plus produce a 1-page color document in as little as 11 seconds.</p>\r\n</div>\r\n</div>\r\n<hr />\r\n<div class=\"row\">\r\n<div class=\"col-md-3\">\r\n<h4 class=\"margin-top-none\">High Resolution Graphics</h4>\r\n</div>\r\n<div class=\"col-md-9\">\r\n<p>With up to true 1200x1200 dpi resolution, images and graphics stay crisp. Lexmark\'s Unison™ Toner ensures consistent quality, too.</p>\r\n</div>\r\n</div>\r\n<hr />\r\n<div class=\"row\">\r\n<div class=\"col-md-3\">\r\n<h4 class=\"margin-top-none\">Professional Color Matching</h4>\r\n</div>\r\n<div class=\"col-md-9\">\r\n<p>Lexmark Named Color Replacement and PANTONE® calibration make it easy to develop a consistent brand image by accurately matching your colors.</p>\r\n</div>\r\n</div>\r\n</div>'),('271',85,0,'91','LEXMARK CS310dn Color Laser Printer'),('272',75,0,'92','<fieldset>\r\n<h3 class=\"specTitle\">Model</h3>\r\n<dl><dt>Brand</dt><dd>Lexmark</dd></dl><dl><dt>Model</dt><dd>MS312dn</dd></dl><dl><dt>Part Number</dt><dd>35S0060-KIT</dd></dl><dl><dt>Recommended Use</dt><dd>Workgroup</dd></dl><dl><dt>Functions</dt><dd>Print</dd></dl><dl><dt>Display</dt><dd>2-line All Points Addressable (APA) monochrome LCD display</dd></dl></fieldset><fieldset>\r\n<h3 class=\"specTitle\">Print</h3>\r\n<dl><dt>Output Type</dt><dd>Monochrome</dd></dl><dl><dt><a id=\"def_colorPopup__6144\" class=\"specs-popup\" name=\"def-color\" data-t-events=\"A\" data-t-e-var78=\"Specification Popup:Laser Technology\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>Laser Technology</dt><dd>Laser</dd></dl><dl><dt>Black Print Speed</dt><dd>Print Speed (Letter, Black): Up to 35 ppm<br />Print Speed (Letter, Black) Duplex: Up to 16 spm</dd></dl><dl><dt><a id=\"def_colorPopup__6147\" class=\"specs-popup\" name=\"def-color\" data-t-events=\"A\" data-t-e-var78=\"Specification Popup:Black Print Quality\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>Black Print Quality</dt><dd>1200 Image Quality:1200 x 1200 dpi<br />2400 Image Quality: 600 x 600 dpi</dd></dl><dl><dt>Time To First Page (seconds)</dt><dd>6.5 sec.</dd></dl><dl><dt><a id=\"def_colorPopup__6150\" class=\"specs-popup\" name=\"def-color\" data-t-events=\"A\" data-t-e-var78=\"Specification Popup:Print Languages, std.\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>Print Languages, std.</dt><dd>PCL 5e Emulation<br />PCL 6 Emulation<br />Personal Printer Data Stream (PPDS)<br />PostScript 3 Emulation<br />Direct Image<br />Microsoft XPS (XML Paper Specification)<br />AirPrint</dd></dl><dl><dt><a id=\"def_colorPopup__6152\" class=\"specs-popup\" name=\"def-color\" data-t-events=\"A\" data-t-e-var78=\"Specification Popup:Duplex printing\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>Duplex printing</dt><dd>Yes</dd></dl><dl><dt><a id=\"def_colorPopup__6153\" class=\"specs-popup\" name=\"def-color\" data-t-events=\"A\" data-t-e-var78=\"Specification Popup:Max. Duty Cycle\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>Max. Duty Cycle</dt><dd>Maximum Monthly Duty Cycle: Up to 50000 pages per month<br />Recommended Monthly Page Volume: 500 - 2500 pages</dd></dl></fieldset><fieldset>\r\n<h3 class=\"specTitle\">Media Handling</h3>\r\n<dl><dt>Paper Trays, std.</dt><dd>2</dd></dl><dl><dt>Paper Trays, max.</dt><dd>3</dd></dl><dl><dt><a id=\"def_colorPopup__6173\" class=\"specs-popup\" name=\"def-color\" data-t-events=\"A\" data-t-e-var78=\"Specification Popup:Input Capacity, std.\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>Input Capacity, std.</dt><dd>300 pages</dd></dl><dl><dt>Input Capacity, max.</dt><dd>Up to 850 pages</dd></dl><dl><dt><a id=\"def_colorPopup__6175\" class=\"specs-popup\" name=\"def-color\" data-t-events=\"A\" data-t-e-var78=\"Specification Popup:Output Capacity, std.\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>Output Capacity, std.</dt><dd>150 pages</dd></dl><dl><dt>Output Capacity, max.</dt><dd>Up to 150 pages</dd></dl><dl><dt>Media Type</dt><dd>Card Stock<br />Envelopes<br />Paper Labels<br />Plain Paper<br />Transparencies<br />Refer to the Card Stock &amp; Label Guide.</dd></dl><dl><dt>Media sizes supported</dt><dd>10 Envelope<br />7 3/4 Envelope<br />9 Envelope<br />A4<br />A5<br />DL Envelope<br />Executive<br />Folio<br />JIS-B5<br />Legal<br />Letter<br />Statement<br />Universal<br />Oficio<br />A6</dd></dl></fieldset><fieldset>\r\n<h3 class=\"specTitle\">Ports</h3>\r\n<dl><dt>USB Ports</dt><dd>USB 2.0 Specification Hi-Speed Certified (Type B)</dd></dl><dl><dt>LPT Ports</dt><dd>Centronics IEEE 1284 Bidirectional Parallel</dd></dl><dl><dt><a id=\"def_colorPopup__6183\" class=\"specs-popup\" name=\"def-color\" data-t-events=\"A\" data-t-e-var78=\"Specification Popup:Network Ports\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>Network Ports</dt><dd>Ethernet 10/100BaseTX (RJ-45), also works with 1000Base-T</dd></dl></fieldset><fieldset>\r\n<h3 class=\"specTitle\">Hardware</h3>\r\n<dl><dt>Noise Level (Approx.)</dt><dd>Noise Level, Idle: 15 dBA<br />Noise Level (Print), Operating: 53 dBA<br />Duplex Print Noise Level, Operating: 52 dBA</dd></dl><dl><dt>Processor(MHz)</dt><dd>Dual Core, 800 MHz</dd></dl><dl><dt><a id=\"def_colorPopup__6189\" class=\"specs-popup\" name=\"def-color\" data-t-events=\"A\" data-t-e-var78=\"Specification Popup:Memory, std.\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>Memory, std.</dt><dd>128 MB</dd></dl><dl><dt>Memory, max.</dt><dd>128 MB</dd></dl><dl><dt>Power Consumption</dt><dd>Average Power (Hibernate Mode): 0.5 watts<br />Average Power (Sleep Mode): 3 watts<br />Average Power (Ready Mode): 7 watts<br />Average Power (Printing): 520 watts</dd></dl></fieldset><fieldset>\r\n<h3 class=\"specTitle\">Compatibility</h3>\r\n<dl><dt>Windows Compatible</dt><dd>Windows XP<br />Windows Server 2003<br />Windows XP x64<br />Windows Server 2003 x64<br />Windows Vista<br />Windows Vista x64<br />Windows Server 2008<br />Windows Server 2008 x64<br />Windows 7<br />Windows 7 x64<br />Windows Server 2008 R2<br />Windows 8<br />Windows 8 x64<br />Windows Server 2012<br />Windows 8.1<br />Windows 8.1 x64<br />Windows Server 2012 R2<br />Windows RT<br />Windows RT 8.1</dd></dl><dl><dt>Macintosh Compatible</dt><dd>Apple OS X (10.6, 10.7, 10.8, 10.9, 10.10)</dd></dl></fieldset><fieldset>\r\n<h3 class=\"specTitle\">Dimensions &amp; Weight</h3>\r\n<dl><dt>Dimensions</dt><dd>10.30\" x 15.70\" x 15.00\"</dd></dl><dl><dt>Weight</dt><dd>30.90 lbs.</dd></dl></fieldset>'),('273',76,0,'92','<ul>\r\n<li class=\"item\">Up to 35 ppm</li>\r\n<li class=\"item\">Up to 1200 x 1200 dpi</li>\r\n<li class=\"item\">USB, Ethernet, Parallel</li>\r\n<li class=\"item\">Duplex</li>\r\n</ul>\r\n<div><strong><span class=\"prod-sub-header\">Get your office printing done faster with this powerful Lexmark laser printer</span></strong></div>\r\n<div>\r\n<p class=\"prod-sub-header skuShortDescription\">Simplify your office printing with this efficient and powerful Lexmark laser printer. With built in Ethernet and USB ports, this printer connects to your network for easy set up and use. Print quickly at up to 35 pages per minute and enjoy a crisp high contrast 1200 x 1200 dpi output. This single-function, duplex printer features a powerful 800 GHz processor and 256 MB of RAM to handle even the largest printing jobs.</p>\r\n</div>\r\n<div class=\"prod-sub-header skuShortDescription\">\r\n<ul class=\"stp--bulleted-list\">\r\n<li><span>Printer function: Print</span></li>\r\n<li><span>Prints up to 35 ppm (black), up to 16 spm duplex (black)</span></li>\r\n<li><span>Ethernet 10/100BaseTX and Hi-Speed USB 20 connectivity</span></li>\r\n<li><span>Automatic 2-sided printing: Yes</span></li>\r\n<li><span>Dual-Core, 800 MHz processor and 128 MB of memory</span></li>\r\n<li><span>Print complex documents fast, run jobs without interruption</span></li>\r\n<li><span>Display: 2-line All Points Addressable (APA) monochrome LCD display</span></li>\r\n<li><span>Monthly duty cycle: Up to 50000 pages per month, 500 - 2500 pages recommended monthly page volume</span></li>\r\n<li><span>Printable area: 016 inches of the top, bottom, right and left edges (within)</span></li>\r\n<li><span>Print resolution: 1200 image quality, 1200 x 1200 dpi, 2400 image quality, 600 x 600 dpi black</span></li>\r\n<li><span>Paper input capacity: Up to 300 pages 20 lbs. bond standard, up to 850 pages 20 lbs. bond maximum, Paper output capacity: Up to 150 pages 20 lbs. bond standard and maximum</span></li>\r\n<li><span>Dimensions: 103\"H x 157\"W x 15\"D, Network printing methods: LPR/LPD, Direct IP (Port 9100), Enhanced IP (Port 9400), FTP, TFTP, Thin Print print integration, IPP 10, 11, 20 (internet printing protocol)</span></li>\r\n<li><span>Power: 520 watts (printing), 3 watts (sleep mode), 05 watts (hibernate mode), 7 watts (ready mode)</span></li>\r\n<li><span>Noise level: 15 dBA (Idle), 53 dBA (print), 52 dBA (duplex print)</span></li>\r\n<li><span>Media sizes supported: 10 envelope, 775\" envelope, 9 envelope, A4, A5, DL envelope, executive, folio, JIS-B5, legal, letter, statement, universal, office, A6, Media types supported: Card stock, envelopes, paper labels, plain paper, transparencies</span></li>\r\n<li><span>Network protocol support: TCP/IP IPv4, AppleTalk™, TCP/IP IPv6, TCP, UDP, Network security: SNMPv3, 8021x Authentication - MD5, MSCHAPv2, LEAP, PEAP, TLS, TTLS, IPSec</span></li>\r\n<li><span>Includes: Setup guide or sheet, statement of limited warranty, Lexmark cartridge collection program information, software and documentation CD, power cord</span></li>\r\n<li><span>Certification and standards: ENERGY STAR Typical Electricity Consumption</span></li>\r\n<li><span>Weight: 309 lbs.</span></li>\r\n</ul>\r\n</div>\r\n<div class=\"prod-sub-header skuShortDescription\">Tackle you printing work efficiently with the <strong>Lexmark laser printer</strong>. This printer enables you to print your documents at amazing speeds of up to 40 pages per minute. You can also effortlessly print documents full of graphics and images as large as 256 MB. The printer also allows you to work with a wide variety of protocols, devices and applications as long as they support printing.<br /><br /><strong>High Speed Printing</strong><br />This monochrome laser printer allows you to print documents at high speeds, hitting speeds of up to 40 pages per minute, due to its 800 MHz dual-core processor and high speed connectivity. It also kicks up very fast due to the instant warm-up fuser. This enables you to print your first page in about 6.5 seconds.<br /><br /><strong>Supports Most Protocols and Devices</strong><br />With this office laser printer, you can work with nearly all protocols, devices and applications as long as they posses printing abilities. This gives you freedom to use whatever device or protocol you can access.<br /><br /><strong>Able to Print Heavy Documents</strong><br />This black and white laser printer also enables you to print large documents, especially those laden with graphics and images as big as 256 MB. It also offers you a printing resolution of between 1200 x 1200 dpi and 600 x 600 dpi and allows you to do two-sided printing. </div>'),('274',85,0,'92','LEXMARK MS312dn Monochrome Laser Printer'),('275',75,0,'93','<fieldset>\r\n<h3 class=\"specTitle\">Compatible Cartridges</h3>\r\n<dl><dt>Cartridges Compatible</dt><dd>601H (60F1H00) High Yield Return Program Toner Cartridge<br />601 (60F1000) Return Program Toner Cartridge<br />602H (60F0HA0) High Yield Toner Cartridge<br />500Z (50F0Z00) Return Program Imaging Unit; Black<br />500ZA (50F0ZA0) Imaging Unit; Black</dd></dl></fieldset><fieldset>\r\n<h3 class=\"specTitle\">Model</h3>\r\n<dl><dt>Brand</dt><dd>Lexmark</dd></dl><dl><dt>Model</dt><dd>MX310dn</dd></dl><dl><dt>Part Number</dt><dd>35S5700</dd></dl><dl><dt>Recommended Use</dt><dd>Small Workgroup</dd></dl><dl><dt>Functions</dt><dd>4-in-1: Print, Copy, Scan &amp; Fax</dd></dl><dl><dt>Display</dt><dd>2.4-inch color LCD display</dd></dl></fieldset><fieldset>\r\n<h3 class=\"specTitle\">Print</h3>\r\n<dl><dt>Output Type</dt><dd>Monochrome</dd></dl><dl><dt><a id=\"def_colorPopup__6144\" class=\"specs-popup\" name=\"def-color\" data-t-events=\"A\" data-t-e-var78=\"Specification Popup:Laser Technology\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>Laser Technology</dt><dd>Laser</dd></dl><dl><dt>Black Print Speed</dt><dd>Print Speed (Letter, Black): Up to 35 ppm<br />Print Speed (Letter, Black) Duplex: Up to 16 spm</dd></dl><dl><dt>Color Print Speed</dt><dd>Black</dd></dl><dl><dt><a id=\"def_colorPopup__6147\" class=\"specs-popup\" name=\"def-color\" data-t-events=\"A\" data-t-e-var78=\"Specification Popup:Black Print Quality\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>Black Print Quality</dt><dd>1200 Image Quality<br />1200 x 1200 dpi<br />2400 Image Quality<br />600 x 600 dpi</dd></dl><dl><dt>Time To First Page (seconds)</dt><dd>6.5 sec.</dd></dl><dl><dt><a id=\"def_colorPopup__6150\" class=\"specs-popup\" name=\"def-color\" data-t-events=\"A\" data-t-e-var78=\"Specification Popup:Print Languages, std.\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>Print Languages, std.</dt><dd>PCL 5e Emulation<br />PCL 6 Emulation<br />Personal Printer Data Stream (PPDS)<br />PostScript 3 Emulation<br />Microsoft XPS (XML Paper Specification)<br />AirPrint<br />PDF 1.7 emulation</dd></dl><dl><dt><a id=\"def_colorPopup__6152\" class=\"specs-popup\" name=\"def-color\" data-t-events=\"A\" data-t-e-var78=\"Specification Popup:Duplex printing\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>Duplex printing</dt><dd>Yes</dd></dl><dl><dt><a id=\"def_colorPopup__6153\" class=\"specs-popup\" name=\"def-color\" data-t-events=\"A\" data-t-e-var78=\"Specification Popup:Max. Duty Cycle\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>Max. Duty Cycle</dt><dd>Maximum Monthly Duty Cycle: Up to 50000 pages per month<br />Recommended Monthly Page Volume: 250 - 6000 pages</dd></dl></fieldset><fieldset>\r\n<h3 class=\"specTitle\">Copy</h3>\r\n<dl><dt>Copy Speed, Black</dt><dd>Copy Speed (Letter, Black): Up to 35 cpm<br />Copy Speed (Letter, Black) Duplex: Up to 17 spm</dd></dl><dl><dt>Copy Speed, Color</dt><dd>Black</dd></dl><dl><dt>Max. Document Enlargement</dt><dd>400%</dd></dl><dl><dt>Max. Document Reduction</dt><dd>25%</dd></dl><dl><dt>Copy Features</dt><dd>Time to First Copy (Black): As fast as 6.5 seconds</dd></dl></fieldset><fieldset>\r\n<h3 class=\"specTitle\">Scan</h3>\r\n<dl><dt>Scan Element</dt><dd>CIS</dd></dl><dl><dt>Scan Resolution, Optical</dt><dd>600 x 600 ppi (color)<br />1200 x 600 ppi (black)</dd></dl><dl><dt>Scan Maximum Document Size</dt><dd>8.5\" x 14\"</dd></dl><dl><dt>Scan Features</dt><dd>Simplex Scan Speed (A4/Ltr, Black): Up to 42 / 43 sides per minute<br />Simplex Scan Speed (A4/Ltr, Color): Up to 19 / 20 sides per minute<br /><br />ADF Scan: Simplex<br />Scanner Type: Flatbed scanner with ADF<br /><br />Scan File Formats (Send as):<br />JPEG, JPG<br />PDF<br />TIFF<br />XPS<br /><br />Scan Destinations:<br />e-mail<br />FTP<br />USB Flash drive<br />USB or Network connected computer<br />Lexmark Document Solutions Suite (LDSS)</dd></dl></fieldset><fieldset>\r\n<h3 class=\"specTitle\">Fax</h3>\r\n<dl><dt>Color Fax</dt><dd>Black</dd></dl><dl><dt>Fax Transmission Speed</dt><dd>&lt; 3 seconds per page</dd></dl><dl><dt>Modem Speed</dt><dd>ITU T.30, V.34 Half-Duplex, 33.6 Kbps</dd></dl></fieldset><fieldset>\r\n<h3 class=\"specTitle\">Media Handling</h3>\r\n<dl><dt>Paper Trays, std.</dt><dd>2</dd></dl><dl><dt>Paper Trays, max.</dt><dd>3</dd></dl><dl><dt><a id=\"def_colorPopup__6173\" class=\"specs-popup\" name=\"def-color\" data-t-events=\"A\" data-t-e-var78=\"Specification Popup:Input Capacity, std.\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>Input Capacity, std.</dt><dd>Up to 300 pages 20.00 lbs. or 75 gsm bond:<br />250 Pages Input<br />50 Pages Multipurpose Feeder<br /><br />ADF: 50 Pages Automatic Document Feeder<br />ADF Paper Input Capacity: Up to 50 pages 20.00 lbs. or 75 gsm bond<br />ADF Paper Output Capacity: Up to 50 pages 20.00 lbs. or 75 gsm bond</dd></dl><dl><dt>Input Capacity, max.</dt><dd>Up to 850 pages 20.00 lbs. or 75 gsm bond</dd></dl><dl><dt><a id=\"def_colorPopup__6175\" class=\"specs-popup\" name=\"def-color\" data-t-events=\"A\" data-t-e-var78=\"Specification Popup:Output Capacity, std.\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>Output Capacity, std.</dt><dd>Up to 150 pages 20.00 lbs. or 75 gsm bond</dd></dl><dl><dt>Output Capacity, max.</dt><dd>Up to 150 pages 20.00 lbs. or 75 gsm bond</dd></dl><dl><dt>Media Type</dt><dd>Card Stock<br />Envelopes<br />Paper Labels<br />Plain Paper<br />Transparencies</dd></dl><dl><dt>Media sizes supported</dt><dd>Paper Weight Range Supported - Standard Tray (lbs.): 16.00 - 24.00 lbs.<br /><br />10 Envelope<br />7 3/4 Envelope<br />9 Envelope<br />A4<br />A5<br />DL Envelope<br />Executive<br />Folio<br />JIS-B5<br />Legal<br />Letter<br />Statement<br />Universal<br />Oficio<br />A6</dd></dl></fieldset><fieldset>\r\n<h3 class=\"specTitle\">Ports</h3>\r\n<dl><dt>USB Ports</dt><dd>USB 2.0 Specification Hi-Speed Certified (Type B)</dd></dl><dl><dt><a id=\"def_colorPopup__6183\" class=\"specs-popup\" name=\"def-color\" data-t-events=\"A\" data-t-e-var78=\"Specification Popup:Network Ports\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>Network Ports</dt><dd>Ethernet 10/100BaseTX (RJ-45), also works with 1000Base-T</dd></dl></fieldset><fieldset>\r\n<h3 class=\"specTitle\">Hardware</h3>\r\n<dl><dt>Noise Level (Approx.)</dt><dd>Noise Level (Print), Operating: 53 dBA<br />Duplex Print Noise Level, Operating: 52 dBA<br />Noise Level (Copy), Operating: 54 dBA<br />Noise Level (Scan), Operating: 55 dBA</dd></dl><dl><dt>Processor(MHz)</dt><dd>Dual Core, 800 MHz</dd></dl><dl><dt><a id=\"def_colorPopup__6189\" class=\"specs-popup\" name=\"def-color\" data-t-events=\"A\" data-t-e-var78=\"Specification Popup:Memory, std.\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>Memory, std.</dt><dd>256 MB</dd></dl><dl><dt>Memory, max.</dt><dd>256 MB</dd></dl><dl><dt>Power Consumption</dt><dd>Average Power (Hibernate Mode): 0.4 watt<br />Average Power (Sleep Mode): 3.2 watts<br />Average Power (Ready Mode): 9.0 watts<br />Average Power (Printing): 520 watts<br />Average Power (Copying): 540 watts<br />Average Power (Scanning): 20 watts<br />ENERGY STAR Typical Electricity Consumption (TEC): 1.8 kilowatt-hours per week</dd></dl></fieldset><fieldset>\r\n<h3 class=\"specTitle\">Compatibility</h3>\r\n<dl><dt>Windows Compatible</dt><dd>Windows XP<br />Windows Server 2003<br />Windows XP x64<br />Windows Server 2003 x64<br />Windows Vista<br />Windows Vista x64<br />Windows Server 2008<br />Windows Server 2008 x64<br />Windows 7<br />Windows 7 x64<br />Windows Server 2008 R2<br />Windows 8<br />Windows 8 x64<br />Windows Server 2012<br />Windows 8.1<br />Windows 8.1 x64<br />Windows Server 2012 R2<br />Windows RT<br />Windows RT 8.1<br />Windows 10</dd></dl><dl><dt>Macintosh Compatible</dt><dd>Apple OS X (10.5, 10.6, 10.7, 10.8, 10.9, 10.10)</dd></dl><dl><dt>Other</dt><dd>Citrix MetaFrame:<br />Microsoft Windows Server 2003 running Terminal Services with Citrix Presentation Server 3.0, 4.0, 4.5<br />Microsoft Windows Server 2003 x64 running Terminal Services with Citrix Presentation Server 4.0 x64, 4.5 x64<br />Microsoft Windows Server 2003 and 2003 X64 Edition with Citrix XenApp 5.0<br />Microsoft Windows Server 2008 and 2008 X64 Edition with Citrix XenApp 5.0<br />Microsoft Windows Server 2008 R2 with Citrix XenApp 6.0, 6.5<br /><br />Linux Operating Systems Supported:<br />SUSE Linux Enterprise Server 10, 11<br />SUSE Linux Enterprise Desktop 10, 11<br />Red Flag Linux Desktop 6.0<br />Linpus Linux Desktop 9.6<br />Debian GNU/Linux 5.0, 6.0<br />Red Hat Enterprise Linux WS 4.0, 5.0, 6.0<br />Ubuntu 11.04, 11.10, 12.04, 12.10<br />openSUSE 11.3, 11.4, 12.1, 12.2<br />PCLinuxOS 2011<br />Mint 9, 10, 11, 12, 13<br />Fedora 14, 15, 16, 17<br /><br />Novell Operating Systems Supported:<br />Novell NetWare 6.5 Open Enterprise Server<br />Novell NetWare 5.1 (SP 6+), 6.0 (SP 3+) with Novell Distributed Print Services (NDPS)<br />Novell Open Enterprise Server on SUSE Linux Enterprise Server<br /><br />UNIX Operating Systems Supported:<br />Sun Solaris SPARC 9, 10<br />HP-UX 11.11, 11.23, 11.31<br />Sun Solaris x86 10, 11<br />IBM AIX 5.3, 6.1, 7.1</dd></dl></fieldset><fieldset>\r\n<h3 class=\"specTitle\">Features</h3>\r\n<dl><dt>Features</dt><dd>Faster Processing<br /><br />Reliable Performance<br /><br />Keep Jobs Moving<br /><br />Get Work Done Quickly<br /><br />High Resolution Graphics</dd></dl></fieldset><fieldset>\r\n<h3 class=\"specTitle\">Dimensions &amp; Weight</h3>\r\n<dl><dt>Dimensions</dt><dd>18.40\" x 15.70\" x 18.60\"</dd></dl><dl><dt>Weight</dt><dd>44.00 lbs.</dd></dl></fieldset>'),('276',76,0,'93','<ul>\r\n<li class=\"item\">Up to 35 ppm</li>\r\n<li class=\"item\">Up to 1200 x 1200 dpi</li>\r\n<li class=\"item\">USB and Ethernet Compatible</li>\r\n<li class=\"item\">Duplex Printing</li>\r\n</ul>\r\n<div id=\"wc-demo-4459291e\" class=\"wc-fragment wc-no-focus\" data-channel-product-name=\"\" data-compiler-v=\"2018.17.2.401\" data-cpi=\"N82E16828006573\" data-is-capdesc-open=\"false\" data-language-code=\"en\" data-module-brand=\"Lexmark\" data-module-code=\"lexmark\" data-module-name=\"Lexmark\" data-mpn=\"35s5700\" data-produced=\"2018-09-17 05:24\" data-section-caption=\"Product Tour\" data-section-tag=\"demo\" data-section-template-code=\"tour\" data-vendor-name=\"MX310dn\" data-wcpc=\"mx310dn\" data-is-reported-view=\"true\">\r\n<h2 class=\"wc-first-header\">FEATURES</h2>\r\n</div>\r\n<div id=\"wc-overview-b84b6d5b\" class=\"wc-fragment wc-no-focus\" data-channel-product-name=\"\" data-compiler-v=\"2018.17.2.401\" data-cpi=\"N82E16828006573\" data-is-capdesc-open=\"false\" data-language-code=\"en\" data-module-brand=\"Lexmark\" data-module-code=\"lexmark\" data-module-name=\"Lexmark\" data-mpn=\"35s5700\" data-produced=\"2018-09-17 05:24\" data-section-caption=\"Features\" data-section-tag=\"overview\" data-section-template-code=\"rich-features\" data-vendor-name=\"MX310dn\" data-wcpc=\"mx310dn\" data-is-reported-view=\"true\">\r\n<div class=\"wc-aplus-body\">\r\n<div class=\"wc-reset\">\r\n<ul class=\"wc-rich-features wc-rich-content-orientation-right-aligned wc-first wc-rich-features-center-984\">\r\n<li class=\"wc-rich-feature-item wc-text-placement-false wc-odd-0 wc-first wc-has-media wc-thumb-medium wc-last \">\r\n<div class=\"wc-media-wrap\">\r\n<div class=\"wc-media-inner-wrap\"><img class=\"wc-media wc-image\" title=\"Versatility. Compact Design.\" src=\"https://smedia.webcollage.net/rwvfp/wc/cp/21712984_legacycode/module/lexmark/_cp/products/mx310dn/tab-a5b09ac3-4f18-44e1-9144-e85b4ac63edf/resource-df81fc3b-2f9a-4010-a902-278daf3782ef.jpg\" alt=\"\" width=\"182\" height=\"182\" data-asset-title=\"Versatility. Compact Design.\" data-asset-type=\"image\" data-asset-url=\"/_cp/products/mx310dn/tab-a5b09ac3-4f18-44e1-9144-e85b4ac63edf/resource-d7819d18-f05c-42b7-9889-aabed6ffdd0c.jpg\" data-asset-wrapper=\"rich-features\" data-height=\"182\" data-section-template-code=\"rich-features\" data-width=\"182\" /></div>\r\n</div>\r\n<div class=\"wc-text-wrap\">\r\n<h3 class=\"wc-rich-content-header wc-feature-main-header \">VERSATILITY. COMPACT DESIGN.</h3>\r\n<div class=\"wc-rich-content-description\">\r\n<div>The network-ready Lexmark MX310dn MFP with 2-sided printing includes 256MB standard printer memory and has print, copy and scan speeds as fast as 35 ppm.</div>\r\n</div>\r\n</div>\r\n</li>\r\n</ul>\r\n</div>\r\n<div class=\"wc-reset\">\r\n<ul class=\"wc-rich-features wc-rich-content-orientation-two-columns wc-rf-columns wc-rich-features-center-984\">\r\n<li class=\"wc-rich-feature-item wc-text-placement-false wc-odd-0 wc-first wc-has-media wc-thumb-medium \">\r\n<div class=\"wc-media-wrap\">\r\n<div class=\"wc-media-inner-wrap\"><img class=\"wc-media wc-image\" title=\"Faster Processing\" src=\"https://smedia.webcollage.net/rwvfp/wc/cp/21712984_legacycode/module/lexmark/_cp/products/mx310dn/tab-a5b09ac3-4f18-44e1-9144-e85b4ac63edf/resource-406afac3-ce99-46d0-94fd-4a29be6ecf62.jpg\" alt=\"\" width=\"199\" height=\"120\" data-asset-title=\"Faster Processing\" data-asset-type=\"image\" data-asset-url=\"/_cp/products/mx310dn/tab-a5b09ac3-4f18-44e1-9144-e85b4ac63edf/resource-d8d4a12e-94d4-434f-98fa-27e5c2b1943d.jpg\" data-asset-wrapper=\"rich-features\" data-height=\"120\" data-section-template-code=\"rich-features\" data-width=\"199\" /></div>\r\n</div>\r\n<h3 class=\"wc-rich-content-header wc-feature-main-header \">FASTER PROCESSING</h3>\r\n<div class=\"wc-rich-content-description\">\r\n<p>Improve your print, scan and copy speeds by taking advantage of 256 MB of memory and an 800 MHz dual-core processor.</p>\r\n</div>\r\n</li>\r\n \r\n<li class=\"wc-rich-feature-item wc-text-placement-false wc-even-0 wc-has-media wc-thumb-medium \">\r\n<div class=\"wc-media-wrap\">\r\n<div class=\"wc-media-inner-wrap\"><img class=\"wc-media wc-image\" title=\"Reliable Performance\" src=\"https://smedia.webcollage.net/rwvfp/wc/cp/21712984_legacycode/module/lexmark/_cp/products/mx310dn/tab-a5b09ac3-4f18-44e1-9144-e85b4ac63edf/resource-f5bd51e8-919d-40bd-ac5c-ef3e7a907dc9.jpg\" alt=\"\" width=\"199\" height=\"120\" data-asset-title=\"Reliable Performance\" data-asset-type=\"image\" data-asset-url=\"/_cp/products/mx310dn/tab-a5b09ac3-4f18-44e1-9144-e85b4ac63edf/resource-d34b87ad-1956-4d9d-9682-2a0492829e30.jpg\" data-asset-wrapper=\"rich-features\" data-height=\"120\" data-section-template-code=\"rich-features\" data-width=\"199\" /></div>\r\n</div>\r\n<h3 class=\"wc-rich-content-header wc-feature-main-header \">RELIABLE PERFORMANCE</h3>\r\n<div class=\"wc-rich-content-description\">\r\n<p>Easily print up to 6,000 pages per month, plus enjoy fewer maintenance hassles, thanks to our state-of-the-art paper handling.</p>\r\n</div>\r\n</li>\r\n \r\n<li class=\"wc-rich-feature-item wc-text-placement-false wc-odd-0 wc-has-media wc-thumb-medium \">\r\n<div class=\"wc-media-wrap\">\r\n<div class=\"wc-media-inner-wrap\"><img class=\"wc-media wc-image\" title=\"Keep Jobs Moving\" src=\"https://smedia.webcollage.net/rwvfp/wc/cp/21712984_legacycode/module/lexmark/_cp/products/mx310dn/tab-a5b09ac3-4f18-44e1-9144-e85b4ac63edf/resource-72c1ee00-c1fa-4452-93c6-d01b6ba63989.jpg\" alt=\"\" width=\"199\" height=\"120\" data-asset-title=\"Keep Jobs Moving\" data-asset-type=\"image\" data-asset-url=\"/_cp/products/mx310dn/tab-a5b09ac3-4f18-44e1-9144-e85b4ac63edf/resource-c5ca24b6-3468-4528-a6b8-175884a1acd4.jpg\" data-asset-wrapper=\"rich-features\" data-height=\"120\" data-section-template-code=\"rich-features\" data-width=\"199\" /></div>\r\n</div>\r\n<h3 class=\"wc-rich-content-header wc-feature-main-header \">KEEP JOBS MOVING</h3>\r\n<div class=\"wc-rich-content-description\">\r\n<p>With a maximum input capacity of up to 850 sheets and a high yield toner cartridge, you won’t have to add paper or change cartridges as often.</p>\r\n</div>\r\n</li>\r\n \r\n<li class=\"wc-rich-feature-item wc-text-placement-false wc-even-0 wc-has-media wc-thumb-medium \">\r\n<div class=\"wc-media-wrap\">\r\n<div class=\"wc-media-inner-wrap\"><img class=\"wc-media wc-image\" title=\"Get Work Done Quickly.\" src=\"https://smedia.webcollage.net/rwvfp/wc/cp/21712984_legacycode/module/lexmark/_cp/products/mx310dn/tab-a5b09ac3-4f18-44e1-9144-e85b4ac63edf/resource-02954065-8017-4095-93bf-286bcd60eb16.jpg\" alt=\"\" width=\"199\" height=\"120\" data-asset-title=\"Get Work Done Quickly.\" data-asset-type=\"image\" data-asset-url=\"/_cp/products/mx310dn/tab-a5b09ac3-4f18-44e1-9144-e85b4ac63edf/resource-eb689bb9-ebaf-450e-9022-23ce488cbe23.jpg\" data-asset-wrapper=\"rich-features\" data-height=\"120\" data-section-template-code=\"rich-features\" data-width=\"199\" /></div>\r\n</div>\r\n<h3 class=\"wc-rich-content-header wc-feature-main-header \">GET WORK DONE QUICKLY.</h3>\r\n<div class=\"wc-rich-content-description\">\r\n<p>Enjoy print speeds up to 35 pages per minute, plus print or copy your first page in as little as 6.5 seconds.</p>\r\n</div>\r\n</li>\r\n \r\n<li class=\"wc-rich-feature-item wc-text-placement-false wc-odd-0 wc-has-media wc-thumb-medium wc-last \">\r\n<div class=\"wc-media-wrap\">\r\n<div class=\"wc-media-inner-wrap\"><img class=\"wc-media wc-image\" title=\"High Resolution Graphics\" src=\"https://smedia.webcollage.net/rwvfp/wc/cp/21712984_legacycode/module/lexmark/_cp/products/mx310dn/tab-a5b09ac3-4f18-44e1-9144-e85b4ac63edf/resource-b3d8bec9-2d46-4ae4-9222-e28ef6583a84.jpg\" alt=\"\" width=\"199\" height=\"120\" data-asset-title=\"High Resolution Graphics\" data-asset-type=\"image\" data-asset-url=\"/_cp/products/mx310dn/tab-a5b09ac3-4f18-44e1-9144-e85b4ac63edf/resource-341384f1-e647-4102-b969-f79a4426cfde.jpg\" data-asset-wrapper=\"rich-features\" data-height=\"120\" data-section-template-code=\"rich-features\" data-width=\"199\" /></div>\r\n</div>\r\n<h3 class=\"wc-rich-content-header wc-feature-main-header \">HIGH RESOLUTION GRAPHICS</h3>\r\n<div class=\"wc-rich-content-description\">\r\n<p>With up to true 1200x1200 dpi resolution, images and graphics stay crisp. Lexmark \'s Unison™ Toner ensures consistent quality, too.</p>\r\n</div>\r\n</li>\r\n</ul>\r\n</div>\r\n<div class=\"wc-reset\">\r\n<ul class=\"wc-rich-features wc-rich-content-orientation-right-aligned wc-last wc-no-line-seperator wc-rich-features-center-984\">\r\n<li class=\"wc-rich-feature-item wc-text-placement-false wc-odd-0 wc-first wc-has-no-caption wc-last \">\r\n<div class=\"wc-text-wrap\">\r\n<div class=\"wc-rich-content-description\">\r\n<ul>\r\n<li>Lexmark MX310dn multifunction laser printer</li>\r\n<li>Up to 2,500 pages starter return program toner cartridge</li>\r\n<li>Up to 60,000 pages** return program imaging unit </li>\r\n<li>Software and documentation CD</li>\r\n<li>Setup guide or sheet (network and local attachment)</li>\r\n<li>RJ-11 Phone cable or adapter (country dependent)</li>\r\n<li>Power cord(s)</li>\r\n<li>Statement of limited warranty / guarantee</li>\r\n<li>Stability sheet and safety sheet or booklet</li>\r\n<li>Lexmark Cartridge Collection Program information</li>\r\n</ul>\r\n<br /><br />\r\n<p><i>*Average Continuous Cartridge Yield in one-sided (simplex) mode 2,500 standard pages. Declared yield value in accordance with ISO/IEC 19752.</i></p>\r\n<p><i>Ethernet, USB or parallel cable not included.</i></p>\r\n<p><i>Box contents may vary by country and/or reseller. Subject to change without notice.</i></p>\r\n<p><i>**Imaging Unit yield based on 3 average letter/A4-size pages per print job and approximately 5% coverage. Actual Yield may vary based on other factors such as device speed, paper size and feed orientation, toner coverage, tray source, percentage of black-only printing and average print job complexity. </i></p>\r\n</div>\r\n</div>\r\n</li>\r\n</ul>\r\n</div>\r\n</div>\r\n</div>'),('277',85,0,'93','LEXMARK MX310dn Monochrome Laser Printer'),('278',75,0,'94','<div class=\"product-detail-in-the-box section\">\r\n<div class=\"row\">\r\n<div class=\"col-md-9\">\r\n<div class=\"row\">\r\n<div class=\"col-xs-12\">\r\n<ul class=\"column-fill-xs-1 column-fill-sm-2 padding-before-2\">\r\n<li>Lexmark Cartridge Collection Program information</li>\r\n<li>Stability sheet and safety sheet or booklet</li>\r\n<li>Statement of limited warranty / guarantee</li>\r\n<li>Return program imaging unit</li>\r\n<li>Up to 7,500 pages* starter return program toner cartridge</li>\r\n<li>Includes hard disk.</li>\r\n<li>Lexmark MX611de multifunction laser printer</li>\r\n<li>Power cord(s)</li>\r\n<li>RJ-11 Phone cable or adapter (country dependent)</li>\r\n<li>Setup guide or sheet (network and local attachment)</li>\r\n<li>Software and documentation CD</li>\r\n</ul>\r\n</div>\r\n<div class=\"col-xs-12\">\r\n<p class=\"text-tiny\">Box contents may vary by country and/or reseller. Subject to change without notice.</p>\r\n<p class=\"text-tiny\">Ethernet, USB or parallel cable not included.</p>\r\n<p class=\"text-tiny\">*Average Continuous Cartridge Yield in one-sided (simplex) mode 7,500 standard pages. Declared yield value in accordance with ISO/IEC 19752.</p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<hr /></div>\r\n<div class=\"product-detail-tech-specs section\">\r\n<div class=\"row\">\r\n<div class=\"col-md-3\">\r\n<h3>General Specs</h3>\r\n</div>\r\n<div class=\"col-md-9\">\r\n<div class=\"row\">\r\n<div class=\"col-xs-12\">\r\n<table class=\"table margin-top-2\">\r\n<tbody>\r\n<tr><th scope=\"row\">Part #</th>\r\n<td>35S6702</td>\r\n</tr>\r\n<tr><th scope=\"row\">Print Technology</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>Monochrome Laser</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">Function</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>Copying</li>\r\n<li>Color Scanning</li>\r\n<li>Printing</li>\r\n<li>Network Scanning</li>\r\n<li>Faxing</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">Workgroup Size</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>Medium Workgroup</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">Display</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>Lexmark e-Task 7-inch (17.8 cm) color touch screen</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">Media Sizes Supported</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>A6, Oficio, 7 3/4 Envelope, 9 Envelope, JIS-B5, A4, Legal, A5, Letter, Statement, Executive, Universal, DL Envelope, Folio, 10 Envelope</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">Included Paper Handling</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>100-Sheet Multipurpose Feeder, 250-Sheet Output Bin, Integrated Duplex, 550-Sheet Input</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">Standard Ports</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>Gigabit Ethernet (10/100/1000), Front USB 2.0 Specification Hi-Speed Certified port (Type A), Rear USB 2.0 Specification Hi-Speed Certified port (Type A), USB 2.0 Specification Hi-Speed Certified (Type B), One Internal Card Slot</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">Size (mm - H x W x D)</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>561 x 489 x 479 mm</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">Weight</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>23.6 kg</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">Packaged Size (mm - H x W x D)</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>673 x 572 x 599 mm</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">Packaged Weight, kg</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>28 kg</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<hr />\r\n<div class=\"row\">\r\n<div class=\"col-md-3\">\r\n<h3>Copying</h3>\r\n</div>\r\n<div class=\"col-md-9\">\r\n<div class=\"row\">\r\n<div class=\"col-xs-12\">\r\n<table class=\"table margin-top-2\">\r\n<tbody>\r\n<tr><th scope=\"row\">Copy Speed</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>Up to:</li>\r\n<li>Black: 47 cpm<span>1</span> (A4)</li>\r\n<li>Black: 50 cpm (Letter)</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">Copy Speed Duplex</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>Up to:</li>\r\n<li>Black: 23 spm (Letter)</li>\r\n<li>Black: 23 spm (A4)</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">Time to First Copy</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>As fast as:</li>\r\n<li>Black: 6.5 seconds</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">Reduce / Enlarge Range</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>25 - 400 %</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<hr />\r\n<div class=\"row\">\r\n<div class=\"col-md-3\">\r\n<h3>Faxing</h3>\r\n</div>\r\n<div class=\"col-md-9\">\r\n<div class=\"row\">\r\n<div class=\"col-xs-12\">\r\n<table class=\"table margin-top-2\">\r\n<tbody>\r\n<tr><th scope=\"row\">Modem Speed</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>ITU T.30, V.34 Half-Duplex, 33.6 Kbps</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">Fax Transmission Speed</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>&lt; 3 seconds per page</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<hr />\r\n<div class=\"row\">\r\n<div class=\"col-md-3\">\r\n<h3>Printing</h3>\r\n</div>\r\n<div class=\"col-md-9\">\r\n<div class=\"row\">\r\n<div class=\"col-xs-12\">\r\n<table class=\"table margin-top-2\">\r\n<tbody>\r\n<tr><th scope=\"row\">Print Speed</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>Black: 47 ppm (A4)</li>\r\n<li>50 ppm</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">Print Speed Duplex</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>Up to:</li>\r\n<li>Black: 20 spm (A4)</li>\r\n<li>Black: 22 spm (Letter)</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">Time to First Page</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>As fast as:</li>\r\n<li>Black: 6.5 seconds</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">Print Resolution</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>Black: 1200 x 1200 dpi, 2400 Image Quality, 600 x 600 dpi, 1200 Image Quality</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">Duplex (2-sided) Printing</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>Integrated Duplex</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">Printable Area</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>metric: 4.0 mm of the top, bottom, right and left edges (within)</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<hr />\r\n<div class=\"row\">\r\n<div class=\"col-md-3\">\r\n<h3>Scanning</h3>\r\n</div>\r\n<div class=\"col-md-9\">\r\n<div class=\"row\">\r\n<div class=\"col-xs-12\">\r\n<table class=\"table margin-top-2\">\r\n<tbody>\r\n<tr><th scope=\"row\">Scanner Type / ADF Scan</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>Flatbed scanner with ADF</li>\r\n<li>RADF (reversing Duplex)</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">Scan Area</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>mm:</li>\r\n<li>215.9 x 355.6 mm (Maximum)</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">A4/Ltr Simplex Scan Speed</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>Up to:</li>\r\n<li>Black: 45 / 48 sides per minute</li>\r\n<li>Color: 30 / 32 sides per minute</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">A4/Ltr Duplex Scan Speed</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>Up to:</li>\r\n<li>Black: 20 / 21 sides per minute</li>\r\n<li>Color: 13 / 14 sides per minute</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">Scan Technology</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>CCD</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">Optical Scanning Resolution</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>up to 1200 X 600 ppi (black)</li>\r\n<li>up to 600 X 600 ppi (color)</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">Scan File Formats</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>Send as:</li>\r\n<li>XPS, TIFF, Highly compressed PDF (1GB RAM and hard disk required), Archival PDF (A-1a, A-1b), Secure PDF, Searchable PDF (optional OCR with 1GB RAM and hard disk required), PDF, JPEG, JPG</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">Scan Destinations</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>e-mail, Lexmark Document Solutions Suite (LDSS), USB or Network connected computer, USB Flash drive, FTP</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">ADF</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>50-Sheet Automatic Document Feeder</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">ADF Paper Input Capacity / ADF Paper Output Capacity</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>Up to: 50 pages 20 lb or 75 gsm bond</li>\r\n<li>Up to: 50 pages 20 lb or 75 gsm bond</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">A4/Ltr Duplex Scan Speed</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>20 / 21 sides per minute</li>\r\n<li>13 / 14 sides per minute</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">A4/Ltr Simplex Scan Speed</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>45 / 48 sides per minute</li>\r\n<li>30 / 32 sides per minute</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<hr />\r\n<div class=\"row\">\r\n<div class=\"col-md-3\">\r\n<h3>Paper Handling</h3>\r\n</div>\r\n<div class=\"col-md-9\">\r\n<div class=\"row\">\r\n<div class=\"col-xs-12\">\r\n<table class=\"table margin-top-2\">\r\n<tbody>\r\n<tr><th scope=\"row\">Media Types Supported</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>Paper Labels, Card Stock, Plain Paper, Transparencies, Envelopes, Refer to the Card Stock &amp; Label Guide.</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">Finishing Option</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>Yes</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">Number of Paper Inputs</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>Standard: 2</li>\r\n<li>Maximum: 5</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">Paper Input Capacity</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>Standard: 650 pages 20 lb or 75 gsm bond</li>\r\n<li>Maximum: 2300 pages 20 lb or 75 gsm bond</li>\r\n<li>650 pages 20 lb or 75 gsm bond</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">Paper Output Capacity</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>Up to:</li>\r\n<li>Standard: 250 pages 20 lb or 75 gsm bond</li>\r\n<li>Maximum: 250 pages 20 lb or 75 gsm bond</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">Paper Weight Range Supported</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>gsm:</li>\r\n<li>60 - 120 gsm (Standard Tray)</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">Optional Paper Handling</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>550-Sheet Lockable Tray, Inline Stapler, 250-Sheet Tray, 550-Sheet Tray</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">Recommended Monthly Page Volume</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>2000 - 15000 pages<span>2</span></li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">Maximum Monthly Duty Cycle</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>Up to:</li>\r\n<li>175000 pages per month<span>3</span></li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<hr />\r\n<div class=\"row\">\r\n<div class=\"col-md-3\">\r\n<h3>Cartridges &amp; Imaging</h3>\r\n</div>\r\n<div class=\"col-md-9\">\r\n<div class=\"row\">\r\n<div class=\"col-xs-12\">\r\n<table class=\"table margin-top-2\">\r\n<tbody>\r\n<tr><th scope=\"row\">Laser Cartridge Yields</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>up to:</li>\r\n<li>10,000<span>4</span> -page High Yield Cartridge</li>\r\n<li>2,500<span>4</span> -page Cartridge</li>\r\n<li>20,000<span>4</span> -page Extra High Yield Cartridge</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">Imaging Unit Estimated Yield</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>Up to:</li>\r\n<li>60000 pages, based on 3 average letter/A4-size pages per print job and ~ 5% coverage<span>5</span></li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">Cartridge(s) Shipping with Product</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>7,500<span>0</span> -page Starter Return Program Toner Cartridge</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">Replacement Cartridges:</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>Product functions only with replacement cartridges designed for use in a specific geographical region. See www.lexmark.com/regions for more details.</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<hr />\r\n<div class=\"row\">\r\n<div class=\"col-md-3\">\r\n<h3>Hardware</h3>\r\n</div>\r\n<div class=\"col-md-9\">\r\n<div class=\"row\">\r\n<div class=\"col-xs-12\">\r\n<table class=\"table margin-top-2\">\r\n<tbody>\r\n<tr><th scope=\"row\">Processor</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>Dual Core, 800 MHz</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">Memory</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>Standard: 1024 MB</li>\r\n<li>Maximum: 3072 MB</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">Hard Disk</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>Included in configuration</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">Printer Languages</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>Standard:</li>\r\n<li>PCL 5e Emulation, PCL 6 Emulation, Microsoft XPS (XML Paper Specification), Personal Printer Data Stream (PPDS), PostScript 3 Emulation, PDF 1.7 emulation, Direct Image, AirPrint™</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">Fonts and Symbol Sets</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>2 PCL bitmap fonts, OCR-A, OCR-B scalable PCL 5e fonts, For more information, refer to the Technical Reference., 84 scalable PCL fonts, 91 scalable PostScript fonts, 3 of 9 scalable PCL 5e fonts in Narrow, Regular and Wide, 5 PPDS bitmap fonts, 39 scalable PPDS fonts</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">Touch Screen Display</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>Yes</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<hr />\r\n<div class=\"row\">\r\n<div class=\"col-md-3\">\r\n<h3>Connectivity</h3>\r\n</div>\r\n<div class=\"col-md-9\">\r\n<div class=\"row\">\r\n<div class=\"col-xs-12\">\r\n<table class=\"table margin-top-2\">\r\n<tbody>\r\n<tr><th scope=\"row\">Direct USB</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>Yes</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">Ethernet Network</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>Yes</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">Network Protocol Support</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>TCP/IP IPv6, TCP/IP IPv4, AppleTalk™, TCP, UDP</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">Network Printing Methods</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>LPR/LPD, Direct IP (Port 9100), Pull Printing, Microsoft Web Services WSD, Secure IP (Port 96xx), FTP, TFTP, Enhanced IP (Port 9400), ThinPrint .print integration, IPP 1.0, 1.1, 2.0 (Internet Printing Protocol)</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">Network Management Protocols</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>DHCP, APIPA (AutoIP), BOOTP, RARP, mDNS, IGMP, Bonjour, WINS, DDNS, SNMPv3, SNMPv1, SNMPv2c, Telnet, NTP, ICMP, HTTP, DNS, ARP, HTTPs (SSL<span>6</span> /TLS), Finger</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">Network Security</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>IPSec, SNMPv3, 802.1x Authentication: MD5, MSCHAPv2, LEAP, PEAP, TLS, TTLS</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">Optional Local Ports</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>Internal 1284-B Bidirectional Parallel, Internal RS-232C serial</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">Optional Network Ports</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>Internal MarkNet N8350 802.11b/g/n Wireless</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<hr />\r\n<div class=\"row\">\r\n<div class=\"col-md-3\">\r\n<h3>Supported Operating Systems</h3>\r\n</div>\r\n<div class=\"col-md-9\">\r\n<div class=\"row\">\r\n<div class=\"col-xs-12\">\r\n<table class=\"table margin-top-2\">\r\n<tbody>\r\n<tr><th scope=\"row\">Microsoft Windows Operating Systems Supported</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>Windows 10, Windows Server 2008 x64, Windows 8.1, Windows 8, Windows Server 2008, Windows Server 2008 R2, Windows 8 x64, Windows 7 x64, Windows Server 2012, Windows RT 8.1, Windows XP x64, Windows Server 2003 x64, Windows RT, Windows Server 2003, Windows Server 2012 R2, Windows XP, Windows 8.1 x64, Windows Vista x64, Windows Vista, Windows 7</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">Apple Operating Systems Supported</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>Apple OS X (10.5, 10.6, 10.7, 10.8, 10.9, 10.10)</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">Linux Operating Systems Supported</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>PCLinuxOS 2011, Ubuntu 11.04, 11.10, 12.04, 12.10, openSUSE 11.3, 11.4, 12.1, 12.2, Linpus Linux Desktop 9.6, Mint 9, 10, 11, 12, 13, Debian GNU/Linux 5.0, 6.0, Fedora 14, 15, 16, 17, Red Hat Enterprise Linux WS 4.0, 5.0, 6.0, SUSE Linux Enterprise Desktop 10, 11, Red Flag Linux Desktop 6.0, SUSE Linux Enterprise Server 10, 11</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">Citrix MetaFrame</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>Microsoft Windows Server 2003 and 2003 X64 Edition with Citrix XenApp 5.0, Microsoft Windows Server 2003 x64 running Terminal Services with Citrix Presentation Server 4.0 x64, 4.5 x64, Microsoft Windows Server 2003 running Terminal Services with Citrix Presentation Server 3.0, 4.0, 4.5, Microsoft Windows Server 2008 R2 with Citrix XenApp 6.0, 6.5, Microsoft Windows Server 2008 and 2008 X64 Edition with Citrix XenApp 5.0</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">Novell Operating Systems Supported</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>Novell Open Enterprise Server on SUSE Linux Enterprise Server, Novell NetWare 5.1(SP 6+), 6.0(SP 3+) with Novell Distributed Print Services (NDPS), Novell NetWare 6.5 Open Enterprise Server</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">UNIX Operating Systems Supported</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>Sun Solaris x86 10, 11, IBM AIX 5.3, 6.1, 7.1, Sun Solaris SPARC 9, 10, HP-UX 11.11, 11.23, 11.31</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<hr />\r\n<div class=\"row\">\r\n<div class=\"col-md-3\">\r\n<h3>Electrical &amp; Operation</h3>\r\n</div>\r\n<div class=\"col-md-9\">\r\n<div class=\"row\">\r\n<div class=\"col-xs-12\">\r\n<table class=\"table margin-top-2\">\r\n<tbody>\r\n<tr><th scope=\"row\">ENERGY STAR</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>Yes</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">ENERGY STAR Typical Electricity Consumption</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>TEC:</li>\r\n<li>2.7 kilowatt-hours per week</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">Noise Level</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>Operating:</li>\r\n<li>Inaudible dBA (Idle)</li>\r\n<li>55 dBA (Print)</li>\r\n<li>56 dBA (Copy)</li>\r\n<li>55 dBA (Scan)</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">Duplex Print Noise Level</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>Operating:</li>\r\n<li>54 dBA</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">Average Power</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>0.4 watts (Hibernate Mode)</li>\r\n<li>3.3 watts (Sleep Mode)</li>\r\n<li>16 watts (Ready Mode)</li>\r\n<li>640 watts (Printing)</li>\r\n<li>660 watts (Copying)</li>\r\n<li>35 watts (Scanning)</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">Specified Operating Environment</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>Humidity: 8 to 80% Relative Humidity</li>\r\n<li>Temperature: 16 to 32°C (60 to 90°F)</li>\r\n<li>Altitude: 0 - 2896 Meters (9,500 Feet)</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">Product Certifications</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>ENERGY STAR, Blue Angel RAL-UZ-171, ICES-003 Class B, BSMI Class B, VCCI Class B, US FDA, UL 60950-1, FCC Class B, cUL CAN/CSA-C22.2 60950-1, NOM, CB EN/IEC 60950-1, CB EN/IEC 60825-1, CE DoC (EN 62301 Class B, EN 62311, CE EN/IEC 60950-1, CE EN/IEC 60825-1, EN 61000-3, EN 55022 Class B, EuP, EN 55024, UL), EFTA (CE), KCC, CCC, CECP, CEL, C-tick DoC, UL-AR, KC mark, UL GS mark, EC 1275, MET-I, ISO 532B, ECMA-370, TED, GOST-R, SII, TER</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">ENERGY STAR</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>Yes</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">UNSPSC Code</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>43212110</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">Harmonized Tariff Code</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>8443.31.0000</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">Country of Origin</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>China (PRC)</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n<tr><th scope=\"row\">License/Agreement Terms</th>\r\n<td>\r\n<ul class=\"margin-bottom-none list-unstyled\">\r\n<li>Printers are sold subject to certain license/agreement conditions. See www.lexmark.com/printerlicense for details.</li>\r\n</ul>\r\n</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n</div>'),('279',76,0,'94','<ul class=\"margin-bottom-none padding-before-2\">\r\n<li>Monochrome Laser</li>\r\n<li>Duplex (2-sided) Printing: Integrated Duplex</li>\r\n<li>Print Speed: 50 ppm</li>\r\n<li>Recommended Monthly Page Volume: 2000 - 15000 pages</li>\r\n</ul>\r\n<div class=\"grid section\">\r\n<div class=\"container\">\r\n<div class=\"row  \">\r\n<div class=\"col-xs-12     \">\r\n<div class=\"tab section\">\r\n<div class=\"tab-content\">\r\n<div id=\"overview\" class=\"tab-pane product-detail-tab-section border-none active\">\r\n<div class=\"wells section\">\r\n<div class=\" well no-shadow border-b8 border-top border-bottom well-sm padding-before-4 padding-after-4 margin-top-1\">\r\n<div class=\"product-detail-marketing-desc\">\r\n<p class=\"lead padding-bottom-1\"><span style=\"font-size: small;\">The <strong>Lexmark MX611dhe MFP</strong> with print, copy, fax, email and scan functions prints up to 50 ppm. Included are 2-sided printing and 650 sheets of input.</span></p>\r\n</div>\r\n</div>\r\n</div>\r\n<div class=\"product-detail-addtl-marketing-desc section\">\r\n<div class=\"row\">\r\n<div class=\"col-md-3\">\r\n<h4 class=\"margin-top-none\">Get Work Done Quickly</h4>\r\n</div>\r\n<div class=\"col-md-9\">\r\n<p>Enjoy print speeds up to 50 pages per minute, plus print or copy your first page in as little as 6.5 seconds.</p>\r\n</div>\r\n</div>\r\n<hr />\r\n<div class=\"row\">\r\n<div class=\"col-md-3\">\r\n<h4 class=\"margin-top-none\">Faster Processing</h4>\r\n</div>\r\n<div class=\"col-md-9\">\r\n<p>Improve your print, scan and copy speeds by taking advantage of up to 3 GB of upgradable memory, an 800 MHz dual-core processor and Gigabit Ethernet.</p>\r\n</div>\r\n</div>\r\n<hr />\r\n<div class=\"row\">\r\n<div class=\"col-md-3\">\r\n<h4 class=\"margin-top-none\">Work Smarter Not Harder</h4>\r\n</div>\r\n<div class=\"col-md-9\">\r\n<p>If you can use a mobile phone application, you can use our pre-loaded solutions. Touch the screen and access shortcuts that let you scan, print or send faxes, emails and other business-critical documents fast.</p>\r\n</div>\r\n</div>\r\n<hr />\r\n<div class=\"row\">\r\n<div class=\"col-md-3\">\r\n<h4 class=\"margin-top-none\">Keep Jobs Moving</h4>\r\n</div>\r\n<div class=\"col-md-9\">\r\n<p>With a maximum input capacity of up to 2,300 sheets and an ultra high yield toner cartridge, you won’t have to add paper or change cartridges as often.</p>\r\n</div>\r\n</div>\r\n<hr />\r\n<div class=\"row\">\r\n<div class=\"col-md-3\">\r\n<h4 class=\"margin-top-none\">Smart and Easy to Use</h4>\r\n</div>\r\n<div class=\"col-md-9\">\r\n<p>A vibrant 7-inch color touch screen provides access to preinstalled productivity solutions and lets you operate the system through smart and intuitive navigation.</p>\r\n</div>\r\n</div>\r\n<hr class=\"hidden-sm hidden-xs\" />\r\n<div><br /><br /></div>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n<div></div>\r\n</div>\r\n<div class=\"product-detail-pre-footer section\">\r\n<div class=\"container\">\r\n<div class=\"row\">\r\n<div class=\"col-md-12\">\r\n<div class=\"product-detail-footnotes\">\r\n<p class=\"text-tiny margin-bottom-3\"><span>†</span> \"Maximum Monthly Duty Cycle\" is defined as the maximum number of pages a device could deliver in a month using a multishift operation. This metric provides a comparison of robustness in relation to other Lexmark printers and MFPs. <br /><br />All information is subject to change without notice. Lexmark is not liable for any errors or omissions.</p>\r\n</div>\r\n</div>\r\n</div>\r\n</div>\r\n</div>'),('280',85,0,'94','LEXMARK MX611dhe Monochrome Laser Printer'),('281',75,0,'95','<div class=\"product-description\"><strong>Specifications</strong></div>\r\n<div class=\"stp--grid stp--grid-no-gutters prod-spec-table\">\r\n<div>\r\n<table class=\"stp--cell prod-specifications stp--bg-gray-6\">\r\n<tbody>\r\n<tr>\r\n<td>Dot Matrix Connectivity</td>\r\n<td>USB/Parallel</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n<div>\r\n<table class=\"stp--cell prod-specifications stp--bg-gray-6\">\r\n<tbody>\r\n<tr>\r\n<td>Dot Matrix Pin Type</td>\r\n<td>24-pin</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n<div>\r\n<table class=\"stp--cell prod-specifications\">\r\n<tbody>\r\n<tr>\r\n<td>Weight (lbs.)</td>\r\n<td>15.6</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n<div>\r\n<table class=\"stp--cell prod-specifications\">\r\n<tbody>\r\n<tr>\r\n<td>Height in Inches</td>\r\n<td>6.3</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n<div>\r\n<table class=\"stp--cell prod-specifications stp--bg-gray-6\">\r\n<tbody>\r\n<tr>\r\n<td>Width in Inches</td>\r\n<td>16.3</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n<div>\r\n<table class=\"stp--cell prod-specifications stp--bg-gray-6\">\r\n<tbody>\r\n<tr>\r\n<td>Depth in Inches</td>\r\n<td>13.8</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n<div>\r\n<table class=\"stp--cell prod-specifications\">\r\n<tbody>\r\n<tr>\r\n<td>Technology</td>\r\n<td>24-Pin DotMatrix</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n<div>\r\n<table class=\"stp--cell prod-specifications\">\r\n<tbody>\r\n<tr>\r\n<td>High Speed Draft</td>\r\n<td>Up to 529 cps</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n<div>\r\n<table class=\"stp--cell prod-specifications stp--bg-gray-6\">\r\n<tbody>\r\n<tr>\r\n<td>Maximum Form Parts</td>\r\n<td>CD, 20x Max*</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n<div>\r\n<table class=\"stp--cell prod-specifications stp--bg-gray-6\">\r\n<tbody>\r\n<tr>\r\n<td>Connectivity</td>\r\n<td>USB, parallel, Type B</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n<div>\r\n<table class=\"stp--cell prod-specifications\">\r\n<tbody>\r\n<tr>\r\n<td>Warranty</td>\r\n<td>3 year mfr. limited</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n<div>\r\n<table class=\"stp--cell prod-specifications\">\r\n<tbody>\r\n<tr>\r\n<td>Printer Language</td>\r\n<td>Epson ESC/P2, IBM PPDS</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n<div>\r\n<table class=\"stp--cell prod-specifications stp--bg-gray-6\">\r\n<tbody>\r\n<tr>\r\n<td>True Color</td>\r\n<td>White and Gray</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n<div>\r\n<table class=\"stp--cell prod-specifications stp--bg-gray-6\">\r\n<tbody>\r\n<tr>\r\n<td>OS Compatibility</td>\r\n<td>Windows 95, 98, 2000, Me, XP and NT 4.0</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n<div>\r\n<table class=\"stp--cell prod-specifications\">\r\n<tbody>\r\n<tr>\r\n<td>Dot Matrix Features</td>\r\n<td>400 million characters printhead life</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n</div>'),('282',76,0,'95','<div><span class=\"prod-sub-header\"><strong>Epson LQ-590 Dot Matrix Printers</strong> offer high printing performance for text, images and photographs.</span></div>\r\n<div>\r\n<p class=\"prod-sub-header skuShortDescription\"><strong>Epson LQ-590 Dot Matrix printers</strong> deliver clear, clean prints efficiently. Suitable for home office or office printing, this ultra-fast printer with its long-lasting ribbon life is reliable for handling even large printing requirements. This Epson printer\'s sharp resolution is ideal for professional presentations and handouts, while its advanced paper handing capabilities make printing seamless. Easy to install and connect to, this powerful printer lets you stay ahead of schedule and streamline your office\'s document filing tasks.</p>\r\n</div>\r\n<div class=\"prod-sub-header skuShortDescription\">\r\n<ul class=\"stp--bulleted-list\">\r\n<li><span>Dot matrix printer is ideal for home or office use for documents, photos or text</span></li>\r\n<li><span>Dimensions: 6 5/16\" x 16 5/16\" x 13 13/16\"</span></li>\r\n<li><span>Black and white printer with ribbon-life of approximately five million characters handles heavy printing loads</span></li>\r\n<li><span>24-pin printer supports a micro-drive and memory stick for portability of documents</span></li>\r\n<li><span>Printer comes with USB and parallel interfaces for easy connectivity</span></li>\r\n<li><span>240 x 144 dpi resolution ensures sharp, clear print quality</span></li>\r\n<li><span>Up to 529 cps print speed ensures quick prints</span></li>\r\n<li><span>Built-in status monitor and drivers simplify supervision of printing jobs</span></li>\r\n<li><span>Printer supports multiple media types for complete business print requirements</span></li>\r\n</ul>\r\n</div>\r\n<div class=\"prod-sub-header skuShortDescription\"><strong>Economical and Fast Prints</strong><br />Reduce the need to constantly change cartridges and save money with the Epson LQ-590 Dot Matrix printer\'s long-lasting ribbon. Ultra-fast print speeds of up to 440 characters per second ensure that large print loads are handled seamlessly with advanced paper handling capabilities.<br /><br /><strong>Productive and Professional Prints</strong><br />Enjoy clear, professional prints with the Epson LQ-590 Dot Matrix printer. This 24-pin printer with its sharp resolution output supports multiple media types to form a complete office printing solution. Featuring parallel and USB interfaces, as well as memory sticks and micro-drives, this efficient printer enhances productivity.<br /><br /><strong>Compact and Durable</strong><br />Consume less space in your home office or office with this compact Epson LQ-590 Dot Matrix printer that is small enough to sit on a shelf. Size notwithstanding, this printer\'s durable print head keeps it running as smoothly as a larger machine irrespective of the print load.</div>'),('283',85,0,'95','Epson LQ-590 Dot-Matrix Printer'),('284',75,0,'96','<div id=\"Print\">\r\n<h3><span style=\"text-decoration: underline;\">Print</span></h3>\r\n<div class=\"specs-section\">\r\n<p><strong>Printing Method: </strong>9-pin, serial, impact dot matrix, narrow carriage</p>\r\n<p><strong>Print Direction: </strong>Text Mode: Bi-directional<br />Graphics Mode: Uni-directional (bi-directional via software)</p>\r\n<p><strong>Print Speed:</strong></p>\r\n<ul>\r\n<li>High Speed Draft: 347 cps (10 cpi), 357 cps (12 cpi), 390 cps (15 cpi)</li>\r\n<li>Draft: 260 cps (10 cpi), 312 cps (12 cpi), 223 (15 cpi)</li>\r\n<li>Near Letter Quality: 65 cps (10 cpi), 78 cps (12 cpi), 55 cps (15 cps)</li>\r\n</ul>\r\n</div>\r\n</div>\r\n<div id=\"Characters &amp; Lines\">\r\n<h3><strong>Character Sets:</strong></h3>\r\n<div class=\"specs-section\">\r\n<ul>\r\n<li>13 standard versions</li>\r\n<li>15 international character sets</li>\r\n<li>43 NLSP versions</li>\r\n</ul>\r\n<p><strong>Resident Bitmapped Fonts:</strong></p>\r\n<ul>\r\n<li>Epson Draft: 10, 12, 15 cpi proportional</li>\r\n<li>Epson Roman: 10, 12, 15 cpi proportional</li>\r\n<li>Epson San Serif: 10, 12, 15 cpi proportional</li>\r\n<li>Epson OCR-B: 10 cpi</li>\r\n</ul>\r\n<p><strong>Bar Code Fonts: </strong>EAN-13, EAN-8, Interleaved 2 of 5, UPC-A, UPC-E, Code 39, Code 128, POSTNET,</p>\r\n<div class=\"clear spacer\"> </div>\r\n</div>\r\n</div>\r\n<div id=\"Paper Handling\"><strong><span>Paper Handling</span></strong>\r\n<div class=\"specs-section\">\r\n<p><strong>Envelopes:</strong></p>\r\n<ul>\r\n<li>No. 6 envelopes: Maximum thickness: 0.0063 ~ 0.0205\"</li>\r\n<li>No. 10 envelopes: Maximum thickness: 0.0063 ~ 0.0205\"</li>\r\n</ul>\r\n<p><strong>Roll paper:</strong></p>\r\n<ul>\r\n<li>Width: 8.5\"</li>\r\n<li>Maximum thickness: 0.0028 ~ 0.0035\"</li>\r\n</ul>\r\n<p><strong>Paper Path:</strong></p>\r\n<ul>\r\n<li>Manual insertion: Rear in, Top out</li>\r\n<li>Tractor: Rear in, Top out</li>\r\n</ul>\r\n</div>\r\n</div>\r\n<div id=\"General\"><span style=\"text-decoration: underline;\"><strong>General</strong></span>\r\n<div class=\"specs-section\">\r\n<p><strong>Software Drivers: </strong>Operating System: Microsoft® Windows® 2000/ XP/ Win 7-8/ Vista</p>\r\n<p><strong>Interface: </strong>Bi-directional parallel (IEEE-1284) USB high speed (ver 2.0), Serial</p>\r\n<p><strong>Input Buffer : </strong>128 KB</p>\r\n<p><strong>Sound Level : </strong>Approx. 53 dBA</p>\r\n<p><strong>Rated voltage : </strong>120V</p>\r\n<p><strong>Rated frequency range : </strong>50 – 60 Hz</p>\r\n<p><strong>Dimensions : </strong>14.25\" x 10.83\" x 6.06\" (W x D x H)</p>\r\n<p><strong>Weight : </strong>9.04 lb</p>\r\n<div class=\"clear spacer\"><br /><span style=\"text-decoration: underline;\"><strong>Reliability</strong></span></div>\r\n</div>\r\n</div>\r\n<div id=\"Reliability\">\r\n<div class=\"specs-section\">\r\n<p><strong><br />MTBF: </strong>10,000 POH (25% duty cycle)</p>\r\n<p><strong>Print head life: </strong>400 million strokes per wire</p>\r\n<p><strong>Ribbon life: </strong>4 million characters</p>\r\n</div>\r\n</div>'),('285',76,0,'96','<p><span>The highly reliable <strong>Epson LX-350</strong> has a mean time between failures of 10,000 operating hours, and is ideal for front and back office applications needing continuous paper or multi-part stationery.A very economical printer to run, the LX-350 helps save money with its high ribbon yield of 4 million characters and its low power consumption. Using just 1.1 W in sleep mode and 27 W when powered on, the LX-350 is qualified by ENERGY STAR for its excellent energy efficiency.Easy to integrate, the LX-350 has parallel, serial and USB interfaces as standard, and will fit neatly onto desks thanks to its compact design and cable management system.</span></p>\r\n<ul>\r\n<li><strong>High reliability</strong>: MTBF of 10,000 operating hours</li>\r\n</ul>\r\n<ul>\r\n<li><strong>Power-efficient</strong>: Energy efficient model for less power consumption</li>\r\n</ul>\r\n<ul>\r\n<li><strong>Economical</strong>: New Ribbon yield of 4 Million characters</li>\r\n</ul>\r\n<ul>\r\n<li><strong>Easy integration</strong>: Parallel, Serial and USB interfaces</li>\r\n</ul>\r\n<ul>\r\n<li><strong>Compact design</strong>: Fits neatly onto desks</li>\r\n</ul>\r\n<p>Epson, world leader of Impact Printers, introduces a new printer with the same technology, reliability and quality of its predecessors, but with a more compact presentation and robustness.</p>\r\n<p>The new LX-350 has fast and durable EPSON 9-Pin technology, prints up to 347 characters per second and is ideal for front and back office applications needing continuous paper or multi-part stationery. Now more reliable than ever, the LX-350 has a mean time between failure of 10,000 operating hours.</p>\r\n<p>A very economical printer to run, the LX-350 helps save money with its NEW high ribbon yield of 4 million characters (Ribbon compatible with LX-300+II and LX300+) and its low power consumption. The LX-350 is qualified by ENERGY STAR for its excellent energy efficiency.</p>\r\n<p>Easy to integrate, the LX-350 has Parallel, Serial and USB interfaces as standard, and will fit neatly onto desks thanks to its compact design and cable management system.</p>'),('286',85,0,'96','Epson LX-350 Dot-Matrix Printer');
INSERT INTO `catalog_product_entity_text` VALUES ('287',75,0,'97','<fieldset>\r\n<h3 class=\"specTitle\">Compatible Cartridges</h3>\r\n<dl><dt>Cartridges Compatible</dt><dd>HP 26A Black LaserJet Toner Cartridge (~3100 pages), CF226A<br />HP 26X Black LaserJet Toner Cartridge (~9000 pages), CF226X</dd></dl></fieldset><fieldset>\r\n<h3 class=\"specTitle\">Model</h3>\r\n<dl><dt>Brand</dt><dd>HP</dd></dl><dl><dt>Series</dt><dd>LaserJet Pro</dd></dl><dl><dt>Model</dt><dd>M402n</dd></dl><dl><dt>Part Number</dt><dd>C5F93A</dd></dl><dl><dt>Functions</dt><dd>Print</dd></dl><dl><dt>Display</dt><dd>2-line backlit LCD graphic display</dd></dl></fieldset><fieldset>\r\n<h3 class=\"specTitle\">Print</h3>\r\n<dl><dt>Output Type</dt><dd>Monochrome</dd></dl><dl><dt><a id=\"def_colorPopup__6144\" class=\"specs-popup\" name=\"def-color\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>Laser Technology</dt><dd>Laser</dd></dl><dl><dt>Black Print Speed</dt><dd>Up to 40 ppm</dd></dl><dl><dt><a id=\"def_colorPopup__6147\" class=\"specs-popup\" name=\"def-color\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>Black Print Quality</dt><dd>600 x 600 dpi, Up to 4800 x 600 enhanced dpi</dd></dl><dl><dt>Time To First Page (seconds)</dt><dd>As fast as 5.6 sec<br />As fast as 8.1 sec (100 V)</dd></dl><dl><dt><a id=\"def_colorPopup__6150\" class=\"specs-popup\" name=\"def-color\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>Print Languages, std.</dt><dd>HP PCL 5, HP PCL 6, HP postscript level 3 emulation, direct PDF (v 1.7) printing, URF, PCLM, PWG</dd></dl><dl><dt><a id=\"def_colorPopup__6152\" class=\"specs-popup\" name=\"def-color\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>Duplex printing</dt><dd>Manual</dd></dl><dl><dt><a id=\"def_colorPopup__6153\" class=\"specs-popup\" name=\"def-color\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>Max. Duty Cycle</dt><dd>Monthly duty cycle: Up to 80,000 pages<br />Recommended monthly page volume: 750 to 4000 pages</dd></dl></fieldset><fieldset>\r\n<h3 class=\"specTitle\">Media Handling</h3>\r\n<dl><dt><a id=\"def_colorPopup__6173\" class=\"specs-popup\" name=\"def-color\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>Input Capacity, std.</dt><dd>100-sheet multipurpose Tray 1<br />250-sheet input Tray 2</dd></dl><dl><dt><a id=\"def_colorPopup__6175\" class=\"specs-popup\" name=\"def-color\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>Output Capacity, std.</dt><dd>150-sheet output bin</dd></dl><dl><dt>Media Type</dt><dd>Paper (plain, EcoFFICIENT, light, heavy, bond, colored, letterhead, preprinted, prepunched, recycled, rough); envelopes; labels; transparencies</dd></dl><dl><dt>Media sizes supported</dt><dd>Tray 1: Letter, Legal, Executive, Envelope #10, Envelope Monarch, Custom size 4.00\" x 6.00\", 5.00\" x 8.00\", 10.00\" x 15.00\" statement<br />Tray 2 &amp; Tray 3: Letter, Legal, Executive, Custom Size, 5.00\" x 8.00\", statement</dd></dl></fieldset><fieldset>\r\n<h3 class=\"specTitle\">Ports</h3>\r\n<dl><dt>USB Ports</dt><dd>1 x Hi-Speed USB 2.0<br />1 x Host USB</dd></dl><dl><dt><a id=\"def_colorPopup__6183\" class=\"specs-popup\" name=\"def-color\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>Network Ports</dt><dd>1 x Gigabit Ethernet 10/100/1000T network</dd></dl><dl><dt>Connectivity Technology</dt><dd>Ethernet</dd></dl></fieldset><fieldset>\r\n<h3 class=\"specTitle\">Hardware</h3>\r\n<dl><dt>Noise Level (Approx.)</dt><dd>Acoustic pressure emissions bystander (active, printing): 54 dB(A)</dd></dl><dl><dt>Processor(MHz)</dt><dd>1200</dd></dl><dl><dt><a id=\"def_colorPopup__6189\" class=\"specs-popup\" name=\"def-color\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>Memory, std.</dt><dd>128 MB DRAM</dd></dl><dl><dt>Memory, max.</dt><dd>128 MB DRAM</dd></dl><dl><dt>Power Requirements</dt><dd>110-volt input voltage: 110 to 127 VAC (+/- 10%), 50/60Hz (+/- 2Hz)<br />220-volt input voltage: 220 to 240 VAC (+/- 10%), 50/60Hz (+/- 2Hz)</dd></dl><dl><dt>Power Consumption</dt><dd>591 Watts (Active Printing)<br />6.1 Watts (Ready)<br />2.8 Watts (Sleep)<br />0.6 Watt (Auto-On / Auto-Off, via USB connectivity)<br />0.1 Watt (Shutdown or Off)</dd></dl></fieldset><fieldset>\r\n<h3 class=\"specTitle\">Compatibility</h3>\r\n<dl><dt>Windows Compatible</dt><dd>Windows OS compatible with In-Box Driver: <br />Windows XP SP3 all 32-bit editions (XP Home, XP Pro, etc)<br />Windows Vista all 32-bit editions (Home Basic, Premium, Professional, etc.)<br />Windows 7 all 32 &amp; 64-bit editions<br />Windows 8 / 8.1 all 32 &amp; 64-bit editions (excluding RT OS for Tablets)<br />Windows 10 all 32 &amp; 64-bit editions (excluding RT OS for Tablets)<br /><br />Windows OS compatible with Universal Print Driver:<br />Windows XP SP3 32 &amp; 64-bit editions (XP Home, XP Pro, etc.)<br />Windows Vista all 32 &amp; 64-bit editions (Home Basic, Premium, Professional, etc)<br />Windows 7 all 32 &amp; 64-bit editions<br />Windows 8 / 8.1 all 32 &amp; 64-bit editions (excluding RT OS for Tablets)<br />Windows 10 all 32 &amp; 64-bit editions (excluding RT OS for Tablets)</dd></dl><dl><dt>Macintosh Compatible</dt><dd>OS X 10.8 Mountain Lion<br />OS X 10.9 Mavericks<br />OS X 10.10 Yosemite</dd></dl><dl><dt>Other</dt><dd>Mobile OS (In-OS drivers): iOS, Android, Windows 8 / 8.1 / 10 RT<br />Linux OS (In-OS HPLIP)<br /><br />Auto install:<br />BOSS (3.0, 5.0)<br />DEBIAN (6.0, 6.0.1, 6.0.2, 6.0.3, 6.0.4, 6.0.5, 6.0.6, 6.0.7, 6.0.8, 6.0.9, 6.0.10, 7.0, 7.1, 7.2, 7.3, 7.4, 7.5, 7.6)<br />FEDORA (17, 18, 19, 20)<br />LINUX MINT (13, 14, 15, 16, 17)<br />SUSE LINUX (12.2, 12.3, 13.1)<br />UBUNTU (10.04, 11.10, 12.04, 12.10, 13.04, 13.10, 14.04, 14.10)<br /><br />Manual install:<br />MANDRIVA LINUX (2010.0, 2011.0)<br />MEPIS (6.0, 6.5, 7.0, 8.0)<br />PCLINUXOS (2006.0, 2006, 2007.0, 2007, 2008.0, 2008, 2009.0, 2009)<br />RED HAT (8.0, 9.0)<br />RED HAT ENTERPRISE LINUX (5.0, 6.0, 7.0)<br />SLACKWARE LINUX (9.0, 9.1, 10.0, 10.1, 10.2, 11, 12, 12.1)<br />GOS (8.04.1)<br />IGOS (1.0)<br />LINPUS LINUX (9.4, 9.5)<br />LINUX FROM SCRATCH<br /><br />Other OS: UNIX</dd></dl></fieldset>'),('288',76,0,'97','<ul>\r\n<ul>\r\n<li class=\"item\">Up to 40 ppm</li>\r\n</ul>\r\n</ul>\r\n<ul>\r\n<ul>\r\n<li class=\"item\">Up to 4800 x 600 enhance dpi</li>\r\n</ul>\r\n</ul>\r\n<ul>\r\n<ul>\r\n<li class=\"item\">USB, Ethernet</li>\r\n</ul>\r\n</ul>\r\n<ul>\r\n<ul>\r\n<li class=\"item\">Uses 26A, 26X toner cartridges</li>\r\n</ul>\r\n</ul>\r\n<p><span style=\"text-decoration: underline;\"><strong>Features</strong></span><br /><strong></strong></p>\r\n<p><strong>Fast printing. Strong protection.</strong><br /><span>Grab pages and go - without waiting around. This printer wakes up and prints faster than the competition.</span><br /><span>Keep printing safe from boot up to shutdown with security features that guard against complex threats.</span><br /><br /><strong>More. Pages, Performance, and Protection.</strong><br /><span>Get the most prints for your money - with Original HP High Yield Black Toner cartridges with JetIntelligence.</span><br /><span>Count on consistent results at high speeds with precision black toner.</span><br /><span>Help ensure you\'re getting the authentic HP quality you paid for with innovative anti-fraud technology.</span><br /><span>Print right away with preinstalled toner cartridges. Replace them with optional high-yield cartridges.</span><br /><br /><strong>Save energy and easily manage tasks</strong><br /><span>Help save energy with HP Auto-On / Auto-Off Technology.</span><br /><span>Print using less energy than competitors-enhanced by Original HP Toner cartridges with JetIntelligence.</span><br /><span>Make the most of your office space, with a printer that conveniently fits right into your work style.</span><br /><span>Easily manage devices and settings using HP Web Jetadmin with a suite of essential management features.</span><br /><br /><strong>Stay connected with easy mobile printing options</strong><br /><span>Easily print from a variety of smartphones and tablets - generally no setup or apps required.</span><br /><span>Easily set up, print, and share with built-in Ethernet networking.</span></p>'),('289',85,0,'97','HP LaserJet Pro M402n Monochrome ePrinter'),('290',75,0,'98','<fieldset>\r\n<h3 class=\"specTitle\">Compatible Cartridges</h3>\r\n<dl><dt>Cartridges Compatible</dt><dd>HP 26A Black LaserJet Toner Cartridge (up to 3100 pages), CF226A<br />HP 26X Black LaserJet Toner Cartridge (up to 9000 pages), CF226X<br />HP 26XC Black LaserJet Toner Cartridge, CF226XC</dd></dl></fieldset><fieldset>\r\n<h3 class=\"specTitle\">Model</h3>\r\n<dl><dt>Brand</dt><dd>HP</dd></dl><dl><dt>Series</dt><dd>LaserJet Pro</dd></dl><dl><dt>Model</dt><dd>M402dne</dd></dl><dl><dt>Part Number</dt><dd>C5J91A#BGJ</dd></dl><dl><dt>Functions</dt><dd>Print</dd></dl><dl><dt>Display</dt><dd>2-line backlit LCD graphic display</dd></dl></fieldset><fieldset>\r\n<h3 class=\"specTitle\">Print</h3>\r\n<dl><dt>Output Type</dt><dd>Monochrome</dd></dl><dl><dt><a id=\"def_colorPopup__6144\" class=\"specs-popup\" name=\"def-color\" data-t-events=\"A\" data-t-e-var78=\"Specification Popup:Laser Technology\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>Laser Technology</dt><dd>Laser</dd></dl><dl><dt>Black Print Speed</dt><dd>Up to 40 ppm (normal, letter)<br />Up to 32 ipm (duplex, letter)</dd></dl><dl><dt>Time To First Page (seconds)</dt><dd>As fast as 5.6 seconds</dd></dl><dl><dt><a id=\"def_colorPopup__6150\" class=\"specs-popup\" name=\"def-color\" data-t-events=\"A\" data-t-e-var78=\"Specification Popup:Print Languages, std.\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>Print Languages, std.</dt><dd>HP PCL 5, HP PCL 6, HP postscript level 3 emulation, direct PDF (v 1.7) printing, URF, PCLM, PWG</dd></dl><dl><dt><a id=\"def_colorPopup__6152\" class=\"specs-popup\" name=\"def-color\" data-t-events=\"A\" data-t-e-var78=\"Specification Popup:Duplex printing\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>Duplex printing</dt><dd>Automatic</dd></dl><dl><dt><a id=\"def_colorPopup__6153\" class=\"specs-popup\" name=\"def-color\" data-t-events=\"A\" data-t-e-var78=\"Specification Popup:Max. Duty Cycle\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>Max. Duty Cycle</dt><dd>Duty cycle (monthly, letter): Up to 80,000 pages<br />Recommended monthly page volume: 750 to 4,000 pages</dd></dl></fieldset><fieldset>\r\n<h3 class=\"specTitle\">Media Handling</h3>\r\n<dl><dt>Paper Trays, std.</dt><dd>2</dd></dl><dl><dt>Paper Trays, max.</dt><dd>3</dd></dl><dl><dt><a id=\"def_colorPopup__6173\" class=\"specs-popup\" name=\"def-color\" data-t-events=\"A\" data-t-e-var78=\"Specification Popup:Input Capacity, std.\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>Input Capacity, std.</dt><dd>100-sheet multipurpose Tray 1, 250-sheet input Tray 2</dd></dl><dl><dt>Input Capacity, max.</dt><dd>Up to 900 sheets</dd></dl><dl><dt><a id=\"def_colorPopup__6175\" class=\"specs-popup\" name=\"def-color\" data-t-events=\"A\" data-t-e-var78=\"Specification Popup:Output Capacity, std.\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>Output Capacity, std.</dt><dd>150-sheet output bin</dd></dl><dl><dt>Output Capacity, max.</dt><dd>Up to 150 sheets</dd></dl><dl><dt>Media Type</dt><dd>Paper (plain, EcoFFICIENT, light, heavy, bond, colored, letterhead, preprinted, prepunched, recycled, rough); envelopes; labels; transparencies</dd></dl><dl><dt>Media sizes supported</dt><dd>Tray 1: Letter, Legal, Executive, Envelope #10, Envelope Monarch, Custom size 4.00\" x 6.00\", 5.00\" x 8.00\", 10.00\" x 15.00\" in statement<br />Tray 2 &amp; Tray 3: Letter, Legal, Executive, Custom Size, 5.00\" x 8.00\", statement</dd></dl></fieldset><fieldset>\r\n<h3 class=\"specTitle\">Ports</h3>\r\n<dl><dt>USB Ports</dt><dd>1 x Hi-Speed USB 2.0<br />1 x Host USB</dd></dl><dl><dt><a id=\"def_colorPopup__6183\" class=\"specs-popup\" name=\"def-color\" data-t-events=\"A\" data-t-e-var78=\"Specification Popup:Network Ports\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>Network Ports</dt><dd>1 x Gigabit Ethernet 10/100/1000T network</dd></dl></fieldset><fieldset>\r\n<h3 class=\"specTitle\">Hardware</h3>\r\n<dl><dt>Processor(MHz)</dt><dd>1200 MHz</dd></dl><dl><dt><a id=\"def_colorPopup__6189\" class=\"specs-popup\" name=\"def-color\" data-t-events=\"A\" data-t-e-var78=\"Specification Popup:Memory, std.\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>Memory, std.</dt><dd>256 MB</dd></dl><dl><dt>Memory, max.</dt><dd>256 MB</dd></dl><dl><dt>Power Requirements</dt><dd>110-volt input voltage: 110 to 127 VAC (+/- 10%), 50/60 Hz (+/- 2 Hz)<br />220-volt input voltage: 220 to 240 VAC (+/- 10%), 50/60 Hz (+/- 2 Hz)</dd></dl><dl><dt>Power Consumption</dt><dd>591 watts (Active Printing), 6.1 watts (Ready), 2.8 watts (Sleep), 0.6 watt (Auto-On/Auto-Off, via USB connectivity), 0.1 watt (Shutdown or Off)</dd></dl></fieldset><fieldset>\r\n<h3 class=\"specTitle\">Compatibility</h3>\r\n<dl><dt>Windows Compatible</dt><dd>Windows OS compatible with In-Box Driver: <br />Windows XP SP3 all 32-bit editions (XP Home, XP Pro, etc)<br />Windows Vista all 32-bit editions (Home Basic, Premium, Professional, etc.)<br />Windows 7 all 32 &amp; 64-bit editions<br />Windows 8/8.1 all 32 &amp; 64-bit editions (excluding RT OS for Tablets)<br />Windows 10 all 32 &amp; 64-bit editions (excluding RT OS for Tablets)<br /><br />Windows OS compatible with Universal Print Driver (From HP.com):<br />Windows XP SP3 32 &amp; 64-bit editions (XP Home, XP Pro, etc.)<br />Windows Vista all 32 &amp; 64-bit editions (Home Basic, Premium, Professional, etc)<br />Windows 7 all 32 &amp; 64-bit editions<br />Windows 8/8.1 all 32 &amp; 64-bit editions (excluding RT OS for Tablets)<br />Windows 10 all 32 &amp; 64-bit editions (excluding RT OS for Tablets)</dd></dl><dl><dt>Macintosh Compatible</dt><dd>OS X 10.8 Mountain Lion<br />OS X 10.9 Mavericks<br />OS X 10.10 Yosemite</dd></dl><dl><dt>Other</dt><dd>Mobile OS (In-OS drivers): iOS, Android, Windows 8/8.1/10 RT<br /><br />Linux OS (In-OS HPLIP)<br />Auto install: BOSS (3.0, 5.0)<br />DEBIAN (6.0, 6.0.1, 6.0.2, 6.0.3, 6.0.4, 6.0.5, 6.0.6, 6.0.7, 6.0.8, 6.0.9, 6.0.10, 7.0, 7.1, 7.2,<br />7.3, 7.4, 7.5, 7.6)<br />FEDORA (17, 18, 19, 20)<br />LINUX MINT (13, 14, 15, 16, 17)<br />SUSE LINUX (12.2, 12.3, 13.1)<br />UBUNTU (10.04, 11.10, 12.04,12.10, 13.04, 13.10, 14.04, 14.10)</dd></dl></fieldset><fieldset>\r\n<h3 class=\"specTitle\">Dimensions &amp; Weight</h3>\r\n<dl><dt>Dimensions</dt><dd>8.50\" x 15.00\" x 14.06\" (Minimum)<br />9.50\" x 15.00\" x 25.00\" (Maximum)</dd></dl><dl><dt>Weight</dt><dd>18.92 lbs.</dd></dl></fieldset>'),('291',76,0,'98','<ul>\r\n<li class=\"item\">Up to 40 ppm</li>\r\n<li class=\"item\">Up to 1200 x 1200 dpi</li>\r\n<li class=\"item\">USB, Ethernet (search m402dw for Wireless option)</li>\r\n<li class=\"item\">Automatic Duplex printing</li>\r\n<li class=\"item\">Uses HP Original Toner Cartridges 26A (CF226A), 26X (CF226X), 26XD (CF226XD)</li>\r\n</ul>\r\n<div class=\"ccs-cc-inline-features-block ccs-cc-inline-single-feature\">\r\n<div class=\"ccs-cc-inline-feature\" data-type=\"text\">\r\n<div class=\"ccs-cc-inline-feature-content ccs-cc-inline-feature-description\">Printing performance and robust security built for how you work. This capable printer finishes jobs faster and delivers comprehensive security to guard against threats. Original HP Toner cartridges with JetIntelligence give you more pages.</div>\r\n</div>\r\n</div>\r\n<div class=\"ccs-cc-inline-features-block ccs-cc-inline-multicolumn\" data-count=\"2\" data-media=\"false\">\r\n<div class=\"ccs-cc-inline-feature\">\r\n<div class=\"ccs-cc-inline-feature-content ccs-cc-inline-feature-description\" data-order=\"0\">\r\n<h3>Fast printing. Strong protection.</h3>\r\nShift your office into high gear with a powerful printer that doesn’t keep you waiting. Print your first page and two-sided prints faster than the competition, and help keep your device, data, and documents safe—from boot up to shutdown.</div>\r\n<div class=\"ccs-cc-inline-feature-content ccs-cc-inline-feature-description\" data-order=\"1\">\r\n<h3>More. Pages, Performance, and Protection.</h3>\r\nPrint more consistent, high-quality pages than ever before. Specially designed Original HP Toner cartridges with JetIntelligence deliver better performance, higher energy efficiency, and authentic HP quality—which the competition can’t match.</div>\r\n</div>\r\n</div>\r\n<div class=\"ccs-cc-inline-features-block ccs-cc-inline-multicolumn\" data-count=\"2\" data-media=\"false\">\r\n<div class=\"ccs-cc-inline-feature\">\r\n<div class=\"ccs-cc-inline-feature-content ccs-cc-inline-feature-description\" data-order=\"0\">\r\n<h3>Help save energy and easily manage tasks</h3>\r\nTake control of printing—and help save energy. Use a suite of essential features to help you easily manage this power-conserving printer. It’s built to fit right into your office space and work style.</div>\r\n<div class=\"ccs-cc-inline-feature-content ccs-cc-inline-feature-description\" data-order=\"1\">\r\n<h3>Stay connected with easy mobile printing options</h3>\r\nKeep your business nimble when needs shift or opportunity strikes—in the office or on the go.<sup><a id=\"ccs-f3inline-161ff3\" href=\"https://www.newegg.com/Product/Product.aspx?Item=1EE-0005-00DY5#ccs-ft3inline-161ff3\">3</a></sup> Ethernet capabilities help you stay connected and work with ease—from right where you are.</div>\r\n</div>\r\n</div>\r\n<h2>Key Features</h2>\r\n<div class=\"ccs-cc-inline-features-block ccs-cc-inline-multicolumn\" data-count=\"2\" data-media=\"true\">\r\n<div class=\"ccs-cc-inline-feature\">\r\n<div class=\"ccs-cc-inline-feature-content ccs-cc-inline-thumbnail\" data-order=\"0\"><img src=\"https://cc.cnetcontent.com/vcs/hp/inline-content/8A/A/F/C/5/A/AFC5ABF73BAE26AC6164AD30AC6ED237170C233B_i_75_featurtn.jpg\" alt=\"Fast wake-up and print\" data-large=\"https://cc.cnetcontent.com/vcs/hp/inline-content/8A/A/F/C/5/A/AFC5ABF73BAE26AC6164AD30AC6ED237170C233B_i_75_featurtn.jpg\" /></div>\r\n<div class=\"ccs-cc-inline-feature-content ccs-cc-inline-thumbnail\" data-order=\"1\"><img src=\"https://cc.cnetcontent.com/vcs/hp/inline-content/8A/D/4/5/6/7/D456796FBAA8B422A1E6EFAF6D0744FA0439DF1C_i_75_featurtn.jpg\" alt=\"Fast two-sided printing\" data-large=\"https://cc.cnetcontent.com/vcs/hp/inline-content/8A/D/4/5/6/7/D456796FBAA8B422A1E6EFAF6D0744FA0439DF1C_i_75_featurtn.jpg\" /></div>\r\n<div class=\"ccs-cc-inline-feature-content ccs-cc-inline-feature-description\" data-order=\"0\">\r\n<h3>Fast wake-up and print</h3>\r\nPrint the first page from sleep mode as fast as 8.0 seconds</div>\r\n<div class=\"ccs-cc-inline-feature-content ccs-cc-inline-feature-description\" data-order=\"1\">\r\n<h3>Fast two-sided printing</h3>\r\nPrint two-sided documents as fast as 32 ipm (images per minute)</div>\r\n</div>\r\n</div>\r\n<div class=\"ccs-cc-inline-features-block ccs-cc-inline-multicolumn\" data-count=\"2\" data-media=\"true\">\r\n<div class=\"ccs-cc-inline-feature\">\r\n<div class=\"ccs-cc-inline-feature-content ccs-cc-inline-thumbnail\" data-order=\"0\"><img src=\"https://cc.cnetcontent.com/vcs/hp/inline-content/8A/C/7/5/6/F/C756FE048C18C52B3F4F43F8DFC7BB65F6A7FFA1_i_75_featurtn.jpg\" alt=\"Optional high-yield cartridge\" data-large=\"https://cc.cnetcontent.com/vcs/hp/inline-content/8A/C/7/5/6/F/C756FE048C18C52B3F4F43F8DFC7BB65F6A7FFA1_i_75_featurtn.jpg\" /></div>\r\n<div class=\"ccs-cc-inline-feature-content ccs-cc-inline-thumbnail\" data-order=\"1\"><img src=\"https://cc.cnetcontent.com/vcs/hp/inline-content/_STD/px/px.gif\" alt=\"Compact size\" data-large=\"https://cc.cnetcontent.com/vcs/hp/inline-content/_STD/px/px.gif\" /></div>\r\n<div class=\"ccs-cc-inline-feature-content ccs-cc-inline-feature-description\" data-order=\"0\">\r\n<h3>Optional high-yield cartridge</h3>\r\nOptional 9K high-yield Original HP Toner cartridge with JetIntelligence</div>\r\n<div class=\"ccs-cc-inline-feature-content ccs-cc-inline-feature-description\" data-order=\"1\">\r\n<h3>Compact size</h3>\r\nCompact design lets this printer fit into small spaces</div>\r\n</div>\r\n</div>\r\n<div class=\"ccs-cc-inline-features-block ccs-cc-inline-multicolumn\" data-count=\"2\" data-media=\"true\">\r\n<div class=\"ccs-cc-inline-feature\">\r\n<div class=\"ccs-cc-inline-feature-content ccs-cc-inline-thumbnail\" data-order=\"0\"><img src=\"https://cc.cnetcontent.com/vcs/hp/inline-content/8A/0/B/0/D/3/0B0D32BBD9B50847A6CFA757BDC5921028D71AC6_i_75_featurtn.jpg\" alt=\"Optional job storage\" data-large=\"https://cc.cnetcontent.com/vcs/hp/inline-content/8A/0/B/0/D/3/0B0D32BBD9B50847A6CFA757BDC5921028D71AC6_i_75_featurtn.jpg\" /></div>\r\n<div class=\"ccs-cc-inline-feature-content ccs-cc-inline-thumbnail\" data-order=\"1\"><img src=\"https://cc.cnetcontent.com/vcs/hp/inline-content/8A/7/8/F/4/B/78F4B9F27C184680234DF593538A228FAECA8ED6_i_75_featurtn.jpg\" alt=\"Low energy use\" data-large=\"https://cc.cnetcontent.com/vcs/hp/inline-content/8A/7/8/F/4/B/78F4B9F27C184680234DF593538A228FAECA8ED6_i_75_featurtn.jpg\" /></div>\r\n<div class=\"ccs-cc-inline-feature-content ccs-cc-inline-feature-description\" data-order=\"0\">\r\n<h3>Optional job storage</h3>\r\nAdd a USB drive for built-in job storage and retrieval</div>\r\n<div class=\"ccs-cc-inline-feature-content ccs-cc-inline-feature-description\" data-order=\"1\">\r\n<h3>Low energy use</h3>\r\nThis printer is optimized for low energy consumption</div>\r\n</div>\r\n</div>\r\n<div class=\"ccs-cc-inline-features-block ccs-cc-inline-multicolumn\" data-count=\"2\" data-media=\"true\">\r\n<div class=\"ccs-cc-inline-feature\">\r\n<div class=\"ccs-cc-inline-feature-content ccs-cc-inline-thumbnail\" data-order=\"0\"><img src=\"https://cc.cnetcontent.com/vcs/hp/inline-content/8A/0/2/6/7/7/0267703C34BBBA7124B008627784B4C010A26353_i_75_featurtn.jpg\" alt=\"Print from mobile devices\" data-large=\"https://cc.cnetcontent.com/vcs/hp/inline-content/8A/0/2/6/7/7/0267703C34BBBA7124B008627784B4C010A26353_i_75_featurtn.jpg\" /></div>\r\n<div class=\"ccs-cc-inline-feature-content ccs-cc-inline-thumbnail\" data-order=\"1\"><img src=\"https://cc.cnetcontent.com/vcs/hp/inline-content/8A/1/5/1/6/8/151684EC1AFCD1DE1C2A7E25A53948ACA52529AE_i_75_featurtn.jpg\" alt=\"Load up to 900 sheets of paper\" data-large=\"https://cc.cnetcontent.com/vcs/hp/inline-content/8A/1/5/1/6/8/151684EC1AFCD1DE1C2A7E25A53948ACA52529AE_i_75_featurtn.jpg\" /></div>\r\n<div class=\"ccs-cc-inline-feature-content ccs-cc-inline-feature-description\" data-order=\"0\">\r\n<h3>Print from mobile devices</h3>\r\nPrint from a variety of smartphones, tablets and laptops</div>\r\n<div class=\"ccs-cc-inline-feature-content ccs-cc-inline-feature-description\" data-order=\"1\">\r\n<h3>Load up to 900 sheets of paper</h3>\r\nReload paper less often—up to 900-sheet paper capacity</div>\r\n</div>\r\n</div>\r\n<div class=\"ccs-cc-inline-features-block ccs-cc-inline-multicolumn\" data-count=\"2\" data-media=\"true\">\r\n<div class=\"ccs-cc-inline-feature\">\r\n<div class=\"ccs-cc-inline-feature-content ccs-cc-inline-thumbnail\" data-order=\"0\"><img src=\"https://cc.cnetcontent.com/vcs/hp/inline-content/8A/5/5/3/6/7/55367D862D446552A2520B4D8EADEB719A6A7BEE_i_75_featurtn.jpg\" alt=\"Only the power you need\" data-large=\"https://cc.cnetcontent.com/vcs/hp/inline-content/8A/5/5/3/6/7/55367D862D446552A2520B4D8EADEB719A6A7BEE_i_75_featurtn.jpg\" /></div>\r\n<div class=\"ccs-cc-inline-feature-content ccs-cc-inline-feature-description\" data-order=\"0\">\r\n<h3>Only the power you need</h3>\r\nHelp save energy with HP Auto-On/Auto-Off Technology.</div>\r\n</div>\r\n</div>\r\n<div class=\"ccs-cc-inline-features-block ccs-cc-inline-single-feature\">\r\n<div class=\"ccs-cc-inline-feature\" data-type=\"text\">\r\n<div class=\"ccs-cc-inline-feature-content ccs-cc-inline-feature-description\">\r\n<h3>Original HP Cartridges</h3>\r\n<ul>\r\n<li>HP 26A Black LaserJet Toner Cartridge (~3100 pages), CF226A</li>\r\n<li>HP 26X Black LaserJet Toner Cartridge (~9000 pages), CF226X</li>\r\n<li>HP 26XC Black LaserJet Toner Cartridge, CF226XC</li>\r\n</ul>\r\n</div>\r\n</div>\r\n</div>'),('292',85,0,'98','HP LaserJet Pro M402dne Monochrome Laser Printer'),('293',75,0,'99','<table class=\"specTable\" data-selenium=\"specTable\">\r\n<tbody data-selenium=\"specBody\">\r\n<tr><th class=\"specHeader Header\" colspan=\"2\" data-selenium=\"specHeader\"><a id=\"44369\" class=\"fs32 OpenSans-300-normal\" name=\"44369\" data-selenium=\"specHeaderLink\"></a>Performance</th></tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Printing Technology</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">HP ImageREt 3600 laser</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Maximum Resolution</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">600 x 600 dpi</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Print Speed</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">20 ppm with letter/A4 in black &amp; white or color</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">First Print Out Speed</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Black &amp; White: 14.5 seconds for letter-sized document<br />Color: 15.5 seconds for letter-sized document</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Print Color</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">CMYK: Cyan, magenta, yellow, black</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Duplex Printing</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Manual</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Printer Duty Cycle</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Up to 75,000 pages<br />Recommended Monthly Volume: 1,500 to 5,000 pages</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<table class=\"specTable\" data-selenium=\"specTable\">\r\n<tbody data-selenium=\"specBody\">\r\n<tr><th class=\"specHeader Header\" colspan=\"2\" data-selenium=\"specHeader\"><a id=\"81701\" class=\"fs32 OpenSans-300-normal\" name=\"81701\" data-selenium=\"specHeaderLink\"></a>Media Handling</th></tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Paper Handling</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Multipurpose tray<br />Input tray<br />Output bin</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Paper Types</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Paper (bond, brochure, colored, glossy, letterhead, photo, plain, preprinted, prepunched, recycled, rough), carstock, glossy film, transparencies, labels, envelopes</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Paper Sizes</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Multipurpose Tray: A3, A4, A5, A6, RA3, SRA3, B4, B5, 8k, 16k, 3.9 x 5.9\" (10 x 15 cm), post cards (JIS single and double), letter, legal, executive, 11 x 17\" (27.9 x 43.2 cm), 12 x 18\" (30.5 x 45.7 cm), 4 x 6\" (10.2 x 15.2 cm), 5 x 8\" (12.7 x 20.3 cm), 8.5 x 13\" (21.6 x 33.0 cm), envelopes (DL, C5, B5, No. 10 Monarch), Custom: 3 x 5\" to 12.6 x 18\" (7.6 x 12.7 cm to 32.0 x 45.7 cm)<br />Input Tray: A3, A4, A5, B4, B5, 8k, 16k, double postcard, letter, legal, executive, 11 x 17\" (27.9 x 43.2 cm), 8.5 x 13\" (21.6 x 33.0 cm), Custom: 5.8 x 8.3\" to 11.7 x 17\" (14.8 x 21.0 cm to 29.7 x 43.2 cm)</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Media Weight</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Multipurpose Tray: 16-58 lb bond (60-220 gsm)<br />Input Tray: Up to 32 lb (120 gsm) plain or 43 lb (160 gsm) coated</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Paper Capacity</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Multipurpose Tray: 100 sheets<br />Input Tray: 250 sheets<br />Optional Tray 3: 500 sheets<br />Output Bin: 250 sheets</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<table class=\"specTable\" data-selenium=\"specTable\">\r\n<tbody data-selenium=\"specBody\">\r\n<tr><th class=\"specHeader Header\" colspan=\"2\" data-selenium=\"specHeader\"><a id=\"44363\" class=\"fs32 OpenSans-300-normal\" name=\"44363\" data-selenium=\"specHeaderLink\"></a>Connectivity</th></tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Interface</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">USB 2.0<br />10/000 Base-T Ethernet</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Processor</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">540 MHz</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Memory</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">192 MB, expandable to 448 MB via one open DDR2 DIMM slot</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Printer Language</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">HP PCL 6, HP PCL 5c, HP postscript level 3 emulation</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Fonts</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">84 scalable TrueType fonts</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">OS Support</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Windows 2000, XP Home, XP Professional, Server 2003, Vista, XP Media Center, XP Professional x64, 7 (HP UPD only)<br />Mac OS X 10.3 or higher<br />Linux<br />OS/2<br />UNIX</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Network OS Support</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Windows 2000, XP Home, XP Professional, Server 2003, Vista, XP Media Center, XP Professional x64, 7 (HP UPD only)<br />Mac OS X 10.3 or higher<br />Linux</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Network Protocols</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Via Built-in Networking Solution: TCP/IP, IPv4, IPv6<br />Print: TCP-IP port 9100 Direct Mode, LPD (raw queue support only), Web Services Printing<br />Discovery: SLP, Bonjour, Web Services Discovery<br />IP Config: IPv4 (BootP, DHCP, AutoIP, Manual), IPv6 (Stateless Link-Local and via Router, Statefull via DHCPv6)<br />Management: SNMPv1, HTTP</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Network Security</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Password-protected network embedded Web server, enable/disable Network ports, SNMPv1 community password change</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<table class=\"specTable\" data-selenium=\"specTable\">\r\n<tbody data-selenium=\"specBody\">\r\n<tr><th class=\"specHeader Header\" colspan=\"2\" data-selenium=\"specHeader\"><a id=\"45092\" class=\"fs32 OpenSans-300-normal\" name=\"45092\" data-selenium=\"specHeaderLink\"></a>General Attributes</th></tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Control Panel</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">5 buttons (cancel job, left arrow, right arrow, select back), 2 LED indicator lights (attention, ready)</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Display</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">2-line, 16-character backlit display</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Power Requirements</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">115-127 VAC (±10%), 60 Hz (±2 Hz)</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Power Consumption</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Active: 440 W<br />Standby: 30 W<br />PowerSave: 4.4 W<br />Off: 0.5 W</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Typical Power Consumption</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">1.787 kWh/week</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Certifications</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">ENERGY STAR qualified<br />Safety Approvals: IEC 60950-1 (International); EN 60950-1+A11 (EU); IEC and requirements 60825-1+A1+A2; NRTL Listed (US/Canada); GS License (Europe); EN 60825-1+A1+A2 (Class 1 Laser/LED Device) GB4943-2001; Low Voltage Directive 2006/95/EC with CE Marking (Europe); other safety approvals as required by individual countries <br />Electromagnetic Emission Standard: CISPR 22: 2005/EN 55022: 2006 Class B, EN 61000-3-2: 2006, EN 61000-3-3: 1995+A1+A2, EN 55024: 1998+A1+A2, FCC Title 47 CFR, Part 15 Class A (USA), ICES-003, Issue 4, (Canada), GB9254-1998, EMC Directive 2004/108/EC with CE Marking (Europe), other EMC approvals as required by individual countries</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Acoustic Noise</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Power Emissions: 6.3 B(A) printing, 5.3 B(A) ready<br />Pressure Emissions: 49 dB(A)</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Operating Conditions</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Temperature: 50 to 86°F (10 to 30°C)<br />Humidity: 10 to 80%, relative<br />Recommended Temperature: 59 to 80.6°F (15 to 27°C)<br />Recommended Humidity: 20 to 60%, relative</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Storage Conditions</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Temperature: 32 to 95°F (0 to 35°C)<br />Humidity: 10 to 90%, relative</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Dimensions</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">21.5 x 23.6 x 13.3\" (545 x 599 x 338 mm)<br />With Trays Extended: 34.0 x 42.0 x 14.6\" (862 x 1066 x 370 mm)</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Weight</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">90.2 lb (40.9 kg)</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<table class=\"specTable\" data-selenium=\"specTable\">\r\n<tbody data-selenium=\"specBody\">\r\n<tr><th class=\"specHeader Header\" colspan=\"2\" data-selenium=\"specHeader\"><a id=\"shipping\" class=\"fs32 OpenSans-300-normal\" name=\"shipping\" data-selenium=\"specHeaderLink\"></a>Packaging Info</th></tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Package Weight</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">99.0 lb</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Box Dimensions (LxWxH)</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">28.5 x 27.5 x 18.5\"</td>\r\n</tr>\r\n</tbody>\r\n</table>'),('294',76,0,'99','<ul class=\"top-section-list\" data-selenium=\"highlightList\">\r\n<li class=\"top-section-list-item\">Print Resolution: 600 x 600 dpi</li>\r\n<li class=\"top-section-list-item\">Maximum Print Size: 12.6 x 18\"</li>\r\n<li class=\"top-section-list-item\">Minimum Print Size: 3 x 5\"</li>\r\n<li class=\"top-section-list-item\">Print Speed: 20 ppm</li>\r\n<li class=\"top-section-list-item\">First Print Out Time: 14.5 Seconds</li>\r\n<li class=\"top-section-list-item\">Two-Line LCD Display</li>\r\n<li class=\"top-section-list-item\">Input Capacity: 350 Sheets</li>\r\n<li class=\"top-section-list-item\">Monthly Duty Cycle: 75,000 Pages</li>\r\n<li class=\"top-section-list-item\">USB 2.0 and Ethernet Connectivity</li>\r\n</ul>\r\n<div class=\"ov-wrapper js-overview-desc\">\r\n<div class=\"ov-desc\">\r\n<p>Cover all of your office\'s printing needs with the 20 ppm <strong>CP5225n LaserJet Professional Color Laser Printer from HP</strong>. Featuring the ability to print documents from 3 x 5\" to 12 x 18\", this unit is extremely versatile. It utilizes a color laser system with a resolution of 600 x 600 dpi to produce first prints in about 14.5 seconds in black and white or 16.5 seconds in color.</p>\r\n<p>The front control panel has 5 buttons and 2 LED indicator lights along with a 2-line LCD display. Paper handling is done through the use of a 100-sheet multipurpose tray and a 250-sheet input tray. Durability is key with the CP5225n as it has a rated duty cycle of 75,000 pages. Additionally, it features both USB 2.0 and Ethernet connectivity.</p>\r\n</div>\r\n</div>\r\n<div class=\"sectionHeaders js-hiddenFeatures\" data-selenium=\"sectionHeaders\">\r\n<ul>\r\n<ul>HP ImageREt 3600 technology create smooth colors, sharp images, and crisp text</ul>\r\n</ul>\r\n<br />\r\n<ul>\r\n<ul>HP ColorSphere toner delivers consistent results and large print volumes</ul>\r\n</ul>\r\n<br />\r\n<ul>\r\n<ul>HP Auto-Off Technology will shut down your printer when not in use</ul>\r\n</ul>\r\n<br />\r\n<ul>\r\n<ul>ENERGY STAR qualified</ul>\r\n</ul>\r\n<br />\r\n<ul>Includes HP Easy Printer Care Software, HP Universal Print Driver, and HP ToolboxFX software in order to maximize the features and usage of your printer</ul>\r\n</div>'),('295',85,0,'99','HP LaserJet Pro CP5225n Color Laser Printer'),('296',75,0,'100','<table class=\"specTable\" data-selenium=\"specTable\">\r\n<tbody data-selenium=\"specBody\">\r\n<tr><th class=\"specHeader Header\" colspan=\"2\" data-selenium=\"specHeader\"><a id=\"44369\" class=\"fs32 OpenSans-300-normal\" name=\"44369\" data-selenium=\"specHeaderLink\"></a>Performance</th></tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Printing Technology</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Laser; HP ImageRET 3600, Pantone calibrated</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Maximum Resolution</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">600 x 600 dpi (38400 x 600 enhanced dpi)</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Print Speed</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">28 ppm</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">First Print Out Speed</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Ready, Black: 8.9 sec<br />Ready, Color: 9.5 sec<br />Sleep, Black: 11.3 sec<br />Sleep, Color: 11.4 sec</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Print Color</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Color</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Duplex Printing</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Automatic</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Printer Duty Cycle</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Monthly: 50,000 pages<br />Recommended Monthly Volume: 750-4,000 pages</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Print Features</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">N-up printing, collation, HP ePrint, Apple AirPrint, Mopria certified, Google Cloud Print, NFC touch-to-print, wireless direct printing, HP Auto-On/Auto-Off Technology, Print from Cloud using business apps on the control panel, HP JetAdvantage Private Print, Job Storage with PIN printing, Print from USB</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<table class=\"specTable\" data-selenium=\"specTable\">\r\n<tbody data-selenium=\"specBody\">\r\n<tr><th class=\"specHeader Header\" colspan=\"2\" data-selenium=\"specHeader\"><a id=\"81701\" class=\"fs32 OpenSans-300-normal\" name=\"81701\" data-selenium=\"specHeaderLink\"></a>Media Handling</th></tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Paper Handling</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Multipurpose tray<br />Input tray<br />Output bin</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Paper Types</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Paper (bond, brochure, colored, glossy, letterhead, photo, plain, preprinted, prepunched, recycled, rough), postcards, labels, envelopes</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Paper Sizes</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Multipurpose Tray: 3 x 5\" to 8.5 x 14\" / 7.6 x 12.7 cm to 21.6 x 35.6 cm<br />Input Tray: 3.9 x 5.8\" to 8.5 x 14\" / 10.0 x 14.7 cm to 21.6 x 35.6 cm</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Media Weight</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Multipurpose Tray: 16-52 lb<br />Input Tray: 16-47 lb</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Paper Capacity</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Multipurpose Tray: 50 sheets<br />Input Tray: 250 sheets<br />Output Bin: 150 sheets</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<table class=\"specTable\" data-selenium=\"specTable\">\r\n<tbody data-selenium=\"specBody\">\r\n<tr><th class=\"specHeader Header\" colspan=\"2\" data-selenium=\"specHeader\"><a id=\"44363\" class=\"fs32 OpenSans-300-normal\" name=\"44363\" data-selenium=\"specHeaderLink\"></a>Connectivity</th></tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Interface</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">USB 2.0<br />Ethernet<br />Wi-Fi with NFC</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">USB Direct Printing</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Yes, 1 x USB host port</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Wireless Printing Features</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">HP ePrint, Apple AirPrint, Google Cloud Print, Mopria-certified, wireless direct printing, NFC touch-to-print, mobile apps</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">OS Compatibility</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Windows XP SP3 (32/64-bit), Vista (32/64-bit), 7 (32/64-bit), 8/8.1 (32/64-bit), 10 (32/64-bit)<br />Mac OS X 10.7-10.10<br />iOS, Android, Windows 8/8.1/10 RT<br />SUSE Linux (12.2, 12.3, 13.1), Fedora (17, 18, 19, 20), Linux Mint (13, 14, 15, 16, 17), Boss (3.0, 5.0), Ubuntu (10.04, 11.10, 12.04, 12.10, 13.04, 13.10, 14.04, 14.10), Debian (6.0.x, 7.x)<br />UNIX</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Processor</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">1.2 GHz</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Memory</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">256 MB NAND flash, 256 MB DRAM</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Fonts</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">84 scalable TrueType fonts</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Printer Language</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">HP PCL 6, HP PCL 5c, HP postscript level 3 emulation, PDF, URF, PCLm, Native Office, PWG Raster</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<table class=\"specTable\" data-selenium=\"specTable\">\r\n<tbody data-selenium=\"specBody\">\r\n<tr><th class=\"specHeader Header\" colspan=\"2\" data-selenium=\"specHeader\"><a id=\"45092\" class=\"fs32 OpenSans-300-normal\" name=\"45092\" data-selenium=\"specHeaderLink\"></a>General Attributes</th></tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Control Panel</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">3.0\" / 7.6 cm color touchscreen<br />3 buttons (home, help, back)</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Power Requirements</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">110-127 VAC (±10%), 60 Hz (±3 Hz)</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Power Consumption</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Active Printing: 570 W<br />Ready: 17.6 W<br />Sleep: 2.4 W<br />Auto-On/Off: 0.6 W<br />Off: 0.05 W</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Typical Power Consumption</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">1.515 kWh/week</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Certifications</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">ENERGY STAR certified<br />Blue Angel<br />EPEAT Silver</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Acoustic Noise</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Power Emissions: 6.3 B(A) (Active); 4.8 B(A) (Ready)<br />Pressure Emissions: 49 dB(A) (Active); 34 dB(A) (Ready)</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Operating Conditions</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Temperature: 59 to 86°F / 15 to 30°C<br />Humidity: 10 to 80%, relative non-condensing<br />Recommended Temperature: 59 to 80.6°F / 15 to 27°C<br />Recommended Humidity: 20 to 70%, relative non-condensing</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Storage Conditions</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Temperature: -4 to 104°F / -20 to 40°C<br />Humidity: 10 to 95%, relative non-condensing</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Dimensions</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">16.2 x 18.5 x 11.6\" / 41.1 x 47.0 x 29.5 cm<br />Maximum: 16.2 x 25.6 x 13.4\" /41.1 x 65.0 x 34.0 cm</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Weight</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">41.7 lb / 18.9 kg</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<table class=\"specTable\" data-selenium=\"specTable\">\r\n<tbody data-selenium=\"specBody\">\r\n<tr><th class=\"specHeader Header\" colspan=\"2\" data-selenium=\"specHeader\"><a id=\"shipping\" class=\"fs32 OpenSans-300-normal\" name=\"shipping\" data-selenium=\"specHeaderLink\"></a>Packaging Info</th></tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Package Weight</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">49.5 lb</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Box Dimensions (LxWxH)</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">23.0 x 19.5 x 15.3\"</td>\r\n</tr>\r\n</tbody>\r\n</table>'),('297',76,0,'100','<ul class=\"top-section-list\" data-selenium=\"highlightList\">\r\n<li class=\"top-section-list-item\">Print Resolution: 600 x 600 dpi</li>\r\n<li class=\"top-section-list-item\">Maximum Print Size: 8.5 x 14\"</li>\r\n<li class=\"top-section-list-item\">Minimum Print Size: 3 x 5\"</li>\r\n<li class=\"top-section-list-item\">Print Speed: 28 ppm</li>\r\n<li class=\"top-section-list-item\">First Print Out Time: 8.9 Seconds Black</li>\r\n<li class=\"top-section-list-item\">Automatic Duplexing</li>\r\n<li class=\"top-section-list-item\">3.0\" Color Touchscreen; USB Host Port</li>\r\n<li class=\"top-section-list-item\">Input Capacity: 300 Sheets</li>\r\n<li class=\"top-section-list-item\">Monthly Duty Cycle: 50,000 Pages</li>\r\n<li class=\"top-section-list-item\">USB 2.0, Ethernet, and Wi-Fi with NFC</li>\r\n</ul>\r\n<div class=\"ov-wrapper js-overview-desc\">\r\n<div class=\"ov-desc\">\r\n<p>Finish your print jobs quickly with the <strong>Color LaserJet Pro M452dw Laser Printer from HP</strong> with a print speed of up to 28 ppm. This unit offers a print resolution of 600 x 600 dpi, which can be enhanced to 38400 x 600 dpi, for finely detailed documents. Also, furthering the speed of the unit is a first print out time of 8.9 seconds for black and 9.5 seconds for color. The M452dw also has automatic duplexing for convenience and a monthly duty cycle of 50,000 pages for durability. Additionally, it has both a 50-sheet multipurpose and 250-sheet input tray for handling a variety of document types from 3 x 5\" to 8.5 x 14\".</p>\r\n<p>Operation is simplified with the implementation of a 3.0\" color touchscreen on the front panel. This intuitively controlled system clearly shows users print status, settings, and more. Also, there is an easy access USB port for printing from a portable drive. And, the M452dw is equipped with USB 2.0, Ethernet, and Wi-Fi with NFC for a multitude of connection options.</p>\r\n</div>\r\n</div>\r\n<div class=\"sectionHeaders js-hiddenFeatures\" data-selenium=\"sectionHeaders\"><dl class=\"js-featureSectionDL\"><dd class=\"featuredd c28\">First page out time of 8.9 seconds for black and 9.5 seconds for color</dd></dl><dl class=\"js-featureSectionDL\"><dd class=\"featuredd c28\">Protect information with HP JetAdvantage Private Print and additional security features</dd></dl><dl class=\"js-featureSectionDL\"><dd class=\"featuredd c28\">Intuitive control using the 3.0\" color touchscreen</dd></dl><dl class=\"js-featureSectionDL\"><dd class=\"featuredd c28\">Print documents directly from a USB drive</dd></dl><dl class=\"js-featureSectionDL\"><dd class=\"featuredd c28\">Anti-fraud technology</dd></dl><dl class=\"js-featureSectionDL\"><dd class=\"featuredd c28\">Print directly from a smartphone or tablet</dd></dl><dl class=\"js-featureSectionDL\"><dd class=\"featuredd c28\">Print-and-touch with NFC-enabled devices</dd></dl><dl class=\"js-featureSectionDL\"><dd class=\"featuredd c28\">Share the printer over a network with either Ethernet or Wi-Fi connectivity</dd></dl></div>'),('298',85,0,'100','HP Color LaserJet Pro M452dw Laser Printer'),('299',75,0,'101','<h2 class=\"ccs-cc-inline-section-title\" data-ccs-jumplink-container=\"true\"><a class=\"ccs-cc-inline-acc-header\" title=\"Specifications\" data-ccs-cc-inline-acc-id=\"specification-d5317c\" data-ccs-cc-inline-acc-state=\"expanded\"><span>Specifications</span></a></h2>\r\n<div class=\"ccs-cc-inline-acc-content\" data-ccs-cc-inline-acc-id=\"specification-d5317c\">\r\n<table>\r\n<tbody>\r\n<tr class=\"ccs-cc-inline-specs-row\"><th class=\"ccs-cc-inline-specification-attribute\" scope=\"row\">Print speed black (ISO, letter) </th>\r\n<td>Up to 26 ppm </td>\r\n</tr>\r\n<tr class=\"ccs-cc-inline-specs-row\"><th class=\"ccs-cc-inline-specification-attribute\" scope=\"row\">First page out black (letter, ready) </th>\r\n<td>As fast as 8 sec </td>\r\n</tr>\r\n<tr class=\"ccs-cc-inline-specs-row\"><th class=\"ccs-cc-inline-specification-attribute\" scope=\"row\">Duty cycle (monthly, letter) </th>\r\n<td>Up to 30,000 pages </td>\r\n</tr>\r\n<tr class=\"ccs-cc-inline-specs-row\"><th class=\"ccs-cc-inline-specification-attribute\" scope=\"row\">Recommended monthly page volume </th>\r\n<td>250 to 2000 </td>\r\n</tr>\r\n<tr class=\"ccs-cc-inline-specs-row\"><th class=\"ccs-cc-inline-specification-attribute\" scope=\"row\">Print technology </th>\r\n<td>Laser </td>\r\n</tr>\r\n<tr class=\"ccs-cc-inline-specs-row\"><th class=\"ccs-cc-inline-specification-attribute\" scope=\"row\">Print quality black (best) </th>\r\n<td>Up to 600 x 600 dpi </td>\r\n</tr>\r\n<tr class=\"ccs-cc-inline-specs-row\"><th class=\"ccs-cc-inline-specification-attribute\" scope=\"row\">Display </th>\r\n<td>196 x 34 pixel graphic LCD </td>\r\n</tr>\r\n<tr class=\"ccs-cc-inline-specs-row\"><th class=\"ccs-cc-inline-specification-attribute\" scope=\"row\">HP ePrint capability </th>\r\n<td>Yes </td>\r\n</tr>\r\n<tr class=\"ccs-cc-inline-specs-row\"><th class=\"ccs-cc-inline-specification-attribute\" scope=\"row\">Mobile printing capability </th>\r\n<td>HP ePrint<br />Apple AirPrint<span>™</span><br />Mopria<span>™</span>-certified<br />Wireless Direct Printing </td>\r\n</tr>\r\n<tr class=\"ccs-cc-inline-specs-row\"><th class=\"ccs-cc-inline-specification-attribute\" scope=\"row\">Wireless capability </th>\r\n<td>Yes, built-in Ethernet, Wi-Fi 802.11b/g/n </td>\r\n</tr>\r\n<tr class=\"ccs-cc-inline-specs-row\"><th class=\"ccs-cc-inline-specification-attribute\" scope=\"row\">Connectivity, standard </th>\r\n<td>1 Hi-Speed USB 2.0<br />1 Ethernet 10/100 </td>\r\n</tr>\r\n<tr class=\"ccs-cc-inline-specs-row\"><th class=\"ccs-cc-inline-specification-attribute\" scope=\"row\">Network ready </th>\r\n<td>Standard (built-in Ethernet, WiFi 802.11b/g/n) </td>\r\n</tr>\r\n<tr class=\"ccs-cc-inline-specs-row\"><th class=\"ccs-cc-inline-specification-attribute\" scope=\"row\">Compatible Operating Systems </th>\r\n<td>Full software installs supported on: Windows 10 (32 &amp; 64-bit), Windows 8.1 (32 &amp; 64-bit), Windows 8 (32 &amp; 64-bit), Windows 7 (32 &amp; 64-bit), Windows Vista (32 &amp; 64-bit), Windows XP (32-bit) (SP2 or higher)<br />Driver only installs (by CD) supported on: Windows Server 2008 (32 &amp; 64-bit), Windows Server 2003 (32-bit) (SP1 or higher), Windows Server 2003 R2 (32-bit), Windows Server 2008 R2 (64-bit)<br />Driver only installs (by APW) supported on: Windows 8.1 (32 &amp; 64-bit)<br />Windows 8 (32 &amp; 64-bit), Windows 7 (32 &amp; 64-bit), Windows Vista (32 &amp; 64-bit), Windows XP (32 &amp; 64-bit) (SP2 or higher), Windows Server 2012 R2 (64-bit), Windows Server 2012 (64-bit), Windows Server 2008 R2 (SP1) (64-bit), Windows Server 2008 (32 &amp; 64-bit), Windows Server 2003 R2 (32 &amp; 64-bit), Windows Server 2003 (32 &amp; 64-bit) (SP1 or higher), Windows Server 2003 Standard and Enterprise<br />Mac OS X Lion, OS X Mountain Lion, and Mavericks<br />For Linux/Unix support, please refer to: http://hplipopensource.com/hplip-web/index.html </td>\r\n</tr>\r\n<tr class=\"ccs-cc-inline-specs-row\"><th class=\"ccs-cc-inline-specification-attribute\" scope=\"row\">Memory </th>\r\n<td>128 MB </td>\r\n</tr>\r\n<tr class=\"ccs-cc-inline-specs-row\"><th class=\"ccs-cc-inline-specification-attribute\" scope=\"row\">Maximum Memory </th>\r\n<td>128 MB </td>\r\n</tr>\r\n<tr class=\"ccs-cc-inline-specs-row\"><th class=\"ccs-cc-inline-specification-attribute\" scope=\"row\">Internal Storage </th>\r\n<td>None </td>\r\n</tr>\r\n<tr class=\"ccs-cc-inline-specs-row\"><th class=\"ccs-cc-inline-specification-attribute\" scope=\"row\">Paper handling input, standard </th>\r\n<td>250-sheet input tray, 10-sheet priority tray </td>\r\n</tr>\r\n<tr class=\"ccs-cc-inline-specs-row\"><th class=\"ccs-cc-inline-specification-attribute\" scope=\"row\">Paper handling output, standard </th>\r\n<td>150-sheet output tray </td>\r\n</tr>\r\n<tr class=\"ccs-cc-inline-specs-row\"><th class=\"ccs-cc-inline-specification-attribute\" scope=\"row\">Duplex printing </th>\r\n<td>Automatic (standard) </td>\r\n</tr>\r\n<tr class=\"ccs-cc-inline-specs-row\"><th class=\"ccs-cc-inline-specification-attribute\" scope=\"row\">Media sizes supported </th>\r\n<td>Letter, legal, executive, postcards, envelopes (No. 10, Monarch) </td>\r\n</tr>\r\n<tr class=\"ccs-cc-inline-specs-row\"><th class=\"ccs-cc-inline-specification-attribute\" scope=\"row\">Media types </th>\r\n<td>Paper (laser, plain, photo, rough, vellum), envelopes, labels, cardstock, transparencies, postcards </td>\r\n</tr>\r\n<tr class=\"ccs-cc-inline-specs-row\"><th class=\"ccs-cc-inline-specification-attribute\" scope=\"row\">Energy efficiency </th>\r\n<td>ENERGY STAR<span>®</span> qualified<br />EPEAT<span>®</span> Silver </td>\r\n</tr>\r\n<tr class=\"ccs-cc-inline-specs-row\"><th class=\"ccs-cc-inline-specification-attribute\" scope=\"row\">Operating temperature range </th>\r\n<td>59 to 90.5ºF </td>\r\n</tr>\r\n<tr class=\"ccs-cc-inline-specs-row\"><th class=\"ccs-cc-inline-specification-attribute\" scope=\"row\">Recommended operating humidity range </th>\r\n<td>10 to 80% RH </td>\r\n</tr>\r\n<tr class=\"ccs-cc-inline-specs-row\"><th class=\"ccs-cc-inline-specification-attribute\" scope=\"row\">Minimum dimensions (W x D x H) </th>\r\n<td>15.1 x 11.1 x 9.9 in </td>\r\n</tr>\r\n<tr class=\"ccs-cc-inline-specs-row\"><th class=\"ccs-cc-inline-specification-attribute\" scope=\"row\">Maximum dimensions (W x D x H) </th>\r\n<td>15.1 x 15.9 x 9.9 in </td>\r\n</tr>\r\n<tr class=\"ccs-cc-inline-specs-row\"><th class=\"ccs-cc-inline-specification-attribute\" scope=\"row\">Weight </th>\r\n<td>14.5 lb </td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>'),('300',76,0,'101','<div>Get this mono printer set up and printing quickly over your wireless network with HP Auto Wireless Connect. Complete your print jobs fast with a print speed of up to 26 pages per minute and automatic duplexing, and easily administer the printer using the embedded, password-protected Web server. A 600 x 600 dpi print resolution ensures sharp, crisp text and images, and a 250-sheet input tray provides plenty of paper for larger print jobs.</div>\r\n<div class=\"prod-sub-header skuShortDescription\">\r\n<ul class=\"stp--bulleted-list\">\r\n<li><span>Single-function HP LaserJet Pro printer offers fast, reliable performance</span></li>\r\n<li><span>Laser technology prints at 600 x 600 dpi for sharp, crisp text and images</span></li>\r\n<li><span>Black-and-white print speed of 21 to 30 pages per minute offers fast printing; monthly duty cycle of 8,000 pages for high-capacity printing</span></li>\r\n<li><span>Take ordering supplies off your to-do list. Now your printer can automatically reorder your ink and toner via Smart Ordering with Auto Restock. </span></li>\r\n<li><span>USB 2.0, Ethernet and Wi-Fi (802.11b/g/n) networking offer fast network access and connectivity</span></li>\r\n<li><span>Printer dimensions are 9.9\"H x 15.1\"W x 11.1\"D</span></li>\r\n<li><span>250-sheet input tray with 10-sheet priority tray provides plenty of paper for large print jobs</span></li>\r\n<li><span>750MHz processor and 128MB memory for fast printing processing</span></li>\r\n<li><span>Supported paper sizes include letter, legal, executive, postcards and envelopes (No. 10, Monarch) for flexible printing</span></li>\r\n</ul>\r\n</div>\r\n<div class=\"prod-sub-header skuShortDescription\">Speed up and ease your printing with this <strong>HP LaserJet Pro mono printer.</strong> The auto duplex option provides two-sided printing to scale down your paper costs and save time. Use a compatible mobile device to print wirelessly.<br /><br /><strong>Seamless Connectivity</strong><br />The network-ready machine comes with a walk-up, hi-speed USB 2.0 slot for direct printing and Ethernet and Wi-Fi interfaces for seamless connectivity. The included HP ePrint and AirPrint applications let you print wirelessly from anywhere in the office.<br /><br /><strong>Speedy Printing</strong><br />Powered by a 750MHz processor, the wireless mono printer handles intensive tasks easily, delivering up to 26ppm and the first page in eight seconds, which reduces wait time. The 128MB mono printer buffers images and improves throughput.<br /><br /><strong>Easy Setup and Customization</strong><br />Pair the printer\'s drivers with Windows or Mac operating systems for customized functionality. The mono printer has an intuitive control panel with a two-line LCD to ease setup and to manage scheduled tasks.</div>'),('301',85,0,'101','HP LaserJet Pro M201dw Wireless Monochrome Printer'),('302',75,0,'102','<table class=\"specTable\" data-selenium=\"specTable\">\r\n<tbody data-selenium=\"specBody\">\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Technology</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Print: HP Thermal Inkjet</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Print Speed</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">ISO Speed: Black: Up to 15 ppm, Color: Up to 8 ppm<br />Maximum Print Speed: Black: Up to 33 ppm, Color: Up to 29 ppm <span class=\"specNote\" data-selenium=\"specNote\"><a class=\"specNoteLink js-popover-opener\" title=\"\" href=\"https://www.bhphotovideo.com/c/product/920433-REG/hp_cr768a_officejet_7110_wide.html#specNote1\" data-trigger=\"hover\" data-container=\"body\" data-selenium=\"specNoteLink\" data-original-title=\"\"></a></span></td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Print Resolution</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Black: Up to 600 x 1200 dpi<br />Color: Up to 4800 x 1200 optimized dpi color (when printing from a computer on selected HP photo papers and 1200 input dpi)</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Capability</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Mobile Printing: HP ePrint, Apple AirPrint</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Capability</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Borderless Printing: Yes; up to 13 x 19\" (330 x 483 mm)</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Cartridges</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">4 (black, cyan, magenta, and yellow)</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Language</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Printer Command: HP PCL 3 GUI, HP PCL 3 Enhanced</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Feeder - Document</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Envelope: Yes, 30</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Network Protocols</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">TCP/IP</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Memory</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Maximum/Standard: 16 MB (ROM); 128 MB (DDR RAM)</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Processor</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">ARM R4</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Processor Speed</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">500 MHz</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Printing</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Camera Phone: Support print from camera through cloud, wireless router, HP ePrint, and Apple AirPrint</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Connectivity</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Standard: 1 USB 2.0, 1 Ethernet, 1 Wireless 802.11b/g/n</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Capabilities</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Network: Built-in Ethernet and wireless (802.11b/g/n)</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Network</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Standard (built-in Ethernet, WiFi 802.11b/g/n)</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Duty Cycle</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Up to 12,000 pages</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Volume</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Recommended Monthly Page: Up to 200 to 800 pages <span class=\"specNote\" data-selenium=\"specNote\"><a class=\"specNoteLink js-popover-opener\" title=\"\" href=\"https://www.bhphotovideo.com/c/product/920433-REG/hp_cr768a_officejet_7110_wide.html#specNote2\" data-trigger=\"hover\" data-container=\"body\" data-selenium=\"specNoteLink\" data-original-title=\"\"></a></span></td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Features</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Printer Smart Software: Orientation: Portrait/landscape<br />Print on Both Sides: None/flip on long edge/flip on short edge<br />Page Order: Front to back/back to front<br />Page Format: Pages per sheet: 1, 2, 4, 6, 9, 16 (i.e., N-up printing)/booklet/draw borders<br />Print in Grayscale: Off/high-quality grayscale/black ink only<br />Borderless Printing: Print with border/borderless print<br />Output Quality: Draft/normal/best/maximum dpi<br />HP Real Life Technologies: Off/on</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Media Types</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Paper (brochure, inkjet, plain), photo, envelopes, cards (index)</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Sizes Supported</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Media: A4: 8.27 x 11.70\" (210.00 x 297.00 mm), A5: 5.83 x 8.27\" (148.00 x 210.00 mm), A6: 4.12 x 5.83\" (105.00 x 148.00 mm), B5 (JIS): 7.16 x 10.12\" (182.00 x 257.00 mm), 6.00 x 8.00\"(152.40 x 203.20 mm), Executive: 7.25 x 10.5\" (184.20 x 266.70 mm), Index card 3.00 x 5.00\" (76.20 x 127.00 mm), Index card 4.00 x 6.00\" (101.60 x 152.40 mm), Index card 5.00 x 8.00\" (127.00 x 203.20 mm), Index card A4: 8.27 × 11.69\" (210.00 x 297.00 mm), Index card Letter: 3.00 x 5.00\" (76.20 x 127.00 mm),<br />3.00 x 5.00\" (76.20 x 127.00 mm), 4.00 x 6.00\" (101.60 x 152.40 mm), 5.00 x 7.00\" (127.00 x 177.80 mm), 8.00 x 10.00\" (203.20 x 254.00 mm), 4.00 x 6.00\" (101.60 x 152.40 mm), L: 3.50 x 5.00\" (89.00 x 127.00 mm), Photo 2L: 4.10 x 7.01\" (127.00 x 178.00 mm), 8.50 x 13.00\" (216.00 x 330.00 mm), Legal, Letter, Statement: 5.50 × 8.50\" (140.00 x 216.00 mm),<br />Ofuku Hagaki: 5.83 x 7.87\" (148.00 x 200.00 mm), Hagaki card: 3.94 x 5.83\" (100.00 x 148.00 mm), Japanese postcard: 3.94 x 5.83\" (100.00 x 148.00 mm), Envelope #10: 4.12 x 9.50\" (105.00 x 241.00 mm), Envelope A2: 4.37 x 5.75\" (111.00 x 146.00 mm), Envelope C5: 9.00 x 6.40\" (229.00 x 162.00 mm), Envelope C6: 6.40 x 4.50\" (162.00 x 114.00 mm), Envelope DL: 4.33 x 8.66 (110.00 x 220.00 mm), Envelope Monarch: 3.87 x 6.75\" (98.43 x 171.45 mm), Card envelope 4.40 x 6.00\" (111.70 x 152.40 mm),<br />JIS Chou #3: 4.72 x 9.25 (120.00 x 235.00 mm), JIS Chou #4: 3.54 x 8.07\" (90.00 x 205.00 mm), 11.00 x 14.00\" (279.40 x 355.60 mm), 12.00 x 12.00\" (304.80 x 304.80 mm), B4 (JIS): 10.12 x 14.33\" (257.00 x 364.00 mm), Tabloid: 11.00 × 17.00\" (279.00 × 432.00 mm), Super B: 13.00 × 19.00\" (330.00 × 483.00 mm), A3: 11.69 × 16.54\" (297.00 × 420.00 mm), A3+: 13.00 x 19.00\" (330.00 x 483.00 mm)</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Media Weight Supported</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">9 to 66 lb (4.08 to 29.93 kg), bond (34 to 250 g/m2)</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Media Thickness</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Photo/Card: Up to 11.5 mil<br />Envelopes: Up to 15.7 mil</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Size</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Custom Media: Tray 1: 3.0 x 5.0 to 13.0 x 44.0\" (76.2 x 127.0 to 330.2 x 482.6 mm) custom media supported on Mac only</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Paper Handling</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Input: 250-sheet input tray, up to 80 cards, up to 30 envelopes, up to 250 sheets legal, up to 60 sheets photo paper<br />Output: 75-sheet output tray, up to 35 cards, up to 10 envelopes, up to 40 sheets labels, up to 75 sheets legal, up to 25 sheets photo paper</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Replacement Toner/Ink Cartridges</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">HP 932 Black Officejet Ink Cartridge (approximately 400 pages)<br />HP 933 Cyan Officejet Ink Cartridge (approximately 330 pages)<br />HP 933 Magenta Officejet Ink Cartridge (approximately 330 pages)<br />HP 933 Yellow Officejet Ink Cartridge (approximately 330 pages)<br />HP 932XL Black Officejet Ink Cartridge (approximately 1000 pages)<br />HP 933XL Magenta Officejet Ink Cartridge (approximately 825 pages)<br />HP 933XL Yellow Officejet Ink Cartridge (approximately 825 pages)<br />HP 933XL Cyan Officejet Ink Cartridge (approximately 825 pages)</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">OS Compatibility</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Windows 8 (32 and 64 bit), Windows 7 (32 and 64 bit), Windows Vista (32 and 64-bit), Windows XP (32 bit) SP3 or greater, Mac OS X v10.6, OS X Lion, OS X Mountain Lion, Linux Network: Windows 8 (32 and 64 bit), Windows 7 (32 and 64-bit), Windows Vista (32 and 64-bit), Windows XP (32 bit) SP3 or greater, Windows 2003 Server (Standard Edition, Enterprise Edition) (32 and 64 bit), Windows 2003 Server R2 (Standard Edition, Enterprise Edition) (32 and 64 bit), Windows Small Business Server 2003 (32 and 64 bit), Windows 2008 Server (Standard Edition, Enterprise Edition) (32 and 64 bit), Windows Small Business Server 2008 (64 bit), Windows 2008 Server R2 (Standard Edition, Enterprise Edition) (64 bit), Windows Small Business Server 2011, Windows Server 2012, Mac OS X v10.6, OS X Lion , OS X Mountain Lion, Linux</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Minimum System Requirements (PC)</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">PC: Windows 7 or Windows 8: 1 GHz 32 bit (x86) or 64 bit (x64) processor, 2 GB HD, Internet Explorer, CD-ROM/DVD or Internet, USB<br />Windows Vista: 800 MHz 32 bit (x86) or 64 bit (x64) processor, 2 GB HD, Internet Explorer, CD-ROM/DVD or Internet, USB <br />Windows XP SP3 (32 bit only): Intel Pentium II, Celeron or 233 MHz compatible processor, 750 MB HD, Internet Explorer 6, CD-ROM/DVD or Internet, USB<br />Mac: Mac OS X v10.6, OS X Lion, OS X Mountain Lion: Intel Core processor, 1 GB HD, CD-ROM/DVD or Internet, USB</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Minimum System Requirements (Mac)</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">PC: Windows 7 or Windows 8: 1 GHz 32 bit (x86) or 64 bit (x64) processor, 2 GB HD, Internet Explorer, CD-ROM/DVD or Internet, USB<br />Windows Vista: 800 MHz 32 bit (x86) or 64 bit (x64) processor, 2 GB HD, Internet Explorer, CD-ROM/DVD or Internet, USB <br />Windows XP SP3 (32 bit only): Intel Pentium II, Celeron or 233 MHz compatible processor, 750 MB HD, Internet Explorer 6, CD-ROM/DVD or Internet, USB<br />Mac: Mac OS X v10.6, OS X Lion, OS X Mountain Lion: Intel Core processor, 1 GB HD, CD-ROM/DVD or Internet, USB</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Control Panel</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">4 ink cartridge lights, 4 buttons with lights (Resume, Wireless, ePrint and Power) and 2 button (Cancel and Configuration), and 1 network indicator light</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Power</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Power Supply Type: External<br />Power Supply Required: Input voltage: 100 to 240 VAC (± 10%), 50/60 Hz (± 3 Hz)<br />Power Consumption: 30.3 W maximum, 25.4 (Active), 0.31 W (Manual-Off), 1.92 W (Standby), 1.04 W (Sleep) <span class=\"specNote\" data-selenium=\"specNote\"><a class=\"specNoteLink js-popover-opener\" title=\"\" href=\"https://www.bhphotovideo.com/c/product/920433-REG/hp_cr768a_officejet_7110_wide.html#specNote3\" data-trigger=\"hover\" data-container=\"body\" data-selenium=\"specNoteLink\" data-original-title=\"\"></a></span></td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Software Included</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">HP Printer Software, Bing Bar for HP (includes HP Smart Print), HP Officejet 7110 series help, Product Improvement Study for HP Officejet 7110 series, HP Update, Shop for Supplies Online, HP Photo Creations</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Acoustics</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Acoustic Pressure Emissions: 51 dB(A) (draft printing, mono); 47 dB(A) (normal printing, mono); 50 dB(A) (draft printing, color); 46 dB(A) (normal printing, color); Acoustic Power Emissions: 6.5 B(A) (draft printing, mono); 6.1 B(A) (Normal printing, mono); 6.5 B(A) (draft printing, color); 6.2 B(A) (normal printing, color)</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Operating Environment</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Operating Temperature Range: 41 to 104°F (5 to 40°C)<br />Recommended Operating Temperature: 59 to 90°F (15 to 32°C)<br />Storage Temperature Range: -40 to 140°F (-40 to 60°C)<br />Non-Operating Humidity Range: 5 to 90% RH non-condensing<br />Operating Humidity Range: 5 to 90% RH non-condensing<br />Recommended Operating Humidity Range: 25 to 75% RH non-condensing</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Dimensions (WxDxH)</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">23.0 x 14.5 x 7.5\" (585 x 419 x 189 mm)<br />Max: 23.0 x 27.9 x 7.5\" (585 x 708 x 189 mm) (trays extended full length)</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Weight</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">18.7 lb (8.5 kg)</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<table class=\"specTable\" data-selenium=\"specTable\">\r\n<tbody data-selenium=\"specBody\">\r\n<tr><th class=\"specHeader Header\" colspan=\"2\" data-selenium=\"specHeader\"><a id=\"shipping\" class=\"fs32 OpenSans-300-normal\" name=\"shipping\" data-selenium=\"specHeaderLink\"></a>Packaging Info</th></tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Package Weight</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">24.6 lb</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Box Dimensions (LxWxH)</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">27.0 x 20.0 x 12.0\"</td>\r\n</tr>\r\n</tbody>\r\n</table>'),('303',76,0,'102','<ul class=\"top-section-list\" data-selenium=\"highlightList\">\r\n<li class=\"top-section-list-item\">1200 dpi</li>\r\n<li class=\"top-section-list-item\">15 ppm Black, 8 ppm Color (ISO)</li>\r\n<li class=\"top-section-list-item\">Wi-Fi, Ethernet, ePrint, AirPrint</li>\r\n<li class=\"top-section-list-item\">Mobile Phone Printing</li>\r\n<li class=\"top-section-list-item\">Print Sizes up to 13 x 44\"</li>\r\n<li class=\"top-section-list-item\">Borderless Prints up to 13 x 19\"</li>\r\n<li class=\"top-section-list-item\">Monthly Duty Cycle 12,000 Pages</li>\r\n</ul>\r\n<div class=\"ov-wrapper js-overview-desc\">\r\n<div class=\"ov-desc\">\r\n<p>The <strong>HP Officejet 7110 Wide Format Wireless Color Inkjet ePrinter</strong> produces borderless professional-quality marketing materials in sizes from 3 x 5 to 13 x 19\". The printer features wireless printing and networking.</p>\r\n<p>Wireless performance is dependent upon physical environment and distance from access point. Wireless operations are compatible with 2.4 GHz routers only.</p>\r\n</div>\r\n</div>\r\n<div class=\"sectionHeaders js-hiddenFeatures\" data-selenium=\"sectionHeaders\">\r\n<div class=\"js-featureSection\" data-tickertarget=\"ov-ft-2\">\r\n<h3 class=\"featureHeader c27 fs24\">Wide-Format Printing</h3>\r\n<dl class=\"js-featureSectionDL\"><dd class=\"featuredd c28\">Print borderless professional color prints in different sizes from 3 x 5 to 13 x 19\" (76.2 x 127 to 330.2 x 482.6mm)</dd></dl><dl class=\"js-featureSectionDL\"><dd class=\"featuredd c28\">Create borderless flyers, brochures, marketing materials, and more in-house</dd></dl><dl class=\"js-featureSectionDL\"><dd class=\"featuredd c28\">Original HP inks that deliver fast-drying, water-resistant documents that stay vivid for a long time </dd></dl><dl class=\"js-featureSectionDL\"><dd class=\"featuredd c28\">Print everyday documents at a low cost per page, using high-yield black and individual color ink cartridges</dd></dl></div>\r\n<div class=\"js-featureSection\" data-tickertarget=\"ov-ft-3\">\r\n<h3 class=\"featureHeader c27 fs24\">Time Saving Features that Ease Office Tasks</h3>\r\n<dl class=\"js-featureSectionDL\"><dd class=\"featuredd c28\">Reload less often and handle high-volume printing using high-capacity ink cartridges and large paper trays</dd></dl><dl class=\"js-featureSectionDL\"><dd class=\"featuredd c28\">Preserve your space with this compact ePrinter designed to fit where you want it-close at hand or out of the way</dd></dl><dl class=\"js-featureSectionDL\"><dd class=\"featuredd c28\">Designed for volumes up to 800 pages per month</dd></dl></div>\r\n<div class=\"js-featureSection\" data-tickertarget=\"ov-ft-4\">\r\n<h3 class=\"featureHeader c27 fs24\">Connect and Print</h3>\r\n<dl class=\"js-featureSectionDL\"><dd class=\"featuredd c28\">Print wirelessly on your office network and share this HP ePrinter with other wireless-enabled PCs </dd></dl><dl class=\"js-featureSectionDL\"><dd class=\"featuredd c28\">Print from your smartphone or tablet from virtually anywhere with HP ePrint </dd></dl><dl class=\"js-featureSectionDL\"><dd class=\"featuredd c28\">Add this ePrinter to your Ethernet network to easily share it with your workgroup</dd></dl><dl class=\"js-featureSectionDL\"><dd class=\"featuredd c28\">Use the free HP ePrint app to print directly from your mobile device</dd></dl></div>\r\n<div class=\"js-featureSection\" data-tickertarget=\"ov-ft-5\">\r\n<h3 class=\"featureHeader c27 fs24\">Reduce Your Environmental Impact Without Sacrificing on Performance</h3>\r\n<dl class=\"js-featureSectionDL\"><dd class=\"featuredd c28\">ENERGY STAR qualified and rated EPEAT (Electronic Product Environmental Assessment Tool) bronze</dd></dl><dl class=\"js-featureSectionDL\"><dd class=\"featuredd c28\">Save up to 50% on paper costs using optional automatic 2-sided printing </dd></dl><dl class=\"js-featureSectionDL\"><dd class=\"featuredd c28\">Recycle HP ink cartridges for free through HP Planet Partners program </dd></dl></div>\r\n</div>'),('304',85,0,'102','HP OfficeJet 7110 Wide-Format Color ePrinter'),('305',75,0,'103','<table class=\"specTable\" data-selenium=\"specTable\">\r\n<tbody data-selenium=\"specBody\">\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Functions</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Print, scan, copy, fax with multitasking support</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<table class=\"specTable\" data-selenium=\"specTable\">\r\n<tbody data-selenium=\"specBody\">\r\n<tr><th class=\"specHeader Header\" colspan=\"2\" data-selenium=\"specHeader\"><a id=\"44168\" class=\"fs32 OpenSans-300-normal\" name=\"44168\" data-selenium=\"specHeaderLink\"></a>Printer</th></tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Printing Technology</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Laser</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Print Color</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Black</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Maximum Resolution</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">600 x 600 dpi</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Print Speed</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Up to 21 ppm, letter-sized at normal quality</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Toner Cartridge Compatibility</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">HP 83A Black LaserJet Toner Cartridge</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">First Print Out Speed</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">9.5 sec</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Duplex Printing</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Manual with driver support</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Printer Duty Cycle</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Monthly: 8,000 pages<br />Recommended Monthly: 250-2000</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Management</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">HP Device Toolbox, Status Alerts</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<table class=\"specTable\" data-selenium=\"specTable\">\r\n<tbody data-selenium=\"specBody\">\r\n<tr><th class=\"specHeader Header\" colspan=\"2\" data-selenium=\"specHeader\"><a id=\"44169\" class=\"fs32 OpenSans-300-normal\" name=\"44169\" data-selenium=\"specHeaderLink\"></a>Scanner</th></tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Scanner Type</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Flatbed, ADF</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Image Sensor</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Contact Image Sensor (CIS)</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Optical Resolution</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">1200 dpi</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Hardware Resolution</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">1200 x 1200 dpi</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Scan Speed</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\"><span>Letter-Sized</span><br />Black &amp; White: 7 ppm<br />Color: 5 ppm</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Maximum Scan Area</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\"><span>ADF:</span> 8.5 x 14.0\" (21.6 x 35.6 cm)<br /><span>Flatbed:</span> 8.5 x 11.7\" (21.6 x 29.7 cm)</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Scanner Drivers</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Twain version 1.9<br />WIA</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Scan Modes</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Via HP LaserJet scan application or TWAIN- or WIA-compliant software</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Scan File Format</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Windows: JPG, RAW (BMP), PDF, TIFF, PNG<br />Mac: TIFF, PNG, JPEG, JPEG-2000, PDF, PDF-Searchable, RTF, TXT</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Color Depth</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">24-bit</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Grayscale</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">256 levels</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Digital Sending Features</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">With HP SW: Scan to e-mail, scan to application, scan to file<br />File Formats: PDF, TIF, BMP, PNG, JPG</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<table class=\"specTable\" data-selenium=\"specTable\">\r\n<tbody data-selenium=\"specBody\">\r\n<tr><th class=\"specHeader Header\" colspan=\"2\" data-selenium=\"specHeader\"><a id=\"44171\" class=\"fs32 OpenSans-300-normal\" name=\"44171\" data-selenium=\"specHeaderLink\"></a>Copier</th></tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Maximum Resolution</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Black and White: 600 x 600 dpi<br />Color: 400 x 600 dpi</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Copy Speed</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Letter-sized, Black &amp; White: 21 cpm</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Quantity</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Up to 99</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Reduction / Enlargement</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">25-400%</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Copy Features</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Lighter/Darker, Optimize (draft, text, mixed, picture), Collation</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<table class=\"specTable\" data-selenium=\"specTable\">\r\n<tbody data-selenium=\"specBody\">\r\n<tr><th class=\"specHeader Header\" colspan=\"2\" data-selenium=\"specHeader\"><a id=\"44509\" class=\"fs32 OpenSans-300-normal\" name=\"44509\" data-selenium=\"specHeaderLink\"></a>Fax</th></tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Modem Speed</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">33.6 kbps</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Transmission Speed</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">3 sec per page</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Fax Resolution</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Best: 300 x 300 dpi<br />Standard: 203 x 98 dpi<br />Fine: 203 x 196 dpi, 256 levels of gray<br />Superfine: 300 x 300 dpi or 203 x 392 dpi, 256 levels of gray<br />Photo Grayscale: 300 x 300 dpi, halftone</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Fax Memory</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Up to 500 pages</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Speed Dial Locations</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Up to 100 numbers</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Fax Broadcasting</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">100 locations</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Fax Features</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Auto fax reduction, Auto-redialing, Fax delayed sending, Distinctive ring detection, Fax forwarding, Fax phone TAM interface, Fax polling, Junk barrier supported, PC interface, Remote retrieval capability</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<table class=\"specTable\" data-selenium=\"specTable\">\r\n<tbody data-selenium=\"specBody\">\r\n<tr><th class=\"specHeader Header\" colspan=\"2\" data-selenium=\"specHeader\"><a id=\"59530\" class=\"fs32 OpenSans-300-normal\" name=\"59530\" data-selenium=\"specHeaderLink\"></a>Paper Handling</th></tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Paper-Feed Method</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Tray or ADF</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Paper Capacity</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Tray: 150 sheets or 10 envelopes<br />ADF: 35 sheets<br />Output Tray: 100 sheets, 10 envelopes, or 75 transparencies</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Paper Types</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Plain or laserjet paper, envelopes, transparencies, labels, postcards</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Paper Sizes</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">3.0 x 5.0\" to 8.5 x 14.0\" (7.6 x 12.7 cm to 21.6 x 35.6 cm)<br />Letter, Legal, Executive, envelopes (Com #10, Monarch #7 3/4), postcards (Standard #10)</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Media Weight</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">16-43 lb (60-163 gsm)</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<table class=\"specTable\" data-selenium=\"specTable\">\r\n<tbody data-selenium=\"specBody\">\r\n<tr><th class=\"specHeader Header\" colspan=\"2\" data-selenium=\"specHeader\"><a id=\"44363\" class=\"fs32 OpenSans-300-normal\" name=\"44363\" data-selenium=\"specHeaderLink\"></a>Connectivity</th></tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Interfaces</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">USB 2.0<br />10/100Base-TX Ethernet</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Wireless Printing Features</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">HP ePrint, Apple AirPrint, Mobile Apps</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">OS Compatibility</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Windows 8 (32/64-bit), 7 (32/64-bit), Vista (32/64-bit), XP SP2 or later (32/64-bit), Server 2012, Server 2008 Standard &amp; Enterprise Editions (32/64-bit), Server 2003 SP1 or later (32/64-bit)<br />Mac OS X 10.6.8 or later<br />Linux possible with support</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Windows System Requirements</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">200 MB free hard disk space for CD and Web Package<br />400 MB free hard disk space for Smart Install<br />512 MB RAM<br />CD/DVD-ROM or Internet<br />USB or Network port</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Apple System Requirements</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">PowerPC G4, G5, or Intel Core Processor<br />500 MB free hard disk space<br />CD/DVD-ROM or Internet<br />USB or Network port</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Memory</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">128 MB</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Processor</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">600 MHz</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Fonts</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">None, host-based</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Printer Language</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">PCLm/PCLmS</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Network Protocols</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Via Built-In Networking Solution: TCP/IP, IPv4, IPv6<br />Print: LPD (raw queue support only)<br />Discovery: SLP, Bonjour, Web Services Discovery<br />IP Config: IPv4 (BootP, DHCP, AutoIP, Manual), IPv6 (Stateless Link-Local and via Router, Statefull via DHCPv6)<br />Management: SNMPv1, HTTP<br />HP ePrint</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Network Security</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Password-protected network embedded web server, SNMPv1 community password change</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<table class=\"specTable\" data-selenium=\"specTable\">\r\n<tbody data-selenium=\"specBody\">\r\n<tr><th class=\"specHeader Header\" colspan=\"2\" data-selenium=\"specHeader\"><a id=\"45092\" class=\"fs32 OpenSans-300-normal\" name=\"45092\" data-selenium=\"specHeaderLink\"></a>General Attributes</th></tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Control Panel</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Dual digit numeric LED display with 26 buttons<br />3 LED indicator lights</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Display</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">2-line LCD for text</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Power Requirements</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">110-127 VAC (±12%), 60 Hz (±3 Hz)</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Power Consumption</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Printing: 480 W<br />Copying, ADF: 186 W<br />Ready: 4.5 W<br />Sleep/Auto-Off: 1.1 W<br />Manual Off: 0.1 W</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Certifications</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">ENERGY STAR qualified</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Acoustic Noise</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Power Emissions: 6.0 B(A)<br />Power Emissions, Active Copy: 6.6 B(A)<br />Power Emissions, Active Scan: 6.2 B(A)<br />Power Emissions, Ready: Inaudible<br />Pressure Emissions Bystander, Active Copy: 52 dB(A)<br />Pressure Emissions Bystander, Active Scan: 48 dB(A)<br />Pressure Emissions Bystander, Active Printing: 49 dB(A)<br />Pressure Emissions Bystander, Ready: Inaudible</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Operating Conditions</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Temperature: 59 to 90.5°F (15 to 32.5°C)<br />Recommended Temperature: 63.5 to 77°F (17.5 to 25°C)<br />Humidity: 10-80%, relative<br />Recommended Humidity: 30-70%, relative</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Storage Conditions</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Temperature: -4 to 140°F (-20 to 60°C)<br />Humidity, Non-Operating: 10-95%, relative</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Dimensions</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">16.5 x 14.4 x 12.2\" (42.0 x 36.5 x 30.9 cm)<br />Max: 16.5 x 17.2 x 12.2\" (42.0 x 43.8 x 30.9 cm)</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Weight</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">20 lb (9.1 kg)</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<table class=\"specTable\" data-selenium=\"specTable\">\r\n<tbody data-selenium=\"specBody\">\r\n<tr><th class=\"specHeader Header\" colspan=\"2\" data-selenium=\"specHeader\"><a id=\"shipping\" class=\"fs32 OpenSans-300-normal\" name=\"shipping\" data-selenium=\"specHeaderLink\"></a>Packaging Info</th></tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Package Weight</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">24.5 lb</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Box Dimensions (LxWxH)</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">23.5 x 15.8 x 13.3\"</td>\r\n</tr>\r\n</tbody>\r\n</table>'),('306',76,0,'103','<ul class=\"top-section-list\" data-selenium=\"highlightList\">\r\n<li class=\"top-section-list-item\">Print, Scan, Copy, Fax</li>\r\n<li class=\"top-section-list-item\">Print Resolution: 600 x 600 dpi</li>\r\n<li class=\"top-section-list-item\">Print Speeds up to 21 ppm</li>\r\n<li class=\"top-section-list-item\">Scan Resolution: 1200 x 1200 dpi</li>\r\n<li class=\"top-section-list-item\">Max Scan Size: 8.5 x 14\"</li>\r\n<li class=\"top-section-list-item\">Scan Speeds up to 7 ppm</li>\r\n<li class=\"top-section-list-item\">Copy Speeds up to 21 cpm</li>\r\n<li class=\"top-section-list-item\">Fax Speed of 3 sec Per Page at 33.6 kbps</li>\r\n<li class=\"top-section-list-item\">Automatic Document Feeder: 35 Sheets</li>\r\n<li class=\"top-section-list-item\">USB 2.0 &amp; 10/100Base-TX Ethernet Ports</li>\r\n</ul>\r\n<div class=\"ov-wrapper js-overview-desc\">\r\n<div class=\"ov-desc\">\r\n<p>The <strong>HP LaserJet Pro M127fn Monochrome All-in-One Laser Printer</strong> is a fully-featured unit capable of printing, scanning, copying, and faxing. It also has both USB 2.0 and 10/100Base-TX Ethernet ports for versatile connectivity and networking options. The M127fn is a speedy printer as well, capable of printing at up to 21 pages per minute.</p>\r\n<p>The M127fn uses laser technology for producing high quality prints. It also has a maximum resolution of 600 x 600 dpi with this method and will print black &amp; white documents. This can even use either the tray or 35-sheet automatic document feeder for speed.</p>\r\n<p>Scanning can be done via the flatbed or ADF with a maximum resolution of 1200 x 1200 dpi and a maximum scan size of 8.5 x 14\". Additionally, it can scan at up to 7 pages per minute and produce copies at a rate of 21 copies per minute. Faxing is also quick with a speed of 3 seconds per page with a 33.6 kbps modem.</p>\r\n</div>\r\n</div>\r\n<div class=\"sectionHeaders js-hiddenFeatures\" data-selenium=\"sectionHeaders\"><dl class=\"js-featureSectionDL\"><dd class=\"featuredd c28\">Wireless printing capabilities with the optional HP 1200w NFC/Wireless Mobile Print Accessory</dd></dl><dl class=\"js-featureSectionDL\"><dd class=\"featuredd c28\">Support for HP ePrint, Apple AirPrint, and Mobile Apps</dd></dl><dl class=\"js-featureSectionDL\"><dd class=\"featuredd c28\">FastRes 600 and Fast Res 1200 print resolution technologies</dd></dl><dl class=\"js-featureSectionDL\"><dd class=\"featuredd c28\">All-in-One multitasking support</dd></dl><dl class=\"js-featureSectionDL\"><dd class=\"featuredd c28\">Manual duplex along with driver support</dd></dl><dl class=\"js-featureSectionDL\"><dd class=\"featuredd c28\">TWAIN and WIA-compliant</dd></dl><dl class=\"js-featureSectionDL\"><dd class=\"featuredd c28\">Smart Install gets you up-and-running immediately</dd></dl><dl class=\"js-featureSectionDL\"><dd class=\"featuredd c28\">Custom paper sizes between 3 x 5\" to 8.5 x 14\"</dd></dl><dl class=\"js-featureSectionDL\"><dd class=\"featuredd c28\">Duty cycle of 8,000 pages per month with a recommended volume of 250-2,000 pages per month</dd></dl><dl class=\"js-featureSectionDL\"><dd class=\"featuredd c28\">128 MB internal memory and 600 MHz processor</dd></dl><dl class=\"js-featureSectionDL\"><dd class=\"featuredd c28\">150-sheet input tray and 35-sheet automatic document feeder as well as 100-sheet output bin</dd></dl><dl class=\"js-featureSectionDL\"><dd class=\"featuredd c28\">Capable of holding up to 10 envelopes</dd></dl><dl class=\"js-featureSectionDL\"><dd class=\"featuredd c28\">Fax address book, LAN/Internet fax, speed dial, and TAM interface features</dd></dl><dl class=\"js-featureSectionDL\"><dd class=\"featuredd c28\">Printer management with HP Device Toolbox and Status Alerts</dd></dl><dl class=\"js-featureSectionDL\"><dd class=\"featuredd c28\">2-line LCD text display along with 26 buttons and 3 LED indicator lights on the control panel</dd></dl><dl class=\"js-featureSectionDL\"><dt class=\"featureTitle\"><strong>Software Included</strong></dt><dd class=\"c28\">Windows: HP Installer/Uninstaller, HP PCLmS print driver, HP WIA Scan Driver, HP TWAIN Scan Driver, HP Scan, HP Fax Setup Wizard, HP Send Fax, Status Alerts, HP Update, DXP<br />Mac: HP Installer/Uninstaller, HP PCLmS print driver, HP Scan, HP Setup Assistant, HP Fax Print Driver, HP Utility, HP Alerts, HP Firmware Updater</dd></dl></div>'),('307',85,0,'103','HP LaserJet Pro M127fn Monochrome Laser Printer');
INSERT INTO `catalog_product_entity_text` VALUES ('308',75,0,'104','<div class=\"additional-attributes-title\"><strong>Specifications</strong></div>\r\n<table id=\"product-attribute-specs-table\" class=\"data table additional-attributes\">\r\n<tbody>\r\n<tr class=\"group\"><th class=\"col label\" colspan=\"2\" scope=\"row\">SKU</th></tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Sku</th>\r\n<td class=\"col data\" data-th=\"sku\">F5S29B</td>\r\n</tr>\r\n<tr class=\"group\"><th class=\"col label\" colspan=\"2\" scope=\"row\">PRINT</th></tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Print speed, black</th>\r\n<td class=\"col data\" data-th=\"Print speed, black\">&lt;=10</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Color output</th>\r\n<td class=\"col data\" data-th=\"Color output\">Color</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Print speed, color</th>\r\n<td class=\"col data\" data-th=\"Print speed, color\">&lt;=10</td>\r\n</tr>\r\n<tr class=\"group\"><th class=\"col label\" colspan=\"2\" scope=\"row\">CATEGORY</th></tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Product type</th>\r\n<td class=\"col data\" data-th=\"Product type\">Inkjet printers</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Family brand</th>\r\n<td class=\"col data\" data-th=\"Family brand\">Deskjet Ink Advantage</td>\r\n</tr>\r\n<tr class=\"group\"><th class=\"col label\" colspan=\"2\" scope=\"row\">USAGE</th></tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Perfect For</th>\r\n<td class=\"col data\" data-th=\"Perfect For\">Home and home office</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Usage</th>\r\n<td class=\"col data\" data-th=\"Usage\">Home and home office</td>\r\n</tr>\r\n<tr class=\"group\"><th class=\"col label\" colspan=\"2\" scope=\"row\">FEATURES</th></tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Functions</th>\r\n<td class=\"col data\" data-th=\"Functions\">Print scan and copy</td>\r\n</tr>\r\n<tr class=\"group\"><th class=\"col label\" colspan=\"2\" scope=\"row\">PRINTING MEDIA HANDLING</th></tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Finished output handling</th>\r\n<td class=\"col data\" data-th=\"Finished output handling\">Sheetfed</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Envelope input capacity</th>\r\n<td class=\"col data\" data-th=\"Envelope input capacity\">Up to 5 envelopes</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Output capacity</th>\r\n<td class=\"col data\" data-th=\"Output capacity\">Up to 25 sheets</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Maximum output capacity (sheets)</th>\r\n<td class=\"col data\" data-th=\"Maximum output capacity (sheets)\">Up to 25 sheets</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Paper handling input, standard</th>\r\n<td class=\"col data\" data-th=\"Paper handling input, standard\">60-sheet input tray</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Paper handling input, optional</th>\r\n<td class=\"col data\" data-th=\"Paper handling input, optional\">Not Applicable</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Input capacity</th>\r\n<td class=\"col data\" data-th=\"Input capacity\">Up to 60 sheets</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Paper handling output, standard</th>\r\n<td class=\"col data\" data-th=\"Paper handling output, standard\">25-sheet output tray</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Standard output capacity (envelopes)</th>\r\n<td class=\"col data\" data-th=\"Standard output capacity (envelopes)\">Up to 5 envelopes</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Maximum input capacity (sheets)</th>\r\n<td class=\"col data\" data-th=\"Maximum input capacity (sheets)\">Up to 60 sheets</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Paper handling output, optional</th>\r\n<td class=\"col data\" data-th=\"Paper handling output, optional\">Not Applicable</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Standard input capacity (envelopes)</th>\r\n<td class=\"col data\" data-th=\"Standard input capacity (envelopes)\">Up to 5</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Maximum input capacity (transparencies)</th>\r\n<td class=\"col data\" data-th=\"Maximum input capacity (transparencies)\">Not Applicable</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Maximum input capacity (cards)</th>\r\n<td class=\"col data\" data-th=\"Maximum input capacity (cards)\">Up to 20 cards</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Maximum input capacity (10x15cm photos)</th>\r\n<td class=\"col data\" data-th=\"Maximum input capacity (10x15cm photos)\">Up to 20 sheets</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Standard output capacity (legal)</th>\r\n<td class=\"col data\" data-th=\"Standard output capacity (legal)\">Up to 25 sheets</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Maximum input capacity (photo paper)</th>\r\n<td class=\"col data\" data-th=\"Maximum input capacity (photo paper)\">Up to 20 sheets</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Maximum input capacity (4x6 photo)</th>\r\n<td class=\"col data\" data-th=\"Maximum input capacity (4x6 photo)\">Up to 20 sheets</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Standard input capacity (legal)</th>\r\n<td class=\"col data\" data-th=\"Standard input capacity (legal)\">Up to 60 sheets</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Standard input capacity (cards)</th>\r\n<td class=\"col data\" data-th=\"Standard input capacity (cards)\">Up to 20 cards</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Maximum input capacity (labels)</th>\r\n<td class=\"col data\" data-th=\"Maximum input capacity (labels)\">Up to 10 sheets</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Maximum output capacity (photo paper)</th>\r\n<td class=\"col data\" data-th=\"Maximum output capacity (photo paper)\">Up to 20 sheets</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Maximum output capacity (cards)</th>\r\n<td class=\"col data\" data-th=\"Maximum output capacity (cards)\">Up to 20 cards</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Standard input capacity (transparencies)</th>\r\n<td class=\"col data\" data-th=\"Standard input capacity (transparencies)\">Not Applicable</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Standard output capacity (cards)</th>\r\n<td class=\"col data\" data-th=\"Standard output capacity (cards)\">Up to 20 cards</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Standard output capacity (labels)</th>\r\n<td class=\"col data\" data-th=\"Standard output capacity (labels)\">Up to 10 sheets</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Maximum output capacity (labels)</th>\r\n<td class=\"col data\" data-th=\"Maximum output capacity (labels)\">Up to 10 sheets</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Maximum output capacity (envelopes)</th>\r\n<td class=\"col data\" data-th=\"Maximum output capacity (envelopes)\">Up to 5 envelopes</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Standard input capacity (secondary tray)</th>\r\n<td class=\"col data\" data-th=\"Standard input capacity (secondary tray)\">Not Applicable</td>\r\n</tr>\r\n<tr class=\"group\"><th class=\"col label\" colspan=\"2\" scope=\"row\">DISPLAY SPECIFICATIONS</th></tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Display</th>\r\n<td class=\"col data\" data-th=\"Display\">None</td>\r\n</tr>\r\n<tr class=\"group\"><th class=\"col label\" colspan=\"2\" scope=\"row\">CARTRIDGES AND PRINTHEADS</th></tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Technology</th>\r\n<td class=\"col data\" data-th=\"Technology\">Ink</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Number of print cartridges</th>\r\n<td class=\"col data\" data-th=\"Number of print cartridges\">2 (1 black, 1 Tri-color)</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Ink types</th>\r\n<td class=\"col data\" data-th=\"Ink types\">Dye-based (color); pigment-based (black)</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Print heads</th>\r\n<td class=\"col data\" data-th=\"Print heads\">2 (1 black, 1 Tri-color [cyan, magenta, yellow])</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Color(s) of printing supplies</th>\r\n<td class=\"col data\" data-th=\"Color(s) of printing supplies\">Black, cyan, magenta, yellow</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Print head nozzles</th>\r\n<td class=\"col data\" data-th=\"Print head nozzles\">328 (Black), 588 (Tri-color)</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Replacement cartridges</th>\r\n<td class=\"col data\" data-th=\"Replacement cartridges\">HP 680 Black Ink Cartridge (~480 pages); HP 680 Tri-color Ink Cartridge (~150 pages)</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Print colors maximum</th>\r\n<td class=\"col data\" data-th=\"Print colors maximum\">4</td>\r\n</tr>\r\n<tr class=\"group\"><th class=\"col label\" colspan=\"2\" scope=\"row\">PRINT SPEED</th></tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Print speed black (normal, letter)</th>\r\n<td class=\"col data\" data-th=\"Print speed black (normal, letter)\">Up to 7.5 ppm</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Print speed black (normal, A4)</th>\r\n<td class=\"col data\" data-th=\"Print speed black (normal, A4)\">Up to 7.5 ppm</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Print speed black (draft, A4)</th>\r\n<td class=\"col data\" data-th=\"Print speed black (draft, A4)\">Up to 20 ppm</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Print speed colour (normal, A4)</th>\r\n<td class=\"col data\" data-th=\"Print speed colour (normal, A4)\">Up to 5.5 ppm</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Print speed</th>\r\n<td class=\"col data\" data-th=\"Print speed\">Print speed up to 7.5 ppm (black) and 5.5 ppm (color)</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Print speed color (normal, letter)</th>\r\n<td class=\"col data\" data-th=\"Print speed color (normal, letter)\">Up to 5.5 ppm</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Print speed colour (draft, 10x15 photo)</th>\r\n<td class=\"col data\" data-th=\"Print speed colour (draft, 10x15 photo)\">Up to 16 ppm</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Print speed colour (normal, 4x6 photo)</th>\r\n<td class=\"col data\" data-th=\"Print speed colour (normal, 4x6 photo)\">As fast as 66 sec</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Print speed colour (draft, A4)</th>\r\n<td class=\"col data\" data-th=\"Print speed colour (draft, A4)\">Up to 16 ppm</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Print speed black (ISO)</th>\r\n<td class=\"col data\" data-th=\"Print speed black (ISO)\">Up to 7.5 ppm</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Print speed color (ISO)</th>\r\n<td class=\"col data\" data-th=\"Print speed color (ISO)\">Up to 5.5 ppm</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Print speed black (draft, letter)</th>\r\n<td class=\"col data\" data-th=\"Print speed black (draft, letter)\">Up to 20 ppm</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Print speed color (draft, letter)</th>\r\n<td class=\"col data\" data-th=\"Print speed color (draft, letter)\">Up to 16 ppm</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Print speed colour (normal, 10x15 photo)</th>\r\n<td class=\"col data\" data-th=\"Print speed colour (normal, 10x15 photo)\">As fast as 66 sec</td>\r\n</tr>\r\n<tr class=\"group\"><th class=\"col label\" colspan=\"2\" scope=\"row\">BATTERY AND POWER</th></tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Power</th>\r\n<td class=\"col data\" data-th=\"Power\">Input voltage: 100 to 240 VAC (+/- 10%), 50/60 Hz (+/- 3 Hz). Input voltage: 200 to 240 VAC (+/- 10%), 50/60 Hz (+/- 3Hz) (China &amp; India)</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Power consumption</th>\r\n<td class=\"col data\" data-th=\"Power consumption\">10 watts maximum, 10 watts (Active), 0.1 watts (Off), 1.9 watts (Standby), 0.9 watt (Sleep)</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Power supply type</th>\r\n<td class=\"col data\" data-th=\"Power supply type\">Internal</td>\r\n</tr>\r\n<tr class=\"group\"><th class=\"col label\" colspan=\"2\" scope=\"row\">PRINT TIME</th></tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">First page out black (letter, ready)</th>\r\n<td class=\"col data\" data-th=\"First page out black (letter, ready)\">As fast as 15 sec</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">First page out black (A4, ready)</th>\r\n<td class=\"col data\" data-th=\"First page out black (A4, ready)\">As fast as 15 sec</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">First page out color (A4, ready)</th>\r\n<td class=\"col data\" data-th=\"First page out color (A4, ready)\">As fast as 18 sec</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">First page out color (letter, ready)</th>\r\n<td class=\"col data\" data-th=\"First page out color (letter, ready)\">As fast as 18 sec</td>\r\n</tr>\r\n<tr class=\"group\"><th class=\"col label\" colspan=\"2\" scope=\"row\">PRINTER SPECIFICATIONS</th></tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Storage device and direct print support</th>\r\n<td class=\"col data\" data-th=\"Storage device and direct print support\">Storage devices not supported</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Duty cycle (monthly, letter)</th>\r\n<td class=\"col data\" data-th=\"Duty cycle (monthly, letter)\">Up to 1000 pages</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Functions</th>\r\n<td class=\"col data\" data-th=\"Functions\">Print, copy, scan</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Paper trays, maximum</th>\r\n<td class=\"col data\" data-th=\"Paper trays, maximum\">1</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Duty cycle (monthly, A4)</th>\r\n<td class=\"col data\" data-th=\"Duty cycle (monthly, A4)\">Up to 1000 pages</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Paper trays, standard</th>\r\n<td class=\"col data\" data-th=\"Paper trays, standard\">1</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Recommended monthly page volume</th>\r\n<td class=\"col data\" data-th=\"Recommended monthly page volume\">50 to 200</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Print technology</th>\r\n<td class=\"col data\" data-th=\"Print technology\">HP Thermal Inkjet</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Duplex printing</th>\r\n<td class=\"col data\" data-th=\"Duplex printing\">Manual (driver support provided)</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Print colours</th>\r\n<td class=\"col data\" data-th=\"Print colours\">Yes</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Top key features</th>\r\n<td class=\"col data\" data-th=\"Top key features\">Scan to PDF</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Target user and print volume</th>\r\n<td class=\"col data\" data-th=\"Target user and print volume\">For teams up to 3 users; Prints up to 200 pages/month</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Vertical alignment accuracy</th>\r\n<td class=\"col data\" data-th=\"Vertical alignment accuracy\">0.042 mm</td>\r\n</tr>\r\n<tr class=\"group\"><th class=\"col label\" colspan=\"2\" scope=\"row\">CERTIFICATION AND COMPLIANCE</th></tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">ENERGY STAR® certified</th>\r\n<td class=\"col data\" data-th=\"ENERGY STAR® certified\">Yes</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Energy efficiency</th>\r\n<td class=\"col data\" data-th=\"Energy efficiency\">ENERGY STAR® qualified</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Safety</th>\r\n<td class=\"col data\" data-th=\"Safety\">IEC 60950-1: 2005 (2nd ed.)/EN 60950-1: 2006; Compliance CE Marking to LVD 2006/95/EC; EC recommendation 1999/519/EC; EN 62479: 2010 (Europe), NOM 019-SCFI-1993 (Mexico), CCC Certified GB4943.1-2011 (CCC S&amp;E -China); CNS 14336: 1999 &amp; CNS13438 (BSMI-Taiwan); EAC (Russia), Mexico NOM-1-NYCE.</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Environmental</th>\r\n<td class=\"col data\" data-th=\"Environmental\">None</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Compliance alliances</th>\r\n<td class=\"col data\" data-th=\"Compliance alliances\">None</td>\r\n</tr>\r\n<tr class=\"group\"><th class=\"col label\" colspan=\"2\" scope=\"row\">GEOGRAPHIC</th></tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Country of origin</th>\r\n<td class=\"col data\" data-th=\"Country of origin\">Made in China</td>\r\n</tr>\r\n<tr class=\"group\"><th class=\"col label\" colspan=\"2\" scope=\"row\">WARRANTY</th></tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Warranty</th>\r\n<td class=\"col data\" data-th=\"Warranty\">1 Year Limited Warranty (Return to HP/Dealer - Unit Exchange)</td>\r\n</tr>\r\n<tr class=\"group\"><th class=\"col label\" colspan=\"2\" scope=\"row\">DIMENSIONS</th></tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Minimum dimensions (W x D x H)</th>\r\n<td class=\"col data\" data-th=\"Minimum dimensions (W x D x H)\">425 x 304 x 149 mm</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Package dimensions (W x D x H)</th>\r\n<td class=\"col data\" data-th=\"Package dimensions (W x D x H)\">475 x 191 x 354 mm</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Maximum dimensions (W x D x H)</th>\r\n<td class=\"col data\" data-th=\"Maximum dimensions (W x D x H)\">424.97 x 519.36 x 248.77 mm (with Input &amp; Output Tray/Extension extended)</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Dimensions with trays up (W x D x H)</th>\r\n<td class=\"col data\" data-th=\"Dimensions with trays up (W x D x H)\">424.97 x 304.32 x 151.08 mm (L*W*H)</td>\r\n</tr>\r\n<tr class=\"group\"><th class=\"col label\" colspan=\"2\" scope=\"row\">WEIGHTS</th></tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Weight</th>\r\n<td class=\"col data\" data-th=\"Weight\">3.42 kg</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Package weight</th>\r\n<td class=\"col data\" data-th=\"Package weight\">4.48 kg</td>\r\n</tr>\r\n<tr class=\"group\"><th class=\"col label\" colspan=\"2\" scope=\"row\">CONNECTIVITY AND COMMUNICATIONS</th></tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Network ready</th>\r\n<td class=\"col data\" data-th=\"Network ready\">None</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Connectivity, standard</th>\r\n<td class=\"col data\" data-th=\"Connectivity, standard\">1 Hi-Speed USB 2.0</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Network capabilities</th>\r\n<td class=\"col data\" data-th=\"Network capabilities\">None</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Mobile printing capability</th>\r\n<td class=\"col data\" data-th=\"Mobile printing capability\">Mobile Print Capability not supported</td>\r\n</tr>\r\n<tr class=\"group\"><th class=\"col label\" colspan=\"2\" scope=\"row\">SYSTEM COMPONENTS</th></tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Control panel</th>\r\n<td class=\"col data\" data-th=\"Control panel\">Button LED</td>\r\n</tr>\r\n<tr class=\"group\"><th class=\"col label\" colspan=\"2\" scope=\"row\">SCAN RESOLUTION</th></tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Scan resolution, hardware</th>\r\n<td class=\"col data\" data-th=\"Scan resolution, hardware\">Up to 1200 x 1200 dpi</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Scan resolution, optical</th>\r\n<td class=\"col data\" data-th=\"Scan resolution, optical\">Up to 1200 dpi</td>\r\n</tr>\r\n<tr class=\"group\"><th class=\"col label\" colspan=\"2\" scope=\"row\">MEMORY</th></tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Memory, standard</th>\r\n<td class=\"col data\" data-th=\"Memory, standard\">Integrated memory</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Memory, maximum</th>\r\n<td class=\"col data\" data-th=\"Memory, maximum\">Integrated memory</td>\r\n</tr>\r\n<tr class=\"group\"><th class=\"col label\" colspan=\"2\" scope=\"row\">BOX CONTENTS</th></tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Cable included</th>\r\n<td class=\"col data\" data-th=\"Cable included\">Yes, 1.5 m USB cable</td>\r\n</tr>\r\n<tr class=\"group\"><th class=\"col label\" colspan=\"2\" scope=\"row\">SUPPORTED PRINTING MEDIA</th></tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Media sizes supported</th>\r\n<td class=\"col data\" data-th=\"Media sizes supported\">A4; B5; A6; DL envelope</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Standard media sizes (duplex)</th>\r\n<td class=\"col data\" data-th=\"Standard media sizes (duplex)\">Not Applicable</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Media weight, supported</th>\r\n<td class=\"col data\" data-th=\"Media weight, supported\">A4: 60 to 90 g/m²; HP envelopes: 75 to 90 g/m²; HP cards: up to 200 g/m²; HP 10 x 15 cm photo paper: up to 300 g/m²</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Media types</th>\r\n<td class=\"col data\" data-th=\"Media types\">Plain paper, Photo paper, Brochure paper</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Media sizes, custom</th>\r\n<td class=\"col data\" data-th=\"Media sizes, custom\">89 x 127 to 215 x 279 mm</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Media weight, recommended</th>\r\n<td class=\"col data\" data-th=\"Media weight, recommended\">75 g/m²</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Media sizes supported, key</th>\r\n<td class=\"col data\" data-th=\"Media sizes supported, key\">4 x 6 in; Letter; Legal; Envelopes</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Media sizes supported, key</th>\r\n<td class=\"col data\" data-th=\"Media sizes supported, key\">10 x 15 cm; A4; Envelopes</td>\r\n</tr>\r\n<tr class=\"group\"><th class=\"col label\" colspan=\"2\" scope=\"row\">SYSTEM REQUIREMENTS</th></tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Minimum system requirements for Macintosh</th>\r\n<td class=\"col data\" data-th=\"Minimum system requirements for Macintosh\">OS X v10.8 Mountain Lion, OS X v10.9 Mavericks, OS X v10.10 Yosemite; 1 GB HD; Internet; USB</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Minimum system requirements</th>\r\n<td class=\"col data\" data-th=\"Minimum system requirements\">Windows 10, 8.1, 8, 7: 1 GHz 32-bit (x86) or 64-bit (x64) processor, 2 GB available hard disk space, CD-ROM/DVD drive or Internet connection, USB port, Microsoft® Internet Explorer. Windows Vista: 800 MHz 32-bit (x86) or 64-bit (x64) processor, 2 GB available hard disk space, CD-ROM/DVD drive or Internet connection, USB port, Internet Explorer 8. Windows XP SP3 or higher (32-bit only): any Intel® Pentium® II, Celeron® or 233 MHz compatible processor ,850 MB available hard disk space, CD-ROM/DVD drive or Internet connection, USB port, Internet Explorer 8.</td>\r\n</tr>\r\n<tr class=\"group\"><th class=\"col label\" colspan=\"2\" scope=\"row\">SOFTWARE AND APPLICATIONS</th></tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Mac compatible</th>\r\n<td class=\"col data\" data-th=\"Mac compatible\">Yes</td>\r\n</tr>\r\n<tr class=\"group\"><th class=\"col label\" colspan=\"2\" scope=\"row\">ENVIRONMENTAL</th></tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Acoustic pressure emissions</th>\r\n<td class=\"col data\" data-th=\"Acoustic pressure emissions\">48 dB(A)</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Recommended operating temperature range</th>\r\n<td class=\"col data\" data-th=\"Recommended operating temperature range\">15 to 30ºC</td>\r\n</tr>\r\n<tr class=\"group\"><th class=\"col label\" colspan=\"2\" scope=\"row\">SUPPORTED OPERATING SYSTEMS</th></tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Compatible operating systems</th>\r\n<td class=\"col data\" data-th=\"Compatible operating systems\">Windows 10, Windows 8.1, Windows 8, Windows 7; OS X v10.8 Mountain Lion, OS X v10.9 Mavericks, OS X v10.10 Yosemite</td>\r\n</tr>\r\n<tr class=\"group\"><th class=\"col label\" colspan=\"2\" scope=\"row\">PRINT RESOLUTION</th></tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Print quality black (best)</th>\r\n<td class=\"col data\" data-th=\"Print quality black (best)\">Up to 1200 x 1200 rendered dpi</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Print quality color (best)</th>\r\n<td class=\"col data\" data-th=\"Print quality color (best)\">Up to 4800 x 1200 optimized dpi color (when printing from a computer on selected HP photo papers and 1200 input dpi)</td>\r\n</tr>\r\n<tr class=\"group\"><th class=\"col label\" colspan=\"2\" scope=\"row\">RACK AND POWER SPECIFICATIONS</th></tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Number of users</th>\r\n<td class=\"col data\" data-th=\"Number of users\">1-3 Users</td>\r\n</tr>\r\n<tr class=\"group\"><th class=\"col label\" colspan=\"2\" scope=\"row\">PRINT AREA</th></tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Maximum print area</th>\r\n<td class=\"col data\" data-th=\"Maximum print area\">215 x 355 mm</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Right margin (A4)</th>\r\n<td class=\"col data\" data-th=\"Right margin (A4)\">3 mm</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Top margin (A4)</th>\r\n<td class=\"col data\" data-th=\"Top margin (A4)\">3 mm</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Bottom margin (A4)</th>\r\n<td class=\"col data\" data-th=\"Bottom margin (A4)\">14.5 mm</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Left margin (A4)</th>\r\n<td class=\"col data\" data-th=\"Left margin (A4)\">3 mm</td>\r\n</tr>\r\n<tr class=\"group\"><th class=\"col label\" colspan=\"2\" scope=\"row\">ADVANCED FEATURES</th></tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Printer smart software features</th>\r\n<td class=\"col data\" data-th=\"Printer smart software features\">Manual Duplex</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Fax smart software features</th>\r\n<td class=\"col data\" data-th=\"Fax smart software features\">No Fax</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Energy savings feature technology</th>\r\n<td class=\"col data\" data-th=\"Energy savings feature technology\">HP Auto-Off Technology</td>\r\n</tr>\r\n<tr class=\"group\"><th class=\"col label\" colspan=\"2\" scope=\"row\">SCANNER SPECIFICATIONS</th></tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Scan file format</th>\r\n<td class=\"col data\" data-th=\"Scan file format\">JPEG, TIFF, PDF, BMP, PNG</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Color scanning</th>\r\n<td class=\"col data\" data-th=\"Color scanning\">Yes</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Automatic document feeder capacity</th>\r\n<td class=\"col data\" data-th=\"Automatic document feeder capacity\">Not Applicable</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Scanner type</th>\r\n<td class=\"col data\" data-th=\"Scanner type\">Flatbed</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Scan size, maximum</th>\r\n<td class=\"col data\" data-th=\"Scan size, maximum\">216 x 297 mm</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Levels of grayscale</th>\r\n<td class=\"col data\" data-th=\"Levels of grayscale\">256</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Scan input modes</th>\r\n<td class=\"col data\" data-th=\"Scan input modes\">Front-panel scan</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Bit depth</th>\r\n<td class=\"col data\" data-th=\"Bit depth\">24-bit</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Twain version</th>\r\n<td class=\"col data\" data-th=\"Twain version\">Version 1.9</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Scan technology</th>\r\n<td class=\"col data\" data-th=\"Scan technology\">Contact Image Sensor (CIS)</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Scanning options (ADF)</th>\r\n<td class=\"col data\" data-th=\"Scanning options (ADF)\">Not Applicable</td>\r\n</tr>\r\n<tr class=\"group\"><th class=\"col label\" colspan=\"2\" scope=\"row\">COPIER SPECIFICATIONS</th></tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Copies, maximum</th>\r\n<td class=\"col data\" data-th=\"Copies, maximum\">Up to 9 copies</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Copier settings</th>\r\n<td class=\"col data\" data-th=\"Copier settings\">Auto-enlarge</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Colour copy capability</th>\r\n<td class=\"col data\" data-th=\"Colour copy capability\">Yes</td>\r\n</tr>\r\n<tr class=\"group\"><th class=\"col label\" colspan=\"2\" scope=\"row\">COMPATIBILITY</th></tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Accessories</th>\r\n<td class=\"col data\" data-th=\"Accessories\">None</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Orderable supplies</th>\r\n<td class=\"col data\" data-th=\"Orderable supplies\">HP 680 Black Ink Cartridge (~480 pages); HP 680 Tri-color Ink Cartridge (~150 pages)</td>\r\n</tr>\r\n<tr class=\"group\"><th class=\"col label\" colspan=\"2\" scope=\"row\">PRODUCT NAMES</th></tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Sub-brand name</th>\r\n<td class=\"col data\" data-th=\"Sub-brand name\">Deskjet Ink Advantage</td>\r\n</tr>\r\n<tr class=\"group\"><th class=\"col label\" colspan=\"2\" scope=\"row\">COPY SPEED</th></tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Copy speed color (ISO)</th>\r\n<td class=\"col data\" data-th=\"Copy speed color (ISO)\">Up to 3 cpm</td>\r\n</tr>\r\n<tr class=\"item\"><th class=\"col label\" scope=\"row\">Copy speed black (ISO)</th>\r\n<td class=\"col data\" data-th=\"Copy speed black (ISO)\">Up to 5 cpm</td>\r\n</tr>\r\n</tbody>\r\n</table>'),('309',76,0,'104','<div class=\"block widget block-container block-key-selling-points\">\r\n<div class=\"block-content\">\r\n<h4>Print affordably with a reliable all-in-one—and count on consistent, high-quality results with Original HP ink cartridges.</h4>\r\n<p>Print all the quality photos and documents you need for a great value with HP’s lowest-priced ink cartridges.</p>\r\n<h4>Simplify your day. Print, scan, and copy with ease—and tackle more everyday tasks than you ever have before.</h4>\r\n<p>Count on easy versatility. Print, scan, and copy what you need quickly with a reliable all-in-one.</p>\r\n<h4>Accomplish more—right out of the box. Avoid hassles and take on everyday tasks with a straightforward all-in-one you can set up in a snap—wherever you need it.</h4>\r\n<p>Get started in fewer steps. Easily set up this all-in-one to print, scan, and copy with simple controls.</p>\r\n</div>\r\n</div>\r\n<div class=\"block widget block-container product-desc-features block-desc-feature\">\r\n<div class=\"block-content\">\r\n<ul>\r\n<li class=\"aiofunctions\">Functions: Print, copy, scan</li>\r\n<li class=\"prntspdblkmaxa4\">Print Speed (Black): Up to 20 ppm</li>\r\n<li class=\"facet_connect\">USB</li>\r\n<li class=\"facet_feat\">Scan to PDF</li>\r\n</ul>\r\n</div>\r\n</div>'),('310',85,0,'104','HP DeskJet Ink Advantage 2135 All-in-One Printer'),('311',75,0,'105','<div class=\"h2-title new-page-width c45\">\r\n<table class=\"specTable\" style=\"font-size: 12px;\" data-selenium=\"specTable\">\r\n<tbody data-selenium=\"specBody\">\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Functions</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Print</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n<div class=\"leftPanel\">\r\n<div class=\"specWrapper\" data-selenium=\"specWrapper\">\r\n<table class=\"specTable\" data-selenium=\"specTable\">\r\n<tbody data-selenium=\"specBody\">\r\n<tr><th class=\"specHeader Header\" colspan=\"2\" data-selenium=\"specHeader\"><a id=\"44168\" class=\"fs32 OpenSans-300-normal\" name=\"44168\" data-selenium=\"specHeaderLink\"></a>Printer</th></tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Printing Technology</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Laser</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Maximum Resolution</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">600 x 600 dpi</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Print Speed</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">23 ppm</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">First Print Out Speed</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">7.3 seconds</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Duplex Printing</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Manual</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Ink Palette</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Black</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Ink Cartridge Configuration</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">1 individual cartridge</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Duty Cycle</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Monthly: 10,000 pages<br />Recommended Monthly Volume: 150-1,500 pages</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Printer Language</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">PCLmS<br />WRF<br />PWG</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<table class=\"specTable\" data-selenium=\"specTable\">\r\n<tbody data-selenium=\"specBody\">\r\n<tr><th class=\"specHeader Header\" colspan=\"2\" data-selenium=\"specHeader\"><a id=\"81701\" class=\"fs32 OpenSans-300-normal\" name=\"81701\" data-selenium=\"specHeaderLink\"></a>Media Handling</th></tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Paper Handling</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Input tray<br />Priority tray<br />Output tray</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Paper Sizes</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">3 x 5\" to 8.5 x 14\" / 7.6 x 12.7 cm to 21.6 x 35.6 cm</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Paper Weight</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">16-43 lb</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Paper Capacity</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Input Tray: 150 sheets<br />Priority Tray: 10 sheets<br />Output Tray: 100 sheets</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Special Media Support</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Envelopes</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<table class=\"specTable\" data-selenium=\"specTable\">\r\n<tbody data-selenium=\"specBody\">\r\n<tr><th class=\"specHeader Header\" colspan=\"2\" data-selenium=\"specHeader\"><a id=\"44363\" class=\"fs32 OpenSans-300-normal\" name=\"44363\" data-selenium=\"specHeaderLink\"></a>Connectivity</th></tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Interface</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">USB 2.0<br />Wi-Fi</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Processor</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">600 MHz</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Memory</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">128 MB</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Compatible Operating Systems</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Windows<br />Mac OS X<br />Linux</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<table class=\"specTable\" data-selenium=\"specTable\">\r\n<tbody data-selenium=\"specBody\">\r\n<tr><th class=\"specHeader Header\" colspan=\"2\" data-selenium=\"specHeader\"><a id=\"44123\" class=\"fs32 OpenSans-300-normal\" name=\"44123\" data-selenium=\"specHeaderLink\"></a>Physical</th></tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Control Panel</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Button LED</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Acoustic Noise</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Power Emissions: 6.5 B(A)<br />Pressure Emissions: 51 dB(A)</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Power Requirements</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">110-127 VAC (±10%), 50/60 Hz, 4.6 A</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Power Consumption</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Maximum: 380 W<br />Ready: 1.7 W<br />Sleep: 0.5 W<br />Off: 0.06 W</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Operating Conditions</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Temperature: 59 to 90.5°F / 15 to 32.5°C<br />Humidity: 10 to 80%<br />Recommended Temperature: 63.5 to 77°F / 17.5 to 25°C<br />Recommended Humidity: 30 to 70%</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Storage Conditions</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Temperature: -4 to 140°F / -20 to 60°C<br />Humidity: 10 to 90%</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Dimensions (WxDxH)</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">14.4 x 9.7 x 7.5\" / 36.5 x 24.7 x 19.1 cm<br />Maximum: 14.4 x 18.4 x 13.1\" / 36.5 x 46.7 x 33.2 cm</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Weight</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">10.4 lb / 4.7 kg</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<table class=\"specTable\" data-selenium=\"specTable\">\r\n<tbody data-selenium=\"specBody\">\r\n<tr><th class=\"specHeader Header\" colspan=\"2\" data-selenium=\"specHeader\"><a id=\"shipping\" class=\"fs32 OpenSans-300-normal\" name=\"shipping\" data-selenium=\"specHeaderLink\"></a>Packaging Info</th></tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Package Weight</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">14.5 lb</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Box Dimensions (LxWxH)</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">15.6 x 11.5 x 9.8\"</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n</div>\r\n</div>'),('312',76,0,'105','<ul class=\"top-section-list\" data-selenium=\"highlightList\">\r\n<li class=\"top-section-list-item\">Print Resolution: 600 x 600 dpi</li>\r\n<li class=\"top-section-list-item\">Maximum Print Size: 8.5 x 14\"</li>\r\n<li class=\"top-section-list-item\">Minimum Print Size: 3 x 5\"</li>\r\n<li class=\"top-section-list-item\">Print Speed: 23 ppm</li>\r\n<li class=\"top-section-list-item\">First Print Out Time: 7.3 Seconds</li>\r\n<li class=\"top-section-list-item\">Mobile Printing Capability</li>\r\n<li class=\"top-section-list-item\">Button LED Control Panel</li>\r\n<li class=\"top-section-list-item\">150-Sheet Input &amp; 10-Sheet Priority Tray</li>\r\n<li class=\"top-section-list-item\">Monthly Duty Cycle: 10,000 Pages</li>\r\n<li class=\"top-section-list-item\">USB 2.0 and Wi-Fi Connectivity</li>\r\n</ul>\r\n<div class=\"ov-wrapper js-overview-desc\">\r\n<div class=\"ov-desc\">\r\n<p>Simplify your setup with the compact and wireless <strong>LaserJet Pro M102w Monochrome Laser Printer from HP</strong> for rapidly creating sharp documents at up to 23 ppm with a first print out speed of 7.3 seconds. The quality comes from FastRes technology, which can boost the 600 x 600 dpi resolution to effectively 1200 dpi. Also, it features both a 150-sheet input tray and a 10-sheet priority slot for handling media from 3 x 5\" to 8.5 x 14\". Bumping up the usability is the implementation of Wi-Fi, in addition to USB 2.0, for connecting directly to computers and mobile devices. Additionally, it features a simple button LED control panel and features a monthly duty cycle of 10,000 pages.</p>\r\n</div>\r\n</div>\r\n<div class=\"sectionHeaders js-hiddenFeatures\" data-selenium=\"sectionHeaders\"><dl class=\"js-featureSectionDL\"><dd class=\"featuredd c28\">HP Auto-On/Auto-Off Technology will help save energy when the printer is not in use.</dd></dl><dl class=\"js-featureSectionDL\"><dd class=\"featuredd c28\">Print wirelessly from a mobile device or computer thanks to built-in support for Apple AirPrint, Google Cloud Print 2.0, Mopria, and Wi-Fi Direct.</dd></dl></div>'),('313',85,0,'105','HP LaserJet Pro M102w Monochrome Laser Printer'),('314',75,0,'106','<table class=\"specTable\" data-selenium=\"specTable\">\r\n<tbody data-selenium=\"specBody\">\r\n<tr><th class=\"specHeader Header\" colspan=\"2\" data-selenium=\"specHeader\"><a id=\"44369\" class=\"fs32 OpenSans-300-normal\" name=\"44369\" data-selenium=\"specHeaderLink\"></a>Performance</th></tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Printing Technology</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Laser</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Maximum Resolution</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">1200 x 1200 dpi</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Print Speed</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Simplex: 30 ppm<br />Duplex: 18 ppm</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">First Print Out Speed</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">6.6 sec</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Print Color</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Black</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Duplex Printing</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Automatic</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Printer Duty Cycle</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Monthly: 30,000 pages<br />Recommended Monthly Volume: 250-2,500 pages</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<table class=\"specTable\" data-selenium=\"specTable\">\r\n<tbody data-selenium=\"specBody\">\r\n<tr><th class=\"specHeader Header\" colspan=\"2\" data-selenium=\"specHeader\"><a id=\"81701\" class=\"fs32 OpenSans-300-normal\" name=\"81701\" data-selenium=\"specHeaderLink\"></a>Media Handling</th></tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Paper Handling</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Input tray<br />Priority tray<br />Output bin</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Paper Types</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Paper (laser, plain, photo, rough, vellum), envelopes, labels, cardstock, postcards</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Paper Sizes</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">3 x 5\" to 8.5 x 14\" / 7.6 x 12.7 cm to 21.6 x 35.6 cm</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Media Weight</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">16-43 lb</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Paper Capacity</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Input Tray: 250 sheets<br />Priority Tray: 10 sheets<br />Output Bin: 150 sheets</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<table class=\"specTable\" data-selenium=\"specTable\">\r\n<tbody data-selenium=\"specBody\">\r\n<tr><th class=\"specHeader Header\" colspan=\"2\" data-selenium=\"specHeader\"><a id=\"44363\" class=\"fs32 OpenSans-300-normal\" name=\"44363\" data-selenium=\"specHeaderLink\"></a>Connectivity</th></tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Interface</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">USB 2.0<br />Ethernet<br />Wi-Fi</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">OS Compatibility</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Windows 10, 8.1, 8, 7, Vista, XP SP3<br />Mac OS X 10.9-10.11<br />Linux</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Mobile Printing Features</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">HP ePrint, Wi-Fi Direct, Apple AirPrint 1.5, Google Cloud Print 2.0</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Processor</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">800 MHz</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Memory</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">256 MB</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Printer Language</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">HP PCL 6, PCL 5c, PS, PCLm, PDF, URF, PWG</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Fonts</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">84 TrueType fonts, scalable</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<table class=\"specTable\" data-selenium=\"specTable\">\r\n<tbody data-selenium=\"specBody\">\r\n<tr><th class=\"specHeader Header\" colspan=\"2\" data-selenium=\"specHeader\"><a id=\"45092\" class=\"fs32 OpenSans-300-normal\" name=\"45092\" data-selenium=\"specHeaderLink\"></a>General Attributes</th></tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Power Requirements</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">100-127 VAC (±10%), 50/60 Hz, 5.4 A</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Power Consumption</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Printing: 480 W<br />Ready: 1.9 W<br />Sleep: 0.5 W<br />Manual Off: 0.05 W<br />Auto-Off/Wake on USB: 0.8 W<br />Auto-Off/Manual On: 0.05 W</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Typical Power Consumption</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">0.8 kWh/week</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Certifications</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">ENERGY STAR certified<br />Blue Angel<br />EPEAT Silver</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Operating Conditions</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Temperature: 59 to 90.5°F / 15 to 32.5°C<br />Humidity: 30 to 70% relative</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Dimensions</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">14.6 x 16.0 x 8.8\" / 37.1 x 40.6 x 22.4 cm<br />Maximum: 14.6 x 24.6 x 14.2\" / 37.1 x 62.5 x 36.1 cm</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Weight</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">15.2 lb / 6.9 kg</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<table class=\"specTable\" data-selenium=\"specTable\">\r\n<tbody data-selenium=\"specBody\">\r\n<tr><th class=\"specHeader Header\" colspan=\"2\" data-selenium=\"specHeader\"><a id=\"shipping\" class=\"fs32 OpenSans-300-normal\" name=\"shipping\" data-selenium=\"specHeaderLink\"></a>Packaging Info</th></tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Package Weight</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">20.0 lb</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Box Dimensions (LxWxH)</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">18.4 x 17.4 x 11.0\"</td>\r\n</tr>\r\n</tbody>\r\n</table>'),('315',76,0,'106','<ul class=\"top-section-list\" data-selenium=\"highlightList\">\r\n<li class=\"top-section-list-item\">Print Resolution: 1200 x 1200 dpi</li>\r\n<li class=\"top-section-list-item\">Maximum Print Size: 8.5 x 14\"</li>\r\n<li class=\"top-section-list-item\">Minimum Print Size: 3 x 5\"</li>\r\n<li class=\"top-section-list-item\">Print Speed: 30 ppm</li>\r\n<li class=\"top-section-list-item\">First Print Out Time: 6.6 Seconds</li>\r\n<li class=\"top-section-list-item\">Automatic Duplexing at up to 18 ppm</li>\r\n<li class=\"top-section-list-item\">250-Sheet Tray &amp; 10-Sheet Priority Tray</li>\r\n<li class=\"top-section-list-item\">Monthly Duty Cycle: 30,000 Pages</li>\r\n<li class=\"top-section-list-item\">USB 2.0, Ethernet, &amp; Wi-Fi Connectivity</li>\r\n</ul>\r\n<p>Boost the printing capabilities of your home or small office with the 30 ppm speed of the wireless<strong> LaserJet Pro M203dw Monochrome Laser Printer from HP</strong>. Able to produce up to 30 ppm, or 18 ppm when printing two sided, the M203dw is a very capable unit. It also features USB 2.0, Ethernet, and Wi-Fi connectivity for setting up in nearly any position, as well as for direct printing from a smartphone or tablet. With a resolution of up to 1200 x 1200 dpi and the ability to work with documents from 3 x 5\" to 8.5 x 14\", users will be able to improve productivity very easily.</p>\r\n<p>The M203dw can get started quickly with a first print out time of 6.6 seconds. Also, it features both a 250-sheet input tray and a 10-sheet priority tray for quickly using multiple media types. Additionally, it has a rated monthly duty cycle of 30,000 pages.</p>'),('316',85,0,'106','HP LaserJet Pro M203dw Monochrome Laser Printer'),('317',85,0,'107','HP OfficeJet Pro 7740 Wide-Format All-in-One Printer'),('318',75,0,'108','<p><strong>Depth</strong>: 30” (76.2 cm) </p>\r\n<p><strong>Height</strong>: 2 RU</p>\r\n<p><strong>Mounting Type</strong>: 4-point</p>\r\n<p><strong>Other</strong>: Vented</p>\r\n<p><strong>Load Capacity:</strong> 200 lbs ( 90 Kg)</p>\r\n<p><strong>Weight</strong>: 20 lbs ( 9 Kg)</p>'),('319',76,0,'108','<p><br /> Black powder painted steel construction</p>\r\n<p> 19” rack standard width</p>\r\n<p> Smooth bearing extension mechanism</p>\r\n<p> Mounting requires two rack-units (2 RU)</p>\r\n<p> Heavy gauge steel construction</p>\r\n<p> Standard EIA 310 D</p>\r\n<p><strong><br /></strong></p>\r\n<p><strong>Depth</strong>: 30” (76.2 cm) </p>\r\n<p><strong>Height</strong>: 2 RU</p>\r\n<p><strong>Mounting Type</strong>: 4-point</p>\r\n<p><strong>Other</strong>: Vented</p>\r\n<p><strong>Load Capacity:</strong> 200 lbs ( 90 Kg)</p>\r\n<p><strong>Weight</strong>: 20 lbs ( 9 Kg)</p>'),('320',85,0,'108','Newlink 4-Point Vented Shelf '),('321',75,0,'109','<p><strong>Depth</strong>: 12\" (30.5cm)</p>\r\n<p><strong>Height</strong>: 2 RU</p>\r\n<p><strong>Mounting Type</strong>: Cantilevered</p>\r\n<p><strong>Other</strong>: Solid</p>\r\n<p><strong>Load Capacity:</strong> 120 lbs ( 55 Kg)</p>\r\n<p><strong>Weight</strong>: 10 lbs ( 4 Kg)</p>'),('322',76,0,'109','<p><br /> Black powder painted steel construction</p>\r\n<p> 19” rack standard width</p>\r\n<p> Smooth bearing extension mechanism</p>\r\n<p> Mounting requires two rack-units (2 RU)</p>\r\n<p> Heavy gauge steel construction</p>\r\n<p> Standard EIA 310 D</p>\r\n<p><strong><br /></strong></p>\r\n<p><strong>Depth</strong>: 12\" (30.5cm)</p>\r\n<p><strong>Height</strong>: 2 RU</p>\r\n<p><strong>Mounting Type</strong>: Cantilevered</p>\r\n<p><strong>Other</strong>: Solid</p>\r\n<p><strong>Load Capacity:</strong> 120 lbs ( 55 Kg)</p>\r\n<p><strong>Weight</strong>: 10 lbs ( 4 Kg)</p>'),('323',85,0,'109','Newlink 4-Point Vented Shelf '),('325',75,0,'110','<table class=\"specTable\" data-selenium=\"specTable\">\r\n<tbody data-selenium=\"specBody\">\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Functions</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Print, Scan, Copy</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<table class=\"specTable\" data-selenium=\"specTable\">\r\n<tbody data-selenium=\"specBody\">\r\n<tr><th class=\"specHeader Header\" colspan=\"2\" data-selenium=\"specHeader\"><a id=\"245269\" class=\"fs32 OpenSans-300-normal\" name=\"245269\" data-selenium=\"specHeaderLink\"></a>Printer</th></tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Printing Technology</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Laser</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Print Resolution</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">600 x 600 dpi</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Print Speed</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">17 ppm (Color)<br />17 ppm (Black)</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">First Print Out Time</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">13.4 Seconds (Color)<br />11.6 Seconds (Black)</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Duplex Printing</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">No</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Color Type</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Color</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Configuration</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">4 x Toners</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Monthly Duty Cycle</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">30,000 Pages<br />1500 Pages (Recommended)</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Printer Language</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">HP PCL 6, HP Postscript Level 3 (Emulation), Native PDF, PCLm, URF</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<table class=\"specTable\" data-selenium=\"specTable\">\r\n<tbody data-selenium=\"specBody\">\r\n<tr><th class=\"specHeader Header\" colspan=\"2\" data-selenium=\"specHeader\"><a id=\"245268\" class=\"fs32 OpenSans-300-normal\" name=\"245268\" data-selenium=\"specHeaderLink\"></a>Scanner</th></tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Type</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Flatbed</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Image Sensor</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">1 x Contact Image Sensor (CIS)</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Optical Resolution</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Flatbed: 1200 dpi</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Color Depth</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">24-Bit (External)</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Grayscale</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">256 Levels</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Duplex Scanning</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">No</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Maximum Scan Area</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Flatbed: 8.50 x 11.69\" / 21.6 x 29.7 cm</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<table class=\"specTable\" data-selenium=\"specTable\">\r\n<tbody data-selenium=\"specBody\">\r\n<tr><th class=\"specHeader Header\" colspan=\"2\" data-selenium=\"specHeader\"><a id=\"245267\" class=\"fs32 OpenSans-300-normal\" name=\"245267\" data-selenium=\"specHeaderLink\"></a>Copier</th></tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Copy Resolution</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">600 x 600 dpi (Color)</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Copy Speed</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">16 cpm (Color)<br />16 cpm (Black)</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Reduction/Enlargement</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">25 to 400%</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Duplex Copying</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">No</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Number of Copies</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Up to 99 Copies</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<table class=\"specTable\" data-selenium=\"specTable\">\r\n<tbody data-selenium=\"specBody\">\r\n<tr><th class=\"specHeader Header\" colspan=\"2\" data-selenium=\"specHeader\"><a id=\"245259\" class=\"fs32 OpenSans-300-normal\" name=\"245259\" data-selenium=\"specHeaderLink\"></a>Media Handling</th></tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Paper Handling</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Input Tray 1, Output Tray</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Media Sizes</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Input Tray 1: 3 x 5 to 8.5 x 14\" / 7.62 x 12.70 to 21.59 x 35.56 cm</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Media Weight</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Input Tray 1: 60 to 163 gsm / 16 to 43 lb</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Paper Capacity</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Input Tray 1: 150 Sheets<br />Output Tray: 100 Sheets</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Special Media Support</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Envelopes</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<table class=\"specTable\" data-selenium=\"specTable\">\r\n<tbody data-selenium=\"specBody\">\r\n<tr><th class=\"specHeader Header\" colspan=\"2\" data-selenium=\"specHeader\"><a id=\"121502\" class=\"fs32 OpenSans-300-normal\" name=\"121502\" data-selenium=\"specHeaderLink\"></a>Connectivity</th></tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Interface</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">RJ45, USB Type-B</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Direct Printing</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Apple AirPrint, HP ePrint, Mopria, Wi-Fi Direct</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Operating System Support</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Windows, macOS/OS X</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<table class=\"specTable\" data-selenium=\"specTable\">\r\n<tbody data-selenium=\"specBody\">\r\n<tr><th class=\"specHeader Header\" colspan=\"2\" data-selenium=\"specHeader\"><a id=\"8008\" class=\"fs32 OpenSans-300-normal\" name=\"8008\" data-selenium=\"specHeaderLink\"></a>General</th></tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">AC Input Power</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">110 to 240 VAC, 50 / 60 Hz</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Power Consumption</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">337 W (Maximum)<br />8 W (Ready)<br />1 W (Sleep)<br />0.1 W (Off)</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Operating Temperature</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">59 to 86°F / 15 to 30°C</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Operating Humidity</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">30 to 70%</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Dimensions (W x H x D)</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">16.5 x 11.5 x 15.0\" / 41.9 x 29.2 x 38.1 cm<br />16.5 x 11.6 x 17.1\" / 41.9 x 29.5 x 43.4 cm (Maximum)</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Weight</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">34.6 lb / 15.7 kg</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<table class=\"specTable\" data-selenium=\"specTable\">\r\n<tbody data-selenium=\"specBody\">\r\n<tr><th class=\"specHeader Header\" colspan=\"2\" data-selenium=\"specHeader\"><a id=\"shipping\" class=\"fs32 OpenSans-300-normal\" name=\"shipping\" data-selenium=\"specHeaderLink\"></a>Packaging Info</th></tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Package Weight</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">40.6 lb</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Box Dimensions (LxWxH)</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">19.9 x 18.1 x 14.8\"</td>\r\n</tr>\r\n</tbody>\r\n</table>'),('326',76,0,'110','<ul class=\"top-section-list\" data-selenium=\"highlightList\">\r\n<li class=\"top-section-list-item\">Print, Copy, Scan</li>\r\n<li class=\"top-section-list-item\">Print Resolution: 600 x 600 dpi</li>\r\n<li class=\"top-section-list-item\">Maximum Document Size: 8.5 x 14\"</li>\r\n<li class=\"top-section-list-item\">Print Speed: Up to 17 ppm</li>\r\n<li class=\"top-section-list-item\">Max Scan Resolution: 1200 dpi</li>\r\n<li class=\"top-section-list-item\">Scan Speeds: 8 ppm Color, 15 ppm Black</li>\r\n<li class=\"top-section-list-item\">2-Line LCD; Mobile Printing Capabilities</li>\r\n<li class=\"top-section-list-item\">150-Sheet Input, 100-Sheet Output Trays</li>\r\n<li class=\"top-section-list-item\">Monthly Duty Cycle: Up to 30,000 Pages</li>\r\n<li class=\"top-section-list-item\">USB 2.0 and Ethernet Connectivity</li>\r\n</ul>\r\n<div class=\"ov-wrapper js-overview-desc\">\r\n<div class=\"ov-desc\">\r\n<p>A multi-functional unit for demanding workplaces, the <strong>Color LaserJet Pro M180nw All-In-One Laser Printer from HP</strong> offers printing, scanning, and copying functions to fulfill your imaging needs. This model can produce 600 x 600 dpi prints in black or color at speeds as fast as 17 ppm, supporting media up to 8.5 x 14\" legal down to 3 x 5\" paper. In the scanning department, the flatbed area offers a maximum resolution of 1200 dpi and works at speeds of up to 8 ppm for color and 15 ppm for black-and-white images.</p>\r\n<p>The M180nw can connect to your computer via USB 2.0 and Ethernet for standard printing, or use its built-in Wi-Fi functionality for wireless direct printing. It also allows you to easily send jobs from your mobile phone via Mopria, Apple AirPrint, and HP ePrint, among other apps. A 2-line LCD display is used to show all relevant information, and is complemented by a keypad and function buttons for easy control. For handling media, the unit counts with a 150-sheet input tray and 100-sheet output bin, and allows you to manually retrieve pages for duplex printing while copying dual-sided documents. Made to be durable, the M180nw features a maximum monthly duty cycle of 30,000 pages, with a recommended volume from 150 to 1500 pages.</p>\r\n</div>\r\n</div>\r\n<div class=\"sectionHeaders js-hiddenFeatures\" data-selenium=\"sectionHeaders\"><dl class=\"js-featureSectionDL\"><dd class=\"c28\">\r\n<ul>\r\n<li>All-in-one unit for printing, copying, and scanning documents</li>\r\n<li>High-quality printing at 600 x 600 dpi, with speeds of up to 17 ppm in black or color depending on your settings</li>\r\n<li>Flatbed scanner offers a maximum resolution of 1200 dpi, features speeds of 8 ppm for color and 15 ppm for black-and-white scans</li>\r\n<li>Copy function with speeds of up to 17 ppm, can be configured for dual-sided copying by allowing you to manually retrieve and reload pages during the print job</li>\r\n<li>Wi-Fi connectivity for direct wireless printing, with supports for mobile device solutions such as Mopria, Apple AirPrint, and HP ePrint</li>\r\n<li>Input tray holds up to 150 sheets of standard paper, compatible with custom media sizes from 3 x 5\" up to 8.5 x 14\"</li>\r\n<li>Output bin with a capacity of 100 sheets</li>\r\n<li>2-line LCD display with keypad and control buttons for easy onboard operation</li>\r\n<li>Maximum monthly duty cycle of 30,000 pages, with a recommended volume from 150 to 1500 pages</li>\r\n<li>USB 2.0 and Ethernet slots for wired connection to a computer</li>\r\n</ul>\r\n</dd></dl></div>'),('327',85,0,'110','HP LaserJet Pro M180nw All-in-One Laser Printer'),('328',75,0,'111','<fieldset>\r\n<h3 class=\"specTitle\">Cartridges Compatible</h3>\r\n<dl><dt>Cartridges Compatible</dt><dd>HP 65 Black (N9K02AN)<br />HP 65 Tri-Color (N9K01AN)<br />HP 65 Black + Tri-Color 2 Pack (T0A36AN)</dd></dl></fieldset><fieldset>\r\n<h3 class=\"specTitle\">Model</h3>\r\n<dl><dt>Brand</dt><dd>HP</dd></dl><dl><dt>Series</dt><dd>Deskjet</dd></dl><dl><dt>Model</dt><dd>2655</dd></dl><dl><dt>Part Number</dt><dd>V1N01A</dd></dl><dl><dt>Recommended Use</dt><dd>MFC / All-In-One</dd></dl><dl><dt>Functions</dt><dd>3-in-1: Print, Copy &amp; Scan</dd></dl></fieldset><fieldset>\r\n<h3 class=\"specTitle\">Print</h3>\r\n<dl><dt><a id=\"def_colorPopup__950\" class=\"specs-popup\" name=\"def-color\" data-t-events=\"A\" data-t-e-var78=\"Specification Popup:Print Technology\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>Print Technology</dt><dd>Thermal Inkjet</dd></dl><dl><dt>Output Type</dt><dd>Color</dd></dl><dl><dt>Black Print Speed</dt><dd>Up to 7.5 ppm (ISO)<br />Up to 20 ppm (Draft)</dd></dl><dl><dt>Color Print Speed</dt><dd>Up to 5.5 ppm (ISO)<br />Up to 16 ppm (Draft)</dd></dl><dl><dt>Black Print Quality</dt><dd>1200 x 1200 dpi</dd></dl><dl><dt>Color Print Quality</dt><dd>4800 x 1200 dpi</dd></dl><dl><dt>Time To First Page (seconds)</dt><dd>Black: As fast as 14 sec.<br />Color: As fast as 18 sec.</dd></dl><dl><dt>Print Languages, std.</dt><dd>HP PCL 3 GUI</dd></dl><dl><dt><a id=\"def_colorPopup__968\" class=\"specs-popup\" name=\"def-color\" data-t-events=\"A\" data-t-e-var78=\"Specification Popup:Duplex printing\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>Duplex printing</dt><dd>Manual</dd></dl><dl><dt><a id=\"def_colorPopup__969\" class=\"specs-popup\" name=\"def-color\" data-t-events=\"A\" data-t-e-var78=\"Specification Popup:Max. Duty Cycle\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>Max. Duty Cycle</dt><dd>Duty cycle (monthly, A4): Up to 1000 pages<br />Recommended monthly page volume: Up to 50 to 100 pages</dd></dl></fieldset><fieldset>\r\n<h3 class=\"specTitle\">Copy</h3>\r\n<dl><dt>Copy speed, Black</dt><dd>Up to 6 cpm</dd></dl><dl><dt>Copy speed, Color</dt><dd>Up to 3 cpm</dd></dl><dl><dt>Copy Quality, Black</dt><dd>600 x 300 dpi</dd></dl><dl><dt>Copy Quality, Color</dt><dd>600 x 300 dpi</dd></dl><dl><dt>Max. Number of Copies</dt><dd>Up to 9 copies</dd></dl><dl><dt>Copier Features</dt><dd>Copier Settings: Auto-enlarge</dd></dl></fieldset><fieldset>\r\n<h3 class=\"specTitle\">Scan</h3>\r\n<dl><dt><a id=\"def_colorPopup__980\" class=\"specs-popup\" name=\"def-color\" data-t-events=\"A\" data-t-e-var78=\"Specification Popup:Scan Resolution, Optical\" data-neg-popid=\"SpecsPopup\" data-popup-loaded=\"true\"></a>Scan Resolution, Optical</dt><dd>Up to 1200 dpi</dd></dl><dl><dt>Scan Resolution, Enhanced</dt><dd>Up to 1200 x 1200 dpi</dd></dl><dl><dt>Scan Technology</dt><dd>CIS</dd></dl><dl><dt>Scan Maximum Document Size</dt><dd>8.5\" x 11.7\"</dd></dl><dl><dt>Scanner Features</dt><dd>Scanner type: Flatbed<br />Scan file format: JPEG, TIFF, PDF, BMP, PNG</dd></dl></fieldset><fieldset>\r\n<h3 class=\"specTitle\">Media Handling</h3>\r\n<dl><dt>Paper Trays, std.</dt><dd>1</dd></dl><dl><dt>Paper Trays, max.</dt><dd>1</dd></dl><dl><dt>Input Capacity, std.</dt><dd>60-sheet</dd></dl><dl><dt>Output Capacity, std.</dt><dd>25-sheet</dd></dl><dl><dt>Media Type</dt><dd>Plainpaper <br />Photopaper<br />Brochurepaper</dd></dl><dl><dt>Media sizes supported</dt><dd>A4<br />B5<br />A6<br />DL envelope</dd></dl></fieldset><fieldset>\r\n<h3 class=\"specTitle\">Ports</h3>\r\n<dl><dt>USB Ports</dt><dd>1 x Hi-Speed USB 2.0</dd></dl><dl><dt>Connectivity Technology</dt><dd>Wireless</dd></dl></fieldset><fieldset>\r\n<h3 class=\"specTitle\">Hardware</h3>\r\n<dl><dt>Noise Level (Approx.)</dt><dd>Acoustic Power Emissions: 6.2 B(A)<br />Acoustic Pressure Emissions: 48 dB(A)</dd></dl><dl><dt>Processor (MHz)</dt><dd>360</dd></dl><dl><dt>Memory, max.</dt><dd>512 M bit DDR3; 256 M bit flash</dd></dl><dl><dt>Power Requirements</dt><dd>100 - 240V, 50/60Hz</dd></dl></fieldset><fieldset>\r\n<h3 class=\"specTitle\">Compatibility</h3>\r\n<dl><dt>Windows Compatible</dt><dd>Windows 10, 8.1, 8, 7<br />Windows Vista (32-bit only)<br />Windows XP SP3 or higher (32-bit only)</dd></dl><dl><dt>Macintosh Compatible</dt><dd>OS X v10.10 Yosemite<br />OS X v10.11 El Capitan <br />OS X v10.12 Sierra</dd></dl></fieldset><fieldset>\r\n<h3 class=\"specTitle\">Dimensions &amp; Weight</h3>\r\n<dl><dt>Dimensions</dt><dd>5.87\" x 16.74\" x 11.97\"<br />9.79\" x 16.73\" x 21.56\" (with Input &amp; Output Tray / Extension extended)</dd></dl><dl><dt>Weight</dt><dd>7.55 lbs.</dd></dl></fieldset>'),('329',76,0,'111','<ul>\r\n<li class=\"item\">Print up to 20 ppm Black and 16 ppm Color</li>\r\n<li class=\"item\">Up to 4800 x 1200 dpi</li>\r\n<li class=\"item\">USB, Wireless</li>\r\n<li class=\"item\">Manual Duplex</li>\r\n<li class=\"item\">Uses HP 65 Ink Cartridges</li>\r\n<li class=\"item\">Instant Ink Ready</li>\r\n</ul>\r\n<div class=\"ccs-cc-inline-features-block ccs-cc-inline-single-feature\">\r\n<div class=\"ccs-cc-inline-feature\" data-type=\"text\">\r\n<div class=\"ccs-cc-inline-feature-content ccs-cc-inline-feature-description\">Save time and money with HP\'s most affordable wireless all-in-one printer to date. With a hassle-free setup and easy printing from your mobile devices, the <strong>HP DeskJet 2655 All-in-One</strong> removes the complications of your everyday printing needs.</div>\r\n</div>\r\n</div>\r\n<div class=\"ccs-cc-inline-features-block ccs-cc-inline-multicolumn\" data-count=\"2\" data-media=\"false\">\r\n<div class=\"ccs-cc-inline-feature\">\r\n<div class=\"ccs-cc-inline-feature-content ccs-cc-inline-feature-description\" data-order=\"0\">\r\n<h3>Easily print from your mobile device.</h3>\r\nEasily connect your smartphone, tablet, or laptop and print from anywhere in your home.Printing has never been this convenient.</div>\r\n<div class=\"ccs-cc-inline-feature-content ccs-cc-inline-feature-description\" data-order=\"1\">\r\n<h3>The most affordable way to print</h3>\r\nLet your printer do the heavy lifting and get ink automatically delivered to your door. Save up to 50% on ink with HP Instant Ink, Ink Replacement Service.</div>\r\n</div>\r\n</div>\r\n<div class=\"ccs-cc-inline-features-block ccs-cc-inline-multicolumn\" data-count=\"2\" data-media=\"false\">\r\n<div class=\"ccs-cc-inline-feature\">\r\n<div class=\"ccs-cc-inline-feature-content ccs-cc-inline-feature-description\" data-order=\"0\">\r\n<h3>Wirelessly print, copy, and scan</h3>\r\nReduce your hassle with wireless printing and get all the features you want in one convenient place.</div>\r\n</div>\r\n</div>\r\n<h2>Key Features</h2>\r\n<div class=\"ccs-cc-inline-features-block ccs-cc-inline-multicolumn\" data-count=\"2\" data-media=\"true\">\r\n<div class=\"ccs-cc-inline-feature\">\r\n<div class=\"ccs-cc-inline-feature-content ccs-cc-inline-thumbnail\" data-order=\"0\"><img src=\"https://cc.cnetcontent.com/vcs/hp/inline-content/2N/1/E/3/9/4/1E3943BFE9F623ECBA5DFDE740F5520207DB6F44_i_75_featurtn.jpg\" alt=\"HP Planet Partners\" data-large=\"https://cc.cnetcontent.com/vcs/hp/inline-content/2N/1/E/3/9/4/1E3943BFE9F623ECBA5DFDE740F5520207DB6F44_i_75_featurtn.jpg\" /></div>\r\n<div class=\"ccs-cc-inline-feature-content ccs-cc-inline-feature-description\" data-order=\"0\">\r\n<h3>HP Planet Partners</h3>\r\nEasily recycle your Original HP ink and toner cartridges for free.</div>\r\n</div>\r\n</div>\r\n<div class=\"ccs-cc-inline-features-block ccs-cc-inline-single-feature\">\r\n<div class=\"ccs-cc-inline-feature\" data-type=\"text\">\r\n<div class=\"ccs-cc-inline-feature-content ccs-cc-inline-feature-description\">\r\n<h3>Original HP Cartridges</h3>\r\n<ul>\r\n<li>HP 65 Black Ink Cartridge (~120 pages)</li>\r\n<li>HP 65 Tri-color Ink Cartridge (~100 pages)</li>\r\n<li>HP 65XL Black Ink Cartridge (~300 pages)</li>\r\n<li>HP 65XL Tri-color Ink Cartridge (~300 pages)</li>\r\n</ul>\r\n</div>\r\n</div>\r\n</div>');
INSERT INTO `catalog_product_entity_text` VALUES ('330',85,0,'111','HP DeskJet 2655 All-in-One ePrinter'),('331',75,0,'112','<p><strong>19” Cable Management (2Unit Duct Panel with Cover) </strong></p>\r\n<p> Dimensions: 88mm x 482.6mm</p>\r\n<p> Panel Color Black</p>\r\n<p> Metal panel, plastic ring</p>\r\n<p> Standard EIA 310 D</p>'),('332',76,0,'112','<p><strong>19” Cable Management (2Unit Duct Panel with Cover)</strong></p>\r\n<p> Dimensions: 88mm x 482.6mm</p>\r\n<p> Panel Color Black</p>\r\n<p> Metal panel, plastic ring</p>\r\n<p> Standard EIA 310 D</p>'),('333',85,0,'112','Newlink 19\" Cable Management Duct Panel with Cover'),('334',75,0,'113','<p><strong>Technical Specifications: </strong></p>\r\n<p> Dimensions: 88mm x 482.6mm</p>\r\n<p> Panel Color Black</p>\r\n<p> Standard EIA 310 D</p>'),('335',76,0,'113','<p><strong>Technical Specifications: </strong></p>\r\n<p> Dimensions: 88mm x 482.6mm</p>\r\n<p> Panel Color Black</p>\r\n<p> Standard EIA 310 D</p>'),('336',85,0,'113','Newlink 19\" Cable Management Double-Sided with Covers'),('337',75,0,'114','<p>Newlink offers a wire management line that protects, routes, and organizes UTP, STP, coaxial and fiber optic cables. These organizers also make it easy to perform moves or changes</p>\r\n<p><b>Features:</b> </p>\r\n<ul>\r\n<li>Ideal for high density installations, the black wire management brackets feature smooth-edged slotted fingers allowing cable to be pulled through at any location </li>\r\n<li>UL Listed</li>\r\n<li>Horizontal Mounting, 5-rings, 1 rack unit</li>\r\n<li>Standard EIA 310 D</li>\r\n</ul>'),('338',76,0,'114','<p>Newlink offers a wire management line that protects, routes, and organizes UTP, STP, coaxial and fiber optic cables. These organizers also make it easy to perform moves or changes</p>\r\n<p><b>Features:</b> </p>\r\n<ul>\r\n<li>Ideal for high density installations, the black wire management brackets feature smooth-edged slotted fingers allowing cable to be pulled through at any location </li>\r\n<li>UL Listed</li>\r\n<li>Horizontal Mounting, 5-rings, 1 rack unit</li>\r\n<li>Standard EIA 310 D</li>\r\n</ul>'),('339',85,0,'114','Newlink Horizontal Cable Organizer 1U 5-Rings '),('340',75,0,'115','<p style=\"text-align: left;\" align=\"right\">These horizontal cable brackets are designed to provide both front and rear cable management in a compact size. The managers feature high capacity slots for entering and exiting cables, removable covers to hide excess patch cord length.<b> </b></p>\r\n<p><b>Features:</b> </p>\r\n<ul>\r\n<li>Height: 1.75\"       </li>\r\n<li>Width: 19\" </li>\r\n<li>Slotted Channels: (1) </li>\r\n<li>Color: Black </li>\r\n<li>Simultaneously organizes both rear horizontal cable and front patch cords on a relay rack giving a neat and aesthetically pleasing installation. The base panel measures 19\"W x 1.75\"H       Flexible \"fingers\" allow cords to enter and exit the cable management panel as needed.</li>\r\n<li>Channels open for easy installation.</li>\r\n<li>Standard EIA 310 D</li>\r\n</ul>'),('341',76,0,'115','<p style=\"text-align: left;\" align=\"right\">These horizontal cable brackets are designed to provide both front and rear cable management in a compact size. The managers feature high capacity slots for entering and exiting cables, removable covers to hide excess patch cord length.<b> </b></p>\r\n<p><b>Features:</b> </p>\r\n<ul>\r\n<li>Height: 1.75\"       </li>\r\n<li>Width: 19\" </li>\r\n<li>Slotted Channels: (1) </li>\r\n<li>Color: Black </li>\r\n<li>Simultaneously organizes both rear horizontal cable and front patch cords on a relay rack giving a neat and aesthetically pleasing installation. The base panel measures 19\"W x 1.75\"H       Flexible \"fingers\" allow cords to enter and exit the cable management panel as needed.</li>\r\n<li>Channels open for easy installation.</li>\r\n<li>Standard EIA 310 D</li>\r\n</ul>'),('342',85,0,'115','Newlink 19\" 1U Horizontal Cable Bracket 1-Side'),('343',75,0,'116','<p><strong> Ten (10) NEMA 15R Outlets </strong></p>\r\n<p> 3m / 10ft cord</p>\r\n<p> 19” Rackmountable</p>\r\n<p> Thermal overcurrent protected</p>\r\n<p> Power switch and reset button</p>\r\n<p></p>\r\n<p>AC Rating Volts: 125</p>\r\n<p>AC Rating Amps: 15</p>\r\n<p>AC Rating Watts: 1875</p>\r\n<p>AC Rating Frequency: 50/60 Hz</p>\r\n<p>Over Current Protection: 15 AMP Thermal Breaker</p>\r\n<p>Power Switch: Yes – Neon red indicator</p>\r\n<p>Power Cable: AWG 14/3 SJT/SO</p>\r\n<p>Cord Length: 10\'</p>\r\n<p>Receptacle Type: NEMA 5-15R</p>\r\n<p>Receptacles on Front: 10</p>\r\n<p>Maximum Output per Receptacle: 15A</p>\r\n<p>UL 1449 Rating: (500 AMPS) 330 Volts</p>\r\n<p>Certification/Agency Approvals: UL &amp; c-UL Recognized to 1449 Standards</p>\r\n<p>Unit Weight: 2.2 Kg / 5 lbs.</p>'),('344',76,0,'116','<p><strong>Ten (10) NEMA 15R Outlets</strong></p>\r\n<p> 3m / 10ft cord</p>\r\n<p> 19” Rackmountable</p>\r\n<p> Thermal overcurrent protected</p>\r\n<p> Power switch and reset button</p>'),('345',85,0,'116','Newlink 19\" Rackmountable 10-Outlet Power Strip'),('346',75,0,'117','<p><strong>Eight (8) NEMA 15R Outlets </strong></p>\r\n<p> 3m / 10ft cord</p>\r\n<p> 19” Rack mountable</p>\r\n<p> Thermal over current protected</p>\r\n<p> Power switch with indicator</p>\r\n<p> Standard EIA 310 D</p>\r\n<p></p>\r\n<p>AC Rating Volts: 125</p>\r\n<p>AC Rating Amps: 15</p>\r\n<p>AC Rating Watts: 1875</p>\r\n<p>AC Rating Frequency: 50/60 Hz</p>\r\n<p>Over Current Protection: 15 AMP Thermal Breaker</p>\r\n<p>Power Switch: Yes – Neon red indicator</p>\r\n<p>Power Cable: AWG 14/3 SJT/SO</p>\r\n<p>Cord Length: 10\'</p>\r\n<p>Receptacle Type: NEMA 5-15R</p>\r\n<p>Receptacles on Front: 8</p>\r\n<p>Maximum Output per Receptacle: 15A</p>\r\n<p>Unit Weight: 2.0 Kg / 5 lbs.</p>'),('347',76,0,'117','<p><strong>Eight (8) NEMA 15R Outlets</strong></p>\r\n<p> 3m / 10ft cord</p>\r\n<p> 19” Rack mountable</p>\r\n<p> Thermal over current protected</p>\r\n<p> Power switch with indicator</p>\r\n<p> Standard EIA 310 D</p>'),('348',85,0,'117','Newlink 19\" Rack Mountable 8-Outlet Power Strip'),('349',75,0,'118','<p><strong>Technical Specifications: </strong></p>\r\n<p>Case material: Aluminum</p>\r\n<p>Case Color: Black</p>\r\n<p>Number of Outlets: 10</p>\r\n<p>Case Length: 430mm</p>\r\n<p>Mounting Length: 465mm</p>\r\n<p>Product Size: 483mm x 45mm x 45mm</p>\r\n<p>Cable Specification: 3 x 14 AWG x 3mt SJT/SO</p>\r\n<p>Input Plug: NEMA 5-15P</p>\r\n<p>Bracket Install: Horizontal</p>\r\n<p>Protection Monitoring Function: (Overload + Surge) Protection</p>\r\n<p>Rated Current: 15A</p>\r\n<p>Rated Voltage: 125V 50-60HZ</p>\r\n<p>Max. Output power: 1875W</p>\r\n<p>Certification: CE ROHS</p>\r\n<p>Standard: EIA 310 D</p>'),('350',76,0,'118','<p><strong>Technical Specifications:</strong></p>\r\n<p>Case material: Aluminum</p>\r\n<p>Case Color: Black</p>\r\n<p>Number of Outlets: 10</p>\r\n<p>Case Length: 430mm</p>\r\n<p>Mounting Length: 465mm</p>\r\n<p>Product Size: 483mm x 45mm x 45mm</p>\r\n<p>Cable Specification: 3 x 14 AWG x 3mt SJT/SO</p>\r\n<p>Input Plug: NEMA 5-15P</p>\r\n<p>Bracket Install: Horizontal</p>\r\n<p>Protection Monitoring Function: (Overload + Surge) Protection</p>\r\n<p>Rated Current: 15A</p>\r\n<p>Rated Voltage: 125V 50-60HZ</p>\r\n<p>Max. Output power: 1875W</p>\r\n<p>Certification: CE ROHS</p>\r\n<p>Standard: EIA 310 D</p>');
INSERT INTO `catalog_product_entity_text` VALUES ('351',85,0,'118','Newlink 19\" Rack Mountable Power Strip with Thermal/Surge/Overload Protection'),('352',75,0,'119','<p>Newlink offers filler panels to cover your open spaces in a rack or cabinet.</p>\r\n<ul>\r\n<li>Standard: EIA 310 D</li>\r\n<li>3U - 19\" x 5 1/4\" </li>\r\n</ul>'),('353',76,0,'119','<p>Newlink offers filler panels to cover your open spaces in a rack or cabinet.</p>\r\n<ul>\r\n<li>Standard: EIA 310 D</li>\r\n<li>3U - 19\" x 5 1/4\" </li>\r\n</ul>'),('354',85,0,'119','Newlink 3U Filler Panel'),('355',75,0,'120','<ul>\r\n<li>Dimensions: H 51 1/4” x W 23 ½” x D 21 ½”</li>\r\n<li>Mounting: Standard 19”</li>\r\n<li>Glass front door w/lock</li>\r\n<li>Removable side panels </li>\r\n<li>Solid back panel w/lock</li>\r\n<li>2-Fan Cooling Device installed</li>\r\n<li>27UR<b></b></li>\r\n<li>Unit Weight: 106 lbs</li>\r\n<li>Loading Capacity: 30kg / 66lbs</li>\r\n<li>Standard EIA 310 D</li>\r\n</ul>\r\n<p>Newlink offers a unique all steel enclosure that is both strong and attractive. Our design allows us to maintain tighter tolerances for door clearance and bends for a more attractive addition to your computer room.</p>'),('356',76,0,'120','<ul>\r\n<li>Dimensions: H 51 1/4” x W 23 ½” x D 21 ½”</li>\r\n<li>Mounting: Standard 19”</li>\r\n<li>Glass front door w/lock</li>\r\n<li>Removable side panels </li>\r\n<li>Solid back panel w/lock</li>\r\n<li>2-Fan Cooling Device installed</li>\r\n<li>27UR<b> </b></li>\r\n<li>Unit Weight: 106 lbs</li>\r\n<li>Loading Capacity: 30kg / 66lbs</li>\r\n<li>Standard EIA 310 D</li>\r\n</ul>\r\n<p>Newlink offers a unique all steel enclosure that is both strong and attractive. Our design allows us to maintain tighter tolerances for door clearance and bends for a more attractive addition to your computer room.<b><i> </i></b></p>'),('357',85,0,'120','Newlink 27U Wall Mountable Patch Cabinet'),('358',75,0,'121','<p><span style=\"text-decoration: underline;\"><strong>Technical Specifications:</strong> </span></p>\r\n<p><span style=\"text-decoration: underline;\"></span><strong>STYLE</strong>: STANDALONE CABINET W/GLASS DOOR</p>\r\n<p><strong>SIZE</strong>: External: 78”High x 24”Wide x 39” ½ Depth. Internal mounting 19”Wide x 32- 34” Depth</p>\r\n<p><strong>FINISH</strong>: POWDER COATED, BLACK APPLICATION: HOUSING OF DATACOMM EQUIPMENT, TELECOMMUNICATIONS EQUIPMENT, COMPUTER CONTROL ROOM EQUIPMENT</p>\r\n<p><strong>CABINET WEIGHT</strong>: 294 LBS</p>\r\n<p><strong>LOAD</strong> <strong>CAPACITY</strong>: 800 Kg / 1760 lbs</p>\r\n<p><strong>FANS</strong>: 2 FANS INCLUDED</p>\r\n<p><strong>POWER</strong> <strong>STRIP</strong>: 6-outlet INCLUDED</p>'),('359',76,0,'121','<p><span style=\"text-decoration: underline;\"><strong>78\" (42 UR) Standalone Cabinet, Glass door w/locks, 2 fans and 1 power strip included </strong></span></p>\r\n<p> External: 78”High x 24”Wide x 39” ½ Depth. Internal mounting 19”Wide x 32-34” Depth</p>\r\n<p> Front Glass Door w/ lock</p>\r\n<p> Vented Rear Door w/ Lock</p>\r\n<p> Removable Side Panels</p>\r\n<p> 19” Mounting Uprights Painted, Square Holes, EIA Spacing w/ M6 Clip Nuts and Hardware.</p>\r\n<p> Weight: 294</p>\r\n<p> Standard EIA 310 D</p>\r\n<p>Newlink offers a unique all steel enclosure that is both strong and attractive. Our design allows us to maintain tighter tolerances for door clearance, better stability and superior heat dissipation. Comes fully assembled and includes two Turbo Fans and a 6-outlet power strip.</p>'),('360',85,0,'121','Newlink 42U Standalone Cabinet '),('361',75,0,'122','<ul>\r\n<li>For 19” cabinets and racks</li>\r\n<li>Rating Voltage (VAC): 115</li>\r\n<li>Frequency (Hz): 50/60</li>\r\n<li>Power Current (Amp): 0.26/0.24</li>\r\n<li>Power Consumption (Watts): 22/20</li>\r\n<li>Speed (RPM): 2700/3100</li>\r\n<li>Air Flow (CFM): 95/115</li>\r\n<li>Static Pressure (Inch-H2O): 0.33/0.38</li>\r\n<li>Noise (dBA): 44/49</li>\r\n<li>Fan Diameter (mm): Inlet/Outlet: 114,73/114</li>\r\n<li>Bearing: Sleeve</li>\r\n<li>Frame: Aluminum Alloy</li>\r\n<li>Weight (g): 550</li>\r\n<li>Color: Black</li>\r\n</ul>'),('362',76,0,'122','<p><span>Fans are an essential part in any cabinet, rack or enclosure, to keep all your equipment cool and running smoothly. Fits perfectly with any 19\" standard rack mount.</span></p>'),('363',85,0,'122','Nexxt 110VAC Cooling Fan Unit for Cabinets '),('364',75,0,'123','<h2><span><span>Specifications</span></span></h2>\r\n<ul>\r\n<li><span><span>Universal organizer for horizontal cabling</span></span></li>\r\n<li><span><span>Allows to install strips in horizontal position</span></span></li>\r\n<li><span><span>Tempered glass door and side panel with lock and key</span></span></li>\r\n<li><span><span>Gutters to guide the cables in the upper and lower panels</span></span></li>\r\n<li><span><span>Adjustable vertical rails</span></span></li>\r\n<li><span><span>Integrated grounding screws</span></span></li>\r\n<li><span><span>Protection level: IP20</span></span></li>\r\n<li><span><span>Maximum stationary load: 30kg</span></span></li>\r\n</ul>'),('365',76,0,'123','<div><span>Nexxt articulated and semi-assembled wall cabinets are ideal for installations where limited space is available or where the use of a complete enclosure is not required. </span><span>Our wall cabinets are the perfect solution for any standard 19-inch installation. </span><span>They are commonly used with interconnection and cable distribution panels to give the facilities a professional, safe and organized appearance. </span><span>These wall cabinets come semi-assembled and are available with 6, 9, 12, 15 and 18 frame units.</span></div>\r\n<ul>\r\n<li><span><span>Available to accommodate 19-inch panels, manufactured according to the industry EIA standard</span></span></li>\r\n<li><span><span>Meets ANSI / TIA / EIA-568 C.2 and ANSI / EIA RS-310-D standards. </span><span>Compatible with IEC297-2 standards; </span><span>DIN41491: SECTION 1; </span><span>DIN41494: SECTION 7; </span><span>GB / t3047.2-92</span></span></li>\r\n<li><span><span>Two structures, one main with opening angle of 120 degrees and front door with opening angle greater than 180 degrees</span></span></li>\r\n<li><span><span>Compact design with welded frame and perforated top panel for ventilation</span></span></li>\r\n<li><span><span>The standard 19-inch installation allows easy access for cable management and maintenance</span></span></li>\r\n<li><span><span>Electrostatic coating to protect against moisture, oxidation, scratches, peeling, strong acids and alkaline erosion</span></span></li>\r\n<li><span><span>Coated with powder paint, polyester epoxy hybrid, black</span></span></li>\r\n<li><span><span>For use indoors and in areas with controlled environments. </span><span>Not suitable for outdoor use, in industrial environments, abrasives or air distribution chambers</span></span></li>\r\n<li><span><span>Allows to include shelves or rails to place modular network and voice switches, routers and other network equipment</span></span></li>\r\n</ul>'),('366',85,0,'123','Nexxt 6U SKD Wall Cabinet'),('367',75,0,'124','<ul>\r\n<li><span>External height (H): 14.33\"</span></li>\r\n<li><span>External width (W): 23.62\"</span></li>\r\n<li><span>External depth (D): 21.65\"</span></li>\r\n<li>Black epoxy-polyester hybrid powder paint</li>\r\n<li>Universal horizontal cable manager&lt;</li>\r\n<li>Horizontal power strips can be fit</li>\r\n<li>Tempered glass door and side panel with key lock</li>\r\n<li>Channels for routing cables located on the top and bottom panels</li>\r\n<li>Adjustable vertical rails</li>\r\n<li>Attached grounding bolts</li>\r\n<li>Protection grade: IP20</li>\r\n<li>Max load: 132lb</li>\r\n<li>Units in box: 1</li>\r\n</ul>'),('368',76,0,'124','<p><span>Nexxt Solutions semi-knocked down (SKD) hinged wall mount enclosures are ideal for installations were space is limited or where a full cabinet is not required. Our wall mount enclosures are the perfect solution for any 19-inch installation. Commonly used with all patch panels and cable management panels to give installations an organized, protected and professional appearance. These wall mount enclosures come as semi-knock down version. Available with 6, 9, 12, 15 and 18 rack spaces.</span></p>\r\n<ul>\r\n<li>Available to accommodate EIA industry-standard 19-inch panels</li>\r\n<li>Follows ANSI/TIA/EIA-568 C.2 manufacturing standards and meets ANSI/EIA RS-310-D. It also complies with IEC297-2; DIN41491: PART1; DIN41494: PART7; GB/T3047.2-92 standard</li>\r\n<li>Two section structure, the main body can turn 120 degree, the turning angle of front door is above 180 degree</li>\r\n<li>Compact welded frame design, featuring perforated top panel for ventilation</li>\r\n<li>19-inch standard installation provides easy access for management and maintenance</li>\r\n<li>One layer of electrostatic coating protects it against humidity, rust, scratches, peeling, strong acid and alkaline erosion</li>\r\n<li>For indoor use only, in environmentally controlled areas, may not be used outdoors, in industrial or harsh environments or in plenum spaces</li>\r\n<li>Use with shelves or rails to support small modular network or voice switches routers and other network equipment</li>\r\n</ul>'),('369',85,0,'124','Nexxt 12U Wall Mount Enclosure'),('370',75,0,'125','<fieldset>\r\n<h3 class=\"specTitle\">Model</h3>\r\n<dl><dt>Brand</dt><dd>TRIPP LITE</dd></dl><dl><dt>Model</dt><dd>SR1UBRUSH</dd></dl></fieldset><fieldset>\r\n<h3 class=\"specTitle\">Type</h3>\r\n<dl><dt>Type</dt><dd>Consumer Electronics</dd></dl></fieldset><fieldset>\r\n<h3 class=\"specTitle\">Features</h3>\r\n<dl><dt>Features</dt><dd>1U Cable pass-through panel with brush strip<br />Brush strip blocks unwanted airflow<br />Improves cooling efficiency<br />Segregates cold aisle from hot aisle</dd></dl></fieldset>'),('371',76,0,'125','<p><span>Block unwanted airflow inside rack enclosures and server cabinets with Tripp Lite’s SR1UBRUSH Cable Pass-Through Panel with Brush Strip. This 1U panel provides convenient cable management while improving cooling efficiency in hot-aisle/cold-aisle rack configurations. It comes with all necessary mounting hardware and is compatible with all standard 19-inch rack enclosures and server cabinets.</span></p>\r\n<div class=\"ccs-cc-inline-features-block ccs-cc-inline-single-feature\">\r\n<div class=\"ccs-cc-inline-feature\" data-type=\"text media\" data-pos=\"left\">\r\n<div class=\"ccs-cc-inline-feature-content ccs-cc-inline-feature-description\"><b>Improve Cooling Efficiency and Optimize Airflow</b> <span><br /><br />Efficient cooling reduces operating costs, improves performance and provides longer lifespans for networking equipment. The SR1UBRUSH improves cooling efficiency within rack enclosures by blocking unwanted airflow to prevent recirculation. </span><span> </span> <b><br /><br /><br />Simple, Hassle-Free Installation</b> <span><br /><br />The SR1UBRUSH can be installed in any standard 19-inch rack enclosure or server cabinet. It comes with all necessary mounting hardware.</span> <span> </span> <b><br /><br /><br /></b></div>\r\n</div>\r\n</div>\r\n<div class=\"ccs-cc-inline-features-block ccs-cc-inline-single-feature\">\r\n<div class=\"ccs-cc-inline-feature\" data-type=\"text media\" data-pos=\"right\">\r\n<div class=\"ccs-cc-inline-feature-content ccs-cc-inline-thumbnail\"><a class=\"ccs-cc-inline-thumbnail-image ccs-cc-inline-thumbnail-media ccs-cc-inline-clickable\" title=\"1U Cable Pass-Through Panel with Brush Strip show larger image\" href=\"https://cdn.cnetcontent.com/syndication/mediaserver/inlinecontent/tri/1e9/35c/1e935cb308ec4f94b9a194a5fa9f85e4/original.jpg\" data-media-type=\"image\" data-zoom-log-call=\"{&quot;logFunctionName&quot;:&quot;ccs_cc_loge_168608&quot;,&quot;paramsFunctionName&quot;:&quot;ccs_cc_gete_params_168608&quot;,&quot;eventId&quot;:&quot;ffe3a99d&quot;}\" data-hover-log-call=\"{&quot;logFunctionName&quot;:&quot;ccs_cc_loge_168608&quot;,&quot;paramsFunctionName&quot;:&quot;ccs_cc_gete_params_168608&quot;,&quot;eventId&quot;:&quot;d0124711&quot;}\" data-caption=\"1U Cable Pass-Through Panel with Brush Strip\"><span class=\"ccs-cc-inline-image-zoom\"></span><img src=\"https://cdn.cnetcontent.com/syndication/mediaserver/inlinecontent/tri/1e9/35c/1e935cb308ec4f94b9a194a5fa9f85e4/width(300).jpg\" alt=\"1U Cable Pass-Through Panel with Brush Strip\" data-large=\"https://cdn.cnetcontent.com/syndication/mediaserver/inlinecontent/tri/1e9/35c/1e935cb308ec4f94b9a194a5fa9f85e4/original.jpg\" /></a></div>\r\n<div class=\"ccs-cc-inline-feature-content ccs-cc-inline-feature-description\"><b><span></span></b></div>\r\n<div class=\"ccs-cc-inline-feature-content ccs-cc-inline-feature-description\"><b><span></span></b></div>\r\n<div class=\"ccs-cc-inline-feature-content ccs-cc-inline-feature-description\"><b><span></span></b></div>\r\n<div class=\"ccs-cc-inline-feature-content ccs-cc-inline-feature-description\"><b><span>Tripp Lite<span> SR1UBRUSH Product Summary:</span></span></b><span><br /></span></div>\r\n<div class=\"ccs-cc-inline-feature-content ccs-cc-inline-feature-description\">\r\n<ul>\r\n<li><span>Blocks unwanted airflow in rack enclosures and server cabinets</span></li>\r\n<li><span>Improves cooling efficiency</span></li>\r\n<li><span>Segregates cold aisle from hot aisle</span></li>\r\n</ul>\r\n<b><br />What’s in the Box</b> <br /><br /><span>SR1UBRUSH Cable Pass-Through Panel with Brush Strip</span><span></span> <span>Mounting Hardware</span></div>\r\n</div>\r\n</div>\r\n<div class=\"ccs-cc-inline-features-block ccs-cc-inline-single-feature\">\r\n<div class=\"ccs-cc-inline-feature\" data-type=\"text\">\r\n<div class=\"ccs-cc-inline-feature-content ccs-cc-inline-feature-description\"><b><br /></b></div>\r\n<div class=\"ccs-cc-inline-feature-content ccs-cc-inline-feature-description\"><b>Why Choose Tripp Lite?</b> <span><br /><br />Founded in 1922 in Chicago, Illinois, Tripp Lite is a leading manufacturer of products to power, connect, house and protect your equipment. From the largest data center to the smallest home office, Tripp Lite products keep your equipment running effectively and efficiently. Whether you need to supply power to servers and have reliable battery backup, connect high-resolution video sources to displays and digital signs, or organize and secure IT equipment in rack enclosures, Tripp Lite has the complete solution. Plus, before and after your purchase, our Chicago-based, in-house technical support specialists are available to assist you by phone, email and live chat. With over 90 years of quality products and service, Tripp Lite is a brand you can trust.</span></div>\r\n</div>\r\n</div>');
INSERT INTO `catalog_product_entity_text` VALUES ('372',85,0,'125','Tripp Lite 1U Cable Pass-Through Panel with Brush Strip'),('373',75,0,'126','<table class=\"specTable\" data-selenium=\"specTable\">\r\n<tbody data-selenium=\"specBody\">\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Ports</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">1 x LC</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Networking Technology</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">1000BASE-BX-20U</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Maximum Networking Distance</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">32,810\' / 10,000 m</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Maximum Data Rate</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">1 Gbps</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Mode</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Single-Mode</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Power Consumption</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">1 W</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Dimensions (L x W x H)</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">2.2 x 0.5 x 0.3\" / 55.9 x 12.7 x 7.6 mm</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Weight</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">0.6 oz / 17 g</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<table class=\"specTable\" data-selenium=\"specTable\">\r\n<tbody data-selenium=\"specBody\">\r\n<tr><th class=\"specHeader Header\" colspan=\"2\" data-selenium=\"specHeader\"><a id=\"shipping\" class=\"fs32 OpenSans-300-normal\" name=\"shipping\" data-selenium=\"specHeaderLink\"></a>Packaging Info</th></tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Package Weight</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">0.15 lb</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Box Dimensions (LxWxH)</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">5.0 x 3.3 x 1.4\"</td>\r\n</tr>\r\n</tbody>\r\n</table>'),('374',76,0,'126','<ul class=\"top-section-list\" data-selenium=\"highlightList\">\r\n<li class=\"top-section-list-item\">1000BASE-BX-20</li>\r\n<li class=\"top-section-list-item\">1 x LC Single Connector</li>\r\n<li class=\"top-section-list-item\">Single-Mode Fiber (SMF)</li>\r\n<li class=\"top-section-list-item\">10 km (6.2 miles) Max.</li>\r\n<li class=\"top-section-list-item\">1000 Mbps Transfer Rate</li>\r\n</ul>\r\n<div class=\"ov-wrapper js-overview-desc\">\r\n<div class=\"ov-desc\">\r\n<p>The <strong>MGBBX1 SFP Transceiver from Cisco</strong> is an easy-to-install module that provides a simple way to add an extra Gigabit Ethernet port to your Cisco Small Business or Cisco Small Business Pro Series switches. The transceiver is available for single-mode fiber-optic cabling and can support distance up to 10 kilometers (6.2 miles).</p>\r\n</div>\r\n</div>\r\n<div class=\"sectionHeaders js-hiddenFeatures\" data-selenium=\"sectionHeaders\"><dl class=\"js-featureSectionDL\"><dt class=\"featureTitle\"><strong>Small Form-Factor Pluggable (SFP)</strong></dt><dd class=\"c28\">Cisco\'s MGBBX1 transceiver is a Small Form-Factor Pluggable (SFP) unit. An SFP is an easy-to-install module that provides a simple way to add an extra Gigabit Ethernet port to your Cisco Small Business Series switches. The Cisco MGBBX1 transceiver provides fast and reliable connectivity between switches that are located on different floors or in separate office buildings. The MGBBX1 transceiver can also support both Fast and Gigabit Ethernet applications</dd></dl><dl class=\"js-featureSectionDL\"><dt class=\"featureTitle\"><strong>Long Distance</strong></dt><dd class=\"c28\">The MGBBX1 transceiver has a reach of up to 10 kilometers (6.2 miles)</dd></dl></div>'),('375',85,0,'126','Cisco MGBBX1 SFP Transceiver'),('376',75,0,'127','<table class=\"specTable\" data-selenium=\"specTable\">\r\n<tbody data-selenium=\"specBody\">\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Performance</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Capacity in Millions of Packets per Second (Mp/s) (64-byte packets): 9.52<br />Switching Capacity in Gb/s: 12.8</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Layer 2 Switching</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Spanning Tree Protocol: Standard 802.1d Spanning Tree support<br />Fast convergence using 802.1w (Rapid Spanning Tree), enabled by default<br />Multiple Spanning Tree instances using 802.1s<br /><br />Port Grouping: Support for IEEE 802.3ad Link Aggregation Control Protocol<br />Up to 8 groups<br />Up to 8 ports per group with 16 candidate ports for each (dynamic) 802.3ad link aggregation<br /><br />VLAN: Support for up to 256 VLANs simultaneously (out of 4096 VLAN IDs) <br />Port-based and 802.1Q tag-based VLANs<br />MAC-based VLAN<br />Management VLAN<br />Private VLAN Edge, also known as protected ports, with multiple uplinks<br />Guest VLAN<br />Unauthenticated VLAN<br /><br />Voice VLAN: Voice traffic is automatically assigned to a voice-specific VLAN and treated with appropriate levels of QoS<br /><br />Q-in-Q VLAN: VLANs transparently cross a service provider network while isolating traffic among customers<br /><br />Generic VLAN Registration Protocol/Generic Attribute Registration Protocol: Protocols for automatically propagating and configuring VLANs in a bridged domain<br /><br />Dynamic Host Configuration Protocol Relay at Layer 2: Relay of DHCP traffic to DHCP server in different VLAN. Works with DHCP Option 82<br /><br />Internet Group Management Protocol Versions 1, 2 and 3 Snooping: IGMP limits bandwidth-intensive multicast traffic to only the requesters; supports 256 multicast groups (source-specific multicasting is also supported) <br /><br />IGMP Querier: IGMP querier is used to support a Layer 2 multicast domain of snooping switches in the absence of a multicast router<br /><br />Head-of-Line (HOL) Blocking: HOL blocking prevention</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Layer 3</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">IPv4 Routing: Wirespeed routing of IPv4 packets<br />Up to 32 static routes and up to 32 IP interfaces<br /><br />Classless Inter-Domain Routing: Support for CIDR<br /><br />DHCP Relay at Layer 3: Relay of DHCP traffic across IP domains<br /><br />User Datagram Protocol Relay: Relay of broadcast information across Layer 3 domains for application discovery or relaying of BootP/DHCP packets</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Security</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Secure Shell Protocol: SSH secures Telnet traffic to and from the switch; SSH v1 and v2 are supported<br /><br />Secure Sockets Layer: SSL Support: Encrypts all HTTPS traffic, allowing highly secure access to the browser-based management GUI in the switch<br /><br />IEEE 802.1X (Authenticator Role): RADIUS authentication and accounting, MD5 hash; guest VLAN; unauthenticated VLAN, single/multiple host mode and single/multiple sessions Supports time-based 802.1X <br />Dynamic VLAN assignment<br /><br />STP Bridge Protocol Data Unit Guard: A security mechanism to protect the network from invalid configurations.<br />A port enabled for BPDU Guard is shut down if a BPDU message is received on that port<br /><br />STP Root Guard: This prevents edge devices not in the network administratorâ™s control from becoming Spanning Tree<br /><br />DHCP Snooping: Filters out DHCP messages with unregistered IP addresses and/or from unexpected or untrusted interfaces. This prevents rogue devices from behaving as a DHCP Server<br /><br />IP Source Guard (IPSG): When IP Source Guard is enabled at a port, the switch filters out IP packets received from the port if the source IP addresses of the packets have not been statically configured or dynamically learnedfrom DHCP snooping. This prevents IP Address Spoofing<br /><br />Dynamic ARP Inspection (DAI): The switch discards ARP packets from a port if there are no static or dynamic IP/MAC bindings or if there is a discrepancy between the source or destination address in the ARP packet. This prevents man-in-the-middle attacks<br /><br />IP/Mac/Port Binding (IPMB): The features (DHCP Snooping, IP Source Guard, and Dynamic ARP Inspection) above work together to prevent DOS attacks in the network, thereby increasing network availability<br /><br />Secure Core Technology: Ensures that the switch will receive and process management and protocol traffic no matter how much traffic is received<br /><br />Secure Sensitive Data (SSD): A mechanism to manage sensitive data (such as passwords, keys, etc.) securely on the switch, populating this data to other devices, and secure autoconfig. Access to view the sensitive data asplaintext or encrypted is provided according to the user configured access level and the accessmethod of the user<br /><br />Layer 2 Isolation Private VLAN Edge (PVE) with community VLAN: PVE (also known as protected ports) provides Layer 2 isolation between devices in the same VLAN, supports multiple uplinks<br /><br />Port Security: Locks MAC addresses to ports, and limits the number of learned MAC addresses<br /><br />RADIUS/TACACS+: Supports RADIUS and TACACS authentication. Switch functions as a client<br /><br />Storm Control: Broadcast, multicast, and unknown unicast<br /><br />DoS Prevention: DoS attack prevention<br /><br />Congestion Avoidance: A TCP congestion avoidance algorithm is required to minimize and prevent global TCP loss synchronization<br /><br />ACLs: Support for up to 512 rules<br />Drop or rate limit based on source and destination MAC, VLAN ID or IP address, protocol, port, differentiated services code point/IP precedence, TCP/ UDP source and destination ports, 802.1p priority, Ethernet type, Internet Control Message Protocol packets, IGMP packets, TCP flag</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Quality of Service</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Priority Levels: 4 hardware queues<br /><br />Scheduling: Strict priority and weighted round-robin<br />Queue assignment based on DSCP and class of service (802.1p/CoS) <br /><br />Class of Service: Port based; 802.1p VLAN priority based; IPv4/v6 IP precedence/type of service/DSCP based; Differentiated Services (DiffServ); classification and re-marking ACLs, trusted QoS</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Standards</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">IEEE 802.3 10BASE-T Ethernet, IEEE 802.3u 100BASE-TX Fast Ethernet, IEEE 802.3ab 1000BASE-T Gigabit Ethernet, IEEE 802.3ad LACP, IEEE 802.3z Gigabit Ethernet, IEEE 802.3x Flow Control, IEEE 802.1D (STP, GARP, and GVRP),IEEE 802.1Q/p VLAN, IEEE 802.1w RSTP, IEEE 802.1s Multiple STP, IEEE 802.1X Port Access Authentication, IEEE 802.3af, IEEE 802.3at, RFC 768, RFC 783, RFC 791, RFC 792, RFC 793, RFC 813, RFC 879, RFC 896, RFC 826, RFC 854, RFC 855, RFC 856, RFC 858, RFC 894, RFC 919, RFC 922, RFC 920, RFC 950, RFC 951, RFC 1042, RFC 1071, RFC 1123, RFC 1141, RFC 1155, RFC 1157, RFC 1350, RFC 1533, RFC 1541, RFC 1542, RFC 1624, RFC 1700, RFC 1867, RFC 2030, RFC 2616, RFC 2131, RFC 2132, RFC 3164, RFC 3411, RFC 3412, RFC 3413, RFC 3414, RFC 3415, RFC 2576, RFC 4330, RFC 1213, RFC 1215, RFC 1286, RFC 1442, RFC 1451, RFC 1493, RFC 1573, RFC 1643, RFC 1757, RFC 1907, RFC 2011, RFC 2012, RFC 2013, RFC 2233, RFC 2618, RFC 2665, RFC 2666, RFC 2674, RFC 2737, RFC 2819, RFC 2863, RFC 1157, RFC 1493, RFC 1215, RFC 3416</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">IPv6</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">IPv6: IPv6 host mode<br />IPv6 over Ethernet<br />Dual IPv6/IPv4 stack<br />IPv6 neighbor and router discovery<br />IPv6 stateless address auto-configuration<br />Path maximum transmission unit discovery<br />Duplicate address detection<br />ICMP version 6<br />IPv6 over IPv4 network with Intra-Site Automatic Tunnel Addressing Protocol support<br /><br />IPv6 QoS: Prioritize IPv6 packets in hardware<br /><br />IPv6 ACL: Drop or rate, limit IPv6 packets in hardware<br /><br />Multicast Listener Discovery Snooping: Deliver IPv6 multicast packets only to the required receivers</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Management</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Web User Interface: Built-in switch configuration utility for easy browser-based device configuration (HTTP/HTTPS). Supports configuration, system dashboard, system maintenance and monitoring<br /><br />SNMP: SNMP versions 1, 2c, and 3 with support for traps, and SNMP version 3 user-based security model<br /><br />Remote Monitoring: Embedded RMON software agent supports 4 RMON groups (history, statistics, alarms and events) for enhanced traffic management, monitoring and analysis<br /><br />IPv4 and IPv6 Dual Stack: Coexistence of both protocol stacks to ease migration<br /><br />Firmware Upgrade: Web browser upgrade (HTTP/HTTPS) and TFTP<br />Upgrade can be initiated through console port as well<br />Dual images for resilient firmware upgrades<br /><br />Port Mirroring: Traffic on a port can be mirrored to another port for analysis with a network analyzer or RMON probe. Up to 8 source ports can be mirrored to one destination port. A single session is supported<br /><br />VLAN Mirroring: Traffic from a VLAN can be mirrored to a port for analysis with a network analyzer or RMON probe. Up to 8 source VLANs can be mirrored to one destination port. A single session is supported<br /><br />Dynamic Host Configuration Protocol (Options 66, 67, 82, 129 and 150): DHCP Options facilitate tighter control from a central point (DHCP server) to obtain IP address, auto-configuration (with configuration file download), DHCP relay, and hostname<br /><br />Secure Copy (SCP): Securely transfer files to and from the switch<br /><br />Auto-configuration with Secure Copy (SCP) File Download:Enables secure mass deployment with protection of sensitive data<br /><br />Text-Editable Config Files: Config files can be edited with a text editor and downloaded to another switch, facilitating easier mass deployment<br /><br />Smartports: Simplified configuration of QoS and security capabilities<br /><br />Auto Smartports: Applies the intelligence delivered through the Smartport roles and applies it automatically to the port based on the devices discovered over CDP or LLDP-MED. This facilitates zero touch deployments Textview CLI: Scriptable command-line interface. A full CLI as well as a menu-based CLI is supported<br /><br />Cloud Services: Support for Cisco Small Business FindIT Network Discovery Utility<br /><br />Localization: Localization of GUI and documentation into multiple languages<br /><br />Other Management: Traceroute; single IP management; HTTP/HTTPS; SSH; RADIUS; port mirroring; TFTP upgrade; DHCP client; BOOTP; SNTP; Xmodem upgrade; cable diagnostics; ping; syslog; Telnet client (SSH secure support)<br /><br />Time-Based Port Operation: Link up or down based on user-defined schedule (when the port is administratively up)<br /><br />Login Banner: Configurable multiple banners for web as well as CLI</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Power Efficiency</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Energy Detect: Automatically turns off power off on Gigabit Ethernet RJ-45 port when detecting link down<br />Active mode is resumed without loss of any packets when the switch detects the link up<br /><br />Cable Length Detection: Adjusts the signal strength based on the cable length. It reduces the power consumption for cables shorter than 10 m<br /><br />Disable Port LEDs:LEDs can be manually turned off to save on Energy</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">General Features</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Jumbo Frames: Frame sizes up to 10 KB supported on 10/100 and Gigabit interfaces<br /><br />MAC Table: Up to 8000 MAC addresses</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Discovery</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Bonjour: Bonjour locates devices such as printers, other computers and the services that those devices offer on a local network using multicast Domain Name System (mDNS) service records<br /><br />Link Layer Discovery Protocol (802.1ab) with LLDP-MED Extensions: LLDP allows the switch to advertise its identification, configuration and capabilities to neighboring devices that store the data in a MIB. LLDP-MED is an enhancement to LLDP that adds the extensions needed for IP phones<br /><br />Cisco Discovery Protocol (CDP): CDP is a proprietary data link layer and network layer protocol which is used to share information about other directly connected Cisco equipment, such as the operating system version and IP address</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">PoE Features</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">IEEE 802.3af PoE delivered over any of the RJ-45 ports within the listed power budgets<br />Power Dedicated to PoE: 180W<br />Number of Ports That Support PoE: 24</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Power Consumption</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Power Savings Mode: Energy Detect<br />System Power Consumption: 110 V, 26.7 W 220 V, 27.9 W<br />Power Consumption Case: 110 V, 218.57 W 220 V, 213.35 W<br />Heat Dissipation: 727.98 BTU/hr</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Ports</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Total System Ports: 24 Fast Ethernet + 4 Gigabit Ethernet <br />RJ-45 Ports: 24 Fast Ethernet, 2 Gigabit Ethernet<br />Combo Ports (RJ-45 + SFP): 2 Gigabit Ethernet Combo</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Buttons</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Reset Button</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Cabling Type</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Unshielded twisted pair Category 5 or better for 10BASE-T/100BASE-TX; UTP Category 5 Ethernet or better for 1000BASE-T</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">LEDs</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">System, Link/Act, PoE, Speed, LED power saving option</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Flash</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">16 MB</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">CPU</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">128 MB</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Packet Buffer Memory</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">8 Mb</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Power Supply</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">100 to 240 V, 47 to 63 Hz, internal, universal</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Fan</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">2 Pieces</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Acoustic Noise</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">40.4 dB</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">MTBF</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">At 40Â°C (hours): 171,504</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Certifications</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">UL (UL 60950), CSA (CSA 22.2), CE mark, FCC Part 15 (CFR 47) Class A</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Environmental Requirements</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Operating Temperature: 32 to 113Â°F (0Â°to 45Â°C) <br />Storage Temperature: -4 to +158Â°F (-20 to +70Â°C) <br />Operating Humidity: 10 to 90%, relative (non-condensing) <br />Storage Humidity: 10 to 90%, relative (non-condensing)</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Minimum Requirements</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Web Browser: Mozilla Firefox version 8 or later; Microsoft Internet Explorer version 7 or later<br />Category 5 Ethernet network cable<br />TCP/IP, network adapter and network operating system (such as Microsoft Windows, Linux or Mac OS X) installed on each computer in the network</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Dimensions</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">17.30 x 1.45 x 10.10â (44.00 x 4.44 x 25.70 cm)</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Weight</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">8.25 lb (3.74 kg)</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<table class=\"specTable\" data-selenium=\"specTable\">\r\n<tbody data-selenium=\"specBody\">\r\n<tr><th class=\"specHeader Header\" colspan=\"2\" data-selenium=\"specHeader\"><a id=\"shipping\" class=\"fs32 OpenSans-300-normal\" name=\"shipping\" data-selenium=\"specHeaderLink\"></a>Packaging Info</th></tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Package Weight</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">11.0 lb</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Box Dimensions (LxWxH)</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">21.26 x 15.197 x 4.173\"</td>\r\n</tr>\r\n</tbody>\r\n</table>'),('377',76,0,'127','<ul class=\"top-section-list\" data-selenium=\"highlightList\">\r\n<li class=\"top-section-list-item\">24 x 10/100 PoE Ports</li>\r\n<li class=\"top-section-list-item\">2 x Combo Mini-GBIC Ports</li>\r\n<li class=\"top-section-list-item\">128 MB RAM</li>\r\n<li class=\"top-section-list-item\">16 MB Flash Memory</li>\r\n<li class=\"top-section-list-item\">QoS Support</li>\r\n<li class=\"top-section-list-item\">IPv4/IPv6 Support</li>\r\n<li class=\"top-section-list-item\">Advanced Security Management</li>\r\n<li class=\"top-section-list-item\">Auto Voice VLAN Capabilities</li>\r\n<li class=\"top-section-list-item\">Energy-Efficient Ethernet</li>\r\n<li class=\"top-section-list-item\">Mac, Windows, Linux Compatible</li>\r\n</ul>\r\n<div class=\"ov-wrapper js-overview-desc\">\r\n<div class=\"ov-desc\">\r\n<p>The <strong>SF300-24PP 24-Port 10/100 Gigabit PoE Managed Switch from Cisco</strong> delivers the features you need to improve the availability of your critical business applications, protect sensitive data and optimize network bandwidth to deliver information and applications more effectively. It provides a reliable foundation for your business network. The Cisco SG300-24PP is easy to set up and use and it provides a suitable combination of affordability and capabilities for small businesses and helps you create an efficient and an optimal connected workforce.</p>\r\nThe Cisco SG300-24PP has the advanced security management capabilities and network features you need to support business-class data, voice, security and wireless technologies. At the same time, it is simple to deploy and configure, allowing you to take advantage of the managed network service your business requires.</div>\r\n</div>\r\n<div class=\"sectionHeaders js-hiddenFeatures\" data-selenium=\"sectionHeaders\"><dl class=\"js-featureSectionDL\" data-tickertarget=\"ov-ft-2\"><dt class=\"featureTitle\"><strong>Secure Desktop Connectivity</strong></dt><dd class=\"c28\">The Cisco SG300-24PP switch can simply and securely connect employees working in small offices with each other and with all of the servers, printers and other devices they use. High performance and reliable connectivity helps speed file transfers and data processing, improves network uptime and keeps your employees connected and productive.</dd></dl><dl class=\"js-featureSectionDL\" data-tickertarget=\"ov-ft-3\"><dt class=\"featureTitle\"><strong>Secure Connectivity</strong></dt><dd class=\"c28\">Power over Ethernet, Auto Smartports, QoS, VLAN and Access Control features, the Cisco 300 Series Switches that add Business Grade wireless to an SMB network.</dd></dl><dl class=\"js-featureSectionDL\" data-tickertarget=\"ov-ft-4\"><dt class=\"featureTitle\"><strong>Unified Communications</strong></dt><dd class=\"c28\">As a managed network solution, the Cisco SG300-24PP switch provides the performance and advanced traffic-handling intelligence you need to deliver all communications and data over a single network. The Cisco SG300-24PP is tested to help ensure easy integration and full compatibility with Cisco and other products, providing a complete small business solution.</dd></dl><dl class=\"js-featureSectionDL\" data-tickertarget=\"ov-ft-5\"><dt class=\"featureTitle\"><strong>Secure Guest Connectivity</strong></dt><dd class=\"c28\">The Cisco SG300-24PP switch lets you extend highly secure network connectivity to guests in a variety of settings, such as a hotel, an office waiting room or any other area open to non-employee users. Using powerful but easy-to-configure security and traffic segmentation capabilities, you can isolate your vital business traffic from guest services and keep guests\' network sessions private from each other.</dd></dl><dl class=\"js-featureSectionDL\" data-tickertarget=\"ov-ft-6\"><dt class=\"featureTitle\"><strong>High performance and reliability</strong></dt><dd class=\"c28\">The Cisco SG300-24PP Switch is rigorously tested to deliver the high availability and performance you expect from a Cisco switch. The solution speeds up file transfer times and improves slow, sluggish networks, while keeping your vital business applications available and preventing costly downtime. As a managed switching solution, the Cisco SG300-24PP also gives you the flexibility to manage and prioritize high-bandwidth traffic such as voice. That means you can empower your employees with state-of-the-art communication and productivity solutions, without draining the performance of your other business applications.</dd></dl><dl class=\"js-featureSectionDL\" data-tickertarget=\"ov-ft-7\"><dt class=\"featureTitle\"><strong>User-Friendly Setup and Configuration</strong></dt><dd class=\"c28\">The Cisco SG300-24PP switch is designed to be easy to use and managed by small businesses and the partners who serve them. The included device manager software provides an intuitive, web-based interface to simplify setup, security and quality of service (QoS) traffic prioritization, allowing even users without IT expertise to configure the switch in minutes. It also provides a Cisco FindIT Network Discovery Utility. This utility works through a simple toolbar on the user\'s web browser to discover Cisco devices in the network and display basic information, such as serial numbers and IP addresses, to aid in the configuration and deployment of Cisco Small Business products. The switch uses Cisco Discovery Protocol as well as Link Layer Discovery Protocol (LLDP-MED) to automatically detect all the devices connected to your network and then automatically configures them for the appropriate connectivity and instructs the devices to use appropriate voice VLAN or QoS parameters. For more advanced capabilities and hands-on control, the switch supports Smartport roles which configure the ports with specific levels of Security, QoS and availability according to the type of connected device, based on Cisco best practices and pretested configurations. The Auto Smartports feature applies the intelligence delivered through the Smartport roles and applies it automatically to the port based on the devices discovered over CDP or LLDP-MED. This facilitates zero touch deployments. Although the Cisco SG300-24PP is designed to be deployed without using a command-line interface, Cisco Textview is available for those who prefer to use text-based configuration. Together, these features reduce the time your staff must devote to network deployment, management and troubleshooting.</dd></dl><dl class=\"js-featureSectionDL\" data-tickertarget=\"ov-ft-8\"><dt class=\"featureTitle\"><strong>Strong Security</strong></dt><dd class=\"c28\">The Cisco SG300-24PP switch provides a high level of security and gives you fine-grained control to safeguard your network from unauthorized users. Its features include: Embedded security to protect management data traveling to and from the switch and encrypt network communications.<br />Extensive access control lists to restrict sensitive portions of the network from unauthorized users and guard against network attacks.<br />Guest virtual LANs let you provide Internet connectivity to non-employee users while isolating critical business services from guest traffic.<br />Support for advanced network security applications such as IEEE 802.1X port security to tightly limit access to specific segments of your network.<br />Security mechanisms such as Bridge Protocol Data Unit Guard and broadcast/multicast/unknown unicast storm control, protect the network from invalid configurations or malicious intent.<br />Secure Core Technology helps ensure that the switch will receive and process management and protocol traffic no matter how much traffic is received.</dd></dl><dl class=\"js-featureSectionDL\" data-tickertarget=\"ov-ft-9\"><dt class=\"featureTitle\"><strong>Power over Ethernet</strong></dt><dd class=\"c28\">The Cisco SF300-24PP switch features 24 PoE ports of fast Ethernet. This capability simplifies advanced technology deployments such as IP telephony, wireless and IP surveillance by allowing you to connect and power network endpoints over a single Ethernet cable. With no need to install separate power supplies for IP phones or wireless access points, you can take advantage of advanced communications technologies more quickly and at a lower cost.</dd></dl><dl class=\"js-featureSectionDL\" data-tickertarget=\"ov-ft-10\"><dt class=\"featureTitle\"><strong>IP Telephony Support</strong></dt><dd class=\"c28\">The Cisco SG300-24PP switch includes embedded QoS intelligence to prioritize delay-sensitive services such as voice and video, simplify unified communications deployments and help ensure consistent network performance for all services. For example, automated voice VLAN capabilities let you plug any IP phone (including third-party phones) into your IP telephony network and receive an immediate dial tone. The switch automatically configures the device with the right VLAN and QoS parameters to prioritize voice traffic.</dd></dl><dl class=\"js-featureSectionDL\" data-tickertarget=\"ov-ft-11\"><dt class=\"featureTitle\"><strong>Advanced Network Management Capabilities</strong></dt><dd class=\"c28\">As a managed switch, the Cisco SG300-24PP switch lets you use a variety of advanced features to control traffic over your network. Features include: Static routing/Layer 3 switching between VLANs: This capability allows you to segment your network into separate workgroups and communicate across VLANs without degrading application performance. As a result, you can manage internal routing with your switch and dedicate your router to external traffic and securities, helping your network run more efficiently.<br />IPv6 support: As the IP network addressing scheme evolves to accommodate more devices, you can make sure that your network is ready. The The Cisco SG300-24PP switch provides native support for IPv6, the newest version of the Internet Protocol, as well as the previous IPv4 standard. As a result, you will be able to move up to the next generation of networking applications and operating systems without an extensive equipment upgrade.<br />Dual image support: With the ability to maintain dual images of your switches, you can perform software upgrades without having to take the network offline and without worrying about an outage during an upgrade.<br />Remote management: Using Simple Network Management Protocol, you can set up and manage all switches and other Cisco devices in your network remotely, instead of having to directly connect to them.</dd></dl><dl class=\"js-featureSectionDL\" data-tickertarget=\"ov-ft-12\"><dt class=\"featureTitle\"><strong>Optimal Energy Efficiency</strong></dt><dd class=\"c28\">The Cisco SG300-24PP \"green\" switch designed with power-saving features optimizes power use to protect the environment and reduces energy costs, without compromising performance. Power-saving features include: The latest application-specific integrated circuits, using low-power 65-nanometer technology (these chipsets allow for lower power consumption and thinner, more efficient designs).<br />Automatic power shutoff on PoE ports when a link is down.<br />Embedded intelligence to adjust signal strength based on cable length.<br />Fanless design which reduces power consumption, increases reliability and provides quieter operation.</dd></dl><dl class=\"js-featureSectionDL\" data-tickertarget=\"ov-ft-13\"><dt class=\"featureTitle\"><strong>Expansion Ports</strong></dt><dd class=\"c28\">The Cisco SG300-24PP switch provides more ports per Gigabit Ethernet switch than traditional switch models, giving you more flexibility to connect and empower your business. It also offers mini gigabit interface converter (mini-GBIC) expansion slots that give you the option to add fiber-optic or Gigabit Ethernet uplink connectivity to the switch. With the ability to increase the connectivity range of the switch, you have more flexibility to design your network around your unique business environment and to easily connect switch on different floors or across the business.</dd></dl><dl class=\"js-featureSectionDL\" data-tickertarget=\"ov-ft-14\"><dt class=\"featureTitle\"><strong>Multi-Language</strong></dt><dd class=\"c28\">The Cisco 300 Series is available in seven languages: English, French, German, Italian, Spanish, Japanese, and simplified Chinese. All product user interfaces and documentation are translated, giving you the ability to select your preferred language.</dd></dl><dl class=\"js-featureSectionDL\" data-tickertarget=\"ov-ft-15\"><dt class=\"featureTitle\"><strong>Security and Investment Protection</strong></dt><dd class=\"c28\">The Cisco SG300-10P switch offers the reliable performance, investment protection and peace of mind you expect from a Cisco switch. When you invest in the Cisco SG300-10P switch, you gain the benefit of: <br />Rigorous testing helps ensure easy integration and compatibility with other Cisco networking and communications products, including the complete Cisco Small Business portfolio.</dd></dl><dl class=\"js-featureSectionDL\" data-tickertarget=\"ov-ft-16\"><dt class=\"featureTitle\"><strong>Service and Support</strong></dt><dd class=\"c28\">The Cisco SG300-24PP switch is backed by the Cisco Small Business Support Service, which provides affordable peace-of-mind coverage. This subscription-based service helps you protect your investment and derive maximum value from Cisco Small Business products. This service includes software updates, access to the Cisco Small Business Support Center, and extends technical service to three years. Cisco Small Business products are supported by professionals in Cisco Small Business Support Center locations worldwide who are specifically trained to understand your needs. The Cisco Small Business Support Community, an online forum, enables you to collaborate with your peers and reach Cisco technical experts for support information.</dd></dl></div>'),('378',85,0,'127','Cisco SF300-24PP 24-Port 10/100 PoE Managed Switch with Gigabit Uplinks'),('379',75,0,'128','<table class=\"specTable\" data-selenium=\"specTable\">\r\n<tbody data-selenium=\"specBody\">\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Performance</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Capacity in Mpps (64-byte packets): 11.19 <br /><br />Switching Capacity in Gbps: 13.6</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Layer 2 Switching</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Spanning Tree Protocol: Standard 802.1d STP support<br />Fast convergence using 802.1w (Rapid Spanning Tree), enabled by default<br /><br />Port Grouping: Support for IEEE 802.3ad Link Aggregation Control Protocol<br />• Up to 4 groups <br />8 candidate ports for each (dynamic) 802.3ad link aggregation<br /><br />VLAN: 16 VLANs supported<br />Port-based and 802.1Q tag-based VLANs<br /><br />Voice VLAN: Voice traffic is automatically assigned to a voice-specific VLAN and treated with appropriate levels of QoS<br /><br />Internet Group Management Protocol Versions 1 and 2 Snooping: Internet Group Management Protocol limits bandwidth-intensive multicast traffic to only the requesters; supports 256 multicast groups<br /><br />Head-of-Line (HOL) Blocking: Head-of-line blocking</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Security</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">IEEE 802.1X (Authenticator Role): RADIUS authentication and accounting, MD5 hash<br /><br />Port Security: Locks MAC addresses to ports and limits the number of learned MAC addresses<br /><br />Storm Control: Broadcast, multicast and unknown unicast</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Quality of Service</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Priority Levels: 4 hardware queues<br /><br />Scheduling: Strict priority and weighted round-robin<br />Queue assignment based on differentiated services code point (DSCP) and class of service (802.1p/CoS)<br /><br />Class of Service: Port based, 802.1p VLAN priority based, IPv4/v6 IP precedence/type of service (ToS)/DSCP based, Differentiated Services (DiffServ)<br /><br />Rate Limiting: Ingress policer, per VLAN and per port</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Standards</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">IEEE 802.3 10BASE-T Ethernet, IEEE 802.3u 100BASE-TX Fast Ethernet, IEEE 802.3ab 1000BASE-T Gigabit Ethernet, IEEE 802.3ad LACP, IEEE 802.3z Gigabit Ethernet, IEEE 802.3x Flow Control, IEEE 802.1D (STP), IEEE 802.1Q/p VLAN, IEEE 802.1w RSTP, IEEE 802.1X Port Access Authentication, IEEE 802.3af, RFC 768, RFC 783, RFC 791, RFC 792, RFC 793, RFC 813, RFC 879, RFC 896, RFC 826, RFC 854, RFC 855, RFC 856, RFC 858, RFC 894, RFC 919, RFC 922, RFC 920, RFC 950, RFC 951, RFC 1042, RFC 1071, RFC 1123, RFC 1141, RFC 1155, RFC 1350, RFC 1533, RFC 1541, RFC 1542, RFC 1624, RFC 1700, RFC 1867, RFC 2030, RFC 2616, RFC 2131, RFC 2132, RFC 3164, RFC 2618</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">IPv6</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">IPv6: IPv6 host mode<br />IPv6 over Ethernet<br />Dual IPv6/IPv4 stack<br />IPv6 neighbor and router discovery (ND)<br />IPv6 stateless address auto-configuration<br />Path maximum transmission unit discovery<br />Duplicate address detection<br />Internet Control Message Protocol version 6<br />IPv6 over IPv4 network with Intra-Site Automatic Tunnel Addressing Protocol support<br /><br />IPv6 QoS: Prioritize IPv6 packets in hardware<br /><br />Multicast Listener Discovery Snooping: Deliver IPv6 multicast packets only to the required receivers<br /><br />IPv6 Applications: Web, ping, Simple Network Time Protocol, Trivial File Transfer Protocol, RADIUS, syslog, DNS client<br /><br />IPv6 RFCs Supported: RFC 2463: ICMP version 6<br />RFC 3513: IPv6 address architecture<br />RFC 4291: IPv6 addressing architecture<br />RFC 2460: IPv6 specification<br />RFC 2461: Neighbor discovery for IPv6<br />RFC 2462: IPv6 stateless address auto-configuration<br />RFC 1981: Path maximum transmission unit discovery<br />RFC 4007: IPv6 scoped address architecture<br />RFC 3484: Default address selection mechanism<br />RFC 4214: ISATAP tunneling<br />RFC 4293: MIB IPv6: Textual conventions and general group<br />RFC 3595: Textual conventions for IPv6 flow label</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Management</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Web User Interface: Built-in switch configuration utility for easy browser-based device configuration (HTTP). Supports configuration, system dashboard, system maintenance and monitoring<br /><br />Remote Monitoring: Embedded RMON software agent supports one RMON group (statistics) for enhanced traffic management, monitoring and analysis<br /><br />IPv4 and IPv6 Dual Stack: Coexistence of both protocol stacks to ease migration<br /><br />Firmware Upgrade: Web browser upgrade (HTTP) and TFTP<br /><br />Port Mirroring: Traffic on a port can be mirrored to another port for analysis with a network analyzer or RMON probe. Up to 4 source ports can be mirrored to one destination port. A single session is supported<br /><br />VLAN Mirroring: Traffic from a VLAN can be mirrored to a port for analysis with a network analyzer or RMON probe. Up to 4 source VLANs can be mirrored to one destination port. A single session is supported<br /><br />Dynamic Host Configuration Protocol (Options 66 and 67): Dynamic Host Configuration Protocol options facilitate tighter control from a central point (DHCP server) to obtain IP address, auto-configuration (with configuration file download)<br /><br />Text-Editable Config Files: Config files can be edited with a text editor and downloaded to another switch, facilitating easier mass deployment<br /><br />Smartports: Simplified configuration of QoS and security capabilities<br /><br />Cloud Services: Support for FindIT Network Discovery Utility<br /><br />Localization: Localization of GUI and documentation into multiple languages<br /><br />Other Management: HTTP, RADIUS, port mirroring, TFTP upgrade, DHCP client, BOOTP, SNTP, ping, syslog</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Power Efficiency</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Energy Detect: Automatically turns off power on Gigabit Ethernet RJ-45 port when the switch detects a link down<br />Active mode is resumed without loss of any packets when the switch detects the link is back up<br /><br />Cable Length Detection: Adjusts the signal strength based on the cable length. Reduces the power consumption for cables shorter than 10 m</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">General Features</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Jumbo Frames: Frame sizes up to 9K<br /><br />MAC Table: Up to 8000 MAC addresses</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Discovery</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Link Layer Discovery Protocol (802.1ab) with LLDP-MED Extensions: Link Layer Discovery Protocol allows the switch to advertise its identification, configuration and capabilities to neighboring devices, which store the data in an MIB. LLDP-MED is an enhancement to LLDP that adds the extensions needed for IP phones<br /><br />Cisco Discovery Protocol: The switch advertises itself using the Cisco Discovery Protocol</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Power Consumption</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Power Savings Mode: Auto power down for link down <br /><br />Power Consumption Worst Case: 110V/P=6.7W<br />220V/P=7.21W <br /><br />Heat Dissipation (BTU/hr): 24.6</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Ports</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">8 Gigabit Ethernet RJ-45 ports</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Buttons</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Reset button</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Cabling Type</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Unshielded twisted pair Category 5 or better for 10BASE-T/100BASE-TX; Unshielded twisted pair Category 5 Ethernet or better for 1000BASE-T</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">LEDs</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">System, Link/Act, Speed</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Flash</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">8 MB</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">CPU</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">32 MB memory</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Packet Buffer Memory</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">4 MB</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Power Supply</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">External: 100V-240 V, 0.5 A, 50-60 HZ</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Fan</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">No</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Acoustic Noise</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">N/A</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">MTBF</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">@ 40°C (hours): 71,834</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Certifications</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">UL (UL 60950), CSA (CSA 22.2), CE mark, FCC Part 15 (CFR 47) Class A</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Environmental Requirements</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Operating Temperature: 32 to 104°F (0 to 40°C)<br />Storage Temperature: -4 to 158°F (-20 to 70°C)<br />Operating Humidity: 10 to 90%, relative, non condensing<br />Storage Humidity: 10 to 90%, relative, non condensing</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Minimum Requirements</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Web Browser: Mozilla Firefox version 2.5 or later; Microsoft Internet Explorer version 6 or later<br />Category 5 Ethernet network cable<br />TCP/IP, network adapter and network operating system (such as Microsoft Windows, Linux, or Mac OS X) installed on each computer in the network</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Dimensions (W x H x D)</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">4.45 x 1.06 x 5.12\" (113 x 27 x 130 mm)</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Weight</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">1.65 lb (0.75 kg)</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<table class=\"specTable\" data-selenium=\"specTable\">\r\n<tbody data-selenium=\"specBody\">\r\n<tr><th class=\"specHeader Header\" colspan=\"2\" data-selenium=\"specHeader\"><a id=\"shipping\" class=\"fs32 OpenSans-300-normal\" name=\"shipping\" data-selenium=\"specHeaderLink\"></a>Packaging Info</th></tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Package Weight</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">1.8 lb</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Box Dimensions (LxWxH)</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">11.3 x 7.9 x 2.5\"</td>\r\n</tr>\r\n</tbody>\r\n</table>'),('380',76,0,'128','<ul class=\"top-section-list\" data-selenium=\"highlightList\">\r\n<li class=\"top-section-list-item\">8x Gigabit Ethernet Ports</li>\r\n<li class=\"top-section-list-item\">QoS Support</li>\r\n<li class=\"top-section-list-item\">IPv4 / IPv6 Support</li>\r\n<li class=\"top-section-list-item\">Auto Voice VLAN Capabilities</li>\r\n<li class=\"top-section-list-item\">Advanced Network Management</li>\r\n<li class=\"top-section-list-item\">Energy-Efficient</li>\r\n</ul>\r\n<div class=\"ov-wrapper js-overview-desc\">\r\n<div class=\"ov-desc\">\r\n<p>The <span><strong>Cisco SG200-08 8-Port 10/100/1000 Gigabit Ethernet Switch</strong> </span>lets you achieve business-class network security and performance at an affordable price. It provides an ideal solution when you require a reliable solution to share network resources and connect computers, printers and servers.</p>\r\n<p>The expandable fast Cisco Ethernet SG200-08 smart switch provides basic management, security and quality-of-service features beyond those of an unmanaged or consumer-grade switch, at a lower cost than managed switches. And with an easy-to-use web user interface, Cisco Discovery Protocol and Cisco Smartports you can deploy and configure a rock-solid business network in minutes.</p>\r\n</div>\r\n</div>\r\n<div class=\"sectionHeaders js-hiddenFeatures\" data-selenium=\"sectionHeaders\"><dl class=\"js-featureSectionDL\" data-tickertarget=\"ov-ft-2\"><dt class=\"featureTitle\"><strong>High-Speed Desktop Connectivity</strong></dt><dd class=\"c28\">The Cisco SG200-08 switch can quickly and securely connect employees working in small offices with one another and with all of the servers, printers and other devices they use. High performance and reliable connectivity help speed file transfers and data processing, improve network uptime and keep your employees connected and productive.</dd></dl><dl class=\"js-featureSectionDL\" data-tickertarget=\"ov-ft-3\"><dt class=\"featureTitle\"><strong>Secure Wireless Connectivity</strong></dt><dd class=\"c28\">The Cisco SG200-08 switch works with Cisco and third-party wireless solutions to extend the reach of your network. Employees can work productively from conference rooms and common areas, collaborate in any office, and access business applications from wherever they are. Gigabit Ethernet speed helps ensure that your employees have the bandwidth and performance they need to make the most of mobile productivity. And with embedded security, your employees can work with confidence, knowing that only authorized users can access the network and network applications.</dd></dl><dl class=\"js-featureSectionDL\" data-tickertarget=\"ov-ft-4\"><dt class=\"featureTitle\"><strong>Unified Communications</strong></dt><dd class=\"c28\">The Cisco SG200-08 provides QoS features to enable you to prioritize delay-sensitive traffic in your network and let you converge all of your communications solutions such as IP telephony and video surveillance over a single Ethernet network. Cisco SG200-08 offers a complete portfolio of IP telephony and other unified communications products designed for small businesses and Cisco SG200-08 switch has been rigorously tested to help ensure easy integration and full compatibility with Cisco and other vendor products.</dd></dl><dl class=\"js-featureSectionDL\" data-tickertarget=\"ov-ft-5\"><dt class=\"featureTitle\"><strong>Easy Configuration and Management</strong></dt><dd class=\"c28\">The Cisco SG200-08 switch is designed to be easy to deploy and use by small businesses or the partners that serve them. Simple-to-use web-based interfaces reduce the time it takes to deploy, manage and troubleshoot your network. Key features include:<br />• Cisco Discovery Protocol that simplifies setup by discovering all connected Cisco devices and allowing them to share information.<br />• Cisco Smartports technology that automatically configures switch ports for different connected devices (PCs, IP phones, wireless access points) based on pre-tested Cisco best practices.<br />• Cisco FindIT Network Discovery Utility that works through a simple toolbar on the user\'s web browser to discover Cisco devices on the network and display basic information, such as serial numbers and IP addresses, to aid in the configuration and speed the deployment of Cisco Small Business products.</dd></dl><dl class=\"js-featureSectionDL\" data-tickertarget=\"ov-ft-6\"><dt class=\"featureTitle\"><strong>Performance and Reliability</strong></dt><dd class=\"c28\">The Cisco SG200-08 switch has been tested to deliver the high availability and performance you expect from a Cisco switch and helps you prevent costly downtime. The Cisco SG200-08 switch speeds file transfer times, improves slow and sluggish networks, keeps your vital business applications available and helps your employees respond more quickly to customers and each other. With a network based on Cisco SG200-08 switch, you can address all of your business communication and connectivity needs and reduce the total cost of ownership of your technology infrastructure.</dd></dl><dl class=\"js-featureSectionDL\" data-tickertarget=\"ov-ft-7\"><dt class=\"featureTitle\"><strong>Network Security</strong></dt><dd class=\"c28\">The Cisco SG200-08 switch provides basic security and network management features you need to maintain a level of security for your business, keep unauthorized users off the network and protects your business data. The switch provides integrated network security to reduce the risk of a security breach, with IEEE 802.1X port security to control access to your network.</dd></dl><dl class=\"js-featureSectionDL\" data-tickertarget=\"ov-ft-8\"><dt class=\"featureTitle\"><strong>IP Telephony Support</strong></dt><dd class=\"c28\">The Cisco SG200-08 switch includes QoS features to prioritize delay-sensitive services such as voice and video, simplifies unified communications deployments and helps ensure consistent network performance for all services. For example, Auto Voice VLAN capabilities let you plug any IP phone (including third-party phones) into your IP telephony network and receives an immediate dial tone. The switch automatically configures the device with the right VLAN and QoS parameters to prioritize voice traffic.</dd></dl><dl class=\"js-featureSectionDL\" data-tickertarget=\"ov-ft-9\"><dt class=\"featureTitle\"><strong>IPv6 Support</strong></dt><dd class=\"c28\">Internet service providers worldwide are moving to the latest version of Internet Protocol to accommodate the growing number of network devices. Cisco SG200-08 switch provides native support for IPv6 alongside traditional IPv4. That means you can take full advantage of IPv6-enabled operating systems and applications in the future, without having to upgrade your network equipment.</dd></dl><dl class=\"js-featureSectionDL\" data-tickertarget=\"ov-ft-10\"><dt class=\"featureTitle\"><strong>Energy-Efficient Solution</strong></dt><dd class=\"c28\">The Cisco SG200-08 switch is designed to be eco-friendly without compromising performance. It helps conserve energy by optimizing power use, which helps protect the environment and lowers your energy costs. Power-saving features include:<br />• Automatic power down on Gigabit ports when a link is not active.<br />• Embedded intelligence to adjust power based on cable length.<br />• Fanless design which reduces power consumption, increases reliability and provides quieter operation.</dd></dl><dl class=\"js-featureSectionDL\" data-tickertarget=\"ov-ft-11\"><dt class=\"featureTitle\"><strong>Peace of Mind and Investment Protection</strong></dt><dd class=\"c28\">The Cisco SG200-08 offers the reliable performance, investment protection and peace of mind you expect from a Cisco switch. When you invest in the Cisco SG200-08 switch you gain the benefit of:<br />• Cisco Small Business Investment Protection Program, which lets you upgrade your Cisco SG200-08 switch to another Cisco Small Business or Cisco Catalyst switch in the future and receive credit for the value of the switch (available only in the United States and Canada).<br />• Rigorous testing to help ensure easy integration and compatibility with other Cisco networking and communications products, including the complete Cisco Small Business portfolio.</dd></dl></div>'),('381',85,0,'128','Cisco SG200-08 8-Port Gigabit Ethernet Switch'),('382',75,0,'129','<div class=\"h2-title new-page-width c45\">\r\n<h2>Cisco SG200-26 Specs</h2>\r\n</div>\r\n<div class=\"leftPanel\">\r\n<div class=\"specWrapper\" data-selenium=\"specWrapper\">\r\n<table class=\"specTable\" data-selenium=\"specTable\">\r\n<tbody data-selenium=\"specBody\">\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Performance</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Capacity in Mpps (64-byte packets): 38.69 <br /><br />Switching Capacity in Gbps: 52.0</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Layer 2 Switching</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Spanning Tree Protocol: Standard 802.1d STP support<br />Fast convergence using 802.1w (Rapid Spanning Tree), enabled by default<br /><br />Port Grouping: Support for IEEE 802.3ad Link Aggregation Control Protocol<br />• Up to 8 groups<br />• Up to 4 ports per group with 16 candidate ports for each (dynamic) 802.3ad link aggregation<br /><br />VLAN: Support for up to 128 VLANs simultaneously (out of 4096 VLAN IDs).<br />Port-based and 802.1Q tag-based VLANs<br /><br />Voice VLAN: Voice traffic is automatically assigned to a voice-specific VLAN and treated with appropriate levels of QoS<br /><br />Internet Group Management Protocol Versions 1 and 2 Snooping: Internet Group Management Protocol limits bandwidth-intensive multicast traffic to only the requesters; supports 256 multicast groups<br /><br />Head-of-Line (HOL) Blocking: Head-of-line blocking</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Security</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">IEEE 802.1X (Authenticator Role): RADIUS authentication and accounting, MD5 hash<br /><br />Port Security: Locks MAC addresses to ports and limits the number of learned MAC addresses<br /><br />Storm Control: Broadcast, multicast and unknown unicast</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Quality of Service</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Priority Levels: 4 hardware queues<br /><br />Scheduling: Strict priority and weighted round-robin <br />Queue assignment based on differentiated services code point (DSCP) and class of service (802.1p/CoS) <br /><br />Class of Service: Port based, 802.1p VLAN priority based, IPv4/v6 IP precedence/type of service (ToS)/DSCP based, Differentiated Services (DiffServ) <br /><br />Rate Limiting: Ingress policer, per VLAN and per port</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Standards</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">IEEE 802.3 10BASE-T Ethernet, IEEE 802.3u 100BASE-TX Fast Ethernet, IEEE 802.3ab 1000BASE-T Gigabit Ethernet, IEEE 802.3ad LACP, IEEE 802.3z Gigabit Ethernet, IEEE 802.3x Flow Control, IEEE 802.1D (STP), IEEE 802.1Q/p VLAN, IEEE 802.1w RSTP, IEEE 802.1X Port Access Authentication, IEEE 802.3af, RFC 768, RFC 783, RFC 791, RFC 792, RFC 793, RFC 813, RFC 879, RFC 896, RFC 826, RFC 854, RFC 855, RFC 856, RFC 858, RFC 894, RFC 919, RFC 922, RFC 920, RFC 950, RFC 951, RFC 1042, RFC 1071, RFC 1123, RFC 1141, RFC 1155, RFC 1350, RFC 1533, RFC 1541, RFC 1542, RFC 1624, RFC 1700, RFC 1867, RFC 2030, RFC 2616, RFC 2131, RFC 2132, RFC 3164, RFC 2618</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">IPv6</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">IPv6: IPv6 host mode<br />IPv6 over Ethernet<br />Dual IPv6/IPv4 stack<br />IPv6 neighbor and router discovery (ND)<br />IPv6 stateless address auto-configuration<br />Path maximum transmission unit discovery<br />Duplicate address detection <br />Internet Control Message Protocol version 6<br />IPv6 over IPv4 network with Intra-Site Automatic Tunnel Addressing Protocol support<br /><br />IPv6 QoS: Prioritize IPv6 packets in hardware<br /><br />Multicast Listener Discovery Snooping: Deliver IPv6 multicast packets only to the required receivers<br /><br />IPv6 Applications: Web, ping, Simple Network Time Protocol, Trivial File Transfer Protocol, RADIUS, syslog, DNS client<br /><br />IPv6 RFCs Supported: RFC 2463: ICMP version 6<br />RFC 3513: IPv6 address architecture<br />RFC 4291: IPv6 addressing architecture<br />RFC 2460: IPv6 specification<br />RFC 2461: Neighbor discovery for IPv6<br />RFC 2462: IPv6 stateless address auto-configuration<br />RFC 1981: Path maximum transmission unit discovery<br />RFC 4007: IPv6 scoped address architecture<br />RFC 3484: Default address selection mechanism<br />RFC 4214: ISATAP tunneling<br />RFC 4293: MIB IPv6: Textual conventions and general group<br />RFC 3595: Textual conventions for IPv6 flow label</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Management</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Web User Interface: Built-in switch configuration utility for easy browser-based device configuration (HTTP) Supports configuration, system dashboard, system maintenance and monitoring<br /><br />Remote Monitoring: Embedded RMON software agent supports one RMON group (statistics) for enhanced traffic management, monitoring and analysis<br /><br />IPv4 and IPv6 Dual Stack: Coexistence of both protocol stacks to ease migration<br /><br />Firmware Upgrade: Web browser upgrade (HTTP) and TFTP<br /><br />Port Mirroring: Traffic on a port can be mirrored to another port for analysis with a network analyzer or RMON probe Up to 4 source ports can be mirrored to one destination port. A single session is supported<br /><br />VLAN Mirroring: Traffic from a VLAN can be mirrored to a port for analysis with a network analyzer or RMON probe Up to 4 source VLANs can be mirrored to one destination port. A single session is supported<br /><br />Dynamic Host Configuration Protocol (Options 66 and 67): Dynamic Host Configuration Protocol options facilitate tighter control from a central point (DHCP server) to obtain IP address, auto-configuration (with configuration file download)<br /><br />Text-Editable Config Files: Config files can be edited with a text editor and downloaded to another switch, facilitating easier mass deployment<br /><br />Smartports: Simplified configuration of QoS and security capabilities<br /><br />Cloud Services: Support for FindIT Network Discovery Utility<br /><br />Localization: Localization of GUI and documentation into multiple languages<br /><br />Other Management: HTTP, RADIUS, port mirroring, TFTP upgrade, DHCP client, BOOTP, SNTP, ping, syslog</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Power Efficiency</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Energy Detect: Automatically turns off power on Gigabit Ethernet RJ-45 port when the switch detects a link down<br />Active mode is resumed without loss of any packets when the switch detects the link is back up<br /><br />Cable Length Detection: Adjusts the signal strength based on the cable length. Reduces the power consumption for cables shorter than 10 m</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">General Features</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Jumbo Frames: Frame sizes up to 10 KB supported on Gigabit interfaces<br /><br />MAC Table: Up to 8000 MAC addresses</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Discovery</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Link Layer Discovery Protocol (802.1ab) with LLDP-MED Extensions: Link Layer Discovery Protocol allows the switch to advertise its identification, configuration and capabilities to neighboring devices, which store the data in an MIB. LLDP-MED is an enhancement to LLDP that adds the extensions needed for IP phones<br /><br />Cisco Discovery Protocol: The switch advertises itself using the Cisco Discovery Protocol</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Power Consumption</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Power Savings Mode: Short reach plus Energy Detect<br /><br />Power Consumption Worst Case: 110V/0.513A/27.8W<br />220V/0.306A/28.3W<br /><br />Heat Dissipation (BTU/hr): 96.6</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Ports</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Total system ports: 26 Gigabit Ethernet<br />24 Gigabit Ethernet RJ-45 ports<br />2 Gigabit Ethernet combo mini-GBIC ports* (RJ-45 + SFP) <span class=\"specNote\" data-selenium=\"specNote\"><a class=\"specNoteLink js-popover-opener\" title=\"\" href=\"https://www.bhphotovideo.com/bnh/controller/home?O=productlist.jsp&amp;A=details&amp;Q=&amp;sku=813249&amp;is=REG&amp;fromDisList=y#specNote1\" data-trigger=\"hover\" data-container=\"body\" data-selenium=\"specNoteLink\" data-original-title=\"\"></a></span></td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Buttons</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Reset button</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Cabling Type</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">Unshielded twisted pair Category 5 or better for 10BASE-T/100BASE-TX; Unshielded twisted pair Category 5 Ethernet or better for 1000BASE-T</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">LEDs</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">System, Link/Act, Speed</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Flash</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">16 MB</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">CPU</td>\r\n<td class=\"specDetail fs18\" data-selenium=\"specDetail\">128 MB memory</td>\r\n</tr>\r\n<tr>\r\n<td class=\"specTopic fs18\" data-selenium=\"specTopic\">Packet Buffer Memory</td>\r\n<td