define(['jquery','underscore','mageUtils','Magento_Ui/js/modal/alert','Magento_Ui/js/lib/validation/validator','Magento_Ui/js/form/element/abstract','jquery/file-uploader'],function($,_,utils,uiAlert,validator,Element){'use strict';return Element.extend({defaults:{value:[],maxFileSize:false,isMultipleFiles:false,placeholderType:'document',allowedExtensions:false,previewTmpl:'ui/form/element/uploader/preview',dropZone:'[data-role=drop-zone]',isLoading:false,uploaderConfig:{dataType:'json',sequentialUploads:true,formData:{'form_key':window.FORM_KEY}},tracks:{isLoading:true}},initUploader:function(fileInput){this.$fileInput=fileInput;_.extend(this.uploaderConfig,{dropZone:$(fileInput).closest(this.dropZone),change:this.onFilesChoosed.bind(this),drop:this.onFilesChoosed.bind(this),add:this.onBeforeFileUpload.bind(this),done:this.onFileUploaded.bind(this),start:this.onLoadingStart.bind(this),stop:this.onLoadingStop.bind(this)});$(fileInput).fileupload(this.uploaderConfig);return this;},setInitialValue:function(){var value=this.getInitialValue();value=value.map(this.processFile,this);this.initialValue=value.slice();this.value(value);this.on('value',this.onUpdate.bind(this));this.isUseDefault(this.disabled());return this;},clear:function(){this.value.removeAll();return this;},hasData:function(){return!!this.value().length;},reset:function(){var value=this.initialValue.slice();this.value(value);return this;},addFile:function(file){file=this.processFile(file);this.isMultipleFiles?this.value.push(file):this.value([file]);return this;},getFile:function(fn){return _.find(this.value(),fn);},removeFile:function(file){this.value.remove(file);return this;},processFile:function(file){file.previewType=this.getFilePreviewType(file);this.observe.call(file,true,['previewWidth','previewHeight']);return file;},formatSize:function(bytes){var sizes=['Bytes','KB','MB','GB','TB'],i;if(bytes===0){return'0 Byte';}
i=window.parseInt(Math.floor(Math.log(bytes)/ Math.log(1024)));return Math.round(bytes / Math.pow(1024,i),2)+' '+sizes[i];},getFilePreview:function(file){return file.url;},getPreviewTmpl:function(){return this.previewTmpl;},isFileAllowed:function(file){var result;_.every([this.isExtensionAllowed(file),this.isSizeExceeded(file)],function(value){result=value;return value.passed;});return result;},isExtensionAllowed:function(file){return validator('validate-file-type',file.name,this.allowedExtensions);},getFilePreviewType:function(file){var type;if(!file.type){return'document';}
type=file.type.split('/')[0];return type!=='image'&&type!=='video'?'document':type;},isSizeExceeded:function(file){return validator('validate-max-size',file.size,this.maxFileSize);},notifyError:function(msg){uiAlert({content:msg});return this;},normalizeData:function(value){return utils.isEmpty(value)?[]:value;},hasChanged:function(){var value=this.value(),initial=this.initialValue;return!utils.equalArrays(value,initial);},onFilesChoosed:function(){},onBeforeFileUpload:function(e,data){var file=data.files[0],allowed=this.isFileAllowed(file),target=$(e.target);if(allowed.passed){target.on('fileuploadsend',function(event,postData){postData.data.append('param_name',this.paramName);}.bind(data));target.fileupload('process',data).done(function(){data.submit();});}else{this.notifyError(allowed.message);}},onFileUploaded:function(e,data){var file=data.result,error=file.error;error?this.notifyError(error):this.addFile(file);},onLoadingStart:function(){this.isLoading=true;},onLoadingStop:function(){this.isLoading=false;},onElementRender:function(fileInput){this.initUploader(fileInput);},onPreviewLoad:function(file,e){var img=e.currentTarget;file.previewWidth=img.naturalWidth;file.previewHeight=img.naturalHeight;},restoreToDefault:function(){var defaultValue=utils.copy(this.default);defaultValue.map(this.processFile,this);this.value(defaultValue);},setDifferedFromDefault:function(){var value=utils.copy(this.value());this.isDifferedFromDefault(!_.isEqual(value,this.default));}});});