define(['underscore','mage/translate','./column'],function(_,$t,Column){'use strict';return Column.extend({defaults:{headerTmpl:'ui/grid/columns/multiselect',bodyTmpl:'ui/grid/cells/multiselect',controlVisibility:false,sortable:false,draggable:false,menuVisible:false,excludeMode:false,allSelected:false,indetermine:false,preserveSelectionsOnFilter:false,disabled:[],selected:[],excluded:[],fieldClass:{'data-grid-checkbox-cell':true},actions:[{value:'selectAll',label:$t('Select All')},{value:'deselectAll',label:$t('Deselect All')},{value:'selectPage',label:$t('Select All on This Page')},{value:'deselectPage',label:$t('Deselect All on This Page')}],imports:{totalRecords:'${ $.provider }:data.totalRecords',rows:'${ $.provider }:data.items'},listens:{'${ $.provider }:params.filters':'onFilter',selected:'onSelectedChange',rows:'onRowsChange'},modules:{source:'${ $.provider }'}},initObservable:function(){this._super().observe(['disabled','selected','excluded','excludeMode','totalSelected','allSelected','indetermine','totalRecords','rows']);return this;},select:function(id,isIndex){this._setSelection(id,isIndex,true);return this;},deselect:function(id,isIndex){this._setSelection(id,isIndex,false);return this;},toggleSelect:function(id,isIndex){this._setSelection(id,isIndex,!this.isSelected(id,isIndex));return this;},isSelected:function(id,isIndex){id=this.getId(id,isIndex);return this.selected.contains(id);},_setSelection:function(id,isIndex,select){var selected=this.selected;id=this.getId(id,isIndex);if(!select&&this.isSelected(id)){selected.remove(id);}else if(select){selected.push(id);}
return this;},selectAll:function(){this.excludeMode(true);this.clearExcluded().selectPage();return this;},deselectAll:function(){this.excludeMode(false);this.clearExcluded();this.selected.removeAll();return this;},toggleSelectAll:function(){this.allSelected()?this.deselectAll():this.selectAll();return this;},selectPage:function(){var selected=_.union(this.selected(),this.getIds());selected=_.difference(selected,this.disabled());this.selected(selected);return this;},deselectPage:function(){var pageIds=this.getIds();this.selected.remove(function(value){return!!~pageIds.indexOf(value);});return this;},clearExcluded:function(){this.excluded.removeAll();return this;},getIds:function(exclude){var items=this.rows(),ids=_.pluck(items,this.indexField);return exclude?_.difference(ids,this.excluded()):ids;},getId:function(id,isIndex){var record=this.rows()[id];if(isIndex&&record){id=record[this.indexField];}
return id;},updateExcluded:function(selected){var excluded=this.excluded(),fromPage=_.difference(this.getIds(),selected);excluded=_.union(excluded,fromPage);excluded=_.difference(excluded,selected);this.excluded(excluded);return this;},countSelected:function(){var total=this.totalRecords(),excluded=this.excluded().length,selected=this.selected().length;if(this.excludeMode()){selected=total-excluded;}
this.totalSelected(selected);return this;},getPageSelections:function(){var ids=this.getIds();return this.selected.filter(function(id){return _.contains(ids,id);});},getSelections:function(){return{excluded:this.excluded(),selected:this.selected(),total:this.totalSelected(),excludeMode:this.excludeMode(),params:this.getFiltering()};},getFiltering:function(){var source=this.source(),keys=['filters','search','namespace'];if(!source){return{};}
return _.pick(source.get('params'),keys);},isActionRelevant:function(actionId){var pageIds=this.getIds().length,multiplePages=pageIds<this.totalRecords(),relevant=true;switch(actionId){case'selectPage':relevant=multiplePages&&!this.isPageSelected(true);break;case'deselectPage':relevant=multiplePages&&this.isPageSelected();break;case'selectAll':relevant=!this.allSelected();break;case'deselectAll':relevant=this.totalSelected()>0;}
return relevant;},isPageSelected:function(all){var pageIds=this.getIds(),selected=this.selected(),excluded=this.excluded(),iterator=all?'every':'some';if(this.allSelected()){return true;}
if(this.excludeMode()){return pageIds[iterator](function(id){return!~excluded.indexOf(id);});}
return pageIds[iterator](function(id){return!!~selected.indexOf(id);});},updateState:function(){var selected=this.selected().length,excluded=this.excluded().length,totalSelected=this.totalSelected(),totalRecords=this.totalRecords(),allSelected=totalRecords&&totalSelected===totalRecords;if(this.excludeMode()){if(excluded===totalRecords&&!this.preserveSelectionsOnFilter){this.deselectAll();}}else if(totalRecords&&selected===totalRecords&&!this.preserveSelectionsOnFilter){this.selectAll();}
this.allSelected(allSelected);this.indetermine(totalSelected&&!allSelected);return this;},hasFieldAction:function(){return false;},onSelectedChange:function(selected){this.updateExcluded(selected).countSelected().updateState();},onRowsChange:function(){var newSelections;if(this.excludeMode()){newSelections=_.union(this.getIds(true),this.selected());this.selected(newSelections);}},onFilter:function(){if(!this.preserveSelectionsOnFilter){this.deselectAll();}}});});