define(['underscore','jquery','text!mage/multiselect.html','Magento_Ui/js/modal/alert','jquery/ui','jquery/editableMultiselect/js/jquery.multiselect'],function(_,$,searchTemplate,alert){'use strict';$.widget('mage.multiselect2',{options:{mselectContainer:'section.mselect-list',mselectItemsWrapperClass:'mselect-items-wrapper',mselectCheckedClass:'mselect-checked',containerClass:'paginated',searchInputClass:'admin__action-multiselect-search',selectedItemsCountClass:'admin__action-multiselect-items-selected',currentPage:1,lastAppendValue:0,updateDelay:1000,optionsLoaded:false},_create:function(){$.fn.multiselect.call(this.element,this.options);},_init:function(){this.domElement=this.element.get(0);this.$container=$(this.options.mselectContainer);this.$wrapper=this.$container.find('.'+this.options.mselectItemsWrapperClass);this.$item=this.$wrapper.find('div').first();this.selectedValues=[];this.values={};this.$container.addClass(this.options.containerClass).prepend(searchTemplate);this.$input=this.$container.find('.'+this.options.searchInputClass);this.$selectedCounter=this.$container.find('.'+this.options.selectedItemsCountClass);this.filter='';if(this.domElement.options.length){this._setLastAppendOption(this.domElement.options[this.domElement.options.length-1].value);}
this._initElement();this._events();},_initElement:function(){this.element.empty();_.each(this.options.selectedValues,function(value){this._createSelectedOption({value:value,label:value});},this);},_events:function(){var onKeyUp=_.debounce(this.onKeyUp,this.options.updateDelay);_.bindAll(this,'onScroll','onCheck','onOptionsChange');this.$wrapper.on('scroll',this.onScroll);this.$wrapper.on('change.mselectCheck','[type=checkbox]',this.onCheck);this.$input.on('keyup',_.bind(onKeyUp,this));this.element.on('change.hiddenSelect',this.onOptionsChange);},onScroll:function(){var height=this.$wrapper.height(),scrollHeight=this.$wrapper.prop('scrollHeight'),scrollTop=Math.ceil(this.$wrapper.prop('scrollTop'));if(!this.options.optionsLoaded&&scrollHeight-height<=scrollTop){this.loadOptions();}},onKeyUp:function(){if(this.getSearchCriteria()===this.filter){return false;}
this.setFilter();this.clearMultiselectOptions();this.setCurrentPage(0);this.loadOptions();},onOptionsChange:function(){this.selectedValues=_.map(this.domElement.options,function(option){this.values[option.value]=true;return option.value;},this);this._updateSelectedCounter();},onCheck:function(event){var checkbox=event.target,option={value:checkbox.value,label:$(checkbox).parent('label').text()};checkbox.checked?this._createSelectedOption(option):this._removeSelectedOption(option);event.stopPropagation();},onError:function(message){alert({content:message});},setFilter:function(){this.filter=this.getSearchCriteria()||'';},getSearchCriteria:function(){return $.trim(this.$input.val());},loadOptions:function(){var nextPage=this.getCurrentPage()+1;this.$wrapper.trigger('processStart');this.$input.prop('disabled',true);$.get(this.options.nextPageUrl,{p:nextPage,s:this.filter}).done(function(response){if(response.success){this.appendOptions(response.result);this.setCurrentPage(nextPage);}else{this.onError(response.errorMessage);}}.bind(this)).always(function(){this.$wrapper.trigger('processStop');this.$input.prop('disabled',false);if(this.filter){this.$input.focus();}}.bind(this));},appendOptions:function(options){var divOptions=[];if(!options.length){return false;}
if(this.isOptionsLoaded(options)){return;}
options.forEach(function(option){if(!this.values[option.value]){this.values[option.value]=true;option.selected=this._isOptionSelected(option);divOptions.push(this._createMultiSelectOption(option));this._setLastAppendOption(option.value);}},this);this.$wrapper.append(divOptions);},clearMultiselectOptions:function(){this._setLastAppendOption(0);this.values={};this.$wrapper.empty();},isOptionsLoaded:function(options){this.options.optionsLoaded=this.options.lastAppendValue===options[options.length-1].value;return this.options.optionsLoaded;},setCurrentPage:function(page){this.options.currentPage=page;},getCurrentPage:function(){return this.options.currentPage;},_createSelectedOption:function(option){var selectOption=new Option(option.label,option.value,false,true);this.element.append(selectOption);this.selectedValues.push(option.value);this._updateSelectedCounter();return selectOption;},_removeSelectedOption:function(option){var unselectedOption=_.findWhere(this.domElement.options,{value:option.value});if(!_.isUndefined(unselectedOption)){this.domElement.remove(unselectedOption.index);this.selectedValues.splice(_.indexOf(this.selectedValues,option.value),1);this._updateSelectedCounter();}
return unselectedOption;},_createMultiSelectOption:function(option){var item=this.$item.clone(),checkbox=item.find('input'),isSelected=!!option.selected;checkbox.val(option.value).prop('checked',isSelected).toggleClass(this.options.mselectCheckedClass,isSelected);item.find('label > span').text(option.label);return item;},_isOptionSelected:function(option){return!!~this.selectedValues.indexOf(option.value);},_setLastAppendOption:function(value){this.options.lastAppendValue=value;},_updateSelectedCounter:function(){this.$selectedCounter.text(this.selectedValues.length);}});return $.mage.multiselect2;});