define(['ko','Magento_Ui/js/lib/view/utils/async','underscore','uiRegistry','uiClass'],function(ko,$,_,registry,Class){'use strict';var isTouchDevice=typeof document.ontouchstart!=='undefined',transformProp;transformProp=(function(){var style=document.body.style,base='Transform',vendors=['webkit','moz','ms','o'],vi=vendors.length,property;if(typeof style.transform!='undefined'){return'transform';}
while(vi--){property=vendors[vi]+base;if(typeof style[property]!='undefined'){return property;}}})();function getTouch(e){return e.touches?e.touches[0]:e;}
function locate(elem,x,y){var value='translate('+x+'px,'+y+'px)';elem.style[transformProp]=value;}
function isInside(x,y,area){return(area&&x>=area.left&&x<=area.right&&y>=area.top&&y<=area.bottom);}
function distance(x1,y1,x2,y2){var dx=x2-x1,dy=y2-y1;dx*=dx;dy*=dy;return Math.sqrt(dx+dy);}
function getModel(elem){return ko.dataFor(elem);}
function compareCols(c1,c2){return c1.cellIndex===c2.cellIndex;}
return Class.extend({defaults:{rootSelector:'${ $.columnsProvider }:.admin__data-grid-wrap',tableSelector:'${ $.rootSelector } -> table.data-grid',mainTableSelector:'[data-role="grid"]',columnSelector:'${ $.tableSelector } thead tr th',noSelectClass:'_no-select',hiddenClass:'_hidden',fixedX:false,fixedY:true,minDistance:2,columns:[]},initialize:function(){_.bindAll(this,'initTable','initColumn','removeColumn','onMouseMove','onMouseUp','onMouseDown');this.$body=$('body');this._super().initListeners();$.async(this.tableSelector,this.initTable);$.async(this.columnSelector,this.initColumn);return this;},initListeners:function(){if(isTouchDevice){$(document).on({touchmove:this.onMouseMove,touchend:this.onMouseUp,touchleave:this.onMouseUp});}else{$(document).on({mousemove:this.onMouseMove,mouseup:this.onMouseUp});}
return this;},initTable:function(table){this.table=$(table).is(this.mainTableSelector)?table:this.table;$(table).addClass('data-grid-draggable');return this;},initColumn:function(column){var model=getModel(column),eventName;if(!model||!model.draggable){return this;}
if(!ko.es5.isTracked(model,'dragover')){model.track('dragover');}
this.columns.push(column);$(column).bindings({css:{'_dragover-left':ko.computed(function(){return model.dragover==='right';}),'_dragover-right':ko.computed(function(){return model.dragover==='left';})}});eventName=isTouchDevice?'touchstart':'mousedown';$(column).on(eventName,this.onMouseDown);$.async.remove(column,this.removeColumn);return this;},removeColumn:function(column){var columns=this.columns,index=columns.indexOf(column);if(~index){columns.splice(index,1);}
return this;},_getColumnIndex:function(elem){return _.toArray(elem.parentNode.cells).indexOf(elem);},_cacheCoords:function(){var container=this.table.getBoundingClientRect(),bodyRect=document.body.getBoundingClientRect(),grabbed=this.grabbed,dragElem=grabbed.elem,cells=_.toArray(dragElem.parentNode.cells),rect;this.coords=this.columns.map(function(column){var data,colIndex=_.findIndex(cells,function(cell){return compareCols(cell,column);});rect=column.getBoundingClientRect();data={index:colIndex,target:column,orig:rect,left:rect.left-bodyRect.left,right:rect.right-bodyRect.left,top:rect.top-bodyRect.top,bottom:container.bottom-bodyRect.top};if(column===dragElem){this.dragArea=data;grabbed.shiftX=rect.left-grabbed.x;grabbed.shiftY=rect.top-grabbed.y;}
return data;},this);return this;},_cloneTable:function(elem){var clone=this.table.cloneNode(true),columnIndex=this._getColumnIndex(elem),headRow=clone.tHead.firstElementChild,headCells=_.toArray(headRow.cells),tableBody=clone.tBodies[0],bodyRows=_.toArray(tableBody.children),origTrs=this.table.tBodies[0].children;clone.style.width=elem.offsetWidth+'px';headCells.forEach(function(th,index){if(index!==columnIndex){headRow.removeChild(th);}});headRow.cells[0].style.height=elem.offsetHeight+'px';bodyRows.forEach(function(row,rowIndex){var cells=row.cells,cell;if(cells.length!==headCells.length){tableBody.removeChild(row);return;}
cell=row.cells[columnIndex].cloneNode(true);while(row.firstElementChild){row.removeChild(row.firstElementChild);}
cell.style.height=origTrs[rowIndex].cells[columnIndex].offsetHeight+'px';row.appendChild(cell);});this.dragTable=clone;$(clone).addClass('_dragging-copy').appendTo('body');return this;},_getDropArea:function(x,y){return _.find(this.coords,function(area){return isInside(x,y,area);});},_updateAreas:function(x,y){var leavedArea=this.dropArea,area=this.dropArea=this._getDropArea(x,y);if(leavedArea){this.dragleave(leavedArea);}
if(area&&!compareCols(area.target,this.dragArea.target)){this.dragenter(area);}},grab:function(x,y,elem){this.initDrag=true;this.grabbed={x:x,y:y,elem:elem};this.$body.addClass(this.noSelectClass);},dragstart:function(elem){this.initDrag=false;this.dropArea=false;this.dragging=true;getModel(elem).dragging(true);this._cacheCoords()._cloneTable(elem);},drag:function(x,y){var grabbed=this.grabbed,dragArea=this.dragArea,posX=x+grabbed.shiftX,posY=y+grabbed.shiftY;if(this.fixedX){x=dragArea.left;posX=dragArea.orig.left;}
if(this.fixedY){y=dragArea.top;posY=dragArea.orig.top;}
locate(this.dragTable,posX,posY);if(!isInside(x,y,this.dropArea)){this._updateAreas(x,y);}},dragenter:function(dropArea){var direction=this.dragArea.index<dropArea.index?'left':'right';getModel(dropArea.target).dragover=direction;},dragleave:function(dropArea){getModel(dropArea.target).dragover=false;},dragend:function(dragArea){var dropArea=this.dropArea,dragElem=dragArea.target;this.dragging=false;document.body.removeChild(this.dragTable);getModel(dragElem).dragging(false);if(dropArea&&!compareCols(dropArea.target,dragElem)){this.drop(dropArea,dragArea);}},drop:function(dropArea,dragArea){var dropModel=getModel(dropArea.target),dragModel=getModel(dragArea.target);getModel(this.table).insertChild(dragModel,dropModel);dropModel.dragover=false;},onMouseMove:function(e){var grab=this.grabbed,touch=getTouch(e),x=touch.pageX,y=touch.pageY;if(this.initDrag||this.dragging){e.preventDefault();}
if(this.initDrag&&distance(x,y,grab.x,grab.y)>=this.minDistance){this.dragstart(grab.elem);}
if(this.dragging){this.drag(x,y);}},onMouseUp:function(){if(this.initDrag||this.dragging){this.initDrag=false;this.$body.removeClass(this.noSelectClass);}
if(this.dragging){this.dragend(this.dragArea);}},onMouseDown:function(e){var touch=getTouch(e);this.grab(touch.pageX,touch.pageY,e.currentTarget);}});});